/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka.data;

import com.github.benmanes.caffeine.cache.LoadingCache;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Closeable;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.WakeupException;
import org.locationtech.geomesa.index.metadata.GeoMesaMetadata;
import org.locationtech.geomesa.index.metadata.KeyValueStoreMetadata;
import org.locationtech.geomesa.index.metadata.TableBasedMetadata;
import org.locationtech.geomesa.index.metadata.package;
import org.locationtech.geomesa.kafka.data.KafkaDataStore;
import org.locationtech.geomesa.kafka.data.KafkaDataStore$;
import org.locationtech.geomesa.kafka.data.KafkaMetadata$;
import org.locationtech.geomesa.kafka.data.KafkaMetadata$KeyBytes$;
import org.locationtech.geomesa.kafka.data.package;
import org.locationtech.geomesa.kafka.versions.KafkaAdminVersions$;
import org.locationtech.geomesa.kafka.versions.KafkaConsumerVersions$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.concurrent.CachedThreadPool$;
import org.locationtech.geomesa.utils.concurrent.LazyCloseable;
import org.locationtech.geomesa.utils.io.IsCloseable;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\r\u001de\u0001B%K\u0001UC\u0001\"\u001e\u0001\u0003\u0006\u0004%\tA\u001e\u0005\n\u0003/\u0001!\u0011!Q\u0001\n]D!\"!\u0007\u0001\u0005\u000b\u0007I\u0011AA\u000e\u0011)\t\u0019\u0004\u0001B\u0001B\u0003%\u0011Q\u0004\u0005\b\u0003k\u0001A\u0011AA\u001c\u0011%\t\t\u0005\u0001b\u0001\n\u0013\t\u0019\u0005\u0003\u0005\u0002R\u0001\u0001\u000b\u0011BA#\u0011%\t\u0019\u0006\u0001b\u0001\n\u0013\t)\u0006\u0003\u0005\u0003\u0006\u0002\u0001\u000b\u0011BA,\u0011\u001d\u0011\t\u000f\u0001C)\u0005GDqA!:\u0001\t\u0013\u00119\u000fC\u0004\u0003z\u0002!IAa?\t\u000f\t}\b\u0001\"\u0015\u00032\"91\u0011\u0001\u0001\u0005R\r\r\u0001bBB\f\u0001\u0011E3\u0011\u0004\u0005\b\u0007K\u0001A\u0011KB\u0014\u0011\u001d\u0019i\u0003\u0001C)\u0007_Aqa!\u000e\u0001\t#\u001a9\u0004C\u0004\u0003^\u0002!\tE!-\t\u000f\rm\u0002\u0001\"\u0003\u0004>\u00191\u00111\u000e\u0001\u0005\u0003[Bq!!\u000e\u0016\t\u0003\t\t\tC\u0005\u0002\u0004V\u0011\r\u0011\"\u0003\u0002\u0006\"A\u0011QR\u000b!\u0002\u0013\t9\tC\u0005\u0002\u0010V\u0011\r\u0011\"\u0003\u0002\u0012\"A\u0011qT\u000b!\u0002\u0013\t\u0019\nC\u0005\u0002\"V\u0011\r\u0011\"\u0003\u0002$\"A!qJ\u000b!\u0002\u0013\t)\u000bC\u0005\u0003RU\u0011\r\u0011\"\u0003\u0003T!A!1L\u000b!\u0002\u0013\u0011)\u0006C\u0005\u0003^U\u0011\r\u0011\"\u0003\u0003`!A!QN\u000b!\u0002\u0013\u0011\t\u0007C\u0005\u0002TU\u0011\r\u0011\"\u0003\u0003p!A!QQ\u000b!\u0002\u0013\u0011\t\bC\u0006\u0003\bV\u0001\r\u00111A\u0005\n\t%\u0005b\u0003BN+\u0001\u0007\t\u0019!C\u0005\u0005;C1B!'\u0016\u0001\u0004\u0005\t\u0015)\u0003\u0003\f\"9!qV\u000b\u0005B\tE\u0006b\u0002BZ+\u0011%!\u0011\u0017\u0005\b\u0005k+B\u0011\u0001B\\\u0011\u001d\u0011\u0019-\u0006C\u0001\u0005\u000bDqAa6\u0016\t\u0003\u0011I\u000eC\u0004\u0003^V!\tE!-\t\u000f\t}W\u0003\"\u0003\u00032\u001a1\u0011Q\u0017\u0001E\u0003oC!\"!6.\u0005+\u0007I\u0011AAl\u0011)\t)/\fB\tB\u0003%\u0011\u0011\u001c\u0005\b\u0003kiC\u0011AAt\u0011\u001d\tY/\fC!\u0003[Dq!!>.\t\u0003\n9\u0010C\u0005\u0003\u00045\n\t\u0011\"\u0001\u0003\u0006!I!\u0011B\u0017\u0012\u0002\u0013\u0005!1\u0002\u0005\n\u0005Ci\u0013\u0011!C!\u0003\u000bC\u0011Ba\t.\u0003\u0003%\tA!\n\t\u0013\t\u001dR&!A\u0005\u0002\t%\u0002\"\u0003B\u0018[\u0005\u0005I\u0011\tB\u0019\u0011%\u0011y$LA\u0001\n\u0003\u0011\t\u0005C\u0005\u0003F5\n\t\u0011\"\u0011\u0003H!I!1J\u0017\u0002\u0002\u0013\u0005#QJ\u0004\n\u0007#\u0002\u0011\u0011!E\u0005\u0007'2\u0011\"!.\u0001\u0003\u0003EIa!\u0016\t\u000f\u0005UR\b\"\u0001\u0004h!I!1J\u001f\u0002\u0002\u0013\u0015#Q\n\u0005\n\u0007Sj\u0014\u0011!CA\u0007WB\u0011ba\u001c>\u0003\u0003%\ti!\u001d\b\u000f\r]$\n#\u0001\u0004z\u00191\u0011J\u0013E\u0001\u0007wBq!!\u000eD\t\u0003\u0019i\bC\u0005\u0004\u0000\r\u0013\r\u0011\"\u0003\u0002\u0006\"A1\u0011Q\"!\u0002\u0013\t9\tC\u0005\u0004\u0004\u000e\u0013\r\u0011\"\u0003\u0002\u0006\"A1QQ\"!\u0002\u0013\t9IA\u0007LC\u001a\\\u0017-T3uC\u0012\fG/\u0019\u0006\u0003\u00172\u000bA\u0001Z1uC*\u0011QJT\u0001\u0006W\u000647.\u0019\u0006\u0003\u001fB\u000bqaZ3p[\u0016\u001c\u0018M\u0003\u0002R%\u0006aAn\\2bi&|g\u000e^3dQ*\t1+A\u0002pe\u001e\u001c\u0001!\u0006\u0002WSN\u0019\u0001aV0\u0011\u0005akV\"A-\u000b\u0005i[\u0016\u0001\u00027b]\u001eT\u0011\u0001X\u0001\u0005U\u00064\u0018-\u0003\u0002_3\n1qJ\u00196fGR\u00042\u0001Y3h\u001b\u0005\t'B\u00012d\u0003!iW\r^1eCR\f'B\u00013O\u0003\u0015Ig\u000eZ3y\u0013\t1\u0017MA\u000bLKf4\u0016\r\\;f'R|'/Z'fi\u0006$\u0017\r^1\u0011\u0005!LG\u0002\u0001\u0003\u0006U\u0002\u0011\ra\u001b\u0002\u0002)F\u0011AN\u001d\t\u0003[Bl\u0011A\u001c\u0006\u0002_\u0006)1oY1mC&\u0011\u0011O\u001c\u0002\b\u001d>$\b.\u001b8h!\ti7/\u0003\u0002u]\n\u0019\u0011I\\=\u0002\r\r|gNZ5h+\u00059\bc\u0001=\u0002\u00129\u0019\u00110!\u0004\u000f\u0007i\fYAD\u0002|\u0003\u0013q1\u0001`A\u0004\u001d\ri\u0018Q\u0001\b\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005A+\u0001\u0004=e>|GOP\u0005\u0002'&\u0011\u0011KU\u0005\u0003\u001fBK!!\u0014(\n\u0005-c\u0015bAA\b\u0015\u0006q1*\u00194lC\u0012\u000bG/Y*u_J,\u0017\u0002BA\n\u0003+\u0011AcS1gW\u0006$\u0015\r^1Ti>\u0014XmQ8oM&<'bAA\b\u0015\u000691m\u001c8gS\u001e\u0004\u0013AC:fe&\fG.\u001b>feV\u0011\u0011Q\u0004\t\u0006\u0003?\tic\u001a\b\u0005\u0003C\tIC\u0004\u0003\u0002$\u0005\u001dbbA>\u0002&%\u0011AMT\u0005\u0003E\u000eL1!a\u000bb\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\f\u00022\t\u0011R*\u001a;bI\u0006$\u0018mU3sS\u0006d\u0017N_3s\u0015\r\tY#Y\u0001\fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0007\u0003s\ti$a\u0010\u0011\t\u0005m\u0002aZ\u0007\u0002\u0015\")Q/\u0002a\u0001o\"9\u0011\u0011D\u0003A\u0002\u0005u\u0011\u0001\u00039s_\u0012,8-\u001a:\u0016\u0005\u0005\u0015\u0003\u0003BA$\u0003\u0017rA!a\u000f\u0002J%\u0019\u00111\u0006&\n\t\u00055\u0013q\n\u0002\r\u0019\u0006T\u0018\u0010\u0015:pIV\u001cWM\u001d\u0006\u0004\u0003WQ\u0015!\u00039s_\u0012,8-\u001a:!\u0003!\u0019wN\\:v[\u0016\u0014XCAA,!\u0019\tI&a\u0019\u0002h5\u0011\u00111\f\u0006\u0005\u0003;\ny&\u0001\u0006d_:\u001cWO\u001d:f]RT1!!\u0019O\u0003\u0015)H/\u001b7t\u0013\u0011\t)'a\u0017\u0003\u001b1\u000b'0_\"m_N,\u0017M\u00197f!\r\tI'F\u0007\u0002\u0001\tAAk\u001c9jG6\u000b\u0007o\u0005\u0004\u0016/\u0006=\u0014Q\u000f\t\u00041\u0006E\u0014bAA:3\nA!+\u001e8oC\ndW\r\u0005\u0003\u0002x\u0005uTBAA=\u0015\r\tYhW\u0001\u0003S>LA!a \u0002z\tI1\t\\8tK\u0006\u0014G.\u001a\u000b\u0003\u0003O\nqa\u001a:pkBLE-\u0006\u0002\u0002\bB\u0019\u0001,!#\n\u0007\u0005-\u0015L\u0001\u0004TiJLgnZ\u0001\tOJ|W\u000f]%eA\u0005!\u0001o\u001c7m+\t\t\u0019\n\u0005\u0003\u0002\u0016\u0006mUBAAL\u0015\r\tIjW\u0001\u0005i&lW-\u0003\u0003\u0002\u001e\u0006]%\u0001\u0003#ve\u0006$\u0018n\u001c8\u0002\u000bA|G\u000e\u001c\u0011\u0002\u000bM$\u0018\r^3\u0016\u0005\u0005\u0015\u0006\u0003CAT\u0003_\u000b\u0019,!7\u000e\u0005\u0005%&\u0002BA/\u0003WS1!!,\\\u0003\u0011)H/\u001b7\n\t\u0005E\u0016\u0011\u0016\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bcAA5[\tA1*Z=CsR,7oE\u0004.\u0003s\u000by,!2\u0011\u00075\fY,C\u0002\u0002>:\u0014a!\u00118z%\u00164\u0007cA7\u0002B&\u0019\u00111\u00198\u0003\u000fA\u0013x\u000eZ;diB!\u0011qYAh\u001d\u0011\tI-!4\u000f\u0007y\fY-C\u0001p\u0013\r\tYC\\\u0005\u0005\u0003#\f\u0019N\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0002,9\fQAY=uKN,\"!!7\u0011\u000b5\fY.a8\n\u0007\u0005ugNA\u0003BeJ\f\u0017\u0010E\u0002n\u0003CL1!a9o\u0005\u0011\u0011\u0015\u0010^3\u0002\r\tLH/Z:!)\u0011\t\u0019,!;\t\u000f\u0005U\u0007\u00071\u0001\u0002Z\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002pB\u0019Q.!=\n\u0007\u0005MhNA\u0002J]R\fa!Z9vC2\u001cH\u0003BA}\u0003\u007f\u00042!\\A~\u0013\r\tiP\u001c\u0002\b\u0005>|G.Z1o\u0011\u0019\u0011\tA\ra\u0001e\u0006\u0019qN\u00196\u0002\t\r|\u0007/\u001f\u000b\u0005\u0003g\u00139\u0001C\u0005\u0002VN\u0002\n\u00111\u0001\u0002Z\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B\u0007U\u0011\tINa\u0004,\u0005\tE\u0001\u0003\u0002B\n\u0005;i!A!\u0006\u000b\t\t]!\u0011D\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0007o\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005?\u0011)BA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&D\u0018\u0001\u00049s_\u0012,8\r^!sSRLXCAAx\u00039\u0001(o\u001c3vGR,E.Z7f]R$2A\u001dB\u0016\u0011%\u0011icNA\u0001\u0002\u0004\ty/A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005g\u0001RA!\u000e\u0003<Il!Aa\u000e\u000b\u0007\teb.\u0001\u0006d_2dWm\u0019;j_:LAA!\u0010\u00038\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tIPa\u0011\t\u0011\t5\u0012(!AA\u0002I\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011q\u0011B%\u0011%\u0011iCOA\u0001\u0002\u0004\ty/\u0001\u0005u_N#(/\u001b8h)\t\t9)\u0001\u0004ti\u0006$X\rI\u0001\tG>l\u0007\u000f\\3uKV\u0011!Q\u000b\t\u0005\u0003O\u00139&\u0003\u0003\u0003Z\u0005%&AD\"pk:$Hi\\<o\u0019\u0006$8\r[\u0001\nG>l\u0007\u000f\\3uK\u0002\naa\u00197pg\u0016$WC\u0001B1!\u0011\u0011\u0019G!\u001b\u000e\u0005\t\u0015$\u0002\u0002B4\u0003S\u000ba!\u0019;p[&\u001c\u0017\u0002\u0002B6\u0005K\u0012Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017aB2m_N,G\rI\u000b\u0003\u0005c\u0002\u0002Ba\u001d\u0003\u0002\u0006e\u0017\u0011\\\u0007\u0003\u0005kRA!a\u0015\u0003x)!!\u0011\u0010B>\u0003\u001d\u0019G.[3oiNT1!\u0014B?\u0015\r\u0011yHU\u0001\u0007CB\f7\r[3\n\t\t\r%Q\u000f\u0002\t\u0007>t7/^7fe\u0006I1m\u001c8tk6,'\u000fI\u0001\u0007MV$XO]3\u0016\u0005\t-\u0005\u0007\u0002BG\u0005+\u0003b!a*\u0003\u0010\nM\u0015\u0002\u0002BI\u0003S\u0013aAR;ukJ,\u0007c\u00015\u0003\u0016\u0012Q!qS\u0013\u0002\u0002\u0003\u0005)\u0011A6\u0003\u0007}#\u0013'A\u0004gkR,(/\u001a\u0011\u0002\u0015\u0019,H/\u001e:f?\u0012*\u0017\u000f\u0006\u0003\u0003 \n\u0015\u0006cA7\u0003\"&\u0019!1\u00158\u0003\tUs\u0017\u000e\u001e\u0005\n\u0005[!\u0013\u0011!a\u0001\u0005O\u0003DA!+\u0003.B1\u0011q\u0015BH\u0005W\u00032\u0001\u001bBW\t-\u00119J!*\u0002\u0002\u0003\u0005)\u0011A6\u0002\u0007I,h\u000e\u0006\u0002\u0003 \u0006iAm\\%oSRL\u0017\r\u001c'pC\u0012\f1aZ3u)\u0011\u0011ILa0\u0011\u000b5\u0014Y,!7\n\u0007\tufN\u0001\u0004PaRLwN\u001c\u0005\b\u0005\u0003D\u0003\u0019AAm\u0003\rYW-_\u0001\u0004C2dGC\u0001Bd!\u0019\u0011IM!4\u0003R6\u0011!1\u001a\u0006\u0005\u0005s\ty&\u0003\u0003\u0003P\n-'!E\"m_N,\u0017M\u00197f\u0013R,'/\u0019;peB9QNa5\u0002Z\u0006e\u0017b\u0001Bk]\n1A+\u001e9mKJ\na\u0001\u001d:fM&DH\u0003\u0002Bd\u00057DqAa6+\u0001\u0004\tI.A\u0003dY>\u001cX-A\bdY\u0016\fg.\u001e9D_:\u001cX/\\3s\u0003I\u0019\u0007.Z2l\u0013\u001a$\u0016M\u00197f\u000bbL7\u000f^:\u0016\u0005\u0005e\u0018!F2iK\u000e\\7i\\7qC\u000e$\u0018n\u001c8Q_2L7-\u001f\u000b\u0005\u0003s\u0014I\u000fC\u0004\u0003l.\u0001\rA!<\u0002\u000f-\u001cE.[3oiB!!q\u001eB{\u001b\t\u0011\tP\u0003\u0003\u0003t\n]\u0014!B1e[&t\u0017\u0002\u0002B|\u0005c\u00141\"\u00113nS:\u001cE.[3oi\u0006\u00192/\u001a;D_6\u0004\u0018m\u0019;j_:\u0004v\u000e\\5dsR!!q\u0014B\u007f\u0011\u001d\u0011Y\u000f\u0004a\u0001\u0005[\f1b\u0019:fCR,G+\u00192mK\u0006\t2M]3bi\u0016,U\u000e\u001d;z\u0005\u0006\u001c7.\u001e9\u0015\t\u0005e2Q\u0001\u0005\b\u0007\u000fq\u0001\u0019AB\u0005\u0003%!\u0018.\\3ti\u0006l\u0007\u000f\u0005\u0003\u0004\f\rMa\u0002BB\u0007\u0007\u001f\u0001\"A 8\n\u0007\rEa.\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0017\u001b)BC\u0002\u0004\u00129\fQa\u001e:ji\u0016$BAa(\u0004\u001c!91QD\bA\u0002\r}\u0011\u0001\u0002:poN\u0004b!a2\u0004\"\tE\u0017\u0002BB\u0012\u0003'\u00141aU3r\u0003\u0019!W\r\\3uKR!!qTB\u0015\u0011\u001d\u0019i\u0002\u0005a\u0001\u0007W\u0001b!a2\u0004\"\u0005e\u0017!C:dC:4\u0016\r\\;f)\u0011\u0011Il!\r\t\u000f\rM\u0012\u00031\u0001\u0002Z\u0006\u0019!o\\<\u0002\u0011M\u001c\u0017M\u001c*poN$BAa2\u0004:!9!q\u001b\nA\u0002\te\u0016!D1e[&t7\t\\5f]R|\u0005/\u0006\u0003\u0004@\r\rC\u0003BB!\u0007\u000f\u00022\u0001[B\"\t\u0019\u0019)\u0005\u0006b\u0001W\n\ta\u000bC\u0004\u0004JQ\u0001\raa\u0013\u0002\u0005\u0019t\u0007cB7\u0004N\t58\u0011I\u0005\u0004\u0007\u001fr'!\u0003$v]\u000e$\u0018n\u001c82\u0003!YU-\u001f\"zi\u0016\u001c\bcAA5{M)Qha\u0016\u0004dAA1\u0011LB0\u00033\f\u0019,\u0004\u0002\u0004\\)\u00191Q\f8\u0002\u000fI,h\u000e^5nK&!1\u0011MB.\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\t\u0005\u0003o\u001a)'\u0003\u0003\u0002R\u0006eDCAB*\u0003\u0015\t\u0007\u000f\u001d7z)\u0011\t\u0019l!\u001c\t\u000f\u0005U\u0007\t1\u0001\u0002Z\u00069QO\\1qa2LH\u0003\u0002B]\u0007gB\u0011b!\u001eB\u0003\u0003\u0005\r!a-\u0002\u0007a$\u0003'A\u0007LC\u001a\\\u0017-T3uC\u0012\fG/\u0019\t\u0004\u0003w\u00195cA\"\u0002:R\u00111\u0011P\u0001\u0014\u00072,\u0017M\\;q!>d\u0017nY=D_:4\u0017nZ\u0001\u0015\u00072,\u0017M\\;q!>d\u0017nY=D_:4\u0017n\u001a\u0011\u0002)\r{W\u000e]1di\u000ecW-\u00198vaB{G.[2z\u0003U\u0019u.\u001c9bGR\u001cE.Z1okB\u0004v\u000e\\5ds\u0002\u0002")
public class KafkaMetadata<T>
implements KeyValueStoreMetadata<T> {
    private volatile KafkaMetadata$KeyBytes$ KeyBytes$module;
    private final KafkaDataStore.KafkaDataStoreConfig config;
    private final package.MetadataSerializer<T> serializer;
    private final package.LazyProducer producer;
    private final LazyCloseable<TopicMap> consumer;
    private char typeNameSeparator;
    private AtomicBoolean org$locationtech$geomesa$index$metadata$TableBasedMetadata$$tableExists;
    private long org$locationtech$geomesa$index$metadata$TableBasedMetadata$$expiry;
    private LoadingCache<Tuple2<String, String>, Option<T>> org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataCache;
    private LoadingCache<Tuple2<String, String>, Seq<Tuple2<String, T>>> org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataScanCache;
    private DateTimeFormatter org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public byte[] encodeRow(String typeName, String key) {
        return KeyValueStoreMetadata.encodeRow$((KeyValueStoreMetadata)this, (String)typeName, (String)key);
    }

    public void write(String typeName, Seq<Tuple2<String, byte[]>> rows) {
        KeyValueStoreMetadata.write$((KeyValueStoreMetadata)this, (String)typeName, rows);
    }

    public void delete(String typeName, Seq<String> keys) {
        KeyValueStoreMetadata.delete$((KeyValueStoreMetadata)this, (String)typeName, keys);
    }

    public Option<byte[]> scanValue(String typeName, String key) {
        return KeyValueStoreMetadata.scanValue$((KeyValueStoreMetadata)this, (String)typeName, (String)key);
    }

    public CloseableIterator<Tuple2<String, byte[]>> scanValues(String typeName, String prefix) {
        return KeyValueStoreMetadata.scanValues$((KeyValueStoreMetadata)this, (String)typeName, (String)prefix);
    }

    public CloseableIterator<Tuple2<String, String>> scanKeys() {
        return KeyValueStoreMetadata.scanKeys$((KeyValueStoreMetadata)this);
    }

    public String scanValues$default$2() {
        return TableBasedMetadata.scanValues$default$2$((TableBasedMetadata)this);
    }

    public String[] getFeatureTypes() {
        return TableBasedMetadata.getFeatureTypes$((TableBasedMetadata)this);
    }

    public Option<T> read(String typeName, String key, boolean cache) {
        return TableBasedMetadata.read$((TableBasedMetadata)this, (String)typeName, (String)key, (boolean)cache);
    }

    public Seq<Tuple2<String, T>> scan(String typeName, String prefix, boolean cache) {
        return TableBasedMetadata.scan$((TableBasedMetadata)this, (String)typeName, (String)prefix, (boolean)cache);
    }

    public void insert(String typeName, String key, T value) {
        TableBasedMetadata.insert$((TableBasedMetadata)this, (String)typeName, (String)key, value);
    }

    public void insert(String typeName, scala.collection.immutable.Map<String, T> kvPairs) {
        TableBasedMetadata.insert$((TableBasedMetadata)this, (String)typeName, kvPairs);
    }

    public void invalidateCache(String typeName, String key) {
        TableBasedMetadata.invalidateCache$((TableBasedMetadata)this, (String)typeName, (String)key);
    }

    public void remove(String typeName, String key) {
        TableBasedMetadata.remove$((TableBasedMetadata)this, (String)typeName, (String)key);
    }

    public void remove(String typeName, Seq<String> keys) {
        TableBasedMetadata.remove$((TableBasedMetadata)this, (String)typeName, keys);
    }

    public void delete(String typeName) {
        TableBasedMetadata.delete$((TableBasedMetadata)this, (String)typeName);
    }

    public void backup(String typeName) {
        TableBasedMetadata.backup$((TableBasedMetadata)this, (String)typeName);
    }

    public void ensureTableExists() {
        TableBasedMetadata.ensureTableExists$((TableBasedMetadata)this);
    }

    public void resetCache() {
        TableBasedMetadata.resetCache$((TableBasedMetadata)this);
    }

    public boolean read$default$3() {
        return GeoMesaMetadata.read$default$3$((GeoMesaMetadata)this);
    }

    public T readRequired(String typeName, String key) {
        return (T)GeoMesaMetadata.readRequired$((GeoMesaMetadata)this, (String)typeName, (String)key);
    }

    public boolean scan$default$3() {
        return GeoMesaMetadata.scan$default$3$((GeoMesaMetadata)this);
    }

    private KafkaMetadata$KeyBytes$ KeyBytes() {
        if (this.KeyBytes$module == null) {
            this.KeyBytes$lzycompute$1();
        }
        return this.KeyBytes$module;
    }

    public char typeNameSeparator() {
        return this.typeNameSeparator;
    }

    public void org$locationtech$geomesa$index$metadata$KeyValueStoreMetadata$_setter_$typeNameSeparator_$eq(char x$1) {
        this.typeNameSeparator = x$1;
    }

    public AtomicBoolean org$locationtech$geomesa$index$metadata$TableBasedMetadata$$tableExists() {
        return this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$tableExists;
    }

    public long org$locationtech$geomesa$index$metadata$TableBasedMetadata$$expiry() {
        return this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$expiry;
    }

    public LoadingCache<Tuple2<String, String>, Option<T>> org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataCache() {
        return this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataCache;
    }

    public LoadingCache<Tuple2<String, String>, Seq<Tuple2<String, T>>> org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataScanCache() {
        return this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataScanCache;
    }

    private DateTimeFormatter org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter$lzycompute() {
        KafkaMetadata kafkaMetadata = this;
        synchronized (kafkaMetadata) {
            if (!this.bitmap$0) {
                this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter = TableBasedMetadata.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter$((TableBasedMetadata)this);
                this.bitmap$0 = true;
            }
        }
        return this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter;
    }

    public DateTimeFormatter org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter() {
        if (!this.bitmap$0) {
            return this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter$lzycompute();
        }
        return this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter;
    }

    public final void org$locationtech$geomesa$index$metadata$TableBasedMetadata$_setter_$org$locationtech$geomesa$index$metadata$TableBasedMetadata$$tableExists_$eq(AtomicBoolean x$1) {
        this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$tableExists = x$1;
    }

    public final void org$locationtech$geomesa$index$metadata$TableBasedMetadata$_setter_$org$locationtech$geomesa$index$metadata$TableBasedMetadata$$expiry_$eq(long x$1) {
        this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$expiry = x$1;
    }

    public final void org$locationtech$geomesa$index$metadata$TableBasedMetadata$_setter_$org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataCache_$eq(LoadingCache<Tuple2<String, String>, Option<T>> x$1) {
        this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataCache = x$1;
    }

    public final void org$locationtech$geomesa$index$metadata$TableBasedMetadata$_setter_$org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataScanCache_$eq(LoadingCache<Tuple2<String, String>, Seq<Tuple2<String, T>>> x$1) {
        this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataScanCache = x$1;
    }

    private Logger logger$lzycompute() {
        KafkaMetadata kafkaMetadata = this;
        synchronized (kafkaMetadata) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public KafkaDataStore.KafkaDataStoreConfig config() {
        return this.config;
    }

    public package.MetadataSerializer<T> serializer() {
        return this.serializer;
    }

    private package.LazyProducer producer() {
        return this.producer;
    }

    private LazyCloseable<TopicMap> consumer() {
        return this.consumer;
    }

    public boolean checkIfTableExists() {
        return BoxesRunTime.unboxToBoolean(this.org$locationtech$geomesa$kafka$data$KafkaMetadata$$adminClientOp((Function1 & Serializable)adminClient -> BoxesRunTime.boxToBoolean((boolean)KafkaMetadata.$anonfun$checkIfTableExists$1(this, adminClient))));
    }

    private boolean checkCompactionPolicy(AdminClient kClient) {
        Set<ConfigResource> cr = Collections.singleton(new ConfigResource(ConfigResource.Type.TOPIC, this.config().catalog()));
        Collection catalogConfigs = ((Map)kClient.describeConfigs(cr).all().get()).values();
        return ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(catalogConfigs).asScala()).exists((Function1 & Serializable)config -> BoxesRunTime.boxToBoolean((boolean)KafkaMetadata.$anonfun$checkCompactionPolicy$1(config)));
    }

    private void setCompactionPolicy(AdminClient kClient) {
        ConfigResource catalogResource = new ConfigResource(ConfigResource.Type.TOPIC, this.config().catalog());
        ConfigEntry catalogConfigEntry = new ConfigEntry(KafkaMetadata$.MODULE$.org$locationtech$geomesa$kafka$data$KafkaMetadata$$CleanupPolicyConfig(), KafkaMetadata$.MODULE$.org$locationtech$geomesa$kafka$data$KafkaMetadata$$CompactCleanupPolicy());
        Set<AlterConfigOp> alterOps = Collections.singleton(new AlterConfigOp(catalogConfigEntry, AlterConfigOp.OpType.SET));
        kClient.incrementalAlterConfigs(Collections.singletonMap(catalogResource, alterOps), new AlterConfigsOptions()).all().get();
    }

    public void createTable() {
        NewTopic newTopic = new NewTopic(this.config().catalog(), 1, (short)this.config().topics().replication()).configs(Collections.singletonMap(KafkaMetadata$.MODULE$.org$locationtech$geomesa$kafka$data$KafkaMetadata$$CleanupPolicyConfig(), KafkaMetadata$.MODULE$.org$locationtech$geomesa$kafka$data$KafkaMetadata$$CompactCleanupPolicy()));
        this.org$locationtech$geomesa$kafka$data$KafkaMetadata$$adminClientOp((Function1 & Serializable)x$1 -> (Void)x$1.createTopics(Collections.singletonList(newTopic)).all().get());
    }

    public KafkaMetadata<T> createEmptyBackup(String timestamp) {
        return new KafkaMetadata<T>(this.config().copy(new StringBuilder(5).append(this.config().catalog()).append("_").append(timestamp).append("_bak").toString(), this.config().copy$default$2(), this.config().copy$default$3(), this.config().copy$default$4(), this.config().copy$default$5(), this.config().copy$default$6(), this.config().copy$default$7(), this.config().copy$default$8(), this.config().copy$default$9(), this.config().copy$default$10(), this.config().copy$default$11(), this.config().copy$default$12(), this.config().copy$default$13(), this.config().copy$default$14(), this.config().copy$default$15()), this.serializer());
    }

    public void write(Seq<Tuple2<byte[], byte[]>> rows) {
        rows.foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                byte[] row = (byte[])tuple2._1();
                byte[] value = (byte[])tuple2._2();
                return ((Producer)this.producer().instance()).send(new ProducerRecord(this.config().catalog(), (Object)row, (Object)value));
            }
            throw new MatchError((Object)tuple2);
        });
        ((Producer)this.producer().instance()).flush();
    }

    public void delete(Seq<byte[]> rows) {
        rows.foreach((Function1 & Serializable)row -> ((Producer)this.producer().instance()).send(new ProducerRecord(this.config().catalog(), row, null)));
        ((Producer)this.producer().instance()).flush();
    }

    public Option<byte[]> scanValue(byte[] row) {
        return ((TopicMap)this.consumer().instance()).get(row);
    }

    public CloseableIterator<Tuple2<byte[], byte[]>> scanRows(Option<byte[]> prefix) {
        Option<byte[]> option = prefix;
        if (None$.MODULE$.equals(option)) {
            return ((TopicMap)this.consumer().instance()).all();
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            byte[] p = (byte[])some.value();
            return ((TopicMap)this.consumer().instance()).prefix(p);
        }
        throw new MatchError(option);
    }

    public void close() {
        package.CloseWithLogging$.MODULE$.apply((Object)new .colon.colon((Object)this.producer(), (List)new .colon.colon(this.consumer(), (List)Nil$.MODULE$)), (IsCloseable)IsCloseable$.MODULE$.iterableIsCloseable());
    }

    public <V> V org$locationtech$geomesa$kafka$data$KafkaMetadata$$adminClientOp(Function1<AdminClient, V> fn) {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.config().brokers());
        this.config().consumers().properties().foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return props.put(k, v);
            }
            throw new MatchError((Object)tuple2);
        });
        this.config().producers().properties().foreach((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return props.put(k, v);
            }
            throw new MatchError((Object)tuple2);
        });
        return (V)package.WithClose$.MODULE$.apply((Object)AdminClient.create((Properties)props), (Function1 & Serializable)admin -> fn.apply(admin), IsCloseable$.MODULE$.closeableIsCloseable());
    }

    private final void KeyBytes$lzycompute$1() {
        KafkaMetadata kafkaMetadata = this;
        synchronized (kafkaMetadata) {
            if (this.KeyBytes$module == null) {
                this.KeyBytes$module = new KafkaMetadata$KeyBytes$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkIfTableExists$1(KafkaMetadata $this, AdminClient adminClient) {
        boolean exists;
        block0: {
            exists = ((Set)adminClient.listTopics().names().get()).contains($this.config().catalog());
            if (!exists || $this.checkCompactionPolicy(adminClient)) break block0;
            $this.setCompactionPolicy(adminClient);
        }
        return exists;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$checkCompactionPolicy$1(Config config) {
        if (config.get(KafkaMetadata$.MODULE$.org$locationtech$geomesa$kafka$data$KafkaMetadata$$CleanupPolicyConfig()) == null) return false;
        String string = config.get(KafkaMetadata$.MODULE$.org$locationtech$geomesa$kafka$data$KafkaMetadata$$CleanupPolicyConfig()).value();
        String string2 = KafkaMetadata$.MODULE$.org$locationtech$geomesa$kafka$data$KafkaMetadata$$CompactCleanupPolicy();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public KafkaMetadata(KafkaDataStore.KafkaDataStoreConfig config, package.MetadataSerializer<T> serializer) {
        this.config = config;
        this.serializer = serializer;
        GeoMesaMetadata.$init$((GeoMesaMetadata)this);
        LazyLogging.$init$((LazyLogging)this);
        TableBasedMetadata.$init$((TableBasedMetadata)this);
        KeyValueStoreMetadata.$init$((KeyValueStoreMetadata)this);
        this.producer = new package.LazyProducer((Function0<Producer<byte[], byte[]>>)(Function0 & Serializable)() -> KafkaDataStore$.MODULE$.producer(this.config().brokers(), this.config().producers().properties()));
        this.consumer = new LazyCloseable((Function0 & Serializable)() -> new TopicMap(), IsCloseable$.MODULE$.closeableIsCloseable());
        Statics.releaseFence();
    }

    private class KeyBytes
    implements Product,
    Serializable {
        private final byte[] bytes;
        public final /* synthetic */ KafkaMetadata $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public byte[] bytes() {
            return this.bytes;
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes());
        }

        public boolean equals(Object obj) {
            Object object = obj;
            if (object instanceof KeyBytes && ((KeyBytes)object).org$locationtech$geomesa$kafka$data$KafkaMetadata$KeyBytes$$$outer() == this.org$locationtech$geomesa$kafka$data$KafkaMetadata$KeyBytes$$$outer()) {
                KeyBytes keyBytes = (KeyBytes)object;
                byte[] other = keyBytes.bytes();
                return Arrays.equals(this.bytes(), other);
            }
            return false;
        }

        public KeyBytes copy(byte[] bytes) {
            return new KeyBytes(this.org$locationtech$geomesa$kafka$data$KafkaMetadata$KeyBytes$$$outer(), bytes);
        }

        public byte[] copy$default$1() {
            return this.bytes();
        }

        public String productPrefix() {
            return "KeyBytes";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.bytes();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof KeyBytes;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "bytes";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public /* synthetic */ KafkaMetadata org$locationtech$geomesa$kafka$data$KafkaMetadata$KeyBytes$$$outer() {
            return this.$outer;
        }

        public KeyBytes(KafkaMetadata $outer, byte[] bytes) {
            this.bytes = bytes;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    private class TopicMap
    implements Runnable,
    Closeable {
        private final String groupId;
        private final Duration poll;
        private final ConcurrentHashMap<KeyBytes, byte[]> state;
        private final CountDownLatch complete;
        private final AtomicBoolean closed;
        private final Consumer<byte[], byte[]> consumer;
        private Future<?> future;

        private String groupId() {
            return this.groupId;
        }

        private Duration poll() {
            return this.poll;
        }

        private ConcurrentHashMap<KeyBytes, byte[]> state() {
            return this.state;
        }

        private CountDownLatch complete() {
            return this.complete;
        }

        private AtomicBoolean closed() {
            return this.closed;
        }

        private Consumer<byte[], byte[]> consumer() {
            return this.consumer;
        }

        private Future<?> future() {
            return this.future;
        }

        private void future_$eq(Future<?> x$1) {
            this.future = x$1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                boolean interrupted = Thread.currentThread().isInterrupted();
                while (!interrupted) {
                    try {
                        ConsumerRecords result = KafkaConsumerVersions$.MODULE$.poll(this.consumer(), this.poll());
                        if (result.isEmpty()) continue;
                        for (ConsumerRecord r : result) {
                            byte[] v = (byte[])r.value();
                            byte[] byArray = v == null ? this.state().remove(new KeyBytes(this.org$locationtech$geomesa$kafka$data$KafkaMetadata$TopicMap$$$outer(), (byte[])r.key())) : this.state().put(new KeyBytes(this.org$locationtech$geomesa$kafka$data$KafkaMetadata$TopicMap$$$outer(), (byte[])r.key()), v);
                        }
                        this.consumer().commitAsync();
                    }
                    catch (Throwable throwable) {
                        BoxedUnit boxedUnit;
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof WakeupException ? true : (throwable2 instanceof InterruptException ? true : throwable2 instanceof InterruptedException)) {
                            interrupted = true;
                            continue;
                        }
                        if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) throw throwable;
                        Throwable e = (Throwable)option.get();
                        if (this.org$locationtech$geomesa$kafka$data$KafkaMetadata$TopicMap$$$outer().logger().underlying().isWarnEnabled()) {
                            this.org$locationtech$geomesa$kafka$data$KafkaMetadata$TopicMap$$$outer().logger().underlying().warn(new StringBuilder(47).append("Consumer [").append(this.groupId()).append("] error receiving message from topic:").toString(), e);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        Thread.sleep(1000L);
                        continue;
                        return;
                    }
                }
            }
            finally {
                this.complete().countDown();
            }
        }

        private void doInitialLoad() {
            try {
                BoxedUnit boxedUnit;
                LazyRef stateStrings$lzy = new LazyRef();
                scala.collection.mutable.Map offsets = (scala.collection.mutable.Map)Map$.MODULE$.empty();
                Seq partitions = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.consumer().partitionsFor(this.org$locationtech$geomesa$kafka$data$KafkaMetadata$TopicMap$$$outer().config().catalog())).asScala()).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.partition()))).toSeq();
                offsets.$plus$plus$eq((IterableOnce)KafkaConsumerVersions$.MODULE$.endOffsets(this.consumer(), this.org$locationtech$geomesa$kafka$data$KafkaMetadata$TopicMap$$$outer().config().catalog(), partitions).collect((PartialFunction)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 != null) {
                            int p = A1._1$mcI$sp();
                            long o = A1._2$mcJ$sp();
                            if (o > 0L) {
                                return (B1)new Tuple2.mcIJ.sp(p, o - 1L);
                            }
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Tuple2<Object, Object> x1) {
                        long o;
                        Tuple2<Object, Object> tuple2 = x1;
                        return tuple2 != null && (o = tuple2._2$mcJ$sp()) > 0L;
                    }
                }));
                while (offsets.nonEmpty()) {
                    ConsumerRecords result = KafkaConsumerVersions$.MODULE$.poll(this.consumer(), this.poll());
                    if (result.isEmpty()) continue;
                    for (ConsumerRecord r : result) {
                        byte[] v = (byte[])r.value();
                        byte[] byArray = v == null ? this.state().remove(new KeyBytes(this.org$locationtech$geomesa$kafka$data$KafkaMetadata$TopicMap$$$outer(), (byte[])r.key())) : this.state().put(new KeyBytes(this.org$locationtech$geomesa$kafka$data$KafkaMetadata$TopicMap$$$outer(), (byte[])r.key()), v);
                        Object object = offsets.get((Object)BoxesRunTime.boxToInteger((int)r.partition())).exists((Function1)(JFunction1.mcZJ.sp & Serializable)o -> r.offset() >= o) ? offsets.remove((Object)BoxesRunTime.boxToInteger((int)r.partition())) : BoxedUnit.UNIT;
                    }
                    this.consumer().commitAsync();
                }
                if (this.org$locationtech$geomesa$kafka$data$KafkaMetadata$TopicMap$$$outer().logger().underlying().isDebugEnabled()) {
                    this.org$locationtech$geomesa$kafka$data$KafkaMetadata$TopicMap$$$outer().logger().underlying().debug("Completed initial load of catalog '{}': \n  {}", new Object[]{this.org$locationtech$geomesa$kafka$data$KafkaMetadata$TopicMap$$$outer().config().catalog(), this.stateStrings$1(stateStrings$lzy).mkString("\n  ")});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.future_$eq(CachedThreadPool$.MODULE$.submit((Runnable)this));
                package$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable)() -> this.future().cancel(true));
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    this.complete().countDown();
                    throw e;
                }
                throw throwable;
            }
        }

        public Option<byte[]> get(byte[] key) {
            return Option$.MODULE$.apply((Object)this.state().get(new KeyBytes(this.org$locationtech$geomesa$kafka$data$KafkaMetadata$TopicMap$$$outer(), key)));
        }

        public CloseableIterator<Tuple2<byte[], byte[]>> all() {
            return CloseableIterator$.MODULE$.apply(((IterableOnce)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.state()).asScala()).iterator().map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    KeyBytes k = (KeyBytes)tuple2._1();
                    byte[] v = (byte[])tuple2._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k.bytes()), (Object)v);
                }
                throw new MatchError((Object)tuple2);
            }), (Function0)(JFunction0.mcV.sp & Serializable)() -> CloseableIterator$.MODULE$.apply$default$2());
        }

        public CloseableIterator<Tuple2<byte[], byte[]>> prefix(byte[] prefix) {
            return this.all().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TopicMap.$anonfun$prefix$1(prefix, x0$1)));
        }

        @Override
        public void close() {
            try {
                Object object = this.future() != null ? BoxesRunTime.boxToBoolean((boolean)this.future().cancel(true)) : BoxedUnit.UNIT;
                this.complete().await(10L, TimeUnit.SECONDS);
            }
            finally {
                if (this.closed().compareAndSet(false, true)) {
                    this.cleanupConsumer();
                }
            }
        }

        private void cleanupConsumer() {
            try {
                Set topics = this.consumer().assignment();
                this.consumer().unsubscribe();
                if (!topics.isEmpty()) {
                    Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.org$locationtech$geomesa$kafka$data$KafkaMetadata$TopicMap$$$outer().org$locationtech$geomesa$kafka$data$KafkaMetadata$$adminClientOp((Function1 & Serializable)x$4 -> {
                        KafkaAdminVersions$.MODULE$.deleteConsumerGroupOffsets(x$4, this.groupId(), topics);
                        return BoxedUnit.UNIT;
                    })).failed().foreach((Function1 & Serializable)e -> {
                        TopicMap.$anonfun$cleanupConsumer$3(this, e);
                        return BoxedUnit.UNIT;
                    });
                }
            }
            finally {
                this.consumer().close();
            }
        }

        public /* synthetic */ KafkaMetadata org$locationtech$geomesa$kafka$data$KafkaMetadata$TopicMap$$$outer() {
            return KafkaMetadata.this;
        }

        private final /* synthetic */ scala.collection.mutable.Map stateStrings$lzycompute$1(LazyRef stateStrings$lzy$1) {
            scala.collection.mutable.Map map;
            LazyRef lazyRef = stateStrings$lzy$1;
            synchronized (lazyRef) {
                map = stateStrings$lzy$1.initialized() ? (scala.collection.mutable.Map)stateStrings$lzy$1.value() : (scala.collection.mutable.Map)stateStrings$lzy$1.initialize((Object)((MapOps)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.state()).asScala()).map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        KeyBytes k = (KeyBytes)tuple2._1();
                        byte[] v = (byte[])tuple2._2();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String(k.bytes(), StandardCharsets.UTF_8)), (Object)new String(v, StandardCharsets.UTF_8));
                    }
                    throw new MatchError((Object)tuple2);
                }));
            }
            return map;
        }

        private final scala.collection.mutable.Map stateStrings$1(LazyRef stateStrings$lzy$1) {
            if (stateStrings$lzy$1.initialized()) {
                return (scala.collection.mutable.Map)stateStrings$lzy$1.value();
            }
            return this.stateStrings$lzycompute$1(stateStrings$lzy$1);
        }

        public static final /* synthetic */ boolean $anonfun$prefix$1(byte[] prefix$1, Tuple2 x0$1) {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                byte[] k = (byte[])tuple2._1();
                return ArrayOps$.MODULE$.startsWith$extension(Predef$.MODULE$.byteArrayOps(k), (Object)prefix$1);
            }
            throw new MatchError((Object)tuple2);
        }

        public static final /* synthetic */ void $anonfun$cleanupConsumer$3(TopicMap $this, Throwable e) {
            BoxedUnit boxedUnit;
            if ($this.org$locationtech$geomesa$kafka$data$KafkaMetadata$TopicMap$$$outer().logger().underlying().isWarnEnabled()) {
                $this.org$locationtech$geomesa$kafka$data$KafkaMetadata$TopicMap$$$outer().logger().underlying().warn("Error deleting consumer group offsets:", e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }

        public TopicMap() {
            if (KafkaMetadata.this == null) {
                throw null;
            }
            this.groupId = UUID.randomUUID().toString();
            this.poll = Duration.of(100L, ChronoUnit.MILLIS);
            this.state = new ConcurrentHashMap();
            this.complete = new CountDownLatch(1);
            this.closed = new AtomicBoolean(false);
            this.consumer = KafkaDataStore$.MODULE$.consumer(KafkaMetadata.this.config().brokers(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)KafkaMetadata.this.config().consumers().properties().$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group.id"), (Object)this.groupId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"auto.offset.reset"), (Object)"earliest")})))));
            KafkaConsumerVersions$.MODULE$.subscribe(this.consumer(), KafkaMetadata.this.config().catalog());
            this.doInitialLoad();
        }
    }
}

