/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka.index;

import com.github.benmanes.caffeine.cache.Ticker;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.expression.Expression;
import org.locationtech.geomesa.filter.factory.FastFilterFactory$;
import org.locationtech.geomesa.kafka.data.KafkaDataStore;
import org.locationtech.geomesa.kafka.data.KafkaDataStore$ImmediatelyExpireConfig$;
import org.locationtech.geomesa.kafka.data.KafkaDataStore$NeverExpireConfig$;
import org.locationtech.geomesa.kafka.index.FeatureStateFactory;
import org.locationtech.geomesa.kafka.index.FeatureStateFactory$CurrentTimeTicker$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.converters.FastConverter$;
import org.locationtech.geomesa.utils.index.SpatialIndex;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class FeatureStateFactory$
implements LazyLogging {
    public static final FeatureStateFactory$ MODULE$ = new FeatureStateFactory$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        FeatureStateFactory$ featureStateFactory$ = this;
        synchronized (featureStateFactory$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public FeatureStateFactory apply(SimpleFeatureType sft, SpatialIndex<SimpleFeature> index, KafkaDataStore.ExpiryTimeConfig expiry, FeatureStateFactory.FeatureExpiration expiration, Option<Tuple2<ScheduledExecutorService, Ticker>> executor) {
        LazyRef x$1$lzy = new LazyRef();
        LazyRef es$lzy = new LazyRef();
        LazyRef ticker$lzy = new LazyRef();
        int geom = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
        KafkaDataStore.ExpiryTimeConfig expiryTimeConfig = expiry;
        if (KafkaDataStore$NeverExpireConfig$.MODULE$.equals(expiryTimeConfig)) {
            return new FeatureStateFactory.BasicFactory(index, geom);
        }
        if (expiryTimeConfig instanceof KafkaDataStore.IngestTimeConfig) {
            KafkaDataStore.IngestTimeConfig ingestTimeConfig = (KafkaDataStore.IngestTimeConfig)expiryTimeConfig;
            Duration ex = ingestTimeConfig.expiry();
            return new FeatureStateFactory.ExpiryFactory(index, geom, expiration, FeatureStateFactory$.es$1(es$lzy, x$1$lzy, executor), ex.toMillis());
        }
        if (expiryTimeConfig instanceof KafkaDataStore.EventTimeConfig) {
            KafkaDataStore.EventTimeConfig eventTimeConfig = (KafkaDataStore.EventTimeConfig)expiryTimeConfig;
            Duration ex = eventTimeConfig.expiry();
            String time = eventTimeConfig.expression();
            boolean ordering = eventTimeConfig.ordered();
            Expression expression = FastFilterFactory$.MODULE$.toExpression(sft, time);
            if (!ex.isFinite() && ordering) {
                return new FeatureStateFactory.EventTimeFactory(index, geom, expression);
            }
            if (ordering) {
                return new FeatureStateFactory.EventTimeOrderedExpiryFactory(index, geom, expression, expiration, FeatureStateFactory$.es$1(es$lzy, x$1$lzy, executor), FeatureStateFactory$.ticker$1(ticker$lzy, x$1$lzy, executor), ex.toMillis());
            }
            return new FeatureStateFactory.EventTimeExpiryFactory(index, geom, expression, expiration, FeatureStateFactory$.es$1(es$lzy, x$1$lzy, executor), FeatureStateFactory$.ticker$1(ticker$lzy, x$1$lzy, executor), ex.toMillis());
        }
        if (expiryTimeConfig instanceof KafkaDataStore.FilteredExpiryConfig) {
            KafkaDataStore.FilteredExpiryConfig filteredExpiryConfig = (KafkaDataStore.FilteredExpiryConfig)expiryTimeConfig;
            Seq<Tuple2<String, KafkaDataStore.ExpiryTimeConfig>> ex = filteredExpiryConfig.expiry();
            Seq delegates = (Seq)ex.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String ecql = (String)tuple2._1();
                    KafkaDataStore.ExpiryTimeConfig e = (KafkaDataStore.ExpiryTimeConfig)tuple2._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)FastFilterFactory$.MODULE$.toFilter(sft, ecql)), (Object)MODULE$.apply(sft, index, e, expiration, (Option<Tuple2<ScheduledExecutorService, Ticker>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)FeatureStateFactory$.es$1(es$lzy, x$1$lzy, executor)), (Object)FeatureStateFactory$.ticker$1(ticker$lzy, x$1$lzy, executor)))));
                }
                throw new MatchError((Object)tuple2);
            });
            return new FeatureStateFactory.FilteredExpiryFactory((Seq<Tuple2<Filter, FeatureStateFactory>>)delegates);
        }
        if (KafkaDataStore$ImmediatelyExpireConfig$.MODULE$.equals(expiryTimeConfig)) {
            throw new IllegalStateException("Can't use feature state with immediate expiration");
        }
        throw new MatchError((Object)expiryTimeConfig);
    }

    public long time(Expression expression, SimpleFeature feature) {
        long l;
        try {
            Object object = expression.evaluate((Object)feature);
            if (object instanceof Date) {
                Date date = (Date)object;
                l = date.getTime();
            } else if (object instanceof Number) {
                Number number = (Number)object;
                l = number.longValue();
            } else {
                l = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply(FastConverter$.MODULE$.convert(object, Date.class)).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.getTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
            }
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(32).append("Error evaluating event time for ").append(feature).toString(), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                l = 0L;
            }
            throw throwable;
        }
        return l;
    }

    private static final /* synthetic */ Tuple2 x$1$lzycompute$1(LazyRef x$1$lzy$1, Option executor$1) {
        Tuple2 tuple2;
        LazyRef lazyRef = x$1$lzy$1;
        synchronized (lazyRef) {
            Tuple2 tuple22;
            if (x$1$lzy$1.initialized()) {
                tuple22 = (Tuple2)x$1$lzy$1.value();
            } else {
                Tuple2 tuple23 = (Tuple2)executor$1.getOrElse((Function0 & Serializable)() -> {
                    ScheduledThreadPoolExecutor es = new ScheduledThreadPoolExecutor(2);
                    es.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
                    es.setRemoveOnCancelPolicy(true);
                    return new Tuple2((Object)es, (Object)FeatureStateFactory$CurrentTimeTicker$.MODULE$);
                });
                if (tuple23 == null) {
                    throw new MatchError((Object)tuple23);
                }
                ScheduledExecutorService es = (ScheduledExecutorService)tuple23._1();
                Ticker ticker = (Ticker)tuple23._2();
                tuple22 = (Tuple2)x$1$lzy$1.initialize((Object)new Tuple2((Object)es, (Object)ticker));
            }
            tuple2 = tuple22;
        }
        return tuple2;
    }

    private static final /* synthetic */ Tuple2 x$1$1(LazyRef x$1$lzy$1, Option executor$1) {
        if (x$1$lzy$1.initialized()) {
            return (Tuple2)x$1$lzy$1.value();
        }
        return FeatureStateFactory$.x$1$lzycompute$1(x$1$lzy$1, executor$1);
    }

    private static final /* synthetic */ ScheduledExecutorService es$lzycompute$1(LazyRef es$lzy$1, LazyRef x$1$lzy$1, Option executor$1) {
        ScheduledExecutorService scheduledExecutorService;
        LazyRef lazyRef = es$lzy$1;
        synchronized (lazyRef) {
            scheduledExecutorService = es$lzy$1.initialized() ? (ScheduledExecutorService)es$lzy$1.value() : (ScheduledExecutorService)es$lzy$1.initialize(FeatureStateFactory$.x$1$1(x$1$lzy$1, executor$1)._1());
        }
        return scheduledExecutorService;
    }

    private static final ScheduledExecutorService es$1(LazyRef es$lzy$1, LazyRef x$1$lzy$1, Option executor$1) {
        if (es$lzy$1.initialized()) {
            return (ScheduledExecutorService)es$lzy$1.value();
        }
        return FeatureStateFactory$.es$lzycompute$1(es$lzy$1, x$1$lzy$1, executor$1);
    }

    private static final /* synthetic */ Ticker ticker$lzycompute$1(LazyRef ticker$lzy$1, LazyRef x$1$lzy$1, Option executor$1) {
        Ticker ticker;
        LazyRef lazyRef = ticker$lzy$1;
        synchronized (lazyRef) {
            ticker = ticker$lzy$1.initialized() ? (Ticker)ticker$lzy$1.value() : (Ticker)ticker$lzy$1.initialize(FeatureStateFactory$.x$1$1(x$1$lzy$1, executor$1)._2());
        }
        return ticker;
    }

    private static final Ticker ticker$1(LazyRef ticker$lzy$1, LazyRef x$1$lzy$1, Option executor$1) {
        if (ticker$lzy$1.initialized()) {
            return (Ticker)ticker$lzy$1.value();
        }
        return FeatureStateFactory$.ticker$lzycompute$1(ticker$lzy$1, x$1$lzy$1, executor$1);
    }

    private FeatureStateFactory$() {
    }
}

