/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka.index;

import com.github.benmanes.caffeine.cache.Ticker;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Closeable;
import java.io.Serializable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.kafka.data.KafkaDataStore;
import org.locationtech.geomesa.kafka.index.FeatureStateFactory$;
import org.locationtech.geomesa.utils.index.SpatialIndex;
import org.locationtech.geomesa.utils.io.IsCloseable;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.jts.geom.Geometry;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\ree\u0001C;w!\u0003\r\n!a\u0001\t\u000f\u0005\u0005\u0002A\"\u0001\u0002$\u001d9\u00111\t<\t\u0002\u0005\u0015cAB;w\u0011\u0003\tI\u0005C\u0004\u0002l\r!\t!!\u001c\t\u000f\u0005=4\u0001\"\u0001\u0002r!9\u0011Q_\u0002\u0005\u0002\t\u0005c!CAe\u0007A\u0005\u0019\u0013AAf\u0011\u001d\tim\u0002D\u0001\u0003\u001f4\u0011\"!8\u0004!\u0003\r\n!a8\t\u000f\u0005\u0005\u0018B\"\u0001\u0002d\"9\u0011Q_\u0005\u0007\u0002\u0005]\bbBA\u0000\u0013\u0019\u0005!\u0011\u0001\u0005\b\u0005\u0007Ia\u0011\u0001B\u0003\u0011\u001d\u00119!\u0003D\u0001\u0005\u000b1aAa\u0016\u0004\u0001\te\u0003BCAB\u001f\t\u0005\t\u0015!\u0003\u0002\"\"Iqo\u0004B\u0001B\u0003%\u00111\u0013\u0005\u000b\u00057z!\u0011!Q\u0001\n\tu\u0003BCA{\u001f\t\u0015\r\u0011\"\u0001\u0002x\"Q!1M\b\u0003\u0002\u0003\u0006I!!?\t\u000f\u0005-t\u0002\"\u0001\u0003f!I!\u0011O\bC\u0002\u0013%!1\u000f\u0005\t\u0005\u0007{\u0001\u0015!\u0003\u0003v!I\u0011\u0011]\bC\u0002\u0013\u0005\u00131\u001d\u0005\t\u0005\u000b{\u0001\u0015!\u0003\u0002f\"9\u0011q`\b\u0005B\t\u0005\u0001b\u0002B\u0004\u001f\u0011\u0005#Q\u0001\u0005\b\u0005\u0007yA\u0011\tB\u0003\u0011\u001d\u00119i\u0004C!\u0005\u00133aAa#\u0004\u0001\t5\u0005BCAB=\t\u0005\t\u0015!\u0003\u0002\"\"IqO\bB\u0001B\u0003%\u00111\u0013\u0005\u000b\u00057r\"\u0011!Q\u0001\n\tu\u0003bCA{=\t\u0005\t\u0015!\u0003\u0002zNA!\"a1\u001f\u0005\u0003\u0005\u000b\u0011BAc\u0011)\u0011YA\bB\u0001B\u0003%!\u0011\u0004\u0005\u000b\u0003Ss\"\u0011!Q\u0001\n\u0005e\bbBA6=\u0011\u0005!Q\u0013\u0005\f\u0005Os\u0002\u0019!a\u0001\n\u0013\u0011I\u000bC\u0006\u0003Lz\u0001\r\u00111A\u0005\n\t5\u0007b\u0003B^=\u0001\u0007\t\u0011)Q\u0005\u0005WCqAa7\u001f\t\u0003\u0012\t\u0001C\u0004\u0002\u0000z!\tE!\u0001\t\u000f\t\u001da\u0004\"\u0011\u0003\u0006!9!q\u0011\u0010\u0005B\t%eA\u0002Bo\u0007\u0001\u0011y\u000e\u0003\u0006\u0002\u0004:\u0012\t\u0011)A\u0005\u0003CC!\"!>/\u0005\u000b\u0007I\u0011AA|\u0011)\u0011\u0019G\fB\u0001B\u0003%\u0011\u0011 \u0005\u000b\u0003\u0007t#\u0011!Q\u0001\n\u0005\u0015\u0007bBA6]\u0011\u0005!\u0011\u001d\u0005\n\u0003Ct#\u0019!C!\u0003GD\u0001B!\"/A\u0003%\u0011Q\u001d\u0005\b\u0003\u007ftC\u0011\tB\u0001\u0011\u001d\u0011\u0019A\fC!\u0005\u000bAqAa\u0002/\t\u0003\u0012)\u0001C\u0004\u0003\b:\"\tE!#\u0007\r\t-8\u0001\u0001Bw\u0011%9(H!A!\u0002\u0013\t\u0019\n\u0003\u0006\u0003\\i\u0012\t\u0011)A\u0005\u0005;Bq!a\u001b;\t\u0003\u0011y\u000fC\u0004\u0002\"i\"\tEa>\t\u000f\tm(\b\"\u0011\u0003\u0002!9!q\u0011\u001e\u0005B\t%eA\u0002B\u007f\u0007\u0001\u0011y\u0010C\u0005x\u0003\n\u0005\t\u0015!\u0003\u0002\u0014\"Q!1L!\u0003\u0002\u0003\u0006IA!\u0018\t\u0015\u0005\r\u0017I!A!\u0002\u0013\t)\r\u0003\u0006\u0003\f\u0005\u0013\t\u0011)A\u0005\u00053A!\"!+B\u0005\u0003\u0005\u000b\u0011BA}\u0011\u001d\tY'\u0011C\u0001\u0007\u0003Aq!!\tB\t\u0003\u001ay\u0001C\u0004\u0003|\u0006#\tE!\u0001\t\u000f\t\u001d\u0015\t\"\u0011\u0003\n\u001a111C\u0002\u0001\u0007+A\u0011b^&\u0003\u0002\u0003\u0006I!a%\t\u0015\tm3J!A!\u0002\u0013\u0011i\u0006\u0003\u0006\u0004\u0018-\u0013\t\u0011)A\u0005\u0005\u000fBq!a\u001bL\t\u0003\u0019I\u0002C\u0004\u0002\"-#\tea\t\t\u000f\tm8\n\"\u0011\u0003\u0002!9!qQ&\u0005B\t%eABB\u0014\u0007\u0001\u0019I\u0003C\u0005x'\n\u0005\t\u0015!\u0003\u0002\u0014\"Q!1L*\u0003\u0002\u0003\u0006IA!\u0018\t\u0015\r]1K!A!\u0002\u0013\u00119\u0005\u0003\u0006\u0002DN\u0013\t\u0011)A\u0005\u0003\u000bD!Ba\u0003T\u0005\u0003\u0005\u000b\u0011\u0002B\r\u0011)\u0019Yc\u0015B\u0001B\u0003%!\u0011\u0006\u0005\u000b\u0003S\u001b&\u0011!Q\u0001\n\u0005e\bbBA6'\u0012\u00051Q\u0006\u0005\b\u0003C\u0019F\u0011IB \u0011\u001d\u0011Yp\u0015C!\u0005\u0003AqAa\"T\t\u0003\u0012II\u0002\u0004\u0004D\r\u00011Q\t\u0005\no~\u0013\t\u0011)A\u0005\u0003'C!Ba\u0017`\u0005\u0003\u0005\u000b\u0011\u0002B/\u0011)\u00199b\u0018B\u0001B\u0003%!q\t\u0005\u000b\u0003\u0007|&\u0011!Q\u0001\n\u0005\u0015\u0007B\u0003B\u0006?\n\u0005\t\u0015!\u0003\u0003\u001a!Q11F0\u0003\u0002\u0003\u0006IA!\u000b\t\u0015\u0005%vL!A!\u0002\u0013\tI\u0010C\u0004\u0002l}#\taa\u0012\t\u000f\u0005\u0005r\f\"\u0011\u0004Z!9!1`0\u0005B\t\u0005\u0001b\u0002BD?\u0012\u0005#\u0011\u0012\u0004\u0007\u0007;\u001a\u0001aa\u0018\t\u0015\r\u00054N!A!\u0002\u0013\u0019\u0019\u0007C\u0004\u0002l-$\taa \t\u000f\u0005\u00052\u000e\"\u0011\u0004\u0006\"9!1`6\u0005B\t\u0005\u0001b\u0002BDW\u0012\u0005#\u0011R\u0004\b\u0007\u0013\u001b\u0001\u0012ABF\r\u001d\u0019ii\u0001E\u0001\u0007\u001fCq!a\u001bs\t\u0003\u0019\t\nC\u0004\u0004\u0014J$\te!&\u0003'\u0019+\u0017\r^;sKN#\u0018\r^3GC\u000e$xN]=\u000b\u0005]D\u0018!B5oI\u0016D(BA={\u0003\u0015Y\u0017MZ6b\u0015\tYH0A\u0004hK>lWm]1\u000b\u0005ut\u0018\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A@\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\t)!!\u0006\u0011\t\u0005\u001d\u0011\u0011C\u0007\u0003\u0003\u0013QA!a\u0003\u0002\u000e\u0005!A.\u00198h\u0015\t\ty!\u0001\u0003kCZ\f\u0017\u0002BA\n\u0003\u0013\u0011aa\u00142kK\u000e$\b\u0003BA\f\u0003;i!!!\u0007\u000b\t\u0005m\u0011QB\u0001\u0003S>LA!a\b\u0002\u001a\tI1\t\\8tK\u0006\u0014G.Z\u0001\fGJ,\u0017\r^3Ti\u0006$X\r\u0006\u0003\u0002&\r]\u0005cAA\u0014\u00139\u0019\u0011\u0011\u0006\u0002\u000f\t\u0005-\u0012\u0011\t\b\u0005\u0003[\tyD\u0004\u0003\u00020\u0005ub\u0002BA\u0019\u0003wqA!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0005\u0003o\t\t!\u0001\u0004=e>|GOP\u0005\u0002\u007f&\u0011QP`\u0005\u0003wrL!!\u001f>\n\u0005]D\u0018a\u0005$fCR,(/Z*uCR,g)Y2u_JL\bcAA$\u00075\taoE\u0003\u0004\u0003\u0017\n9\u0006\u0005\u0003\u0002N\u0005MSBAA(\u0015\t\t\t&A\u0003tG\u0006d\u0017-\u0003\u0003\u0002V\u0005=#AB!osJ+g\r\u0005\u0003\u0002Z\u0005\u001dTBAA.\u0015\u0011\ti&a\u0018\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\t\u0005\u0005\u00141M\u0001\tif\u0004Xm]1gK*\u0011\u0011QM\u0001\u0004G>l\u0017\u0002BA5\u00037\u00121\u0002T1{s2{wmZ5oO\u00061A(\u001b8jiz\"\"!!\u0012\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0019\u0005M\u0014QOAI\u0003O\u000b\tM!\u0003\u0011\u0007\u0005\u001d\u0003\u0001C\u0004\u0002x\u0015\u0001\r!!\u001f\u0002\u0007M4G\u000f\u0005\u0003\u0002|\u00055UBAA?\u0015\u0011\ty(!!\u0002\rMLW\u000e\u001d7f\u0015\u0011\t\u0019)!\"\u0002\u000f\u0019,\u0017\r^;sK*!\u0011qQAE\u0003\r\t\u0007/\u001b\u0006\u0004\u0003\u0017s\u0018\u0001C4f_R|w\u000e\\:\n\t\u0005=\u0015Q\u0010\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0007BB<\u0006\u0001\u0004\t\u0019\n\u0005\u0004\u0002\u0016\u0006u\u0015\u0011U\u0007\u0003\u0003/S1a^AM\u0015\r\tYJ_\u0001\u0006kRLGn]\u0005\u0005\u0003?\u000b9J\u0001\u0007Ta\u0006$\u0018.\u00197J]\u0012,\u0007\u0010\u0005\u0003\u0002|\u0005\r\u0016\u0002BAS\u0003{\u0012QbU5na2,g)Z1ukJ,\u0007bBAU\u000b\u0001\u0007\u00111V\u0001\u0007Kb\u0004\u0018N]=\u0011\t\u00055\u00161\u0018\b\u0005\u0003_\u000b)L\u0004\u0003\u0002,\u0005E\u0016bAAZq\u0006!A-\u0019;b\u0013\u0011\t9,!/\u0002\u001d-\u000bgm[1ECR\f7\u000b^8sK*\u0019\u00111\u0017=\n\t\u0005u\u0016q\u0018\u0002\u0011\u000bb\u0004\u0018N]=US6,7i\u001c8gS\u001eTA!a.\u0002:\"9\u00111Y\u0003A\u0002\u0005\u0015\u0017AC3ya&\u0014\u0018\r^5p]B\u0019\u0011qY\u0004\u000e\u0003\r\u0011\u0011CR3biV\u0014X-\u0012=qSJ\fG/[8o'\r9\u00111J\u0001\u0007Kb\u0004\u0018N]3\u0015\t\u0005E\u0017q\u001b\t\u0005\u0003\u001b\n\u0019.\u0003\u0003\u0002V\u0006=#\u0001B+oSRDq!!7\t\u0001\u0004\tY.\u0001\u0007gK\u0006$XO]3Ti\u0006$X\rE\u0002\u0002H&\u0011ABR3biV\u0014Xm\u0015;bi\u0016\u001c2!CA&\u0003\tIG-\u0006\u0002\u0002fB!\u0011q]Ax\u001d\u0011\tI/a;\u0011\t\u0005M\u0012qJ\u0005\u0005\u0003[\fy%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003c\f\u0019P\u0001\u0004TiJLgn\u001a\u0006\u0005\u0003[\fy%\u0001\u0003uS6,WCAA}!\u0011\ti%a?\n\t\u0005u\u0018q\n\u0002\u0005\u0019>tw-A\bj]N,'\u000f^%oi>Le\u000eZ3y)\t\t\t.A\tsKR\u0014\u0018.\u001a<f\rJ|W.\u00138eKb$\"!!)\u0002\u001fI,Wn\u001c<f\rJ|W.\u00138eKbDqAa\u0003\u0006\u0001\u0004\u0011i!\u0001\u0005fq\u0016\u001cW\u000f^8s!\u0019\tiEa\u0004\u0003\u0014%!!\u0011CA(\u0005\u0019y\u0005\u000f^5p]BA\u0011Q\nB\u000b\u00053\u0011I#\u0003\u0003\u0003\u0018\u0005=#A\u0002+va2,'\u0007\u0005\u0003\u0003\u001c\t\u0015RB\u0001B\u000f\u0015\u0011\u0011yB!\t\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0003$\u00055\u0011\u0001B;uS2LAAa\n\u0003\u001e\tA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0011\t\t-\"QH\u0007\u0003\u0005[QAAa\f\u00032\u0005)1-Y2iK*!!1\u0007B\u001b\u0003!\u0019\u0017M\u001a4fS:,'\u0002\u0002B\u001c\u0005s\t\u0001BY3o[\u0006tWm\u001d\u0006\u0005\u0005w\t\u0019'\u0001\u0004hSRDWOY\u0005\u0005\u0005\u007f\u0011iC\u0001\u0004US\u000e\\WM\u001d\u000b\u0007\u0003s\u0014\u0019E!\u0016\t\u000f\t\u0015c\u00011\u0001\u0003H\u0005QQ\r\u001f9sKN\u001c\u0018n\u001c8\u0011\t\t%#\u0011K\u0007\u0003\u0005\u0017RAA!\u0012\u0003N)!!qJAC\u0003\u00191\u0017\u000e\u001c;fe&!!1\u000bB&\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\b\u0003\u00073\u0001\u0019AAQ\u0005)\u0011\u0015m]5d'R\fG/Z\n\u0006\u001f\u0005-\u00131\\\u0001\u0005O\u0016|W\u000e\u0005\u0003\u0002N\t}\u0013\u0002\u0002B1\u0003\u001f\u00121!\u00138u\u0003\u0015!\u0018.\\3!))\u00119G!\u001b\u0003l\t5$q\u000e\t\u0004\u0003\u000f|\u0001bBAB+\u0001\u0007\u0011\u0011\u0015\u0005\u0007oV\u0001\r!a%\t\u000f\tmS\u00031\u0001\u0003^!9\u0011Q_\u000bA\u0002\u0005e\u0018!A4\u0016\u0005\tU\u0004\u0003\u0002B<\u0005\u007fj!A!\u001f\u000b\t\tm#1\u0010\u0006\u0004\u0005{b\u0018a\u00016ug&!!\u0011\u0011B=\u0005!9Um\\7fiJL\u0018AA4!\u0003\rIG\rI\u0001\ti>\u001cFO]5oOR\u0011\u0011Q\u001d\u0002\f\u000bb\u0004\u0018N]=Ti\u0006$XmE\u0003\u001f\u0005O\u0012y\t\u0005\u0003\u0002\b\tE\u0015\u0002\u0002BJ\u0003\u0013\u0011\u0001BU;o]\u0006\u0014G.\u001a\u000b\u0011\u0005/\u0013IJa'\u0003\u001e\n}%\u0011\u0015BR\u0005K\u00032!a2\u001f\u0011\u001d\t\u0019I\na\u0001\u0003CCaa\u001e\u0014A\u0002\u0005M\u0005b\u0002B.M\u0001\u0007!Q\f\u0005\b\u0003k4\u0003\u0019AA}\u0011\u001d\t\u0019M\na\u0001\u0003\u000bDqAa\u0003'\u0001\u0004\u0011I\u0002C\u0004\u0002*\u001a\u0002\r!!?\u0002\r\u0019,H/\u001e:f+\t\u0011Y\u000b\r\u0003\u0003.\n]\u0006C\u0002B\u000e\u0005_\u0013\u0019,\u0003\u0003\u00032\nu!aD*dQ\u0016$W\u000f\\3e\rV$XO]3\u0011\t\tU&q\u0017\u0007\u0001\t-\u0011I,KA\u0001\u0002\u0003\u0015\tA!0\u0003\u0007}#\u0013'A\u0004gkR,(/\u001a\u0011\u0012\t\t}&Q\u0019\t\u0005\u0003\u001b\u0012\t-\u0003\u0003\u0003D\u0006=#a\u0002(pi\"Lgn\u001a\t\u0005\u0003\u001b\u00129-\u0003\u0003\u0003J\u0006=#aA!os\u0006Qa-\u001e;ve\u0016|F%Z9\u0015\t\u0005E'q\u001a\u0005\n\u0005#D\u0013\u0011!a\u0001\u0005'\f1\u0001\u001f\u00132a\u0011\u0011)N!7\u0011\r\tm!q\u0016Bl!\u0011\u0011)L!7\u0005\u0019\te&qZA\u0001\u0002\u0003\u0015\tA!0\u0002\u0007I,hN\u0001\u0007FqBL'/\u001a3Ti\u0006$XmE\u0003/\u0003\u0017\nY\u000e\u0006\u0005\u0003d\n\u0015(q\u001dBu!\r\t9M\f\u0005\b\u0003\u0007\u001b\u0004\u0019AAQ\u0011\u001d\t)p\ra\u0001\u0003sDq!a14\u0001\u0004\t)M\u0001\u0007CCNL7MR1di>\u0014\u0018pE\u0003;\u0003\u000b\t\u0019\b\u0006\u0004\u0003r\nM(Q\u001f\t\u0004\u0003\u000fT\u0004BB<>\u0001\u0004\t\u0019\nC\u0004\u0003\\u\u0002\rA!\u0018\u0015\t\u0005m'\u0011 \u0005\b\u0003\u0007s\u0004\u0019AAQ\u0003\u0015\u0019Gn\\:f\u00055)\u0005\u0010]5ss\u001a\u000b7\r^8ssN)\u0011)!\u0002\u0002tQa11AB\u0003\u0007\u000f\u0019Iaa\u0003\u0004\u000eA\u0019\u0011qY!\t\r]<\u0005\u0019AAJ\u0011\u001d\u0011Yf\u0012a\u0001\u0005;Bq!a1H\u0001\u0004\t)\rC\u0004\u0003\f\u001d\u0003\rA!\u0007\t\u000f\u0005%v\t1\u0001\u0002zR!\u00111\\B\t\u0011\u001d\t\u0019\t\u0013a\u0001\u0003C\u0013\u0001#\u0012<f]R$\u0016.\\3GC\u000e$xN]=\u0014\u000f-\u000b)!a\u001d\u0002X\u0005IQM^3oiRKW.\u001a\u000b\t\u00077\u0019iba\b\u0004\"A\u0019\u0011qY&\t\r]|\u0005\u0019AAJ\u0011\u001d\u0011Yf\u0014a\u0001\u0005;Bqaa\u0006P\u0001\u0004\u00119\u0005\u0006\u0003\u0002\\\u000e\u0015\u0002bBAB!\u0002\u0007\u0011\u0011\u0015\u0002\u0017\u000bZ,g\u000e\u001e+j[\u0016,\u0005\u0010]5ss\u001a\u000b7\r^8ssN)1+!\u0002\u0002t\u00051A/[2lKJ$\u0002ca\f\u00042\rM2QGB\u001c\u0007s\u0019Yd!\u0010\u0011\u0007\u0005\u001d7\u000b\u0003\u0004x7\u0002\u0007\u00111\u0013\u0005\b\u00057Z\u0006\u0019\u0001B/\u0011\u001d\u00199b\u0017a\u0001\u0005\u000fBq!a1\\\u0001\u0004\t)\rC\u0004\u0003\fm\u0003\rA!\u0007\t\u000f\r-2\f1\u0001\u0003*!9\u0011\u0011V.A\u0002\u0005eH\u0003BAn\u0007\u0003Bq!a!]\u0001\u0004\t\tKA\u000fFm\u0016tG\u000fV5nK>\u0013H-\u001a:fI\u0016C\b/\u001b:z\r\u0006\u001cGo\u001c:z'\u0015y\u0016QAA:)A\u0019Iea\u0013\u0004N\r=3\u0011KB*\u0007+\u001a9\u0006E\u0002\u0002H~Caa^4A\u0002\u0005M\u0005b\u0002B.O\u0002\u0007!Q\f\u0005\b\u0007/9\u0007\u0019\u0001B$\u0011\u001d\t\u0019m\u001aa\u0001\u0003\u000bDqAa\u0003h\u0001\u0004\u0011I\u0002C\u0004\u0004,\u001d\u0004\rA!\u000b\t\u000f\u0005%v\r1\u0001\u0002zR!\u00111\\B.\u0011\u001d\t\u0019\t\u001ba\u0001\u0003C\u0013QCR5mi\u0016\u0014X\rZ#ya&\u0014\u0018PR1di>\u0014\u0018pE\u0003l\u0003\u000b\t\u0019(A\u0005eK2,w-\u0019;fgB11QMB8\u0007krAaa\u001a\u0004l9!\u00111GB5\u0013\t\t\t&\u0003\u0003\u0004n\u0005=\u0013a\u00029bG.\fw-Z\u0005\u0005\u0007c\u001a\u0019HA\u0002TKFTAa!\u001c\u0002PAA\u0011Q\nB\u000b\u0007o\n\u0019\b\u0005\u0003\u0004z\rmTB\u0001B'\u0013\u0011\u0019iH!\u0014\u0003\r\u0019KG\u000e^3s)\u0011\u0019\tia!\u0011\u0007\u0005\u001d7\u000eC\u0004\u0004b5\u0004\raa\u0019\u0015\t\u0005m7q\u0011\u0005\b\u0003\u0007s\u0007\u0019AAQ\u0003E\u0019UO\u001d:f]R$\u0016.\\3US\u000e\\WM\u001d\t\u0004\u0003\u000f\u0014(!E\"veJ,g\u000e\u001e+j[\u0016$\u0016nY6feN)!/!\u0002\u0003*Q\u001111R\u0001\u0005e\u0016\fG\r\u0006\u0002\u0002z\"9\u00111Q\u0001A\u0002\u0005\u0005\u0006")
public interface FeatureStateFactory
extends Closeable {
    public static long time(Expression expression, SimpleFeature feature) {
        return FeatureStateFactory$.MODULE$.time(expression, feature);
    }

    public static FeatureStateFactory apply(SimpleFeatureType sft, SpatialIndex<SimpleFeature> index, KafkaDataStore.ExpiryTimeConfig expiry, FeatureExpiration expiration, Option<Tuple2<ScheduledExecutorService, Ticker>> executor) {
        return FeatureStateFactory$.MODULE$.apply(sft, index, expiry, expiration, executor);
    }

    public FeatureState createState(SimpleFeature var1);

    public static class BasicFactory
    implements FeatureStateFactory {
        private final SpatialIndex<SimpleFeature> index;
        private final int geom;

        @Override
        public FeatureState createState(SimpleFeature feature) {
            return new BasicState(feature, this.index, this.geom, 0L);
        }

        @Override
        public void close() {
        }

        public String toString() {
            return new StringBuilder(19).append("BasicFactory[geom:").append(this.geom).append("]").toString();
        }

        public BasicFactory(SpatialIndex<SimpleFeature> index, int geom) {
            this.index = index;
            this.geom = geom;
        }
    }

    public static class BasicState
    implements FeatureState {
        private final SimpleFeature feature;
        private final SpatialIndex<SimpleFeature> index;
        private final long time;
        private final Geometry g;
        private final String id;

        @Override
        public long time() {
            return this.time;
        }

        private Geometry g() {
            return this.g;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public void insertIntoIndex() {
            this.index.insert(this.g(), this.id(), (Object)this.feature);
        }

        @Override
        public SimpleFeature removeFromIndex() {
            return (SimpleFeature)this.index.remove(this.g(), this.id());
        }

        @Override
        public SimpleFeature retrieveFromIndex() {
            return (SimpleFeature)this.index.get(this.g(), this.id());
        }

        public String toString() {
            return new StringBuilder(14).append("FeatureState(").append(this.feature).append(")").toString();
        }

        public BasicState(SimpleFeature feature, SpatialIndex<SimpleFeature> index, int geom, long time) {
            this.feature = feature;
            this.index = index;
            this.time = time;
            this.g = (Geometry)feature.getAttribute(geom);
            this.id = feature.getID();
        }
    }

    public static class EventTimeExpiryFactory
    implements FeatureStateFactory {
        private final SpatialIndex<SimpleFeature> index;
        private final int geom;
        private final Expression eventTime;
        private final FeatureExpiration expiration;
        private final ScheduledExecutorService executor;
        private final Ticker ticker;
        private final long expiry;

        @Override
        public FeatureState createState(SimpleFeature feature) {
            long expiry = FeatureStateFactory$.MODULE$.time(this.eventTime, feature) + this.expiry - this.ticker.read() / 1000000L;
            if (expiry < 1L) {
                return new ExpiredState(feature, 0L, this.expiration);
            }
            return new ExpiryState(feature, this.index, this.geom, 0L, this.expiration, this.executor, expiry);
        }

        @Override
        public void close() {
            this.executor.shutdownNow();
        }

        public String toString() {
            return new StringBuilder(48).append("EventTimeExpiryFactory[geom:").append(this.geom).append(",eventTime:").append(ECQL.toCQL((Expression)this.eventTime)).append(",expiry:").append(this.expiry).append("]").toString();
        }

        public EventTimeExpiryFactory(SpatialIndex<SimpleFeature> index, int geom, Expression eventTime, FeatureExpiration expiration, ScheduledExecutorService executor, Ticker ticker, long expiry) {
            this.index = index;
            this.geom = geom;
            this.eventTime = eventTime;
            this.expiration = expiration;
            this.executor = executor;
            this.ticker = ticker;
            this.expiry = expiry;
        }
    }

    public static class EventTimeFactory
    implements FeatureStateFactory,
    LazyLogging {
        private final SpatialIndex<SimpleFeature> index;
        private final int geom;
        private final Expression eventTime;
        private transient Logger logger;
        private volatile transient boolean bitmap$trans$0;

        private Logger logger$lzycompute() {
            EventTimeFactory eventTimeFactory = this;
            synchronized (eventTimeFactory) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            if (!this.bitmap$trans$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public FeatureState createState(SimpleFeature feature) {
            return new BasicState(feature, this.index, this.geom, FeatureStateFactory$.MODULE$.time(this.eventTime, feature));
        }

        @Override
        public void close() {
        }

        public String toString() {
            return new StringBuilder(34).append("EventTimeFactory[geom:").append(this.geom).append(",eventTime:").append(ECQL.toCQL((Expression)this.eventTime)).append("]").toString();
        }

        public EventTimeFactory(SpatialIndex<SimpleFeature> index, int geom, Expression eventTime) {
            this.index = index;
            this.geom = geom;
            this.eventTime = eventTime;
            LazyLogging.$init$((LazyLogging)this);
        }
    }

    public static class EventTimeOrderedExpiryFactory
    implements FeatureStateFactory {
        private final SpatialIndex<SimpleFeature> index;
        private final int geom;
        private final Expression eventTime;
        private final FeatureExpiration expiration;
        private final ScheduledExecutorService executor;
        private final Ticker ticker;
        private final long expiry;

        @Override
        public FeatureState createState(SimpleFeature feature) {
            long time = FeatureStateFactory$.MODULE$.time(this.eventTime, feature);
            long expiry = time + this.expiry - this.ticker.read() / 1000000L;
            if (expiry < 1L) {
                return new ExpiredState(feature, time, this.expiration);
            }
            return new ExpiryState(feature, this.index, this.geom, time, this.expiration, this.executor, expiry);
        }

        @Override
        public void close() {
            this.executor.shutdownNow();
        }

        public String toString() {
            return new StringBuilder(55).append("EventTimeOrderedExpiryFactory[geom:").append(this.geom).append(",eventTime:").append(ECQL.toCQL((Expression)this.eventTime)).append(",expiry:").append(this.expiry).append("]").toString();
        }

        public EventTimeOrderedExpiryFactory(SpatialIndex<SimpleFeature> index, int geom, Expression eventTime, FeatureExpiration expiration, ScheduledExecutorService executor, Ticker ticker, long expiry) {
            this.index = index;
            this.geom = geom;
            this.eventTime = eventTime;
            this.expiration = expiration;
            this.executor = executor;
            this.ticker = ticker;
            this.expiry = expiry;
        }
    }

    public static class ExpiredState
    implements FeatureState {
        private final SimpleFeature feature;
        private final long time;
        private final FeatureExpiration expiration;
        private final String id;

        @Override
        public long time() {
            return this.time;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public void insertIntoIndex() {
            this.expiration.expire(this);
        }

        @Override
        public SimpleFeature retrieveFromIndex() {
            return null;
        }

        @Override
        public SimpleFeature removeFromIndex() {
            return null;
        }

        public String toString() {
            return new StringBuilder(14).append("ExpiredState(").append(this.feature).append(")").toString();
        }

        public ExpiredState(SimpleFeature feature, long time, FeatureExpiration expiration) {
            this.feature = feature;
            this.time = time;
            this.expiration = expiration;
            this.id = feature.getID();
        }
    }

    public static class ExpiryFactory
    implements FeatureStateFactory {
        private final SpatialIndex<SimpleFeature> index;
        private final int geom;
        private final FeatureExpiration expiration;
        private final ScheduledExecutorService executor;
        private final long expiry;

        @Override
        public FeatureState createState(SimpleFeature feature) {
            return new ExpiryState(feature, this.index, this.geom, 0L, this.expiration, this.executor, this.expiry);
        }

        @Override
        public void close() {
            this.executor.shutdownNow();
        }

        public String toString() {
            return new StringBuilder(28).append("ExpiryFactory[geom:").append(this.geom).append(",expiry:").append(this.expiry).append("]").toString();
        }

        public ExpiryFactory(SpatialIndex<SimpleFeature> index, int geom, FeatureExpiration expiration, ScheduledExecutorService executor, long expiry) {
            this.index = index;
            this.geom = geom;
            this.expiration = expiration;
            this.executor = executor;
            this.expiry = expiry;
        }
    }

    public static class ExpiryState
    extends BasicState
    implements Runnable {
        private final SimpleFeature feature;
        private final FeatureExpiration expiration;
        private final ScheduledExecutorService executor;
        private final long expiry;
        private ScheduledFuture<?> future;

        private ScheduledFuture<?> future() {
            return this.future;
        }

        private void future_$eq(ScheduledFuture<?> x$1) {
            this.future = x$1;
        }

        @Override
        public void run() {
            this.expiration.expire(this);
        }

        @Override
        public void insertIntoIndex() {
            super.insertIntoIndex();
            this.future_$eq(this.executor.schedule(this, this.expiry, TimeUnit.MILLISECONDS));
        }

        @Override
        public SimpleFeature removeFromIndex() {
            this.future().cancel(false);
            return super.removeFromIndex();
        }

        @Override
        public String toString() {
            return new StringBuilder(13).append("ExpiryState(").append(this.feature).append(")").toString();
        }

        public ExpiryState(SimpleFeature feature, SpatialIndex<SimpleFeature> index, int geom, long time, FeatureExpiration expiration, ScheduledExecutorService executor, long expiry) {
            this.feature = feature;
            this.expiration = expiration;
            this.executor = executor;
            this.expiry = expiry;
            super(feature, index, geom, time);
        }
    }

    public static interface FeatureExpiration {
        public void expire(FeatureState var1);
    }

    public static interface FeatureState {
        public String id();

        public long time();

        public void insertIntoIndex();

        public SimpleFeature retrieveFromIndex();

        public SimpleFeature removeFromIndex();
    }

    public static class FilteredExpiryFactory
    implements FeatureStateFactory {
        private final Seq<Tuple2<Filter, FeatureStateFactory>> delegates;

        @Override
        public FeatureState createState(SimpleFeature feature) {
            Option opt = this.delegates.collectFirst((PartialFunction)new Serializable(null, feature){
                private static final long serialVersionUID = 0L;
                private final SimpleFeature feature$1;

                public final <A1 extends Tuple2<Filter, FeatureStateFactory>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        Filter f = (Filter)A1._1();
                        FeatureStateFactory factory = (FeatureStateFactory)A1._2();
                        if (f.evaluate((Object)this.feature$1)) {
                            return (B1)factory.createState(this.feature$1);
                        }
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Tuple2<Filter, FeatureStateFactory> x1) {
                    Filter f;
                    Tuple2<Filter, FeatureStateFactory> tuple2 = x1;
                    return tuple2 != null && (f = (Filter)tuple2._1()).evaluate((Object)this.feature$1);
                }
                {
                    this.feature$1 = feature$1;
                }
            });
            return (FeatureState)opt.get();
        }

        @Override
        public void close() {
            package.CloseWithLogging$.MODULE$.apply(this.delegates.map((Function1 & Serializable)x$4 -> (FeatureStateFactory)x$4._2()), (IsCloseable)IsCloseable$.MODULE$.iterableIsCloseable());
        }

        public String toString() {
            return new StringBuilder(33).append("FilteredExpiryFactory[delegates:").append(((IterableOnceOps)this.delegates.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Filter f = (Filter)tuple2._1();
                    FeatureStateFactory d = (FeatureStateFactory)tuple2._2();
                    return new StringBuilder(2).append(ECQL.toCQL((Filter)f)).append("->").append(d).toString();
                }
                throw new MatchError((Object)tuple2);
            })).mkString(",")).append("]").toString();
        }

        public FilteredExpiryFactory(Seq<Tuple2<Filter, FeatureStateFactory>> delegates) {
            this.delegates = delegates;
            Object object = ((Tuple2)delegates.last())._1();
            IncludeFilter includeFilter = Filter.INCLUDE;
            Predef$.MODULE$.require(!(object != null ? !object.equals(includeFilter) : includeFilter != null), (Function0 & Serializable)() -> "Filter feature state factory requires a fall back Filter.INCLUDE entry");
        }
    }
}

