/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka.index;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.expression.Expression;
import org.locationtech.geomesa.filter.factory.FastFilterFactory$;
import org.locationtech.geomesa.filter.index.SpatialIndexSupport;
import org.locationtech.geomesa.kafka.data.KafkaDataStore;
import org.locationtech.geomesa.kafka.data.KafkaDataStore$;
import org.locationtech.geomesa.kafka.data.KafkaDataStore$ImmediatelyExpireConfig$;
import org.locationtech.geomesa.kafka.data.KafkaDataStore$NeverExpireConfig$;
import org.locationtech.geomesa.kafka.index.KafkaFeatureCache;
import org.locationtech.geomesa.kafka.index.KafkaFeatureCacheImpl;
import org.locationtech.geomesa.kafka.index.KafkaFeatureCacheView;
import org.locationtech.geomesa.kafka.index.KafkaFeatureCacheView$;
import org.locationtech.geomesa.kafka.index.KafkaFeatureCacheWithMetrics;
import org.locationtech.geomesa.memory.cqengine.GeoCQIndexSupport$;
import org.locationtech.geomesa.memory.cqengine.utils.CQIndexType$;
import org.locationtech.geomesa.metrics.core.GeoMesaMetrics;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;

public final class KafkaFeatureCache$
implements LazyLogging {
    public static final KafkaFeatureCache$ MODULE$ = new KafkaFeatureCache$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        KafkaFeatureCache$ kafkaFeatureCache$ = this;
        synchronized (kafkaFeatureCache$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public KafkaFeatureCache apply(SimpleFeatureType sft, KafkaDataStore.IndexConfig config, Seq<KafkaDataStore.LayerView> views, Option<GeoMesaMetrics> metrics) {
        KafkaDataStore.ExpiryTimeConfig expiryTimeConfig = config.expiry();
        KafkaDataStore$ImmediatelyExpireConfig$ kafkaDataStore$ImmediatelyExpireConfig$ = KafkaDataStore$ImmediatelyExpireConfig$.MODULE$;
        if (!(expiryTimeConfig != null ? !expiryTimeConfig.equals(kafkaDataStore$ImmediatelyExpireConfig$) : kafkaDataStore$ImmediatelyExpireConfig$ != null)) {
            return new KafkaFeatureCache.NoOpFeatureCache((Seq<KafkaFeatureCacheView>)((Seq)views.map((Function1 & Serializable)v -> KafkaFeatureCacheView$.MODULE$.empty(v.viewSft()))));
        }
        Option<GeoMesaMetrics> option = metrics;
        if (None$.MODULE$.equals(option)) {
            return new KafkaFeatureCacheImpl(sft, config, views);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            GeoMesaMetrics m = (GeoMesaMetrics)some.value();
            return new KafkaFeatureCacheWithMetrics(sft, config, views, m);
        }
        throw new MatchError(option);
    }

    public Seq<KafkaDataStore.LayerView> apply$default$3() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Option<GeoMesaMetrics> apply$default$4() {
        return None$.MODULE$;
    }

    public KafkaFeatureCache empty(Seq<KafkaDataStore.LayerView> views) {
        return new KafkaFeatureCache.EmptyFeatureCache((Seq<KafkaFeatureCacheView>)((Seq)views.map((Function1 & Serializable)v -> KafkaFeatureCacheView$.MODULE$.empty(v.viewSft()))));
    }

    public Seq<KafkaDataStore.LayerView> empty$default$1() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public KafkaFeatureCache nonIndexing(SimpleFeatureType sft, KafkaDataStore.ExpiryTimeConfig ordering) {
        KafkaDataStore.FilteredExpiryConfig filteredExpiryConfig;
        Seq<Tuple2<String, KafkaDataStore.ExpiryTimeConfig>> filters;
        Serializable event = new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends KafkaDataStore.ExpiryTimeConfig, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof KafkaDataStore.EventTimeConfig) {
                    KafkaDataStore.EventTimeConfig eventTimeConfig = (KafkaDataStore.EventTimeConfig)A1;
                    String exp = eventTimeConfig.expression();
                    boolean bl = eventTimeConfig.ordered();
                    if (bl) {
                        return (B1)exp;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(KafkaDataStore.ExpiryTimeConfig x1) {
                KafkaDataStore.EventTimeConfig eventTimeConfig;
                boolean bl;
                KafkaDataStore.ExpiryTimeConfig expiryTimeConfig = x1;
                return expiryTimeConfig instanceof KafkaDataStore.EventTimeConfig && true == (bl = (eventTimeConfig = (KafkaDataStore.EventTimeConfig)expiryTimeConfig).ordered());
            }
        };
        KafkaDataStore.ExpiryTimeConfig expiryTimeConfig = ordering;
        Object ord = event.isDefinedAt(expiryTimeConfig) ? new Some(event.apply(expiryTimeConfig)) : (expiryTimeConfig instanceof KafkaDataStore.FilteredExpiryConfig && event.isDefinedAt(((Tuple2)(filters = (filteredExpiryConfig = (KafkaDataStore.FilteredExpiryConfig)expiryTimeConfig).expiry()).head())._2()) ? new Some(event.apply(((Tuple2)filters.head())._2())) : None$.MODULE$);
        Option option = ord.map((Function1 & Serializable)x$1 -> FastFilterFactory$.MODULE$.toExpression(sft, x$1));
        if (None$.MODULE$.equals(option)) {
            return new KafkaFeatureCache.NonIndexingFeatureCache();
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Expression exp = (Expression)some.value();
            return new KafkaFeatureCache.NonIndexingEventTimeFeatureCache(exp);
        }
        throw new MatchError((Object)option);
    }

    public KafkaDataStore.ExpiryTimeConfig nonIndexing$default$2() {
        return KafkaDataStore$NeverExpireConfig$.MODULE$;
    }

    public SpatialIndexSupport cqIndexSupport(SimpleFeatureType sft, KafkaDataStore.IndexConfig config) {
        Seq<Tuple2<String, Enumeration.Value>> seq = config.cqAttributes();
        .colon.colon colon2 = new .colon.colon(KafkaDataStore$.MODULE$.CqIndexFlag(), (List)Nil$.MODULE$);
        Seq attributes = !(seq != null ? !seq.equals((Object)colon2) : colon2 != null) ? (Seq)CQIndexType$.MODULE$.getDefinedAttributes(sft).$plus$plus((IterableOnce)Option$.MODULE$.apply((Object)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))).map((Function1 & Serializable)x$2 -> new Tuple2(x$2, (Object)CQIndexType$.MODULE$.GEOMETRY()))) : config.cqAttributes();
        return GeoCQIndexSupport$.MODULE$.apply(sft, attributes, config.resolution().x(), config.resolution().y());
    }

    private KafkaFeatureCache$() {
    }
}

