/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka.index;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.geotools.api.data.FeatureListener;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.IncludeFilter;
import org.locationtech.geomesa.filter.index.BucketIndexSupport$;
import org.locationtech.geomesa.filter.index.SizeSeparatedBucketIndexSupport$;
import org.locationtech.geomesa.filter.index.SpatialIndexSupport;
import org.locationtech.geomesa.kafka.data.KafkaDataStore;
import org.locationtech.geomesa.kafka.index.FeatureStateFactory;
import org.locationtech.geomesa.kafka.index.FeatureStateFactory$;
import org.locationtech.geomesa.kafka.index.KafkaFeatureCache;
import org.locationtech.geomesa.kafka.index.KafkaFeatureCache$;
import org.locationtech.geomesa.kafka.index.KafkaFeatureCacheImpl$;
import org.locationtech.geomesa.kafka.index.KafkaFeatureCacheView;
import org.locationtech.geomesa.kafka.index.KafkaFeatureCacheView$;
import org.locationtech.geomesa.kafka.index.KafkaListeners;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.SpatialIndex;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005g\u0001B\u000e\u001d\u0001\u001dB\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t'\u0002\u0011\t\u0011)A\u0005)\"Aq\f\u0001B\u0001B\u0003%\u0001\rC\u0003m\u0001\u0011\u0005Q\u000eC\u0004s\u0001\t\u0007I\u0011B:\t\u000f\u0005M\u0001\u0001)A\u0005i\"I\u0011Q\u0003\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003O\u0001\u0001\u0015!\u0003\u0002\u001a!I\u0011\u0011\u0006\u0001C\u0002\u0013%\u00111\u0006\u0005\t\u0003g\u0001\u0001\u0015!\u0003\u0002.!I\u0011Q\u0007\u0001C\u0002\u0013\u0005\u0013q\u0007\u0005\t\u0003\u0003\u0002\u0001\u0015!\u0003\u0002:!9\u00111\t\u0001\u0005B\u0005\u0015\u0003bBA+\u0001\u0011\u0005\u0013q\u000b\u0005\b\u0003;\u0002A\u0011IA0\u0011\u001d\t)\u0007\u0001C!\u0003OBq!!\u001b\u0001\t\u0003\nY\u0007C\u0004\u0002j\u0001!\t%a\u001d\t\u000f\u0005\r\u0005\u0001\"\u0011\u0002\u0006\"9\u00111\u0011\u0001\u0005B\u0005=\u0005bBAM\u0001\u0011\u0005\u0013q\r\u0005\b\u00037\u0003A\u0011BAO\u000f%\t\t\u000bHA\u0001\u0012\u0003\t\u0019K\u0002\u0005\u001c9\u0005\u0005\t\u0012AAS\u0011\u0019a\u0007\u0004\"\u0001\u0002(\"I\u0011\u0011\u0016\r\u0012\u0002\u0013\u0005\u00111\u0016\u0002\u0016\u0017\u000647.\u0019$fCR,(/Z\"bG\",\u0017*\u001c9m\u0015\tib$A\u0003j]\u0012,\u0007P\u0003\u0002 A\u0005)1.\u00194lC*\u0011\u0011EI\u0001\bO\u0016|W.Z:b\u0015\t\u0019C%\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001&\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0001F\f\u001a\u0011\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0003\r\u0005s\u0017PU3g!\ty\u0003'D\u0001\u001d\u0013\t\tDDA\tLC\u001a\\\u0017MR3biV\u0014XmQ1dQ\u0016\u0004\"aM\"\u000f\u0005Q\neBA\u001bA\u001d\t1tH\u0004\u00028}9\u0011\u0001(\u0010\b\u0003sqj\u0011A\u000f\u0006\u0003w\u0019\na\u0001\u0010:p_Rt\u0014\"A\u0013\n\u0005\r\"\u0013BA\u0011#\u0013\ty\u0002%\u0003\u0002\u001e=%\u0011!\tH\u0001\u0014\r\u0016\fG/\u001e:f'R\fG/\u001a$bGR|'/_\u0005\u0003\t\u0016\u0013\u0011CR3biV\u0014X-\u0012=qSJ\fG/[8o\u0015\t\u0011E$A\u0002tMR\u0004\"\u0001S)\u000e\u0003%S!AS&\u0002\rMLW\u000e\u001d7f\u0015\taU*A\u0004gK\u0006$XO]3\u000b\u00059{\u0015aA1qS*\u0011\u0001\u000bJ\u0001\tO\u0016|Go\\8mg&\u0011!+\u0013\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0017AB2p]\u001aLw\r\u0005\u0002V9:\u0011a+\u0017\b\u0003k]K!\u0001\u0017\u0010\u0002\t\u0011\fG/Y\u0005\u00035n\u000babS1gW\u0006$\u0015\r^1Ti>\u0014XM\u0003\u0002Y=%\u0011QL\u0018\u0002\f\u0013:$W\r_\"p]\u001aLwM\u0003\u0002[7\u0006QA.Y=feZKWm^:\u0011\u0007\u00054\u0017N\u0004\u0002cI:\u0011\u0011hY\u0005\u0002W%\u0011QMK\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0007NA\u0002TKFT!!\u001a\u0016\u0011\u0005US\u0017BA6_\u0005%a\u0015-_3s-&,w/\u0001\u0004=S:LGO\u0010\u000b\u0005]>\u0004\u0018\u000f\u0005\u00020\u0001!)a\t\u0002a\u0001\u000f\")1\u000b\u0002a\u0001)\"9q\f\u0002I\u0001\u0002\u0004\u0001\u0017!B:uCR,W#\u0001;\u0011\u000bUdh0!\u0004\u000e\u0003YT!a\u001e=\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002zu\u0006!Q\u000f^5m\u0015\u0005Y\u0018\u0001\u00026bm\u0006L!! <\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000fE\u0002\u0000\u0003\u000fqA!!\u0001\u0002\u0004A\u0011\u0011HK\u0005\u0004\u0003\u000bQ\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\n\u0005-!AB*ue&twMC\u0002\u0002\u0006)\u00022aMA\b\u0013\r\t\t\"\u0012\u0002\r\r\u0016\fG/\u001e:f'R\fG/Z\u0001\u0007gR\fG/\u001a\u0011\u0002\u000fM,\b\u000f]8siV\u0011\u0011\u0011\u0004\t\u0005\u00037\t\u0019#\u0004\u0002\u0002\u001e)\u0019Q$a\b\u000b\u0007\u0005\u0005\u0002%\u0001\u0004gS2$XM]\u0005\u0005\u0003K\tiBA\nTa\u0006$\u0018.\u00197J]\u0012,\u0007pU;qa>\u0014H/\u0001\u0005tkB\u0004xN\u001d;!\u0003\u001d1\u0017m\u0019;pef,\"!!\f\u0011\u0007=\ny#C\u0002\u00022q\u00111CR3biV\u0014Xm\u0015;bi\u00164\u0015m\u0019;pef\f\u0001BZ1di>\u0014\u0018\u0010I\u0001\u0006m&,wo]\u000b\u0003\u0003s\u0001B!\u00194\u0002<A\u0019q&!\u0010\n\u0007\u0005}BDA\u000bLC\u001a\\\u0017MR3biV\u0014XmQ1dQ\u00164\u0016.Z<\u0002\rYLWm^:!\u0003\r\u0001X\u000f\u001e\u000b\u0005\u0003\u000f\ni\u0005E\u0002*\u0003\u0013J1!a\u0013+\u0005\u0011)f.\u001b;\t\r1k\u0001\u0019AA(!\rA\u0015\u0011K\u0005\u0004\u0003'J%!D*j[BdWMR3biV\u0014X-\u0001\u0004sK6|g/\u001a\u000b\u0005\u0003\u000f\nI\u0006\u0003\u0004\u0002\\9\u0001\rA`\u0001\u0003S\u0012\fa!\u001a=qSJ,G\u0003BA$\u0003CBq!a\u0019\u0010\u0001\u0004\ti!\u0001\u0007gK\u0006$XO]3Ti\u0006$X-A\u0003dY\u0016\f'\u000f\u0006\u0002\u0002H\u0005!1/\u001b>f)\t\ti\u0007E\u0002*\u0003_J1!!\u001d+\u0005\rIe\u000e\u001e\u000b\u0005\u0003[\n)\bC\u0004\u0002xI\u0001\r!!\u001f\u0002\u0003\u0019\u0004B!a\u001f\u0002\u00005\u0011\u0011Q\u0010\u0006\u0004\u0003Ci\u0015\u0002BAA\u0003{\u0012aAR5mi\u0016\u0014\u0018!B9vKJLH\u0003BAD\u0003\u001b\u0003R!KAE\u0003\u001fJ1!a#+\u0005\u0019y\u0005\u000f^5p]\"1\u00111L\nA\u0002y$B!!%\u0002\u0018B)\u0011-a%\u0002P%\u0019\u0011Q\u00135\u0003\u0011%#XM]1u_JDq!!\t\u0015\u0001\u0004\tI(A\u0003dY>\u001cX-A\u0007de\u0016\fG/Z*vaB|'\u000f\u001e\u000b\u0005\u00033\ty\nC\u0003G-\u0001\u0007q)A\u000bLC\u001a\\\u0017MR3biV\u0014XmQ1dQ\u0016LU\u000e\u001d7\u0011\u0005=B2C\u0001\r))\t\t\u0019+A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\u0003[S3\u0001YAXW\t\t\t\f\u0005\u0003\u00024\u0006uVBAA[\u0015\u0011\t9,!/\u0002\u0013Ut7\r[3dW\u0016$'bAA^U\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0016Q\u0017\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class KafkaFeatureCacheImpl
implements KafkaFeatureCache,
FeatureStateFactory.FeatureExpiration {
    private final KafkaDataStore.IndexConfig config;
    private final ConcurrentHashMap<String, FeatureStateFactory.FeatureState> state;
    private final SpatialIndexSupport support;
    private final FeatureStateFactory factory;
    private final Seq<KafkaFeatureCacheView> views;
    private volatile boolean org$locationtech$geomesa$kafka$index$KafkaListeners$$hasListeners;
    private Set<Tuple2<SimpleFeatureSource, FeatureListener>> org$locationtech$geomesa$kafka$index$KafkaListeners$$listeners;
    private Logger logger;

    public static Seq<KafkaDataStore.LayerView> $lessinit$greater$default$3() {
        return KafkaFeatureCacheImpl$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public void addListener(SimpleFeatureSource source, FeatureListener listener) {
        KafkaListeners.addListener$(this, source, listener);
    }

    @Override
    public void removeListener(SimpleFeatureSource source, FeatureListener listener) {
        KafkaListeners.removeListener$(this, source, listener);
    }

    @Override
    public void fireChange(long timestamp, SimpleFeature feature) {
        KafkaListeners.fireChange$(this, timestamp, feature);
    }

    @Override
    public void fireDelete(long timestamp, String id, Function0<SimpleFeature> removed) {
        KafkaListeners.fireDelete$(this, timestamp, id, removed);
    }

    @Override
    public void fireClear(long timestamp) {
        KafkaListeners.fireClear$(this, timestamp);
    }

    @Override
    public boolean org$locationtech$geomesa$kafka$index$KafkaListeners$$hasListeners() {
        return this.org$locationtech$geomesa$kafka$index$KafkaListeners$$hasListeners;
    }

    @Override
    public void org$locationtech$geomesa$kafka$index$KafkaListeners$$hasListeners_$eq(boolean x$1) {
        this.org$locationtech$geomesa$kafka$index$KafkaListeners$$hasListeners = x$1;
    }

    @Override
    public Set<Tuple2<SimpleFeatureSource, FeatureListener>> org$locationtech$geomesa$kafka$index$KafkaListeners$$listeners() {
        return this.org$locationtech$geomesa$kafka$index$KafkaListeners$$listeners;
    }

    @Override
    public final void org$locationtech$geomesa$kafka$index$KafkaListeners$_setter_$org$locationtech$geomesa$kafka$index$KafkaListeners$$listeners_$eq(Set<Tuple2<SimpleFeatureSource, FeatureListener>> x$1) {
        this.org$locationtech$geomesa$kafka$index$KafkaListeners$$listeners = x$1;
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private ConcurrentHashMap<String, FeatureStateFactory.FeatureState> state() {
        return this.state;
    }

    private SpatialIndexSupport support() {
        return this.support;
    }

    private FeatureStateFactory factory() {
        return this.factory;
    }

    @Override
    public Seq<KafkaFeatureCacheView> views() {
        return this.views;
    }

    @Override
    public void put(SimpleFeature feature) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (feature.getDefaultGeometry() == null) {
            BoxedUnit boxedUnit3;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Null geometry detected for feature {}. Skipping loading into cache.", (Object)feature.getID());
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            return;
        }
        FeatureStateFactory.FeatureState featureState = this.factory().createState(feature);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("{} adding feature {}", new Object[]{featureState.id(), featureState});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        FeatureStateFactory.FeatureState old = this.state().put(featureState.id(), featureState);
        if (old == null) {
            featureState.insertIntoIndex();
            this.views().foreach((Function1 & Serializable)x$1 -> {
                x$1.put(feature);
                return BoxedUnit.UNIT;
            });
        } else if (old.time() <= featureState.time()) {
            BoxedUnit boxedUnit4;
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("{} removing old feature", (Object)featureState.id());
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            old.removeFromIndex();
            featureState.insertIntoIndex();
            this.views().foreach((Function1 & Serializable)view -> {
                KafkaFeatureCacheImpl.$anonfun$put$2(featureState, feature, view);
                return BoxedUnit.UNIT;
            });
        } else {
            BoxedUnit boxedUnit5;
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("{} ignoring out of sequence feature", (Object)featureState.id());
                boxedUnit5 = BoxedUnit.UNIT;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            if (!this.state().replace(featureState.id(), featureState, old)) {
                BoxedUnit boxedUnit6;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("{} detected inconsistent state... spatial index may be incorrect", (Object)featureState.id());
                    boxedUnit6 = BoxedUnit.UNIT;
                } else {
                    boxedUnit6 = BoxedUnit.UNIT;
                }
                old.removeFromIndex();
                this.views().foreach((Function1 & Serializable)x$2 -> {
                    x$2.remove(featureState.id());
                    return BoxedUnit.UNIT;
                });
            }
        }
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Current index size: {}/{}", new Object[]{BoxesRunTime.boxToInteger((int)this.state().size()), BoxesRunTime.boxToInteger((int)this.support().index().size())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public void remove(String id) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("{} removing feature", (Object)id);
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        FeatureStateFactory.FeatureState old = this.state().remove(id);
        if (old != null) {
            old.removeFromIndex();
            this.views().foreach((Function1 & Serializable)x$3 -> {
                x$3.remove(id);
                return BoxedUnit.UNIT;
            });
        }
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Current index size: {}/{}", new Object[]{BoxesRunTime.boxToInteger((int)this.state().size()), BoxesRunTime.boxToInteger((int)this.support().index().size())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public void expire(FeatureStateFactory.FeatureState featureState) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("{} expiring from index", (Object)featureState.id());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.state().remove(featureState.id(), featureState)) {
            featureState.removeFromIndex();
            this.views().foreach((Function1 & Serializable)x$4 -> {
                x$4.remove(featureState.id());
                return BoxedUnit.UNIT;
            });
        }
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Current index size: {}/{}", new Object[]{BoxesRunTime.boxToInteger((int)this.state().size()), BoxesRunTime.boxToInteger((int)this.support().index().size())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public void clear() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Clearing index");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.state().clear();
        this.support().index().clear();
        this.views().foreach((Function1 & Serializable)x$5 -> {
            x$5.clear();
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public int size() {
        return this.state().size();
    }

    @Override
    public int size(Filter f) {
        Filter filter = f;
        IncludeFilter includeFilter = Filter.INCLUDE;
        if (!(filter != null ? !filter.equals(includeFilter) : includeFilter != null)) {
            return this.size();
        }
        return this.query(f).length();
    }

    @Override
    public Option<SimpleFeature> query(String id) {
        return Option$.MODULE$.apply((Object)this.state().get(id)).flatMap((Function1 & Serializable)f -> Option$.MODULE$.apply((Object)f.retrieveFromIndex()));
    }

    @Override
    public Iterator<SimpleFeature> query(Filter filter) {
        return this.support().query(filter);
    }

    @Override
    public void close() {
        this.factory().close();
    }

    private SpatialIndexSupport createSupport(SimpleFeatureType sft) {
        if (this.config.cqAttributes().nonEmpty()) {
            return KafkaFeatureCache$.MODULE$.cqIndexSupport(sft, this.config);
        }
        if (RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))) {
            return BucketIndexSupport$.MODULE$.apply(sft, this.config.resolution().x(), this.config.resolution().y());
        }
        return SizeSeparatedBucketIndexSupport$.MODULE$.apply(sft, this.config.ssiTiers(), (double)this.config.resolution().x() / 360.0, (double)this.config.resolution().y() / 180.0);
    }

    public static final /* synthetic */ void $anonfun$put$2(FeatureStateFactory.FeatureState featureState$1, SimpleFeature feature$1, KafkaFeatureCacheView view) {
        view.remove(featureState$1.id());
        view.put(feature$1);
    }

    public KafkaFeatureCacheImpl(SimpleFeatureType sft, KafkaDataStore.IndexConfig config, Seq<KafkaDataStore.LayerView> layerViews) {
        BoxedUnit boxedUnit;
        this.config = config;
        StrictLogging.$init$((StrictLogging)this);
        KafkaListeners.$init$(this);
        this.state = new ConcurrentHashMap();
        this.support = this.createSupport(sft);
        this.factory = FeatureStateFactory$.MODULE$.apply(sft, (SpatialIndex<SimpleFeature>)this.support().index(), config.expiry(), this, config.executor());
        this.views = (Seq)layerViews.map((Function1 & Serializable)view -> KafkaFeatureCacheView$.MODULE$.apply((KafkaDataStore.LayerView)view, this.createSupport(view.viewSft())));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Initialized KafkaFeatureCache with factory {} and support {}", new Object[]{this.factory(), this.support()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Statics.releaseFence();
    }
}

