/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka.index;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.util.concurrent.ConcurrentHashMap;
import org.geotools.api.data.FeatureListener;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.IncludeFilter;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.features.TransformSimpleFeature;
import org.locationtech.geomesa.filter.index.SpatialIndexSupport;
import org.locationtech.geomesa.kafka.data.KafkaDataStore;
import org.locationtech.geomesa.kafka.index.KafkaFeatureCache;
import org.locationtech.geomesa.kafka.index.KafkaFeatureCacheView$;
import org.locationtech.geomesa.kafka.index.KafkaListeners;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.Transform;
import org.locationtech.jts.geom.Geometry;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\tUaaB\u00193!\u0003\r\t!\u0010\u0005\u0006\u0011\u0002!\t!\u0013\u0005\u0006\u001b\u00021\tA\u0014\u0005\b7\u0002\u0011\r\u0011\"\u0011]\u000f\u0015Q'\u0007#\u0001l\r\u0015\t$\u0007#\u0001m\u0011\u0015iW\u0001\"\u0001o\u0011\u0015yW\u0001\"\u0001q\u0011\u001d\ti\"\u0002C\u0001\u0003?1a!a\t\u0006\u0001\u0005\u0015\u0002\u0002C'\n\u0005\u000b\u0007I\u0011\u0001(\t\u0013\u0005e\u0012B!A!\u0002\u0013y\u0005BB7\n\t\u0003\tYD\u0002\u0004\u0002D\u0015\u0001\u0011Q\t\u0005\n\u001b6\u0011\t\u0011)A\u0005\u001f\u0006B!\"!\u0014\u000e\u0005\u0003\u0005\u000b\u0011BA\b\u0011)\t9\"\u0004B\u0001B\u0003%\u0011\u0011\u0016\u0005\u0007[6!\t!a3\t\u000f\u0005EU\u0002\"\u0011\u0002V\u001a1\u0011\u0011\\\u0003\u0001\u00037D\u0011\"T\n\u0003\u0002\u0003\u0006IaT\u0011\t\u0015\u000553C!A!\u0002\u0013\ty\u0001\u0003\u0006\u0002^N\u0011\t\u0011)A\u0005\u0003?Da!\\\n\u0005\u0002\u0005M\bbBAI'\u0011\u0005\u0013Q \u0004\u0007\u0005\u0003)\u0001Aa\u0001\t\u00135K\"\u0011!Q\u0001\n=\u000b\u0003BCA'3\t\u0005\t\u0015!\u0003\u0002\u0010!Q\u0011qC\r\u0003\u0002\u0003\u0006I!!+\t\u0015\u0005u\u0017D!A!\u0002\u0013\ty\u000e\u0003\u0004n3\u0011\u0005!Q\u0001\u0005\b\u0003#KB\u0011\tB\t\r\u001d\tI%BA\u0001\u0003\u0017B\u0001\"\u0014\u0011\u0003\u0006\u0004%\tA\u0014\u0005\n\u0003s\u0001#\u0011!Q\u0001\n=C!\"!\u0014!\u0005\u0003\u0005\u000b\u0011BA\b\u0011\u0019i\u0007\u0005\"\u0001\u0002P!I\u0011Q\u000b\u0011C\u0002\u0013%\u0011q\u000b\u0005\t\u0003?\u0002\u0003\u0015!\u0003\u0002Z!I\u0011\u0011\r\u0011C\u0002\u0013%\u00111\r\u0005\t\u0003\u001f\u0003\u0003\u0015!\u0003\u0002f!9\u0011\u0011\u0013\u0011\u0005B\u0005M\u0005bBALA\u0011\u0005\u0013\u0011\u0014\u0005\u0007\u0003?\u0003C\u0011I%\t\u000f\u0005\u0005\u0006\u0005\"\u0011\u0002$\"9\u0011\u0011\u0015\u0011\u0005B\u0005\u0015\u0006bBAZA\u0011\u0005\u0013Q\u0017\u0005\b\u0003g\u0003C\u0011IA`\u0011\u0019\tI\r\tC!\u0013\n)2*\u00194lC\u001a+\u0017\r^;sK\u000e\u000b7\r[3WS\u0016<(BA\u001a5\u0003\u0015Ig\u000eZ3y\u0015\t)d'A\u0003lC\u001a\\\u0017M\u0003\u00028q\u00059q-Z8nKN\f'BA\u001d;\u00031awnY1uS>tG/Z2i\u0015\u0005Y\u0014aA8sO\u000e\u00011c\u0001\u0001?\tB\u0011qHQ\u0007\u0002\u0001*\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\u0001\n1\u0011I\\=SK\u001a\u0004\"!\u0012$\u000e\u0003IJ!a\u0012\u001a\u0003#-\u000bgm[1GK\u0006$XO]3DC\u000eDW-\u0001\u0004%S:LG\u000f\n\u000b\u0002\u0015B\u0011qhS\u0005\u0003\u0019\u0002\u0013A!\u00168ji\u0006\u00191O\u001a;\u0016\u0003=\u0003\"\u0001U-\u000e\u0003ES!AU*\u0002\rMLW\u000e\u001d7f\u0015\t!V+A\u0004gK\u0006$XO]3\u000b\u0005Y;\u0016aA1qS*\u0011\u0001LO\u0001\tO\u0016|Go\\8mg&\u0011!,\u0015\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0017!\u0002<jK^\u001cX#A/\u0011\u0007y3\u0017N\u0004\u0002`I:\u0011\u0001mY\u0007\u0002C*\u0011!\rP\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005K!!\u001a!\u0002\u000fA\f7m[1hK&\u0011q\r\u001b\u0002\u0004'\u0016\f(BA3A!\t)\u0005!A\u000bLC\u001a\\\u0017MR3biV\u0014XmQ1dQ\u00164\u0016.Z<\u0011\u0005\u0015+1CA\u0003?\u0003\u0019a\u0014N\\5u}Q\t1.A\u0003baBd\u0017\u0010\u0006\u0003jc\u00065\u0001\"\u0002:\b\u0001\u0004\u0019\u0018\u0001\u0002<jK^\u00042\u0001^A\u0004\u001d\r)\u0018\u0011\u0001\b\u0003mzt!a^?\u000f\u0005adhBA=|\u001d\t\u0001'0C\u0001<\u0013\tI$(\u0003\u00028q%\u0011QGN\u0005\u0003\u007fR\nA\u0001Z1uC&!\u00111AA\u0003\u00039Y\u0015MZ6b\t\u0006$\u0018m\u0015;pe\u0016T!a \u001b\n\t\u0005%\u00111\u0002\u0002\n\u0019\u0006LXM\u001d,jK^TA!a\u0001\u0002\u0006!11g\u0002a\u0001\u0003\u001f\u0001B!!\u0005\u0002\u001a5\u0011\u00111\u0003\u0006\u0004g\u0005U!bAA\fm\u00051a-\u001b7uKJLA!a\u0007\u0002\u0014\t\u00192\u000b]1uS\u0006d\u0017J\u001c3fqN+\b\u000f]8si\u0006)Q-\u001c9usR\u0019\u0011.!\t\t\u000b5C\u0001\u0019A(\u00035-\u000bgm[1GK\u0006$XO]3DC\u000eDW-R7qif4\u0016.Z<\u0014\t%\t9#\u001b\t\u0005\u0003S\t\u0019D\u0004\u0003\u0002,\u0005=bb\u0001<\u0002.%\u00111\u0007N\u0005\u0004\u0003c\u0011\u0014!E&bM.\fg)Z1ukJ,7)Y2iK&!\u0011QGA\u001c\u0005E)U\u000e\u001d;z\r\u0016\fG/\u001e:f\u0007\u0006\u001c\u0007.\u001a\u0006\u0004\u0003c\u0011\u0014\u0001B:gi\u0002\"B!!\u0010\u0002BA\u0019\u0011qH\u0005\u000e\u0003\u0015AQ!\u0014\u0007A\u0002=\u00131dS1gW\u00064U-\u0019;ve\u0016\u001c\u0015m\u00195f\r&dG/\u001a:WS\u0016<8cA\u0007\u0002HA\u0019\u0011q\b\u0011\u0003)\t\u000b7/\u001a$fCR,(/Z\"bG\",g+[3x'\r\u0001c([\u0001\bgV\u0004\bo\u001c:u)\u0019\t9%!\u0015\u0002T!)Q\n\na\u0001\u001f\"9\u0011Q\n\u0013A\u0002\u0005=\u0011!C4f_6Le\u000eZ3y+\t\tI\u0006E\u0002@\u00037J1!!\u0018A\u0005\rIe\u000e^\u0001\u000bO\u0016|W.\u00138eKb\u0004\u0013!B5e\u001b\u0006\u0004XCAA3!!\t9'!\u001e\u0002z\u0005%UBAA5\u0015\u0011\tY'!\u001c\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002p\u0005E\u0014\u0001B;uS2T!!a\u001d\u0002\t)\fg/Y\u0005\u0005\u0003o\nIGA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004B!a\u001f\u0002\u0004:!\u0011QPA@!\t\u0001\u0007)C\u0002\u0002\u0002\u0002\u000ba\u0001\u0015:fI\u00164\u0017\u0002BAC\u0003\u000f\u0013aa\u0015;sS:<'bAAA\u0001B\u0019\u0001+a#\n\u0007\u00055\u0015KA\u0007TS6\u0004H.\u001a$fCR,(/Z\u0001\u0007S\u0012l\u0015\r\u001d\u0011\u0002\u0007A,H\u000fF\u0002K\u0003+Ca\u0001V\u0015A\u0002\u0005%\u0015A\u0002:f[>4X\rF\u0002K\u00037Cq!!(+\u0001\u0004\tI(\u0001\u0002jI\u0006)1\r\\3be\u0006!1/\u001b>f)\t\tI\u0006\u0006\u0003\u0002Z\u0005\u001d\u0006bBA\f[\u0001\u0007\u0011\u0011\u0016\t\u0005\u0003W\u000by+\u0004\u0002\u0002.*\u0019\u0011qC+\n\t\u0005E\u0016Q\u0016\u0002\u0007\r&dG/\u001a:\u0002\u000bE,XM]=\u0015\t\u0005]\u0016Q\u0018\t\u0006\u007f\u0005e\u0016\u0011R\u0005\u0004\u0003w\u0003%AB(qi&|g\u000eC\u0004\u0002\u001e:\u0002\r!!\u001f\u0015\t\u0005\u0005\u0017q\u0019\t\u0006=\u0006\r\u0017\u0011R\u0005\u0004\u0003\u000bD'\u0001C%uKJ\fGo\u001c:\t\u000f\u0005]q\u00061\u0001\u0002*\u0006)1\r\\8tKRA\u0011QZAh\u0003#\f\u0019\u000eE\u0002\u0002@5AQ!T\tA\u0002=Cq!!\u0014\u0012\u0001\u0004\ty\u0001C\u0004\u0002\u0018E\u0001\r!!+\u0015\u0007)\u000b9\u000e\u0003\u0004U%\u0001\u0007\u0011\u0011\u0012\u0002\u001f\u0017\u000647.\u0019$fCR,(/Z\"bG\",GK]1og\u001a|'/\u001c,jK^\u001c2aEA$\u0003)!(/\u00198tM>\u0014Xn\u001d\t\u0006\u007f\u0005\u0005\u0018Q]\u0005\u0004\u0003G\u0004%!B!se\u0006L\b\u0003BAt\u0003_l!!!;\u000b\u0007a\u000bYOC\u0002\u0002nZ\nQ!\u001e;jYNLA!!=\u0002j\nIAK]1og\u001a|'/\u001c\u000b\t\u0003k\f90!?\u0002|B\u0019\u0011qH\n\t\u000b5;\u0002\u0019A(\t\u000f\u00055s\u00031\u0001\u0002\u0010!9\u0011Q\\\fA\u0002\u0005}Gc\u0001&\u0002\u0000\"1A\u000b\u0007a\u0001\u0003\u0013\u0013AeS1gW\u00064U-\u0019;ve\u0016\u001c\u0015m\u00195f\r&dG/\u001a:Ue\u0006t7OZ8s[ZKWm^\n\u00043\u0005\u001dCC\u0003B\u0004\u0005\u0013\u0011YA!\u0004\u0003\u0010A\u0019\u0011qH\r\t\u000b5s\u0002\u0019A(\t\u000f\u00055c\u00041\u0001\u0002\u0010!9\u0011q\u0003\u0010A\u0002\u0005%\u0006bBAo=\u0001\u0007\u0011q\u001c\u000b\u0004\u0015\nM\u0001B\u0002+ \u0001\u0004\tI\t")
public interface KafkaFeatureCacheView
extends KafkaFeatureCache {
    public static KafkaFeatureCacheView empty(SimpleFeatureType sft) {
        return KafkaFeatureCacheView$.MODULE$.empty(sft);
    }

    public static KafkaFeatureCacheView apply(KafkaDataStore.LayerView view, SpatialIndexSupport index) {
        return KafkaFeatureCacheView$.MODULE$.apply(view, index);
    }

    public void org$locationtech$geomesa$kafka$index$KafkaFeatureCacheView$_setter_$views_$eq(Seq<KafkaFeatureCacheView> var1);

    public SimpleFeatureType sft();

    @Override
    public Seq<KafkaFeatureCacheView> views();

    public static void $init$(KafkaFeatureCacheView $this) {
        $this.org$locationtech$geomesa$kafka$index$KafkaFeatureCacheView$_setter_$views_$eq((Seq<KafkaFeatureCacheView>)((Seq)package$.MODULE$.Seq().empty()));
    }

    public static abstract class BaseFeatureCacheView
    implements KafkaFeatureCacheView {
        private final SimpleFeatureType sft;
        private final SpatialIndexSupport support;
        private final int geomIndex;
        private final ConcurrentHashMap<String, SimpleFeature> idMap;
        private Seq<KafkaFeatureCacheView> views;
        private volatile boolean org$locationtech$geomesa$kafka$index$KafkaListeners$$hasListeners;
        private Set<Tuple2<SimpleFeatureSource, FeatureListener>> org$locationtech$geomesa$kafka$index$KafkaListeners$$listeners;
        private Logger logger;

        @Override
        public void addListener(SimpleFeatureSource source, FeatureListener listener) {
            KafkaListeners.addListener$(this, source, listener);
        }

        @Override
        public void removeListener(SimpleFeatureSource source, FeatureListener listener) {
            KafkaListeners.removeListener$(this, source, listener);
        }

        @Override
        public void fireChange(long timestamp, SimpleFeature feature) {
            KafkaListeners.fireChange$(this, timestamp, feature);
        }

        @Override
        public void fireDelete(long timestamp, String id, Function0<SimpleFeature> removed) {
            KafkaListeners.fireDelete$(this, timestamp, id, removed);
        }

        @Override
        public void fireClear(long timestamp) {
            KafkaListeners.fireClear$(this, timestamp);
        }

        @Override
        public Seq<KafkaFeatureCacheView> views() {
            return this.views;
        }

        @Override
        public void org$locationtech$geomesa$kafka$index$KafkaFeatureCacheView$_setter_$views_$eq(Seq<KafkaFeatureCacheView> x$1) {
            this.views = x$1;
        }

        @Override
        public boolean org$locationtech$geomesa$kafka$index$KafkaListeners$$hasListeners() {
            return this.org$locationtech$geomesa$kafka$index$KafkaListeners$$hasListeners;
        }

        @Override
        public void org$locationtech$geomesa$kafka$index$KafkaListeners$$hasListeners_$eq(boolean x$1) {
            this.org$locationtech$geomesa$kafka$index$KafkaListeners$$hasListeners = x$1;
        }

        @Override
        public Set<Tuple2<SimpleFeatureSource, FeatureListener>> org$locationtech$geomesa$kafka$index$KafkaListeners$$listeners() {
            return this.org$locationtech$geomesa$kafka$index$KafkaListeners$$listeners;
        }

        @Override
        public final void org$locationtech$geomesa$kafka$index$KafkaListeners$_setter_$org$locationtech$geomesa$kafka$index$KafkaListeners$$listeners_$eq(Set<Tuple2<SimpleFeatureSource, FeatureListener>> x$1) {
            this.org$locationtech$geomesa$kafka$index$KafkaListeners$$listeners = x$1;
        }

        public Logger logger() {
            return this.logger;
        }

        public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
            this.logger = x$1;
        }

        @Override
        public SimpleFeatureType sft() {
            return this.sft;
        }

        private int geomIndex() {
            return this.geomIndex;
        }

        private ConcurrentHashMap<String, SimpleFeature> idMap() {
            return this.idMap;
        }

        @Override
        public void put(SimpleFeature feature) {
            this.idMap().put(feature.getID(), feature);
            this.support.index().insert((Geometry)feature.getAttribute(this.geomIndex()), feature.getID(), (Object)feature);
        }

        @Override
        public void remove(String id) {
            SimpleFeature feature = this.idMap().remove(id);
            if (feature != null) {
                this.support.index().remove((Geometry)feature.getAttribute(this.geomIndex()), id);
                return;
            }
        }

        @Override
        public void clear() {
            this.idMap().clear();
            this.support.index().clear();
        }

        @Override
        public int size() {
            return this.idMap().size();
        }

        @Override
        public int size(Filter filter) {
            Filter filter2 = filter;
            IncludeFilter includeFilter = Filter.INCLUDE;
            if (!(filter2 != null ? !filter2.equals(includeFilter) : includeFilter != null)) {
                return this.idMap().size();
            }
            return this.query(filter).length();
        }

        @Override
        public Option<SimpleFeature> query(String id) {
            return Option$.MODULE$.apply((Object)this.idMap().get(id));
        }

        @Override
        public Iterator<SimpleFeature> query(Filter filter) {
            return this.support.query(filter);
        }

        @Override
        public void close() {
        }

        public BaseFeatureCacheView(SimpleFeatureType sft, SpatialIndexSupport support) {
            this.sft = sft;
            this.support = support;
            StrictLogging.$init$((StrictLogging)this);
            KafkaListeners.$init$(this);
            KafkaFeatureCacheView.$init$(this);
            this.geomIndex = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
            this.idMap = new ConcurrentHashMap();
            Statics.releaseFence();
        }
    }

    public static class KafkaFeatureCacheEmptyView
    extends KafkaFeatureCache.EmptyFeatureCache
    implements KafkaFeatureCacheView {
        private final SimpleFeatureType sft;
        private Seq<KafkaFeatureCacheView> views;

        @Override
        public Seq<KafkaFeatureCacheView> views() {
            return this.views;
        }

        @Override
        public void org$locationtech$geomesa$kafka$index$KafkaFeatureCacheView$_setter_$views_$eq(Seq<KafkaFeatureCacheView> x$1) {
            this.views = x$1;
        }

        @Override
        public SimpleFeatureType sft() {
            return this.sft;
        }

        public KafkaFeatureCacheEmptyView(SimpleFeatureType sft) {
            this.sft = sft;
            super((Seq<KafkaFeatureCacheView>)((Seq)package$.MODULE$.Seq().empty()));
            KafkaFeatureCacheView.$init$(this);
            Statics.releaseFence();
        }
    }

    public static class KafkaFeatureCacheFilterTransformView
    extends BaseFeatureCacheView {
        private final Filter filter;
        private final Transform[] transforms;

        @Override
        public void put(SimpleFeature feature) {
            if (this.filter.evaluate((Object)feature)) {
                super.put((SimpleFeature)new TransformSimpleFeature(super.sft(), this.transforms, feature));
                return;
            }
        }

        public KafkaFeatureCacheFilterTransformView(SimpleFeatureType sft, SpatialIndexSupport support, Filter filter, Transform[] transforms) {
            this.filter = filter;
            this.transforms = transforms;
            super(sft, support);
        }
    }

    public static class KafkaFeatureCacheFilterView
    extends BaseFeatureCacheView {
        private final Filter filter;

        @Override
        public void put(SimpleFeature feature) {
            if (this.filter.evaluate((Object)feature)) {
                super.put(ScalaSimpleFeature$.MODULE$.wrap(super.sft(), feature));
                return;
            }
        }

        public KafkaFeatureCacheFilterView(SimpleFeatureType sft, SpatialIndexSupport support, Filter filter) {
            this.filter = filter;
            super(sft, support);
        }
    }

    public static class KafkaFeatureCacheTransformView
    extends BaseFeatureCacheView {
        private final Transform[] transforms;

        @Override
        public void put(SimpleFeature feature) {
            super.put((SimpleFeature)new TransformSimpleFeature(super.sft(), this.transforms, feature));
        }

        public KafkaFeatureCacheTransformView(SimpleFeatureType sft, SpatialIndexSupport support, Transform[] transforms) {
            this.transforms = transforms;
            super(sft, support);
        }
    }
}

