/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka.index;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.locationtech.geomesa.kafka.data.KafkaDataStore;
import org.locationtech.geomesa.kafka.index.FeatureStateFactory;
import org.locationtech.geomesa.kafka.index.KafkaFeatureCache;
import org.locationtech.geomesa.kafka.index.KafkaFeatureCacheImpl;
import org.locationtech.geomesa.metrics.core.GeoMesaMetrics;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t}h\u0001B\u001e=\u0001\u001dC\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\t3\u0002\u0011\t\u0011)A\u00055\"A\u0001\u000f\u0001B\u0001B\u0003%\u0011\u000fC\u0005\u0000\u0001\t\u0005\t\u0015!\u0003\u0002\u0002!9\u0011q\u0002\u0001\u0005\u0002\u0005E\u0001\"CA\u000f\u0001\t\u0007I\u0011BA\u0010\u0011!\t\u0019\u0004\u0001Q\u0001\n\u0005\u0005\u0002\"CA\u001b\u0001\t\u0007I\u0011BA\u0010\u0011!\t9\u0004\u0001Q\u0001\n\u0005\u0005\u0002\"CA\u001d\u0001\t\u0007I\u0011BA\u0010\u0011!\tY\u0004\u0001Q\u0001\n\u0005\u0005\u0002\"CA\u001f\u0001\t\u0007I\u0011BA \u0011!\u0011\t\r\u0001Q\u0001\n\u0005\u0005\u0003b\u0002Bb\u0001\u0011\u0005#Q\u0019\u0005\b\u0005\u001f\u0004A\u0011\tBi\u0011\u001d\u0011)\u000f\u0001C!\u0005O<q!!\u0014=\u0011\u0003\tyE\u0002\u0004<y!\u0005\u0011\u0011\u000b\u0005\b\u0003\u001f\u0011B\u0011AA-\r\u0019\tYF\u0005!\u0002^!Q\u00111\u000e\u000b\u0003\u0016\u0004%\t!!\u001c\t\u0015\u0005UDC!E!\u0002\u0013\ty\u0007\u0003\u0006\u0002xQ\u0011)\u001a!C\u0001\u0003sB!\"!:\u0015\u0005#\u0005\u000b\u0011BA>\u0011)\t9\u000f\u0006BK\u0002\u0013\u0005\u0011\u0011\u001e\u0005\u000b\u0003c$\"\u0011#Q\u0001\n\u0005-\bbBA\b)\u0011\u0005\u00111\u001f\u0005\n\u0003{$\u0012\u0011!C\u0001\u0003\u007fD\u0011Ba\u0002\u0015#\u0003%\tA!\u0003\t\u0013\tmA#%A\u0005\u0002\tu\u0001\"\u0003B\u0011)E\u0005I\u0011\u0001B\u0012\u0011%\u00119\u0003FA\u0001\n\u0003\u0012I\u0003C\u0005\u00032Q\t\t\u0011\"\u0001\u0002n!I!1\u0007\u000b\u0002\u0002\u0013\u0005!Q\u0007\u0005\n\u0005\u0003\"\u0012\u0011!C!\u0005\u0007B\u0011B!\u0015\u0015\u0003\u0003%\tAa\u0015\t\u0013\tuC#!A\u0005B\t}\u0003\"\u0003B2)\u0005\u0005I\u0011\tB3\u0011%\u00119\u0007FA\u0001\n\u0003\u0012I\u0007C\u0005\u0003lQ\t\t\u0011\"\u0011\u0003n\u001dI!\u0011\u000f\n\u0002\u0002#\u0005!1\u000f\u0004\n\u00037\u0012\u0012\u0011!E\u0001\u0005kBq!a\u0004+\t\u0003\u0011i\tC\u0005\u0003h)\n\t\u0011\"\u0012\u0003j!I!q\u0012\u0016\u0002\u0002\u0013\u0005%\u0011\u0013\u0005\n\u00053S\u0013\u0011!CA\u00057C\u0011B!++\u0003\u0003%IAa+\u0007\r\t5&\u0003\u0001BX\u0011)\u0011\u0019\f\rB\u0001B\u0003%!Q\u0017\u0005\b\u0003\u001f\u0001D\u0011\u0001B^\u0011\u001d\ti\f\rC!\u0005K2a!a \u0013\u0001\u0005\u0005\u0005bBA\bi\u0011\u0005\u0011Q\u0015\u0005\n\u0003O#$\u0019!C\u0005\u0003SC\u0001\"a/5A\u0003%\u00111\u0016\u0005\b\u0003{#D\u0011IA`\u0011\u001d\t\t\r\u000eC\u0001\u0003\u0007Dq!!15\t\u001b\tiM\u0001\u000fLC\u001a\\\u0017MR3biV\u0014XmQ1dQ\u0016<\u0016\u000e\u001e5NKR\u0014\u0018nY:\u000b\u0005ur\u0014!B5oI\u0016D(BA A\u0003\u0015Y\u0017MZ6b\u0015\t\t%)A\u0004hK>lWm]1\u000b\u0005\r#\u0015\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A#\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001A\u0005CA%K\u001b\u0005a\u0014BA&=\u0005UY\u0015MZ6b\r\u0016\fG/\u001e:f\u0007\u0006\u001c\u0007.Z%na2\f1a\u001d4u!\tqu+D\u0001P\u0015\t\u0001\u0016+\u0001\u0004tS6\u0004H.\u001a\u0006\u0003%N\u000bqAZ3biV\u0014XM\u0003\u0002U+\u0006\u0019\u0011\r]5\u000b\u0005Y#\u0015\u0001C4f_R|w\u000e\\:\n\u0005a{%!E*j[BdWMR3biV\u0014X\rV=qK\u000611m\u001c8gS\u001e\u0004\"aW7\u000f\u0005qSgBA/i\u001d\tqvM\u0004\u0002`M:\u0011\u0001-\u001a\b\u0003C\u0012l\u0011A\u0019\u0006\u0003G\u001a\u000ba\u0001\u0010:p_Rt\u0014\"A#\n\u0005\r#\u0015BA!C\u0013\ty\u0004)\u0003\u0002j}\u0005!A-\u0019;b\u0013\tYG.\u0001\bLC\u001a\\\u0017\rR1uCN#xN]3\u000b\u0005%t\u0014B\u00018p\u0005-Ie\u000eZ3y\u0007>tg-[4\u000b\u0005-d\u0017!\u0002<jK^\u001c\bc\u0001:zy:\u00111O\u001e\b\u0003CRL\u0011!^\u0001\u0006g\u000e\fG.Y\u0005\u0003ob\fq\u0001]1dW\u0006<WMC\u0001v\u0013\tQ8PA\u0002TKFT!a\u001e=\u0011\u0005mk\u0018B\u0001@p\u0005%a\u0015-_3s-&,w/A\u0004nKR\u0014\u0018nY:\u0011\t\u0005\r\u00111B\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005!1m\u001c:f\u0015\ty\b)\u0003\u0003\u0002\u000e\u0005\u0015!AD$f_6+7/Y'fiJL7m]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015\u0005M\u0011QCA\f\u00033\tY\u0002\u0005\u0002J\u0001!)A*\u0002a\u0001\u001b\")\u0011,\u0002a\u00015\")\u0001/\u0002a\u0001c\"1q0\u0002a\u0001\u0003\u0003\tq!\u001e9eCR,7/\u0006\u0002\u0002\"A!\u00111EA\u0018\u001b\t\t)CC\u0002\u0000\u0003OQA!!\u000b\u0002,\u0005A1m\u001c3bQ\u0006dWM\u0003\u0002\u0002.\u0005\u00191m\\7\n\t\u0005E\u0012Q\u0005\u0002\u0006\u001b\u0016$XM]\u0001\tkB$\u0017\r^3tA\u0005A!/Z7pm\u0006d7/A\u0005sK6|g/\u00197tA\u0005YQ\r\u001f9je\u0006$\u0018n\u001c8t\u00031)\u0007\u0010]5sCRLwN\\:!\u0003)!GoZ'fiJL7m]\u000b\u0003\u0003\u0003\u0002b!a\u0011\u0002F\u0005%S\"\u0001=\n\u0007\u0005\u001d\u0003P\u0001\u0004PaRLwN\u001c\t\u0004\u0003\u0017\"bBA%\u0012\u0003qY\u0015MZ6b\r\u0016\fG/\u001e:f\u0007\u0006\u001c\u0007.Z,ji\"lU\r\u001e:jGN\u0004\"!\u0013\n\u0014\u0007I\t\u0019\u0006\u0005\u0003\u0002D\u0005U\u0013bAA,q\n1\u0011I\\=SK\u001a$\"!a\u0014\u0003\u0017\u0011\u000bG/Z'fiJL7m]\n\b)\u0005M\u0013qLA3!\u0011\t\u0019%!\u0019\n\u0007\u0005\r\u0004PA\u0004Qe>$Wo\u0019;\u0011\u0007I\f9'C\u0002\u0002jm\u0014AbU3sS\u0006d\u0017N_1cY\u0016\f\u0011![\u000b\u0003\u0003_\u0002B!a\u0011\u0002r%\u0019\u00111\u000f=\u0003\u0007%sG/\u0001\u0002jA\u0005!A.Y:u+\t\tY\bE\u0002\u0002~Qj\u0011A\u0005\u0002\u000e\u0019\u0006\u001cH\u000fR1uK\u001e\u000bWoZ3\u0014\u000bQ\n\u0019)a%\u0011\t\u0005\u0015\u0015qR\u0007\u0003\u0003\u000fSA!!#\u0002\f\u0006!A.\u00198h\u0015\t\ti)\u0001\u0003kCZ\f\u0017\u0002BAI\u0003\u000f\u0013aa\u00142kK\u000e$\bCBA\u0012\u0003+\u000bI*\u0003\u0003\u0002\u0018\u0006\u0015\"!B$bk\u001e,\u0007\u0003BAN\u0003Ck!!!(\u000b\t\u0005}\u00151R\u0001\u0005kRLG.\u0003\u0003\u0002$\u0006u%\u0001\u0002#bi\u0016$\"!a\u001f\u0002\u000bY\fG.^3\u0016\u0005\u0005-\u0006\u0003BAW\u0003ok!!a,\u000b\t\u0005E\u00161W\u0001\u0007CR|W.[2\u000b\t\u0005U\u0016QT\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA]\u0003_\u0013!\"\u0011;p[&\u001cGj\u001c8h\u0003\u00191\u0018\r\\;fA\u0005Aq-\u001a;WC2,X\r\u0006\u0002\u0002\u001a\u0006I1/\u001a;MCR,7\u000f\u001e\u000b\u0005\u0003\u000b\fY\r\u0005\u0003\u0002D\u0005\u001d\u0017bAAeq\n!QK\\5u\u0011\u001d\t9+\u000fa\u0001\u00033#B!!2\u0002P\"9\u0011q\u0015\u001eA\u0002\u0005E\u0007\u0003BA\"\u0003'L1!!6y\u0005\u0011auN\\4)\u0007i\nI\u000e\u0005\u0003\u0002\\\u0006\u0005XBAAo\u0015\r\ty\u000e_\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAr\u0003;\u0014q\u0001^1jYJ,7-A\u0003mCN$\b%A\u0004mCR,gnY=\u0016\u0005\u0005-\b\u0003BA\u0012\u0003[LA!a<\u0002&\tI\u0001*[:u_\u001e\u0014\u0018-\\\u0001\tY\u0006$XM\\2zAQA\u0011Q_A|\u0003s\fY\u0010E\u0002\u0002~QAq!a\u001b\u001c\u0001\u0004\ty\u0007C\u0004\u0002xm\u0001\r!a\u001f\t\u000f\u0005\u001d8\u00041\u0001\u0002l\u0006!1m\u001c9z)!\t)P!\u0001\u0003\u0004\t\u0015\u0001\"CA69A\u0005\t\u0019AA8\u0011%\t9\b\bI\u0001\u0002\u0004\tY\bC\u0005\u0002hr\u0001\n\u00111\u0001\u0002l\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B\u0006U\u0011\tyG!\u0004,\u0005\t=\u0001\u0003\u0002B\t\u0005/i!Aa\u0005\u000b\t\tU\u0011Q\\\u0001\nk:\u001c\u0007.Z2lK\u0012LAA!\u0007\u0003\u0014\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\u0004\u0016\u0005\u0003w\u0012i!\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t\u0015\"\u0006BAv\u0005\u001b\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B\u0016!\u0011\t)I!\f\n\t\t=\u0012q\u0011\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!q\u0007B\u001f!\u0011\t\u0019E!\u000f\n\u0007\tm\u0002PA\u0002B]fD\u0011Ba\u0010#\u0003\u0003\u0005\r!a\u001c\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011)\u0005\u0005\u0004\u0003H\t5#qG\u0007\u0003\u0005\u0013R1Aa\u0013y\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u001f\u0012IE\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B+\u00057\u0002B!a\u0011\u0003X%\u0019!\u0011\f=\u0003\u000f\t{w\u000e\\3b]\"I!q\b\u0013\u0002\u0002\u0003\u0007!qG\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0003,\t\u0005\u0004\"\u0003B K\u0005\u0005\t\u0019AA8\u0003!A\u0017m\u001d5D_\u0012,GCAA8\u0003!!xn\u0015;sS:<GC\u0001B\u0016\u0003\u0019)\u0017/^1mgR!!Q\u000bB8\u0011%\u0011y\u0004KA\u0001\u0002\u0004\u00119$A\u0006ECR,W*\u001a;sS\u000e\u001c\bcAA?UM)!Fa\u001e\u0003\u0004Ba!\u0011\u0010B@\u0003_\nY(a;\u0002v6\u0011!1\u0010\u0006\u0004\u0005{B\u0018a\u0002:v]RLW.Z\u0005\u0005\u0005\u0003\u0013YHA\tBEN$(/Y2u\rVt7\r^5p]N\u0002BA!\"\u0003\f6\u0011!q\u0011\u0006\u0005\u0005\u0013\u000bY)\u0001\u0002j_&!\u0011\u0011\u000eBD)\t\u0011\u0019(A\u0003baBd\u0017\u0010\u0006\u0005\u0002v\nM%Q\u0013BL\u0011\u001d\tY'\fa\u0001\u0003_Bq!a\u001e.\u0001\u0004\tY\bC\u0004\u0002h6\u0002\r!a;\u0002\u000fUt\u0017\r\u001d9msR!!Q\u0014BS!\u0019\t\u0019%!\u0012\u0003 BQ\u00111\tBQ\u0003_\nY(a;\n\u0007\t\r\u0006P\u0001\u0004UkBdWm\r\u0005\n\u0005Os\u0013\u0011!a\u0001\u0003k\f1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t\u0019IA\u0005TSj,w)Y;hKN)\u0001'a!\u00032B1\u00111EAK\u0003_\nQaY1dQ\u0016\u00042!\u0013B\\\u0013\r\u0011I\f\u0010\u0002\u0012\u0017\u000647.\u0019$fCR,(/Z\"bG\",G\u0003\u0002B_\u0005\u007f\u00032!! 1\u0011\u001d\u0011\u0019L\ra\u0001\u0005k\u000b1\u0002\u001a;h\u001b\u0016$(/[2tA\u0005\u0019\u0001/\u001e;\u0015\t\u0005\u0015'q\u0019\u0005\u0007%:\u0001\rA!3\u0011\u00079\u0013Y-C\u0002\u0003N>\u0013QbU5na2,g)Z1ukJ,\u0017A\u0002:f[>4X\r\u0006\u0003\u0002F\nM\u0007b\u0002Bk\u001f\u0001\u0007!q[\u0001\u0003S\u0012\u0004BA!7\u0003b:!!1\u001cBo!\t\t\u00070C\u0002\u0003`b\fa\u0001\u0015:fI\u00164\u0017\u0002\u0002B\u0018\u0005GT1Aa8y\u0003\u0019)\u0007\u0010]5sKR!\u0011Q\u0019Bu\u0011\u001d\u0011Y\u000f\u0005a\u0001\u0005[\fABZ3biV\u0014Xm\u0015;bi\u0016\u0004BAa<\u0003z:!!\u0011\u001fB{\u001d\ri&1_\u0005\u0003{yJ1Aa>=\u0003M1U-\u0019;ve\u0016\u001cF/\u0019;f\r\u0006\u001cGo\u001c:z\u0013\u0011\u0011YP!@\u0003\u0019\u0019+\u0017\r^;sKN#\u0018\r^3\u000b\u0007\t]H\b")
public class KafkaFeatureCacheWithMetrics
extends KafkaFeatureCacheImpl {
    private final SimpleFeatureType sft;
    private final GeoMesaMetrics metrics;
    private final Meter updates;
    private final Meter removals;
    private final Meter expirations;
    private final Option<DateMetrics> dtgMetrics;

    private Meter updates() {
        return this.updates;
    }

    private Meter removals() {
        return this.removals;
    }

    private Meter expirations() {
        return this.expirations;
    }

    private Option<DateMetrics> dtgMetrics() {
        return this.dtgMetrics;
    }

    @Override
    public void put(SimpleFeature feature) {
        super.put(feature);
        this.updates().mark();
        this.dtgMetrics().foreach((Function1 & Serializable)x0$1 -> {
            KafkaFeatureCacheWithMetrics.$anonfun$put$1(feature, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void remove(String id) {
        super.remove(id);
        this.removals().mark();
    }

    @Override
    public void expire(FeatureStateFactory.FeatureState featureState) {
        super.expire(featureState);
        this.expirations().mark();
    }

    public static final /* synthetic */ DateMetrics $anonfun$dtgMetrics$1(KafkaFeatureCacheWithMetrics $this, int i) {
        LastDateGauge last = (LastDateGauge)$this.metrics.gauge($this.sft.getTypeName(), "dtg.latest", (Function0 & Serializable)() -> new LastDateGauge());
        Histogram latency = $this.metrics.histogram($this.sft.getTypeName(), "dtg.latency.millis");
        return new DateMetrics(i, last, latency);
    }

    public static final /* synthetic */ void $anonfun$put$1(SimpleFeature feature$1, DateMetrics x0$1) {
        DateMetrics dateMetrics = x0$1;
        if (dateMetrics != null) {
            int index = dateMetrics.i();
            LastDateGauge dtg = dateMetrics.last();
            Histogram latency = dateMetrics.latency();
            Date date = (Date)feature$1.getAttribute(index);
            if (date != null) {
                dtg.setLatest(date);
                latency.update(System.currentTimeMillis() - date.getTime());
                return;
            }
            return;
        }
        throw new MatchError((Object)dateMetrics);
    }

    public KafkaFeatureCacheWithMetrics(SimpleFeatureType sft, KafkaDataStore.IndexConfig config, Seq<KafkaDataStore.LayerView> views, GeoMesaMetrics metrics) {
        this.sft = sft;
        this.metrics = metrics;
        super(sft, config, views);
        metrics.gauge(sft.getTypeName(), "index-size", (Function0 & Serializable)() -> new SizeGauge(this));
        this.updates = metrics.meter(sft.getTypeName(), "updates");
        this.removals = metrics.meter(sft.getTypeName(), "removals");
        this.expirations = metrics.meter(sft.getTypeName(), "expirations");
        this.dtgMetrics = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).map((Function1 & Serializable)i -> KafkaFeatureCacheWithMetrics.$anonfun$dtgMetrics$1(this, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static class DateMetrics
    implements Product,
    Serializable {
        private final int i;
        private final LastDateGauge last;
        private final Histogram latency;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public int i() {
            return this.i;
        }

        public LastDateGauge last() {
            return this.last;
        }

        public Histogram latency() {
            return this.latency;
        }

        public DateMetrics copy(int i, LastDateGauge last, Histogram latency) {
            return new DateMetrics(i, last, latency);
        }

        public int copy$default$1() {
            return this.i();
        }

        public LastDateGauge copy$default$2() {
            return this.last();
        }

        public Histogram copy$default$3() {
            return this.latency();
        }

        public String productPrefix() {
            return "DateMetrics";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this.i());
                }
                case 1: {
                    return this.last();
                }
                case 2: {
                    return this.latency();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DateMetrics;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "i";
                }
                case 1: {
                    return "last";
                }
                case 2: {
                    return "latency";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.i());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.last()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.latency()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof DateMetrics)) return false;
            boolean bl = true;
            if (!bl) return false;
            DateMetrics dateMetrics = (DateMetrics)x$1;
            if (this.i() != dateMetrics.i()) return false;
            LastDateGauge lastDateGauge = this.last();
            LastDateGauge lastDateGauge2 = dateMetrics.last();
            if (lastDateGauge == null) {
                if (lastDateGauge2 != null) {
                    return false;
                }
            } else if (!lastDateGauge.equals(lastDateGauge2)) return false;
            Histogram histogram = this.latency();
            Histogram histogram2 = dateMetrics.latency();
            if (histogram == null) {
                if (histogram2 != null) {
                    return false;
                }
            } else if (!histogram.equals(histogram2)) return false;
            if (!dateMetrics.canEqual(this)) return false;
            return true;
        }

        public DateMetrics(int i, LastDateGauge last, Histogram latency) {
            this.i = i;
            this.last = last;
            this.latency = latency;
            Product.$init$((Product)this);
        }
    }

    public static class LastDateGauge
    implements Gauge<Date> {
        private final AtomicLong value = new AtomicLong(0L);

        private AtomicLong value() {
            return this.value;
        }

        public Date getValue() {
            return new Date(this.value().get());
        }

        public void setLatest(Date value) {
            this.setLatest(value.getTime());
        }

        private final void setLatest(long value) {
            long prev;
            while ((prev = this.value().get()) < value && !this.value().compareAndSet(prev, value)) {
            }
        }
    }

    public static class SizeGauge
    implements Gauge<Object> {
        private final KafkaFeatureCache cache;

        public int getValue() {
            return this.cache.size();
        }

        public SizeGauge(KafkaFeatureCache cache) {
            this.cache = cache;
        }
    }
}

