/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka.utils;

import java.io.Serializable;
import java.time.Duration;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.locationtech.geomesa.kafka.consumer.BatchConsumer;
import org.locationtech.geomesa.kafka.utils.GeoMessage;
import org.locationtech.geomesa.kafka.utils.GeoMessageSerializer;
import org.locationtech.geomesa.kafka.versions.RecordVersions$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001daa\u0002\u0007\u000e!\u0003\r\n\u0001\u0007\u0005\u0006?\u00011\t\u0001I\u0004\u0006\u00156A\ta\u0013\u0004\u0006\u00195A\t\u0001\u0014\u0005\u0006\u001b\u000e!\tA\u0014\u0004\u0005\u001f\u000e\u0001\u0001\u000b\u0003\u0005V\u000b\t\u0005\t\u0015!\u0003W\u0011!9WA!A!\u0002\u0013A\u0007\u0002\u00039\u0006\u0005\u0003\u0005\u000b\u0011B9\t\u0011Q,!\u0011!Q\u0001\nUDQ!T\u0003\u0005\u0002YDQaH\u0003\u0005Ru\u00141cR3p\u001b\u0016\u001c8/Y4f!J|7-Z:t_JT!AD\b\u0002\u000bU$\u0018\u000e\\:\u000b\u0005A\t\u0012!B6bM.\f'B\u0001\n\u0014\u0003\u001d9Wm\\7fg\u0006T!\u0001F\u000b\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003Y\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\r\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\r\u0005s\u0017PU3g\u0003\u001d\u0019wN\\:v[\u0016$\"!I\u001e\u0011\u0005\tBdBA\u00126\u001d\t!#G\u0004\u0002&a9\u0011ae\f\b\u0003O9r!\u0001K\u0017\u000f\u0005%bS\"\u0001\u0016\u000b\u0005-:\u0012A\u0002\u001fs_>$h(C\u0001\u0017\u0013\t!R#\u0003\u0002\u0013'%\u0011\u0001#E\u0005\u0003c=\t\u0001bY8ogVlWM]\u0005\u0003gQ\nQBQ1uG\"\u001cuN\\:v[\u0016\u0014(BA\u0019\u0010\u0013\t1t'A\u0006CCR\u001c\u0007NU3tk2$(BA\u001a5\u0013\tI$HA\u0006CCR\u001c\u0007NU3tk2$(B\u0001\u001c8\u0011\u0015a\u0014\u00011\u0001>\u0003\u001d\u0011XmY8sIN\u00042AP\"G\u001d\ty\u0014I\u0004\u0002*\u0001&\tA$\u0003\u0002C7\u00059\u0001/Y2lC\u001e,\u0017B\u0001#F\u0005\r\u0019V-\u001d\u0006\u0003\u0005n\u0001\"a\u0012%\u000e\u00035I!!S\u0007\u0003\u0015\u001d+w.T3tg\u0006<W-A\nHK>lUm]:bO\u0016\u0004&o\\2fgN|'\u000f\u0005\u0002H\u0007M\u00111!G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-\u0013!cR3p\u001b\u0016\u001c8/Y4f\u0007>t7/^7feN\u0011Q!\u0015\t\u0003%Nk\u0011\u0001N\u0005\u0003)R\u0012QBQ1uG\"\u001cuN\\:v[\u0016\u0014\u0018!C2p]N,X.\u001a:t!\rq4i\u0016\t\u00051~\u000b\u0017-D\u0001Z\u0015\t\t$L\u0003\u0002\\9\u000691\r\\5f]R\u001c(B\u0001\t^\u0015\tqV#\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003Af\u0013\u0001bQ8ogVlWM\u001d\t\u00045\t$\u0017BA2\u001c\u0005\u0015\t%O]1z!\tQR-\u0003\u0002g7\t!!)\u001f;f\u0003%1'/Z9vK:\u001c\u0017\u0010\u0005\u0002j]6\t!N\u0003\u0002lY\u0006!A/[7f\u0015\u0005i\u0017\u0001\u00026bm\u0006L!a\u001c6\u0003\u0011\u0011+(/\u0019;j_:\f!b]3sS\u0006d\u0017N_3s!\t9%/\u0003\u0002t\u001b\t!r)Z8NKN\u001c\u0018mZ3TKJL\u0017\r\\5{KJ\f\u0011\u0002\u001d:pG\u0016\u001c8o\u001c:\u0011\u0005\u001d\u0003A#B<zund\bC\u0001=\u0006\u001b\u0005\u0019\u0001\"B+\u000b\u0001\u00041\u0006\"B4\u000b\u0001\u0004A\u0007\"\u00029\u000b\u0001\u0004\t\b\"\u0002;\u000b\u0001\u0004)HCA\u0011\u007f\u0011\u0015a4\u00021\u0001\u0000!\u0011q4)!\u0001\u0011\u000ba\u000b\u0019!Y1\n\u0007\u0005\u0015\u0011L\u0001\bD_:\u001cX/\\3s%\u0016\u001cwN\u001d3")
public interface GeoMessageProcessor {
    public Enumeration.Value consume(Seq<GeoMessage> var1);

    public static class GeoMessageConsumer
    extends BatchConsumer {
        private final GeoMessageSerializer serializer;
        private final GeoMessageProcessor processor;

        public Enumeration.Value consume(Seq<ConsumerRecord<byte[], byte[]>> records) {
            Seq messages = (Seq)records.flatMap((Function1 & Serializable)record -> {
                Iterator iterator;
                try {
                    Map headers = RecordVersions$.MODULE$.getHeaders(record);
                    long timestamp = RecordVersions$.MODULE$.getTimestamp(record);
                    iterator = package$.MODULE$.Iterator().single((Object)$this.serializer.deserialize((byte[])record.key(), (byte[])record.value(), (Map<String, byte[]>)headers, timestamp));
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        BoxedUnit boxedUnit;
                        Throwable e = (Throwable)option.get();
                        if (this.logger().underlying().isErrorEnabled()) {
                            this.logger().underlying().error("Error deserializing message:", e);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        iterator = package$.MODULE$.Iterator().empty();
                    }
                    throw throwable;
                }
                return iterator;
            });
            if (messages.isEmpty()) {
                return BatchConsumer.BatchResult$.MODULE$.Commit();
            }
            return this.processor.consume((Seq<GeoMessage>)messages);
        }

        public GeoMessageConsumer(Seq<Consumer<byte[], byte[]>> consumers, Duration frequency, GeoMessageSerializer serializer, GeoMessageProcessor processor) {
            this.serializer = serializer;
            this.processor = processor;
            super(consumers, frequency);
        }
    }
}

