/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka.utils;

import org.geotools.api.feature.simple.SimpleFeatureType;
import org.locationtech.geomesa.features.SerializationOption;
import org.locationtech.geomesa.features.SerializationOption$;
import org.locationtech.geomesa.features.SerializationType$;
import org.locationtech.geomesa.features.SimpleFeatureSerializer;
import org.locationtech.geomesa.features.avro.AvroFeatureSerializer;
import org.locationtech.geomesa.features.avro.AvroFeatureSerializer$;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer$;
import org.locationtech.geomesa.kafka.utils.GeoMessageSerializer;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.NotImplementedError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Random$;
import scala.util.hashing.MurmurHash3$;

public final class GeoMessageSerializer$ {
    public static final GeoMessageSerializer$ MODULE$ = new GeoMessageSerializer$();
    private static final byte KryoVersion = (byte)2;
    private static final byte AvroVersion = (byte)3;
    private static final String VersionHeader = "v";
    private static final byte[] org$locationtech$geomesa$kafka$utils$GeoMessageSerializer$$Empty = (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte());

    public byte KryoVersion() {
        return KryoVersion;
    }

    public byte AvroVersion() {
        return AvroVersion;
    }

    public String VersionHeader() {
        return VersionHeader;
    }

    public byte[] org$locationtech$geomesa$kafka$utils$GeoMessageSerializer$$Empty() {
        return org$locationtech$geomesa$kafka$utils$GeoMessageSerializer$$Empty;
    }

    public GeoMessageSerializer apply(SimpleFeatureType sft, Enumeration.Value serialization, boolean lazy) {
        return this.apply(sft, serialization, (Set<Enumeration.Value>)(lazy ? (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{SerializationOption$.MODULE$.Lazy()})) : Predef$.MODULE$.Set().empty()));
    }

    public GeoMessageSerializer apply(SimpleFeatureType sft, Enumeration.Value serialization, Set<Enumeration.Value> opts) {
        Tuple2 tuple2;
        Set options = (Set)SerializationOption.SerializationOptions$.MODULE$.builder().withoutId().withUserData().immutable().build().$plus$plus(opts);
        KryoFeatureSerializer kryoSerializer = ((KryoFeatureSerializer.Builder)KryoFeatureSerializer$.MODULE$.builder(sft).opts(options)).build();
        AvroFeatureSerializer avroSerializer = ((AvroFeatureSerializer.Builder)AvroFeatureSerializer$.MODULE$.builder(sft).opts(options)).build();
        Enumeration.Value value = serialization;
        Enumeration.Value value2 = SerializationType$.MODULE$.KRYO();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            tuple2 = new Tuple2((Object)kryoSerializer, (Object)BoxesRunTime.boxToByte((byte)this.KryoVersion()));
        } else {
            Enumeration.Value value4 = SerializationType$.MODULE$.AVRO();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                tuple2 = new Tuple2((Object)avroSerializer, (Object)BoxesRunTime.boxToByte((byte)this.AvroVersion()));
            } else {
                throw new NotImplementedError(new StringBuilder(31).append("Unhandled serialization type '").append(serialization).append("'").toString());
            }
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        SimpleFeatureSerializer serializer = (SimpleFeatureSerializer)tuple22._1();
        byte version = BoxesRunTime.unboxToByte((Object)tuple22._2());
        Tuple2 tuple23 = new Tuple2((Object)serializer, (Object)BoxesRunTime.boxToByte((byte)version));
        SimpleFeatureSerializer serializer2 = (SimpleFeatureSerializer)tuple23._1();
        byte version2 = BoxesRunTime.unboxToByte((Object)tuple23._2());
        return new GeoMessageSerializer(sft, serializer2, kryoSerializer, avroSerializer, version2);
    }

    public Enumeration.Value apply$default$2() {
        return SerializationType$.MODULE$.KRYO();
    }

    public boolean apply$default$3() {
        return false;
    }

    public int partition(int numPartitions, Function0<byte[]> toKey) {
        if (numPartitions < 2) {
            return 0;
        }
        byte[] key = (byte[])toKey.apply();
        if (key != null && key.length > 0) {
            return Math.abs(MurmurHash3$.MODULE$.bytesHash(key, 1007110753)) % numPartitions;
        }
        return Random$.MODULE$.nextInt(numPartitions);
    }

    private GeoMessageSerializer$() {
    }
}

