/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka.tools.ingest;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.util.List;
import org.apache.kafka.clients.producer.Producer;
import org.geotools.data.DataStore;
import org.locationtech.geomesa.kafka.data.KafkaDataStore;
import org.locationtech.geomesa.kafka.tools.KafkaDataStoreCommand;
import org.locationtech.geomesa.kafka.tools.KafkaDataStoreCommand$class;
import org.locationtech.geomesa.kafka.tools.KafkaDataStoreParams$class;
import org.locationtech.geomesa.kafka.tools.ProducerDataStoreParams;
import org.locationtech.geomesa.kafka.tools.ProducerDataStoreParams$class;
import org.locationtech.geomesa.kafka.tools.ingest.KafkaIngestCommand$;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.ConverterConfigParam;
import org.locationtech.geomesa.tools.DataStoreCommand;
import org.locationtech.geomesa.tools.DistributedRunParam;
import org.locationtech.geomesa.tools.InputFilesParam;
import org.locationtech.geomesa.tools.InteractiveCommand;
import org.locationtech.geomesa.tools.OptionalFeatureSpecParam;
import org.locationtech.geomesa.tools.OptionalForceParam;
import org.locationtech.geomesa.tools.OptionalInputFormatParam;
import org.locationtech.geomesa.tools.OptionalTypeNameParam;
import org.locationtech.geomesa.tools.ingest.IngestCommand;
import org.locationtech.geomesa.tools.ingest.LocalConverterIngest;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.classpath.ClassPathUtils$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001B\u0001\u0003\u0001=\u0011!cS1gW\u0006LenZ3ti\u000e{W.\\1oI*\u00111\u0001B\u0001\u0007S:<Wm\u001d;\u000b\u0005\u00151\u0011!\u0002;p_2\u001c(BA\u0004\t\u0003\u0015Y\u0017MZ6b\u0015\tI!\"A\u0004hK>lWm]1\u000b\u0005-a\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001bC\t\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0007]QB$D\u0001\u0019\u0015\t\u0019\u0011D\u0003\u0002\u0006\u0011%\u00111\u0004\u0007\u0002\u000e\u0013:<Wm\u001d;D_6l\u0017M\u001c3\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}1\u0011\u0001\u00023bi\u0006L!!\t\u0010\u0003\u001d-\u000bgm[1ECR\f7\u000b^8sKB\u00111\u0005J\u0007\u0002\t%\u0011Q\u0005\u0002\u0002\u0016\u0017\u000647.\u0019#bi\u0006\u001cFo\u001c:f\u0007>lW.\u00198e\u0011\u00159\u0003\u0001\"\u0001)\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006\u0005\u0002+\u00015\t!\u0001C\u0004-\u0001\t\u0007I\u0011I\u0017\u0002\rA\f'/Y7t+\u0005q\u0003CA\u0018G\u001d\t\u0001tH\u0004\u00022}9\u0011!'\u0010\b\u0003gqr!\u0001N\u001e\u000f\u0005URdB\u0001\u001c:\u001b\u00059$B\u0001\u001d\u000f\u0003\u0019a$o\\8u}%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005\r!q!\u0002!\u0003\u0011\u0003\t\u0015AE&bM.\f\u0017J\\4fgR\u001cu.\\7b]\u0012\u0004\"A\u000b\"\u0007\u000b\u0005\u0011\u0001\u0012A\"\u0014\u0005\t\u0003\u0002\"B\u0014C\t\u0003)E#A!\u0007\t\u001d\u0013\u0005\u0001\u0013\u0002\u0012\u0017\u000647.Y%oO\u0016\u001cH\u000fU1sC6\u001c8\u0003\u0002$\u0011\u0013R\u0003\"AS)\u000f\u0005-{eB\u0001'O\u001d\t\u0019T*\u0003\u0002\u0006\u0011%\u00111!G\u0005\u0003!b\tQ\"\u00138hKN$8i\\7nC:$\u0017B\u0001*T\u00051IenZ3tiB\u000b'/Y7t\u0015\t\u0001\u0006\u0004\u0005\u0002$+&\u0011a\u000b\u0002\u0002\u0018!J|G-^2fe\u0012\u000bG/Y*u_J,\u0007+\u0019:b[NDQa\n$\u0005\u0002a#\u0012!\u0017\t\u00035\u001ak\u0011A\u0011\u0005\b9\u001a\u0003\r\u0011\"\u0001^\u0003\u0015!W\r\\1z+\u0005q\u0006CA0e\u001b\u0005\u0001'BA1c\u0003!!WO]1uS>t'BA2\u0013\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003K\u0002\u0014\u0001\u0002R;sCRLwN\u001c\u0005\bO\u001a\u0003\r\u0011\"\u0001i\u0003%!W\r\\1z?\u0012*\u0017\u000f\u0006\u0002jYB\u0011\u0011C[\u0005\u0003WJ\u0011A!\u00168ji\"9QNZA\u0001\u0002\u0004q\u0016a\u0001=%c!1qN\u0012Q!\ny\u000ba\u0001Z3mCf\u0004\u0003f\u00038rwr|\u0018\u0011AA\u0003\u0003\u000f\u0001\"A]=\u000e\u0003MT!\u0001^;\u0002\u0015)\u001cw.\\7b]\u0012,'O\u0003\u0002wo\u0006)!-Z;ti*\t\u00010A\u0002d_6L!A_:\u0003\u0013A\u000b'/Y7fi\u0016\u0014\u0018!\u00028b[\u0016\u001cH&A?\"\u0003y\fq!L\u0017eK2\f\u00170A\u0006eKN\u001c'/\u001b9uS>t\u0017EAA\u0002\u0003!\u000b%\u000f^5gS\u000eL\u0017\r\u001c\u0011eK2\f\u0017\u0010I5og\u0016\u0014H/\u001a3!E\u0016$x/Z3oA5,7o]1hKNd\u0003%Y:!C\u0002\"WO]1uS>t\u0007\u0005K3/O:\u0002s%\r\u00191[N<\u0013&A\u0005d_:4XM\u001d;fe\u000e\u0012\u0011\u0011\u0002\t\u0005\u0003\u0017\tIB\u0004\u0003\u0002\u000e\u0005Mab\u0001'\u0002\u0010%\u0019\u0011\u0011C\r\u0002\u000bU$\u0018\u000e\\:\n\t\u0005U\u0011qC\u0001\u0014!\u0006\u0014\u0018-\\3uKJ\u001cuN\u001c<feR,'o\u001d\u0006\u0004\u0003#I\u0012\u0002BA\u000e\u0003;\u0011\u0011\u0003R;sCRLwN\\\"p]Z,'\u000f^3s\u0015\u0011\t)\"a\u0006)\u000f\u0019\u000b\t#a\n\u0002*A\u0019!/a\t\n\u0007\u0005\u00152O\u0001\u0006QCJ\fW.\u001a;feN\f!cY8n[\u0006tG\rR3tGJL\u0007\u000f^5p]\u0006\u0012\u00111F\u00011\u0013:<Wm\u001d;0G>tg/\u001a:uAY\f'/[8vg\u00022\u0017\u000e\\3!M>\u0014X.\u0019;tA%tGo\u001c\u0011HK>lUm]1\t\u000f\u0005=\u0002\u0001)A\u0005]\u00059\u0001/\u0019:b[N\u0004\u0003\"CA\u001a\u0001\t\u0007I\u0011IA\u001b\u0003-a\u0017N\u00196beN4\u0015\u000e\\3\u0016\u0005\u0005]\u0002\u0003BA\u001d\u0003\u007fq1!EA\u001e\u0013\r\tiDE\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00131\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005u\"\u0003\u0003\u0005\u0002H\u0001\u0001\u000b\u0011BA\u001c\u00031a\u0017N\u00196beN4\u0015\u000e\\3!\u0011\u001d\tY\u0005\u0001C!\u0003\u001b\nA\u0002\\5cU\u0006\u00148\u000fU1uQN,\"!a\u0014\u0011\r\u0005E\u00131LA1\u001d\u0011\t\u0019&a\u0016\u000f\u0007Y\n)&C\u0001\u0014\u0013\r\tIFE\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti&a\u0018\u0003\u0011%#XM]1u_JT1!!\u0017\u0013!\u0015\t\u00121MA4\u0013\r\t)G\u0005\u0002\n\rVt7\r^5p]B\u0002b!!\u0015\u0002j\u00055\u0014\u0002BA6\u0003?\u00121aU3r!\u0011\ty'!\u001f\u000e\u0005\u0005E$\u0002BA:\u0003k\n!![8\u000b\u0005\u0005]\u0014\u0001\u00026bm\u0006LA!a\u001f\u0002r\t!a)\u001b7f\u0011\u001d\ty\b\u0001C)\u0003\u0003\u000bAb\u0019:fCR,\u0017J\\4fgR$\"\"a!\u0002\u0010\u0006%\u0016\u0011YAj!\u0011\t))a#\u000e\u0005\u0005\u001d%\u0002BAE\u0003k\nA\u0001\\1oO&!\u0011QRAD\u0005!\u0011VO\u001c8bE2,\u0007\u0002CAI\u0003{\u0002\r!a%\u0002\t5|G-\u001a\t\u0005\u0003+\u000b\u0019K\u0004\u0003\u0002\u0018\u0006ueb\u0001'\u0002\u001a&\u0019\u00111T\r\u0002'\u0011K7\u000f\u001e:jEV$X\r\u001a*v]B\u000b'/Y7\n\t\u0005}\u0015\u0011U\u0001\t%VtWj\u001c3fg*\u0019\u00111T\r\n\t\u0005\u0015\u0016q\u0015\u0002\b%VtWj\u001c3f\u0015\u0011\ty*!)\t\u0011\u0005-\u0016Q\u0010a\u0001\u0003[\u000b1a\u001d4u!\u0011\ty+!0\u000e\u0005\u0005E&\u0002BAZ\u0003k\u000baa]5na2,'\u0002BA\\\u0003s\u000bqAZ3biV\u0014XMC\u0002\u0002<2\tqa\u001c9f]\u001eL7/\u0003\u0003\u0002@\u0006E&!E*j[BdWMR3biV\u0014X\rV=qK\"A\u0011QAA?\u0001\u0004\t\u0019\r\u0005\u0003\u0002F\u0006=WBAAd\u0015\u0011\tI-a3\u0002\r\r|gNZ5h\u0015\r\tim^\u0001\tif\u0004Xm]1gK&!\u0011\u0011[Ad\u0005\u0019\u0019uN\u001c4jO\"A\u0011Q[A?\u0001\u0004\t9.\u0001\u0004j]B,Ho\u001d\t\u0007\u0003#\nI'a\u000e")
public class KafkaIngestCommand
implements IngestCommand<KafkaDataStore>,
KafkaDataStoreCommand {
    private final KafkaIngestParams params;
    private final String libjarsFile;
    private final String name;
    private final Logger logger;
    private Object org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    private volatile boolean bitmap$0;

    @Override
    public Map<String, String> connection() {
        return KafkaDataStoreCommand$class.connection(this);
    }

    public String name() {
        return this.name;
    }

    public void org$locationtech$geomesa$tools$ingest$IngestCommand$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    public void execute() {
        IngestCommand.class.execute((IngestCommand)this);
    }

    private Logger logger$lzycompute() {
        KafkaIngestCommand kafkaIngestCommand = this;
        synchronized (kafkaIngestCommand) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Object org$locationtech$geomesa$tools$InteractiveCommand$$_console() {
        return this.org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    }

    public void org$locationtech$geomesa$tools$InteractiveCommand$$_console_$eq(Object x$1) {
        this.org$locationtech$geomesa$tools$InteractiveCommand$$_console = x$1;
    }

    public Object console() {
        return InteractiveCommand.class.console((InteractiveCommand)this);
    }

    public void setConsole(Object c) {
        InteractiveCommand.class.setConsole((InteractiveCommand)this, (Object)c);
    }

    public <T> T withDataStore(Function1<KafkaDataStore, T> method) throws ParameterException {
        return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return DataStoreCommand.class.loadDataStore((DataStoreCommand)this);
    }

    @Override
    public KafkaIngestParams params() {
        return this.params;
    }

    public String libjarsFile() {
        return this.libjarsFile;
    }

    public Iterator<Function0<Seq<File>>> libjarsPaths() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<File> apply() {
                return ClassPathUtils$.MODULE$.getJarsFromEnvironment("GEOMESA_KAFKA_HOME");
            }
        }, new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<File> apply() {
                return ClassPathUtils$.MODULE$.getJarsFromEnvironment("KAFKA_HOME");
            }
        }, new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<File> apply() {
                return ClassPathUtils$.MODULE$.getJarsFromClasspath(KafkaDataStore.class);
            }
        }, new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<File> apply() {
                return ClassPathUtils$.MODULE$.getJarsFromClasspath(Producer.class);
            }
        }}));
    }

    public Runnable createIngest(Enumeration.Value mode, SimpleFeatureType sft, Config converter, Seq<String> inputs) {
        block4: {
            Runnable runnable;
            block3: {
                long delay;
                block2: {
                    delay = this.params().delay().toMillis();
                    if (delay > 0L) break block2;
                    runnable = IngestCommand.class.createIngest((IngestCommand)this, (Enumeration.Value)mode, (SimpleFeatureType)sft, (Config)converter, inputs);
                    break block3;
                }
                Enumeration.Value value = mode;
                Enumeration.Value value2 = DistributedRunParam.RunModes$.MODULE$.Local();
                if (value != null ? !value.equals(value2) : value2 != null) break block4;
                Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Inserting delay of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params().delay()})));
                runnable = new LocalConverterIngest(this, sft, converter, inputs, delay){
                    public final long delay$1;

                    public CloseableIterator<SimpleFeature> features(CloseableIterator<SimpleFeature> iter) {
                        return iter.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$1 $outer;

                            public final SimpleFeature apply(SimpleFeature f) {
                                Thread.sleep(this.$outer.delay$1);
                                return f;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.delay$1 = delay$1;
                        super($outer.connection(), sft$1, converter$1, inputs$1, Predef$.MODULE$.Integer2int($outer.params().threads()));
                    }
                };
            }
            return runnable;
        }
        throw new ParameterException("Delay is only supported for local ingest");
    }

    public KafkaIngestCommand() {
        DataStoreCommand.class.$init$((DataStoreCommand)this);
        InteractiveCommand.class.$init$((InteractiveCommand)this);
        LazyLogging.class.$init$((LazyLogging)this);
        IngestCommand.class.$init$((IngestCommand)this);
        KafkaDataStoreCommand$class.$init$(this);
        this.params = new KafkaIngestParams();
        this.libjarsFile = "org/locationtech/geomesa/kafka/tools/ingest-libjars.list";
    }

    @Parameters(commandDescription="Ingest/convert various file formats into GeoMesa")
    public static class KafkaIngestParams
    implements IngestCommand.IngestParams,
    ProducerDataStoreParams {
        @Parameter(names={"--delay"}, description="Artificial delay inserted between messages, as a duration (e.g. '100ms')", converter=ParameterConverters.DurationConverter.class)
        private Duration delay;
        @Parameter(names={"--replication"}, description="Replication factor for Kafka topic")
        private int replication;
        @Parameter(names={"--partitions"}, description="Number of partitions for the Kafka topic")
        private int partitions;
        private final int numConsumers;
        private final Duration readBack;
        private final boolean fromBeginning;
        @Parameter(names={"-b", "--brokers"}, description="Brokers (host:port, comma separated)", required=true)
        private String brokers;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)", required=true)
        private String zookeepers;
        @Parameter(names={"-p", "--zkpath"}, description="Zookeeper path where feature schemas are saved")
        private String zkPath;
        @Parameter(names={"-t", "--threads"}, description="Number of threads if using local ingest")
        private Integer threads;
        @Parameter(names={"--split-max-size"}, description="Maximum size of a split in bytes (distributed jobs)")
        private Integer maxSplitSize;
        @Parameter(names={"--src-list"}, description="Input files are text files with lists of files, one per line, to ingest.")
        private boolean srcList;
        @Parameter(names={"--no-tracking"}, description="Return immediately after submitting ingest job (distributed jobs)")
        private boolean noWaitForCompletion;
        @Parameter(names={"--run-mode"}, description="Run locally or on a cluster", required=false, converter=DistributedRunParam.ModeConverter.class)
        private Enumeration.Value mode;
        @Parameter(names={"--input-format"}, description="File format of input files (shp, csv, tsv, avro, etc). Optional, auto-detection will be attempted")
        private String format;
        @Parameter(description="<file>...")
        private List<String> files;
        @Parameter(names={"-C", "--converter"}, description="GeoMesa converter specification as a config string, file name, or name of an available converter")
        private String config;
        @Parameter(names={"--converter-error-mode"}, description="Override the converter error mode - 'skip-bad-records' or 'raise-errors'", converter=ParameterConverters.ErrorModeConverter.class)
        private Enumeration.Value errorMode;
        @Parameter(names={"--force"}, description="Force execution without prompt")
        private boolean force;
        @Parameter(names={"-s", "--spec"}, description="SimpleFeatureType specification as a GeoTools spec string, SFT config, or file with either")
        private String spec;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate")
        private String featureName;

        @Override
        public int replication() {
            return this.replication;
        }

        @Override
        @TraitSetter
        public void replication_$eq(int x$1) {
            this.replication = x$1;
        }

        @Override
        public int partitions() {
            return this.partitions;
        }

        @Override
        @TraitSetter
        public void partitions_$eq(int x$1) {
            this.partitions = x$1;
        }

        @Override
        public int numConsumers() {
            return this.numConsumers;
        }

        @Override
        public Duration readBack() {
            return this.readBack;
        }

        @Override
        public boolean fromBeginning() {
            return this.fromBeginning;
        }

        @Override
        public void org$locationtech$geomesa$kafka$tools$ProducerDataStoreParams$_setter_$numConsumers_$eq(int x$1) {
            this.numConsumers = x$1;
        }

        @Override
        public void org$locationtech$geomesa$kafka$tools$ProducerDataStoreParams$_setter_$readBack_$eq(Duration x$1) {
            this.readBack = x$1;
        }

        @Override
        public void org$locationtech$geomesa$kafka$tools$ProducerDataStoreParams$_setter_$fromBeginning_$eq(boolean x$1) {
            this.fromBeginning = x$1;
        }

        @Override
        public String brokers() {
            return this.brokers;
        }

        @Override
        @TraitSetter
        public void brokers_$eq(String x$1) {
            this.brokers = x$1;
        }

        @Override
        public String zookeepers() {
            return this.zookeepers;
        }

        @Override
        @TraitSetter
        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        @Override
        public String zkPath() {
            return this.zkPath;
        }

        @Override
        @TraitSetter
        public void zkPath_$eq(String x$1) {
            this.zkPath = x$1;
        }

        public Integer threads() {
            return this.threads;
        }

        public void threads_$eq(Integer x$1) {
            this.threads = x$1;
        }

        public Integer maxSplitSize() {
            return this.maxSplitSize;
        }

        public void maxSplitSize_$eq(Integer x$1) {
            this.maxSplitSize = x$1;
        }

        public boolean srcList() {
            return this.srcList;
        }

        public void srcList_$eq(boolean x$1) {
            this.srcList = x$1;
        }

        public boolean noWaitForCompletion() {
            return this.noWaitForCompletion;
        }

        public void noWaitForCompletion_$eq(boolean x$1) {
            this.noWaitForCompletion = x$1;
        }

        public boolean waitForCompletion() {
            return IngestCommand.IngestParams.class.waitForCompletion((IngestCommand.IngestParams)this);
        }

        public Enumeration.Value mode() {
            return this.mode;
        }

        public void mode_$eq(Enumeration.Value x$1) {
            this.mode = x$1;
        }

        public String format() {
            return this.format;
        }

        public void format_$eq(String x$1) {
            this.format = x$1;
        }

        public List<String> files() {
            return this.files;
        }

        public void files_$eq(List<String> x$1) {
            this.files = x$1;
        }

        public String config() {
            return this.config;
        }

        public void config_$eq(String x$1) {
            this.config = x$1;
        }

        public Enumeration.Value errorMode() {
            return this.errorMode;
        }

        public void errorMode_$eq(Enumeration.Value x$1) {
            this.errorMode = x$1;
        }

        public boolean force() {
            return this.force;
        }

        public void force_$eq(boolean x$1) {
            this.force = x$1;
        }

        public String spec() {
            return this.spec;
        }

        public void spec_$eq(String x$1) {
            this.spec = x$1;
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        public Duration delay() {
            return this.delay;
        }

        public void delay_$eq(Duration x$1) {
            this.delay = x$1;
        }

        public KafkaIngestParams() {
            OptionalTypeNameParam.class.$init$((OptionalTypeNameParam)this);
            OptionalFeatureSpecParam.class.$init$((OptionalFeatureSpecParam)this);
            OptionalForceParam.class.$init$((OptionalForceParam)this);
            ConverterConfigParam.class.$init$((ConverterConfigParam)this);
            InputFilesParam.class.$init$((InputFilesParam)this);
            OptionalInputFormatParam.class.$init$((OptionalInputFormatParam)this);
            DistributedRunParam.class.$init$((DistributedRunParam)this);
            IngestCommand.IngestParams.class.$init$((IngestCommand.IngestParams)this);
            KafkaDataStoreParams$class.$init$(this);
            ProducerDataStoreParams$class.$init$(this);
            this.delay = Duration$.MODULE$.Zero();
        }
    }
}

