/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka.tools.export;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.validators.PositiveInteger;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.mapreduce.Job;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListener;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureStore;
import org.locationtech.geomesa.features.TransformSimpleFeature;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.kafka.data.KafkaDataStore;
import org.locationtech.geomesa.kafka.data.KafkaDataStore$;
import org.locationtech.geomesa.kafka.tools.ConsumerDataStoreParams;
import org.locationtech.geomesa.kafka.tools.ConsumerDataStoreParams$class;
import org.locationtech.geomesa.kafka.tools.KafkaDataStoreCommand;
import org.locationtech.geomesa.kafka.tools.KafkaDataStoreCommand$KafkaDistributedCommand$class;
import org.locationtech.geomesa.kafka.tools.KafkaDataStoreCommand$class;
import org.locationtech.geomesa.kafka.tools.KafkaDataStoreParams$class;
import org.locationtech.geomesa.kafka.utils.KafkaFeatureEvent;
import org.locationtech.geomesa.tools.DistributedRunParam;
import org.locationtech.geomesa.tools.OptionalCqlFilterParam;
import org.locationtech.geomesa.tools.OptionalForceParam;
import org.locationtech.geomesa.tools.QueryHintsParams;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.formats.ExportFormat;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.utils.NoopParameterSplitter;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.geotools.Transform;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.TraitSetter;
import scala.sys.package$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tEb\u0001B\u0001\u0003\u0001=\u0011!cS1gW\u0006,\u0005\u0010]8si\u000e{W.\\1oI*\u00111\u0001B\u0001\u0007Kb\u0004xN\u001d;\u000b\u0005\u00151\u0011!\u0002;p_2\u001c(BA\u0004\t\u0003\u0015Y\u0017MZ6b\u0015\tI!\"A\u0004hK>lWm]1\u000b\u0005-a\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001\u0002\u0004\n\t\u0003#Yi\u0011A\u0005\u0006\u0003'Q\tA\u0001\\1oO*\tQ#\u0001\u0003kCZ\f\u0017BA\f\u0013\u0005\u0019y%M[3diB\u0019\u0011\u0004\b\u0010\u000e\u0003iQ!aA\u000e\u000b\u0005\u0015A\u0011BA\u000f\u001b\u00055)\u0005\u0010]8si\u000e{W.\\1oIB\u0011qDI\u0007\u0002A)\u0011\u0011EB\u0001\u0005I\u0006$\u0018-\u0003\u0002$A\tq1*\u00194lC\u0012\u000bG/Y*u_J,\u0007CA\u00136\u001d\t13G\u0004\u0002(e9\u0011\u0001&\r\b\u0003SAr!AK\u0018\u000f\u0005-rS\"\u0001\u0017\u000b\u00055r\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!\u0001\u000e\u0003\u0002+-\u000bgm[1ECR\f7\u000b^8sK\u000e{W.\\1oI&\u0011ag\u000e\u0002\u0018\u0017\u000647.\u0019#jgR\u0014\u0018NY;uK\u0012\u001cu.\\7b]\u0012T!\u0001\u000e\u0003\t\u000be\u0002A\u0011\u0001\u001e\u0002\rqJg.\u001b;?)\u0005Y\u0004C\u0001\u001f\u0001\u001b\u0005\u0011\u0001b\u0002 \u0001\u0005\u0004%\teP\u0001\u0007a\u0006\u0014\u0018-\\:\u0016\u0003\u0001\u0003\"!Q)\u000f\u0005\t#eB\u0001\u0014D\u0013\t\u0019AaB\u0003F\u0005!\u0005a)\u0001\nLC\u001a\\\u0017-\u0012=q_J$8i\\7nC:$\u0007C\u0001\u001fH\r\u0015\t!\u0001#\u0001I'\t9\u0015\n\u0005\u0002K\u001b6\t1JC\u0001M\u0003\u0015\u00198-\u00197b\u0013\tq5J\u0001\u0004B]f\u0014VM\u001a\u0005\u0006s\u001d#\t\u0001\u0015\u000b\u0002\r\u001a!!k\u0012\u0001T\u0005UY\u0015MZ6b\u000bb\u0004xN\u001d;QCJ\fW.\u001a;feN\u001cR!U%U1r\u0003\"!\u0016,\u000e\u0003\u0011I!a\u0016\u0003\u0003/\r{gn];nKJ$\u0015\r^1Ti>\u0014X\rU1sC6\u001c\bCA-[\u001b\u0005Y\u0012BA.\u001c\u0005U\u0011V-];je\u0016$G+\u001f9f\u001d\u0006lW\rU1sC6\u0004\"!\u00183\u000f\u0005y\u0013gBA0b\u001d\tA\u0003-\u0003\u0002\u0006\u0011%\u00111aG\u0005\u0003Gj\tQ\"\u0012=q_J$8i\\7nC:$\u0017BA3g\u00051)\u0005\u0010]8siB\u000b'/Y7t\u0015\t\u0019'\u0004C\u0003:#\u0012\u0005\u0001\u000eF\u0001j!\tQ\u0017+D\u0001HQ\u0011\tFN^<\u0011\u00055$X\"\u00018\u000b\u0005=\u0004\u0018A\u00036d_6l\u0017M\u001c3fe*\u0011\u0011O]\u0001\u0006E\u0016,8\u000f\u001e\u0006\u0002g\u0006\u00191m\\7\n\u0005Ut'A\u0003)be\u0006lW\r^3sg\u0006\u00112m\\7nC:$G)Z:de&\u0004H/[8oC\u0005A\u0018AK#ya>\u0014H\u000f\t4fCR,(/Z:!MJ|W\u000eI1!\u000f\u0016|W*Z:bA-\u000bgm[1!i>\u0004\u0018n\u0019\u0004\u0005u\u001e\u00031PA\u000bFqB|'\u000f\u001e$fCR,(/\u001a'jgR,g.\u001a:\u0014\u0007e\u0004B\u0010E\u0002~\u0003\u0007i\u0011A \u0006\u0003C}T1!!\u0001\r\u0003!9Wm\u001c;p_2\u001c\u0018bAA\u0003}\nya)Z1ukJ,G*[:uK:,'\u000f\u0003\u0006\u0002\ne\u0014\t\u0011)A\u0005\u0003\u0017\t1a\u001d4u!\u0011\ti!a\u0007\u000e\u0005\u0005=!\u0002BA\t\u0003'\taa]5na2,'\u0002BA\u000b\u0003/\tqAZ3biV\u0014XMC\u0002\u0002\u001a1\tqa\u001c9f]\u001eL7/\u0003\u0003\u0002\u001e\u0005=!!E*j[BdWMR3biV\u0014X\rV=qK\"Q\u0011\u0011E=\u0003\u0002\u0003\u0006I!a\t\u0002\r\u0019LG\u000e^3s!\u0015Q\u0015QEA\u0015\u0013\r\t9c\u0013\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005-\u0012qF\u0007\u0003\u0003[QA!!\t\u0002\u0018%!\u0011\u0011GA\u0017\u0005\u00191\u0015\u000e\u001c;fe\"Q\u0011QG=\u0003\u0002\u0003\u0006I!a\u000e\u0002\u0013Q\u0014\u0018M\\:g_Jl\u0007#\u0002&\u0002&\u0005e\u0002c\u0002&\u0002<\u0005}\u00121B\u0005\u0004\u0003{Y%A\u0002+va2,'\u0007\u0005\u0003\u0002B\u0005\u001dcb\u0001&\u0002D%\u0019\u0011QI&\u0002\rA\u0013X\rZ3g\u0013\u0011\tI%a\u0013\u0003\rM#(/\u001b8h\u0015\r\t)e\u0013\u0005\u000b\u0003\u001fJ(\u0011!Q\u0001\n\u0005E\u0013!B9vKV,\u0007CBA*\u0003;\n\t'\u0004\u0002\u0002V)!\u0011qKA-\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u00037\"\u0012\u0001B;uS2LA!a\u0018\u0002V\ti!\t\\8dW&tw-U;fk\u0016\u0004B!!\u0004\u0002d%!\u0011QMA\b\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK\"1\u0011(\u001fC\u0001\u0003S\"\"\"a\u001b\u0002n\u0005=\u0014\u0011OA:!\tQ\u0017\u0010\u0003\u0005\u0002\n\u0005\u001d\u0004\u0019AA\u0006\u0011!\t\t#a\u001aA\u0002\u0005\r\u0002\u0002CA\u001b\u0003O\u0002\r!a\u000e\t\u0011\u0005=\u0013q\ra\u0001\u0003#B\u0011\"a\u001ez\u0005\u0004%I!!\u001f\u0002\u0015\u0005$HO]5ckR,7/\u0006\u0002\u0002|A)!*!\n\u0002~A9!*a\u000f\u0002\f\u0005}\u0004#\u0002&\u0002\u0002\u0006\u0015\u0015bAAB\u0017\n)\u0011I\u001d:bsB!\u0011qQAH\u001b\t\tII\u0003\u0003\u0002\u0002\u0005-%bAAG\u0011\u0005)Q\u000f^5mg&!\u0011\u0011SAE\u0005%!&/\u00198tM>\u0014X\u000e\u0003\u0005\u0002\u0016f\u0004\u000b\u0011BA>\u0003-\tG\u000f\u001e:jEV$Xm\u001d\u0011\t\u000f\u0005e\u0015\u0010\"\u0011\u0002\u001c\u000691\r[1oO\u0016$G\u0003BAO\u0003G\u00032ASAP\u0013\r\t\tk\u0013\u0002\u0005+:LG\u000f\u0003\u0005\u0002&\u0006]\u0005\u0019AAT\u0003\u0015)g/\u001a8u!\ri\u0018\u0011V\u0005\u0004\u0003Ws(\u0001\u0004$fCR,(/Z#wK:$\bbBAXs\u0012\u0005\u0011\u0011W\u0001\u0006C\u0012$W\r\u001a\u000b\u0005\u0003;\u000b\u0019\f\u0003\u0005\u00026\u00065\u0006\u0019AA1\u0003\t\u0019h\rC\u0004\u0002:\u0002\u0001\u000b\u0011\u0002!\u0002\u000fA\f'/Y7tA!I\u0011q\n\u0001C\u0002\u0013%\u0011QX\u000b\u0003\u0003#B\u0001\"!1\u0001A\u0003%\u0011\u0011K\u0001\u0007cV,W/\u001a\u0011\t\r\r\u0001A\u0011KAc))\t9-a4\u0002T\u0006u\u0017Q\u001e\t\u0006\u0015\u0006\u0015\u0012\u0011\u001a\t\u0004\u0015\u0006-\u0017bAAg\u0017\n!Aj\u001c8h\u0011\u001d\t\t.a1A\u0002y\t!\u0001Z:\t\u0011\u0005U\u00171\u0019a\u0001\u0003/\fQ!];fef\u00042!`Am\u0013\r\tYN \u0002\u0006#V,'/\u001f\u0005\t\u0003?\f\u0019\r1\u0001\u0002b\u0006AQ\r\u001f9peR,'\u000f\u0005\u0003\u0002d\u0006%XBAAs\u0015\r\t9OG\u0001\bM>\u0014X.\u0019;t\u0013\u0011\tY/!:\u0003\u001f\u0019+\u0017\r^;sK\u0016C\bo\u001c:uKJD\u0001\"a<\u0002D\u0002\u0007\u0011\u0011_\u0001\u0010oJLG/Z#naRLh)\u001b7fgB\u0019!*a=\n\u0007\u0005U8JA\u0004C_>dW-\u00198\t\u000f\u0005e\b\u0001\"\u0003\u0002|\u0006\u0011R\r\u001f9peR\u001cuN\u001c;j]V|Wo\u001d7z))\t9-!@\u0002\u0000\n\u0005!q\u0003\u0005\t\u0003\u0013\t9\u00101\u0001\u0002\f!A\u0011q\\A|\u0001\u0004\t\t\u000f\u0003\u0005\u0003\u0004\u0005]\b\u0019\u0001B\u0003\u0003!1W-\u0019;ve\u0016\u001c\bC\u0002B\u0004\u0005#\t\tG\u0004\u0003\u0003\n\t5abA\u0016\u0003\f%\tA*C\u0002\u0003\u0010-\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0003\u0014\tU!\u0001C%uKJ\fGo\u001c:\u000b\u0007\t=1\n\u0003\u0005\u0002p\u0006]\b\u0019AAy\u0011\u001d\u0011Y\u0002\u0001C\u0005\u0005;\tQ\"\u001a=q_J$x+\u001b;i\u001b\u0006DH\u0003DAd\u0005?\u0011\tCa\t\u0003&\t\u001d\u0002\u0002CA\u0005\u00053\u0001\r!a\u0003\t\u0011\u0005}'\u0011\u0004a\u0001\u0003CD\u0001Ba\u0001\u0003\u001a\u0001\u0007!Q\u0001\u0005\t\u0003_\u0014I\u00021\u0001\u0002r\"A!\u0011\u0006B\r\u0001\u0004\u0011Y#A\u0002nCb\u00042A\u0013B\u0017\u0013\r\u0011yc\u0013\u0002\u0004\u0013:$\b")
public class KafkaExportCommand
implements ExportCommand<KafkaDataStore>,
KafkaDataStoreCommand.KafkaDistributedCommand {
    private final KafkaExportParameters params;
    private final BlockingQueue<SimpleFeature> org$locationtech$geomesa$kafka$tools$export$KafkaExportCommand$$queue;
    private final String name;
    private final Logger logger;
    private Object org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ Seq org$locationtech$geomesa$kafka$tools$KafkaDataStoreCommand$KafkaDistributedCommand$$super$libjarsFiles() {
        return ExportCommand.class.libjarsFiles((ExportCommand)this);
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$kafka$tools$KafkaDataStoreCommand$KafkaDistributedCommand$$super$libjarsPaths() {
        return package.DistributedCommand.class.libjarsPaths((package.DistributedCommand)this);
    }

    @Override
    public Seq<String> libjarsFiles() {
        return KafkaDataStoreCommand$KafkaDistributedCommand$class.libjarsFiles(this);
    }

    @Override
    public Iterator<Function0<Seq<File>>> libjarsPaths() {
        return KafkaDataStoreCommand$KafkaDistributedCommand$class.libjarsPaths(this);
    }

    @Override
    public scala.collection.immutable.Map<String, String> connection() {
        return KafkaDataStoreCommand$class.connection(this);
    }

    public String name() {
        return this.name;
    }

    public void org$locationtech$geomesa$tools$export$ExportCommand$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    public void execute() {
        ExportCommand.class.execute((ExportCommand)this);
    }

    public void configure(Job job, DataStore ds, Query query) {
        ExportCommand.class.configure((ExportCommand)this, (Job)job, (DataStore)ds, (Query)query);
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, (String)message, code);
    }

    private Logger logger$lzycompute() {
        KafkaExportCommand kafkaExportCommand = this;
        synchronized (kafkaExportCommand) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Object org$locationtech$geomesa$tools$InteractiveCommand$$_console() {
        return this.org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    }

    public void org$locationtech$geomesa$tools$InteractiveCommand$$_console_$eq(Object x$1) {
        this.org$locationtech$geomesa$tools$InteractiveCommand$$_console = x$1;
    }

    public Object console() {
        return package.InteractiveCommand.class.console((package.InteractiveCommand)this);
    }

    public void setConsole(Object c) {
        package.InteractiveCommand.class.setConsole((package.InteractiveCommand)this, (Object)c);
    }

    public <T> T withDataStore(Function1<KafkaDataStore, T> method) throws ParameterException {
        return (T)package.DataStoreCommand.class.withDataStore((package.DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return package.DataStoreCommand.class.loadDataStore((package.DataStoreCommand)this);
    }

    public Seq<package.Command> subCommands() {
        return package.Command.class.subCommands((package.Command)this);
    }

    public Option<ParameterException> validate() {
        return package.Command.class.validate((package.Command)this);
    }

    public void run() {
        package.Command.class.run((package.Command)this);
    }

    @Override
    public KafkaExportParameters params() {
        return this.params;
    }

    public BlockingQueue<SimpleFeature> org$locationtech$geomesa$kafka$tools$export$KafkaExportCommand$$queue() {
        return this.org$locationtech$geomesa$kafka$tools$export$KafkaExportCommand$$queue;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public Option<Object> export(KafkaDataStore ds, Query query, FeatureExporter exporter, boolean writeEmptyFiles) {
        Option option;
        block9: {
            Option<Object> option2;
            SimpleFeatureType sft = ds.getSchema(this.params().featureName());
            if (sft == null) {
                throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Type ", " does not exist at path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params().featureName(), this.params().zkPath()})));
            }
            Option filter = Option$.MODULE$.apply((Object)query.getFilter()).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Filter x$1) {
                    Filter filter = x$1;
                    IncludeFilter includeFilter = Filter.INCLUDE;
                    return filter != null ? !filter.equals(includeFilter) : includeFilter != null;
                }
            });
            Option transform = QueryHints$.MODULE$.RichHints(query.getHints()).getTransform();
            ExportFeatureListener listener = new ExportFeatureListener(sft, (Option<Filter>)filter, (Option<Tuple2<String, SimpleFeatureType>>)transform, this.org$locationtech$geomesa$kafka$tools$export$KafkaExportCommand$$queue());
            package.Command$.MODULE$.user().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exporting from kafka topic '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sft.getUserData().get(KafkaDataStore$.MODULE$.TopicKey())}))).append((Object)"- use `ctrl-c` to stop").toString());
            Iterator<SimpleFeature> features2 = new Iterator<SimpleFeature>(this){
                private SimpleFeature current;
                private final /* synthetic */ KafkaExportCommand $outer;

                public Iterator<SimpleFeature> seq() {
                    return Iterator.class.seq((Iterator)this);
                }

                public boolean isEmpty() {
                    return Iterator.class.isEmpty((Iterator)this);
                }

                public boolean isTraversableAgain() {
                    return Iterator.class.isTraversableAgain((Iterator)this);
                }

                public boolean hasDefiniteSize() {
                    return Iterator.class.hasDefiniteSize((Iterator)this);
                }

                public Iterator<SimpleFeature> take(int n) {
                    return Iterator.class.take((Iterator)this, (int)n);
                }

                public Iterator<SimpleFeature> drop(int n) {
                    return Iterator.class.drop((Iterator)this, (int)n);
                }

                public Iterator<SimpleFeature> slice(int from, int until) {
                    return Iterator.class.slice((Iterator)this, (int)from, (int)until);
                }

                public <B> Iterator<B> map(Function1<SimpleFeature, B> f) {
                    return Iterator.class.map((Iterator)this, f);
                }

                public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                    return Iterator.class.$plus$plus((Iterator)this, that);
                }

                public <B> Iterator<B> flatMap(Function1<SimpleFeature, GenTraversableOnce<B>> f) {
                    return Iterator.class.flatMap((Iterator)this, f);
                }

                public Iterator<SimpleFeature> filter(Function1<SimpleFeature, Object> p) {
                    return Iterator.class.filter((Iterator)this, p);
                }

                public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<SimpleFeature, B, Object> p) {
                    return Iterator.class.corresponds((Iterator)this, that, p);
                }

                public Iterator<SimpleFeature> withFilter(Function1<SimpleFeature, Object> p) {
                    return Iterator.class.withFilter((Iterator)this, p);
                }

                public Iterator<SimpleFeature> filterNot(Function1<SimpleFeature, Object> p) {
                    return Iterator.class.filterNot((Iterator)this, p);
                }

                public <B> Iterator<B> collect(PartialFunction<SimpleFeature, B> pf) {
                    return Iterator.class.collect((Iterator)this, pf);
                }

                public <B> Iterator<B> scanLeft(B z, Function2<B, SimpleFeature, B> op) {
                    return Iterator.class.scanLeft((Iterator)this, z, op);
                }

                public <B> Iterator<B> scanRight(B z, Function2<SimpleFeature, B, B> op) {
                    return Iterator.class.scanRight((Iterator)this, z, op);
                }

                public Iterator<SimpleFeature> takeWhile(Function1<SimpleFeature, Object> p) {
                    return Iterator.class.takeWhile((Iterator)this, p);
                }

                public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> partition(Function1<SimpleFeature, Object> p) {
                    return Iterator.class.partition((Iterator)this, p);
                }

                public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> span(Function1<SimpleFeature, Object> p) {
                    return Iterator.class.span((Iterator)this, p);
                }

                public Iterator<SimpleFeature> dropWhile(Function1<SimpleFeature, Object> p) {
                    return Iterator.class.dropWhile((Iterator)this, p);
                }

                public <B> Iterator<Tuple2<SimpleFeature, B>> zip(Iterator<B> that) {
                    return Iterator.class.zip((Iterator)this, that);
                }

                public <A1> Iterator<A1> padTo(int len, A1 elem) {
                    return Iterator.class.padTo((Iterator)this, (int)len, elem);
                }

                public Iterator<Tuple2<SimpleFeature, Object>> zipWithIndex() {
                    return Iterator.class.zipWithIndex((Iterator)this);
                }

                public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                    return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
                }

                public <U> void foreach(Function1<SimpleFeature, U> f) {
                    Iterator.class.foreach((Iterator)this, f);
                }

                public boolean forall(Function1<SimpleFeature, Object> p) {
                    return Iterator.class.forall((Iterator)this, p);
                }

                public boolean exists(Function1<SimpleFeature, Object> p) {
                    return Iterator.class.exists((Iterator)this, p);
                }

                public boolean contains(Object elem) {
                    return Iterator.class.contains((Iterator)this, (Object)elem);
                }

                public Option<SimpleFeature> find(Function1<SimpleFeature, Object> p) {
                    return Iterator.class.find((Iterator)this, p);
                }

                public int indexWhere(Function1<SimpleFeature, Object> p) {
                    return Iterator.class.indexWhere((Iterator)this, p);
                }

                public <B> int indexOf(B elem) {
                    return Iterator.class.indexOf((Iterator)this, elem);
                }

                public BufferedIterator<SimpleFeature> buffered() {
                    return Iterator.class.buffered((Iterator)this);
                }

                public <B> Iterator.GroupedIterator<B> grouped(int size) {
                    return Iterator.class.grouped((Iterator)this, (int)size);
                }

                public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                    return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
                }

                public int length() {
                    return Iterator.class.length((Iterator)this);
                }

                public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> duplicate() {
                    return Iterator.class.duplicate((Iterator)this);
                }

                public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                    return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
                }

                public <B> void copyToArray(Object xs, int start, int len) {
                    Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
                }

                public boolean sameElements(Iterator<?> that) {
                    return Iterator.class.sameElements((Iterator)this, that);
                }

                public Traversable<SimpleFeature> toTraversable() {
                    return Iterator.class.toTraversable((Iterator)this);
                }

                public Iterator<SimpleFeature> toIterator() {
                    return Iterator.class.toIterator((Iterator)this);
                }

                public Stream<SimpleFeature> toStream() {
                    return Iterator.class.toStream((Iterator)this);
                }

                public String toString() {
                    return Iterator.class.toString((Iterator)this);
                }

                public <B> int sliding$default$2() {
                    return Iterator.class.sliding$default$2((Iterator)this);
                }

                public List<SimpleFeature> reversed() {
                    return TraversableOnce.class.reversed((TraversableOnce)this);
                }

                public int size() {
                    return TraversableOnce.class.size((TraversableOnce)this);
                }

                public boolean nonEmpty() {
                    return TraversableOnce.class.nonEmpty((TraversableOnce)this);
                }

                public int count(Function1<SimpleFeature, Object> p) {
                    return TraversableOnce.class.count((TraversableOnce)this, p);
                }

                public <B> Option<B> collectFirst(PartialFunction<SimpleFeature, B> pf) {
                    return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
                }

                public <B> B $div$colon(B z, Function2<B, SimpleFeature, B> op) {
                    return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
                }

                public <B> B $colon$bslash(B z, Function2<SimpleFeature, B, B> op) {
                    return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
                }

                public <B> B foldLeft(B z, Function2<B, SimpleFeature, B> op) {
                    return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
                }

                public <B> B foldRight(B z, Function2<SimpleFeature, B, B> op) {
                    return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
                }

                public <B> B reduceLeft(Function2<B, SimpleFeature, B> op) {
                    return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
                }

                public <B> B reduceRight(Function2<SimpleFeature, B, B> op) {
                    return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
                }

                public <B> Option<B> reduceLeftOption(Function2<B, SimpleFeature, B> op) {
                    return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
                }

                public <B> Option<B> reduceRightOption(Function2<SimpleFeature, B, B> op) {
                    return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
                }

                public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                    return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
                }

                public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                    return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
                }

                public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                    return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
                }

                public <B> B aggregate(Function0<B> z, Function2<B, SimpleFeature, B> seqop, Function2<B, B, B> combop) {
                    return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
                }

                public <B> B sum(Numeric<B> num) {
                    return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
                }

                public <B> B product(Numeric<B> num) {
                    return (B)TraversableOnce.class.product((TraversableOnce)this, num);
                }

                public Object min(Ordering cmp) {
                    return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
                }

                public Object max(Ordering cmp) {
                    return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
                }

                public Object maxBy(Function1 f, Ordering cmp) {
                    return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                }

                public Object minBy(Function1 f, Ordering cmp) {
                    return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                }

                public <B> void copyToBuffer(Buffer<B> dest) {
                    TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
                }

                public <B> void copyToArray(Object xs, int start) {
                    TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
                }

                public <B> void copyToArray(Object xs) {
                    TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
                }

                public <B> Object toArray(ClassTag<B> evidence$1) {
                    return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
                }

                public List<SimpleFeature> toList() {
                    return TraversableOnce.class.toList((TraversableOnce)this);
                }

                public Iterable<SimpleFeature> toIterable() {
                    return TraversableOnce.class.toIterable((TraversableOnce)this);
                }

                public Seq<SimpleFeature> toSeq() {
                    return TraversableOnce.class.toSeq((TraversableOnce)this);
                }

                public IndexedSeq<SimpleFeature> toIndexedSeq() {
                    return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
                }

                public <B> Buffer<B> toBuffer() {
                    return TraversableOnce.class.toBuffer((TraversableOnce)this);
                }

                public <B> Set<B> toSet() {
                    return TraversableOnce.class.toSet((TraversableOnce)this);
                }

                public Vector<SimpleFeature> toVector() {
                    return TraversableOnce.class.toVector((TraversableOnce)this);
                }

                public <Col> Col to(CanBuildFrom<Nothing$, SimpleFeature, Col> cbf) {
                    return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
                }

                public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef$.less.colon.less<SimpleFeature, Tuple2<T, U>> ev) {
                    return TraversableOnce.class.toMap((TraversableOnce)this, ev);
                }

                public String mkString(String start, String sep, String end) {
                    return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
                }

                public String mkString(String sep) {
                    return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
                }

                public String mkString() {
                    return TraversableOnce.class.mkString((TraversableOnce)this);
                }

                public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                    return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                }

                public StringBuilder addString(StringBuilder b, String sep) {
                    return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
                }

                public StringBuilder addString(StringBuilder b) {
                    return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
                }

                private SimpleFeature current() {
                    return this.current;
                }

                private void current_$eq(SimpleFeature x$1) {
                    this.current = x$1;
                }

                public boolean hasNext() {
                    if (this.current() == null) {
                        this.current_$eq(this.$outer.org$locationtech$geomesa$kafka$tools$export$KafkaExportCommand$$queue().poll(100L, TimeUnit.MILLISECONDS));
                    }
                    return this.current() != null;
                }

                /*
                 * WARNING - void declaration
                 */
                public SimpleFeature next() {
                    void var1_1;
                    SimpleFeature res = this.current();
                    this.current_$eq(null);
                    return var1_1;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    TraversableOnce.class.$init$((TraversableOnce)this);
                    Iterator.class.$init$((Iterator)this);
                }
            };
            SimpleFeatureStore fs = ds.getFeatureSource(query.getTypeName());
            fs.addFeatureListener((FeatureListener)listener);
            option = QueryHints$.MODULE$.RichHints(query.getHints()).getMaxFeatures();
            if (None$.MODULE$.equals(option)) {
                option2 = this.exportContinuously(QueryHints$.MODULE$.RichHints(query.getHints()).getReturnSft(), exporter, features2, writeEmptyFiles);
            } else {
                if (!(option instanceof Some)) break block9;
                Some some = (Some)option;
                int m = BoxesRunTime.unboxToInt((Object)some.x());
                option2 = this.exportWithMax(QueryHints$.MODULE$.RichHints(query.getHints()).getReturnSft(), exporter, features2, writeEmptyFiles, m);
            }
            Option<Object> option3 = option2;
            {
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option4 = NonFatal$.MODULE$.unapply(throwable2);
                    if (option4.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option4.get();
                    throw new RuntimeException("Could not execute export query. Please ensure that all arguments are correct", e);
                }
            }
            fs.removeFeatureListener((FeatureListener)listener);
            return option3;
        }
        try {
            throw new MatchError((Object)option);
        }
        catch (Throwable throwable) {
            void var8_8;
            void var10_10;
            var10_10.removeFeatureListener((FeatureListener)var8_8);
            throw throwable;
        }
    }

    private Option<Object> exportContinuously(SimpleFeatureType sft, FeatureExporter exporter, Iterator<SimpleFeature> features2, boolean writeEmptyFiles) {
        boolean started;
        boolean bl;
        package$.MODULE$.addShutdownHook((Function0)new Serializable(this, exporter){
            public static final long serialVersionUID = 0L;
            private final FeatureExporter exporter$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.exporter$1.close();
            }
            {
                this.exporter$1 = exporter$1;
            }
        });
        LongRef count = LongRef.create((long)0L);
        if (writeEmptyFiles) {
            exporter.start(sft);
            bl = true;
        } else {
            bl = started = false;
        }
        while (true) {
            if (features2.hasNext()) {
                if (!started) {
                    exporter.start(sft);
                    started = true;
                }
                exporter.export(features2).foreach((Function1)new Serializable(this, count){
                    public static final long serialVersionUID = 0L;
                    private final LongRef count$1;

                    public final void apply(long x$2) {
                        this.apply$mcVJ$sp(x$2);
                    }

                    public void apply$mcVJ$sp(long x$2) {
                        this.count$1.elem += x$2;
                    }
                    {
                        this.count$1 = count$1;
                    }
                });
                continue;
            }
            Thread.sleep(1000L);
        }
    }

    private Option<Object> exportWithMax(SimpleFeatureType sft, FeatureExporter exporter, Iterator<SimpleFeature> features2, boolean writeEmptyFiles, int max) {
        boolean started;
        boolean bl;
        LongRef count = LongRef.create((long)0L);
        if (writeEmptyFiles) {
            exporter.start(sft);
            bl = true;
        } else {
            bl = started = false;
        }
        while (count.elem < (long)max) {
            BoxedUnit boxedUnit;
            if (features2.hasNext()) {
                if (!started) {
                    exporter.start(sft);
                    started = true;
                }
                Iterator batch = features2.take(max - (int)count.elem).map((Function1)new Serializable(this, count){
                    public static final long serialVersionUID = 0L;
                    private final LongRef count$2;

                    public final SimpleFeature apply(SimpleFeature f) {
                        ++this.count$2.elem;
                        return f;
                    }
                    {
                        this.count$2 = count$2;
                    }
                });
                boxedUnit = exporter.export(batch);
                continue;
            }
            Thread.sleep(1000L);
            boxedUnit = BoxedUnit.UNIT;
        }
        return new Some((Object)BoxesRunTime.boxToLong((long)count.elem));
    }

    public KafkaExportCommand() {
        package.Command.class.$init$((package.Command)this);
        package.DataStoreCommand.class.$init$((package.DataStoreCommand)this);
        package.DistributedCommand.class.$init$((package.DistributedCommand)this);
        package.InteractiveCommand.class.$init$((package.InteractiveCommand)this);
        LazyLogging.class.$init$((LazyLogging)this);
        MethodProfiling.class.$init$((MethodProfiling)this);
        ExportCommand.class.$init$((ExportCommand)this);
        KafkaDataStoreCommand$class.$init$(this);
        KafkaDataStoreCommand$KafkaDistributedCommand$class.$init$(this);
        this.params = new KafkaExportParameters();
        this.org$locationtech$geomesa$kafka$tools$export$KafkaExportCommand$$queue = new LinkedBlockingQueue<SimpleFeature>();
    }

    @Parameters(commandDescription="Export features from a GeoMesa Kafka topic")
    public static class KafkaExportParameters
    implements ConsumerDataStoreParams,
    RequiredTypeNameParam,
    ExportCommand.ExportParams {
        @Parameter(names={"-o", "--output"}, description="Output to a file instead of std out")
        private String file;
        @Parameter(names={"--gzip"}, description="Level of gzip compression to apply to output, from 1-9")
        private Integer gzip;
        @Parameter(names={"--no-header"}, description="Export as a delimited text format (csv|tsv) without a type header")
        private boolean noHeader;
        @Parameter(names={"--suppress-empty"}, description="Suppress all output (headers, etc) if there are no features exported")
        private boolean suppressEmpty;
        @Parameter(names={"-m", "--max-features"}, description="Restrict the maximum number of features returned")
        private Integer maxFeatures;
        @Parameter(names={"--attribute"}, description="Attributes or derived expressions to export, or 'id' to include the feature ID", splitter=NoopParameterSplitter.class)
        private java.util.List<String> transforms;
        @Parameter(names={"-a", "--attributes"}, description="Comma-separated attributes to export, or 'id' to include the feature ID")
        private java.util.List<String> attributes;
        @Parameter(names={"--sort-by"}, description="Sort by the specified attributes (comma-delimited)")
        private java.util.List<String> sortFields;
        @Parameter(names={"--sort-descending"}, description="Sort in descending order, instead of ascending", arity=0)
        private boolean sortDescending;
        @Parameter(names={"--num-reducers"}, description="Number of reducers to use when sorting or merging (for distributed export)", validateWith={PositiveInteger.class})
        private Integer reducers;
        @Parameter(names={"--chunk-size"}, description="Split the output into multiple files, by specifying the rough number of bytes to store per file", converter=ParameterConverters.BytesConverter.class)
        private Long chunkSize;
        @Parameter(names={"-F", "--output-format"}, description="File format of output files (csv|tsv|gml|json|shp|avro|leaflet|orc|parquet|arrow)", converter=ParameterConverters.ExportFormatConverter.class)
        private ExportFormat explicitOutputFormat;
        private final ExportFormat outputFormat;
        @Parameter(names={"--force"}, description="Force execution without prompt")
        private boolean force;
        @Parameter(names={"--run-mode"}, description="Run locally or on a cluster", required=false)
        private String runMode;
        private final Option<Enumeration.Value> mode;
        @Parameter(names={"--hints"}, description="Query hints to set, in the form key1=value1;key2=value2", required=false, converter=ParameterConverters.HintConverter.class)
        private Map<String, String> hints;
        @Parameter(names={"-q", "--cql"}, description="CQL predicate", converter=ParameterConverters.FilterConverter.class)
        private Filter cqlFilter;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"--num-consumers"}, description="Number of consumer threads used for reading from Kafka")
        private int numConsumers;
        @Parameter(names={"--from-beginning"}, description="Consume from the beginning or end of the topic")
        private boolean fromBeginning;
        @Parameter(names={"--read-back"}, description="Consume messages written within this time frame, e.g. '1 hour'", converter=ParameterConverters.DurationConverter.class)
        private Duration readBack;
        private final int replication;
        private final int partitions;
        @Parameter(names={"-b", "--brokers"}, description="Brokers (host:port, comma separated)", required=true)
        private String brokers;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)", required=true)
        private String zookeepers;
        @Parameter(names={"-p", "--zkpath"}, description="Zookeeper path where feature schemas are saved")
        private String zkPath;
        private volatile byte bitmap$0;

        public String file() {
            return this.file;
        }

        public void file_$eq(String x$1) {
            this.file = x$1;
        }

        public Integer gzip() {
            return this.gzip;
        }

        public void gzip_$eq(Integer x$1) {
            this.gzip = x$1;
        }

        public boolean noHeader() {
            return this.noHeader;
        }

        public void noHeader_$eq(boolean x$1) {
            this.noHeader = x$1;
        }

        public boolean suppressEmpty() {
            return this.suppressEmpty;
        }

        public void suppressEmpty_$eq(boolean x$1) {
            this.suppressEmpty = x$1;
        }

        public Integer maxFeatures() {
            return this.maxFeatures;
        }

        public void maxFeatures_$eq(Integer x$1) {
            this.maxFeatures = x$1;
        }

        public java.util.List<String> transforms() {
            return this.transforms;
        }

        public void transforms_$eq(java.util.List<String> x$1) {
            this.transforms = x$1;
        }

        public java.util.List<String> attributes() {
            return this.attributes;
        }

        public void attributes_$eq(java.util.List<String> x$1) {
            this.attributes = x$1;
        }

        public java.util.List<String> sortFields() {
            return this.sortFields;
        }

        public void sortFields_$eq(java.util.List<String> x$1) {
            this.sortFields = x$1;
        }

        public boolean sortDescending() {
            return this.sortDescending;
        }

        public void sortDescending_$eq(boolean x$1) {
            this.sortDescending = x$1;
        }

        public Integer reducers() {
            return this.reducers;
        }

        public void reducers_$eq(Integer x$1) {
            this.reducers = x$1;
        }

        public Long chunkSize() {
            return this.chunkSize;
        }

        public void chunkSize_$eq(Long x$1) {
            this.chunkSize = x$1;
        }

        public ExportFormat explicitOutputFormat() {
            return this.explicitOutputFormat;
        }

        public void explicitOutputFormat_$eq(ExportFormat x$1) {
            this.explicitOutputFormat = x$1;
        }

        private ExportFormat outputFormat$lzycompute() {
            KafkaExportParameters kafkaExportParameters = this;
            synchronized (kafkaExportParameters) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.outputFormat = ExportCommand.ExportParams.class.outputFormat((ExportCommand.ExportParams)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
                return this.outputFormat;
            }
        }

        public ExportFormat outputFormat() {
            return (byte)(this.bitmap$0 & 1) == 0 ? this.outputFormat$lzycompute() : this.outputFormat;
        }

        public boolean force() {
            return this.force;
        }

        public void force_$eq(boolean x$1) {
            this.force = x$1;
        }

        public String runMode() {
            return this.runMode;
        }

        public void runMode_$eq(String x$1) {
            this.runMode = x$1;
        }

        private Option mode$lzycompute() {
            KafkaExportParameters kafkaExportParameters = this;
            synchronized (kafkaExportParameters) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.mode = DistributedRunParam.class.mode((DistributedRunParam)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
                return this.mode;
            }
        }

        public Option<Enumeration.Value> mode() {
            return (byte)(this.bitmap$0 & 2) == 0 ? this.mode$lzycompute() : this.mode;
        }

        public Map<String, String> hints() {
            return this.hints;
        }

        public void hints_$eq(Map<String, String> x$1) {
            this.hints = x$1;
        }

        public Filter cqlFilter() {
            return this.cqlFilter;
        }

        public void cqlFilter_$eq(Filter x$1) {
            this.cqlFilter = x$1;
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        @Override
        public int numConsumers() {
            return this.numConsumers;
        }

        @Override
        @TraitSetter
        public void numConsumers_$eq(int x$1) {
            this.numConsumers = x$1;
        }

        @Override
        public boolean fromBeginning() {
            return this.fromBeginning;
        }

        @Override
        @TraitSetter
        public void fromBeginning_$eq(boolean x$1) {
            this.fromBeginning = x$1;
        }

        @Override
        public Duration readBack() {
            return this.readBack;
        }

        @Override
        @TraitSetter
        public void readBack_$eq(Duration x$1) {
            this.readBack = x$1;
        }

        @Override
        public int replication() {
            return this.replication;
        }

        @Override
        public int partitions() {
            return this.partitions;
        }

        @Override
        public void org$locationtech$geomesa$kafka$tools$ConsumerDataStoreParams$_setter_$replication_$eq(int x$1) {
            this.replication = x$1;
        }

        @Override
        public void org$locationtech$geomesa$kafka$tools$ConsumerDataStoreParams$_setter_$partitions_$eq(int x$1) {
            this.partitions = x$1;
        }

        @Override
        public String brokers() {
            return this.brokers;
        }

        @Override
        @TraitSetter
        public void brokers_$eq(String x$1) {
            this.brokers = x$1;
        }

        @Override
        public String zookeepers() {
            return this.zookeepers;
        }

        @Override
        @TraitSetter
        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        @Override
        public String zkPath() {
            return this.zkPath;
        }

        @Override
        @TraitSetter
        public void zkPath_$eq(String x$1) {
            this.zkPath = x$1;
        }

        public KafkaExportParameters() {
            KafkaDataStoreParams$class.$init$(this);
            ConsumerDataStoreParams$class.$init$(this);
            RequiredTypeNameParam.class.$init$((RequiredTypeNameParam)this);
            OptionalCqlFilterParam.class.$init$((OptionalCqlFilterParam)this);
            QueryHintsParams.class.$init$((QueryHintsParams)this);
            DistributedRunParam.class.$init$((DistributedRunParam)this);
            OptionalForceParam.class.$init$((OptionalForceParam)this);
            ExportCommand.ExportParams.class.$init$((ExportCommand.ExportParams)this);
        }
    }

    public static class ExportFeatureListener
    implements FeatureListener {
        public final SimpleFeatureType org$locationtech$geomesa$kafka$tools$export$KafkaExportCommand$ExportFeatureListener$$sft;
        private final Option<Filter> filter;
        private final BlockingQueue<SimpleFeature> queue;
        private final Option<Tuple2<SimpleFeatureType, Transform[]>> attributes;

        private Option<Tuple2<SimpleFeatureType, Transform[]>> attributes() {
            return this.attributes;
        }

        public void changed(FeatureEvent event) {
            FeatureEvent featureEvent = event;
            if (featureEvent instanceof KafkaFeatureEvent.KafkaFeatureChanged) {
                KafkaFeatureEvent.KafkaFeatureChanged kafkaFeatureChanged = (KafkaFeatureEvent.KafkaFeatureChanged)featureEvent;
                this.added(kafkaFeatureChanged.feature());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }

        public void added(SimpleFeature sf) {
            if (this.filter.forall((Function1)new Serializable(this, sf){
                public static final long serialVersionUID = 0L;
                private final SimpleFeature sf$1;

                public final boolean apply(Filter x$3) {
                    return x$3.evaluate((Object)this.sf$1);
                }
                {
                    this.sf$1 = sf$1;
                }
            })) {
                this.queue.put((SimpleFeature)this.attributes().map((Function1)new Serializable(this, sf){
                    public static final long serialVersionUID = 0L;
                    private final SimpleFeature sf$1;

                    public final TransformSimpleFeature apply(Tuple2<SimpleFeatureType, Transform[]> x0$2) {
                        Tuple2<SimpleFeatureType, Transform[]> tuple2 = x0$2;
                        if (tuple2 != null) {
                            SimpleFeatureType tsft = (SimpleFeatureType)tuple2._1();
                            Transform[] a = (Transform[])tuple2._2();
                            TransformSimpleFeature transformSimpleFeature = new TransformSimpleFeature(tsft, a, this.sf$1);
                            return transformSimpleFeature;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.sf$1 = sf$1;
                    }
                }).getOrElse((Function0)new Serializable(this, sf){
                    public static final long serialVersionUID = 0L;
                    private final SimpleFeature sf$1;

                    public final SimpleFeature apply() {
                        return this.sf$1;
                    }
                    {
                        this.sf$1 = sf$1;
                    }
                }));
            }
        }

        public ExportFeatureListener(SimpleFeatureType sft, Option<Filter> filter, Option<Tuple2<String, SimpleFeatureType>> transform, BlockingQueue<SimpleFeature> queue) {
            this.org$locationtech$geomesa$kafka$tools$export$KafkaExportCommand$ExportFeatureListener$$sft = sft;
            this.filter = filter;
            this.queue = queue;
            this.attributes = transform.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ExportFeatureListener $outer;

                public final Tuple2<SimpleFeatureType, Transform[]> apply(Tuple2<String, SimpleFeatureType> x0$1) {
                    Tuple2<String, SimpleFeatureType> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String tdefs = (String)tuple2._1();
                        SimpleFeatureType tsft = (SimpleFeatureType)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)tsft, Transform.Transforms$.MODULE$.apply(this.$outer.org$locationtech$geomesa$kafka$tools$export$KafkaExportCommand$ExportFeatureListener$$sft, tdefs).toArray(ClassTag$.MODULE$.apply(Transform.class)));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
    }
}

