/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kudu.data;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureSource;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureSource;
import org.locationtech.geomesa.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.process.analytic.SamplingVisitor;
import org.opengis.feature.FeatureVisitor;
import org.opengis.util.ProgressListener;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001E3A!\u0001\u0002\u0001\u001b\t)2*\u001e3v\r\u0016\fG/\u001e:f\u0007>dG.Z2uS>t'BA\u0002\u0005\u0003\u0011!\u0017\r^1\u000b\u0005\u00151\u0011\u0001B6vIVT!a\u0002\u0005\u0002\u000f\u001d,w.\\3tC*\u0011\u0011BC\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\f\u0011\u0005=!R\"\u0001\t\u000b\u0005E\u0011\u0012\u0001C4f_R|w\u000e\\:\u000b\u0005M1\u0011!B5oI\u0016D\u0018BA\u000b\u0011\u0005a9Um\\'fg\u00064U-\u0019;ve\u0016\u001cu\u000e\u001c7fGRLwN\u001c\t\u0003/yi\u0011\u0001\u0007\u0006\u00033i\tAb]2bY\u0006dwnZ4j]\u001eT!a\u0007\u000f\u0002\u0011QL\b/Z:bM\u0016T\u0011!H\u0001\u0004G>l\u0017BA\u0010\u0019\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u0013\u0005\u0002!\u0011!Q\u0001\n\t*\u0013AB:pkJ\u001cW\r\u0005\u0002\u0010G%\u0011A\u0005\u0005\u0002\u0015\u000f\u0016|W*Z:b\r\u0016\fG/\u001e:f'>,(oY3\n\u0005\u0005\"\u0002\"C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015/\u0003\u0015\tX/\u001a:z!\tIC&D\u0001+\u0015\t\u00191F\u0003\u0002\u0012\u0015%\u0011QF\u000b\u0002\u0006#V,'/_\u0005\u0003OQAQ\u0001\r\u0001\u0005\u0002E\na\u0001P5oSRtDc\u0001\u001a5kA\u00111\u0007A\u0007\u0002\u0005!)\u0011e\fa\u0001E!)qe\fa\u0001Q!)q\u0007\u0001C!q\u00059\u0011mY2faR\u001cHcA\u001d@\u0013B\u0011!(P\u0007\u0002w)\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\t!QK\\5u\u0011\u0015\u0001e\u00071\u0001B\u0003\u001d1\u0018n]5u_J\u0004\"AQ$\u000e\u0003\rS!\u0001R#\u0002\u000f\u0019,\u0017\r^;sK*\u0011aIC\u0001\b_B,gnZ5t\u0013\tA5I\u0001\bGK\u0006$XO]3WSNLGo\u001c:\t\u000b)3\u0004\u0019A&\u0002\u0011A\u0014xn\u001a:fgN\u0004\"\u0001T(\u000e\u00035S!AT#\u0002\tU$\u0018\u000e\\\u0005\u0003!6\u0013\u0001\u0003\u0015:pOJ,7o\u001d'jgR,g.\u001a:")
public class KuduFeatureCollection
extends GeoMesaFeatureCollection
implements LazyLogging {
    private final GeoMesaFeatureSource source;
    private final Query query;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        KuduFeatureCollection kuduFeatureCollection = this;
        synchronized (kuduFeatureCollection) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void accepts(FeatureVisitor visitor, ProgressListener progress) {
        FeatureVisitor featureVisitor = visitor;
        if (featureVisitor instanceof SamplingVisitor) {
            super.accepts(visitor, progress);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (featureVisitor instanceof GeoMesaProcessVisitor) {
            GeoMesaProcessVisitor geoMesaProcessVisitor = (GeoMesaProcessVisitor)featureVisitor;
            geoMesaProcessVisitor.execute((SimpleFeatureSource)this.source, this.query);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Using fallback FeatureVisitor for process {}.", new Object[]{featureVisitor.getClass().getName()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            super.accepts(visitor, progress);
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        }
    }

    public KuduFeatureCollection(GeoMesaFeatureSource source, Query query) {
        this.source = source;
        this.query = query;
        super(source, query);
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

