/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kudu.index;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.apache.kudu.Schema;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.PartialRow;
import org.locationtech.geomesa.index.conf.splitter.DefaultSplitter;
import org.locationtech.geomesa.index.index.IndexKeySpace;
import org.locationtech.geomesa.index.index.attribute.AttributeIndex$;
import org.locationtech.geomesa.index.index.attribute.AttributeIndexKey;
import org.locationtech.geomesa.index.index.attribute.AttributeIndexKeySpace;
import org.locationtech.geomesa.index.index.attribute.AttributeIndexKeySpace$;
import org.locationtech.geomesa.kudu.data.KuduFeature;
import org.locationtech.geomesa.kudu.index.KuduAttributeIndex;
import org.locationtech.geomesa.kudu.index.KuduAttributeIndex$;
import org.locationtech.geomesa.kudu.package;
import org.locationtech.geomesa.kudu.schema.KuduIndexColumnAdapter;
import org.locationtech.geomesa.kudu.schema.KuduIndexColumnAdapter$FeatureIdAdapter$;
import org.locationtech.geomesa.kudu.schema.KuduIndexColumnAdapter$IdxColumnAdapter$;
import org.locationtech.geomesa.kudu.schema.KuduIndexColumnAdapter$SecondaryColumnAdapter$;
import org.locationtech.geomesa.kudu.schema.KuduIndexColumnAdapter$ValueColumnAdapter$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class KuduAttributeIndex$class {
    public static AttributeIndexKeySpace keySpace(KuduAttributeIndex $this) {
        return AttributeIndexKeySpace$.MODULE$;
    }

    public static Option tieredKeySpace(KuduAttributeIndex $this, SimpleFeatureType sft) {
        return AttributeIndex$.MODULE$.TieredOptions().find((Function1)new Serializable($this, sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final boolean apply(IndexKeySpace<? extends Product, ? super Object> x$1) {
                return x$1.supports(this.sft$1);
            }
            {
                this.sft$1 = sft$1;
            }
        });
    }

    public static void configurePartitions(KuduAttributeIndex $this, SimpleFeatureType sft, Schema schema2, Map config, CreateTableOptions options) {
        int shards = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getAttributeShards$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
        Object object = shards > 1 ? options.addHashPartitions(Collections.singletonList(KuduIndexColumnAdapter$ValueColumnAdapter$.MODULE$.name()), shards) : BoxedUnit.UNIT;
        options.setRangePartitionColumns((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KuduIndexColumnAdapter$IdxColumnAdapter$.MODULE$.name(), KuduIndexColumnAdapter$ValueColumnAdapter$.MODULE$.name()}))).asJava());
        SimpleFeatureTypes$.MODULE$.getSecondaryIndexedAttributes(sft).foreach((Function1)new Serializable($this, sft, schema2, config, options){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$2;
            public final Schema schema$1;
            private final Map config$1;
            public final CreateTableOptions options$1;

            public final void apply(AttributeDescriptor d) {
                Seq seq;
                String upperBound = new String(IndexKeySpace.ByteRange$.MODULE$.UnboundedUpperRange(), StandardCharsets.UTF_8);
                Seq configured = DefaultSplitter.Parser$.MODULE$.attributeSplits(d.getLocalName(), d.getType().getBinding(), this.config$1);
                if (configured.isEmpty()) {
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", upperBound}));
                } else {
                    Builder builder = Seq$.MODULE$.newBuilder();
                    builder.sizeHint(configured.length() + 2);
                    builder.$plus$eq((Object)"");
                    builder.$plus$plus$eq((TraversableOnce)configured.sorted((Ordering)Ordering.String$.MODULE$));
                    builder.$plus$eq((Object)upperBound);
                    seq = (Seq)((SeqLike)builder.result()).distinct();
                }
                Seq splits = seq;
                short i = (short)this.sft$2.indexOf(d.getLocalName());
                splits.sliding(2).foreach((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KuduAttributeIndex$.anonfun.configurePartitions.1 $outer;
                    private final short i$1;

                    public final CreateTableOptions apply(Seq<String> x0$1) {
                        Seq<String> seq = x0$1;
                        Some some = Seq$.MODULE$.unapplySeq(seq);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            String lo = (String)((SeqLike)some.get()).apply(0);
                            String hi = (String)((SeqLike)some.get()).apply(1);
                            PartialRow lower = this.$outer.schema$1.newPartialRow();
                            PartialRow upper = this.$outer.schema$1.newPartialRow();
                            lower.addShort(0, this.i$1);
                            upper.addShort(0, this.i$1);
                            lower.addString(1, lo);
                            upper.addString(1, hi);
                            CreateTableOptions createTableOptions = this.$outer.options$1.addRangePartition(lower, upper);
                            return createTableOptions;
                        }
                        throw new MatchError(seq);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.i$1 = i$1;
                    }
                });
            }
            {
                this.sft$2 = sft$2;
                this.schema$1 = schema$1;
                this.config$1 = config$1;
                this.options$1 = options$1;
            }
        });
    }

    public static Seq createKeyValues(KuduAttributeIndex $this, Function1 toIndexKey, KuduFeature kf) {
        package.KuduValue<String> fid = new package.KuduValue<String>(kf.feature().getID(), KuduIndexColumnAdapter$FeatureIdAdapter$.MODULE$);
        return (Seq)((TraversableLike)toIndexKey.apply((Object)kf.feature())).map((Function1)new Serializable($this, fid){
            public static final long serialVersionUID = 0L;
            private final package.KuduValue fid$1;

            public final Seq<package.KuduValue<? super byte[]>> apply(AttributeIndexKey key) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.KuduValue[]{new package.KuduValue<Object>(BoxesRunTime.boxToShort((short)key.i()), KuduIndexColumnAdapter$IdxColumnAdapter$.MODULE$), new package.KuduValue<String>(key.value(), KuduIndexColumnAdapter$ValueColumnAdapter$.MODULE$), new package.KuduValue<byte[]>((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), KuduIndexColumnAdapter$SecondaryColumnAdapter$.MODULE$), this.fid$1}));
            }
            {
                this.fid$1 = fid$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static Seq createKeyValues(KuduAttributeIndex $this, Function1 toIndexKey, Function1 toTieredIndexKey, KuduFeature kf) {
        package.KuduValue<String> fid = new package.KuduValue<String>(kf.feature().getID(), KuduIndexColumnAdapter$FeatureIdAdapter$.MODULE$);
        Seq tiers = (Seq)toTieredIndexKey.apply((Object)kf.feature());
        return (Seq)((TraversableLike)toIndexKey.apply((Object)kf.feature())).flatMap((Function1)new Serializable($this, fid, tiers){
            public static final long serialVersionUID = 0L;
            public final package.KuduValue fid$2;
            private final Seq tiers$1;

            public final Seq<Seq<package.KuduValue<? super byte[]>>> apply(AttributeIndexKey key) {
                return (Seq)this.tiers$1.map((Function1)new Serializable(this, key){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KuduAttributeIndex$.anonfun.createKeyValues.2 $outer;
                    private final AttributeIndexKey key$1;

                    public final Seq<package.KuduValue<? super byte[]>> apply(byte[] secondary) {
                        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.KuduValue[]{new package.KuduValue<Object>(BoxesRunTime.boxToShort((short)this.key$1.i()), KuduIndexColumnAdapter$IdxColumnAdapter$.MODULE$), new package.KuduValue<String>(this.key$1.value(), KuduIndexColumnAdapter$ValueColumnAdapter$.MODULE$), new package.KuduValue<byte[]>(secondary, KuduIndexColumnAdapter$SecondaryColumnAdapter$.MODULE$), this.$outer.fid$2}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.key$1 = key$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.fid$2 = fid$2;
                this.tiers$1 = tiers$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static Tuple2 toRowRanges(KuduAttributeIndex $this, SimpleFeatureType sft, Schema schema2, IndexKeySpace.ScanRange range) {
        block8: {
            Tuple2 tuple2;
            block3: {
                IndexKeySpace.ScanRange scanRange;
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    scanRange = range;
                                    if (!(scanRange instanceof IndexKeySpace.SingleRowRange)) break block2;
                                    IndexKeySpace.SingleRowRange singleRowRange = (IndexKeySpace.SingleRowRange)scanRange;
                                    AttributeIndexKey row = (AttributeIndexKey)singleRowRange.row();
                                    tuple2 = new Tuple2((Object)KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$lower($this, schema2, row, KuduAttributeIndex$class.lower$default$3($this), KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$lower$default$4($this)), (Object)KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$upper($this, schema2, row, KuduAttributeIndex$class.upper$default$3($this), KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$upper$default$4($this)));
                                    break block3;
                                }
                                if (!(scanRange instanceof IndexKeySpace.BoundedRange)) break block4;
                                IndexKeySpace.BoundedRange boundedRange = (IndexKeySpace.BoundedRange)scanRange;
                                AttributeIndexKey lo = (AttributeIndexKey)boundedRange.lower();
                                AttributeIndexKey hi = (AttributeIndexKey)boundedRange.upper();
                                tuple2 = new Tuple2((Object)KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$lower($this, schema2, lo, KuduAttributeIndex$class.lower$default$3($this), KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$lower$default$4($this)), (Object)KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$upper($this, schema2, hi, KuduAttributeIndex$class.upper$default$3($this), KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$upper$default$4($this)));
                                break block3;
                            }
                            if (!(scanRange instanceof IndexKeySpace.PrefixRange)) break block5;
                            IndexKeySpace.PrefixRange prefixRange = (IndexKeySpace.PrefixRange)scanRange;
                            AttributeIndexKey prefix = (AttributeIndexKey)prefixRange.prefix();
                            Schema x$2 = schema2;
                            AttributeIndexKey x$3 = prefix;
                            boolean x$4 = true;
                            byte[] x$5 = KuduAttributeIndex$class.lower$default$3($this);
                            Schema x$6 = schema2;
                            AttributeIndexKey x$7 = prefix;
                            boolean x$8 = true;
                            byte[] x$9 = KuduAttributeIndex$class.upper$default$3($this);
                            tuple2 = new Tuple2((Object)KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$lower($this, x$2, x$3, x$5, x$4), (Object)KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$upper($this, x$6, x$7, x$9, x$8));
                            break block3;
                        }
                        if (!(scanRange instanceof IndexKeySpace.LowerBoundedRange)) break block6;
                        IndexKeySpace.LowerBoundedRange lowerBoundedRange = (IndexKeySpace.LowerBoundedRange)scanRange;
                        AttributeIndexKey lo = (AttributeIndexKey)lowerBoundedRange.lower();
                        Object x$10 = null;
                        boolean x$11 = false;
                        short x$12 = lo.copy$default$1();
                        tuple2 = new Tuple2((Object)KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$lower($this, schema2, lo, KuduAttributeIndex$class.lower$default$3($this), KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$lower$default$4($this)), (Object)KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$upper($this, schema2, lo.copy(x$12, null, x$11), KuduAttributeIndex$class.upper$default$3($this), KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$upper$default$4($this)));
                        break block3;
                    }
                    if (!(scanRange instanceof IndexKeySpace.UpperBoundedRange)) break block7;
                    IndexKeySpace.UpperBoundedRange upperBoundedRange = (IndexKeySpace.UpperBoundedRange)scanRange;
                    AttributeIndexKey hi = (AttributeIndexKey)upperBoundedRange.upper();
                    Object x$13 = null;
                    boolean x$14 = false;
                    short x$15 = hi.copy$default$1();
                    tuple2 = new Tuple2((Object)KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$lower($this, schema2, hi.copy(x$15, null, x$14), KuduAttributeIndex$class.lower$default$3($this), KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$lower$default$4($this)), (Object)KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$upper($this, schema2, hi, KuduAttributeIndex$class.upper$default$3($this), KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$upper$default$4($this)));
                    break block3;
                }
                if (!(scanRange instanceof IndexKeySpace.UnboundedRange)) break block8;
                IndexKeySpace.UnboundedRange unboundedRange = (IndexKeySpace.UnboundedRange)scanRange;
                AttributeIndexKey empty = (AttributeIndexKey)unboundedRange.empty();
                tuple2 = new Tuple2((Object)KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$lower($this, schema2, empty, KuduAttributeIndex$class.lower$default$3($this), KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$lower$default$4($this)), (Object)KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$upper($this, schema2, empty, KuduAttributeIndex$class.upper$default$3($this), KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$upper$default$4($this)));
            }
            return tuple2;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{range})));
    }

    public static Seq toTieredRowRanges(KuduAttributeIndex $this, SimpleFeatureType sft, Schema schema2, IndexKeySpace.ScanRange range, Function0 tiers, Function0 minTier, Function0 maxTier) {
        block8: {
            Seq seq;
            block3: {
                IndexKeySpace.ScanRange scanRange;
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    scanRange = range;
                                    if (!(scanRange instanceof IndexKeySpace.SingleRowRange)) break block2;
                                    IndexKeySpace.SingleRowRange singleRowRange = (IndexKeySpace.SingleRowRange)scanRange;
                                    AttributeIndexKey row = (AttributeIndexKey)singleRowRange.row();
                                    seq = (Seq)((TraversableLike)tiers.apply()).map((Function1)new Serializable($this, row, schema2){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ KuduAttributeIndex $outer;
                                        private final AttributeIndexKey row$1;
                                        private final Schema schema$2;

                                        public final Tuple2<Some<PartialRow>, Some<PartialRow>> apply(IndexKeySpace.ByteRange x0$2) {
                                            IndexKeySpace.ByteRange byteRange;
                                            block4: {
                                                Tuple2 tuple2;
                                                block3: {
                                                    block2: {
                                                        byteRange = x0$2;
                                                        if (!(byteRange instanceof IndexKeySpace.BoundedByteRange)) break block2;
                                                        IndexKeySpace.BoundedByteRange boundedByteRange = (IndexKeySpace.BoundedByteRange)byteRange;
                                                        byte[] lo = boundedByteRange.lower();
                                                        byte[] hi = boundedByteRange.upper();
                                                        tuple2 = new Tuple2((Object)KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$lower(this.$outer, this.schema$2, this.row$1, lo, KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$lower$default$4(this.$outer)), (Object)KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$upper(this.$outer, this.schema$2, this.row$1, hi, KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$upper$default$4(this.$outer)));
                                                        break block3;
                                                    }
                                                    if (!(byteRange instanceof IndexKeySpace.SingleRowByteRange)) break block4;
                                                    IndexKeySpace.SingleRowByteRange singleRowByteRange = (IndexKeySpace.SingleRowByteRange)byteRange;
                                                    byte[] r = singleRowByteRange.row();
                                                    tuple2 = new Tuple2((Object)KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$lower(this.$outer, this.schema$2, this.row$1, r, KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$lower$default$4(this.$outer)), (Object)KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$upper(this.$outer, this.schema$2, this.row$1, r, KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$upper$default$4(this.$outer)));
                                                }
                                                return tuple2;
                                            }
                                            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{byteRange})));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.row$1 = row$1;
                                            this.schema$2 = schema$2;
                                        }
                                    }, Seq$.MODULE$.canBuildFrom());
                                    break block3;
                                }
                                if (!(scanRange instanceof IndexKeySpace.BoundedRange)) break block4;
                                IndexKeySpace.BoundedRange boundedRange = (IndexKeySpace.BoundedRange)scanRange;
                                AttributeIndexKey lo = (AttributeIndexKey)boundedRange.lower();
                                AttributeIndexKey hi = (AttributeIndexKey)boundedRange.upper();
                                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$lower($this, schema2, lo, (byte[])minTier.apply(), KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$lower$default$4($this)), (Object)KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$upper($this, schema2, hi, (byte[])maxTier.apply(), KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$upper$default$4($this)))}));
                                break block3;
                            }
                            if (!(scanRange instanceof IndexKeySpace.PrefixRange)) break block5;
                            IndexKeySpace.PrefixRange prefixRange = (IndexKeySpace.PrefixRange)scanRange;
                            AttributeIndexKey prefix = (AttributeIndexKey)prefixRange.prefix();
                            Tuple2[] tuple2Array = new Tuple2[1];
                            Schema x$16 = schema2;
                            AttributeIndexKey x$17 = prefix;
                            boolean x$18 = true;
                            byte[] x$19 = KuduAttributeIndex$class.lower$default$3($this);
                            Schema x$20 = schema2;
                            AttributeIndexKey x$21 = prefix;
                            boolean x$22 = true;
                            byte[] x$23 = KuduAttributeIndex$class.upper$default$3($this);
                            tuple2Array[0] = new Tuple2((Object)KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$lower($this, x$16, x$17, x$19, x$18), (Object)KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$upper($this, x$20, x$21, x$23, x$22));
                            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
                            break block3;
                        }
                        if (!(scanRange instanceof IndexKeySpace.LowerBoundedRange)) break block6;
                        IndexKeySpace.LowerBoundedRange lowerBoundedRange = (IndexKeySpace.LowerBoundedRange)scanRange;
                        AttributeIndexKey lo = (AttributeIndexKey)lowerBoundedRange.lower();
                        Tuple2[] tuple2Array = new Tuple2[1];
                        Object x$24 = null;
                        boolean x$25 = false;
                        short x$26 = lo.copy$default$1();
                        tuple2Array[0] = new Tuple2((Object)KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$lower($this, schema2, lo, (byte[])minTier.apply(), KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$lower$default$4($this)), (Object)KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$upper($this, schema2, lo.copy(x$26, null, x$25), KuduAttributeIndex$class.upper$default$3($this), KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$upper$default$4($this)));
                        seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
                        break block3;
                    }
                    if (!(scanRange instanceof IndexKeySpace.UpperBoundedRange)) break block7;
                    IndexKeySpace.UpperBoundedRange upperBoundedRange = (IndexKeySpace.UpperBoundedRange)scanRange;
                    AttributeIndexKey hi = (AttributeIndexKey)upperBoundedRange.upper();
                    Tuple2[] tuple2Array = new Tuple2[1];
                    Object x$27 = null;
                    boolean x$28 = false;
                    short x$29 = hi.copy$default$1();
                    tuple2Array[0] = new Tuple2((Object)KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$lower($this, schema2, hi.copy(x$29, null, x$28), KuduAttributeIndex$class.lower$default$3($this), KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$lower$default$4($this)), (Object)KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$upper($this, schema2, hi, (byte[])maxTier.apply(), KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$upper$default$4($this)));
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
                    break block3;
                }
                if (!(scanRange instanceof IndexKeySpace.UnboundedRange)) break block8;
                IndexKeySpace.UnboundedRange unboundedRange = (IndexKeySpace.UnboundedRange)scanRange;
                AttributeIndexKey empty = (AttributeIndexKey)unboundedRange.empty();
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$lower($this, schema2, empty, KuduAttributeIndex$class.lower$default$3($this), KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$lower$default$4($this)), (Object)KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$upper($this, schema2, empty, KuduAttributeIndex$class.upper$default$3($this), KuduAttributeIndex$class.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$upper$default$4($this)))}));
            }
            return seq;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{range})));
    }

    public static Some org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$lower(KuduAttributeIndex $this, Schema schema2, AttributeIndexKey key, byte[] secondary, boolean prefix) {
        PartialRow row = schema2.newPartialRow();
        KuduIndexColumnAdapter$IdxColumnAdapter$.MODULE$.writeToRow(row, key.i());
        if (key.value() == null) {
            KuduIndexColumnAdapter$ValueColumnAdapter$.MODULE$.writeToRow(row, "");
        } else if (prefix || key.inclusive()) {
            KuduIndexColumnAdapter$ValueColumnAdapter$.MODULE$.writeToRow(row, key.value());
        } else {
            KuduIndexColumnAdapter$ValueColumnAdapter$.MODULE$.writeToRow(row, new StringBuilder().append((Object)key.value()).append((Object)new String(ByteArrays$.MODULE$.ZeroByteArray(), StandardCharsets.UTF_8)).toString());
        }
        KuduIndexColumnAdapter$SecondaryColumnAdapter$.MODULE$.writeToRow(row, secondary);
        KuduIndexColumnAdapter$FeatureIdAdapter$.MODULE$.writeToRow(row, "");
        return new Some((Object)row);
    }

    private static byte[] lower$default$3(KuduAttributeIndex $this) {
        return (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
    }

    public static boolean org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$lower$default$4(KuduAttributeIndex $this) {
        return false;
    }

    public static Some org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$upper(KuduAttributeIndex $this, Schema schema2, AttributeIndexKey key, byte[] secondary, boolean prefix) {
        PartialRow row = schema2.newPartialRow();
        if (key.value() == null) {
            if (key.i() + 1 == Short.MAX_VALUE) {
                KuduIndexColumnAdapter$IdxColumnAdapter$.MODULE$.writeToRow(row, key.i());
                KuduIndexColumnAdapter$ValueColumnAdapter$.MODULE$.writeToRow(row, new String(ByteArrays$.MODULE$.ZeroByteArray(), StandardCharsets.UTF_8));
            } else {
                KuduIndexColumnAdapter$IdxColumnAdapter$.MODULE$.writeToRow(row, (short)(key.i() + 1));
                KuduIndexColumnAdapter$ValueColumnAdapter$.MODULE$.writeToRow(row, "");
            }
            KuduIndexColumnAdapter$SecondaryColumnAdapter$.MODULE$.writeToRow(row, (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
        } else {
            KuduIndexColumnAdapter$IdxColumnAdapter$.MODULE$.writeToRow(row, key.i());
            if (!prefix && secondary.length != 0 && key.inclusive()) {
                KuduIndexColumnAdapter$ValueColumnAdapter$.MODULE$.writeToRow(row, key.value());
                KuduIndexColumnAdapter$SecondaryColumnAdapter$.MODULE$.writeToRow(row, secondary);
            } else {
                if (key.inclusive()) {
                    KuduIndexColumnAdapter$ValueColumnAdapter$.MODULE$.writeToRow(row, new StringBuilder().append((Object)key.value()).append((Object)new String(IndexKeySpace.ByteRange$.MODULE$.UnboundedUpperRange(), StandardCharsets.UTF_8)).toString());
                } else {
                    KuduIndexColumnAdapter$ValueColumnAdapter$.MODULE$.writeToRow(row, key.value());
                }
                KuduIndexColumnAdapter$SecondaryColumnAdapter$.MODULE$.writeToRow(row, (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
            }
        }
        KuduIndexColumnAdapter$FeatureIdAdapter$.MODULE$.writeToRow(row, "");
        return new Some((Object)row);
    }

    private static byte[] upper$default$3(KuduAttributeIndex $this) {
        return (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
    }

    public static boolean org$locationtech$geomesa$kudu$index$KuduAttributeIndex$$upper$default$4(KuduAttributeIndex $this) {
        return false;
    }

    public static void $init$(KuduAttributeIndex $this) {
        $this.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$_setter_$name_$eq(AttributeIndex$.MODULE$.Name());
        $this.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$_setter_$version_$eq(1);
        $this.org$locationtech$geomesa$kudu$index$KuduAttributeIndex$_setter_$keyColumns_$eq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KuduIndexColumnAdapter[]{KuduIndexColumnAdapter$IdxColumnAdapter$.MODULE$, KuduIndexColumnAdapter$ValueColumnAdapter$.MODULE$, KuduIndexColumnAdapter$SecondaryColumnAdapter$.MODULE$, KuduIndexColumnAdapter$FeatureIdAdapter$.MODULE$})));
    }
}

