/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kudu.index;

import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.Delete;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.OperationResponse;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.RowResult;
import org.apache.kudu.client.SessionConfiguration;
import org.apache.kudu.client.Upsert;
import org.geotools.factory.Hints;
import org.locationtech.geomesa.index.api.FilterStrategy;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.conf.QueryProperties$;
import org.locationtech.geomesa.index.index.IndexKeySpace;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.kudu.data.KuduDataStore;
import org.locationtech.geomesa.kudu.data.KuduFeature;
import org.locationtech.geomesa.kudu.data.KuduQueryPlan;
import org.locationtech.geomesa.kudu.index.KuduFeatureIndex;
import org.locationtech.geomesa.kudu.index.KuduFeatureIndex$;
import org.locationtech.geomesa.kudu.index.KuduFeatureIndex$$anonfun$removeAll$1$;
import org.locationtech.geomesa.kudu.package;
import org.locationtech.geomesa.kudu.result.KuduResultAdapter;
import org.locationtech.geomesa.kudu.result.KuduResultAdapter$;
import org.locationtech.geomesa.kudu.schema.KuduColumnAdapter;
import org.locationtech.geomesa.kudu.schema.KuduIndexColumnAdapter$VisibilityAdapter$;
import org.locationtech.geomesa.kudu.schema.KuduSimpleFeatureSchema;
import org.locationtech.geomesa.kudu.schema.KuduSimpleFeatureSchema$;
import org.locationtech.geomesa.kudu.utils.RichKuduClient;
import org.locationtech.geomesa.kudu.utils.RichKuduClient$;
import org.locationtech.geomesa.kudu.utils.RichKuduClient$RichScanner$;
import org.locationtech.geomesa.security.SecurityUtils;
import org.locationtech.geomesa.utils.cache.CacheKeyGenerator$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.locationtech.geomesa.utils.text.KVPairParser$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.ParIterableLike;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.EmptyMethodCache;
import scala.runtime.MethodCache;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public abstract class KuduFeatureIndex$class {
    private static Class[] reflParams$Cache1 = new Class[]{String.class, Filter.class};
    private static volatile SoftReference reflPoly$Cache1 = new SoftReference<EmptyMethodCache>(new EmptyMethodCache());

    public static Method reflMethod$Method1(Class x$1) {
        Method method1;
        MethodCache methodCache1 = (MethodCache)reflPoly$Cache1.get();
        if (methodCache1 == null) {
            methodCache1 = new EmptyMethodCache();
            reflPoly$Cache1 = new SoftReference<MethodCache>(methodCache1);
        }
        if ((method1 = methodCache1.find(x$1)) != null) {
            return method1;
        }
        method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("onFullTableScan", reflParams$Cache1));
        reflPoly$Cache1 = new SoftReference<MethodCache>(methodCache1.add(x$1, method1));
        return method1;
    }

    public static Option createPartition(KuduFeatureIndex $this, SimpleFeatureType sft, KuduTable table, Map splitters2, short bin) {
        return None$.MODULE$;
    }

    public static boolean supports(KuduFeatureIndex $this, SimpleFeatureType sft) {
        return $this.keySpace().supports(sft);
    }

    public static String configure(KuduFeatureIndex $this, SimpleFeatureType sft, KuduDataStore ds, Option partition) {
        BoxedUnit boxedUnit;
        String table = $this.org$locationtech$geomesa$kudu$index$KuduFeatureIndex$$super$configure(sft, ds, partition);
        if (ds.client().tableExists(table)) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            Schema schema2 = $this.tableSchema(sft);
            CreateTableOptions options = new CreateTableOptions();
            Map splitters2 = (Map)Option$.MODULE$.apply((Object)((String)sft.getUserData().get(SimpleFeatureTypes.Configs$.MODULE$.TABLE_SPLITTER_OPTS()))).map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Map<String, String> apply(String s) {
                    return KVPairParser$.MODULE$.parse(s);
                }
            }).getOrElse((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Map<String, Nothing$> apply() {
                    return Predef$.MODULE$.Map().empty();
                }
            });
            $this.configurePartitions(sft, schema2, (Map<String, String>)splitters2, options);
            int servers = ds.client().listTabletServers().getTabletServersCount();
            Object object = servers < 3 ? options.setNumReplicas(servers) : BoxedUnit.UNIT;
            boxedUnit = ds.client().createTable(table, schema2, options);
        }
        return table;
    }

    public static Function1 writer(KuduFeatureIndex $this, SimpleFeatureType sft, KuduDataStore ds) {
        KuduTable table = ds.client().openTable((String)$this.getTableNames(sft, ds, (Option)None$.MODULE$).head());
        Map<String, String> splitters2 = KuduFeatureIndex$.MODULE$.splitters(sft);
        IndexKeySpace qual$1 = $this.keySpace();
        SimpleFeatureType x$13 = sft;
        boolean x$14 = qual$1.toIndexKey$default$2();
        Function1 toIndexKey = qual$1.toIndexKey(x$13, x$14);
        KuduSimpleFeatureSchema schema2 = KuduSimpleFeatureSchema$.MODULE$.apply(sft);
        return new Serializable($this, table, splitters2, toIndexKey, schema2, sft){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KuduFeatureIndex $outer;
            private final KuduTable table$1;
            private final Map splitters$1;
            private final Function1 toIndexKey$1;
            private final KuduSimpleFeatureSchema schema$1;
            private final SimpleFeatureType sft$2;

            public final Seq<package.WriteOperation> apply(KuduFeature kf) {
                return KuduFeatureIndex$class.org$locationtech$geomesa$kudu$index$KuduFeatureIndex$$createInsert(this.$outer, this.sft$2, this.table$1, this.schema$1, this.splitters$1, this.toIndexKey$1, kf);
            }
            {
                void var6_6;
                void var5_5;
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.table$1 = table$1;
                this.splitters$1 = var3_3;
                this.toIndexKey$1 = var4_4;
                this.schema$1 = var5_5;
                this.sft$2 = var6_6;
            }
        };
    }

    public static Function1 remover(KuduFeatureIndex $this, SimpleFeatureType sft, KuduDataStore ds) {
        KuduTable table = ds.client().openTable((String)$this.getTableNames(sft, ds, (Option)None$.MODULE$).head());
        Function1 toIndexKey = $this.keySpace().toIndexKey(sft, true);
        return new Serializable($this, table, toIndexKey, sft){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KuduFeatureIndex $outer;
            private final KuduTable table$3;
            private final Function1 toIndexKey$2;
            private final SimpleFeatureType sft$3;

            public final Seq<package.WriteOperation> apply(KuduFeature kf) {
                return KuduFeatureIndex$class.org$locationtech$geomesa$kudu$index$KuduFeatureIndex$$createDelete(this.$outer, this.sft$3, this.table$3, this.toIndexKey$2, kf);
            }
            {
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.table$3 = table$3;
                this.toIndexKey$2 = var3_3;
                this.sft$3 = var4_4;
            }
        };
    }

    public static Function4 getIdFromRow(KuduFeatureIndex $this, SimpleFeatureType sft) {
        throw new NotImplementedError("Kudu does not support binary rows");
    }

    public static Seq getSplits(KuduFeatureIndex $this, SimpleFeatureType sft, Option partition) {
        throw new NotImplementedError("Kudu does not support binary splits");
    }

    public static void removeAll(KuduFeatureIndex $this, SimpleFeatureType sft, KuduDataStore ds) {
        ((ParIterableLike)$this.getTableNames(sft, ds, (Option)None$.MODULE$).par()).foreach((Function1)new Serializable($this, ds){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KuduFeatureIndex $outer;
            private final KuduDataStore ds$1;

            public final void apply(String name) {
                KuduTable table = this.ds$1.client().openTable(name);
                KuduScanner.KuduScannerBuilder builder = this.ds$1.client().newScannerBuilder(table);
                builder.setProjectedColumnNames((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.$outer.keyColumns().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<String> apply(KuduColumnAdapter<?> x$1) {
                        return (Seq)x$1.columns().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(ColumnSchema x$2) {
                                return x$2.getName();
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                    }
                }, Seq$.MODULE$.canBuildFrom())).asJava());
                WithClose$.MODULE$.apply((Object)new RichKuduClient.SessionHolder(this.ds$1.client().newSession()), (Function0)new Serializable(this, builder){
                    public static final long serialVersionUID = 0L;
                    private final KuduScanner.KuduScannerBuilder builder$1;

                    public final CloseableIterator<RowResult> apply() {
                        return RichKuduClient$RichScanner$.MODULE$.iterator$extension(RichKuduClient$.MODULE$.RichScanner(this.builder$1.build()));
                    }
                    {
                        this.builder$1 = builder$1;
                    }
                }, (Function2)new Serializable(this, table){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KuduFeatureIndex$.anonfun.removeAll.1 $outer;
                    public final KuduTable table$5;

                    public final void apply(RichKuduClient.SessionHolder x0$1, CloseableIterator<RowResult> x1$1) {
                        Tuple2 tuple2 = new Tuple2((Object)x0$1, x1$1);
                        if (tuple2 != null) {
                            RichKuduClient.SessionHolder holder = (RichKuduClient.SessionHolder)tuple2._1();
                            CloseableIterator iterator = (CloseableIterator)tuple2._2();
                            holder.session().setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND);
                            iterator.foreach((Function1)new Serializable(this, holder){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ KuduFeatureIndex$$anonfun$removeAll$1$.anonfun.apply.4 $outer;
                                private final RichKuduClient.SessionHolder holder$1;

                                public final OperationResponse apply(RowResult row) {
                                    Delete delete2 = this.$outer.table$5.newDelete();
                                    this.$outer.org$locationtech$geomesa$kudu$index$KuduFeatureIndex$$anonfun$$anonfun$$$outer().org$locationtech$geomesa$kudu$index$KuduFeatureIndex$$anonfun$$$outer().keyColumns().foreach((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final Delete delete$1;
                                        private final RowResult row$3;

                                        public final void apply(KuduColumnAdapter<?> x$3) {
                                            x$3.transfer(this.row$3, this.delete$1.getRow());
                                        }
                                        {
                                            this.delete$1 = delete$1;
                                            this.row$3 = row$3;
                                        }
                                    });
                                    return this.holder$1.session().apply((Operation)delete2);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.holder$1 = holder$1;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError((Object)tuple2);
                    }

                    public /* synthetic */ KuduFeatureIndex$.anonfun.removeAll.1 org$locationtech$geomesa$kudu$index$KuduFeatureIndex$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.table$5 = table$5;
                    }
                });
            }

            public /* synthetic */ KuduFeatureIndex org$locationtech$geomesa$kudu$index$KuduFeatureIndex$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ds$1 = ds$1;
            }
        });
    }

    public static void delete(KuduFeatureIndex $this, SimpleFeatureType sft, KuduDataStore ds, Option partition) {
        ((ParIterableLike)$this.getTableNames(sft, ds, partition).par()).foreach((Function1)new Serializable($this, ds){
            public static final long serialVersionUID = 0L;
            private final KuduDataStore ds$2;

            public final Object apply(String table) {
                return this.ds$2.client().tableExists(table) ? this.ds$2.client().deleteTable(table) : BoxedUnit.UNIT;
            }
            {
                this.ds$2 = ds$2;
            }
        });
        $this.org$locationtech$geomesa$kudu$index$KuduFeatureIndex$$super$delete(sft, ds, partition);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static QueryPlan getQueryPlan(KuduFeatureIndex $this, SimpleFeatureType sft, KuduDataStore ds, FilterStrategy filter, Hints hints, Explainer explain2) {
        Tuple2 tuple2;
        KuduQueryPlan kuduQueryPlan;
        Iterator iterator;
        Option indexValues = filter.primary().map((Function1)new Serializable($this, sft, explain2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KuduFeatureIndex $outer;
            private final SimpleFeatureType sft$4;
            private final Explainer explain$1;

            public final T apply(Filter x$4) {
                return (T)this.$outer.keySpace().getIndexValues(this.sft$4, x$4, this.explain$1);
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sft$4 = sft$4;
                this.explain$1 = var3_3;
            }
        });
        Option option = indexValues;
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (QueryHints$.MODULE$.RichHints(hints).getMaxFeatures().forall((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(int x$5) {
                    return this.apply$mcZI$sp(x$5);
                }

                public boolean apply$mcZI$sp(int x$5) {
                    return x$5 > BoxesRunTime.unboxToInt((Object)QueryProperties$.MODULE$.BlockMaxThreshold().toInt().get());
                }
            })) {
                GeoMesaSystemProperties.SystemProperty qual1 = QueryProperties$.MODULE$.BlockFullTableScans();
                try {
                    KuduFeatureIndex$class.reflMethod$Method1(qual1.getClass()).invoke((Object)qual1, sft.getTypeName(), filter.filter().getOrElse((Function0)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final IncludeFilter apply() {
                            return Filter.INCLUDE;
                        }
                    }));
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getCause();
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            filter.secondary().foreach((Function1)new Serializable($this, sft){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KuduFeatureIndex $outer;
                private final SimpleFeatureType sft$4;

                public final void apply(Filter f) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        this.$outer.logger().underlying().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running full table scan on ", " index for schema ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.name(), this.sft$4.getTypeName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with filter ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{org.locationtech.geomesa.filter.package$.MODULE$.filterToString(f)}))).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.sft$4 = sft$4;
                }
            });
            iterator = package$.MODULE$.Iterator().single((Object)new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$));
        } else {
            if (!(option instanceof Some)) throw new MatchError((Object)option);
            Some some = (Some)option;
            Object values = some.x();
            Schema schema2 = $this.tableSchema(sft);
            IndexKeySpace qual$2 = $this.keySpace();
            Object x$15 = values;
            int x$16 = qual$2.getRanges$default$2();
            iterator = qual$2.getRanges(x$15, x$16).map((Function1)new Serializable($this, schema2, sft){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KuduFeatureIndex $outer;
                private final Schema schema$2;
                private final SimpleFeatureType sft$4;

                public final Tuple2<Option<PartialRow>, Option<PartialRow>> apply(IndexKeySpace.ScanRange<U> x$6) {
                    return this.$outer.toRowRanges(this.sft$4, this.schema$2, x$6);
                }
                {
                    void var3_3;
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.schema$2 = schema$2;
                    this.sft$4 = var3_3;
                }
            });
        }
        Iterator ranges = iterator;
        if (ranges.isEmpty()) {
            kuduQueryPlan = new KuduQueryPlan.EmptyPlan((FilterStrategy<KuduDataStore, KuduFeature, package.WriteOperation>)filter);
            return kuduQueryPlan;
        }
        Seq tables = $this.getTablesForQuery(sft, ds, filter.filter());
        KuduSimpleFeatureSchema schema3 = KuduSimpleFeatureSchema$.MODULE$.apply(sft);
        Option fullFilter = $this.keySpace().useFullFilter(indexValues, (Option)new Some((Object)ds.config()), hints) ? filter.filter() : filter.secondary();
        Buffer auths = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ds.config().authProvider().getAuthorizations()).asScala()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(String x$7) {
                return x$7.getBytes(StandardCharsets.UTF_8);
            }
        }, Buffer$.MODULE$.canBuildFrom());
        KuduSimpleFeatureSchema.KuduFilter kuduFilter = (KuduSimpleFeatureSchema.KuduFilter)fullFilter.map((Function1)new Serializable($this, schema3){
            public static final long serialVersionUID = 0L;
            private final KuduSimpleFeatureSchema schema$3;

            public final KuduSimpleFeatureSchema.KuduFilter apply(Filter filter) {
                return this.schema$3.predicate(filter);
            }
            {
                this.schema$3 = schema$3;
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final KuduSimpleFeatureSchema.KuduFilter apply() {
                return new KuduSimpleFeatureSchema.KuduFilter((Seq<KuduPredicate>)((Seq)Seq$.MODULE$.empty()), (Option<Filter>)None$.MODULE$);
            }
        });
        if (kuduFilter == null) throw new MatchError((Object)kuduFilter);
        Seq<KuduPredicate> predicates = kuduFilter.predicates();
        Option<Filter> ecql = kuduFilter.filter();
        Tuple2 tuple22 = tuple2 = new Tuple2(predicates, ecql);
        Seq predicates2 = (Seq)tuple22._1();
        Option ecql2 = (Option)tuple22._2();
        KuduResultAdapter adapter = KuduResultAdapter$.MODULE$.apply(sft, (Seq<byte[]>)auths, (Option<Filter>)ecql2, hints);
        kuduQueryPlan = new KuduQueryPlan.ScanPlan((FilterStrategy<KuduDataStore, KuduFeature, package.WriteOperation>)filter, (Seq<String>)tables, (Seq<Tuple2<Option<PartialRow>, Option<PartialRow>>>)ranges.toSeq(), (Seq<KuduPredicate>)predicates2, (Option<Filter>)ecql2, adapter, ds.config().queryThreads());
        return kuduQueryPlan;
    }

    /*
     * WARNING - void declaration
     */
    public static Schema tableSchema(KuduFeatureIndex $this, SimpleFeatureType sft) {
        void var3_3;
        BoxedUnit boxedUnit;
        String key = CacheKeyGenerator$.MODULE$.cacheKey(sft);
        Schema schema2 = $this.org$locationtech$geomesa$kudu$index$KuduFeatureIndex$$tableSchemas().get(key);
        if (schema2 == null) {
            ArrayList<ColumnSchema> cols = new ArrayList<ColumnSchema>();
            ((IterableLike)$this.keyColumns().flatMap((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Seq<ColumnSchema> apply(KuduColumnAdapter<?> x$9) {
                    return x$9.columns();
                }
            }, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable($this, cols){
                public static final long serialVersionUID = 0L;
                private final ArrayList cols$1;

                public final boolean apply(ColumnSchema x$1) {
                    return this.cols$1.add(x$1);
                }
                {
                    this.cols$1 = cols$1;
                }
            });
            cols.add(KuduIndexColumnAdapter$VisibilityAdapter$.MODULE$.column());
            KuduSimpleFeatureSchema$.MODULE$.apply(sft).writeSchema().foreach((Function1)new Serializable($this, cols){
                public static final long serialVersionUID = 0L;
                private final ArrayList cols$1;

                public final boolean apply(ColumnSchema x$1) {
                    return this.cols$1.add(x$1);
                }
                {
                    this.cols$1 = cols$1;
                }
            });
            schema2 = new Schema(cols);
            boxedUnit = $this.org$locationtech$geomesa$kudu$index$KuduFeatureIndex$$tableSchemas().put(key, schema2);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    public static Seq org$locationtech$geomesa$kudu$index$KuduFeatureIndex$$createInsert(KuduFeatureIndex $this, SimpleFeatureType sft, KuduTable table, KuduSimpleFeatureSchema schema2, Map splitters2, Function1 toIndexKey, KuduFeature kf) {
        Seq<package.KuduValue<?>> featureValues = schema2.serialize(kf.feature());
        String vis = SecurityUtils.getVisibility((SimpleFeature)kf.feature());
        Serializable partitioning = new Serializable($this, sft, table, splitters2, kf){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KuduFeatureIndex $outer;
            private final SimpleFeatureType sft$1;
            private final KuduTable table$2;
            private final Map splitters$2;
            private final KuduFeature kf$1;

            public final Option<package.Partitioning> apply() {
                return this.$outer.createPartition(this.sft$1, this.table$2, (Map<String, String>)this.splitters$2, this.kf$1.bin());
            }
            {
                void var5_5;
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sft$1 = sft$1;
                this.table$2 = var3_3;
                this.splitters$2 = var4_4;
                this.kf$1 = var5_5;
            }
        };
        return (Seq)$this.createKeyValues(toIndexKey, kf).map((Function1)new Serializable($this, table, kf, featureValues, vis, (Function0)partitioning){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KuduFeatureIndex $outer;
            private final KuduTable table$2;
            private final KuduFeature kf$1;
            private final Seq featureValues$1;
            private final String vis$1;
            private final Function0 partitioning$1;

            public final package.WriteOperation apply(Seq<package.KuduValue<?>> key) {
                Upsert upsert = this.table$2.newUpsert();
                PartialRow row = upsert.getRow();
                key.foreach((Function1)new Serializable(this, row){
                    public static final long serialVersionUID = 0L;
                    private final PartialRow row$1;

                    public final void apply(package.KuduValue<?> x$10) {
                        x$10.writeToRow(this.row$1);
                    }
                    {
                        this.row$1 = row$1;
                    }
                });
                this.featureValues$1.foreach((Function1)new Serializable(this, row){
                    public static final long serialVersionUID = 0L;
                    private final PartialRow row$1;

                    public final void apply(package.KuduValue<?> x$11) {
                        x$11.writeToRow(this.row$1);
                    }
                    {
                        this.row$1 = row$1;
                    }
                });
                KuduIndexColumnAdapter$VisibilityAdapter$.MODULE$.writeToRow(row, this.vis$1);
                return new package.WriteOperation((Operation)upsert, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.identifier(), BoxesRunTime.boxToShort((short)this.kf$1.bin())})), (Function0<Option<package.Partitioning>>)this.partitioning$1);
            }
            {
                void var6_6;
                void var5_5;
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.table$2 = table$2;
                this.kf$1 = var3_3;
                this.featureValues$1 = var4_4;
                this.vis$1 = var5_5;
                this.partitioning$1 = var6_6;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static Seq org$locationtech$geomesa$kudu$index$KuduFeatureIndex$$createDelete(KuduFeatureIndex $this, SimpleFeatureType sft, KuduTable table, Function1 toIndexKey, KuduFeature kf) {
        return (Seq)$this.createKeyValues(toIndexKey, kf).map((Function1)new Serializable($this, table){
            public static final long serialVersionUID = 0L;
            private final KuduTable table$4;

            public final package.WriteOperation apply(Seq<package.KuduValue<?>> key) {
                Delete delete2 = this.table$4.newDelete();
                PartialRow row = delete2.getRow();
                key.foreach((Function1)new Serializable(this, row){
                    public static final long serialVersionUID = 0L;
                    private final PartialRow row$2;

                    public final void apply(package.KuduValue<?> x$12) {
                        x$12.writeToRow(this.row$2);
                    }
                    {
                        this.row$2 = row$2;
                    }
                });
                return new package.WriteOperation((Operation)delete2, "", null);
            }
            {
                this.table$4 = table$4;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static void $init$(KuduFeatureIndex $this) {
        $this.org$locationtech$geomesa$kudu$index$KuduFeatureIndex$_setter_$org$locationtech$geomesa$kudu$index$KuduFeatureIndex$$tableSchemas_$eq(new ConcurrentHashMap());
    }
}

