/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kudu.index;

import java.nio.charset.StandardCharsets;
import org.apache.kudu.Schema;
import org.apache.kudu.client.Delete;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.Upsert;
import org.geotools.factory.Hints;
import org.locationtech.geomesa.index.api.FilterStrategy;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.index.IndexKeySpace;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.kudu.data.KuduDataStore;
import org.locationtech.geomesa.kudu.data.KuduFeature;
import org.locationtech.geomesa.kudu.data.KuduQueryPlan;
import org.locationtech.geomesa.kudu.index.KuduFeatureIndex$;
import org.locationtech.geomesa.kudu.index.KuduTieredFeatureIndex;
import org.locationtech.geomesa.kudu.index.KuduTieredFeatureIndex$;
import org.locationtech.geomesa.kudu.package;
import org.locationtech.geomesa.kudu.result.KuduResultAdapter;
import org.locationtech.geomesa.kudu.result.KuduResultAdapter$;
import org.locationtech.geomesa.kudu.schema.KuduIndexColumnAdapter$VisibilityAdapter$;
import org.locationtech.geomesa.kudu.schema.KuduSimpleFeatureSchema;
import org.locationtech.geomesa.kudu.schema.KuduSimpleFeatureSchema$;
import org.locationtech.geomesa.security.SecurityUtils;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public abstract class KuduTieredFeatureIndex$class {
    public static Function1 writer(KuduTieredFeatureIndex $this, SimpleFeatureType sft, KuduDataStore ds) {
        KuduTable table = ds.client().openTable((String)$this.getTableNames(sft, ds, (Option)None$.MODULE$).head());
        KuduSimpleFeatureSchema schema2 = KuduSimpleFeatureSchema$.MODULE$.apply(sft);
        Map<String, String> splitters2 = KuduFeatureIndex$.MODULE$.splitters(sft);
        IndexKeySpace qual$1 = $this.keySpace();
        SimpleFeatureType x$10 = sft;
        boolean x$11 = qual$1.toIndexKey$default$2();
        Function1 toIndexKey = qual$1.toIndexKey(x$10, x$11);
        Option option = $this.tieredKeySpace(sft).map((Function1)new Serializable($this, sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$2;

            public final Function3<Seq<byte[]>, SimpleFeature, byte[], Seq<byte[]>> apply(IndexKeySpace<?, ?> x$1) {
                return x$1.toIndexKeyBytes(this.sft$2, x$1.toIndexKeyBytes$default$2());
            }
            {
                this.sft$2 = sft$2;
            }
        });
        Serializable toTieredKey = new Serializable($this, option){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KuduTieredFeatureIndex $outer;
            private final Option eta$0$1$1;

            public final Seq<byte[]> apply(SimpleFeature feature) {
                return KuduTieredFeatureIndex$class.org$locationtech$geomesa$kudu$index$KuduTieredFeatureIndex$$createTieredKey(this.$outer, this.eta$0$1$1, feature);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.eta$0$1$1 = eta$0$1$1;
            }
        };
        return new Serializable($this, table, schema2, splitters2, toIndexKey, (Function1)toTieredKey, sft){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KuduTieredFeatureIndex $outer;
            private final KuduTable table$1;
            private final KuduSimpleFeatureSchema schema$1;
            private final Map splitters$1;
            private final Function1 toIndexKey$1;
            private final Function1 toTieredKey$1;
            private final SimpleFeatureType sft$2;

            public final Seq<package.WriteOperation> apply(KuduFeature kf) {
                return KuduTieredFeatureIndex$class.org$locationtech$geomesa$kudu$index$KuduTieredFeatureIndex$$createInsert(this.$outer, this.sft$2, this.table$1, this.schema$1, this.splitters$1, this.toIndexKey$1, this.toTieredKey$1, kf);
            }
            {
                void var7_7;
                void var6_6;
                void var5_5;
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.table$1 = table$1;
                this.schema$1 = var3_3;
                this.splitters$1 = var4_4;
                this.toIndexKey$1 = var5_5;
                this.toTieredKey$1 = var6_6;
                this.sft$2 = var7_7;
            }
        };
    }

    public static Function1 remover(KuduTieredFeatureIndex $this, SimpleFeatureType sft, KuduDataStore ds) {
        KuduTable table = ds.client().openTable((String)$this.getTableNames(sft, ds, (Option)None$.MODULE$).head());
        IndexKeySpace qual$2 = $this.keySpace();
        SimpleFeatureType x$12 = sft;
        boolean x$13 = qual$2.toIndexKey$default$2();
        Function1 toIndexKey = qual$2.toIndexKey(x$12, x$13);
        Option option = $this.tieredKeySpace(sft).map((Function1)new Serializable($this, sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$3;

            public final Function3<Seq<byte[]>, SimpleFeature, byte[], Seq<byte[]>> apply(IndexKeySpace<?, ?> x$2) {
                return x$2.toIndexKeyBytes(this.sft$3, x$2.toIndexKeyBytes$default$2());
            }
            {
                this.sft$3 = sft$3;
            }
        });
        Serializable toTieredKey = new Serializable($this, option){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KuduTieredFeatureIndex $outer;
            private final Option eta$0$2$1;

            public final Seq<byte[]> apply(SimpleFeature feature) {
                return KuduTieredFeatureIndex$class.org$locationtech$geomesa$kudu$index$KuduTieredFeatureIndex$$createTieredKey(this.$outer, this.eta$0$2$1, feature);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.eta$0$2$1 = eta$0$2$1;
            }
        };
        return new Serializable($this, table, toIndexKey, (Function1)toTieredKey){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KuduTieredFeatureIndex $outer;
            private final KuduTable table$3;
            private final Function1 toIndexKey$2;
            private final Function1 toTieredKey$2;

            public final Seq<package.WriteOperation> apply(KuduFeature kf) {
                return KuduTieredFeatureIndex$class.org$locationtech$geomesa$kudu$index$KuduTieredFeatureIndex$$createDelete(this.$outer, this.table$3, this.toIndexKey$2, this.toTieredKey$2, kf);
            }
            {
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.table$3 = table$3;
                this.toIndexKey$2 = var3_3;
                this.toTieredKey$2 = var4_4;
            }
        };
    }

    public static QueryPlan getQueryPlan(KuduTieredFeatureIndex $this, SimpleFeatureType sft, KuduDataStore ds, FilterStrategy filter, Hints hints, Explainer explain2) {
        KuduSimpleFeatureSchema.KuduFilter kuduFilter;
        block5: {
            QueryPlan queryPlan;
            block3: {
                Tuple2 tuple2;
                Iterator ranges;
                Object values;
                block4: {
                    Schema kuduSchema;
                    int x$15;
                    Object x$14;
                    Filter secondary;
                    Filter primary;
                    IndexKeySpace tier;
                    VolatileByteRef bitmap$0;
                    ObjectRef tiers$lzy;
                    block2: {
                        tiers$lzy = ObjectRef.zero();
                        bitmap$0 = VolatileByteRef.create((byte)0);
                        tier = (IndexKeySpace)$this.tieredKeySpace(sft).orNull(Predef$.MODULE$.$conforms());
                        primary = (Filter)filter.primary().orNull(Predef$.MODULE$.$conforms());
                        secondary = (Filter)filter.secondary().orNull(Predef$.MODULE$.$conforms());
                        if (tier != null && primary != null && secondary != null && !KuduTieredFeatureIndex$class.tiers$1($this, tier, secondary, tiers$lzy, sft, explain2, bitmap$0).isEmpty()) break block2;
                        queryPlan = $this.org$locationtech$geomesa$kudu$index$KuduTieredFeatureIndex$$super$getQueryPlan(sft, ds, filter, hints, explain2);
                        break block3;
                    }
                    ObjectRef minTier$lzy = ObjectRef.zero();
                    ObjectRef maxTier$lzy = ObjectRef.zero();
                    values = $this.keySpace().getIndexValues(sft, primary, explain2);
                    IndexKeySpace qual$3 = $this.keySpace();
                    Iterator keyRanges = qual$3.getRanges(x$14 = values, x$15 = qual$3.getRanges$default$2());
                    ranges = keyRanges.flatMap((Function1)new Serializable($this, tier, secondary, tiers$lzy, minTier$lzy, maxTier$lzy, kuduSchema = $this.tableSchema(sft), sft, explain2, bitmap$0){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KuduTieredFeatureIndex $outer;
                        public final IndexKeySpace tier$1;
                        public final Filter secondary$1;
                        public final ObjectRef tiers$lzy$1;
                        public final ObjectRef minTier$lzy$1;
                        public final ObjectRef maxTier$lzy$1;
                        private final Schema kuduSchema$1;
                        public final SimpleFeatureType sft$4;
                        public final Explainer explain$1;
                        public final VolatileByteRef bitmap$0$1;

                        public final Seq<Tuple2<Option<PartialRow>, Option<PartialRow>>> apply(IndexKeySpace.ScanRange<U> x$3) {
                            return this.$outer.toTieredRowRanges(this.sft$4, this.kuduSchema$1, x$3, (Function0<Seq<IndexKeySpace.ByteRange>>)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ KuduTieredFeatureIndex$.anonfun.5 $outer;

                                public final Seq<IndexKeySpace.ByteRange> apply() {
                                    return KuduTieredFeatureIndex$class.tiers$1(this.$outer.org$locationtech$geomesa$kudu$index$KuduTieredFeatureIndex$$anonfun$$$outer(), this.$outer.tier$1, this.$outer.secondary$1, this.$outer.tiers$lzy$1, this.$outer.sft$4, this.$outer.explain$1, this.$outer.bitmap$0$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, (Function0<byte[]>)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ KuduTieredFeatureIndex$.anonfun.5 $outer;

                                public final byte[] apply() {
                                    return KuduTieredFeatureIndex$class.minTier$1(this.$outer.org$locationtech$geomesa$kudu$index$KuduTieredFeatureIndex$$anonfun$$$outer(), this.$outer.tier$1, this.$outer.secondary$1, this.$outer.tiers$lzy$1, this.$outer.minTier$lzy$1, this.$outer.sft$4, this.$outer.explain$1, this.$outer.bitmap$0$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, (Function0<byte[]>)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ KuduTieredFeatureIndex$.anonfun.5 $outer;

                                public final byte[] apply() {
                                    return KuduTieredFeatureIndex$class.maxTier$1(this.$outer.org$locationtech$geomesa$kudu$index$KuduTieredFeatureIndex$$anonfun$$$outer(), this.$outer.tier$1, this.$outer.secondary$1, this.$outer.tiers$lzy$1, this.$outer.maxTier$lzy$1, this.$outer.sft$4, this.$outer.explain$1, this.$outer.bitmap$0$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }

                        public /* synthetic */ KuduTieredFeatureIndex org$locationtech$geomesa$kudu$index$KuduTieredFeatureIndex$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            void var10_10;
                            void var9_9;
                            void var8_8;
                            void var7_7;
                            void var6_6;
                            void var5_5;
                            void var4_4;
                            void var3_3;
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.tier$1 = tier$1;
                            this.secondary$1 = var3_3;
                            this.tiers$lzy$1 = var4_4;
                            this.minTier$lzy$1 = var5_5;
                            this.maxTier$lzy$1 = var6_6;
                            this.kuduSchema$1 = var7_7;
                            this.sft$4 = var8_8;
                            this.explain$1 = var9_9;
                            this.bitmap$0$1 = var10_10;
                        }
                    });
                    if (!ranges.isEmpty()) break block4;
                    queryPlan = new KuduQueryPlan.EmptyPlan((FilterStrategy<KuduDataStore, KuduFeature, package.WriteOperation>)filter);
                    break block3;
                }
                KuduSimpleFeatureSchema schema2 = KuduSimpleFeatureSchema$.MODULE$.apply(sft);
                Option fullFilter = $this.keySpace().useFullFilter((Option)new Some(values), (Option)new Some((Object)ds.config()), hints) ? filter.filter() : filter.secondary();
                Buffer auths = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ds.config().authProvider().getAuthorizations()).asScala()).map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final byte[] apply(String x$4) {
                        return x$4.getBytes(StandardCharsets.UTF_8);
                    }
                }, Buffer$.MODULE$.canBuildFrom());
                kuduFilter = (KuduSimpleFeatureSchema.KuduFilter)fullFilter.map((Function1)new Serializable($this, schema2){
                    public static final long serialVersionUID = 0L;
                    private final KuduSimpleFeatureSchema schema$2;

                    public final KuduSimpleFeatureSchema.KuduFilter apply(Filter filter) {
                        return this.schema$2.predicate(filter);
                    }
                    {
                        this.schema$2 = schema$2;
                    }
                }).getOrElse((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final KuduSimpleFeatureSchema.KuduFilter apply() {
                        return new KuduSimpleFeatureSchema.KuduFilter((Seq<KuduPredicate>)((Seq)Seq$.MODULE$.empty()), (Option<Filter>)None$.MODULE$);
                    }
                });
                if (kuduFilter == null) break block5;
                Seq<KuduPredicate> predicates = kuduFilter.predicates();
                Option<Filter> ecql = kuduFilter.filter();
                Tuple2 tuple22 = tuple2 = new Tuple2(predicates, ecql);
                Seq predicates2 = (Seq)tuple22._1();
                Option ecql2 = (Option)tuple22._2();
                KuduResultAdapter adapter = KuduResultAdapter$.MODULE$.apply(sft, (Seq<byte[]>)auths, (Option<Filter>)ecql2, hints);
                Seq tables = $this.getTablesForQuery(sft, ds, filter.filter());
                queryPlan = new KuduQueryPlan.ScanPlan((FilterStrategy<KuduDataStore, KuduFeature, package.WriteOperation>)filter, (Seq<String>)tables, (Seq<Tuple2<Option<PartialRow>, Option<PartialRow>>>)ranges.toSeq(), (Seq<KuduPredicate>)predicates2, (Option<Filter>)ecql2, adapter, ds.config().queryThreads());
            }
            return queryPlan;
        }
        throw new MatchError((Object)kuduFilter);
    }

    public static Seq org$locationtech$geomesa$kudu$index$KuduTieredFeatureIndex$$createInsert(KuduTieredFeatureIndex $this, SimpleFeatureType sft, KuduTable table, KuduSimpleFeatureSchema schema2, Map splitters2, Function1 toIndexKey, Function1 toTieredIndexKey, KuduFeature kf) {
        Seq<package.KuduValue<?>> featureValues = schema2.serialize(kf.feature());
        String vis = SecurityUtils.getVisibility((SimpleFeature)kf.feature());
        Serializable partitioning = new Serializable($this, sft, table, splitters2, kf){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KuduTieredFeatureIndex $outer;
            private final SimpleFeatureType sft$1;
            private final KuduTable table$2;
            private final Map splitters$2;
            private final KuduFeature kf$1;

            public final Option<package.Partitioning> apply() {
                return this.$outer.createPartition(this.sft$1, this.table$2, (Map<String, String>)this.splitters$2, this.kf$1.bin());
            }
            {
                void var5_5;
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sft$1 = sft$1;
                this.table$2 = var3_3;
                this.splitters$2 = var4_4;
                this.kf$1 = var5_5;
            }
        };
        return (Seq)$this.createKeyValues(toIndexKey, (Function1<SimpleFeature, Seq<byte[]>>)toTieredIndexKey, kf).map((Function1)new Serializable($this, table, kf, featureValues, vis, (Function0)partitioning){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KuduTieredFeatureIndex $outer;
            private final KuduTable table$2;
            private final KuduFeature kf$1;
            private final Seq featureValues$1;
            private final String vis$1;
            private final Function0 partitioning$1;

            public final package.WriteOperation apply(Seq<package.KuduValue<?>> key) {
                Upsert upsert = this.table$2.newUpsert();
                PartialRow row = upsert.getRow();
                key.foreach((Function1)new Serializable(this, row){
                    public static final long serialVersionUID = 0L;
                    private final PartialRow row$1;

                    public final void apply(package.KuduValue<?> x$6) {
                        x$6.writeToRow(this.row$1);
                    }
                    {
                        this.row$1 = row$1;
                    }
                });
                this.featureValues$1.foreach((Function1)new Serializable(this, row){
                    public static final long serialVersionUID = 0L;
                    private final PartialRow row$1;

                    public final void apply(package.KuduValue<?> x$7) {
                        x$7.writeToRow(this.row$1);
                    }
                    {
                        this.row$1 = row$1;
                    }
                });
                KuduIndexColumnAdapter$VisibilityAdapter$.MODULE$.writeToRow(row, this.vis$1);
                return new package.WriteOperation((Operation)upsert, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.identifier(), BoxesRunTime.boxToShort((short)this.kf$1.bin())})), (Function0<Option<package.Partitioning>>)this.partitioning$1);
            }
            {
                void var6_6;
                void var5_5;
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.table$2 = table$2;
                this.kf$1 = var3_3;
                this.featureValues$1 = var4_4;
                this.vis$1 = var5_5;
                this.partitioning$1 = var6_6;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static Seq org$locationtech$geomesa$kudu$index$KuduTieredFeatureIndex$$createDelete(KuduTieredFeatureIndex $this, KuduTable table, Function1 toIndexKey, Function1 toTieredIndexKey, KuduFeature kf) {
        return (Seq)$this.createKeyValues(toIndexKey, (Function1<SimpleFeature, Seq<byte[]>>)toTieredIndexKey, kf).map((Function1)new Serializable($this, table){
            public static final long serialVersionUID = 0L;
            private final KuduTable table$4;

            public final package.WriteOperation apply(Seq<package.KuduValue<?>> key) {
                Delete delete2 = this.table$4.newDelete();
                PartialRow row = delete2.getRow();
                key.foreach((Function1)new Serializable(this, row){
                    public static final long serialVersionUID = 0L;
                    private final PartialRow row$2;

                    public final void apply(package.KuduValue<?> x$8) {
                        x$8.writeToRow(this.row$2);
                    }
                    {
                        this.row$2 = row$2;
                    }
                });
                return new package.WriteOperation((Operation)delete2, "", null);
            }
            {
                this.table$4 = table$4;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static Seq org$locationtech$geomesa$kudu$index$KuduTieredFeatureIndex$$createTieredKey(KuduTieredFeatureIndex $this, Option tieredBytes, SimpleFeature feature) {
        return (Seq)tieredBytes.map((Function1)new Serializable($this, feature){
            public static final long serialVersionUID = 0L;
            private final SimpleFeature feature$1;

            public final Seq<byte[]> apply(Function3<Seq<byte[]>, SimpleFeature, byte[], Seq<byte[]>> x$9) {
                return (Seq)x$9.apply((Object)Seq$.MODULE$.empty(), (Object)this.feature$1, Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
            }
            {
                this.feature$1 = feature$1;
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Seq<byte[]> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{(byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())}));
            }
        });
    }

    private static final Seq tiers$lzycompute$1(KuduTieredFeatureIndex $this, IndexKeySpace tier$1, Filter secondary$1, ObjectRef tiers$lzy$1, SimpleFeatureType sft$4, Explainer explain$1, VolatileByteRef bitmap$0$1) {
        KuduTieredFeatureIndex kuduTieredFeatureIndex = $this;
        synchronized (kuduTieredFeatureIndex) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                tiers$lzy$1.elem = tier$1.getRangeBytes(tier$1.getRanges(tier$1.getIndexValues(sft$4, secondary$1, explain$1), tier$1.getRanges$default$2()), tier$1.getRangeBytes$default$2(), tier$1.getRangeBytes$default$3()).toSeq();
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (Seq)tiers$lzy$1.elem;
        }
    }

    public static final Seq tiers$1(KuduTieredFeatureIndex $this, IndexKeySpace tier$1, Filter secondary$1, ObjectRef tiers$lzy$1, SimpleFeatureType sft$4, Explainer explain$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? KuduTieredFeatureIndex$class.tiers$lzycompute$1($this, tier$1, secondary$1, tiers$lzy$1, sft$4, explain$1, bitmap$0$1) : (Seq)tiers$lzy$1.elem;
    }

    private static final byte[] minTier$lzycompute$1(KuduTieredFeatureIndex $this, IndexKeySpace tier$1, Filter secondary$1, ObjectRef tiers$lzy$1, ObjectRef minTier$lzy$1, SimpleFeatureType sft$4, Explainer explain$1, VolatileByteRef bitmap$0$1) {
        KuduTieredFeatureIndex kuduTieredFeatureIndex = $this;
        synchronized (kuduTieredFeatureIndex) {
            if ((byte)(bitmap$0$1.elem & 2) == 0) {
                minTier$lzy$1.elem = IndexKeySpace.ByteRange$.MODULE$.min(KuduTieredFeatureIndex$class.tiers$1($this, tier$1, secondary$1, tiers$lzy$1, sft$4, explain$1, bitmap$0$1));
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 2);
            }
            return (byte[])minTier$lzy$1.elem;
        }
    }

    public static final byte[] minTier$1(KuduTieredFeatureIndex $this, IndexKeySpace tier$1, Filter secondary$1, ObjectRef tiers$lzy$1, ObjectRef minTier$lzy$1, SimpleFeatureType sft$4, Explainer explain$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 2) == 0 ? KuduTieredFeatureIndex$class.minTier$lzycompute$1($this, tier$1, secondary$1, tiers$lzy$1, minTier$lzy$1, sft$4, explain$1, bitmap$0$1) : (byte[])minTier$lzy$1.elem;
    }

    private static final byte[] maxTier$lzycompute$1(KuduTieredFeatureIndex $this, IndexKeySpace tier$1, Filter secondary$1, ObjectRef tiers$lzy$1, ObjectRef maxTier$lzy$1, SimpleFeatureType sft$4, Explainer explain$1, VolatileByteRef bitmap$0$1) {
        KuduTieredFeatureIndex kuduTieredFeatureIndex = $this;
        synchronized (kuduTieredFeatureIndex) {
            if ((byte)(bitmap$0$1.elem & 4) == 0) {
                maxTier$lzy$1.elem = IndexKeySpace.ByteRange$.MODULE$.max(KuduTieredFeatureIndex$class.tiers$1($this, tier$1, secondary$1, tiers$lzy$1, sft$4, explain$1, bitmap$0$1));
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 4);
            }
            return (byte[])maxTier$lzy$1.elem;
        }
    }

    public static final byte[] maxTier$1(KuduTieredFeatureIndex $this, IndexKeySpace tier$1, Filter secondary$1, ObjectRef tiers$lzy$1, ObjectRef maxTier$lzy$1, SimpleFeatureType sft$4, Explainer explain$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 4) == 0 ? KuduTieredFeatureIndex$class.maxTier$lzycompute$1($this, tier$1, secondary$1, tiers$lzy$1, maxTier$lzy$1, sft$4, explain$1, bitmap$0$1) : (byte[])maxTier$lzy$1.elem;
    }

    public static void $init$(KuduTieredFeatureIndex $this) {
    }
}

