/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kudu.index.z3;

import java.util.Collections;
import java.util.List;
import org.apache.kudu.Schema;
import org.apache.kudu.client.AlterTableOptions;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.PartialRow;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.index.conf.splitter.DefaultSplitter;
import org.locationtech.geomesa.index.index.z3.Z3IndexKey;
import org.locationtech.geomesa.kudu.data.KuduFeature;
import org.locationtech.geomesa.kudu.index.z3.KuduZ3Schema;
import org.locationtech.geomesa.kudu.index.z3.KuduZ3Schema$;
import org.locationtech.geomesa.kudu.package;
import org.locationtech.geomesa.kudu.schema.KuduIndexColumnAdapter;
import org.locationtech.geomesa.kudu.schema.KuduIndexColumnAdapter$FeatureIdAdapter$;
import org.locationtech.geomesa.kudu.schema.KuduIndexColumnAdapter$PeriodColumnAdapter$;
import org.locationtech.geomesa.kudu.schema.KuduIndexColumnAdapter$ZColumnAdapter$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.mutable.Builder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class KuduZ3Schema$class {
    public static void configurePartitions(KuduZ3Schema $this, SimpleFeatureType sft, Schema schema2, Map config, CreateTableOptions options) {
        Map map;
        int shards = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZShards$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
        Object object = shards > 1 ? options.addHashPartitions(Collections.singletonList(KuduIndexColumnAdapter$FeatureIdAdapter$.MODULE$.name()), shards) : BoxedUnit.UNIT;
        options.setRangePartitionColumns((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KuduIndexColumnAdapter$PeriodColumnAdapter$.MODULE$.name(), KuduIndexColumnAdapter$ZColumnAdapter$.MODULE$.name()}))).asJava());
        Seq configured = DefaultSplitter.Parser$.MODULE$.z3Splits(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)), config);
        if (configured.isEmpty()) {
            short bin = ((BinnedTime)BinnedTime$.MODULE$.timeToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))).apply((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis()))).bin();
            map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToShort((short)bin)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, Long.MAX_VALUE})))}));
        } else {
            map = (Map)configured.groupBy((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final short apply(Tuple2<Object, Option<Object>> x$1) {
                    return BoxesRunTime.unboxToShort((Object)x$1._1());
                }
            }).map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Seq<Object>> apply(Tuple2<Object, Seq<Tuple2<Object, Option<Object>>>> x0$1) {
                    Tuple2<Object, Seq<Tuple2<Object, Option<Object>>>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        Seq seq;
                        short bin = BoxesRunTime.unboxToShort((Object)tuple2._1());
                        Seq times = (Seq)tuple2._2();
                        Seq ts = (Seq)times.flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Iterable<Object> apply(Tuple2<Object, Option<Object>> x$2) {
                                return Option$.MODULE$.option2Iterable((Option)x$2._2());
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        if (ts.isEmpty()) {
                            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, Long.MAX_VALUE}));
                        } else {
                            Builder builder = Seq$.MODULE$.newBuilder();
                            builder.sizeHint(ts.size() + 2);
                            builder.$plus$eq((Object)BoxesRunTime.boxToLong((long)0L));
                            builder.$plus$plus$eq((TraversableOnce)ts.sorted((Ordering)Ordering.Long$.MODULE$));
                            builder.$plus$eq((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE));
                            seq = (Seq)((SeqLike)builder.result()).distinct();
                        }
                        Seq t = seq;
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToShort((short)bin)), (Object)t);
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
            }, Map$.MODULE$.canBuildFrom());
        }
        Map splits = map;
        splits.foreach((Function1)new Serializable($this, schema2, options){
            public static final long serialVersionUID = 0L;
            public final Schema schema$2;
            public final CreateTableOptions options$1;

            public final void apply(Tuple2<Object, Seq<Object>> x0$2) {
                Tuple2<Object, Seq<Object>> tuple2 = x0$2;
                if (tuple2 != null) {
                    short bin = BoxesRunTime.unboxToShort((Object)tuple2._1());
                    Seq times = (Seq)tuple2._2();
                    times.sliding(2).foreach((Function1)new Serializable(this, bin){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ KuduZ3Schema$.anonfun.configurePartitions.1 $outer;
                        private final short bin$1;

                        public final CreateTableOptions apply(Seq<Object> x0$3) {
                            Seq<Object> seq = x0$3;
                            Some some = Seq$.MODULE$.unapplySeq(seq);
                            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                long lo = BoxesRunTime.unboxToLong((Object)((SeqLike)some.get()).apply(0));
                                long hi = BoxesRunTime.unboxToLong((Object)((SeqLike)some.get()).apply(1));
                                PartialRow lower = this.$outer.schema$2.newPartialRow();
                                PartialRow upper = this.$outer.schema$2.newPartialRow();
                                lower.addShort(0, this.bin$1);
                                upper.addShort(0, this.bin$1);
                                lower.addLong(1, lo);
                                upper.addLong(1, hi);
                                CreateTableOptions createTableOptions = this.$outer.options$1.addRangePartition(lower, upper);
                                return createTableOptions;
                            }
                            throw new MatchError(seq);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.bin$1 = (short)bin$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                void var3_3;
                this.schema$2 = schema$2;
                this.options$1 = var3_3;
            }
        });
    }

    public static Option createPartition(KuduZ3Schema $this, SimpleFeatureType sft, KuduTable table, Map splitters2, short bin) {
        AlterTableOptions alteration = new AlterTableOptions();
        Seq configured = DefaultSplitter.Parser$.MODULE$.z3BitSplits(splitters2);
        Seq bitSplits = configured.isEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, Long.MAX_VALUE})) : (Seq)configured.$colon$plus((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE), Seq$.MODULE$.canBuildFrom());
        Schema schema2 = $this.tableSchema(sft);
        bitSplits.sliding(2).foreach((Function1)new Serializable($this, alteration, schema2, bin){
            public static final long serialVersionUID = 0L;
            private final AlterTableOptions alteration$1;
            private final Schema schema$1;
            private final short bin$2;

            public final AlterTableOptions apply(Seq<Object> x0$4) {
                Seq<Object> seq = x0$4;
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    long lo = BoxesRunTime.unboxToLong((Object)((SeqLike)some.get()).apply(0));
                    long hi = BoxesRunTime.unboxToLong((Object)((SeqLike)some.get()).apply(1));
                    PartialRow lower = this.schema$1.newPartialRow();
                    PartialRow upper = this.schema$1.newPartialRow();
                    lower.addShort(0, this.bin$2);
                    upper.addShort(0, this.bin$2);
                    lower.addLong(1, lo);
                    upper.addLong(1, hi);
                    AlterTableOptions alterTableOptions = this.alteration$1.addRangePartition(lower, upper);
                    return alterTableOptions;
                }
                throw new MatchError(seq);
            }
            {
                void var3_3;
                this.alteration$1 = alteration$1;
                this.schema$1 = var3_3;
                this.bin$2 = (short)bin$2;
            }
        });
        return new Some((Object)new package.Partitioning(table.getName(), alteration));
    }

    public static Seq createKeyValues(KuduZ3Schema $this, Function1 toIndexKey, KuduFeature kf) {
        package.KuduValue<String> fid = new package.KuduValue<String>(kf.feature().getID(), KuduIndexColumnAdapter$FeatureIdAdapter$.MODULE$);
        return (Seq)((TraversableLike)toIndexKey.apply((Object)kf.feature())).map((Function1)new Serializable($this, fid){
            public static final long serialVersionUID = 0L;
            private final package.KuduValue fid$1;

            public final Seq<package.KuduValue<? super String>> apply(Z3IndexKey k) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.KuduValue[]{new package.KuduValue<Object>(BoxesRunTime.boxToShort((short)k.bin()), KuduIndexColumnAdapter$PeriodColumnAdapter$.MODULE$), new package.KuduValue<Object>(BoxesRunTime.boxToLong((long)k.z()), KuduIndexColumnAdapter$ZColumnAdapter$.MODULE$), this.fid$1}));
            }
            {
                this.fid$1 = fid$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static void $init$(KuduZ3Schema $this) {
        $this.org$locationtech$geomesa$kudu$index$z3$KuduZ3Schema$_setter_$keyColumns_$eq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KuduIndexColumnAdapter[]{KuduIndexColumnAdapter$PeriodColumnAdapter$.MODULE$, KuduIndexColumnAdapter$ZColumnAdapter$.MODULE$, KuduIndexColumnAdapter$FeatureIdAdapter$.MODULE$})));
    }
}

