/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kudu.index;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.PartialRow;
import org.locationtech.geomesa.index.conf.splitter.DefaultSplitter;
import org.locationtech.geomesa.index.index.IndexKeySpace;
import org.locationtech.geomesa.index.index.id.IdIndex$;
import org.locationtech.geomesa.index.index.id.IdIndexKeySpace;
import org.locationtech.geomesa.index.index.id.IdIndexKeySpace$;
import org.locationtech.geomesa.kudu.data.KuduFeature;
import org.locationtech.geomesa.kudu.index.KuduIdIndex;
import org.locationtech.geomesa.kudu.package;
import org.locationtech.geomesa.kudu.schema.KuduIndexColumnAdapter;
import org.locationtech.geomesa.kudu.utils.ColumnConfiguration$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.Builder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class KuduIdIndex$class {
    public static IdIndexKeySpace keySpace(KuduIdIndex $this) {
        return IdIndexKeySpace$.MODULE$;
    }

    public static void configurePartitions(KuduIdIndex $this, SimpleFeatureType sft, Schema schema2, Map config, CreateTableOptions options) {
        Seq seq;
        int shards = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getIdShards$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
        Object object = shards > 1 ? options.addHashPartitions(Collections.singletonList($this.org$locationtech$geomesa$kudu$index$KuduIdIndex$$featureIdAdapter().name()), shards) : BoxedUnit.UNIT;
        options.setRangePartitionColumns(Collections.singletonList($this.org$locationtech$geomesa$kudu$index$KuduIdIndex$$featureIdAdapter().name()));
        String upperBound = new String(IndexKeySpace.ByteRange$.MODULE$.UnboundedUpperRange(), StandardCharsets.UTF_8);
        Seq configured = DefaultSplitter.Parser$.MODULE$.idSplits(config);
        if (configured.isEmpty()) {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", upperBound}));
        } else {
            Builder builder = Seq$.MODULE$.newBuilder();
            builder.sizeHint(configured.length() + 2);
            builder.$plus$eq((Object)"");
            builder.$plus$plus$eq((TraversableOnce)configured.sorted((Ordering)Ordering.String$.MODULE$));
            builder.$plus$eq((Object)upperBound);
            seq = (Seq)((SeqLike)builder.result()).distinct();
        }
        Seq idSplits = seq;
        idSplits.sliding(2).foreach((Function1)new Serializable($this, schema2, options){
            public static final long serialVersionUID = 0L;
            private final Schema schema$1;
            private final CreateTableOptions options$1;

            public final CreateTableOptions apply(Seq<String> x0$1) {
                Seq<String> seq = x0$1;
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    String lo = (String)((SeqLike)some.get()).apply(0);
                    String hi = (String)((SeqLike)some.get()).apply(1);
                    PartialRow lower = this.schema$1.newPartialRow();
                    PartialRow upper = this.schema$1.newPartialRow();
                    lower.addString(0, lo);
                    upper.addString(0, hi);
                    CreateTableOptions createTableOptions = this.options$1.addRangePartition(lower, upper);
                    return createTableOptions;
                }
                throw new MatchError(seq);
            }
            {
                this.schema$1 = schema$1;
                this.options$1 = options$1;
            }
        });
    }

    public static Seq createKeyValues(KuduIdIndex $this, Function1 toIndexKey, KuduFeature kf) {
        return (Seq)((TraversableLike)toIndexKey.apply((Object)kf.feature())).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KuduIdIndex $outer;

            public final Seq<package.KuduValue<String>> apply(byte[] key) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.KuduValue[]{new package.KuduValue<String>(new String(key, StandardCharsets.UTF_8), this.$outer.org$locationtech$geomesa$kudu$index$KuduIdIndex$$featureIdAdapter())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static Tuple2 toRowRanges(KuduIdIndex $this, SimpleFeatureType sft, Schema schema2, IndexKeySpace.ScanRange range) {
        block8: {
            Tuple2 tuple2;
            block3: {
                IndexKeySpace.ScanRange scanRange;
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    scanRange = range;
                                    if (!(scanRange instanceof IndexKeySpace.SingleRowRange)) break block2;
                                    IndexKeySpace.SingleRowRange singleRowRange = (IndexKeySpace.SingleRowRange)scanRange;
                                    byte[] row = (byte[])singleRowRange.row();
                                    tuple2 = new Tuple2((Object)KuduIdIndex$class.lower$1($this, row, schema2), (Object)KuduIdIndex$class.upper$1($this, (byte[])Predef$.MODULE$.byteArrayOps(row).$colon$plus((Object)BoxesRunTime.boxToByte((byte)ByteArrays$.MODULE$.ZeroByte()), ClassTag$.MODULE$.Byte()), schema2));
                                    break block3;
                                }
                                if (!(scanRange instanceof IndexKeySpace.BoundedRange)) break block4;
                                IndexKeySpace.BoundedRange boundedRange = (IndexKeySpace.BoundedRange)scanRange;
                                byte[] lo = (byte[])boundedRange.lower();
                                byte[] hi = (byte[])boundedRange.upper();
                                tuple2 = new Tuple2((Object)KuduIdIndex$class.lower$1($this, lo, schema2), (Object)KuduIdIndex$class.upper$1($this, hi, schema2));
                                break block3;
                            }
                            if (!(scanRange instanceof IndexKeySpace.UnboundedRange)) break block5;
                            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
                            break block3;
                        }
                        if (!(scanRange instanceof IndexKeySpace.LowerBoundedRange)) break block6;
                        IndexKeySpace.LowerBoundedRange lowerBoundedRange = (IndexKeySpace.LowerBoundedRange)scanRange;
                        byte[] lo = (byte[])lowerBoundedRange.lower();
                        tuple2 = new Tuple2((Object)KuduIdIndex$class.lower$1($this, lo, schema2), (Object)None$.MODULE$);
                        break block3;
                    }
                    if (!(scanRange instanceof IndexKeySpace.UpperBoundedRange)) break block7;
                    IndexKeySpace.UpperBoundedRange upperBoundedRange = (IndexKeySpace.UpperBoundedRange)scanRange;
                    byte[] hi = (byte[])upperBoundedRange.upper();
                    tuple2 = new Tuple2((Object)None$.MODULE$, (Object)KuduIdIndex$class.upper$1($this, hi, schema2));
                    break block3;
                }
                if (!(scanRange instanceof IndexKeySpace.PrefixRange)) break block8;
                tuple2 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
            }
            return tuple2;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{range})));
    }

    private static final Some lower$1(KuduIdIndex $this, byte[] id, Schema schema$2) {
        PartialRow row = schema$2.newPartialRow();
        $this.org$locationtech$geomesa$kudu$index$KuduIdIndex$$featureIdAdapter().writeToRow(row, new String(id, StandardCharsets.UTF_8));
        return new Some((Object)row);
    }

    private static final Some upper$1(KuduIdIndex $this, byte[] id, Schema schema$2) {
        PartialRow row = schema$2.newPartialRow();
        $this.org$locationtech$geomesa$kudu$index$KuduIdIndex$$featureIdAdapter().writeToRow(row, new String(id, StandardCharsets.UTF_8));
        return new Some((Object)row);
    }

    public static void $init$(KuduIdIndex $this) {
        $this.org$locationtech$geomesa$kudu$index$KuduIdIndex$_setter_$org$locationtech$geomesa$kudu$index$KuduIdIndex$$featureIdAdapter_$eq(new KuduIndexColumnAdapter.FeatureIdAdapter(ColumnSchema.Encoding.PREFIX_ENCODING, ColumnConfiguration$.MODULE$.compression(ColumnConfiguration$.MODULE$.compression$default$1())));
        $this.org$locationtech$geomesa$kudu$index$KuduIdIndex$_setter_$name_$eq(IdIndex$.MODULE$.Name());
        $this.org$locationtech$geomesa$kudu$index$KuduIdIndex$_setter_$version_$eq(1);
        $this.org$locationtech$geomesa$kudu$index$KuduIdIndex$_setter_$keyColumns_$eq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KuduIndexColumnAdapter.FeatureIdAdapter[]{$this.org$locationtech$geomesa$kudu$index$KuduIdIndex$$featureIdAdapter()})));
    }
}

