/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kudu.index.z2;

import java.util.Collections;
import org.apache.kudu.Schema;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.PartialRow;
import org.locationtech.geomesa.index.conf.splitter.DefaultSplitter;
import org.locationtech.geomesa.index.index.IndexKeySpace;
import org.locationtech.geomesa.kudu.data.KuduFeature;
import org.locationtech.geomesa.kudu.index.z2.KuduZ2Schema;
import org.locationtech.geomesa.kudu.package;
import org.locationtech.geomesa.kudu.schema.KuduIndexColumnAdapter;
import org.locationtech.geomesa.kudu.schema.KuduIndexColumnAdapter$FeatureIdAdapter$;
import org.locationtech.geomesa.kudu.schema.KuduIndexColumnAdapter$ZColumnAdapter$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.Builder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class KuduZ2Schema$class {
    public static void configurePartitions(KuduZ2Schema $this, SimpleFeatureType sft, Schema schema2, Map config, CreateTableOptions options) {
        Seq seq;
        int shards = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZShards$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
        Object object = shards > 1 ? options.addHashPartitions(Collections.singletonList(KuduIndexColumnAdapter$FeatureIdAdapter$.MODULE$.name()), shards) : BoxedUnit.UNIT;
        options.setRangePartitionColumns(Collections.singletonList(KuduIndexColumnAdapter$ZColumnAdapter$.MODULE$.name()));
        Seq configured = DefaultSplitter.Parser$.MODULE$.z2Splits(config);
        if (configured.isEmpty()) {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, Long.MAX_VALUE}));
        } else {
            Builder builder = Seq$.MODULE$.newBuilder();
            builder.sizeHint(configured.length() + 2);
            builder.$plus$eq((Object)BoxesRunTime.boxToLong((long)0L));
            builder.$plus$plus$eq((TraversableOnce)configured.sorted((Ordering)Ordering.Long$.MODULE$));
            builder.$plus$eq((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE));
            seq = (Seq)((SeqLike)builder.result()).distinct();
        }
        Seq bitSplits = seq;
        bitSplits.sliding(2).foreach((Function1)new Serializable($this, schema2, options){
            public static final long serialVersionUID = 0L;
            private final Schema schema$1;
            private final CreateTableOptions options$1;

            public final CreateTableOptions apply(Seq<Object> x0$1) {
                Seq<Object> seq = x0$1;
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    long lo = BoxesRunTime.unboxToLong((Object)((SeqLike)some.get()).apply(0));
                    long hi = BoxesRunTime.unboxToLong((Object)((SeqLike)some.get()).apply(1));
                    PartialRow lower = this.schema$1.newPartialRow();
                    PartialRow upper = this.schema$1.newPartialRow();
                    lower.addLong(0, lo);
                    upper.addLong(0, hi);
                    CreateTableOptions createTableOptions = this.options$1.addRangePartition(lower, upper);
                    return createTableOptions;
                }
                throw new MatchError(seq);
            }
            {
                void var3_3;
                this.schema$1 = schema$1;
                this.options$1 = var3_3;
            }
        });
    }

    public static Seq createKeyValues(KuduZ2Schema $this, Function1 toIndexKey, KuduFeature kf) {
        package.KuduValue<String> fid = new package.KuduValue<String>(kf.feature().getID(), KuduIndexColumnAdapter$FeatureIdAdapter$.MODULE$);
        return (Seq)((TraversableLike)toIndexKey.apply((Object)kf.feature())).map((Function1)new Serializable($this, fid){
            public static final long serialVersionUID = 0L;
            private final package.KuduValue fid$1;

            public final Seq<package.KuduValue<? super String>> apply(long z) {
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.KuduValue[]{new package.KuduValue<Object>(BoxesRunTime.boxToLong((long)z), KuduIndexColumnAdapter$ZColumnAdapter$.MODULE$), this.fid$1}));
            }
            {
                this.fid$1 = fid$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static Tuple2 toRowRanges(KuduZ2Schema $this, SimpleFeatureType sft, Schema schema2, IndexKeySpace.ScanRange range) {
        block4: {
            Tuple2 tuple2;
            block3: {
                IndexKeySpace.ScanRange scanRange;
                block2: {
                    scanRange = range;
                    if (!(scanRange instanceof IndexKeySpace.BoundedRange)) break block2;
                    IndexKeySpace.BoundedRange boundedRange = (IndexKeySpace.BoundedRange)scanRange;
                    long lo = boundedRange.lower$mcJ$sp();
                    long hi = boundedRange.upper$mcJ$sp();
                    tuple2 = new Tuple2((Object)KuduZ2Schema$class.lower$1($this, lo, schema2), (Object)KuduZ2Schema$class.upper$1($this, hi, schema2));
                    break block3;
                }
                if (!(scanRange instanceof IndexKeySpace.UnboundedRange)) break block4;
                tuple2 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
            }
            return tuple2;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected range type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{range})));
    }

    private static final Some lower$1(KuduZ2Schema $this, long z, Schema schema$2) {
        PartialRow row = schema$2.newPartialRow();
        KuduIndexColumnAdapter$ZColumnAdapter$.MODULE$.writeToRow(row, z);
        KuduIndexColumnAdapter$FeatureIdAdapter$.MODULE$.writeToRow(row, "");
        return new Some((Object)row);
    }

    private static final Some upper$1(KuduZ2Schema $this, long z, Schema schema$2) {
        PartialRow row = schema$2.newPartialRow();
        KuduIndexColumnAdapter$ZColumnAdapter$.MODULE$.writeToRow(row, z + 1L);
        KuduIndexColumnAdapter$FeatureIdAdapter$.MODULE$.writeToRow(row, "");
        return new Some((Object)row);
    }

    public static void $init$(KuduZ2Schema $this) {
        $this.org$locationtech$geomesa$kudu$index$z2$KuduZ2Schema$_setter_$keyColumns_$eq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KuduIndexColumnAdapter[]{KuduIndexColumnAdapter$ZColumnAdapter$.MODULE$, KuduIndexColumnAdapter$FeatureIdAdapter$.MODULE$})));
    }
}

