/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kudu.data;

import org.apache.kudu.client.KuduClient;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.locationtech.geomesa.index.conf.partition.TablePartition$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.index.index.z3.XZ3Index$;
import org.locationtech.geomesa.index.index.z3.Z3Index$;
import org.locationtech.geomesa.index.metadata.GeoMesaMetadata;
import org.locationtech.geomesa.index.metadata.MetadataStringSerializer$;
import org.locationtech.geomesa.index.stats.GeoMesaStats;
import org.locationtech.geomesa.index.stats.MetadataBackedStats;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.index.utils.LocalLocking;
import org.locationtech.geomesa.index.utils.Releasable;
import org.locationtech.geomesa.kudu.data.KuduBackedMetadata;
import org.locationtech.geomesa.kudu.data.KuduDataStoreFactory;
import org.locationtech.geomesa.kudu.data.KuduIndexAdapter;
import org.locationtech.geomesa.kudu.data.KuduQueryPlan;
import org.locationtech.geomesa.kudu.package$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\u0001\u0003\u00015\u0011QbS;ek\u0012\u000bG/Y*u_J,'BA\u0002\u0005\u0003\u0011!\u0017\r^1\u000b\u0005\u00151\u0011\u0001B6vIVT!a\u0002\u0005\u0002\u000f\u001d,w.\\3tC*\u0011\u0011BC\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\r\u0011\u0007=!b#D\u0001\u0011\u0015\t\t\"#\u0001\u0005hK>$xn\u001c7t\u0015\t\u0019b!A\u0003j]\u0012,\u00070\u0003\u0002\u0016!\t\u0001r)Z8NKN\fG)\u0019;b'R|'/\u001a\t\u0003/\u0001i\u0011A\u0001\t\u00033qi\u0011A\u0007\u0006\u00037I\tQ!\u001e;jYNL!!\b\u000e\u0003\u00191{7-\u00197M_\u000e\\\u0017N\\4\t\u0011}\u0001!Q1A\u0005\u0002\u0001\naa\u00197jK:$X#A\u0011\u0011\u0005\t:S\"A\u0012\u000b\u0005}!#BA\u0003&\u0015\t1#\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003Q\r\u0012!bS;ek\u000ec\u0017.\u001a8u\u0011!Q\u0003A!A!\u0002\u0013\t\u0013aB2mS\u0016tG\u000f\t\u0005\tY\u0001\u0011)\u0019!C![\u000511m\u001c8gS\u001e,\u0012A\f\t\u0003_}r!\u0001M\u001f\u000f\u0005EbdB\u0001\u001a<\u001d\t\u0019$H\u0004\u00025s9\u0011Q\u0007O\u0007\u0002m)\u0011q\u0007D\u0001\u0007yI|w\u000e\u001e \n\u0003-I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\t\u0019A!\u0003\u0002?\u0005\u0005!2*\u001e3v\t\u0006$\u0018m\u0015;pe\u00164\u0015m\u0019;pefL!\u0001Q!\u0003'-+H-\u001e#bi\u0006\u001cFo\u001c:f\u0007>tg-[4\u000b\u0005y\u0012\u0001\"C\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018E\u0003\u001d\u0019wN\u001c4jO\u0002J!\u0001\f\u000b\t\u000b\u0019\u0003A\u0011A$\u0002\rqJg.\u001b;?)\r1\u0002*\u0013\u0005\u0006?\u0015\u0003\r!\t\u0005\u0006Y\u0015\u0003\rA\f\u0005\b\u0017\u0002\u0011\r\u0011\"\u0011M\u0003!iW\r^1eCR\fW#A'\u0011\u00079\u0003&+D\u0001P\u0015\tY%#\u0003\u0002R\u001f\nyq)Z8NKN\fW*\u001a;bI\u0006$\u0018\r\u0005\u0002T3:\u0011AkV\u0007\u0002+*\ta+A\u0003tG\u0006d\u0017-\u0003\u0002Y+\u00061\u0001K]3eK\u001aL!AW.\u0003\rM#(/\u001b8h\u0015\tAV\u000b\u0003\u0004^\u0001\u0001\u0006I!T\u0001\n[\u0016$\u0018\rZ1uC\u0002Bqa\u0018\u0001C\u0002\u0013\u0005\u0003-A\u0004bI\u0006\u0004H/\u001a:\u0016\u0003\u0005\u0004\"a\u00062\n\u0005\r\u0014!\u0001E&vIVLe\u000eZ3y\u0003\u0012\f\u0007\u000f^3s\u0011\u0019)\u0007\u0001)A\u0005C\u0006A\u0011\rZ1qi\u0016\u0014\b\u0005C\u0004h\u0001\t\u0007I\u0011\t5\u0002\u000bM$\u0018\r^:\u0016\u0003%\u0004\"A\u001b7\u000e\u0003-T!a\u001a\n\n\u00055\\'\u0001D$f_6+7/Y*uCR\u001c\bBB8\u0001A\u0003%\u0011.\u0001\u0004ti\u0006$8\u000f\t\u0005\u0006c\u0002!\tF]\u0001\u0010aJ,7k\u00195f[\u0006\u001c%/Z1uKR\u00111O\u001e\t\u0003)RL!!^+\u0003\tUs\u0017\u000e\u001e\u0005\u0006oB\u0004\r\u0001_\u0001\u0004g\u001a$\bcA=\u0002\u00025\t!P\u0003\u0002|y\u000611/[7qY\u0016T!! @\u0002\u000f\u0019,\u0017\r^;sK*\u0011qPC\u0001\b_B,gnZ5t\u0013\r\t\u0019A\u001f\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0007&\u00029\u0002\b\u0005}\u0001#\u0002+\u0002\n\u00055\u0011bAA\u0006+\n1A\u000f\u001b:poN\u0004B!a\u0004\u0002\u001a9!\u0011\u0011CA\u000b\u001d\r)\u00141C\u0005\u0002-&\u0019\u0011qC+\u0002\u000fA\f7m[1hK&!\u00111DA\u000f\u0005aIE\u000e\\3hC2\f%oZ;nK:$X\t_2faRLwN\u001c\u0006\u0004\u0003/)6EAA\u0007\u0011\u001d\t\u0019\u0003\u0001C!\u0003K\tAbZ3u#V,'/\u001f)mC:$\u0002\"a\n\u00024\u0005\r\u00131\n\t\u0007\u0003\u001f\tI#!\f\n\t\u0005-\u0012Q\u0004\u0002\u0004'\u0016\f\bcA\f\u00020%\u0019\u0011\u0011\u0007\u0002\u0003\u001b-+H-^)vKJL\b\u000b\\1o\u0011!\t)$!\tA\u0002\u0005]\u0012!B9vKJL\b\u0003BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\r\tiD\u0003\u0002\u0012\u0015%!\u0011\u0011IA\u001e\u0005\u0015\tV/\u001a:z\u0011%\u0019\u0012\u0011\u0005I\u0001\u0002\u0004\t)\u0005\u0005\u0003U\u0003\u000f\u0012\u0016bAA%+\n1q\n\u001d;j_:D!\"!\u0014\u0002\"A\u0005\t\u0019AA(\u0003%)\u0007\u0010\u001d7bS:,'\u000fE\u0002\u001a\u0003#J1!a\u0015\u001b\u0005%)\u0005\u0010\u001d7bS:,'\u000fC\u0004\u0002X\u0001!\t%!\u0017\u0002\u000f\u0011L7\u000f]8tKR\t1\u000f")
public class KuduDataStore
extends GeoMesaDataStore<KuduDataStore>
implements LocalLocking {
    private final KuduClient client;
    private final GeoMesaMetadata<String> metadata;
    private final KuduIndexAdapter adapter;
    private final GeoMesaStats stats;

    public Releasable acquireDistributedLock(String key) {
        return LocalLocking.class.acquireDistributedLock((LocalLocking)this, (String)key);
    }

    public Option<Releasable> acquireDistributedLock(String key, long timeOut) {
        return LocalLocking.class.acquireDistributedLock((LocalLocking)this, (String)key, (long)timeOut);
    }

    public KuduClient client() {
        return this.client;
    }

    public KuduDataStoreFactory.KuduDataStoreConfig config() {
        return (KuduDataStoreFactory.KuduDataStoreConfig)super.config();
    }

    public GeoMesaMetadata<String> metadata() {
        return this.metadata;
    }

    public KuduIndexAdapter adapter() {
        return this.adapter;
    }

    public GeoMesaStats stats() {
        return this.stats;
    }

    public void preSchemaCreate(SimpleFeatureType sft) throws IllegalArgumentException {
        Object object;
        Option$.MODULE$.apply(sft.getUserData().get(SimpleFeatureTypes.Configs$.MODULE$.TABLE_SPLITTER_OPTS())).foreach((Function1)new Serializable(this, sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final Object apply(Object x$1) {
                return this.sft$1.getUserData().put(package$.MODULE$.KuduSplitterOptions(), x$1);
            }
            {
                this.sft$1 = sft$1;
            }
        });
        Object object2 = !sft.getUserData().containsKey(SimpleFeatureTypes.Configs$.MODULE$.ENABLED_INDICES()) && RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).isDefined() ? (RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)) ? sft.getUserData().put(SimpleFeatureTypes.Configs$.MODULE$.ENABLED_INDICES(), Z3Index$.MODULE$.name()) : (RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.nonPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)) ? sft.getUserData().put(SimpleFeatureTypes.Configs$.MODULE$.ENABLED_INDICES(), XZ3Index$.MODULE$.name()) : BoxedUnit.UNIT)) : BoxedUnit.UNIT;
        if (TablePartition$.MODULE$.partitioned(sft)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Table partitioning is not supported - disabling");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            object = sft.getUserData().remove(SimpleFeatureTypes.Configs$.MODULE$.TABLE_PARTITIONING());
        } else {
            object = BoxedUnit.UNIT;
        }
        super.preSchemaCreate(sft);
    }

    public Seq<KuduQueryPlan> getQueryPlan(Query query, Option<String> index, Explainer explainer) {
        return super.getQueryPlan(query, index, explainer);
    }

    public void dispose() {
        try {
            super.dispose();
            return;
        }
        finally {
            this.client().close();
        }
    }

    public KuduDataStore(KuduClient client, KuduDataStoreFactory.KuduDataStoreConfig config) {
        this.client = client;
        super((GeoMesaDataStoreFactory.GeoMesaDataStoreConfig)config);
        LocalLocking.class.$init$((LocalLocking)this);
        this.metadata = new KuduBackedMetadata(client, config.catalog(), MetadataStringSerializer$.MODULE$);
        this.adapter = new KuduIndexAdapter(this);
        this.stats = new MetadataBackedStats.RunnableStats((DataStore)this);
    }
}

