/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kudu.data;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kudu.client.KuduClient;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.kudu.data.KuduDataStoreFactory$Params$;
import org.locationtech.geomesa.kudu.package$KuduSystemProperties$;
import org.locationtech.geomesa.utils.geotools.GeoMesaParam;
import scala.Function1;
import scala.Serializable;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;

public final class KuduDataStoreFactory$
implements GeoMesaDataStoreFactory.GeoMesaDataStoreInfo,
LazyLogging {
    public static final KuduDataStoreFactory$ MODULE$;
    private final String DisplayName;
    private final String Description;
    private final GeoMesaParam<?>[] ParameterInfo;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new KuduDataStoreFactory$();
    }

    private Logger logger$lzycompute() {
        KuduDataStoreFactory$ kuduDataStoreFactory$ = this;
        synchronized (kuduDataStoreFactory$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String DisplayName() {
        return this.DisplayName;
    }

    public String Description() {
        return this.Description;
    }

    public GeoMesaParam<?>[] ParameterInfo() {
        return this.ParameterInfo;
    }

    public boolean canProcess(Map<String, java.io.Serializable> params) {
        return KuduDataStoreFactory$Params$.MODULE$.KuduMasterParam().exists(params);
    }

    public KuduClient buildClient(Map<String, java.io.Serializable> params) {
        BoxedUnit boxedUnit;
        String master = (String)KuduDataStoreFactory$Params$.MODULE$.KuduMasterParam().lookup(params);
        KuduClient.KuduClientBuilder builder = new KuduClient.KuduClientBuilder(master);
        KuduDataStoreFactory$Params$.MODULE$.WorkerThreadsParam().lookupOpt(params).foreach((Function1)new Serializable(builder){
            public static final long serialVersionUID = 0L;
            private final KuduClient.KuduClientBuilder builder$1;

            public final KuduClient.KuduClientBuilder apply(Integer i) {
                return this.builder$1.workerCount(i.intValue());
            }
            {
                this.builder$1 = builder$1;
            }
        });
        KuduDataStoreFactory$Params$.MODULE$.BossThreadsParam().lookupOpt(params).foreach((Function1)new Serializable(builder){
            public static final long serialVersionUID = 0L;
            private final KuduClient.KuduClientBuilder builder$1;

            public final KuduClient.KuduClientBuilder apply(Integer i) {
                return this.builder$1.bossCount(i.intValue());
            }
            {
                this.builder$1 = builder$1;
            }
        });
        Object object = KuduDataStoreFactory$Params$.MODULE$.StatisticsParam().lookupOpt(params).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Boolean x$4) {
                return x$4;
            }
        }) ? builder.disableStatistics() : BoxedUnit.UNIT;
        package$KuduSystemProperties$.MODULE$.AdminOperationTimeout().toDuration().foreach((Function1)new Serializable(builder){
            public static final long serialVersionUID = 0L;
            private final KuduClient.KuduClientBuilder builder$1;

            public final KuduClient.KuduClientBuilder apply(Duration d) {
                return this.builder$1.defaultAdminOperationTimeoutMs(d.toMillis());
            }
            {
                this.builder$1 = builder$1;
            }
        });
        package$KuduSystemProperties$.MODULE$.OperationTimeout().toDuration().foreach((Function1)new Serializable(builder){
            public static final long serialVersionUID = 0L;
            private final KuduClient.KuduClientBuilder builder$1;

            public final KuduClient.KuduClientBuilder apply(Duration d) {
                return this.builder$1.defaultOperationTimeoutMs(d.toMillis());
            }
            {
                this.builder$1 = builder$1;
            }
        });
        package$KuduSystemProperties$.MODULE$.SocketReadTimeout().toDuration().foreach((Function1)new Serializable(builder){
            public static final long serialVersionUID = 0L;
            private final KuduClient.KuduClientBuilder builder$1;

            public final KuduClient.KuduClientBuilder apply(Duration d) {
                return this.builder$1.defaultSocketReadTimeoutMs(d.toMillis());
            }
            {
                this.builder$1 = builder$1;
            }
        });
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Connecting to Kudu master at: {}", new Object[]{master});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        KuduClient client = builder.build();
        KuduDataStoreFactory$Params$.MODULE$.CredentialsParam().lookupOpt(params).foreach((Function1)new Serializable(client){
            public static final long serialVersionUID = 0L;
            private final KuduClient client$1;

            public final void apply(String creds) {
                this.client$1.importAuthenticationCredentials(creds.getBytes(StandardCharsets.UTF_8));
            }
            {
                this.client$1 = client$1;
            }
        });
        return client;
    }

    private KuduDataStoreFactory$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.DisplayName = "Kudu (GeoMesa)";
        this.Description = "Apache Kudu\u2122 columnar store";
        this.ParameterInfo = (GeoMesaParam[])((Object[])new GeoMesaParam[]{KuduDataStoreFactory$Params$.MODULE$.KuduMasterParam(), KuduDataStoreFactory$Params$.MODULE$.CatalogParam(), KuduDataStoreFactory$Params$.MODULE$.CredentialsParam(), KuduDataStoreFactory$Params$.MODULE$.WorkerThreadsParam(), KuduDataStoreFactory$Params$.MODULE$.BossThreadsParam(), KuduDataStoreFactory$Params$.MODULE$.QueryThreadsParam(), KuduDataStoreFactory$Params$.MODULE$.QueryTimeoutParam(), KuduDataStoreFactory$Params$.MODULE$.AuthsParam(), KuduDataStoreFactory$Params$.MODULE$.LooseBBoxParam(), KuduDataStoreFactory$Params$.MODULE$.AuditQueriesParam(), KuduDataStoreFactory$Params$.MODULE$.GenerateStatsParam(), KuduDataStoreFactory$Params$.MODULE$.StatisticsParam(), KuduDataStoreFactory$Params$.MODULE$.CachingParam()});
    }
}

