/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kudu.data;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.client.AlterTableOptions;
import org.apache.kudu.client.AlterTableResponse;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.Delete;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.OperationResponse;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.RowResult;
import org.apache.kudu.client.SessionConfiguration;
import org.apache.kudu.client.Upsert;
import org.geotools.factory.Hints;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.IndexAdapter;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.WritableFeature$;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.conf.ColumnGroups;
import org.locationtech.geomesa.kudu.data.KuduDataStore;
import org.locationtech.geomesa.kudu.data.KuduIndexAdapter$$anonfun$clearTables$2$;
import org.locationtech.geomesa.kudu.data.KuduQueryPlan;
import org.locationtech.geomesa.kudu.data.KuduWritableFeature;
import org.locationtech.geomesa.kudu.index.KuduColumnMapper;
import org.locationtech.geomesa.kudu.index.KuduColumnMapper$;
import org.locationtech.geomesa.kudu.package;
import org.locationtech.geomesa.kudu.package$KuduSystemProperties$;
import org.locationtech.geomesa.kudu.result.KuduResultAdapter;
import org.locationtech.geomesa.kudu.result.KuduResultAdapter$;
import org.locationtech.geomesa.kudu.schema.KuduColumnAdapter;
import org.locationtech.geomesa.kudu.schema.KuduIndexColumnAdapter$VisibilityAdapter$;
import org.locationtech.geomesa.kudu.schema.KuduSimpleFeatureSchema;
import org.locationtech.geomesa.kudu.schema.KuduSimpleFeatureSchema$;
import org.locationtech.geomesa.kudu.utils.RichKuduClient;
import org.locationtech.geomesa.kudu.utils.RichKuduClient$;
import org.locationtech.geomesa.kudu.utils.RichKuduClient$RichScanner$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.parallel.ParIterableLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\rea\u0001B\u0001\u0003\u00015\u0011\u0001cS;ek&sG-\u001a=BI\u0006\u0004H/\u001a:\u000b\u0005\r!\u0011\u0001\u00023bi\u0006T!!\u0002\u0004\u0002\t-,H-\u001e\u0006\u0003\u000f!\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\n\u0015\u0005aAn\\2bi&|g\u000e^3dQ*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007cA\u000b\u001b95\taC\u0003\u0002\u00181\u0005\u0019\u0011\r]5\u000b\u0005e1\u0011!B5oI\u0016D\u0018BA\u000e\u0017\u00051Ie\u000eZ3y\u0003\u0012\f\u0007\u000f^3s!\tib$D\u0001\u0003\u0013\ty\"AA\u0007Lk\u0012,H)\u0019;b'R|'/\u001a\u0005\tC\u0001\u0011\t\u0011)A\u00059\u0005\u0011Am\u001d\u0005\u0006G\u0001!\t\u0001J\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u00152\u0003CA\u000f\u0001\u0011\u0015\t#\u00051\u0001\u001d\u0011\u0015A\u0003\u0001\"\u0011*\u0003-\u0019'/Z1uKR\u000b'\r\\3\u0015\t)j\u0003\t\u0014\t\u0003\u001f-J!\u0001\f\t\u0003\tUs\u0017\u000e\u001e\u0005\u00063\u001d\u0002\rA\f\u0019\u0004_Qr\u0004\u0003B\u000b1euJ!!\r\f\u0003'\u001d+w.T3tC\u001a+\u0017\r^;sK&sG-\u001a=\u0011\u0005M\"D\u0002\u0001\u0003\nk5\n\t\u0011!A\u0003\u0002Y\u00121a\u0018\u00132#\t9$\b\u0005\u0002\u0010q%\u0011\u0011\b\u0005\u0002\b\u001d>$\b.\u001b8h!\ty1(\u0003\u0002=!\t\u0019\u0011I\\=\u0011\u0005MrD!C .\u0003\u0003\u0005\tQ!\u00017\u0005\ryFE\r\u0005\u0006\u0003\u001e\u0002\rAQ\u0001\na\u0006\u0014H/\u001b;j_:\u00042aD\"F\u0013\t!\u0005C\u0001\u0004PaRLwN\u001c\t\u0003\r&s!aD$\n\u0005!\u0003\u0012A\u0002)sK\u0012,g-\u0003\u0002K\u0017\n11\u000b\u001e:j]\u001eT!\u0001\u0013\t\t\r5;C\u00111\u0001O\u0003\u0019\u0019\b\u000f\\5ugB\u0019qbT)\n\u0005A\u0003\"\u0001\u0003\u001fcs:\fW.\u001a \u0011\u0007ISVL\u0004\u0002T1:\u0011AkV\u0007\u0002+*\u0011a\u000bD\u0001\u0007yI|w\u000e\u001e \n\u0003EI!!\u0017\t\u0002\u000fA\f7m[1hK&\u00111\f\u0018\u0002\u0004'\u0016\f(BA-\u0011!\rya\fY\u0005\u0003?B\u0011Q!\u0011:sCf\u0004\"aD1\n\u0005\t\u0004\"\u0001\u0002\"zi\u0016DQ\u0001\u001a\u0001\u0005B\u0015\fA\u0002Z3mKR,G+\u00192mKN$\"A\u000b4\t\u000b\u001d\u001c\u0007\u0019\u00015\u0002\rQ\f'\r\\3t!\r\u0011&,\u0012\u0005\u0006U\u0002!\te[\u0001\fG2,\u0017M\u001d+bE2,7\u000fF\u0002+Y6DQaZ5A\u0002!DQA\\5A\u0002=\fa\u0001\u001d:fM&D\bcA\bD;\")\u0011\u000f\u0001C!e\u0006y1M]3bi\u0016\fV/\u001a:z!2\fg\u000e\u0006\u0002tmB\u0011Q\u0004^\u0005\u0003k\n\u0011QbS;ekF+XM]=QY\u0006t\u0007\"B<q\u0001\u0004A\u0018\u0001C:ue\u0006$XmZ=\u0011\u0007e\fYAD\u0002{\u0003\u0013q1a_A\u0004\u001d\ra\u0018Q\u0001\b\u0004{\u0006\rab\u0001@\u0002\u00029\u0011Ak`\u0005\u0002\u0017%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0007\u0004\n\u0005]A\u0012BA-\u0017\u0013\u0011\ti!a\u0004\u0003\u001bE+XM]=TiJ\fG/Z4z\u0015\tIf\u0003C\u0004\u0002\u0014\u0001!\t%!\u0006\u0002\u0019\r\u0014X-\u0019;f/JLG/\u001a:\u0015\u0011\u0005]1\u0011AB\u0002\u0007/\u0001B!!\u0007\u000229!\u00111DA\u0012\u001d\u0011\ti\"!\t\u000f\u0007q\fy\"\u0003\u0002\u0006\r%\u00111\u0001B\u0004\b\u0003K\u0011\u0001\u0012AA\u0014\u0003AYU\u000fZ;J]\u0012,\u00070\u00113baR,'\u000fE\u0002\u001e\u0003S1a!\u0001\u0002\t\u0002\u0005-2cAA\u0015\u001d!91%!\u000b\u0005\u0002\u0005=BCAA\u0014\r\u001d\t\u0019$!\u000b\u0001\u0003k\u0011qbS;ek&sG-\u001a=Xe&$XM]\n\u0007\u0003c\t9$!\u0012\u0011\t\u0005e\u0012q\b\b\u0004u\u0006m\u0012bAA\u001f-\u0005a\u0011J\u001c3fq\u0006#\u0017\r\u001d;fe&!\u0011\u0011IA\"\u0005-Ie\u000eZ3y/JLG/\u001a:\u000b\u0007\u0005ub\u0003\u0005\u0003\u0002H\u0005USBAA%\u0015\u0011\tY%!\u0014\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\t\u0005=\u0013\u0011K\u0001\tif\u0004Xm]1gK*\u0011\u00111K\u0001\u0004G>l\u0017\u0002BA,\u0003\u0013\u0012Qb\u0015;sS\u000e$Hj\\4hS:<\u0007\"C\u0011\u00022\t\u0005\t\u0015!\u0003\u001d\u00115\ti&!\r\u0003\u0002\u0003\u0006I!a\u0018\u0002r\u00059\u0011N\u001c3jG\u0016\u001c\b\u0003\u0002*[\u0003C\u0002d!a\u0019\u0002h\u00055\u0004CB\u000b1\u0003K\nY\u0007E\u00024\u0003O\"1\"!\u001b\u0002\\\u0005\u0005\t\u0011!B\u0001m\t\u0019q\fJ\u001b\u0011\u0007M\ni\u0007B\u0006\u0002p\u0005m\u0013\u0011!A\u0001\u0006\u00031$aA0%m%!\u0011QLA \u0011-\t)(!\r\u0003\u0002\u0003\u0006I!a\u001e\u0002\u000f]\u0014\u0018\r\u001d9feB!\u0011\u0011PA>\u001b\t\tICB\u0004\u0002~\u0005%\u0002!a \u0003%-+H-\u001e$fCR,(/Z,sCB\u0004XM]\n\u0006\u0003wr\u0011\u0011\u0011\t\u0005\u0003\u0007\u000bIID\u0002{\u0003\u000bK1!a\"\u0017\u0003=9&/\u001b;bE2,g)Z1ukJ,\u0017\u0002BAF\u0003\u001b\u0013aBR3biV\u0014Xm\u0016:baB,'OC\u0002\u0002\bZA1\"!%\u0002|\t\u0005\t\u0015!\u0003\u0002\u0014\u0006\u00191O\u001a;\u0011\t\u0005U\u00151U\u0007\u0003\u0003/SA!!'\u0002\u001c\u000611/[7qY\u0016TA!!(\u0002 \u00069a-Z1ukJ,'bAAQ\u0015\u00059q\u000e]3oO&\u001c\u0018\u0002BAS\u0003/\u0013\u0011cU5na2,g)Z1ukJ,G+\u001f9f\u0011-\tI+a\u001f\u0003\u0002\u0003\u0006I!!!\u0002\u0011\u0011,G.Z4bi\u0016DqaIA>\t\u0003\ti\u000b\u0006\u0004\u0002x\u0005=\u0016\u0011\u0017\u0005\t\u0003#\u000bY\u000b1\u0001\u0002\u0014\"A\u0011\u0011VAV\u0001\u0004\t\t\t\u0003\u0006\u00026\u0006m$\u0019!C\u0005\u0003o\u000b\u0001\u0002\u001a;h\u0013:$W\r_\u000b\u0003\u0003s\u0003BaD\"\u0002<B\u0019q\"!0\n\u0007\u0005}\u0006CA\u0002J]RD\u0011\"a1\u0002|\u0001\u0006I!!/\u0002\u0013\u0011$x-\u00138eKb\u0004\u0003BCAd\u0003w\u0012\r\u0011\"\u0003\u0002J\u0006)Ao\u001c\"j]V\u0011\u00111\u001a\t\u0005\u0003\u001b\fIN\u0004\u0003\u0002P\u0006UWBAAi\u0015\r\t\u0019NB\u0001\u0006GV\u0014h/Z\u0005\u0005\u0003/\f\t.\u0001\u0006CS:tW\r\u001a+j[\u0016LA!a7\u0002^\n\u0001B+[7f)>\u0014\u0015N\u001c8fIRKW.\u001a\u0006\u0005\u0003/\f\t\u000eC\u0005\u0002b\u0006m\u0004\u0015!\u0003\u0002L\u00061Ao\u001c\"j]\u0002B!\"!:\u0002|\t\u0007I\u0011BAt\u0003\u0019\u00198\r[3nCV\u0011\u0011\u0011\u001e\t\u0005\u0003W\fy/\u0004\u0002\u0002n*\u0019\u0011Q\u001d\u0003\n\t\u0005E\u0018Q\u001e\u0002\u0018\u0017V$WoU5na2,g)Z1ukJ,7k\u00195f[\u0006D\u0011\"!>\u0002|\u0001\u0006I!!;\u0002\u000fM\u001c\u0007.Z7bA!A\u0011\u0011`A>\t\u0003\nY0\u0001\u0003xe\u0006\u0004H\u0003BA\u007f\u0005\u0007\u00012!HA\u0000\u0013\r\u0011\tA\u0001\u0002\u0014\u0017V$Wo\u0016:ji\u0006\u0014G.\u001a$fCR,(/\u001a\u0005\t\u0003;\u000b9\u00101\u0001\u0003\u0006A!\u0011Q\u0013B\u0004\u0013\u0011\u0011I!a&\u0003\u001bMKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0011%\t\u0015\u0011\u0007B\u0001B\u0003%!\tC\u0004$\u0003c!\tAa\u0004\u0015\u0015\tE!1\u0003B\u000b\u0005K\u00119\u0003\u0005\u0003\u0002z\u0005E\u0002BB\u0011\u0003\u000e\u0001\u0007A\u0004\u0003\u0005\u0002^\t5\u0001\u0019\u0001B\f!\u0011\u0011&L!\u00071\r\tm!q\u0004B\u0012!\u0019)\u0002G!\b\u0003\"A\u00191Ga\b\u0005\u0017\u0005%$QCA\u0001\u0002\u0003\u0015\tA\u000e\t\u0004g\t\rBaCA8\u0005+\t\t\u0011!A\u0003\u0002YB\u0001\"!\u001e\u0003\u000e\u0001\u0007\u0011q\u000f\u0005\u0007\u0003\n5\u0001\u0019\u0001\"\t\u0015\t-\u0012\u0011\u0007b\u0001\n\u0013\u0011i#\u0001\u0006qCJ$\u0018\u000e^5p]N,\"Aa\f\u0011\u000b\tE\"1H#\u000e\u0005\tM\"\u0002\u0002B\u001b\u0005o\tq!\\;uC\ndWMC\u0002\u0003:A\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011iDa\r\u0003\u0007M+G\u000fC\u0005\u0003B\u0005E\u0002\u0015!\u0003\u00030\u0005Y\u0001/\u0019:uSRLwN\\:!\u0011)\u0011)%!\rC\u0002\u0013%!qI\u0001\bg\u0016\u001c8/[8o+\t\u0011I\u0005\u0005\u0003\u0003L\tec\u0002\u0002B'\u0005'rA!!\b\u0003P%\u0019!\u0011\u000b\u0003\u0002\u000bU$\u0018\u000e\\:\n\t\tU#qK\u0001\u000f%&\u001c\u0007nS;ek\u000ec\u0017.\u001a8u\u0015\r\u0011\t\u0006B\u0005\u0005\u00057\u0012iFA\u0007TKN\u001c\u0018n\u001c8I_2$WM\u001d\u0006\u0005\u0005+\u00129\u0006C\u0005\u0003b\u0005E\u0002\u0015!\u0003\u0003J\u0005A1/Z:tS>t\u0007\u0005\u0003\u0006\u0003f\u0005E\"\u0019!C\u0005\u0005O\nq!\\1qa\u0016\u00148/\u0006\u0002\u0003jA!qB\u0018B6!\u001dy!Q\u000eB9\u0005wJ1Aa\u001c\u0011\u0005\u0019!V\u000f\u001d7feA!!1\u000fB<\u001b\t\u0011)H\u0003\u0002\u001a\t%!!\u0011\u0010B;\u0005AYU\u000fZ;D_2,XN\\'baB,'\u000f\u0005\u0003\u0003~\t%UB\u0001B@\u0015\u0011\u0011\tIa!\u0002\r\rd\u0017.\u001a8u\u0015\r)!Q\u0011\u0006\u0004\u0005\u000fS\u0011AB1qC\u000eDW-\u0003\u0003\u0003\f\n}$!C&vIV$\u0016M\u00197f\u0011%\u0011y)!\r!\u0002\u0013\u0011I'\u0001\u0005nCB\u0004XM]:!\u0011)\u0011\u0019*!\rA\u0002\u0013%!QS\u0001\u0002SV\u0011\u00111\u0018\u0005\u000b\u00053\u000b\t\u00041A\u0005\n\tm\u0015!B5`I\u0015\fHc\u0001\u0016\u0003\u001e\"Q!q\u0014BL\u0003\u0003\u0005\r!a/\u0002\u0007a$\u0013\u0007C\u0005\u0003$\u0006E\u0002\u0015)\u0003\u0002<\u0006\u0011\u0011\u000e\t\u0005\t\u0005O\u000b\t\u0004\"\u0015\u0003*\u0006)qO]5uKR9!Fa+\u00034\n\u001d\u0007\u0002CAO\u0005K\u0003\rA!,\u0011\u0007U\u0011y+C\u0002\u00032Z\u0011qb\u0016:ji\u0006\u0014G.\u001a$fCR,(/\u001a\u0005\t\u0005k\u0013)\u000b1\u0001\u00038\u00061a/\u00197vKN\u0004Ba\u00040\u0003:B\"!1\u0018Bb!\u0015I(Q\u0018Ba\u0013\u0011\u0011y,a\u0004\u0003\u0017I{woS3z-\u0006dW/\u001a\t\u0004g\t\rGa\u0003Bc\u0005g\u000b\t\u0011!A\u0003\u0002Y\u00121a\u0018\u00138\u0011!\u0011IM!*A\u0002\t-\u0017AB;qI\u0006$X\rE\u0002\u0010\u0005\u001bL1Aa4\u0011\u0005\u001d\u0011un\u001c7fC:D\u0001Ba5\u00022\u0011E#Q[\u0001\u0007I\u0016dW\r^3\u0015\u000b)\u00129N!7\t\u0011\u0005u%\u0011\u001ba\u0001\u0005[C\u0001B!.\u0003R\u0002\u0007!1\u001c\t\u0005\u001fy\u0013i\u000e\r\u0003\u0003`\n\r\b#B=\u0003>\n\u0005\bcA\u001a\u0003d\u0012Y!Q\u001dBm\u0003\u0003\u0005\tQ!\u00017\u0005\ryF\u0005\u000f\u0005\t\u0005S\f\t\u0004\"\u0011\u0003l\u0006)a\r\\;tQR\t!\u0006\u0003\u0005\u0003p\u0006EB\u0011\tBv\u0003\u0015\u0019Gn\\:f\u0011!\u0011\u00190!\r\u0005\n\tU\u0018AF3ySN$\u0018N\\4QCJ$\u0018\u000e^5p]\u0016\u0013(o\u001c:\u0015\t\t-'q\u001f\u0005\t\u0005s\u0014\t\u00101\u0001\u0003|\u0006\tQ\rE\u0002S\u0005{L1Aa@]\u0005%!\u0006N]8xC\ndW\r\u0003\u0005\u0002\u0012\u0006E\u0001\u0019AAJ\u0011!\ti&!\u0005A\u0002\r\u0015\u0001\u0003\u0002*[\u0007\u000f\u0001da!\u0003\u0004\u000e\rM\u0001CB\u000b1\u0007\u0017\u0019\t\u0002E\u00024\u0007\u001b!1ba\u0004\u0004\u0004\u0005\u0005\t\u0011!B\u0001m\t\u0019q\fJ\u001a\u0011\u0007M\u001a\u0019\u0002B\u0006\u0004\u0016\r\r\u0011\u0011!A\u0001\u0006\u00031$aA0%i!A\u0011)!\u0005\u0011\u0002\u0003\u0007!\t")
public class KuduIndexAdapter
implements IndexAdapter<KuduDataStore> {
    public final KuduDataStore org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds;
    private final ColumnGroups groups;
    private final Option<Object> tableNameLimit;

    public ColumnGroups groups() {
        return this.groups;
    }

    public Option<Object> tableNameLimit() {
        return this.tableNameLimit;
    }

    public void org$locationtech$geomesa$index$api$IndexAdapter$_setter_$groups_$eq(ColumnGroups x$1) {
        this.groups = x$1;
    }

    public void org$locationtech$geomesa$index$api$IndexAdapter$_setter_$tableNameLimit_$eq(Option x$1) {
        this.tableNameLimit = x$1;
    }

    public Option<String> createWriter$default$3() {
        return IndexAdapter.class.createWriter$default$3((IndexAdapter)this);
    }

    public void createTable(GeoMesaFeatureIndex<?, ?> index, Option<String> partition, Function0<Seq<byte[]>> splits) {
        String table = index.configureTableName(partition, index.configureTableName$default$2());
        if (!this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.client().tableExists(table)) {
            KuduColumnMapper mapper = KuduColumnMapper$.MODULE$.apply(index);
            CreateTableOptions options = mapper.configurePartitions();
            int servers = this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.client().listTabletServers().getTabletServersCount();
            Object object = servers < 3 ? options.setNumReplicas(servers) : BoxedUnit.UNIT;
            this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.client().createTable(table, mapper.tableSchema(), options);
        }
    }

    public void deleteTables(Seq<String> tables) {
        ((ParIterableLike)tables.par()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KuduIndexAdapter $outer;

            public final Object apply(String table) {
                return this.$outer.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.client().tableExists(table) ? this.$outer.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.client().deleteTable(table) : BoxedUnit.UNIT;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void clearTables(Seq<String> tables, Option<byte[]> prefix) {
        Predef$.MODULE$.require(prefix.isEmpty(), (Function0)new Serializable(this, prefix){
            public static final long serialVersionUID = 0L;
            private final Option prefix$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected None but got prefix range ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prefix$1}));
            }
            {
                this.prefix$1 = prefix$1;
            }
        });
        GeoMesaFeatureIndex[] indices = (GeoMesaFeatureIndex[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.getTypeNames()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KuduIndexAdapter $outer;

            public final SimpleFeatureType apply(String typeName) {
                return this.$outer.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.getSchema(typeName);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SimpleFeatureType.class)))).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KuduIndexAdapter $outer;

            public final Seq<GeoMesaFeatureIndex<?, ?>> apply(SimpleFeatureType x$1) {
                return this.$outer.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.manager().indices(x$1, this.$outer.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.manager().indices$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(GeoMesaFeatureIndex.class)));
        ((ParIterableLike)tables.par()).foreach((Function1)new Serializable(this, indices){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KuduIndexAdapter $outer;
            private final GeoMesaFeatureIndex[] indices$1;

            public final void apply(String name) {
                GeoMesaFeatureIndex index = (GeoMesaFeatureIndex)Predef$.MODULE$.refArrayOps((Object[])this.indices$1).find((Function1)new Serializable(this, name){
                    public static final long serialVersionUID = 0L;
                    private final String name$1;

                    public final boolean apply(GeoMesaFeatureIndex<?, ?> x$2) {
                        return x$2.getTableNames(x$2.getTableNames$default$1()).contains((Object)this.name$1);
                    }
                    {
                        this.name$1 = name$1;
                    }
                }).getOrElse((Function0)new Serializable(this, name){
                    public static final long serialVersionUID = 0L;
                    private final String name$1;

                    public final Nothing$ apply() {
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't find index corresponding to table '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1})));
                    }
                    {
                        this.name$1 = name$1;
                    }
                });
                Seq<KuduColumnAdapter<?>> columns = KuduColumnMapper$.MODULE$.apply(index).keyColumns();
                KuduTable table = this.$outer.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.client().openTable(name);
                KuduScanner.KuduScannerBuilder builder = this.$outer.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.client().newScannerBuilder(table);
                builder.setProjectedColumnNames((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)columns.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<String> apply(KuduColumnAdapter<?> x$3) {
                        return (Seq)x$3.columns().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(ColumnSchema x$4) {
                                return x$4.getName();
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                    }
                }, Seq$.MODULE$.canBuildFrom())).asJava());
                WithClose$.MODULE$.apply((Object)new RichKuduClient.SessionHolder(this.$outer.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.client().newSession()), (Function0)new Serializable(this, builder){
                    public static final long serialVersionUID = 0L;
                    private final KuduScanner.KuduScannerBuilder builder$1;

                    public final CloseableIterator<RowResult> apply() {
                        return RichKuduClient$RichScanner$.MODULE$.iterator$extension(RichKuduClient$.MODULE$.RichScanner(this.builder$1.build()));
                    }
                    {
                        this.builder$1 = builder$1;
                    }
                }, (Function2)new Serializable(this, columns, table){
                    public static final long serialVersionUID = 0L;
                    public final Seq columns$1;
                    public final KuduTable table$1;

                    public final void apply(RichKuduClient.SessionHolder x0$1, CloseableIterator<RowResult> x1$1) {
                        Tuple2 tuple2 = new Tuple2((Object)x0$1, x1$1);
                        if (tuple2 != null) {
                            RichKuduClient.SessionHolder holder = (RichKuduClient.SessionHolder)tuple2._1();
                            CloseableIterator iterator = (CloseableIterator)tuple2._2();
                            holder.session().setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND);
                            iterator.foreach((Function1)new Serializable(this, holder){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$clearTables$2$$anonfun$apply$4 $outer;
                                private final RichKuduClient.SessionHolder holder$1;

                                public final OperationResponse apply(RowResult row) {
                                    Delete delete2 = this.$outer.table$1.newDelete();
                                    this.$outer.columns$1.foreach((Function1)new Serializable(this, delete2, row){
                                        public static final long serialVersionUID = 0L;
                                        private final Delete delete$1;
                                        private final RowResult row$5;

                                        public final void apply(KuduColumnAdapter<?> x$5) {
                                            x$5.transfer(this.row$5, this.delete$1.getRow());
                                        }
                                        {
                                            this.delete$1 = delete$1;
                                            this.row$5 = row$5;
                                        }
                                    });
                                    return this.holder$1.session().apply((Operation)delete2);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.holder$1 = holder$1;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        this.columns$1 = columns$1;
                        this.table$1 = table$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.indices$1 = indices$1;
            }
        });
    }

    public KuduQueryPlan createQueryPlan(package.QueryStrategy strategy) {
        package.QueryStrategy queryStrategy = strategy;
        if (queryStrategy != null) {
            Tuple4 tuple4;
            package.FilterStrategy filter = queryStrategy.filter();
            Seq keyRanges = queryStrategy.keyRanges();
            Seq tieredKeyRanges = queryStrategy.tieredKeyRanges();
            Hints hints = queryStrategy.hints();
            Tuple4 tuple42 = tuple4 = new Tuple4((Object)filter, (Object)keyRanges, (Object)tieredKeyRanges, (Object)hints);
            package.FilterStrategy filter2 = (package.FilterStrategy)tuple42._1();
            Seq keyRanges2 = (Seq)tuple42._2();
            Seq tieredKeyRanges2 = (Seq)tuple42._3();
            Hints hints2 = (Hints)tuple42._4();
            GeoMesaFeatureIndex index = filter2.index();
            KuduColumnMapper mapper = KuduColumnMapper$.MODULE$.apply(index);
            Buffer auths = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.config().authProvider().getAuthorizations()).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte[] apply(String x$7) {
                    return x$7.getBytes(StandardCharsets.UTF_8);
                }
            }, Buffer$.MODULE$.canBuildFrom());
            KuduSimpleFeatureSchema.KuduFilter kuduFilter = (KuduSimpleFeatureSchema.KuduFilter)strategy.ecql().map((Function1)new Serializable(this, mapper){
                public static final long serialVersionUID = 0L;
                private final KuduColumnMapper mapper$1;

                public final KuduSimpleFeatureSchema.KuduFilter apply(Filter filter) {
                    return this.mapper$1.schema().predicate(filter);
                }
                {
                    this.mapper$1 = mapper$1;
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final KuduSimpleFeatureSchema.KuduFilter apply() {
                    return new KuduSimpleFeatureSchema.KuduFilter((Seq<KuduPredicate>)((Seq)Seq$.MODULE$.empty()), (Option<Filter>)None$.MODULE$);
                }
            });
            if (kuduFilter != null) {
                KuduQueryPlan kuduQueryPlan;
                Tuple2 tuple2;
                Seq<KuduPredicate> predicates = kuduFilter.predicates();
                Option<Filter> ecql = kuduFilter.filter();
                Tuple2 tuple22 = tuple2 = new Tuple2(predicates, ecql);
                Seq predicates2 = (Seq)tuple22._1();
                Option ecql2 = (Option)tuple22._2();
                KuduResultAdapter adapter = KuduResultAdapter$.MODULE$.apply(index.sft(), (Seq<byte[]>)auths, (Option<Filter>)ecql2, hints2);
                if (keyRanges2.isEmpty()) {
                    kuduQueryPlan = new KuduQueryPlan.EmptyPlan(filter2, adapter);
                } else {
                    Seq tables = index.getTablesForQuery(filter2.filter());
                    Seq<Tuple2<Option<PartialRow>, Option<PartialRow>>> ranges = mapper.toRowRanges(keyRanges2, (Seq<package.ByteRange>)tieredKeyRanges2);
                    kuduQueryPlan = new KuduQueryPlan.ScanPlan(filter2, (Seq<String>)tables, ranges, (Seq<KuduPredicate>)predicates2, (Option<Filter>)ecql2, adapter, this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.config().queryThreads());
                }
                return kuduQueryPlan;
            }
            throw new MatchError((Object)kuduFilter);
        }
        throw new MatchError((Object)queryStrategy);
    }

    public KuduIndexWriter createWriter(SimpleFeatureType sft, Seq<GeoMesaFeatureIndex<?, ?>> indices, Option<String> partition) {
        return new KuduIndexWriter(this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds, indices, new KuduFeatureWrapper(sft, WritableFeature$.MODULE$.wrapper(sft, this.groups())), partition);
    }

    public KuduIndexAdapter(KuduDataStore ds) {
        this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds = ds;
        IndexAdapter.class.$init$((IndexAdapter)this);
    }

    public static class KuduIndexWriter
    extends IndexAdapter.IndexWriter
    implements StrictLogging {
        public final KuduDataStore org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$ds;
        public final Option<String> org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$partition;
        private final Set<String> partitions;
        private final RichKuduClient.SessionHolder org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$session;
        private final Tuple2<KuduColumnMapper, KuduTable>[] mappers;
        private int i;
        private final Logger logger;

        public Logger logger() {
            return this.logger;
        }

        public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
            this.logger = x$1;
        }

        private Set<String> partitions() {
            return this.partitions;
        }

        public RichKuduClient.SessionHolder org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$session() {
            return this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$session;
        }

        private Tuple2<KuduColumnMapper, KuduTable>[] mappers() {
            return this.mappers;
        }

        private int i() {
            return this.i;
        }

        private void i_$eq(int x$1) {
            this.i = x$1;
        }

        public void write(WritableFeature feature, package.RowKeyValue<?>[] values, boolean update) {
            KuduWritableFeature kf = (KuduWritableFeature)feature;
            this.i_$eq(0);
            while (this.i() < values.length) {
                Tuple2<KuduColumnMapper, KuduTable> tuple2;
                block5: {
                    package.RowKeyValue<?> rowKeyValue;
                    block8: {
                        block7: {
                            BoxedUnit boxedUnit;
                            KuduTable table;
                            KuduColumnMapper mapper;
                            block6: {
                                Tuple2 tuple22;
                                tuple2 = this.mappers()[this.i()];
                                if (tuple2 == null) break block5;
                                KuduColumnMapper mapper2 = (KuduColumnMapper)tuple2._1();
                                KuduTable table2 = (KuduTable)tuple2._2();
                                Tuple2 tuple23 = tuple22 = new Tuple2((Object)mapper2, (Object)table2);
                                mapper = (KuduColumnMapper)tuple23._1();
                                table = (KuduTable)tuple23._2();
                                if (this.partitions().add((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mapper.index().identifier(), BoxesRunTime.boxToShort((short)kf.bin())})))) {
                                    mapper.createPartition(table, kf.bin()).foreach((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ KuduIndexWriter $outer;

                                        /*
                                         * Enabled force condition propagation
                                         * Lifted jumps to return sites
                                         */
                                        public final Object apply(package.Partitioning x0$2) {
                                            AlterTableResponse alterTableResponse;
                                            package.Partitioning partitioning = x0$2;
                                            if (partitioning == null) throw new MatchError((Object)partitioning);
                                            String name = partitioning.table();
                                            AlterTableOptions alter = partitioning.alteration();
                                            try {
                                                alterTableResponse = this.$outer.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$ds.client().alterTable(name, alter);
                                                return alterTableResponse;
                                            }
                                            catch (Throwable throwable22) {
                                                BoxedUnit boxedUnit;
                                                Throwable throwable3 = throwable22;
                                                if (!this.$outer.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$existingPartitionError(throwable3)) throw throwable22;
                                                if (this.$outer.logger().underlying().isDebugEnabled()) {
                                                    this.$outer.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tried to create a partition to table ", " but it already exists: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), throwable3);
                                                    boxedUnit = BoxedUnit.UNIT;
                                                } else {
                                                    boxedUnit = BoxedUnit.UNIT;
                                                }
                                                BoxedUnit boxedUnit2 = boxedUnit;
                                                alterTableResponse = boxedUnit2;
                                            }
                                            return alterTableResponse;
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                }
                                if (!((rowKeyValue = values[this.i()]) instanceof package.SingleRowKeyValue)) break block6;
                                package.SingleRowKeyValue singleRowKeyValue = (package.SingleRowKeyValue)rowKeyValue;
                                Upsert upsert = table.newUpsert();
                                PartialRow row = upsert.getRow();
                                mapper.createKeyValues(singleRowKeyValue).foreach((Function1)new Serializable(this, row){
                                    public static final long serialVersionUID = 0L;
                                    private final PartialRow row$1;

                                    public final void apply(package.KuduValue<?> x$10) {
                                        x$10.writeToRow(this.row$1);
                                    }
                                    {
                                        this.row$1 = row$1;
                                    }
                                });
                                kf.kuduValues().foreach((Function1)new Serializable(this, row){
                                    public static final long serialVersionUID = 0L;
                                    private final PartialRow row$1;

                                    public final void apply(package.KuduValue<?> x$11) {
                                        x$11.writeToRow(this.row$1);
                                    }
                                    {
                                        this.row$1 = row$1;
                                    }
                                });
                                KuduIndexColumnAdapter$VisibilityAdapter$.MODULE$.writeToRow(row, kf.vis());
                                boxedUnit = this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$session().session().apply((Operation)upsert);
                                break block7;
                            }
                            if (!(rowKeyValue instanceof package.MultiRowKeyValue)) break block8;
                            package.MultiRowKeyValue multiRowKeyValue = (package.MultiRowKeyValue)rowKeyValue;
                            multiRowKeyValue.split().foreach((Function1)new Serializable(this, kf, mapper, table){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ KuduIndexWriter $outer;
                                private final KuduWritableFeature kf$1;
                                private final KuduColumnMapper mapper$2;
                                private final KuduTable table$2;

                                public final OperationResponse apply(package.SingleRowKeyValue<Object> kv) {
                                    Upsert upsert = this.table$2.newUpsert();
                                    PartialRow row = upsert.getRow();
                                    this.mapper$2.createKeyValues(kv).foreach((Function1)new Serializable(this, row){
                                        public static final long serialVersionUID = 0L;
                                        private final PartialRow row$2;

                                        public final void apply(package.KuduValue<?> x$12) {
                                            x$12.writeToRow(this.row$2);
                                        }
                                        {
                                            this.row$2 = row$2;
                                        }
                                    });
                                    this.kf$1.kuduValues().foreach((Function1)new Serializable(this, row){
                                        public static final long serialVersionUID = 0L;
                                        private final PartialRow row$2;

                                        public final void apply(package.KuduValue<?> x$13) {
                                            x$13.writeToRow(this.row$2);
                                        }
                                        {
                                            this.row$2 = row$2;
                                        }
                                    });
                                    KuduIndexColumnAdapter$VisibilityAdapter$.MODULE$.writeToRow(row, this.kf$1.vis());
                                    return this.$outer.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$session().session().apply((Operation)upsert);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.kf$1 = kf$1;
                                    this.mapper$2 = mapper$2;
                                    this.table$2 = table$2;
                                }
                            });
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        this.i_$eq(this.i() + 1);
                        continue;
                    }
                    throw new MatchError(rowKeyValue);
                }
                throw new MatchError(tuple2);
            }
        }

        public void delete(WritableFeature feature, package.RowKeyValue<?>[] values) {
            this.i_$eq(0);
            while (this.i() < values.length) {
                Tuple2<KuduColumnMapper, KuduTable> tuple2;
                block3: {
                    package.RowKeyValue<?> rowKeyValue;
                    block6: {
                        block5: {
                            BoxedUnit boxedUnit;
                            KuduTable table;
                            KuduColumnMapper mapper;
                            block4: {
                                Tuple2 tuple22;
                                tuple2 = this.mappers()[this.i()];
                                if (tuple2 == null) break block3;
                                KuduColumnMapper mapper2 = (KuduColumnMapper)tuple2._1();
                                KuduTable table2 = (KuduTable)tuple2._2();
                                Tuple2 tuple23 = tuple22 = new Tuple2((Object)mapper2, (Object)table2);
                                mapper = (KuduColumnMapper)tuple23._1();
                                table = (KuduTable)tuple23._2();
                                rowKeyValue = values[this.i()];
                                if (!(rowKeyValue instanceof package.SingleRowKeyValue)) break block4;
                                package.SingleRowKeyValue singleRowKeyValue = (package.SingleRowKeyValue)rowKeyValue;
                                Delete delete2 = table.newDelete();
                                PartialRow row = delete2.getRow();
                                mapper.createKeyValues(singleRowKeyValue).foreach((Function1)new Serializable(this, row){
                                    public static final long serialVersionUID = 0L;
                                    private final PartialRow row$3;

                                    public final void apply(package.KuduValue<?> x$15) {
                                        x$15.writeToRow(this.row$3);
                                    }
                                    {
                                        this.row$3 = row$3;
                                    }
                                });
                                boxedUnit = this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$session().session().apply((Operation)delete2);
                                break block5;
                            }
                            if (!(rowKeyValue instanceof package.MultiRowKeyValue)) break block6;
                            package.MultiRowKeyValue multiRowKeyValue = (package.MultiRowKeyValue)rowKeyValue;
                            multiRowKeyValue.split().foreach((Function1)new Serializable(this, mapper, table){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ KuduIndexWriter $outer;
                                private final KuduColumnMapper mapper$3;
                                private final KuduTable table$3;

                                public final OperationResponse apply(package.SingleRowKeyValue<Object> kv) {
                                    Delete delete2 = this.table$3.newDelete();
                                    PartialRow row = delete2.getRow();
                                    this.mapper$3.createKeyValues(kv).foreach((Function1)new Serializable(this, row){
                                        public static final long serialVersionUID = 0L;
                                        private final PartialRow row$4;

                                        public final void apply(package.KuduValue<?> x$16) {
                                            x$16.writeToRow(this.row$4);
                                        }
                                        {
                                            this.row$4 = row$4;
                                        }
                                    });
                                    return this.$outer.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$session().session().apply((Operation)delete2);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.mapper$3 = mapper$3;
                                    this.table$3 = table$3;
                                }
                            });
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        this.i_$eq(this.i() + 1);
                        continue;
                    }
                    throw new MatchError(rowKeyValue);
                }
                throw new MatchError(tuple2);
            }
        }

        public void flush() {
            this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$session().flush();
        }

        public void close() {
            this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$session().close();
        }

        public boolean org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$existingPartitionError(Throwable e) {
            return e.getMessage() != null && e.getMessage().startsWith("New range partition conflicts with existing range partition");
        }

        public KuduIndexWriter(KuduDataStore ds, Seq<GeoMesaFeatureIndex<?, ?>> indices, KuduFeatureWrapper wrapper, Option<String> partition) {
            this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$ds = ds;
            this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$partition = partition;
            super(indices, (WritableFeature.FeatureWrapper)wrapper);
            StrictLogging.class.$init$((StrictLogging)this);
            this.partitions = Set$.MODULE$.empty();
            this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$session = new RichKuduClient.SessionHolder(ds.client().newSession());
            this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$session().session().setMutationBufferSpace(BoxesRunTime.unboxToInt((Object)package$KuduSystemProperties$.MODULE$.MutationBufferSpace().toInt().get()));
            this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$session().session().setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND);
            this.mappers = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])super.indices().toArray(ClassTag$.MODULE$.apply(GeoMesaFeatureIndex.class))).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KuduIndexWriter $outer;

                public final Tuple2<KuduColumnMapper, KuduTable> apply(GeoMesaFeatureIndex<?, ?> index) {
                    KuduColumnMapper mapper = KuduColumnMapper$.MODULE$.apply(index);
                    Seq seq = index.getTableNames(this.$outer.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$partition);
                    Some some = Seq$.MODULE$.unapplySeq(seq);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
                        KuduTable kuduTable;
                        String t = (String)((SeqLike)some.get()).apply(0);
                        KuduTable table = kuduTable = this.$outer.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$ds.client().openTable(t);
                        return new Tuple2((Object)mapper, (Object)table);
                    }
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected a single table but got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seq.mkString(", ")})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            this.i = 0;
        }
    }

    public static class KuduFeatureWrapper
    implements WritableFeature.FeatureWrapper {
        private final WritableFeature.FeatureWrapper delegate;
        private final Option<Object> dtgIndex;
        private final Function1<Object, BinnedTime> toBin;
        private final KuduSimpleFeatureSchema schema;

        private Option<Object> dtgIndex() {
            return this.dtgIndex;
        }

        private Function1<Object, BinnedTime> toBin() {
            return this.toBin;
        }

        private KuduSimpleFeatureSchema schema() {
            return this.schema;
        }

        public KuduWritableFeature wrap(SimpleFeature feature) {
            return new KuduWritableFeature(this.delegate.wrap(feature), this.schema(), this.dtgIndex(), this.toBin());
        }

        public KuduFeatureWrapper(SimpleFeatureType sft, WritableFeature.FeatureWrapper delegate) {
            this.delegate = delegate;
            this.dtgIndex = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
            this.toBin = BinnedTime$.MODULE$.timeToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
            this.schema = KuduSimpleFeatureSchema$.MODULE$.apply(sft);
        }
    }
}

