/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kudu.data;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.client.AlterTableOptions;
import org.apache.kudu.client.AlterTableResponse;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.Delete;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.OperationResponse;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.RowResult;
import org.apache.kudu.client.SessionConfiguration;
import org.apache.kudu.client.Upsert;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.IndexAdapter;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.WritableFeature$;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.conf.ColumnGroups;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.utils.Reprojection;
import org.locationtech.geomesa.kudu.data.KuduDataStore;
import org.locationtech.geomesa.kudu.data.KuduIndexAdapter$$anonfun$clearTables$2$;
import org.locationtech.geomesa.kudu.data.KuduQueryPlan;
import org.locationtech.geomesa.kudu.data.KuduWritableFeature;
import org.locationtech.geomesa.kudu.index.KuduColumnMapper;
import org.locationtech.geomesa.kudu.index.KuduColumnMapper$;
import org.locationtech.geomesa.kudu.package;
import org.locationtech.geomesa.kudu.package$KuduSystemProperties$;
import org.locationtech.geomesa.kudu.result.KuduResultAdapter;
import org.locationtech.geomesa.kudu.result.KuduResultAdapter$;
import org.locationtech.geomesa.kudu.schema.KuduColumnAdapter;
import org.locationtech.geomesa.kudu.schema.KuduIndexColumnAdapter$VisibilityAdapter$;
import org.locationtech.geomesa.kudu.schema.KuduSimpleFeatureSchema;
import org.locationtech.geomesa.kudu.schema.KuduSimpleFeatureSchema$;
import org.locationtech.geomesa.kudu.utils.RichKuduClient;
import org.locationtech.geomesa.kudu.utils.RichKuduClient$;
import org.locationtech.geomesa.kudu.utils.RichKuduClient$RichScanner$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.parallel.ParIterableLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\r-b\u0001B\u0001\u0003\u00015\u0011\u0001cS;ek&sG-\u001a=BI\u0006\u0004H/\u001a:\u000b\u0005\r!\u0011\u0001\u00023bi\u0006T!!\u0002\u0004\u0002\t-,H-\u001e\u0006\u0003\u000f!\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\n\u0015\u0005aAn\\2bi&|g\u000e^3dQ*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007cA\u000b\u001b95\taC\u0003\u0002\u00181\u0005\u0019\u0011\r]5\u000b\u0005e1\u0011!B5oI\u0016D\u0018BA\u000e\u0017\u00051Ie\u000eZ3y\u0003\u0012\f\u0007\u000f^3s!\tib$D\u0001\u0003\u0013\ty\"AA\u0007Lk\u0012,H)\u0019;b'R|'/\u001a\u0005\tC\u0001\u0011\t\u0011)A\u00059\u0005\u0011Am\u001d\u0005\u0006G\u0001!\t\u0001J\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u00152\u0003CA\u000f\u0001\u0011\u0015\t#\u00051\u0001\u001d\u0011\u0015A\u0003\u0001\"\u0011*\u0003-\u0019'/Z1uKR\u000b'\r\\3\u0015\t)j\u0003\t\u0014\t\u0003\u001f-J!\u0001\f\t\u0003\tUs\u0017\u000e\u001e\u0005\u00063\u001d\u0002\rA\f\u0019\u0004_Qr\u0004\u0003B\u000b1euJ!!\r\f\u0003'\u001d+w.T3tC\u001a+\u0017\r^;sK&sG-\u001a=\u0011\u0005M\"D\u0002\u0001\u0003\nk5\n\t\u0011!A\u0003\u0002Y\u00121a\u0018\u00132#\t9$\b\u0005\u0002\u0010q%\u0011\u0011\b\u0005\u0002\b\u001d>$\b.\u001b8h!\ty1(\u0003\u0002=!\t\u0019\u0011I\\=\u0011\u0005MrD!C .\u0003\u0003\u0005\tQ!\u00017\u0005\ryFE\r\u0005\u0006\u0003\u001e\u0002\rAQ\u0001\na\u0006\u0014H/\u001b;j_:\u00042aD\"F\u0013\t!\u0005C\u0001\u0004PaRLwN\u001c\t\u0003\r&s!aD$\n\u0005!\u0003\u0012A\u0002)sK\u0012,g-\u0003\u0002K\u0017\n11\u000b\u001e:j]\u001eT!\u0001\u0013\t\t\r5;C\u00111\u0001O\u0003\u0019\u0019\b\u000f\\5ugB\u0019qbT)\n\u0005A\u0003\"\u0001\u0003\u001fcs:\fW.\u001a \u0011\u0007ISVL\u0004\u0002T1:\u0011AkV\u0007\u0002+*\u0011a\u000bD\u0001\u0007yI|w\u000e\u001e \n\u0003EI!!\u0017\t\u0002\u000fA\f7m[1hK&\u00111\f\u0018\u0002\u0004'\u0016\f(BA-\u0011!\rya\fY\u0005\u0003?B\u0011Q!\u0011:sCf\u0004\"aD1\n\u0005\t\u0004\"\u0001\u0002\"zi\u0016DQ\u0001\u001a\u0001\u0005B\u0015\f1B]3oC6,G+\u00192mKR\u0019!F\u001a5\t\u000b\u001d\u001c\u0007\u0019A#\u0002\t\u0019\u0014x.\u001c\u0005\u0006S\u000e\u0004\r!R\u0001\u0003i>DQa\u001b\u0001\u0005B1\fA\u0002Z3mKR,G+\u00192mKN$\"AK7\t\u000b9T\u0007\u0019A8\u0002\rQ\f'\r\\3t!\r\u0011&,\u0012\u0005\u0006c\u0002!\tE]\u0001\fG2,\u0017M\u001d+bE2,7\u000fF\u0002+gRDQA\u001c9A\u0002=DQ!\u001e9A\u0002Y\fa\u0001\u001d:fM&D\bcA\bD;\")\u0001\u0010\u0001C!s\u0006y1M]3bi\u0016\fV/\u001a:z!2\fg\u000e\u0006\u0002{{B\u0011Qd_\u0005\u0003y\n\u0011QbS;ekF+XM]=QY\u0006t\u0007\"\u0002@x\u0001\u0004y\u0018\u0001C:ue\u0006$XmZ=\u0011\t\u0005\u0005\u0011\u0011\u0004\b\u0005\u0003\u0007\t9B\u0004\u0003\u0002\u0006\u0005Ua\u0002BA\u0004\u0003'qA!!\u0003\u0002\u00129!\u00111BA\b\u001d\r!\u0016QB\u0005\u0002\u0017%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0007\u0004\n\u0005]A\u0012BA-\u0017\u0013\u0011\tY\"!\b\u0003\u001bE+XM]=TiJ\fG/Z4z\u0015\tIf\u0003C\u0004\u0002\"\u0001!\t%a\t\u0002\u0019\r\u0014X-\u0019;f/JLG/\u001a:\u0015\u0011\u0005\u001521CB\u000b\u0007S\u0001B!a\n\u0002@9!\u0011\u0011FA\u0019\u001d\u0011\tY#a\f\u000f\t\u0005\u001d\u0011QF\u0005\u0003\u000b\u0019I!a\u0001\u0003\b\u000f\u0005M\"\u0001#\u0001\u00026\u0005\u00012*\u001e3v\u0013:$W\r_!eCB$XM\u001d\t\u0004;\u0005]bAB\u0001\u0003\u0011\u0003\tIdE\u0002\u000289AqaIA\u001c\t\u0003\ti\u0004\u0006\u0002\u00026\u00199\u0011\u0011IA\u001c\u0001\u0005\r#aD&vIVLe\u000eZ3y/JLG/\u001a:\u0014\r\u0005}\u0012QIA-!\u0019\t9%!\u0014\u0002T9!\u00111AA%\u0013\r\tYEF\u0001\r\u0013:$W\r_!eCB$XM]\u0005\u0005\u0003\u001f\n\tFA\bCCN,\u0017J\u001c3fq^\u0013\u0018\u000e^3s\u0015\r\tYE\u0006\t\u0004;\u0005U\u0013bAA,\u0005\t\u00192*\u001e3v/JLG/\u00192mK\u001a+\u0017\r^;sKB!\u00111LA5\u001b\t\tiF\u0003\u0003\u0002`\u0005\u0005\u0014\u0001D:dC2\fGn\\4hS:<'\u0002BA2\u0003K\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0003\u0003O\n1aY8n\u0013\u0011\tY'!\u0018\u0003\u001bM#(/[2u\u0019><w-\u001b8h\u0011%\t\u0013q\bB\u0001B\u0003%A\u0004C\u0007\u0002r\u0005}\"\u0011!Q\u0001\n\u0005M\u0014QQ\u0001\bS:$\u0017nY3t!\u0011\u0011&,!\u001e1\r\u0005]\u00141PAA!\u0019)\u0002'!\u001f\u0002\u0000A\u00191'a\u001f\u0005\u0017\u0005u\u0014qNA\u0001\u0002\u0003\u0015\tA\u000e\u0002\u0004?\u0012*\u0004cA\u001a\u0002\u0002\u0012Y\u00111QA8\u0003\u0003\u0005\tQ!\u00017\u0005\ryFEN\u0005\u0005\u0003c\ni\u0005C\u0006\u0002\n\u0006}\"\u0011!Q\u0001\n\u0005-\u0015aB<sCB\u0004XM\u001d\t\u0005\u0003\u001b\u000by)\u0004\u0002\u00028\u00199\u0011\u0011SA\u001c\u0001\u0005M%AE&vIV4U-\u0019;ve\u0016<&/\u00199qKJ\u001cR!a$\u000f\u0003+\u0003b!a&\u0002\u001e\u0006Mc\u0002BA\u0002\u00033K1!a'\u0017\u0003=9&/\u001b;bE2,g)Z1ukJ,\u0017\u0002BAP\u0003C\u0013aBR3biV\u0014Xm\u0016:baB,'OC\u0002\u0002\u001cZA1\"!*\u0002\u0010\n\u0005\t\u0015!\u0003\u0002(\u0006\u00191O\u001a;\u0011\t\u0005%\u0016qW\u0007\u0003\u0003WSA!!,\u00020\u000611/[7qY\u0016TA!!-\u00024\u00069a-Z1ukJ,'bAA[\u0015\u00059q\u000e]3oO&\u001c\u0018\u0002BA]\u0003W\u0013\u0011cU5na2,g)Z1ukJ,G+\u001f9f\u0011-\ti,a$\u0003\u0002\u0003\u0006I!a0\u0002\u0011\u0011,G.Z4bi\u0016\u0004b!a&\u0002\u001e\u0006\u0005\u0007cA\u000b\u0002D&\u0019\u0011Q\u0019\f\u0003\u001f]\u0013\u0018\u000e^1cY\u00164U-\u0019;ve\u0016DqaIAH\t\u0003\tI\r\u0006\u0004\u0002\f\u0006-\u0017Q\u001a\u0005\t\u0003K\u000b9\r1\u0001\u0002(\"A\u0011QXAd\u0001\u0004\ty\f\u0003\u0006\u0002R\u0006=%\u0019!C\u0005\u0003'\f\u0001\u0002\u001a;h\u0013:$W\r_\u000b\u0003\u0003+\u0004BaD\"\u0002XB\u0019q\"!7\n\u0007\u0005m\u0007CA\u0002J]RD\u0011\"a8\u0002\u0010\u0002\u0006I!!6\u0002\u0013\u0011$x-\u00138eKb\u0004\u0003BCAr\u0003\u001f\u0013\r\u0011\"\u0003\u0002f\u0006)Ao\u001c\"j]V\u0011\u0011q\u001d\t\u0005\u0003S\f)P\u0004\u0003\u0002l\u0006EXBAAw\u0015\r\tyOB\u0001\u0006GV\u0014h/Z\u0005\u0005\u0003g\fi/\u0001\u0006CS:tW\r\u001a+j[\u0016LA!a>\u0002z\n\u0001B+[7f)>\u0014\u0015N\u001c8fIRKW.\u001a\u0006\u0005\u0003g\fi\u000fC\u0005\u0002~\u0006=\u0005\u0015!\u0003\u0002h\u00061Ao\u001c\"j]\u0002B!B!\u0001\u0002\u0010\n\u0007I\u0011\u0002B\u0002\u0003\u0019\u00198\r[3nCV\u0011!Q\u0001\t\u0005\u0005\u000f\u0011Y!\u0004\u0002\u0003\n)\u0019!\u0011\u0001\u0003\n\t\t5!\u0011\u0002\u0002\u0018\u0017V$WoU5na2,g)Z1ukJ,7k\u00195f[\u0006D\u0011B!\u0005\u0002\u0010\u0002\u0006IA!\u0002\u0002\u000fM\u001c\u0007.Z7bA!A!QCAH\t\u0003\u00129\"\u0001\u0003xe\u0006\u0004HCBA*\u00053\u0011\t\u0003\u0003\u0005\u00022\nM\u0001\u0019\u0001B\u000e!\u0011\tIK!\b\n\t\t}\u00111\u0016\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\t\u0015\t\r\"1\u0003I\u0001\u0002\u0004\u0011)#\u0001\u0004eK2,G/\u001a\t\u0004\u001f\t\u001d\u0012b\u0001B\u0015!\t9!i\\8mK\u0006t\u0007\"C!\u0002@\t\u0005\t\u0015!\u0003C\u0011\u001d\u0019\u0013q\bC\u0001\u0005_!\"B!\r\u00034\tU\"Q\tB$!\u0011\ti)a\u0010\t\r\u0005\u0012i\u00031\u0001\u001d\u0011!\t\tH!\fA\u0002\t]\u0002\u0003\u0002*[\u0005s\u0001dAa\u000f\u0003@\t\r\u0003CB\u000b1\u0005{\u0011\t\u0005E\u00024\u0005\u007f!1\"! \u00036\u0005\u0005\t\u0011!B\u0001mA\u00191Ga\u0011\u0005\u0017\u0005\r%QGA\u0001\u0002\u0003\u0015\tA\u000e\u0005\t\u0003\u0013\u0013i\u00031\u0001\u0002\f\"1\u0011I!\fA\u0002\tC!Ba\u0013\u0002@\t\u0007I\u0011\u0002B'\u0003)\u0001\u0018M\u001d;ji&|gn]\u000b\u0003\u0005\u001f\u0002RA!\u0015\u0003\\\u0015k!Aa\u0015\u000b\t\tU#qK\u0001\b[V$\u0018M\u00197f\u0015\r\u0011I\u0006E\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B/\u0005'\u00121aU3u\u0011%\u0011\t'a\u0010!\u0002\u0013\u0011y%A\u0006qCJ$\u0018\u000e^5p]N\u0004\u0003B\u0003B3\u0003\u007f\u0011\r\u0011\"\u0003\u0003h\u000591/Z:tS>tWC\u0001B5!\u0011\u0011YG!\u001f\u000f\t\t5$1\u000f\b\u0005\u0003W\u0011y'C\u0002\u0003r\u0011\tQ!\u001e;jYNLAA!\u001e\u0003x\u0005q!+[2i\u0017V$Wo\u00117jK:$(b\u0001B9\t%!!1\u0010B?\u00055\u0019Vm]:j_:Du\u000e\u001c3fe*!!Q\u000fB<\u0011%\u0011\t)a\u0010!\u0002\u0013\u0011I'\u0001\u0005tKN\u001c\u0018n\u001c8!\u0011)\u0011))a\u0010C\u0002\u0013%!qQ\u0001\b[\u0006\u0004\b/\u001a:t+\t\u0011I\t\u0005\u0003\u0010=\n-\u0005cB\b\u0003\u000e\nE%1T\u0005\u0004\u0005\u001f\u0003\"A\u0002+va2,'\u0007\u0005\u0003\u0003\u0014\n]UB\u0001BK\u0015\tIB!\u0003\u0003\u0003\u001a\nU%\u0001E&vIV\u001cu\u000e\\;n]6\u000b\u0007\u000f]3s!\u0011\u0011iJ!+\u000e\u0005\t}%\u0002\u0002BQ\u0005G\u000baa\u00197jK:$(bA\u0003\u0003&*\u0019!q\u0015\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\u0011YKa(\u0003\u0013-+H-\u001e+bE2,\u0007\"\u0003BX\u0003\u007f\u0001\u000b\u0011\u0002BE\u0003!i\u0017\r\u001d9feN\u0004\u0003B\u0003BZ\u0003\u007f\u0001\r\u0011\"\u0003\u00036\u0006\t\u0011.\u0006\u0002\u0002X\"Q!\u0011XA \u0001\u0004%IAa/\u0002\u000b%|F%Z9\u0015\u0007)\u0012i\f\u0003\u0006\u0003@\n]\u0016\u0011!a\u0001\u0003/\f1\u0001\u001f\u00132\u0011%\u0011\u0019-a\u0010!B\u0013\t9.\u0001\u0002jA!A!qYA \t#\u0012I-A\u0003xe&$X\rF\u0004+\u0005\u0017\u0014iM!9\t\u0011\u0005E&Q\u0019a\u0001\u0003'B\u0001Ba4\u0003F\u0002\u0007!\u0011[\u0001\u0007m\u0006dW/Z:\u0011\t=q&1\u001b\u0019\u0005\u0005+\u0014i\u000e\u0005\u0004\u0002\u0002\t]'1\\\u0005\u0005\u00053\fiBA\u0006S_^\\U-\u001f,bYV,\u0007cA\u001a\u0003^\u0012Y!q\u001cBg\u0003\u0003\u0005\tQ!\u00017\u0005\ryFe\u000e\u0005\t\u0005G\u0014)\r1\u0001\u0003&\u00051Q\u000f\u001d3bi\u0016D\u0001Ba\t\u0002@\u0011E#q\u001d\u000b\u0006U\t%(1\u001e\u0005\t\u0003c\u0013)\u000f1\u0001\u0002T!A!q\u001aBs\u0001\u0004\u0011i\u000f\u0005\u0003\u0010=\n=\b\u0007\u0002By\u0005k\u0004b!!\u0001\u0003X\nM\bcA\u001a\u0003v\u0012Y!q\u001fBv\u0003\u0003\u0005\tQ!\u00017\u0005\ryF\u0005\u000f\u0005\t\u0005w\fy\u0004\"\u0011\u0003~\u0006)a\r\\;tQR\t!\u0006\u0003\u0005\u0004\u0002\u0005}B\u0011\tB\u007f\u0003\u0015\u0019Gn\\:f\u0011!\u0019)!a\u0010\u0005\n\r\u001d\u0011AF3ySN$\u0018N\\4QCJ$\u0018\u000e^5p]\u0016\u0013(o\u001c:\u0015\t\t\u00152\u0011\u0002\u0005\t\u0007\u0017\u0019\u0019\u00011\u0001\u0004\u000e\u0005\tQ\rE\u0002S\u0007\u001fI1a!\u0005]\u0005%!\u0006N]8xC\ndW\r\u0003\u0005\u0002&\u0006}\u0001\u0019AAT\u0011!\t\t(a\bA\u0002\r]\u0001\u0003\u0002*[\u00073\u0001daa\u0007\u0004 \r\u0015\u0002CB\u000b1\u0007;\u0019\u0019\u0003E\u00024\u0007?!1b!\t\u0004\u0016\u0005\u0005\t\u0011!B\u0001m\t\u0019q\fJ\u001a\u0011\u0007M\u001a)\u0003B\u0006\u0004(\rU\u0011\u0011!A\u0001\u0006\u00031$aA0%i!A\u0011)a\b\u0011\u0002\u0003\u0007!\t")
public class KuduIndexAdapter
implements IndexAdapter<KuduDataStore> {
    public final KuduDataStore org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds;
    private final ColumnGroups groups;
    private final Option<Object> tableNameLimit;

    public ColumnGroups groups() {
        return this.groups;
    }

    public Option<Object> tableNameLimit() {
        return this.tableNameLimit;
    }

    public void org$locationtech$geomesa$index$api$IndexAdapter$_setter_$groups_$eq(ColumnGroups x$1) {
        this.groups = x$1;
    }

    public void org$locationtech$geomesa$index$api$IndexAdapter$_setter_$tableNameLimit_$eq(Option x$1) {
        this.tableNameLimit = x$1;
    }

    public Option<String> createWriter$default$3() {
        return IndexAdapter.class.createWriter$default$3((IndexAdapter)this);
    }

    public void createTable(GeoMesaFeatureIndex<?, ?> index, Option<String> partition, Function0<Seq<byte[]>> splits) {
        String table = index.configureTableName(partition, index.configureTableName$default$2());
        if (!this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.client().tableExists(table)) {
            KuduColumnMapper mapper = KuduColumnMapper$.MODULE$.apply(index);
            CreateTableOptions options = mapper.configurePartitions();
            int servers = this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.client().listTabletServers().getTabletServersCount();
            Object object = servers < 3 ? options.setNumReplicas(servers) : BoxedUnit.UNIT;
            this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.client().createTable(table, mapper.tableSchema(), options);
        }
    }

    public void renameTable(String from, String to) {
        if (this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.client().tableExists(from)) {
            this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.client().alterTable(from, new AlterTableOptions().renameTable(to));
        }
    }

    public void deleteTables(Seq<String> tables) {
        ((ParIterableLike)tables.par()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KuduIndexAdapter $outer;

            public final Object apply(String table) {
                return this.$outer.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.client().tableExists(table) ? this.$outer.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.client().deleteTable(table) : BoxedUnit.UNIT;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void clearTables(Seq<String> tables, Option<byte[]> prefix) {
        Predef$.MODULE$.require(prefix.isEmpty(), (Function0)new Serializable(this, prefix){
            public static final long serialVersionUID = 0L;
            private final Option prefix$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected None but got prefix range ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prefix$1}));
            }
            {
                this.prefix$1 = prefix$1;
            }
        });
        GeoMesaFeatureIndex[] indices = (GeoMesaFeatureIndex[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.getTypeNames()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KuduIndexAdapter $outer;

            public final SimpleFeatureType apply(String typeName) {
                return this.$outer.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.getSchema(typeName);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SimpleFeatureType.class)))).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KuduIndexAdapter $outer;

            public final Seq<GeoMesaFeatureIndex<?, ?>> apply(SimpleFeatureType x$1) {
                return this.$outer.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.manager().indices(x$1, this.$outer.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.manager().indices$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(GeoMesaFeatureIndex.class)));
        ((ParIterableLike)tables.par()).foreach((Function1)new Serializable(this, indices){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KuduIndexAdapter $outer;
            private final GeoMesaFeatureIndex[] indices$1;

            public final void apply(String name) {
                GeoMesaFeatureIndex index = (GeoMesaFeatureIndex)Predef$.MODULE$.refArrayOps((Object[])this.indices$1).find((Function1)new Serializable(this, name){
                    public static final long serialVersionUID = 0L;
                    private final String name$1;

                    public final boolean apply(GeoMesaFeatureIndex<?, ?> x$2) {
                        return x$2.getTableNames(x$2.getTableNames$default$1()).contains((Object)this.name$1);
                    }
                    {
                        this.name$1 = name$1;
                    }
                }).getOrElse((Function0)new Serializable(this, name){
                    public static final long serialVersionUID = 0L;
                    private final String name$1;

                    public final Nothing$ apply() {
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't find index corresponding to table '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1})));
                    }
                    {
                        this.name$1 = name$1;
                    }
                });
                Seq<KuduColumnAdapter<?>> columns = KuduColumnMapper$.MODULE$.apply(index).keyColumns();
                KuduTable table = this.$outer.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.client().openTable(name);
                KuduScanner.KuduScannerBuilder builder = this.$outer.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.client().newScannerBuilder(table);
                builder.setProjectedColumnNames((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)columns.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<String> apply(KuduColumnAdapter<?> x$3) {
                        return (Seq)x$3.columns().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(ColumnSchema x$4) {
                                return x$4.getName();
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                    }
                }, Seq$.MODULE$.canBuildFrom())).asJava());
                WithClose$.MODULE$.apply((Object)new RichKuduClient.SessionHolder(this.$outer.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.client().newSession()), (Function0)new Serializable(this, builder){
                    public static final long serialVersionUID = 0L;
                    private final KuduScanner.KuduScannerBuilder builder$1;

                    public final CloseableIterator<RowResult> apply() {
                        return RichKuduClient$RichScanner$.MODULE$.iterator$extension(RichKuduClient$.MODULE$.RichScanner(this.builder$1.build()));
                    }
                    {
                        this.builder$1 = builder$1;
                    }
                }, (Function2)new Serializable(this, columns, table){
                    public static final long serialVersionUID = 0L;
                    public final Seq columns$1;
                    public final KuduTable table$1;

                    public final void apply(RichKuduClient.SessionHolder x0$1, CloseableIterator<RowResult> x1$1) {
                        Tuple2 tuple2 = new Tuple2((Object)x0$1, x1$1);
                        if (tuple2 != null) {
                            RichKuduClient.SessionHolder holder = (RichKuduClient.SessionHolder)tuple2._1();
                            CloseableIterator iterator = (CloseableIterator)tuple2._2();
                            holder.session().setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND);
                            iterator.foreach((Function1)new Serializable(this, holder){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$clearTables$2$$anonfun$apply$4 $outer;
                                private final RichKuduClient.SessionHolder holder$1;

                                public final OperationResponse apply(RowResult row) {
                                    Delete delete2 = this.$outer.table$1.newDelete();
                                    this.$outer.columns$1.foreach((Function1)new Serializable(this, delete2, row){
                                        public static final long serialVersionUID = 0L;
                                        private final Delete delete$1;
                                        private final RowResult row$5;

                                        public final void apply(KuduColumnAdapter<?> x$5) {
                                            x$5.transfer(this.row$5, this.delete$1.getRow());
                                        }
                                        {
                                            this.delete$1 = delete$1;
                                            this.row$5 = row$5;
                                        }
                                    });
                                    return this.holder$1.session().apply((Operation)delete2);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.holder$1 = holder$1;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        this.columns$1 = columns$1;
                        this.table$1 = table$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.indices$1 = indices$1;
            }
        });
    }

    public KuduQueryPlan createQueryPlan(package.QueryStrategy strategy) {
        package.QueryStrategy queryStrategy = strategy;
        if (queryStrategy != null) {
            Tuple4 tuple4;
            package.FilterStrategy filter = queryStrategy.filter();
            Seq keyRanges = queryStrategy.keyRanges();
            Seq tieredKeyRanges = queryStrategy.tieredKeyRanges();
            Hints hints = queryStrategy.hints();
            Tuple4 tuple42 = tuple4 = new Tuple4((Object)filter, (Object)keyRanges, (Object)tieredKeyRanges, (Object)hints);
            package.FilterStrategy filter2 = (package.FilterStrategy)tuple42._1();
            Seq keyRanges2 = (Seq)tuple42._2();
            Seq tieredKeyRanges2 = (Seq)tuple42._3();
            Hints hints2 = (Hints)tuple42._4();
            GeoMesaFeatureIndex index = filter2.index();
            KuduColumnMapper mapper = KuduColumnMapper$.MODULE$.apply(index);
            Buffer auths = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.config().authProvider().getAuthorizations()).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte[] apply(String x$7) {
                    return x$7.getBytes(StandardCharsets.UTF_8);
                }
            }, Buffer$.MODULE$.canBuildFrom());
            KuduSimpleFeatureSchema.KuduFilter kuduFilter = (KuduSimpleFeatureSchema.KuduFilter)strategy.ecql().map((Function1)new Serializable(this, mapper){
                public static final long serialVersionUID = 0L;
                private final KuduColumnMapper mapper$1;

                public final KuduSimpleFeatureSchema.KuduFilter apply(Filter filter) {
                    return this.mapper$1.schema().predicate(filter);
                }
                {
                    this.mapper$1 = mapper$1;
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final KuduSimpleFeatureSchema.KuduFilter apply() {
                    return new KuduSimpleFeatureSchema.KuduFilter((Seq<KuduPredicate>)((Seq)Seq$.MODULE$.empty()), (Option<Filter>)None$.MODULE$);
                }
            });
            if (kuduFilter != null) {
                KuduQueryPlan kuduQueryPlan;
                Tuple2 tuple2;
                Seq<KuduPredicate> predicates = kuduFilter.predicates();
                Option<Filter> ecql = kuduFilter.filter();
                Tuple2 tuple22 = tuple2 = new Tuple2(predicates, ecql);
                Seq predicates2 = (Seq)tuple22._1();
                Option ecql2 = (Option)tuple22._2();
                KuduResultAdapter adapter = KuduResultAdapter$.MODULE$.apply(index.sft(), (Seq<byte[]>)auths, (Option<Filter>)ecql2, hints2);
                if (keyRanges2.isEmpty()) {
                    kuduQueryPlan = new KuduQueryPlan.EmptyPlan(filter2, adapter);
                } else {
                    Seq tables = index.getTablesForQuery(filter2.filter());
                    Seq<Tuple2<Option<PartialRow>, Option<PartialRow>>> ranges = mapper.toRowRanges(keyRanges2, (Seq<package.ByteRange>)tieredKeyRanges2);
                    Option sort = QueryHints$.MODULE$.RichHints(hints2).getSortFields();
                    Option max = QueryHints$.MODULE$.RichHints(hints2).getMaxFeatures();
                    Option project = QueryHints$.MODULE$.RichHints(hints2).getProjection();
                    int threads = this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds.config().queryThreads();
                    kuduQueryPlan = new KuduQueryPlan.ScanPlan(filter2, (Seq<String>)tables, ranges, (Seq<KuduPredicate>)predicates2, (Option<Filter>)ecql2, adapter, (Option<Seq<Tuple2<String, Object>>>)sort, (Option<Object>)max, (Option<Reprojection.QueryReferenceSystems>)project, threads);
                }
                return kuduQueryPlan;
            }
            throw new MatchError((Object)kuduFilter);
        }
        throw new MatchError((Object)queryStrategy);
    }

    public KuduIndexWriter createWriter(SimpleFeatureType sft, Seq<GeoMesaFeatureIndex<?, ?>> indices, Option<String> partition) {
        return new KuduIndexWriter(this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds, indices, new KuduFeatureWrapper(sft, (WritableFeature.FeatureWrapper<WritableFeature>)WritableFeature$.MODULE$.wrapper(sft, this.groups())), partition);
    }

    public KuduIndexAdapter(KuduDataStore ds) {
        this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$$ds = ds;
        IndexAdapter.class.$init$((IndexAdapter)this);
    }

    public static class KuduIndexWriter
    extends IndexAdapter.BaseIndexWriter<KuduWritableFeature>
    implements StrictLogging {
        public final KuduDataStore org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$ds;
        public final Option<String> org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$partition;
        private final Set<String> partitions;
        private final RichKuduClient.SessionHolder org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$session;
        private final Tuple2<KuduColumnMapper, KuduTable>[] mappers;
        private int i;
        private final Logger logger;

        public Logger logger() {
            return this.logger;
        }

        public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
            this.logger = x$1;
        }

        private Set<String> partitions() {
            return this.partitions;
        }

        public RichKuduClient.SessionHolder org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$session() {
            return this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$session;
        }

        private Tuple2<KuduColumnMapper, KuduTable>[] mappers() {
            return this.mappers;
        }

        private int i() {
            return this.i;
        }

        private void i_$eq(int x$1) {
            this.i = x$1;
        }

        public void write(KuduWritableFeature feature, package.RowKeyValue<?>[] values, boolean update) {
            this.i_$eq(0);
            while (this.i() < values.length) {
                Tuple2<KuduColumnMapper, KuduTable> tuple2;
                block5: {
                    package.RowKeyValue<?> rowKeyValue;
                    block8: {
                        block7: {
                            BoxedUnit boxedUnit;
                            KuduTable table;
                            KuduColumnMapper mapper;
                            block6: {
                                Tuple2 tuple22;
                                tuple2 = this.mappers()[this.i()];
                                if (tuple2 == null) break block5;
                                KuduColumnMapper mapper2 = (KuduColumnMapper)tuple2._1();
                                KuduTable table2 = (KuduTable)tuple2._2();
                                Tuple2 tuple23 = tuple22 = new Tuple2((Object)mapper2, (Object)table2);
                                mapper = (KuduColumnMapper)tuple23._1();
                                table = (KuduTable)tuple23._2();
                                if (this.partitions().add((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mapper.index().identifier(), BoxesRunTime.boxToShort((short)feature.bin())})))) {
                                    mapper.createPartition(table, feature.bin()).foreach((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ KuduIndexWriter $outer;

                                        /*
                                         * Enabled force condition propagation
                                         * Lifted jumps to return sites
                                         */
                                        public final Object apply(package.Partitioning x0$2) {
                                            AlterTableResponse alterTableResponse;
                                            package.Partitioning partitioning = x0$2;
                                            if (partitioning == null) throw new MatchError((Object)partitioning);
                                            String name = partitioning.table();
                                            AlterTableOptions alter = partitioning.alteration();
                                            try {
                                                alterTableResponse = this.$outer.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$ds.client().alterTable(name, alter);
                                                return alterTableResponse;
                                            }
                                            catch (Throwable throwable22) {
                                                BoxedUnit boxedUnit;
                                                Throwable throwable3 = throwable22;
                                                if (!this.$outer.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$existingPartitionError(throwable3)) throw throwable22;
                                                if (this.$outer.logger().underlying().isDebugEnabled()) {
                                                    this.$outer.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tried to create a partition to table ", " but it already exists: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), throwable3);
                                                    boxedUnit = BoxedUnit.UNIT;
                                                } else {
                                                    boxedUnit = BoxedUnit.UNIT;
                                                }
                                                BoxedUnit boxedUnit2 = boxedUnit;
                                                alterTableResponse = boxedUnit2;
                                            }
                                            return alterTableResponse;
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                }
                                if (!((rowKeyValue = values[this.i()]) instanceof package.SingleRowKeyValue)) break block6;
                                package.SingleRowKeyValue singleRowKeyValue = (package.SingleRowKeyValue)rowKeyValue;
                                Upsert upsert = table.newUpsert();
                                PartialRow row = upsert.getRow();
                                mapper.createKeyValues(singleRowKeyValue).foreach((Function1)new Serializable(this, row){
                                    public static final long serialVersionUID = 0L;
                                    private final PartialRow row$1;

                                    public final void apply(package.KuduValue<?> x$10) {
                                        x$10.writeToRow(this.row$1);
                                    }
                                    {
                                        this.row$1 = row$1;
                                    }
                                });
                                feature.kuduValues().foreach((Function1)new Serializable(this, row){
                                    public static final long serialVersionUID = 0L;
                                    private final PartialRow row$1;

                                    public final void apply(package.KuduValue<?> x$11) {
                                        x$11.writeToRow(this.row$1);
                                    }
                                    {
                                        this.row$1 = row$1;
                                    }
                                });
                                KuduIndexColumnAdapter$VisibilityAdapter$.MODULE$.writeToRow(row, feature.vis());
                                boxedUnit = this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$session().session().apply((Operation)upsert);
                                break block7;
                            }
                            if (!(rowKeyValue instanceof package.MultiRowKeyValue)) break block8;
                            package.MultiRowKeyValue multiRowKeyValue = (package.MultiRowKeyValue)rowKeyValue;
                            multiRowKeyValue.split().foreach((Function1)new Serializable(this, feature, mapper, table){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ KuduIndexWriter $outer;
                                private final KuduWritableFeature feature$1;
                                private final KuduColumnMapper mapper$2;
                                private final KuduTable table$2;

                                public final OperationResponse apply(package.SingleRowKeyValue<Object> kv) {
                                    Upsert upsert = this.table$2.newUpsert();
                                    PartialRow row = upsert.getRow();
                                    this.mapper$2.createKeyValues(kv).foreach((Function1)new Serializable(this, row){
                                        public static final long serialVersionUID = 0L;
                                        private final PartialRow row$2;

                                        public final void apply(package.KuduValue<?> x$12) {
                                            x$12.writeToRow(this.row$2);
                                        }
                                        {
                                            this.row$2 = row$2;
                                        }
                                    });
                                    this.feature$1.kuduValues().foreach((Function1)new Serializable(this, row){
                                        public static final long serialVersionUID = 0L;
                                        private final PartialRow row$2;

                                        public final void apply(package.KuduValue<?> x$13) {
                                            x$13.writeToRow(this.row$2);
                                        }
                                        {
                                            this.row$2 = row$2;
                                        }
                                    });
                                    KuduIndexColumnAdapter$VisibilityAdapter$.MODULE$.writeToRow(row, this.feature$1.vis());
                                    return this.$outer.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$session().session().apply((Operation)upsert);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.feature$1 = feature$1;
                                    this.mapper$2 = mapper$2;
                                    this.table$2 = table$2;
                                }
                            });
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        this.i_$eq(this.i() + 1);
                        continue;
                    }
                    throw new MatchError(rowKeyValue);
                }
                throw new MatchError(tuple2);
            }
        }

        public void delete(KuduWritableFeature feature, package.RowKeyValue<?>[] values) {
            this.i_$eq(0);
            while (this.i() < values.length) {
                Tuple2<KuduColumnMapper, KuduTable> tuple2;
                block3: {
                    package.RowKeyValue<?> rowKeyValue;
                    block6: {
                        block5: {
                            BoxedUnit boxedUnit;
                            KuduTable table;
                            KuduColumnMapper mapper;
                            block4: {
                                Tuple2 tuple22;
                                tuple2 = this.mappers()[this.i()];
                                if (tuple2 == null) break block3;
                                KuduColumnMapper mapper2 = (KuduColumnMapper)tuple2._1();
                                KuduTable table2 = (KuduTable)tuple2._2();
                                Tuple2 tuple23 = tuple22 = new Tuple2((Object)mapper2, (Object)table2);
                                mapper = (KuduColumnMapper)tuple23._1();
                                table = (KuduTable)tuple23._2();
                                rowKeyValue = values[this.i()];
                                if (!(rowKeyValue instanceof package.SingleRowKeyValue)) break block4;
                                package.SingleRowKeyValue singleRowKeyValue = (package.SingleRowKeyValue)rowKeyValue;
                                Delete delete2 = table.newDelete();
                                PartialRow row = delete2.getRow();
                                mapper.createKeyValues(singleRowKeyValue).foreach((Function1)new Serializable(this, row){
                                    public static final long serialVersionUID = 0L;
                                    private final PartialRow row$3;

                                    public final void apply(package.KuduValue<?> x$15) {
                                        x$15.writeToRow(this.row$3);
                                    }
                                    {
                                        this.row$3 = row$3;
                                    }
                                });
                                boxedUnit = this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$session().session().apply((Operation)delete2);
                                break block5;
                            }
                            if (!(rowKeyValue instanceof package.MultiRowKeyValue)) break block6;
                            package.MultiRowKeyValue multiRowKeyValue = (package.MultiRowKeyValue)rowKeyValue;
                            multiRowKeyValue.split().foreach((Function1)new Serializable(this, mapper, table){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ KuduIndexWriter $outer;
                                private final KuduColumnMapper mapper$3;
                                private final KuduTable table$3;

                                public final OperationResponse apply(package.SingleRowKeyValue<Object> kv) {
                                    Delete delete2 = this.table$3.newDelete();
                                    PartialRow row = delete2.getRow();
                                    this.mapper$3.createKeyValues(kv).foreach((Function1)new Serializable(this, row){
                                        public static final long serialVersionUID = 0L;
                                        private final PartialRow row$4;

                                        public final void apply(package.KuduValue<?> x$16) {
                                            x$16.writeToRow(this.row$4);
                                        }
                                        {
                                            this.row$4 = row$4;
                                        }
                                    });
                                    return this.$outer.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$session().session().apply((Operation)delete2);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.mapper$3 = mapper$3;
                                    this.table$3 = table$3;
                                }
                            });
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        this.i_$eq(this.i() + 1);
                        continue;
                    }
                    throw new MatchError(rowKeyValue);
                }
                throw new MatchError(tuple2);
            }
        }

        public void flush() {
            this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$session().flush();
        }

        public void close() {
            this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$session().close();
        }

        public boolean org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$existingPartitionError(Throwable e) {
            return e.getMessage() != null && e.getMessage().startsWith("New range partition conflicts with existing range partition");
        }

        public KuduIndexWriter(KuduDataStore ds, Seq<GeoMesaFeatureIndex<?, ?>> indices, KuduFeatureWrapper wrapper, Option<String> partition) {
            this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$ds = ds;
            this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$partition = partition;
            super(indices, (WritableFeature.FeatureWrapper)wrapper);
            StrictLogging.class.$init$((StrictLogging)this);
            this.partitions = Set$.MODULE$.empty();
            this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$session = new RichKuduClient.SessionHolder(ds.client().newSession());
            this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$session().session().setMutationBufferSpace(BoxesRunTime.unboxToInt((Object)package$KuduSystemProperties$.MODULE$.MutationBufferSpace().toInt().get()));
            this.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$session().session().setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND);
            this.mappers = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])super.indices().toArray(ClassTag$.MODULE$.apply(GeoMesaFeatureIndex.class))).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KuduIndexWriter $outer;

                public final Tuple2<KuduColumnMapper, KuduTable> apply(GeoMesaFeatureIndex<?, ?> index) {
                    KuduColumnMapper mapper = KuduColumnMapper$.MODULE$.apply(index);
                    Seq seq = index.getTableNames(this.$outer.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$partition);
                    Some some = Seq$.MODULE$.unapplySeq(seq);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
                        KuduTable kuduTable;
                        String t = (String)((SeqLike)some.get()).apply(0);
                        KuduTable table = kuduTable = this.$outer.org$locationtech$geomesa$kudu$data$KuduIndexAdapter$KuduIndexWriter$$ds.client().openTable(t);
                        return new Tuple2((Object)mapper, (Object)table);
                    }
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected a single table but got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seq.mkString(", ")})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            this.i = 0;
        }
    }

    public static class KuduFeatureWrapper
    implements WritableFeature.FeatureWrapper<KuduWritableFeature> {
        private final WritableFeature.FeatureWrapper<WritableFeature> delegate;
        private final Option<Object> dtgIndex;
        private final Function1<Object, BinnedTime> toBin;
        private final KuduSimpleFeatureSchema schema;

        public boolean wrap$default$2() {
            return WritableFeature.FeatureWrapper.class.wrap$default$2((WritableFeature.FeatureWrapper)this);
        }

        private Option<Object> dtgIndex() {
            return this.dtgIndex;
        }

        private Function1<Object, BinnedTime> toBin() {
            return this.toBin;
        }

        private KuduSimpleFeatureSchema schema() {
            return this.schema;
        }

        public KuduWritableFeature wrap(SimpleFeature feature, boolean delete2) {
            return new KuduWritableFeature(this.delegate.wrap(feature, delete2), this.schema(), this.dtgIndex(), this.toBin());
        }

        public KuduFeatureWrapper(SimpleFeatureType sft, WritableFeature.FeatureWrapper<WritableFeature> delegate) {
            this.delegate = delegate;
            WritableFeature.FeatureWrapper.class.$init$((WritableFeature.FeatureWrapper)this);
            this.dtgIndex = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
            this.toBin = BinnedTime$.MODULE$.timeToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
            this.schema = KuduSimpleFeatureSchema$.MODULE$.apply(sft);
        }
    }
}

