/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kudu.result;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.filter.factory.FastFilterFactory$;
import org.locationtech.geomesa.kudu.result.DensityAdapter;
import org.locationtech.geomesa.kudu.result.KuduResultAdapter;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.io.ByteBuffers;
import org.locationtech.geomesa.utils.io.ByteBuffers$;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple8;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DensityAdapter$
implements KuduResultAdapter.KuduResultAdapterSerialization<DensityAdapter>,
scala.Serializable {
    public static DensityAdapter$ MODULE$;

    static {
        new DensityAdapter$();
    }

    @Override
    public void serialize(DensityAdapter adapter, ByteBuffers.ExpandingByteBuffer bb) {
        bb.putString(adapter.sft().getTypeName());
        bb.putString(SimpleFeatureTypes$.MODULE$.encodeType(adapter.sft(), true));
        bb.putInt(adapter.auths().length());
        adapter.auths().foreach((Function1 & Serializable & scala.Serializable)bytes -> {
            bb.putBytes(bytes);
            return BoxedUnit.UNIT;
        });
        bb.putString((String)adapter.ecql().map((Function1 & Serializable & scala.Serializable)x$1 -> ECQL.toCQL((Filter)x$1)).orNull(Predef$.MODULE$.$conforms()));
        bb.putString(adapter.geom());
        bb.putDouble(adapter.envelope().getMinX());
        bb.putDouble(adapter.envelope().getMaxX());
        bb.putDouble(adapter.envelope().getMinY());
        bb.putDouble(adapter.envelope().getMaxY());
        bb.putInt(adapter.width());
        bb.putInt(adapter.height());
        bb.putString((String)adapter.weight().orNull(Predef$.MODULE$.$conforms()));
    }

    @Override
    public DensityAdapter deserialize(ByteBuffer bb) {
        SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.createType(ByteBuffers.RichByteBuffer$.MODULE$.getString$extension(ByteBuffers$.MODULE$.RichByteBuffer(bb)), ByteBuffers.RichByteBuffer$.MODULE$.getString$extension(ByteBuffers$.MODULE$.RichByteBuffer(bb)));
        Seq auths = (Seq)Seq$.MODULE$.fill(bb.getInt(), (Function0 & Serializable & scala.Serializable)() -> ByteBuffers.RichByteBuffer$.MODULE$.getBytes$extension(ByteBuffers$.MODULE$.RichByteBuffer(bb)));
        Option ecql = Option$.MODULE$.apply((Object)ByteBuffers.RichByteBuffer$.MODULE$.getString$extension(ByteBuffers$.MODULE$.RichByteBuffer(bb))).map((Function1 & Serializable & scala.Serializable)x$5 -> FastFilterFactory$.MODULE$.toFilter(sft, x$5));
        String geom = ByteBuffers.RichByteBuffer$.MODULE$.getString$extension(ByteBuffers$.MODULE$.RichByteBuffer(bb));
        Envelope envelope = new Envelope(bb.getDouble(), bb.getDouble(), bb.getDouble(), bb.getDouble());
        int width = bb.getInt();
        int height = bb.getInt();
        Option weight = Option$.MODULE$.apply((Object)ByteBuffers.RichByteBuffer$.MODULE$.getString$extension(ByteBuffers$.MODULE$.RichByteBuffer(bb)));
        return new DensityAdapter(sft, (Seq<byte[]>)auths, (Option<Filter>)ecql, geom, envelope, width, height, (Option<String>)weight);
    }

    public DensityAdapter apply(SimpleFeatureType sft, Seq<byte[]> auths, Option<Filter> ecql, String geom, Envelope envelope, int width, int height, Option<String> weight) {
        return new DensityAdapter(sft, auths, ecql, geom, envelope, width, height, weight);
    }

    public Option<Tuple8<SimpleFeatureType, Seq<byte[]>, Option<Filter>, String, Envelope, Object, Object, Option<String>>> unapply(DensityAdapter x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple8((Object)x$0.sft(), x$0.auths(), x$0.ecql(), (Object)x$0.geom(), (Object)x$0.envelope(), (Object)BoxesRunTime.boxToInteger((int)x$0.width()), (Object)BoxesRunTime.boxToInteger((int)x$0.height()), x$0.weight()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DensityAdapter$() {
        MODULE$ = this;
    }
}

