/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kudu.data;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.kudu.client.AlterTableOptions;
import org.apache.kudu.client.AlterTableResponse;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.Delete;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.SessionConfiguration;
import org.apache.kudu.client.Upsert;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.curve.BinnedTime;
import org.locationtech.geomesa.curve.BinnedTime$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.IndexAdapter;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.WritableFeature$;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.conf.ColumnGroups;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.utils.Reprojection;
import org.locationtech.geomesa.kudu.data.KuduDataStore;
import org.locationtech.geomesa.kudu.data.KuduQueryPlan;
import org.locationtech.geomesa.kudu.data.KuduWritableFeature;
import org.locationtech.geomesa.kudu.index.KuduColumnMapper;
import org.locationtech.geomesa.kudu.index.KuduColumnMapper$;
import org.locationtech.geomesa.kudu.package;
import org.locationtech.geomesa.kudu.package$KuduSystemProperties$;
import org.locationtech.geomesa.kudu.result.KuduResultAdapter;
import org.locationtech.geomesa.kudu.result.KuduResultAdapter$;
import org.locationtech.geomesa.kudu.schema.KuduColumnAdapter;
import org.locationtech.geomesa.kudu.schema.KuduIndexColumnAdapter$VisibilityAdapter$;
import org.locationtech.geomesa.kudu.schema.KuduSimpleFeatureSchema;
import org.locationtech.geomesa.kudu.schema.KuduSimpleFeatureSchema$;
import org.locationtech.geomesa.kudu.utils.RichKuduClient;
import org.locationtech.geomesa.kudu.utils.RichKuduClient$;
import org.locationtech.geomesa.kudu.utils.RichKuduClient$RichScanner$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.parallel.ParIterableLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r-b\u0001B\u0016-\u0001]B\u0001B\u0013\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\u0006\u0017\u0002!\t\u0001\u0014\u0005\u0006\u001f\u0002!\t\u0005\u0015\u0005\b\u0003/\u0001A\u0011IA\r\u0011\u001d\t\u0019\u0003\u0001C!\u0003KAq!!\f\u0001\t\u0003\ny\u0003C\u0004\u0002:\u0001!\t%a\u000f\t\u000f\u0005\u001d\u0004\u0001\"\u0011\u0002j\u001d9\u0011q\u000f\u0017\t\u0002\u0005edAB\u0016-\u0011\u0003\tY\b\u0003\u0004L\u0015\u0011\u0005\u0011Q\u0010\u0004\u0007\u0003\u007fR\u0001!!!\t\u0011)c!\u0011!Q\u0001\n\u0019C!\"a+\r\u0005\u0003\u0005\u000b\u0011BAW\u0011)\ty\f\u0004B\u0001B\u0003%\u0011\u0011\u0019\u0005\tQ2\u0011\t\u0011)A\u0005S\"11\n\u0004C\u0001\u0005\u0017B\u0011B!\u001a\r\u0005\u0004%IAa\u001a\t\u0011\teD\u0002)A\u0005\u0005SB\u0011Ba\u001f\r\u0005\u0004%IA! \t\u0011\tUE\u0002)A\u0005\u0005\u007fB\u0011Ba&\r\u0005\u0004%IA!'\t\u0011\t}F\u0002)A\u0005\u00057C\u0011B!1\r\u0001\u0004%IAa1\t\u0013\t\u0015G\u00021A\u0005\n\t\u001d\u0007\u0002\u0003Bg\u0019\u0001\u0006KAa\u0001\t\u000f\t=G\u0002\"\u0015\u0003R\"9!1\t\u0007\u0005R\t5\bb\u0002B\u0000\u0019\u0011\u00053\u0011\u0001\u0005\b\u0007\u0007aA\u0011IB\u0001\u0011\u001d\u0019)\u0001\u0004C\u0005\u0007\u000f1a!!2\u000b\u0001\u0005\u001d\u0007BCAlA\t\u0005\t\u0015!\u0003\u0002Z\"Q\u0011Q\u001e\u0011\u0003\u0002\u0003\u0006I!a<\t\r-\u0003C\u0011AA|\u0011%\ti\u0010\tb\u0001\n\u0013\ty\u0010\u0003\u0005\u0003\n\u0001\u0002\u000b\u0011\u0002B\u0001\u0011%\u0011Y\u0001\tb\u0001\n\u0013\u0011i\u0001\u0003\u0005\u0003$\u0001\u0002\u000b\u0011\u0002B\b\u0011%\u0011)\u0003\tb\u0001\n\u0013\u00119\u0003\u0003\u0005\u00034\u0001\u0002\u000b\u0011\u0002B\u0015\u0011\u001d\u0011)\u0004\tC!\u0005o\u0011\u0001cS;ek&sG-\u001a=BI\u0006\u0004H/\u001a:\u000b\u00055r\u0013\u0001\u00023bi\u0006T!a\f\u0019\u0002\t-,H-\u001e\u0006\u0003cI\nqaZ3p[\u0016\u001c\u0018M\u0003\u00024i\u0005aAn\\2bi&|g\u000e^3dQ*\tQ'A\u0002pe\u001e\u001c\u0001aE\u0002\u0001qy\u0002\"!\u000f\u001f\u000e\u0003iR\u0011aO\u0001\u0006g\u000e\fG.Y\u0005\u0003{i\u0012a!\u00118z%\u00164\u0007cA E\r6\t\u0001I\u0003\u0002B\u0005\u0006\u0019\u0011\r]5\u000b\u0005\r\u0003\u0014!B5oI\u0016D\u0018BA#A\u00051Ie\u000eZ3y\u0003\u0012\f\u0007\u000f^3s!\t9\u0005*D\u0001-\u0013\tIEFA\u0007Lk\u0012,H)\u0019;b'R|'/Z\u0001\u0003IN\fa\u0001P5oSRtDCA'O!\t9\u0005\u0001C\u0003K\u0005\u0001\u0007a)A\u0006de\u0016\fG/\u001a+bE2,G\u0003B)UO^\u0004\"!\u000f*\n\u0005MS$\u0001B+oSRDQaQ\u0002A\u0002U\u00034AV.f!\u0011yt+\u00173\n\u0005a\u0003%aE$f_6+7/\u0019$fCR,(/Z%oI\u0016D\bC\u0001.\\\u0019\u0001!\u0011\u0002\u0018+\u0002\u0002\u0003\u0005)\u0011A/\u0003\u0007}#\u0013'\u0005\u0002_CB\u0011\u0011hX\u0005\u0003Aj\u0012qAT8uQ&tw\r\u0005\u0002:E&\u00111M\u000f\u0002\u0004\u0003:L\bC\u0001.f\t%1G+!A\u0001\u0002\u000b\u0005QLA\u0002`IIBQ\u0001[\u0002A\u0002%\f\u0011\u0002]1si&$\u0018n\u001c8\u0011\u0007eRG.\u0003\u0002lu\t1q\n\u001d;j_:\u0004\"!\u001c;\u000f\u00059\u0014\bCA8;\u001b\u0005\u0001(BA97\u0003\u0019a$o\\8u}%\u00111OO\u0001\u0007!J,G-\u001a4\n\u0005U4(AB*ue&twM\u0003\u0002tu!1\u0001p\u0001CA\u0002e\faa\u001d9mSR\u001c\bcA\u001d{y&\u00111P\u000f\u0002\ty\tLh.Y7f}A)Q0!\u0002\u0002\f9\u0019a0!\u0001\u000f\u0005=|\u0018\"A\u001e\n\u0007\u0005\r!(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0011\u0011\u0002\u0002\u0004'\u0016\f(bAA\u0002uA)\u0011(!\u0004\u0002\u0012%\u0019\u0011q\u0002\u001e\u0003\u000b\u0005\u0013(/Y=\u0011\u0007e\n\u0019\"C\u0002\u0002\u0016i\u0012AAQ=uK\u0006Y!/\u001a8b[\u0016$\u0016M\u00197f)\u0015\t\u00161DA\u0010\u0011\u0019\ti\u0002\u0002a\u0001Y\u0006!aM]8n\u0011\u0019\t\t\u0003\u0002a\u0001Y\u0006\u0011Ao\\\u0001\rI\u0016dW\r^3UC\ndWm\u001d\u000b\u0004#\u0006\u001d\u0002bBA\u0015\u000b\u0001\u0007\u00111F\u0001\u0007i\u0006\u0014G.Z:\u0011\tu\f)\u0001\\\u0001\fG2,\u0017M\u001d+bE2,7\u000fF\u0003R\u0003c\t\u0019\u0004C\u0004\u0002*\u0019\u0001\r!a\u000b\t\u000f\u0005Ub\u00011\u0001\u00028\u00051\u0001O]3gSb\u0004B!\u000f6\u0002\f\u0005y1M]3bi\u0016\fV/\u001a:z!2\fg\u000e\u0006\u0003\u0002>\u0005\r\u0003cA$\u0002@%\u0019\u0011\u0011\t\u0017\u0003\u001b-+H-^)vKJL\b\u000b\\1o\u0011\u001d\t)e\u0002a\u0001\u0003\u000f\n\u0001b\u001d;sCR,w-\u001f\t\u0005\u0003\u0013\n\tG\u0004\u0003\u0002L\u0005}c\u0002BA'\u0003;rA!a\u0014\u0002\\9!\u0011\u0011KA-\u001d\u0011\t\u0019&a\u0016\u000f\u0007=\f)&C\u00016\u0013\t\u0019D'\u0003\u00022e%\u00111\tM\u0005\u0003\u0003\nK1!a\u0001A\u0013\u0011\t\u0019'!\u001a\u0003\u001bE+XM]=TiJ\fG/Z4z\u0015\r\t\u0019\u0001Q\u0001\rGJ,\u0017\r^3Xe&$XM\u001d\u000b\t\u0003W\u001a\u0019b!\u0006\u0004*A\u0019\u0011Q\u000e\u0007\u000f\u0007\u0005=\u0014B\u0004\u0003\u0002r\u0005Ud\u0002BA(\u0003gJ!a\f\u0019\n\u00055r\u0013\u0001E&vIVLe\u000eZ3y\u0003\u0012\f\u0007\u000f^3s!\t9%b\u0005\u0002\u000bqQ\u0011\u0011\u0011\u0010\u0002\u0010\u0017V$W/\u00138eKb<&/\u001b;feN)A\"a!\u0002\u0018B1\u0011QQAF\u0003#sA!a\u0013\u0002\b&\u0019\u0011\u0011\u0012!\u0002\u0019%sG-\u001a=BI\u0006\u0004H/\u001a:\n\t\u00055\u0015q\u0012\u0002\u0010\u0005\u0006\u001cX-\u00138eKb<&/\u001b;fe*\u0019\u0011\u0011\u0012!\u0011\u0007\u001d\u000b\u0019*C\u0002\u0002\u00162\u00121cS;ek^\u0013\u0018\u000e^1cY\u00164U-\u0019;ve\u0016\u0004B!!'\u0002(6\u0011\u00111\u0014\u0006\u0005\u0003;\u000by*\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0003\u0002\"\u0006\r\u0016\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0005\u0005\u0015\u0016aA2p[&!\u0011\u0011VAN\u00055\u0019FO]5di2{wmZ5oO\u00069\u0011N\u001c3jG\u0016\u001c\b#B?\u0002\u0006\u0005=\u0006GBAY\u0003k\u000bY\f\u0005\u0004@/\u0006M\u0016\u0011\u0018\t\u00045\u0006UFACA\\\u001d\u0005\u0005\t\u0011!B\u0001;\n\u0019q\fJ\u001b\u0011\u0007i\u000bY\f\u0002\u0006\u0002>:\t\t\u0011!A\u0003\u0002u\u00131a\u0018\u00137\u0003\u001d9(/\u00199qKJ\u00042!a1!\u001b\u0005Q!AE&vIV4U-\u0019;ve\u0016<&/\u00199qKJ\u001cB\u0001\t\u001d\u0002JB1\u00111ZAi\u0003#sA!a\u0013\u0002N&\u0019\u0011q\u001a!\u0002\u001f]\u0013\u0018\u000e^1cY\u00164U-\u0019;ve\u0016LA!a5\u0002V\nqa)Z1ukJ,wK]1qa\u0016\u0014(bAAh\u0001\u0006\u00191O\u001a;\u0011\t\u0005m\u0017\u0011^\u0007\u0003\u0003;TA!a8\u0002b\u000611/[7qY\u0016TA!a9\u0002f\u00069a-Z1ukJ,'bAAti\u00059q\u000e]3oO&\u001c\u0018\u0002BAv\u0003;\u0014\u0011cU5na2,g)Z1ukJ,G+\u001f9f\u0003!!W\r\\3hCR,\u0007CBAf\u0003#\f\t\u0010E\u0002@\u0003gL1!!>A\u0005=9&/\u001b;bE2,g)Z1ukJ,GCBAa\u0003s\fY\u0010C\u0004\u0002X\u000e\u0002\r!!7\t\u000f\u000558\u00051\u0001\u0002p\u0006AA\r^4J]\u0012,\u00070\u0006\u0002\u0003\u0002A!\u0011H\u001bB\u0002!\rI$QA\u0005\u0004\u0005\u000fQ$aA%oi\u0006IA\r^4J]\u0012,\u0007\u0010I\u0001\u0006i>\u0014\u0015N\\\u000b\u0003\u0005\u001f\u0001BA!\u0005\u0003\u001e9!!1\u0003B\r\u001b\t\u0011)BC\u0002\u0003\u0018A\nQaY;sm\u0016LAAa\u0007\u0003\u0016\u0005Q!)\u001b8oK\u0012$\u0016.\\3\n\t\t}!\u0011\u0005\u0002\u0011)&lW\rV8CS:tW\r\u001a+j[\u0016TAAa\u0007\u0003\u0016\u00051Ao\u001c\"j]\u0002\naa]2iK6\fWC\u0001B\u0015!\u0011\u0011YCa\f\u000e\u0005\t5\"b\u0001B\u0013]%!!\u0011\u0007B\u0017\u0005]YU\u000fZ;TS6\u0004H.\u001a$fCR,(/Z*dQ\u0016l\u0017-A\u0004tG\",W.\u0019\u0011\u0002\t]\u0014\u0018\r\u001d\u000b\u0007\u0003#\u0013ID!\u0011\t\u000f\u0005\r(\u00061\u0001\u0003<A!\u00111\u001cB\u001f\u0013\u0011\u0011y$!8\u0003\u001bMKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0011%\u0011\u0019E\u000bI\u0001\u0002\u0004\u0011)%\u0001\u0004eK2,G/\u001a\t\u0004s\t\u001d\u0013b\u0001B%u\t9!i\\8mK\u0006tGC\u0003B'\u0005\u001f\u0012\tF!\u0019\u0003dA\u0019\u00111\u0019\u0007\t\u000b)\u000b\u0002\u0019\u0001$\t\u000f\u0005-\u0016\u00031\u0001\u0003TA)Q0!\u0002\u0003VA2!q\u000bB.\u0005?\u0002baP,\u0003Z\tu\u0003c\u0001.\u0003\\\u0011Y\u0011q\u0017B)\u0003\u0003\u0005\tQ!\u0001^!\rQ&q\f\u0003\f\u0003{\u0013\t&!A\u0001\u0002\u000b\u0005Q\fC\u0004\u0002@F\u0001\r!!1\t\u000b!\f\u0002\u0019A5\u0002\u0015A\f'\u000f^5uS>t7/\u0006\u0002\u0003jA)!1\u000eB;Y6\u0011!Q\u000e\u0006\u0005\u0005_\u0012\t(A\u0004nkR\f'\r\\3\u000b\u0007\tM$(\u0001\u0006d_2dWm\u0019;j_:LAAa\u001e\u0003n\t\u00191+\u001a;\u0002\u0017A\f'\u000f^5uS>t7\u000fI\u0001\bg\u0016\u001c8/[8o+\t\u0011y\b\u0005\u0003\u0003\u0002\n=e\u0002\u0002BB\u0005\u0013sA!!\u001d\u0003\u0006&\u0019!q\u0011\u0018\u0002\u000bU$\u0018\u000e\\:\n\t\t-%QR\u0001\u000f%&\u001c\u0007nS;ek\u000ec\u0017.\u001a8u\u0015\r\u00119IL\u0005\u0005\u0005#\u0013\u0019JA\u0007TKN\u001c\u0018n\u001c8I_2$WM\u001d\u0006\u0005\u0005\u0017\u0013i)\u0001\u0005tKN\u001c\u0018n\u001c8!\u0003\u001di\u0017\r\u001d9feN,\"Aa'\u0011\u000be\niA!(\u0011\u000fe\u0012yJa)\u0003.&\u0019!\u0011\u0015\u001e\u0003\rQ+\b\u000f\\33!\u0011\u0011)K!+\u000e\u0005\t\u001d&BA\"/\u0013\u0011\u0011YKa*\u0003!-+H-^\"pYVlg.T1qa\u0016\u0014\b\u0003\u0002BX\u0005wk!A!-\u000b\t\tM&QW\u0001\u0007G2LWM\u001c;\u000b\u0007=\u00129LC\u0002\u0003:R\na!\u00199bG\",\u0017\u0002\u0002B_\u0005c\u0013\u0011bS;ekR\u000b'\r\\3\u0002\u00115\f\u0007\u000f]3sg\u0002\n\u0011![\u000b\u0003\u0005\u0007\tQ![0%KF$2!\u0015Be\u0011%\u0011Y-GA\u0001\u0002\u0004\u0011\u0019!A\u0002yIE\n!!\u001b\u0011\u0002\u000b]\u0014\u0018\u000e^3\u0015\u000fE\u0013\u0019N!6\u0003j\"9\u00111]\u000eA\u0002\u0005E\u0005b\u0002Bl7\u0001\u0007!\u0011\\\u0001\u0007m\u0006dW/Z:\u0011\u000be\niAa71\t\tu'Q\u001d\t\u0007\u0003\u0013\u0012yNa9\n\t\t\u0005\u0018Q\r\u0002\f%><8*Z=WC2,X\rE\u0002[\u0005K$1Ba:\u0003V\u0006\u0005\t\u0011!B\u0001;\n\u0019q\fJ\u001c\t\u000f\t-8\u00041\u0001\u0003F\u00051Q\u000f\u001d3bi\u0016$R!\u0015Bx\u0005cDq!a9\u001d\u0001\u0004\t\t\nC\u0004\u0003Xr\u0001\rAa=\u0011\u000be\niA!>1\t\t](1 \t\u0007\u0003\u0013\u0012yN!?\u0011\u0007i\u0013Y\u0010B\u0006\u0003~\nE\u0018\u0011!A\u0001\u0006\u0003i&aA0%q\u0005)a\r\\;tQR\t\u0011+A\u0003dY>\u001cX-\u0001\ffq&\u001cH/\u001b8h!\u0006\u0014H/\u001b;j_:,%O]8s)\u0011\u0011)e!\u0003\t\u000f\r-q\u00041\u0001\u0004\u000e\u0005\tQ\rE\u0002~\u0007\u001fIAa!\u0005\u0002\n\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0005\b\u0003/D\u0001\u0019AAm\u0011\u001d\tY\u000b\u0003a\u0001\u0007/\u0001R!`A\u0003\u00073\u0001daa\u0007\u0004 \r\u0015\u0002CB X\u0007;\u0019\u0019\u0003E\u0002[\u0007?!1b!\t\u0004\u0016\u0005\u0005\t\u0011!B\u0001;\n\u0019q\fJ\u001a\u0011\u0007i\u001b)\u0003B\u0006\u0004(\rU\u0011\u0011!A\u0001\u0006\u0003i&aA0%i!9\u0001\u000e\u0003I\u0001\u0002\u0004I\u0007")
public class KuduIndexAdapter
implements IndexAdapter<KuduDataStore> {
    private final KuduDataStore ds;
    private final ColumnGroups groups;
    private final Option<Object> tableNameLimit;

    public Option<String> createWriter$default$3() {
        return IndexAdapter.createWriter$default$3$((IndexAdapter)this);
    }

    public ColumnGroups groups() {
        return this.groups;
    }

    public Option<Object> tableNameLimit() {
        return this.tableNameLimit;
    }

    public void org$locationtech$geomesa$index$api$IndexAdapter$_setter_$groups_$eq(ColumnGroups x$1) {
        this.groups = x$1;
    }

    public void org$locationtech$geomesa$index$api$IndexAdapter$_setter_$tableNameLimit_$eq(Option<Object> x$1) {
        this.tableNameLimit = x$1;
    }

    public void createTable(GeoMesaFeatureIndex<?, ?> index, Option<String> partition, Function0<Seq<byte[]>> splits) {
        block0: {
            String table = index.configureTableName(partition, index.configureTableName$default$2());
            if (this.ds.client().tableExists(table)) break block0;
            KuduColumnMapper mapper = KuduColumnMapper$.MODULE$.apply(index);
            CreateTableOptions options = mapper.configurePartitions();
            int servers = this.ds.client().listTabletServers().getTabletServersCount();
            Object object = servers < 3 ? options.setNumReplicas(servers) : BoxedUnit.UNIT;
            this.ds.client().createTable(table, mapper.tableSchema(), options);
        }
    }

    public void renameTable(String from, String to) {
        block0: {
            if (!this.ds.client().tableExists(from)) break block0;
            this.ds.client().alterTable(from, new AlterTableOptions().renameTable(to));
        }
    }

    public void deleteTables(Seq<String> tables) {
        ((ParIterableLike)tables.par()).foreach((Function1 & Serializable & scala.Serializable)table -> $this.ds.client().tableExists(table) ? $this.ds.client().deleteTable(table) : BoxedUnit.UNIT);
    }

    public void clearTables(Seq<String> tables, Option<byte[]> prefix) {
        Predef$.MODULE$.require(prefix.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Expected None but got prefix range ").append(prefix).toString());
        GeoMesaFeatureIndex[] indices = (GeoMesaFeatureIndex[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.ds.getTypeNames())).map((Function1 & Serializable & scala.Serializable)typeName -> $this.ds.getSchema((String)typeName), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SimpleFeatureType.class))))).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> $this.ds.manager().indices(x$1, $this.ds.manager().indices$default$2()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(GeoMesaFeatureIndex.class)));
        ((ParIterableLike)tables.par()).foreach((Function1 & Serializable & scala.Serializable)name -> {
            KuduIndexAdapter.$anonfun$clearTables$4(this, indices, name);
            return BoxedUnit.UNIT;
        });
    }

    public KuduQueryPlan createQueryPlan(package.QueryStrategy strategy) {
        KuduQueryPlan kuduQueryPlan;
        package.QueryStrategy queryStrategy = strategy;
        if (queryStrategy == null) {
            throw new MatchError((Object)queryStrategy);
        }
        package.FilterStrategy filter2 = queryStrategy.filter();
        Seq keyRanges = queryStrategy.keyRanges();
        Seq tieredKeyRanges = queryStrategy.tieredKeyRanges();
        Hints hints = queryStrategy.hints();
        Tuple4 tuple4 = new Tuple4((Object)filter2, (Object)keyRanges, (Object)tieredKeyRanges, (Object)hints);
        Tuple4 tuple42 = tuple4;
        package.FilterStrategy filter3 = (package.FilterStrategy)tuple42._1();
        Seq keyRanges2 = (Seq)tuple42._2();
        Seq tieredKeyRanges2 = (Seq)tuple42._3();
        Hints hints2 = (Hints)tuple42._4();
        GeoMesaFeatureIndex index = filter3.index();
        KuduColumnMapper mapper = KuduColumnMapper$.MODULE$.apply(index);
        Buffer auths = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.ds.config().authProvider().getAuthorizations()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getBytes(StandardCharsets.UTF_8), Buffer$.MODULE$.canBuildFrom());
        KuduSimpleFeatureSchema.KuduFilter kuduFilter = (KuduSimpleFeatureSchema.KuduFilter)strategy.ecql().map((Function1 & Serializable & scala.Serializable)filter -> mapper.schema().predicate((Filter)filter)).getOrElse((Function0 & Serializable & scala.Serializable)() -> new KuduSimpleFeatureSchema.KuduFilter((Seq<KuduPredicate>)((Seq)Nil$.MODULE$), (Option<Filter>)None$.MODULE$));
        if (kuduFilter == null) {
            throw new MatchError((Object)kuduFilter);
        }
        Seq<KuduPredicate> predicates = kuduFilter.predicates();
        Option<Filter> ecql = kuduFilter.filter();
        Tuple2 tuple2 = new Tuple2(predicates, ecql);
        Tuple2 tuple22 = tuple2;
        Seq predicates2 = (Seq)tuple22._1();
        Option ecql2 = (Option)tuple22._2();
        KuduResultAdapter adapter = KuduResultAdapter$.MODULE$.apply(index.sft(), (Seq<byte[]>)auths, (Option<Filter>)ecql2, hints2);
        if (keyRanges2.isEmpty()) {
            kuduQueryPlan = new KuduQueryPlan.EmptyPlan(filter3, adapter);
        } else {
            Seq tables = index.getTablesForQuery(filter3.filter());
            Seq<Tuple2<Option<PartialRow>, Option<PartialRow>>> ranges = mapper.toRowRanges(keyRanges2, (Seq<package.ByteRange>)tieredKeyRanges2);
            Option sort = QueryHints$.MODULE$.RichHints(hints2).getSortFields();
            Option max = QueryHints$.MODULE$.RichHints(hints2).getMaxFeatures();
            Option project = QueryHints$.MODULE$.RichHints(hints2).getProjection();
            int threads = this.ds.config().queries().threads();
            kuduQueryPlan = new KuduQueryPlan.ScanPlan(filter3, (Seq<String>)tables, ranges, (Seq<KuduPredicate>)predicates2, (Option<Filter>)ecql2, adapter, (Option<Seq<Tuple2<String, Object>>>)sort, (Option<Object>)max, (Option<Reprojection.QueryReferenceSystems>)project, threads);
        }
        return kuduQueryPlan;
    }

    public KuduIndexWriter createWriter(SimpleFeatureType sft, Seq<GeoMesaFeatureIndex<?, ?>> indices, Option<String> partition) {
        return new KuduIndexWriter(this.ds, indices, new KuduFeatureWrapper(sft, (WritableFeature.FeatureWrapper<WritableFeature>)WritableFeature$.MODULE$.wrapper(sft, this.groups())), partition);
    }

    public static final /* synthetic */ boolean $anonfun$clearTables$5(String name$1, GeoMesaFeatureIndex x$2) {
        return x$2.getTableNames(x$2.getTableNames$default$1()).contains((Object)name$1);
    }

    public static final /* synthetic */ void $anonfun$clearTables$10(KuduTable table$1, Seq columns$1, RichKuduClient.SessionHolder x0$1, CloseableIterator x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RichKuduClient.SessionHolder holder = (RichKuduClient.SessionHolder)tuple2._1();
        CloseableIterator iterator = (CloseableIterator)tuple2._2();
        holder.session().setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND);
        iterator.foreach((Function1 & Serializable & scala.Serializable)row -> {
            Delete delete = table$1.newDelete();
            columns$1.foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                x$5.transfer(row, delete.getRow());
                return BoxedUnit.UNIT;
            });
            return holder.session().apply((Operation)delete);
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$clearTables$4(KuduIndexAdapter $this, GeoMesaFeatureIndex[] indices$1, String name) {
        GeoMesaFeatureIndex index = (GeoMesaFeatureIndex)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indices$1)).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KuduIndexAdapter.$anonfun$clearTables$5(name, x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(45).append("Couldn't find index corresponding to table '").append(name).append("'").toString());
        });
        Seq<KuduColumnAdapter<?>> columns = KuduColumnMapper$.MODULE$.apply(index).keyColumns();
        KuduTable table = $this.ds.client().openTable(name);
        KuduScanner.KuduScannerBuilder builder = $this.ds.client().newScannerBuilder(table);
        builder.setProjectedColumnNames((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)columns.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> (Seq)x$3.columns().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getName(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).asJava());
        package.WithClose$.MODULE$.apply((Object)new RichKuduClient.SessionHolder($this.ds.client().newSession()), (Function0 & Serializable & scala.Serializable)() -> RichKuduClient$RichScanner$.MODULE$.iterator$extension(RichKuduClient$.MODULE$.RichScanner(builder.build())), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            KuduIndexAdapter.$anonfun$clearTables$10(table, columns, x0$1, x1$1);
            return BoxedUnit.UNIT;
        }, IsCloseable$.MODULE$.closeableIsCloseable(), IsCloseable$.MODULE$.closeableIsCloseable());
    }

    public KuduIndexAdapter(KuduDataStore ds) {
        this.ds = ds;
        IndexAdapter.$init$((IndexAdapter)this);
    }

    public static class KuduFeatureWrapper
    implements WritableFeature.FeatureWrapper<KuduWritableFeature> {
        private final WritableFeature.FeatureWrapper<WritableFeature> delegate;
        private final Option<Object> dtgIndex;
        private final Function1<Object, BinnedTime> toBin;
        private final KuduSimpleFeatureSchema schema;

        public boolean wrap$default$2() {
            return WritableFeature.FeatureWrapper.wrap$default$2$((WritableFeature.FeatureWrapper)this);
        }

        private Option<Object> dtgIndex() {
            return this.dtgIndex;
        }

        private Function1<Object, BinnedTime> toBin() {
            return this.toBin;
        }

        private KuduSimpleFeatureSchema schema() {
            return this.schema;
        }

        public KuduWritableFeature wrap(SimpleFeature feature, boolean delete) {
            return new KuduWritableFeature(this.delegate.wrap(feature, delete), this.schema(), this.dtgIndex(), this.toBin());
        }

        public KuduFeatureWrapper(SimpleFeatureType sft, WritableFeature.FeatureWrapper<WritableFeature> delegate) {
            this.delegate = delegate;
            this.dtgIndex = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft));
            this.toBin = BinnedTime$.MODULE$.timeToBinnedTime(RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ3Interval$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
            this.schema = KuduSimpleFeatureSchema$.MODULE$.apply(sft);
        }
    }

    public static class KuduIndexWriter
    extends IndexAdapter.BaseIndexWriter<KuduWritableFeature>
    implements StrictLogging {
        private final KuduDataStore ds;
        private final Option<String> partition;
        private final Set<String> partitions;
        private final RichKuduClient.SessionHolder session;
        private final Tuple2<KuduColumnMapper, KuduTable>[] mappers;
        private int i;
        private final Logger logger;

        public Logger logger() {
            return this.logger;
        }

        public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
            this.logger = x$1;
        }

        private Set<String> partitions() {
            return this.partitions;
        }

        private RichKuduClient.SessionHolder session() {
            return this.session;
        }

        private Tuple2<KuduColumnMapper, KuduTable>[] mappers() {
            return this.mappers;
        }

        private int i() {
            return this.i;
        }

        private void i_$eq(int x$1) {
            this.i = x$1;
        }

        public void write(KuduWritableFeature feature, package.RowKeyValue<?>[] values, boolean update) {
            this.i_$eq(0);
            while (this.i() < values.length) {
                BoxedUnit boxedUnit;
                package.RowKeyValue<?> rowKeyValue;
                Tuple2<KuduColumnMapper, KuduTable> tuple2 = this.mappers()[this.i()];
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                KuduColumnMapper mapper = (KuduColumnMapper)tuple2._1();
                KuduTable table = (KuduTable)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)mapper, (Object)table);
                Tuple2 tuple23 = tuple22;
                KuduColumnMapper mapper2 = (KuduColumnMapper)tuple23._1();
                KuduTable table2 = (KuduTable)tuple23._2();
                if (this.partitions().add((Object)new StringBuilder(1).append(mapper2.index().identifier()).append(".").append(feature.bin()).toString())) {
                    mapper2.createPartition(table2, feature.bin()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        AlterTableResponse alterTableResponse;
                        package.Partitioning partitioning = x0$1;
                        if (partitioning != null) {
                            String name = partitioning.table();
                            AlterTableOptions alter = partitioning.alteration();
                            try {
                                alterTableResponse = $this.ds.client().alterTable(name, alter);
                            }
                            catch (Throwable throwable) {
                                BoxedUnit boxedUnit;
                                Throwable throwable2 = throwable;
                                if (this.existingPartitionError(throwable2)) {
                                    if (this.logger().underlying().isDebugEnabled()) {
                                        this.logger().underlying().debug(new StringBuilder(61).append("Tried to create a partition to table ").append(name).append(" but it already exists: ").toString(), throwable2);
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                } else {
                                    throw throwable;
                                }
                                BoxedUnit boxedUnit2 = boxedUnit;
                                alterTableResponse = boxedUnit2;
                            }
                        } else {
                            throw new MatchError((Object)partitioning);
                        }
                        AlterTableResponse alterTableResponse2 = alterTableResponse;
                        return alterTableResponse2;
                    });
                }
                if ((rowKeyValue = values[this.i()]) instanceof package.SingleRowKeyValue) {
                    package.SingleRowKeyValue singleRowKeyValue = (package.SingleRowKeyValue)rowKeyValue;
                    Upsert upsert = table2.newUpsert();
                    PartialRow row = upsert.getRow();
                    mapper2.createKeyValues(singleRowKeyValue).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                        x$10.writeToRow(row);
                        return BoxedUnit.UNIT;
                    });
                    feature.kuduValues().foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
                        x$11.writeToRow(row);
                        return BoxedUnit.UNIT;
                    });
                    KuduIndexColumnAdapter$VisibilityAdapter$.MODULE$.writeToRow(row, feature.vis());
                    boxedUnit = this.session().session().apply((Operation)upsert);
                } else if (rowKeyValue instanceof package.MultiRowKeyValue) {
                    package.MultiRowKeyValue multiRowKeyValue = (package.MultiRowKeyValue)rowKeyValue;
                    multiRowKeyValue.split().foreach((Function1 & Serializable & scala.Serializable)kv -> {
                        Upsert upsert = table2.newUpsert();
                        PartialRow row = upsert.getRow();
                        mapper2.createKeyValues((package.SingleRowKeyValue<?>)kv).foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
                            x$12.writeToRow(row);
                            return BoxedUnit.UNIT;
                        });
                        feature.kuduValues().foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
                            x$13.writeToRow(row);
                            return BoxedUnit.UNIT;
                        });
                        KuduIndexColumnAdapter$VisibilityAdapter$.MODULE$.writeToRow(row, feature.vis());
                        return this.session().session().apply((Operation)upsert);
                    });
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(rowKeyValue);
                }
                this.i_$eq(this.i() + 1);
            }
        }

        public void delete(KuduWritableFeature feature, package.RowKeyValue<?>[] values) {
            this.i_$eq(0);
            while (this.i() < values.length) {
                BoxedUnit boxedUnit;
                Tuple2<KuduColumnMapper, KuduTable> tuple2 = this.mappers()[this.i()];
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                KuduColumnMapper mapper = (KuduColumnMapper)tuple2._1();
                KuduTable table = (KuduTable)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)mapper, (Object)table);
                Tuple2 tuple23 = tuple22;
                KuduColumnMapper mapper2 = (KuduColumnMapper)tuple23._1();
                KuduTable table2 = (KuduTable)tuple23._2();
                package.RowKeyValue<?> rowKeyValue = values[this.i()];
                if (rowKeyValue instanceof package.SingleRowKeyValue) {
                    package.SingleRowKeyValue singleRowKeyValue = (package.SingleRowKeyValue)rowKeyValue;
                    Delete delete = table2.newDelete();
                    PartialRow row = delete.getRow();
                    mapper2.createKeyValues(singleRowKeyValue).foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
                        x$15.writeToRow(row);
                        return BoxedUnit.UNIT;
                    });
                    boxedUnit = this.session().session().apply((Operation)delete);
                } else if (rowKeyValue instanceof package.MultiRowKeyValue) {
                    package.MultiRowKeyValue multiRowKeyValue = (package.MultiRowKeyValue)rowKeyValue;
                    multiRowKeyValue.split().foreach((Function1 & Serializable & scala.Serializable)kv -> {
                        Delete delete = table2.newDelete();
                        PartialRow row = delete.getRow();
                        mapper2.createKeyValues((package.SingleRowKeyValue<?>)kv).foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
                            x$16.writeToRow(row);
                            return BoxedUnit.UNIT;
                        });
                        return this.session().session().apply((Operation)delete);
                    });
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(rowKeyValue);
                }
                this.i_$eq(this.i() + 1);
            }
        }

        public void flush() {
            this.session().flush();
        }

        public void close() {
            this.session().close();
        }

        private boolean existingPartitionError(Throwable e) {
            return e.getMessage() != null && e.getMessage().startsWith("New range partition conflicts with existing range partition");
        }

        public KuduIndexWriter(KuduDataStore ds, Seq<GeoMesaFeatureIndex<?, ?>> indices, KuduFeatureWrapper wrapper, Option<String> partition) {
            this.ds = ds;
            this.partition = partition;
            super(indices, (WritableFeature.FeatureWrapper)wrapper);
            StrictLogging.$init$((StrictLogging)this);
            this.partitions = Set$.MODULE$.empty();
            this.session = new RichKuduClient.SessionHolder(ds.client().newSession());
            this.session().session().setMutationBufferSpace(BoxesRunTime.unboxToInt((Object)package$KuduSystemProperties$.MODULE$.MutationBufferSpace().toInt().get()));
            this.session().session().setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND);
            this.mappers = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indices.toArray(ClassTag$.MODULE$.apply(GeoMesaFeatureIndex.class)))).map((Function1 & Serializable & scala.Serializable)index -> {
                KuduColumnMapper mapper = KuduColumnMapper$.MODULE$.apply((GeoMesaFeatureIndex<?, ?>)index);
                Seq seq = index.getTableNames($this.partition);
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(1) != 0) {
                    throw new IllegalStateException(new StringBuilder(33).append("Expected a single table but got: ").append(seq.mkString(", ")).toString());
                }
                String t = (String)((SeqLike)some.get()).apply(0);
                KuduTable kuduTable = $this.ds.client().openTable(t);
                KuduTable table = kuduTable;
                return new Tuple2((Object)mapper, (Object)table);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            this.i = 0;
        }
    }
}

