/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kudu.result;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.filter.factory.FastFilterFactory$;
import org.locationtech.geomesa.kudu.result.ArrowAdapter;
import org.locationtech.geomesa.kudu.result.KuduResultAdapter;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.io.ByteBuffers;
import org.locationtech.geomesa.utils.io.ByteBuffers$;
import org.locationtech.geomesa.utils.text.StringSerialization$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ArrowAdapter$
implements KuduResultAdapter.KuduResultAdapterSerialization<ArrowAdapter>,
scala.Serializable {
    public static ArrowAdapter$ MODULE$;

    static {
        new ArrowAdapter$();
    }

    @Override
    public void serialize(ArrowAdapter adapter, ByteBuffers.ExpandingByteBuffer bb) {
        bb.putString(adapter.sft().getTypeName());
        bb.putString(SimpleFeatureTypes$.MODULE$.encodeType(adapter.sft(), true));
        bb.putInt(adapter.auths().length());
        adapter.auths().foreach((Function1 & Serializable & scala.Serializable)bytes -> {
            bb.putBytes(bytes);
            return BoxedUnit.UNIT;
        });
        bb.putString((String)adapter.ecql().map((Function1 & Serializable & scala.Serializable)x$1 -> ECQL.toCQL((Filter)x$1)).orNull(Predef$.MODULE$.$conforms()));
        bb.putString((String)adapter.transform().map((Function1 & Serializable & scala.Serializable)t -> SimpleFeatureTypes$.MODULE$.encodeType((SimpleFeatureType)t._2(), true)).orNull(Predef$.MODULE$.$conforms()));
        bb.putString((String)adapter.transform().map((Function1 & Serializable & scala.Serializable)x$11 -> (String)x$11._1()).orNull(Predef$.MODULE$.$conforms()));
        bb.putBool(adapter.config().includeFid());
        bb.putBool(adapter.config().proxyFid());
        bb.putInt(adapter.config().dictionaryFields().length());
        adapter.config().dictionaryFields().foreach((Function1 & Serializable & scala.Serializable)string -> {
            bb.putString(string);
            return BoxedUnit.UNIT;
        });
        if (adapter.config().providedDictionaries().isEmpty()) {
            bb.putString(null);
        } else {
            bb.putString(StringSerialization$.MODULE$.encodeSeqMap(adapter.config().providedDictionaries().mapValues((Function1 & Serializable & scala.Serializable)x$12 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(x$12)).toSeq())));
        }
        bb.putString((String)adapter.config().sort().map((Function1 & Serializable & scala.Serializable)x$13 -> (String)x$13._1()).orNull(Predef$.MODULE$.$conforms()));
        bb.putBool(adapter.config().sort().exists((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14._2$mcZ$sp())));
        bb.putInt(adapter.config().batchSize());
        bb.putBool(adapter.config().skipReduce());
        bb.putBool(adapter.config().doublePass());
        bb.putBool(adapter.config().multiFile());
    }

    @Override
    public ArrowAdapter deserialize(ByteBuffer bb) {
        SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.createType(ByteBuffers.RichByteBuffer$.MODULE$.getString$extension(ByteBuffers$.MODULE$.RichByteBuffer(bb)), ByteBuffers.RichByteBuffer$.MODULE$.getString$extension(ByteBuffers$.MODULE$.RichByteBuffer(bb)));
        Seq auths = (Seq)Seq$.MODULE$.fill(bb.getInt(), (Function0 & Serializable & scala.Serializable)() -> ByteBuffers.RichByteBuffer$.MODULE$.getBytes$extension(ByteBuffers$.MODULE$.RichByteBuffer(bb)));
        Option ecql = Option$.MODULE$.apply((Object)ByteBuffers.RichByteBuffer$.MODULE$.getString$extension(ByteBuffers$.MODULE$.RichByteBuffer(bb))).map((Function1 & Serializable & scala.Serializable)x$15 -> FastFilterFactory$.MODULE$.toFilter(sft, x$15));
        Option tsft = Option$.MODULE$.apply((Object)ByteBuffers.RichByteBuffer$.MODULE$.getString$extension(ByteBuffers$.MODULE$.RichByteBuffer(bb))).map((Function1 & Serializable & scala.Serializable)x$16 -> SimpleFeatureTypes$.MODULE$.createType(sft.getTypeName(), x$16));
        Option tdefs = Option$.MODULE$.apply((Object)ByteBuffers.RichByteBuffer$.MODULE$.getString$extension(ByteBuffers$.MODULE$.RichByteBuffer(bb)));
        Option transform = tsft.flatMap((Function1 & Serializable & scala.Serializable)s -> tdefs.map((Function1 & Serializable & scala.Serializable)d -> new Tuple2(d, s)));
        boolean includeFid = ByteBuffers.RichByteBuffer$.MODULE$.getBool$extension(ByteBuffers$.MODULE$.RichByteBuffer(bb));
        boolean proxyFid = ByteBuffers.RichByteBuffer$.MODULE$.getBool$extension(ByteBuffers$.MODULE$.RichByteBuffer(bb));
        Seq dictionaryFields = (Seq)Seq$.MODULE$.fill(bb.getInt(), (Function0 & Serializable & scala.Serializable)() -> ByteBuffers.RichByteBuffer$.MODULE$.getString$extension(ByteBuffers$.MODULE$.RichByteBuffer(bb)));
        Map providedDictionaries = (Map)Option$.MODULE$.apply((Object)ByteBuffers.RichByteBuffer$.MODULE$.getString$extension(ByteBuffers$.MODULE$.RichByteBuffer(bb))).map((Function1 & Serializable & scala.Serializable)x$17 -> StringSerialization$.MODULE$.decodeSeqMap(sft, x$17)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
        Option sortField = Option$.MODULE$.apply((Object)ByteBuffers.RichByteBuffer$.MODULE$.getString$extension(ByteBuffers$.MODULE$.RichByteBuffer(bb)));
        boolean sortReverse = ByteBuffers.RichByteBuffer$.MODULE$.getBool$extension(ByteBuffers$.MODULE$.RichByteBuffer(bb));
        Option sort = sortField.map((Function1 & Serializable & scala.Serializable)x$18 -> new Tuple2(x$18, (Object)BoxesRunTime.boxToBoolean((boolean)sortReverse)));
        int batchSize = bb.getInt();
        boolean skipReduce = ByteBuffers.RichByteBuffer$.MODULE$.getBool$extension(ByteBuffers$.MODULE$.RichByteBuffer(bb));
        boolean doublePass = ByteBuffers.RichByteBuffer$.MODULE$.getBool$extension(ByteBuffers$.MODULE$.RichByteBuffer(bb));
        boolean multiFile = ByteBuffers.RichByteBuffer$.MODULE$.getBool$extension(ByteBuffers$.MODULE$.RichByteBuffer(bb));
        ArrowAdapter.ArrowConfig config = new ArrowAdapter.ArrowConfig(includeFid, proxyFid, (Seq<String>)dictionaryFields, (Map<String, Object[]>)providedDictionaries, (Option<Tuple2<String, Object>>)sort, batchSize, skipReduce, doublePass, multiFile);
        return new ArrowAdapter(sft, (Seq<byte[]>)auths, (Option<Filter>)ecql, (Option<Tuple2<String, SimpleFeatureType>>)transform, config);
    }

    public ArrowAdapter apply(SimpleFeatureType sft, Seq<byte[]> auths, Option<Filter> ecql, Option<Tuple2<String, SimpleFeatureType>> transform, ArrowAdapter.ArrowConfig config) {
        return new ArrowAdapter(sft, auths, ecql, transform, config);
    }

    public Option<Tuple5<SimpleFeatureType, Seq<byte[]>, Option<Filter>, Option<Tuple2<String, SimpleFeatureType>>, ArrowAdapter.ArrowConfig>> unapply(ArrowAdapter x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)x$0.sft(), x$0.auths(), x$0.ecql(), x$0.transform(), (Object)x$0.config()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ArrowAdapter$() {
        MODULE$ = this;
    }
}

