/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kudu.utils;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.apache.kudu.ColumnSchema;
import org.locationtech.geomesa.kudu.package$KuduSystemProperties$;
import org.locationtech.geomesa.kudu.utils.ColumnConfiguration;
import org.locationtech.geomesa.utils.geotools.ObjectType$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ColumnConfiguration$
implements LazyLogging,
scala.Serializable {
    public static ColumnConfiguration$ MODULE$;
    private final String EncodingOption;
    private final String CompressionOption;
    private final Seq<Enumeration.Value> defaultBitShuffleTypes;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ColumnConfiguration$();
    }

    private Logger logger$lzycompute() {
        ColumnConfiguration$ columnConfiguration$ = this;
        synchronized (columnConfiguration$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String EncodingOption() {
        return this.EncodingOption;
    }

    public String CompressionOption() {
        return this.CompressionOption;
    }

    private Seq<Enumeration.Value> defaultBitShuffleTypes() {
        return this.defaultBitShuffleTypes;
    }

    public ColumnConfiguration apply(Enumeration.Value binding, Map<Object, Object> config) {
        Some some;
        Option enc = config.get((Object)this.EncodingOption()).map((Function1 & Serializable & scala.Serializable)e -> MODULE$.encoding(e.toString()));
        if (enc.contains((Object)ColumnSchema.Encoding.BIT_SHUFFLE) || this.defaultBitShuffleTypes().contains((Object)binding)) {
            config.get((Object)this.CompressionOption()).foreach((Function1 & Serializable & scala.Serializable)c -> {
                ColumnConfiguration$.$anonfun$apply$6(binding, c);
                return BoxedUnit.UNIT;
            });
            some = None$.MODULE$;
        } else {
            some = new Some((Object)this.compression((Option<String>)config.get((Object)this.CompressionOption()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString())));
        }
        Some comp = some;
        return new ColumnConfiguration((Option<ColumnSchema.Encoding>)enc, (Option<ColumnSchema.CompressionAlgorithm>)comp);
    }

    public ColumnSchema.Encoding encoding(String name) {
        return (ColumnSchema.Encoding)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ColumnSchema.Encoding.values())).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ColumnConfiguration$.$anonfun$encoding$1(name, x$3))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(41).append("Encoding '").append(name).append("' not found. Valid values are: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ColumnSchema.Encoding.values())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ")).toString());
        });
    }

    public ColumnSchema.CompressionAlgorithm compression(Option<String> name) {
        String n = (String)name.getOrElse((Function0 & Serializable & scala.Serializable)() -> package$KuduSystemProperties$.MODULE$.Compression().get());
        return (ColumnSchema.CompressionAlgorithm)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ColumnSchema.CompressionAlgorithm.values())).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ColumnConfiguration$.$anonfun$compression$2(n, x$5))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(44).append("Compression '").append(n).append("' not found. Valid values are: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ColumnSchema.CompressionAlgorithm.values())).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ")).toString());
        });
    }

    public Option<String> compression$default$1() {
        return None$.MODULE$;
    }

    public ColumnConfiguration apply(Option<ColumnSchema.Encoding> encoding, Option<ColumnSchema.CompressionAlgorithm> compression) {
        return new ColumnConfiguration(encoding, compression);
    }

    public Option<Tuple2<Option<ColumnSchema.Encoding>, Option<ColumnSchema.CompressionAlgorithm>>> unapply(ColumnConfiguration x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2(x$0.encoding(), x$0.compression()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$apply$6(Enumeration.Value binding$1, Object c) {
        BoxedUnit boxedUnit;
        if (MODULE$.logger().underlying().isWarnEnabled()) {
            MODULE$.logger().underlying().warn("Ignoring compression '{}' on bit-shuffled column of type '{}'", new Object[]{c, binding$1});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$encoding$1(String name$1, ColumnSchema.Encoding x$3) {
        return x$3.name().equalsIgnoreCase(name$1);
    }

    public static final /* synthetic */ boolean $anonfun$compression$2(String n$1, ColumnSchema.CompressionAlgorithm x$5) {
        return x$5.name().equalsIgnoreCase(n$1);
    }

    private ColumnConfiguration$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.EncodingOption = "encoding";
        this.CompressionOption = "compression";
        this.defaultBitShuffleTypes = (Seq)new .colon.colon((Object)ObjectType$.MODULE$.INT(), (List)new .colon.colon((Object)ObjectType$.MODULE$.LONG(), (List)new .colon.colon((Object)ObjectType$.MODULE$.FLOAT(), (List)new .colon.colon((Object)ObjectType$.MODULE$.DOUBLE(), (List)new .colon.colon((Object)ObjectType$.MODULE$.DATE(), (List)new .colon.colon((Object)ObjectType$.MODULE$.GEOMETRY(), (List)Nil$.MODULE$))))));
    }
}

