/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kudu.data;

import com.github.benmanes.caffeine.cache.LoadingCache;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.Delete;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.OperationResponse;
import org.apache.kudu.client.Upsert;
import org.locationtech.geomesa.index.metadata.GeoMesaMetadata;
import org.locationtech.geomesa.index.metadata.TableBasedMetadata;
import org.locationtech.geomesa.index.metadata.package;
import org.locationtech.geomesa.kudu.utils.ColumnConfiguration$;
import org.locationtech.geomesa.kudu.utils.RichKuduClient$;
import org.locationtech.geomesa.kudu.utils.RichKuduClient$RichScanner$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.conversions.ScalaImplicits;
import org.locationtech.geomesa.utils.conversions.ScalaImplicits$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001\u0002\n\u0014\u0001yA\u0001B\u0010\u0001\u0003\u0006\u0004%\ta\u0010\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0001\"A\u0011\n\u0001BC\u0002\u0013\u0005!\n\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003L\u0011!9\u0006A!b\u0001\n\u0003A\u0006\u0002\u00036\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u000b-\u0004A\u0011\u00017\t\u0011I\u0004\u0001R1A\u0005\nMDQa\u001e\u0001\u0005RaDQ\u0001 \u0001\u0005RuDq!a\u0001\u0001\t#\n)\u0001C\u0004\u0002\f\u0001!\t&!\u0004\t\u000f\u0005e\u0002\u0001\"\u0015\u0002<!9\u0011Q\t\u0001\u0005R\u0005\u001d\u0003bBA+\u0001\u0011E\u0013q\u000b\u0005\b\u0003_\u0002A\u0011KA9\u0011\u0019\t9\b\u0001C!{\n\u00112*\u001e3v\u0005\u0006\u001c7.\u001a3NKR\fG-\u0019;b\u0015\t!R#\u0001\u0003eCR\f'B\u0001\f\u0018\u0003\u0011YW\u000fZ;\u000b\u0005aI\u0012aB4f_6,7/\u0019\u0006\u00035m\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011\u0001H\u0001\u0004_J<7\u0001A\u000b\u0003?I\u001a2\u0001\u0001\u0011)!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0003mC:<'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012aa\u00142kK\u000e$\bcA\u0015/a5\t!F\u0003\u0002,Y\u0005AQ.\u001a;bI\u0006$\u0018M\u0003\u0002./\u0005)\u0011N\u001c3fq&\u0011qF\u000b\u0002\u0013)\u0006\u0014G.\u001a\"bg\u0016$W*\u001a;bI\u0006$\u0018\r\u0005\u00022e1\u0001A!B\u001a\u0001\u0005\u0004!$!\u0001+\u0012\u0005UZ\u0004C\u0001\u001c:\u001b\u00059$\"\u0001\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005i:$a\u0002(pi\"Lgn\u001a\t\u0003mqJ!!P\u001c\u0003\u0007\u0005s\u00170\u0001\u0004dY&,g\u000e^\u000b\u0002\u0001B\u0011\u0011IR\u0007\u0002\u0005*\u0011ah\u0011\u0006\u0003-\u0011S!!R\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t9%I\u0001\u0006Lk\u0012,8\t\\5f]R\fqa\u00197jK:$\b%A\u0004dCR\fGn\\4\u0016\u0003-\u0003\"\u0001T*\u000f\u00055\u000b\u0006C\u0001(8\u001b\u0005y%B\u0001)\u001e\u0003\u0019a$o\\8u}%\u0011!kN\u0001\u0007!J,G-\u001a4\n\u0005Q+&AB*ue&twM\u0003\u0002So\u0005A1-\u0019;bY><\u0007%\u0001\u0006tKJL\u0017\r\\5{KJ,\u0012!\u0017\t\u00045\u001e\u0004dBA.f\u001d\taFM\u0004\u0002^G:\u0011aL\u0019\b\u0003?\u0006t!A\u00141\n\u0003qI!AG\u000e\n\u0005aI\u0012BA\u0017\u0018\u0013\tYC&\u0003\u0002gU\u00059\u0001/Y2lC\u001e,\u0017B\u00015j\u0005IiU\r^1eCR\f7+\u001a:jC2L'0\u001a:\u000b\u0005\u0019T\u0013aC:fe&\fG.\u001b>fe\u0002\na\u0001P5oSRtD\u0003B7paF\u00042A\u001c\u00011\u001b\u0005\u0019\u0002\"\u0002 \b\u0001\u0004\u0001\u0005\"B%\b\u0001\u0004Y\u0005\"B,\b\u0001\u0004I\u0016!\u0002;bE2,W#\u0001;\u0011\u0005\u0005+\u0018B\u0001<C\u0005%YU\u000fZ;UC\ndW-\u0001\ndQ\u0016\u001c7.\u00134UC\ndW-\u0012=jgR\u001cX#A=\u0011\u0005YR\u0018BA>8\u0005\u001d\u0011un\u001c7fC:\f1b\u0019:fCR,G+\u00192mKR\ta\u0010\u0005\u00027\u007f&\u0019\u0011\u0011A\u001c\u0003\tUs\u0017\u000e^\u0001\u0012GJ,\u0017\r^3F[B$\u0018PQ1dWV\u0004HcA7\u0002\b!1\u0011\u0011B\u0006A\u0002-\u000b\u0011\u0002^5nKN$\u0018-\u001c9\u0002\u000b]\u0014\u0018\u000e^3\u0015\u000by\fy!a\u0005\t\r\u0005EA\u00021\u0001L\u0003!!\u0018\u0010]3OC6,\u0007bBA\u000b\u0019\u0001\u0007\u0011qC\u0001\u0005e><8\u000f\u0005\u0004\u0002\u001a\u0005\u0005\u0012q\u0005\b\u0005\u00037\tyBD\u0002O\u0003;I\u0011\u0001O\u0005\u0003M^JA!a\t\u0002&\t\u00191+Z9\u000b\u0005\u0019<\u0004C\u0002\u001c\u0002*-\u000bi#C\u0002\u0002,]\u0012a\u0001V;qY\u0016\u0014\u0004#\u0002\u001c\u00020\u0005M\u0012bAA\u0019o\t)\u0011I\u001d:bsB\u0019a'!\u000e\n\u0007\u0005]rG\u0001\u0003CsR,\u0017A\u00023fY\u0016$X\rF\u0003\u007f\u0003{\ty\u0004\u0003\u0004\u0002\u00125\u0001\ra\u0013\u0005\b\u0003\u0003j\u0001\u0019AA\"\u0003\u0011YW-_:\u0011\u000b\u0005e\u0011\u0011E&\u0002\u0013M\u001c\u0017M\u001c,bYV,GCBA%\u0003\u001f\n\t\u0006E\u00037\u0003\u0017\ni#C\u0002\u0002N]\u0012aa\u00149uS>t\u0007BBA\t\u001d\u0001\u00071\n\u0003\u0004\u0002T9\u0001\raS\u0001\u0004W\u0016L\u0018AC:dC:4\u0016\r\\;fgR1\u0011\u0011LA5\u0003W\u0002b!a\u0017\u0002f\u0005\u001dRBAA/\u0015\u0011\ty&!\u0019\u0002\u0015\r|G\u000e\\3di&|gNC\u0002\u0002d]\tQ!\u001e;jYNLA!a\u001a\u0002^\t\t2\t\\8tK\u0006\u0014G.Z%uKJ\fGo\u001c:\t\r\u0005Eq\u00021\u0001L\u0011!\tig\u0004I\u0001\u0002\u0004Y\u0015A\u00029sK\u001aL\u00070\u0001\u0005tG\u0006t7*Z=t)\t\t\u0019\b\u0005\u0004\u0002\\\u0005\u0015\u0014Q\u000f\t\u0006m\u0005%2jS\u0001\u0006G2|7/\u001a")
public class KuduBackedMetadata<T>
implements TableBasedMetadata<T> {
    private KuduTable table;
    private final KuduClient client;
    private final String catalog;
    private final package.MetadataSerializer<T> serializer;
    private final AtomicBoolean org$locationtech$geomesa$index$metadata$TableBasedMetadata$$tableExists;
    private final long org$locationtech$geomesa$index$metadata$TableBasedMetadata$$expiry;
    private final LoadingCache<Tuple2<String, String>, Option<T>> org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataCache;
    private final LoadingCache<Tuple2<String, String>, Seq<Tuple2<String, T>>> org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataScanCache;
    private DateTimeFormatter org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter;
    private Logger logger;
    private volatile byte bitmap$0;

    public String scanValues$default$2() {
        return TableBasedMetadata.scanValues$default$2$((TableBasedMetadata)this);
    }

    public String[] getFeatureTypes() {
        return TableBasedMetadata.getFeatureTypes$((TableBasedMetadata)this);
    }

    public Option<T> read(String typeName, String key, boolean cache) {
        return TableBasedMetadata.read$((TableBasedMetadata)this, (String)typeName, (String)key, (boolean)cache);
    }

    public Seq<Tuple2<String, T>> scan(String typeName, String prefix, boolean cache) {
        return TableBasedMetadata.scan$((TableBasedMetadata)this, (String)typeName, (String)prefix, (boolean)cache);
    }

    public void insert(String typeName, String key, T value) {
        TableBasedMetadata.insert$((TableBasedMetadata)this, (String)typeName, (String)key, value);
    }

    public void insert(String typeName, Map<String, T> kvPairs) {
        TableBasedMetadata.insert$((TableBasedMetadata)this, (String)typeName, kvPairs);
    }

    public void invalidateCache(String typeName, String key) {
        TableBasedMetadata.invalidateCache$((TableBasedMetadata)this, (String)typeName, (String)key);
    }

    public void remove(String typeName, String key) {
        TableBasedMetadata.remove$((TableBasedMetadata)this, (String)typeName, (String)key);
    }

    public void remove(String typeName, Seq<String> keys) {
        TableBasedMetadata.remove$((TableBasedMetadata)this, (String)typeName, keys);
    }

    public void delete(String typeName) {
        TableBasedMetadata.delete$((TableBasedMetadata)this, (String)typeName);
    }

    public void backup(String typeName) {
        TableBasedMetadata.backup$((TableBasedMetadata)this, (String)typeName);
    }

    public void ensureTableExists() {
        TableBasedMetadata.ensureTableExists$((TableBasedMetadata)this);
    }

    public void resetCache() {
        TableBasedMetadata.resetCache$((TableBasedMetadata)this);
    }

    public boolean read$default$3() {
        return GeoMesaMetadata.read$default$3$((GeoMesaMetadata)this);
    }

    public T readRequired(String typeName, String key) {
        return (T)GeoMesaMetadata.readRequired$((GeoMesaMetadata)this, (String)typeName, (String)key);
    }

    public boolean scan$default$3() {
        return GeoMesaMetadata.scan$default$3$((GeoMesaMetadata)this);
    }

    public AtomicBoolean org$locationtech$geomesa$index$metadata$TableBasedMetadata$$tableExists() {
        return this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$tableExists;
    }

    public long org$locationtech$geomesa$index$metadata$TableBasedMetadata$$expiry() {
        return this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$expiry;
    }

    public LoadingCache<Tuple2<String, String>, Option<T>> org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataCache() {
        return this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataCache;
    }

    public LoadingCache<Tuple2<String, String>, Seq<Tuple2<String, T>>> org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataScanCache() {
        return this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataScanCache;
    }

    private DateTimeFormatter org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter$lzycompute() {
        KuduBackedMetadata kuduBackedMetadata = this;
        synchronized (kuduBackedMetadata) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter = TableBasedMetadata.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter$((TableBasedMetadata)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter;
    }

    public DateTimeFormatter org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter$lzycompute() : this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$formatter;
    }

    public final void org$locationtech$geomesa$index$metadata$TableBasedMetadata$_setter_$org$locationtech$geomesa$index$metadata$TableBasedMetadata$$tableExists_$eq(AtomicBoolean x$1) {
        this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$tableExists = x$1;
    }

    public final void org$locationtech$geomesa$index$metadata$TableBasedMetadata$_setter_$org$locationtech$geomesa$index$metadata$TableBasedMetadata$$expiry_$eq(long x$1) {
        this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$expiry = x$1;
    }

    public final void org$locationtech$geomesa$index$metadata$TableBasedMetadata$_setter_$org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataCache_$eq(LoadingCache<Tuple2<String, String>, Option<T>> x$1) {
        this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataCache = x$1;
    }

    public final void org$locationtech$geomesa$index$metadata$TableBasedMetadata$_setter_$org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataScanCache_$eq(LoadingCache<Tuple2<String, String>, Seq<Tuple2<String, T>>> x$1) {
        this.org$locationtech$geomesa$index$metadata$TableBasedMetadata$$metaDataScanCache = x$1;
    }

    private Logger logger$lzycompute() {
        KuduBackedMetadata kuduBackedMetadata = this;
        synchronized (kuduBackedMetadata) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public KuduClient client() {
        return this.client;
    }

    public String catalog() {
        return this.catalog;
    }

    public package.MetadataSerializer<T> serializer() {
        return this.serializer;
    }

    private KuduTable table$lzycompute() {
        KuduBackedMetadata kuduBackedMetadata = this;
        synchronized (kuduBackedMetadata) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.table = this.client().openTable(this.catalog());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.table;
    }

    private KuduTable table() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.table$lzycompute() : this.table;
    }

    public boolean checkIfTableExists() {
        return this.client().tableExists(this.catalog());
    }

    public void createTable() {
        ColumnSchema sftCol = new ColumnSchema.ColumnSchemaBuilder("type", Type.STRING).encoding(ColumnSchema.Encoding.PREFIX_ENCODING).compressionAlgorithm(ColumnConfiguration$.MODULE$.compression(ColumnConfiguration$.MODULE$.compression$default$1())).key(true).build();
        ColumnSchema keyCol = new ColumnSchema.ColumnSchemaBuilder("key", Type.STRING).encoding(ColumnSchema.Encoding.PLAIN_ENCODING).compressionAlgorithm(ColumnConfiguration$.MODULE$.compression(ColumnConfiguration$.MODULE$.compression$default$1())).key(true).build();
        ColumnSchema valueCol = new ColumnSchema.ColumnSchemaBuilder("value", Type.BINARY).encoding(ColumnSchema.Encoding.PLAIN_ENCODING).compressionAlgorithm(ColumnConfiguration$.MODULE$.compression(ColumnConfiguration$.MODULE$.compression$default$1())).build();
        Schema schema = new Schema((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)sftCol, (List)new .colon.colon((Object)keyCol, (List)new .colon.colon((Object)valueCol, (List)Nil$.MODULE$)))).asJava());
        CreateTableOptions options = new CreateTableOptions().addHashPartitions(Collections.singletonList(sftCol.getName()), 2);
        int servers = this.client().listTabletServers().getTabletServersCount();
        Object object = servers < 3 ? options.setNumReplicas(servers) : BoxedUnit.UNIT;
        this.client().createTable(this.catalog(), schema, options);
    }

    public KuduBackedMetadata<T> createEmptyBackup(String timestamp) {
        return new KuduBackedMetadata<T>(this.client(), new StringBuilder(5).append(this.catalog()).append("_").append(timestamp).append("_bak").toString(), this.serializer());
    }

    public void write(String typeName, Seq<Tuple2<String, byte[]>> rows) {
        try (KuduSession session = this.client().newSession();){
            rows.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                byte[] value = (byte[])tuple2._2();
                Upsert insert = this.table().newUpsert();
                insert.getRow().addString(0, typeName);
                insert.getRow().addString(1, key);
                insert.getRow().addBinary(2, value);
                OperationResponse operationResponse = session.apply((Operation)insert);
                return operationResponse;
            });
        }
    }

    public void delete(String typeName, Seq<String> keys) {
        try (KuduSession session = this.client().newSession();){
            keys.foreach((Function1 & Serializable & scala.Serializable)key -> {
                Delete delete = this.table().newDelete();
                delete.getRow().addString(0, typeName);
                delete.getRow().addString(1, key);
                return session.apply((Operation)delete);
            });
        }
    }

    public Option<byte[]> scanValue(String typeName, String key) {
        KuduScanner scanner = ((KuduScanner.KuduScannerBuilder)this.client().newScannerBuilder(this.table()).setProjectedColumnIndexes(Collections.singletonList(Predef$.MODULE$.int2Integer(2))).addPredicate(KuduPredicate.newComparisonPredicate((ColumnSchema)this.table().getSchema().getColumnByIndex(0), (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (String)typeName)).addPredicate(KuduPredicate.newComparisonPredicate((ColumnSchema)this.table().getSchema().getColumnByIndex(1), (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (String)key))).build();
        return (Option)package.WithClose$.MODULE$.apply(RichKuduClient$RichScanner$.MODULE$.iterator$extension(RichKuduClient$.MODULE$.RichScanner(scanner)), (Function1 & Serializable & scala.Serializable)x$1 -> ScalaImplicits.RichIterator$.MODULE$.headOption$extension(ScalaImplicits$.MODULE$.RichIterator((Iterator)x$1)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getBinaryCopy(0)), IsCloseable$.MODULE$.closeableIsCloseable());
    }

    public CloseableIterator<Tuple2<String, byte[]>> scanValues(String typeName, String prefix) {
        KuduScanner.KuduScannerBuilder builder = (KuduScanner.KuduScannerBuilder)this.client().newScannerBuilder(this.table()).setProjectedColumnIndexes((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava());
        builder.addPredicate(KuduPredicate.newComparisonPredicate((ColumnSchema)this.table().getSchema().getColumnByIndex(0), (KuduPredicate.ComparisonOp)KuduPredicate.ComparisonOp.EQUAL, (String)typeName));
        CloseableIterator iter = RichKuduClient$RichScanner$.MODULE$.iterator$extension(RichKuduClient$.MODULE$.RichScanner(builder.build())).map((Function1 & Serializable & scala.Serializable)r -> new Tuple2((Object)r.getString(1), (Object)r.getBinaryCopy(2)));
        return prefix == null || prefix.isEmpty() ? iter : iter.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)KuduBackedMetadata.$anonfun$scanValues$2(prefix, x0$1)));
    }

    public CloseableIterator<Tuple2<String, String>> scanKeys() {
        KuduScanner.KuduScannerBuilder builder = (KuduScanner.KuduScannerBuilder)this.client().newScannerBuilder(this.table()).setProjectedColumnIndexes((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)Nil$.MODULE$))).asJava());
        return RichKuduClient$RichScanner$.MODULE$.iterator$extension(RichKuduClient$.MODULE$.RichScanner(builder.build())).map((Function1 & Serializable & scala.Serializable)r -> new Tuple2((Object)r.getString(0), (Object)r.getString(1)));
    }

    public void close() {
    }

    public static final /* synthetic */ boolean $anonfun$scanValues$2(String prefix$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        boolean bl = k.startsWith(prefix$1);
        return bl;
    }

    public KuduBackedMetadata(KuduClient client, String catalog, package.MetadataSerializer<T> serializer) {
        this.client = client;
        this.catalog = catalog;
        this.serializer = serializer;
        GeoMesaMetadata.$init$((GeoMesaMetadata)this);
        LazyLogging.$init$((LazyLogging)this);
        TableBasedMetadata.$init$((TableBasedMetadata)this);
    }
}

