/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kudu.result;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.kudu.client.RowResult;
import org.locationtech.geomesa.kudu.result.FilteringAdapter$;
import org.locationtech.geomesa.kudu.result.KuduResultAdapter;
import org.locationtech.geomesa.kudu.schema.KuduIndexColumnAdapter$FeatureIdAdapter$;
import org.locationtech.geomesa.kudu.schema.KuduIndexColumnAdapter$VisibilityAdapter$;
import org.locationtech.geomesa.kudu.schema.KuduSimpleFeatureSchema;
import org.locationtech.geomesa.kudu.schema.KuduSimpleFeatureSchema$;
import org.locationtech.geomesa.kudu.schema.RowResultSimpleFeature;
import org.locationtech.geomesa.security.SecurityUtils;
import org.locationtech.geomesa.security.VisibilityEvaluator$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.io.ByteBuffers;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tec\u0001\u0002\u0013&\u0001BB\u0001\"\u0011\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0007\"Aa\n\u0001BK\u0002\u0013\u0005q\n\u0003\u0005c\u0001\tE\t\u0015!\u0003Q\u0011!\u0019\u0007A!f\u0001\n\u0003!\u0007\u0002C6\u0001\u0005#\u0005\u000b\u0011B3\t\u000b1\u0004A\u0011A7\t\u000fI\u0004!\u0019!C\u0005g\"1\u0011\u0010\u0001Q\u0001\nQDq\u0001\u0013\u0001C\u0002\u0013%!\u0010\u0003\u0004\u007f\u0001\u0001\u0006Ia\u001f\u0005\t\u007f\u0002\u0011\r\u0011\"\u0011\u0002\u0002!A\u0011Q\u0003\u0001!\u0002\u0013\t\u0019\u0001C\u0003'\u0001\u0011\u0005#\tC\u0004\u0002\u0018\u0001!\t%!\u0007\t\u000f\u0005%\u0003\u0001\"\u0011\u0002L!I\u0011Q\n\u0001\u0002\u0002\u0013\u0005\u0011q\n\u0005\n\u0003/\u0002\u0011\u0013!C\u0001\u00033B\u0011\"a\u001c\u0001#\u0003%\t!!\u001d\t\u0013\u0005U\u0004!%A\u0005\u0002\u0005]\u0004\"CA>\u0001\u0005\u0005I\u0011IA?\u0011%\ti\tAA\u0001\n\u0003\ty\tC\u0005\u0002\u0018\u0002\t\t\u0011\"\u0001\u0002\u001a\"I\u0011Q\u0015\u0001\u0002\u0002\u0013\u0005\u0013q\u0015\u0005\n\u0003g\u0003\u0011\u0011!C\u0001\u0003kC\u0011\"a0\u0001\u0003\u0003%\t%!1\t\u0013\u0005\r\u0007!!A\u0005B\u0005\u0015waBAeK!\u0005\u00111\u001a\u0004\u0007I\u0015B\t!!4\t\r1lB\u0011AAy\u0011\u001d\t\u00190\bC!\u0003kDqAa\b\u001e\t\u0003\u0012\t\u0003C\u0005\u00032u\t\t\u0011\"!\u00034!I!1H\u000f\u0002\u0002\u0013\u0005%Q\b\u0005\n\u0005\u001fj\u0012\u0011!C\u0005\u0005#\u0012\u0001CR5mi\u0016\u0014\u0018N\\4BI\u0006\u0004H/\u001a:\u000b\u0005\u0019:\u0013A\u0002:fgVdGO\u0003\u0002)S\u0005!1.\u001e3v\u0015\tQ3&A\u0004hK>lWm]1\u000b\u00051j\u0013\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"\u0001\u0018\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\ttg\u000f \u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\r\u0005s\u0017PU3g!\tA\u0014(D\u0001&\u0013\tQTEA\tLk\u0012,(+Z:vYR\fE-\u00199uKJ\u0004\"A\r\u001f\n\u0005u\u001a$a\u0002)s_\u0012,8\r\u001e\t\u0003e}J!\u0001Q\u001a\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0007M4G/F\u0001D!\t!5*D\u0001F\u0015\t1u)\u0001\u0004tS6\u0004H.\u001a\u0006\u0003\u0011&\u000bqAZ3biV\u0014XM\u0003\u0002K[\u00059q\u000e]3oO&\u001c\u0018B\u0001'F\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/Z\u0001\u0005g\u001a$\b%A\u0003bkRD7/F\u0001Q!\r\t\u0016\f\u0018\b\u0003%^s!a\u0015,\u000e\u0003QS!!V\u0018\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0014B\u0001-4\u0003\u001d\u0001\u0018mY6bO\u0016L!AW.\u0003\u0007M+\u0017O\u0003\u0002YgA\u0019!'X0\n\u0005y\u001b$!B!se\u0006L\bC\u0001\u001aa\u0013\t\t7G\u0001\u0003CsR,\u0017AB1vi\"\u001c\b%\u0001\u0003fGFdW#A3\u0011\u0005\u0019LW\"A4\u000b\u0005!L\u0015A\u00024jYR,'/\u0003\u0002kO\n1a)\u001b7uKJ\fQ!Z2rY\u0002\na\u0001P5oSRtD\u0003\u00028paF\u0004\"\u0001\u000f\u0001\t\u000b\u0005;\u0001\u0019A\"\t\u000b9;\u0001\u0019\u0001)\t\u000b\r<\u0001\u0019A3\u0002\rM\u001c\u0007.Z7b+\u0005!\bCA;x\u001b\u00051(B\u0001:(\u0013\tAhOA\fLk\u0012,8+[7qY\u00164U-\u0019;ve\u0016\u001c6\r[3nC\u000691o\u00195f[\u0006\u0004S#A>\u0011\u0005Ud\u0018BA?w\u0005Y\u0011vn\u001e*fgVdGoU5na2,g)Z1ukJ,\u0017\u0001\u00034fCR,(/\u001a\u0011\u0002\u000f\r|G.^7ogV\u0011\u00111\u0001\t\u0005#f\u000b)\u0001\u0005\u0003\u0002\b\u0005=a\u0002BA\u0005\u0003\u0017\u0001\"aU\u001a\n\u0007\u000551'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003#\t\u0019B\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u001b\u0019\u0014\u0001C2pYVlgn\u001d\u0011\u0002\u000b\u0005$\u0017\r\u001d;\u0015\t\u0005m\u0011\u0011\u0007\t\u0007\u0003;\t9#a\u000b\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\t!bY8mY\u0016\u001cG/[8o\u0015\r\t)#K\u0001\u0006kRLGn]\u0005\u0005\u0003S\tyBA\tDY>\u001cX-\u00192mK&#XM]1u_J\u00042\u0001RA\u0017\u0013\r\ty#\u0012\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\t\u000f\u0005Mr\u00021\u0001\u00026\u00059!/Z:vYR\u001c\bCBA\u000f\u0003O\t9\u0004\u0005\u0003\u0002:\u0005\u0015SBAA\u001e\u0015\u0011\ti$a\u0010\u0002\r\rd\u0017.\u001a8u\u0015\rA\u0013\u0011\t\u0006\u0004\u0003\u0007j\u0013AB1qC\u000eDW-\u0003\u0003\u0002H\u0005m\"!\u0003*poJ+7/\u001e7u\u0003!!xn\u0015;sS:<GCAA\u0003\u0003\u0011\u0019w\u000e]=\u0015\u000f9\f\t&a\u0015\u0002V!9\u0011)\u0005I\u0001\u0002\u0004\u0019\u0005b\u0002(\u0012!\u0003\u0005\r\u0001\u0015\u0005\bGF\u0001\n\u00111\u0001f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u0017+\u0007\r\u000bif\u000b\u0002\u0002`A!\u0011\u0011MA6\u001b\t\t\u0019G\u0003\u0003\u0002f\u0005\u001d\u0014!C;oG\",7m[3e\u0015\r\tIgM\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA7\u0003G\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\u001d+\u0007A\u000bi&\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005e$fA3\u0002^\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a \u0011\t\u0005\u0005\u00151R\u0007\u0003\u0003\u0007SA!!\"\u0002\b\u0006!A.\u00198h\u0015\t\tI)\u0001\u0003kCZ\f\u0017\u0002BA\t\u0003\u0007\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!%\u0011\u0007I\n\u0019*C\u0002\u0002\u0016N\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a'\u0002\"B\u0019!'!(\n\u0007\u0005}5GA\u0002B]fD\u0011\"a)\u0018\u0003\u0003\u0005\r!!%\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\u000b\u0005\u0004\u0002,\u0006=\u00161T\u0007\u0003\u0003[S1!!\t4\u0013\u0011\t\t,!,\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003o\u000bi\fE\u00023\u0003sK1!a/4\u0005\u001d\u0011un\u001c7fC:D\u0011\"a)\u001a\u0003\u0003\u0005\r!a'\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!%\u0002\r\u0015\fX/\u00197t)\u0011\t9,a2\t\u0013\u0005\r6$!AA\u0002\u0005m\u0015\u0001\u0005$jYR,'/\u001b8h\u0003\u0012\f\u0007\u000f^3s!\tATdE\u0003\u001ec\u0005=g\bE\u0003\u0002R\u0006-hN\u0004\u0003\u0002T\u0006\u001dh\u0002BAk\u0003KtA!a6\u0002d:!\u0011\u0011\\Aq\u001d\u0011\tY.a8\u000f\u0007M\u000bi.C\u0001/\u0013\taS&\u0003\u0002+W%\u0011\u0001&K\u0005\u0003M\u001dJ1!!;&\u0003EYU\u000fZ;SKN,H\u000e^!eCB$XM]\u0005\u0005\u0003[\fyO\u0001\u0010Lk\u0012,(+Z:vYR\fE-\u00199uKJ\u001cVM]5bY&T\u0018\r^5p]*\u0019\u0011\u0011^\u0013\u0015\u0005\u0005-\u0017!C:fe&\fG.\u001b>f)\u0019\t90!@\u0003\u0002A\u0019!'!?\n\u0007\u0005m8G\u0001\u0003V]&$\bBBA\u0000?\u0001\u0007a.A\u0004bI\u0006\u0004H/\u001a:\t\u000f\t\rq\u00041\u0001\u0003\u0006\u0005\u0011!M\u0019\t\u0005\u0005\u000f\u0011IB\u0004\u0003\u0003\n\tMa\u0002\u0002B\u0006\u0005\u001fqA!a6\u0003\u000e%\u0019\u0011QE\u0015\n\t\tE\u00111E\u0001\u0003S>LAA!\u0006\u0003\u0018\u0005Y!)\u001f;f\u0005V4g-\u001a:t\u0015\u0011\u0011\t\"a\t\n\t\tm!Q\u0004\u0002\u0014\u000bb\u0004\u0018M\u001c3j]\u001e\u0014\u0015\u0010^3Ck\u001a4WM\u001d\u0006\u0005\u0005+\u00119\"A\u0006eKN,'/[1mSj,Gc\u00018\u0003$!9!1\u0001\u0011A\u0002\t\u0015\u0002\u0003\u0002B\u0014\u0005[i!A!\u000b\u000b\t\t-\u0012qQ\u0001\u0004]&|\u0017\u0002\u0002B\u0018\u0005S\u0011!BQ=uK\n+hMZ3s\u0003\u0015\t\u0007\u000f\u001d7z)\u001dq'Q\u0007B\u001c\u0005sAQ!Q\u0011A\u0002\rCQAT\u0011A\u0002ACQaY\u0011A\u0002\u0015\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003@\t-\u0003#\u0002\u001a\u0003B\t\u0015\u0013b\u0001B\"g\t1q\n\u001d;j_:\u0004bA\rB$\u0007B+\u0017b\u0001B%g\t1A+\u001e9mKNB\u0001B!\u0014#\u0003\u0003\u0005\rA\\\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u0015\u0011\t\u0005\u0005%QK\u0005\u0005\u0005/\n\u0019I\u0001\u0004PE*,7\r\u001e")
public class FilteringAdapter
implements KuduResultAdapter,
Product,
scala.Serializable {
    private final SimpleFeatureType sft;
    private final Seq<byte[]> auths;
    private final Filter ecql;
    private final KuduSimpleFeatureSchema schema;
    private final RowResultSimpleFeature feature;
    private final Seq<String> columns;

    public static Option<Tuple3<SimpleFeatureType, Seq<byte[]>, Filter>> unapply(FilteringAdapter filteringAdapter) {
        return FilteringAdapter$.MODULE$.unapply(filteringAdapter);
    }

    public static FilteringAdapter apply(SimpleFeatureType simpleFeatureType, Seq<byte[]> seq, Filter filter) {
        return FilteringAdapter$.MODULE$.apply(simpleFeatureType, seq, filter);
    }

    public static FilteringAdapter deserialize(ByteBuffer byteBuffer) {
        return FilteringAdapter$.MODULE$.deserialize(byteBuffer);
    }

    public static void serialize(FilteringAdapter filteringAdapter, ByteBuffers.ExpandingByteBuffer expandingByteBuffer) {
        FilteringAdapter$.MODULE$.serialize(filteringAdapter, expandingByteBuffer);
    }

    public SimpleFeatureType sft() {
        return this.sft;
    }

    public Seq<byte[]> auths() {
        return this.auths;
    }

    public Filter ecql() {
        return this.ecql;
    }

    private KuduSimpleFeatureSchema schema() {
        return this.schema;
    }

    private RowResultSimpleFeature feature() {
        return this.feature;
    }

    @Override
    public Seq<String> columns() {
        return this.columns;
    }

    @Override
    public SimpleFeatureType result() {
        return this.sft();
    }

    @Override
    public CloseableIterator<SimpleFeature> adapt(CloseableIterator<RowResult> results) {
        return results.flatMap((Function1 & Serializable & scala.Serializable)row -> {
            CloseableIterator closeableIterator;
            String vis = KuduIndexColumnAdapter$VisibilityAdapter$.MODULE$.readFromRow((RowResult)row);
            if (vis == null || VisibilityEvaluator$.MODULE$.parse(vis, VisibilityEvaluator$.MODULE$.parse$default$2()).evaluate(this.auths())) {
                this.feature().setRowResult((RowResult)row);
                if (this.ecql().evaluate((Object)this.feature())) {
                    SecurityUtils.setFeatureVisibility((SimpleFeature)this.feature(), (String)vis);
                    closeableIterator = package$.MODULE$.Iterator().single((Object)this.feature());
                    return closeableIterator;
                }
            }
            closeableIterator = CloseableIterator$.MODULE$.empty();
            return closeableIterator;
        });
    }

    public String toString() {
        return new StringBuilder(38).append("FilterAdapter(sft=").append(this.sft().getTypeName()).append("{").append(SimpleFeatureTypes$.MODULE$.encodeType(this.sft())).append("}, ").append("filter=").append(org.locationtech.geomesa.filter.package$.MODULE$.filterToString(this.ecql())).append(", auths=").append(((TraversableOnce)this.auths().map((Function1 & Serializable & scala.Serializable)x$2 -> new String((byte[])x$2, StandardCharsets.UTF_8), Seq$.MODULE$.canBuildFrom())).mkString(",")).append(")").toString();
    }

    public FilteringAdapter copy(SimpleFeatureType sft, Seq<byte[]> auths, Filter ecql) {
        return new FilteringAdapter(sft, auths, ecql);
    }

    public SimpleFeatureType copy$default$1() {
        return this.sft();
    }

    public Seq<byte[]> copy$default$2() {
        return this.auths();
    }

    public Filter copy$default$3() {
        return this.ecql();
    }

    public String productPrefix() {
        return "FilteringAdapter";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Filter filter;
        int n = x$1;
        switch (n) {
            case 0: {
                filter = this.sft();
                break;
            }
            case 1: {
                filter = this.auths();
                break;
            }
            case 2: {
                filter = this.ecql();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return filter;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FilteringAdapter;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FilteringAdapter)) return false;
        boolean bl = true;
        if (!bl) return false;
        FilteringAdapter filteringAdapter = (FilteringAdapter)x$1;
        SimpleFeatureType simpleFeatureType = this.sft();
        SimpleFeatureType simpleFeatureType2 = filteringAdapter.sft();
        if (simpleFeatureType == null) {
            if (simpleFeatureType2 != null) {
                return false;
            }
        } else if (!simpleFeatureType.equals(simpleFeatureType2)) return false;
        Seq<byte[]> seq = this.auths();
        Seq<byte[]> seq2 = filteringAdapter.auths();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Filter filter = this.ecql();
        Filter filter2 = filteringAdapter.ecql();
        if (filter == null) {
            if (filter2 != null) {
                return false;
            }
        } else if (!filter.equals(filter2)) return false;
        if (!filteringAdapter.canEqual(this)) return false;
        return true;
    }

    public FilteringAdapter(SimpleFeatureType sft, Seq<byte[]> auths, Filter ecql) {
        this.sft = sft;
        this.auths = auths;
        this.ecql = ecql;
        Product.$init$((Product)this);
        this.schema = KuduSimpleFeatureSchema$.MODULE$.apply(sft);
        this.feature = new RowResultSimpleFeature(sft, KuduIndexColumnAdapter$FeatureIdAdapter$.MODULE$, this.schema().adapters());
        this.columns = (Seq)((TraversableLike)new .colon.colon((Object)KuduIndexColumnAdapter$FeatureIdAdapter$.MODULE$.name(), (List)new .colon.colon((Object)KuduIndexColumnAdapter$VisibilityAdapter$.MODULE$.name(), (List)Nil$.MODULE$))).$plus$plus((GenTraversableOnce)this.schema().schema().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
    }
}

