/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kudu.data;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kudu.client.KuduClient;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.kudu.data.KuduDataStoreFactory$Params$;
import org.locationtech.geomesa.kudu.package$KuduSystemProperties$;
import org.locationtech.geomesa.utils.geotools.GeoMesaParam;
import scala.Function1;
import scala.Serializable;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class KuduDataStoreFactory$
implements GeoMesaDataStoreFactory.GeoMesaDataStoreInfo,
LazyLogging {
    public static KuduDataStoreFactory$ MODULE$;
    private final String DisplayName;
    private final String Description;
    private final GeoMesaParam<?>[] ParameterInfo;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new KuduDataStoreFactory$();
    }

    private Logger logger$lzycompute() {
        KuduDataStoreFactory$ kuduDataStoreFactory$ = this;
        synchronized (kuduDataStoreFactory$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String DisplayName() {
        return this.DisplayName;
    }

    public String Description() {
        return this.Description;
    }

    public GeoMesaParam<?>[] ParameterInfo() {
        return this.ParameterInfo;
    }

    public boolean canProcess(Map<String, ? extends java.io.Serializable> params) {
        return KuduDataStoreFactory$Params$.MODULE$.KuduMasterParam().exists(params);
    }

    public KuduClient buildClient(Map<String, java.io.Serializable> params) {
        BoxedUnit boxedUnit;
        String master = (String)KuduDataStoreFactory$Params$.MODULE$.KuduMasterParam().lookup(params);
        KuduClient.KuduClientBuilder builder = new KuduClient.KuduClientBuilder(master);
        KuduDataStoreFactory$Params$.MODULE$.WorkerThreadsParam().lookupOpt(params).foreach((Function1 & java.io.Serializable & Serializable)i -> builder.workerCount(i.intValue()));
        KuduDataStoreFactory$Params$.MODULE$.BossThreadsParam().lookupOpt(params).foreach((Function1 & java.io.Serializable & Serializable)i -> builder.bossCount(i.intValue()));
        Object object = KuduDataStoreFactory$Params$.MODULE$.StatisticsParam().lookupOpt(params).exists((Function1 & java.io.Serializable & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4)) ? builder.disableStatistics() : BoxedUnit.UNIT;
        package$KuduSystemProperties$.MODULE$.AdminOperationTimeout().toDuration().foreach((Function1 & java.io.Serializable & Serializable)d -> builder.defaultAdminOperationTimeoutMs(d.toMillis()));
        package$KuduSystemProperties$.MODULE$.OperationTimeout().toDuration().foreach((Function1 & java.io.Serializable & Serializable)d -> builder.defaultOperationTimeoutMs(d.toMillis()));
        package$KuduSystemProperties$.MODULE$.SocketReadTimeout().toDuration().foreach((Function1 & java.io.Serializable & Serializable)d -> builder.defaultSocketReadTimeoutMs(d.toMillis()));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Connecting to Kudu master at: {}", new Object[]{master});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        KuduClient client = builder.build();
        KuduDataStoreFactory$Params$.MODULE$.CredentialsParam().lookupOpt(params).foreach((Function1 & java.io.Serializable & Serializable)creds -> {
            client.importAuthenticationCredentials(creds.getBytes(StandardCharsets.UTF_8));
            return BoxedUnit.UNIT;
        });
        return client;
    }

    private KuduDataStoreFactory$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.DisplayName = "Kudu (GeoMesa)";
        this.Description = "Apache Kudu\u2122 columnar store";
        this.ParameterInfo = (GeoMesaParam[])((Object[])new GeoMesaParam[]{KuduDataStoreFactory$Params$.MODULE$.KuduMasterParam(), KuduDataStoreFactory$Params$.MODULE$.CatalogParam(), KuduDataStoreFactory$Params$.MODULE$.CredentialsParam(), KuduDataStoreFactory$Params$.MODULE$.WorkerThreadsParam(), KuduDataStoreFactory$Params$.MODULE$.BossThreadsParam(), KuduDataStoreFactory$Params$.MODULE$.QueryThreadsParam(), KuduDataStoreFactory$Params$.MODULE$.QueryTimeoutParam(), KuduDataStoreFactory$Params$.MODULE$.AuthsParam(), KuduDataStoreFactory$Params$.MODULE$.LooseBBoxParam(), KuduDataStoreFactory$Params$.MODULE$.AuditQueriesParam(), KuduDataStoreFactory$Params$.MODULE$.GenerateStatsParam(), KuduDataStoreFactory$Params$.MODULE$.StatisticsParam(), KuduDataStoreFactory$Params$.MODULE$.CachingParam(), KuduDataStoreFactory$Params$.MODULE$.PartitionParallelScansParam()});
    }
}

