/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kudu.index;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.PartialRow;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.conf.splitter.DefaultSplitter;
import org.locationtech.geomesa.kudu.index.KuduColumnMapper;
import org.locationtech.geomesa.kudu.index.Z2ColumnMapper$;
import org.locationtech.geomesa.kudu.package;
import org.locationtech.geomesa.kudu.schema.KuduIndexColumnAdapter$FeatureIdAdapter$;
import org.locationtech.geomesa.kudu.schema.KuduIndexColumnAdapter$ZColumnAdapter$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Builder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}t!B\u0006\r\u0011\u00039b!B\r\r\u0011\u0003Q\u0002\"B\u0011\u0002\t\u0003\u0011\u0003bB\u0012\u0002\u0005\u0004%I\u0001\n\u0005\u0007\u0015\u0006\u0001\u000b\u0011B\u0013\u0007\tea\u0001a\u0013\u0005\n\u001b\u0015\u0011\t\u0011)A\u0005\u001f\u0006DQ!I\u0003\u0005\u0002\tDQa[\u0003\u0005B1DQA^\u0003\u0005B]Dq!a\u0012\u0006\t\u0003\nI%\u0001\b[e\r{G.^7o\u001b\u0006\u0004\b/\u001a:\u000b\u00055q\u0011!B5oI\u0016D(BA\b\u0011\u0003\u0011YW\u000fZ;\u000b\u0005E\u0011\u0012aB4f_6,7/\u0019\u0006\u0003'Q\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011!F\u0001\u0004_J<7\u0001\u0001\t\u00031\u0005i\u0011\u0001\u0004\u0002\u000f5J\u001au\u000e\\;n]6\u000b\u0007\u000f]3s'\t\t1\u0004\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\tqaY8mk6t7/F\u0001&!\r1\u0013fK\u0007\u0002O)\u0011\u0001&H\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u0016(\u0005\r\u0019V-\u001d\u0019\u0003YQ\u00022!\f\u00193\u001b\u0005q#BA\u0018\u000f\u0003\u0019\u00198\r[3nC&\u0011\u0011G\f\u0002\u0017\u0017V$W/\u00138eKb\u001cu\u000e\\;n]\u0006#\u0017\r\u001d;feB\u00111\u0007\u000e\u0007\u0001\t%)\u0004!!A\u0001\u0002\u000b\u0005\u0001H\u0001\u0002`c)\u0011qGF\u0001\u0007yI|w\u000e\u001e \u0012\u0005e:%c\u0001\u001e=\t\u001a!1\b\u0001\u0001:\u00051a$/\u001a4j]\u0016lWM\u001c;?!\ti$)D\u0001?\u0015\ty\u0004)\u0001\u0003mC:<'\"A!\u0002\t)\fg/Y\u0005\u0003\u0007z\u0012aa\u0015;sS:<\u0007C\u0001\u000fF\u0013\t1UD\u0001\u0003M_:<\u0007C\u0001\u000fI\u0013\tIUDA\u0002B]f\f\u0001bY8mk6t7\u000fI\n\u0003\u000b1\u0003\"\u0001G'\n\u00059c!\u0001E&vIV\u001cu\u000e\\;n]6\u000b\u0007\u000f]3sa\r\u0001\u0006l\u0018\t\u0005#V;f,D\u0001S\u0015\t\u0019F+A\u0002ba&T!!\u0004\t\n\u0005Y\u0013&aE$f_6+7/\u0019$fCR,(/Z%oI\u0016D\bCA\u001aY\t%If!!A\u0001\u0002\u000b\u0005!LA\u0002`IE\n\"aW$\u0011\u0005qa\u0016BA/\u001e\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aM0\u0005\u0013\u00014\u0011\u0011!A\u0001\u0006\u0003Q&aA0%e%\u0011Q\"\u0014\u000b\u0003G\u0012\u0004\"\u0001G\u0003\t\u000b59\u0001\u0019A31\u0007\u0019D'\u000e\u0005\u0003R+\u001eL\u0007CA\u001ai\t%IF-!A\u0001\u0002\u000b\u0005!\f\u0005\u00024U\u0012I\u0001\rZA\u0001\u0002\u0003\u0015\tAW\u0001\u0014G>tg-[4ve\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0002[B\u0011a\u000e^\u0007\u0002_*\u0011\u0001/]\u0001\u0007G2LWM\u001c;\u000b\u0005=\u0011(BA:\u0015\u0003\u0019\t\u0007/Y2iK&\u0011Qo\u001c\u0002\u0013\u0007J,\u0017\r^3UC\ndWm\u00149uS>t7/A\bde\u0016\fG/Z&fsZ\u000bG.^3t)\rA\u0018q\u0005\t\u0005s~\f\u0019A\u0004\u0002{{:\u00111\u0010`\u0007\u0002m%\ta$\u0003\u0002\u007f;\u00059\u0001/Y2lC\u001e,\u0017b\u0001\u0016\u0002\u0002)\u0011a0\b\u0019\u0005\u0003\u000b\t\u0019\u0003\u0005\u0004\u0002\b\u0005m\u0011\u0011\u0005\b\u0005\u0003\u0013\tIB\u0004\u0003\u0002\f\u0005]a\u0002BA\u0007\u0003+qA!a\u0004\u0002\u00149\u001910!\u0005\n\u0003UI!a\u0005\u000b\n\u0005E\u0011\u0012BA\b\u0011\u0013\tqh\"\u0003\u0003\u0002\u001e\u0005}!!C&vIV4\u0016\r\\;f\u0015\tqh\u0002E\u00024\u0003G!!\"!\n\n\u0003\u0003\u0005\tQ!\u0001[\u0005\ryF\u0005\u000e\u0005\b\u0003SI\u0001\u0019AA\u0016\u0003\u00151\u0018\r\\;fa\u0011\ti#a\u0011\u0011\r\u0005=\u00121HA!\u001d\u0011\t\t$!\u000f\u000f\t\u0005M\u0012q\u0007\b\u0005\u0003\u0017\t)$\u0003\u0002\u000e!%\u00111\u000bV\u0005\u0003}JKA!!\u0010\u0002@\t\t2+\u001b8hY\u0016\u0014vn^&fsZ\u000bG.^3\u000b\u0005y\u0014\u0006cA\u001a\u0002D\u0011Y\u0011QIA\u0014\u0003\u0003\u0005\tQ!\u0001[\u0005\ryFeM\u0001\fi>\u0014vn\u001e*b]\u001e,7\u000f\u0006\u0004\u0002L\u0005}\u00131\u000f\t\u0005s~\fi\u0005E\u0004\u001d\u0003\u001f\n\u0019&a\u0015\n\u0007\u0005ESD\u0001\u0004UkBdWM\r\t\u00069\u0005U\u0013\u0011L\u0005\u0004\u0003/j\"AB(qi&|g\u000eE\u0002o\u00037J1!!\u0018p\u0005)\u0001\u0016M\u001d;jC2\u0014vn\u001e\u0005\b\u0003CR\u0001\u0019AA2\u0003\u0019\u0011\u0018M\\4fgB!\u0011p`A3a\u0011\t9'a\u001c\u0011\r\u0005=\u0012\u0011NA7\u0013\u0011\tY'a\u0010\u0003\u0013M\u001b\u0017M\u001c*b]\u001e,\u0007cA\u001a\u0002p\u0011Y\u0011\u0011OA0\u0003\u0003\u0005\tQ!\u0001[\u0005\ryF%\u000e\u0005\b\u0003kR\u0001\u0019AA<\u0003=!\u0018.\u001a:fI.+\u0017PU1oO\u0016\u001c\b\u0003B=\u0000\u0003s\u0002B!a\f\u0002|%!\u0011QPA \u0005%\u0011\u0015\u0010^3SC:<W\r")
public class Z2ColumnMapper
extends KuduColumnMapper {
    /*
     * WARNING - void declaration
     */
    @Override
    public CreateTableOptions configurePartitions() {
        void var1_1;
        Seq seq;
        CreateTableOptions options = new CreateTableOptions();
        int shards = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getZ2Shards$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(super.index().sft()));
        Object object = shards > 1 ? options.addHashPartitions(Collections.singletonList(KuduIndexColumnAdapter$FeatureIdAdapter$.MODULE$.name()), shards) : BoxedUnit.UNIT;
        options.setRangePartitionColumns(Collections.singletonList(KuduIndexColumnAdapter$ZColumnAdapter$.MODULE$.name()));
        Seq configured = DefaultSplitter.Parser$.MODULE$.z2Splits(this.splitters());
        if (configured.isEmpty()) {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, Long.MAX_VALUE}));
        } else {
            Builder builder = Seq$.MODULE$.newBuilder();
            builder.sizeHint(configured.length() + 2);
            builder.$plus$eq((Object)BoxesRunTime.boxToLong((long)0L));
            builder.$plus$plus$eq((TraversableOnce)configured.sorted((Ordering)Ordering.Long$.MODULE$));
            builder.$plus$eq((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE));
            seq = (Seq)((SeqLike)builder.result()).distinct();
        }
        Seq bitSplits = seq;
        bitSplits.sliding(2).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq seq = x0$1;
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                throw new MatchError((Object)seq);
            }
            long lo = BoxesRunTime.unboxToLong((Object)((SeqLike)some.get()).apply(0));
            long hi = BoxesRunTime.unboxToLong((Object)((SeqLike)some.get()).apply(1));
            PartialRow lower = this.tableSchema().newPartialRow();
            PartialRow upper = this.tableSchema().newPartialRow();
            lower.addLong(0, lo);
            upper.addLong(0, hi);
            CreateTableOptions createTableOptions = options.addRangePartition(lower, upper);
            return createTableOptions;
        });
        return var1_1;
    }

    @Override
    public Seq<package.KuduValue<?>> createKeyValues(package.SingleRowKeyValue<?> value) {
        package.KuduValue<String> fid = new package.KuduValue<String>(new String(value.id(), StandardCharsets.UTF_8), KuduIndexColumnAdapter$FeatureIdAdapter$.MODULE$);
        Object object = value.key();
        if (!(object instanceof Long)) {
            throw new IllegalStateException(new StringBuilder(27).append("Expected z value but got '").append(value.key()).append("'").toString());
        }
        long l = BoxesRunTime.unboxToLong((Object)object);
        Seq seq = (Seq)new .colon.colon(new package.KuduValue<Object>(BoxesRunTime.boxToLong((long)l), KuduIndexColumnAdapter$ZColumnAdapter$.MODULE$), (List)new .colon.colon(fid, (List)Nil$.MODULE$));
        return seq;
    }

    @Override
    public Seq<Tuple2<Option<PartialRow>, Option<PartialRow>>> toRowRanges(Seq<package.ScanRange<?>> ranges, Seq<package.ByteRange> tieredKeyRanges) {
        return (Seq)ranges.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            package.ScanRange scanRange = x0$1;
            if (scanRange instanceof package.BoundedRange) {
                package.BoundedRange boundedRange = (package.BoundedRange)scanRange;
                long lo = boundedRange.lower$mcJ$sp();
                long hi = boundedRange.upper$mcJ$sp();
                tuple2 = new Tuple2((Object)this.lower$1(lo), (Object)this.upper$1(hi));
            } else if (scanRange instanceof package.UnboundedRange) {
                tuple2 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
            } else {
                throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected range type ").append(scanRange).toString());
            }
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private final Some lower$1(long z) {
        PartialRow row = this.tableSchema().newPartialRow();
        KuduIndexColumnAdapter$ZColumnAdapter$.MODULE$.writeToRow(row, z);
        KuduIndexColumnAdapter$FeatureIdAdapter$.MODULE$.writeToRow(row, "");
        return new Some((Object)row);
    }

    private final Some upper$1(long z) {
        PartialRow row = this.tableSchema().newPartialRow();
        KuduIndexColumnAdapter$ZColumnAdapter$.MODULE$.writeToRow(row, z + 1L);
        KuduIndexColumnAdapter$FeatureIdAdapter$.MODULE$.writeToRow(row, "");
        return new Some((Object)row);
    }

    public Z2ColumnMapper(GeoMesaFeatureIndex<?, ?> index) {
        super(index, Z2ColumnMapper$.MODULE$.org$locationtech$geomesa$kudu$index$Z2ColumnMapper$$columns());
    }
}

