/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kudu.tools.ingest;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.util.List;
import org.apache.kudu.client.KuduClient;
import org.locationtech.geomesa.kudu.data.KuduDataStore;
import org.locationtech.geomesa.kudu.tools.KuduDataStoreCommand;
import org.locationtech.geomesa.kudu.tools.KuduDataStoreCommand$KuduParams$class;
import org.locationtech.geomesa.kudu.tools.KuduDataStoreCommand$class;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.DataStoreCommand;
import org.locationtech.geomesa.tools.DistributedRunParam;
import org.locationtech.geomesa.tools.InputFilesParam;
import org.locationtech.geomesa.tools.InputFormatParam;
import org.locationtech.geomesa.tools.InteractiveCommand;
import org.locationtech.geomesa.tools.OptionalConverterConfigParam;
import org.locationtech.geomesa.tools.OptionalFeatureSpecParam;
import org.locationtech.geomesa.tools.OptionalForceParam;
import org.locationtech.geomesa.tools.OptionalInputFormatParam;
import org.locationtech.geomesa.tools.OptionalTypeNameParam;
import org.locationtech.geomesa.tools.PasswordParams;
import org.locationtech.geomesa.tools.ingest.IngestCommand;
import org.locationtech.geomesa.tools.ingest.IngestParams;
import org.locationtech.geomesa.utils.classpath.ClassPathUtils$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\u0001\u0003\u0001=\u0011\u0011cS;ek&sw-Z:u\u0007>lW.\u00198e\u0015\t\u0019A!\u0001\u0004j]\u001e,7\u000f\u001e\u0006\u0003\u000b\u0019\tQ\u0001^8pYNT!a\u0002\u0005\u0002\t-,H-\u001e\u0006\u0003\u0013)\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\f\u0019\u0005aAn\\2bi&|g\u000e^3dQ*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001!Y\u0011\u0003CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\rE\u0002\u00185qi\u0011\u0001\u0007\u0006\u0003\u0007eQ!!\u0002\u0005\n\u0005mA\"!D%oO\u0016\u001cHoQ8n[\u0006tG\r\u0005\u0002\u001eA5\taD\u0003\u0002 \r\u0005!A-\u0019;b\u0013\t\tcDA\u0007Lk\u0012,H)\u0019;b'R|'/\u001a\t\u0003G\u0011j\u0011\u0001B\u0005\u0003K\u0011\u0011AcS;ek\u0012\u000bG/Y*u_J,7i\\7nC:$\u0007\"B\u0014\u0001\t\u0003A\u0013A\u0002\u001fj]&$h\bF\u0001*!\tQ\u0003!D\u0001\u0003\u0011\u001da\u0003A1A\u0005B5\na\u0001]1sC6\u001cX#\u0001\u0018\u0011\u0005=2eB\u0001\u0019@\u001d\t\tdH\u0004\u00023{9\u00111\u0007\u0010\b\u0003imr!!\u000e\u001e\u000f\u0005YJT\"A\u001c\u000b\u0005ar\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!a\u0001\u0003\b\u000b\u0001\u0013\u0001\u0012A!\u0002#-+H-^%oO\u0016\u001cHoQ8n[\u0006tG\r\u0005\u0002+\u0005\u001a)\u0011A\u0001E\u0001\u0007N\u0011!\t\u0005\u0005\u0006O\t#\t!\u0012\u000b\u0002\u0003\u001a!qI\u0011\u0001I\u0005AYU\u000fZ;J]\u001e,7\u000f\u001e)be\u0006l7o\u0005\u0003G!%c\u0005CA\fK\u0013\tY\u0005D\u0001\u0007J]\u001e,7\u000f\u001e)be\u0006l7\u000f\u0005\u0002N!:\u0011\u0011GT\u0005\u0003\u001f\u0012\tAcS;ek\u0012\u000bG/Y*u_J,7i\\7nC:$\u0017BA)S\u0005)YU\u000fZ;QCJ\fWn\u001d\u0006\u0003\u001f\u0012AQa\n$\u0005\u0002Q#\u0012!\u0016\t\u0003-\u001ak\u0011A\u0011\u0015\u0005\rb\u00137\r\u0005\u0002ZA6\t!L\u0003\u0002\\9\u0006Q!nY8n[\u0006tG-\u001a:\u000b\u0005us\u0016!\u00022fkN$(\"A0\u0002\u0007\r|W.\u0003\u0002b5\nQ\u0001+\u0019:b[\u0016$XM]:\u0002%\r|W.\\1oI\u0012+7o\u0019:jaRLwN\\\u0011\u0002I\u0006\u0001\u0014J\\4fgR|3m\u001c8wKJ$\bE^1sS>,8\u000f\t4jY\u0016\u0004cm\u001c:nCR\u001c\b%\u001b8u_\u0002:Um\\'fg\u0006DaA\u001a\u0001!\u0002\u0013q\u0013a\u00029be\u0006l7\u000f\t\u0005\bQ\u0002\u0011\r\u0011\"\u0011j\u0003-a\u0017N\u00196beN4\u0015\u000e\\3\u0016\u0003)\u0004\"a\u001b8\u000f\u0005Ea\u0017BA7\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011q\u000e\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u00055\u0014\u0002B\u0002:\u0001A\u0003%!.\u0001\u0007mS\nT\u0017M]:GS2,\u0007\u0005C\u0003u\u0001\u0011\u0005S/\u0001\u0007mS\nT\u0017M]:QCRD7/F\u0001w!\r9Hp \b\u0003qjt!AN=\n\u0003MI!a\u001f\n\u0002\u000fA\f7m[1hK&\u0011QP \u0002\t\u0013R,'/\u0019;pe*\u00111P\u0005\t\u0006#\u0005\u0005\u0011QA\u0005\u0004\u0003\u0007\u0011\"!\u0003$v]\u000e$\u0018n\u001c81!\u00159\u0018qAA\u0006\u0013\r\tIA \u0002\u0004'\u0016\f\b\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\u0003S>T!!!\u0006\u0002\t)\fg/Y\u0005\u0005\u00033\tyA\u0001\u0003GS2,\u0007")
public class KuduIngestCommand
implements IngestCommand<KuduDataStore>,
KuduDataStoreCommand {
    private final KuduIngestParams params;
    private final String libjarsFile;
    private final String name;
    private final Logger logger;
    private Object org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    private volatile boolean bitmap$0;

    @Override
    public Map<String, String> connection() {
        return KuduDataStoreCommand$class.connection(this);
    }

    public String name() {
        return this.name;
    }

    public void org$locationtech$geomesa$tools$ingest$IngestCommand$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    public void execute() {
        IngestCommand.class.execute((IngestCommand)this);
    }

    public Runnable createConverterIngest(SimpleFeatureType sft, Config converterConfig, Seq<String> ingestFiles) {
        return IngestCommand.class.createConverterIngest((IngestCommand)this, (SimpleFeatureType)sft, (Config)converterConfig, ingestFiles);
    }

    private Logger logger$lzycompute() {
        KuduIngestCommand kuduIngestCommand = this;
        synchronized (kuduIngestCommand) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Object org$locationtech$geomesa$tools$InteractiveCommand$$_console() {
        return this.org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    }

    public void org$locationtech$geomesa$tools$InteractiveCommand$$_console_$eq(Object x$1) {
        this.org$locationtech$geomesa$tools$InteractiveCommand$$_console = x$1;
    }

    public Object console() {
        return InteractiveCommand.class.console((InteractiveCommand)this);
    }

    public void setConsole(Object c) {
        InteractiveCommand.class.setConsole((InteractiveCommand)this, (Object)c);
    }

    public <T> T withDataStore(Function1<KuduDataStore, T> method) throws ParameterException {
        return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
    }

    @Override
    public KuduIngestParams params() {
        return this.params;
    }

    public String libjarsFile() {
        return this.libjarsFile;
    }

    public Iterator<Function0<Seq<File>>> libjarsPaths() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<File> apply() {
                return ClassPathUtils$.MODULE$.getJarsFromEnvironment("GEOMESA_KUDU_HOME");
            }
        }, new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<File> apply() {
                return ClassPathUtils$.MODULE$.getJarsFromClasspath(KuduDataStore.class);
            }
        }, new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<File> apply() {
                return ClassPathUtils$.MODULE$.getJarsFromClasspath(KuduClient.class);
            }
        }}));
    }

    public KuduIngestCommand() {
        DataStoreCommand.class.$init$((DataStoreCommand)this);
        InteractiveCommand.class.$init$((InteractiveCommand)this);
        LazyLogging.class.$init$((LazyLogging)this);
        IngestCommand.class.$init$((IngestCommand)this);
        KuduDataStoreCommand$class.$init$(this);
        this.params = new KuduIngestParams();
        this.libjarsFile = "org/locationtech/geomesa/kudu/tools/ingest-libjars.list";
    }

    @Parameters(commandDescription="Ingest/convert various file formats into GeoMesa")
    public static class KuduIngestParams
    implements IngestParams,
    KuduDataStoreCommand.KuduParams {
        @Parameter(names={"-M", "--master"}, description="Kudu master server", required=true)
        private String master;
        @Parameter(names={"--boss-threads"}, description="Kudu client boss threads")
        private Integer bosses;
        @Parameter(names={"--worker-threads"}, description="Kudu client worker threads")
        private Integer workers;
        @Parameter(names={"--disable-statistics"}, description="Disable Kudu client statistics", arity=0)
        private Boolean statistics;
        @Parameter(names={"-p", "--password"}, description="Connection password")
        private String password;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"-t", "--threads"}, description="Number of threads if using local ingest")
        private Integer threads;
        @Parameter(names={"--split-max-size"}, description="Maximum size of a split in bytes (distributed jobs)")
        private Integer maxSplitSize;
        @Parameter(names={"--src-list"}, description="Input files are text files with lists of files, one per line, to ingest.")
        private boolean srcList;
        @Parameter(names={"--no-tracking"}, description="This application closes when ingest job is submitted. Useful for launching jobs with a script.")
        private boolean noWaitForCompletion;
        @Parameter(names={"--run-mode"}, description="Run locally or on a cluster", required=false, converter=DistributedRunParam.ModeConverter.class)
        private Enumeration.Value mode;
        @Parameter(names={"--input-format"}, description="File format of input files (shp, csv, tsv, avro, etc). Optional, autodetection will be attempted.")
        private String format;
        @Parameter(description="<file>...")
        private List<String> files;
        @Parameter(names={"-C", "--converter"}, description="GeoMesa converter specification as a config string, file name, or name of an available converter", required=false)
        private String config;
        @Parameter(names={"--force"}, description="Force execution without prompt")
        private boolean force;
        @Parameter(names={"-s", "--spec"}, description="SimpleFeatureType specification as a GeoTools spec string, SFT config, or file with either")
        private String spec;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate")
        private String featureName;

        @Override
        public String master() {
            return this.master;
        }

        @Override
        @TraitSetter
        public void master_$eq(String x$1) {
            this.master = x$1;
        }

        @Override
        public Integer bosses() {
            return this.bosses;
        }

        @Override
        @TraitSetter
        public void bosses_$eq(Integer x$1) {
            this.bosses = x$1;
        }

        @Override
        public Integer workers() {
            return this.workers;
        }

        @Override
        @TraitSetter
        public void workers_$eq(Integer x$1) {
            this.workers = x$1;
        }

        @Override
        public Boolean statistics() {
            return this.statistics;
        }

        @Override
        @TraitSetter
        public void statistics_$eq(Boolean x$1) {
            this.statistics = x$1;
        }

        public String password() {
            return this.password;
        }

        public void password_$eq(String x$1) {
            this.password = x$1;
        }

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        public Integer threads() {
            return this.threads;
        }

        public void threads_$eq(Integer x$1) {
            this.threads = x$1;
        }

        public Integer maxSplitSize() {
            return this.maxSplitSize;
        }

        public void maxSplitSize_$eq(Integer x$1) {
            this.maxSplitSize = x$1;
        }

        public boolean srcList() {
            return this.srcList;
        }

        public void srcList_$eq(boolean x$1) {
            this.srcList = x$1;
        }

        public boolean noWaitForCompletion() {
            return this.noWaitForCompletion;
        }

        public void noWaitForCompletion_$eq(boolean x$1) {
            this.noWaitForCompletion = x$1;
        }

        public boolean waitForCompletion() {
            return IngestParams.class.waitForCompletion((IngestParams)this);
        }

        public Enumeration.Value mode() {
            return this.mode;
        }

        public void mode_$eq(Enumeration.Value x$1) {
            this.mode = x$1;
        }

        public String format() {
            return this.format;
        }

        public void format_$eq(String x$1) {
            this.format = x$1;
        }

        public Enumeration.Value fmt() {
            return InputFormatParam.class.fmt((InputFormatParam)this);
        }

        public List<String> files() {
            return this.files;
        }

        public void files_$eq(List<String> x$1) {
            this.files = x$1;
        }

        public String config() {
            return this.config;
        }

        public void config_$eq(String x$1) {
            this.config = x$1;
        }

        public boolean force() {
            return this.force;
        }

        public void force_$eq(boolean x$1) {
            this.force = x$1;
        }

        public String spec() {
            return this.spec;
        }

        public void spec_$eq(String x$1) {
            this.spec = x$1;
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        public KuduIngestParams() {
            OptionalTypeNameParam.class.$init$((OptionalTypeNameParam)this);
            OptionalFeatureSpecParam.class.$init$((OptionalFeatureSpecParam)this);
            OptionalForceParam.class.$init$((OptionalForceParam)this);
            OptionalConverterConfigParam.class.$init$((OptionalConverterConfigParam)this);
            InputFilesParam.class.$init$((InputFilesParam)this);
            InputFormatParam.class.$init$((InputFormatParam)this);
            OptionalInputFormatParam.class.$init$((OptionalInputFormatParam)this);
            DistributedRunParam.class.$init$((DistributedRunParam)this);
            IngestParams.class.$init$((IngestParams)this);
            CatalogParam.class.$init$((CatalogParam)this);
            PasswordParams.class.$init$((PasswordParams)this);
            KuduDataStoreCommand$KuduParams$class.$init$(this);
        }
    }
}

