/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kudu.tools.export;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.List;
import java.util.Map;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.kudu.data.KuduDataStore;
import org.locationtech.geomesa.kudu.tools.KuduDataStoreCommand;
import org.locationtech.geomesa.kudu.tools.KuduDataStoreCommand$KuduParams$class;
import org.locationtech.geomesa.kudu.tools.KuduDataStoreCommand$class;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.DataStoreCommand;
import org.locationtech.geomesa.tools.OptionalCqlFilterParam;
import org.locationtech.geomesa.tools.OptionalIndexParam;
import org.locationtech.geomesa.tools.PasswordParams;
import org.locationtech.geomesa.tools.QueryHintsParams;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001Y4A!\u0001\u0002\u0001\u001f\t\t2*\u001e3v\u000bb\u0004xN\u001d;D_6l\u0017M\u001c3\u000b\u0005\r!\u0011AB3ya>\u0014HO\u0003\u0002\u0006\r\u0005)Ao\\8mg*\u0011q\u0001C\u0001\u0005WV$WO\u0003\u0002\n\u0015\u00059q-Z8nKN\f'BA\u0006\r\u00031awnY1uS>tG/Z2i\u0015\u0005i\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u0011-\t\u0002\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007cA\f\u001b95\t\u0001D\u0003\u0002\u00043)\u0011Q\u0001C\u0005\u00037a\u0011Q\"\u0012=q_J$8i\\7nC:$\u0007CA\u000f!\u001b\u0005q\"BA\u0010\u0007\u0003\u0011!\u0017\r^1\n\u0005\u0005r\"!D&vIV$\u0015\r^1Ti>\u0014X\r\u0005\u0002$I5\tA!\u0003\u0002&\t\t!2*\u001e3v\t\u0006$\u0018m\u0015;pe\u0016\u001cu.\\7b]\u0012DQa\n\u0001\u0005\u0002!\na\u0001P5oSRtD#A\u0015\u0011\u0005)\u0002Q\"\u0001\u0002\t\u000f1\u0002!\u0019!C![\u00051\u0001/\u0019:b[N,\u0012A\f\t\u0003_\u0019s!\u0001M \u000f\u0005ErdB\u0001\u001a>\u001d\t\u0019DH\u0004\u00025w9\u0011QG\u000f\b\u0003mej\u0011a\u000e\u0006\u0003q9\ta\u0001\u0010:p_Rt\u0014\"A\u0007\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u00111\u0001B\u0004\u0006\u0001\nA\t!Q\u0001\u0012\u0017V$W/\u0012=q_J$8i\\7nC:$\u0007C\u0001\u0016C\r\u0015\t!\u0001#\u0001D'\t\u0011\u0005\u0003C\u0003(\u0005\u0012\u0005Q\tF\u0001B\r\u00119%\t\u0001%\u0003!-+H-^#ya>\u0014H\u000fU1sC6\u001c8C\u0002$\u0011\u0013R[v\f\u0005\u0002K#:\u00111j\u0014\b\u0003\u0019:s!aM'\n\u0005\u0015A\u0011BA\u0002\u001a\u0013\t\u0001\u0006$A\u0007FqB|'\u000f^\"p[6\fg\u000eZ\u0005\u0003%N\u0013A\"\u0012=q_J$\b+\u0019:b[NT!\u0001\u0015\r\u0011\u0005UCfBA\u0019W\u0013\t9F!\u0001\u000bLk\u0012,H)\u0019;b'R|'/Z\"p[6\fg\u000eZ\u0005\u00033j\u0013!bS;ekB\u000b'/Y7t\u0015\t9F\u0001\u0005\u0002];6\t\u0011$\u0003\u0002_3\t)\"+Z9vSJ,G\rV=qK:\u000bW.\u001a)be\u0006l\u0007C\u0001/a\u0013\t\t\u0017D\u0001\nPaRLwN\\1m\u0013:$W\r\u001f)be\u0006l\u0007\"B\u0014G\t\u0003\u0019G#\u00013\u0011\u0005\u00154U\"\u0001\")\t\u0019;\u0017O\u001d\t\u0003Q>l\u0011!\u001b\u0006\u0003U.\f!B[2p[6\fg\u000eZ3s\u0015\taW.A\u0003cKV\u001cHOC\u0001o\u0003\r\u0019w.\\\u0005\u0003a&\u0014!\u0002U1sC6,G/\u001a:t\u0003I\u0019w.\\7b]\u0012$Um]2sSB$\u0018n\u001c8\"\u0003M\f\u0011&\u0012=q_J$\bEZ3biV\u0014Xm\u001d\u0011ge>l\u0007%\u0019\u0011HK>lUm]1!I\u0006$\u0018\rI:u_J,\u0007BB;\u0001A\u0003%a&A\u0004qCJ\fWn\u001d\u0011")
public class KuduExportCommand
implements ExportCommand<KuduDataStore>,
KuduDataStoreCommand {
    private final KuduExportParams params;
    private final String name;
    private final Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public scala.collection.immutable.Map<String, String> connection() {
        return KuduDataStoreCommand$class.connection(this);
    }

    public String name() {
        return this.name;
    }

    public void org$locationtech$geomesa$tools$export$ExportCommand$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    public void execute() {
        ExportCommand.class.execute((ExportCommand)this);
    }

    public Option export(DataStore ds) {
        return ExportCommand.class.export((ExportCommand)this, (DataStore)ds);
    }

    public Option<Object> export(FeatureExporter exporter, SimpleFeatureCollection collection) {
        return ExportCommand.class.export((ExportCommand)this, (FeatureExporter)exporter, (SimpleFeatureCollection)collection);
    }

    public SimpleFeatureType getSchema(DataStore ds) {
        return ExportCommand.class.getSchema((ExportCommand)this, (DataStore)ds);
    }

    public SimpleFeatureCollection getFeatures(DataStore ds, Query query) {
        return ExportCommand.class.getFeatures((ExportCommand)this, (DataStore)ds, (Query)query);
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, (String)message, code);
    }

    private Logger logger$lzycompute() {
        KuduExportCommand kuduExportCommand = this;
        synchronized (kuduExportCommand) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public <T> T withDataStore(Function1<KuduDataStore, T> method) throws ParameterException {
        return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return DataStoreCommand.class.loadDataStore((DataStoreCommand)this);
    }

    @Override
    public KuduExportParams params() {
        return this.params;
    }

    public KuduExportCommand() {
        DataStoreCommand.class.$init$((DataStoreCommand)this);
        LazyLogging.class.$init$((LazyLogging)this);
        MethodProfiling.class.$init$((MethodProfiling)this);
        ExportCommand.class.$init$((ExportCommand)this);
        KuduDataStoreCommand$class.$init$(this);
        this.params = new KuduExportParams();
    }

    @Parameters(commandDescription="Export features from a GeoMesa data store")
    public static class KuduExportParams
    implements ExportCommand.ExportParams,
    KuduDataStoreCommand.KuduParams,
    RequiredTypeNameParam,
    OptionalIndexParam {
        @Parameter(names={"--index"}, description="Specify a particular GeoMesa index", required=false)
        private String index;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"-M", "--master"}, description="Kudu master server", required=true)
        private String master;
        @Parameter(names={"--boss-threads"}, description="Kudu client boss threads")
        private Integer bosses;
        @Parameter(names={"--worker-threads"}, description="Kudu client worker threads")
        private Integer workers;
        @Parameter(names={"--disable-statistics"}, description="Disable Kudu client statistics", arity=0)
        private Boolean statistics;
        @Parameter(names={"-p", "--password"}, description="Connection password")
        private String password;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"-o", "--output"}, description="Output to a file instead of std out")
        private String file;
        @Parameter(names={"--gzip"}, description="Level of gzip compression to apply to output, from 1-9")
        private Integer gzip;
        @Parameter(names={"-F", "--output-format"}, description="File format of output files (csv|tsv|gml|json|shp|avro|leaflet|orc|parquet|arrow)", required=false, converter=ParameterConverters.ExportFormatConverter.class)
        private Enumeration.Value outputFormat;
        @Parameter(names={"--no-header"}, description="Export as a delimited text format (csv|tsv) without a type header", required=false)
        private boolean noHeader;
        @Parameter(names={"-m", "--max-features"}, description="Maximum number of features to return. default: Unlimited")
        private Integer maxFeatures;
        @Parameter(names={"-a", "--attributes"}, description="Attributes from feature to export (comma-separated)...Comma-separated expressions with each in the format attribute[=filter_function_expression]|derived-attribute=filter_function_expression|'id'. 'id' will export the feature ID, filter_function_expression is an expression of filter function applied to attributes, literals and filter functions, i.e. can be nested")
        private List<String> attributes;
        @Parameter(names={"--hints"}, description="Query hints to set, in the form key1=value1;key2=value2", required=false, converter=ParameterConverters.HintConverter.class)
        private Map<String, String> hints;
        @Parameter(names={"-q", "--cql"}, description="CQL predicate", converter=ParameterConverters.FilterConverter.class)
        private Filter cqlFilter;

        public String index() {
            return this.index;
        }

        public void index_$eq(String x$1) {
            this.index = x$1;
        }

        public <DS extends GeoMesaDataStore<DS>> Option<GeoMesaFeatureIndex<?, ?>> loadIndex(DS ds, String typeName, IndexMode.IndexMode mode) throws ParameterException {
            return OptionalIndexParam.class.loadIndex((OptionalIndexParam)this, ds, (String)typeName, (IndexMode.IndexMode)mode);
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        @Override
        public String master() {
            return this.master;
        }

        @Override
        @TraitSetter
        public void master_$eq(String x$1) {
            this.master = x$1;
        }

        @Override
        public Integer bosses() {
            return this.bosses;
        }

        @Override
        @TraitSetter
        public void bosses_$eq(Integer x$1) {
            this.bosses = x$1;
        }

        @Override
        public Integer workers() {
            return this.workers;
        }

        @Override
        @TraitSetter
        public void workers_$eq(Integer x$1) {
            this.workers = x$1;
        }

        @Override
        public Boolean statistics() {
            return this.statistics;
        }

        @Override
        @TraitSetter
        public void statistics_$eq(Boolean x$1) {
            this.statistics = x$1;
        }

        public String password() {
            return this.password;
        }

        public void password_$eq(String x$1) {
            this.password = x$1;
        }

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        public String file() {
            return this.file;
        }

        public void file_$eq(String x$1) {
            this.file = x$1;
        }

        public Integer gzip() {
            return this.gzip;
        }

        public void gzip_$eq(Integer x$1) {
            this.gzip = x$1;
        }

        public Enumeration.Value outputFormat() {
            return this.outputFormat;
        }

        public void outputFormat_$eq(Enumeration.Value x$1) {
            this.outputFormat = x$1;
        }

        public boolean noHeader() {
            return this.noHeader;
        }

        public void noHeader_$eq(boolean x$1) {
            this.noHeader = x$1;
        }

        public Integer maxFeatures() {
            return this.maxFeatures;
        }

        public void maxFeatures_$eq(Integer x$1) {
            this.maxFeatures = x$1;
        }

        public List<String> attributes() {
            return this.attributes;
        }

        public void attributes_$eq(List<String> x$1) {
            this.attributes = x$1;
        }

        public Map<String, String> hints() {
            return this.hints;
        }

        public void hints_$eq(Map<String, String> x$1) {
            this.hints = x$1;
        }

        public Filter cqlFilter() {
            return this.cqlFilter;
        }

        public void cqlFilter_$eq(Filter x$1) {
            this.cqlFilter = x$1;
        }

        public KuduExportParams() {
            OptionalCqlFilterParam.class.$init$((OptionalCqlFilterParam)this);
            QueryHintsParams.class.$init$((QueryHintsParams)this);
            ExportCommand.ExportParams.class.$init$((ExportCommand.ExportParams)this);
            CatalogParam.class.$init$((CatalogParam)this);
            PasswordParams.class.$init$((PasswordParams)this);
            KuduDataStoreCommand$KuduParams$class.$init$(this);
            RequiredTypeNameParam.class.$init$((RequiredTypeNameParam)this);
            OptionalIndexParam.class.$init$((OptionalIndexParam)this);
        }
    }
}

