/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kudu.tools.export;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.validators.PositiveInteger;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.mapreduce.Job;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.kudu.data.KuduDataStore;
import org.locationtech.geomesa.kudu.tools.KuduDataStoreCommand;
import org.locationtech.geomesa.kudu.tools.KuduDataStoreCommand$KuduDistributedCommand$class;
import org.locationtech.geomesa.kudu.tools.KuduDataStoreCommand$KuduParams$class;
import org.locationtech.geomesa.kudu.tools.KuduDataStoreCommand$class;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.DataStoreCommand;
import org.locationtech.geomesa.tools.DistributedCommand;
import org.locationtech.geomesa.tools.DistributedRunParam;
import org.locationtech.geomesa.tools.InteractiveCommand;
import org.locationtech.geomesa.tools.OptionalCqlFilterParam;
import org.locationtech.geomesa.tools.OptionalForceParam;
import org.locationtech.geomesa.tools.OptionalIndexParam;
import org.locationtech.geomesa.tools.PasswordParams;
import org.locationtech.geomesa.tools.QueryHintsParams;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.formats.ExportFormat;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.tools.utils.NoopParameterSplitter;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.opengis.filter.Filter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001\u001f\t\t2*\u001e3v\u000bb\u0004xN\u001d;D_6l\u0017M\u001c3\u000b\u0005\r!\u0011AB3ya>\u0014HO\u0003\u0002\u0006\r\u0005)Ao\\8mg*\u0011q\u0001C\u0001\u0005WV$WO\u0003\u0002\n\u0015\u00059q-Z8nKN\f'BA\u0006\r\u00031awnY1uS>tG/Z2i\u0015\u0005i\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u0011-\t\u0002\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007cA\f\u001b95\t\u0001D\u0003\u0002\u00043)\u0011Q\u0001C\u0005\u00037a\u0011Q\"\u0012=q_J$8i\\7nC:$\u0007CA\u000f!\u001b\u0005q\"BA\u0010\u0007\u0003\u0011!\u0017\r^1\n\u0005\u0005r\"!D&vIV$\u0015\r^1Ti>\u0014X\r\u0005\u0002$g9\u0011A%\r\b\u0003KAr!AJ\u0018\u000f\u0005\u001drcB\u0001\u0015.\u001d\tIC&D\u0001+\u0015\tYc\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011B\u0001\u001a\u0005\u0003QYU\u000fZ;ECR\f7\u000b^8sK\u000e{W.\\1oI&\u0011A'\u000e\u0002\u0017\u0017V$W\u000fR5tiJL'-\u001e;fI\u000e{W.\\1oI*\u0011!\u0007\u0002\u0005\u0006o\u0001!\t\u0001O\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0002\"A\u000f\u0001\u000e\u0003\tAq\u0001\u0010\u0001C\u0002\u0013\u0005S(\u0001\u0004qCJ\fWn]\u000b\u0002}A\u0011q(\u0013\b\u0003\u0001\ns!\u0001J!\n\u0005\r!q!B\"\u0003\u0011\u0003!\u0015!E&vIV,\u0005\u0010]8si\u000e{W.\\1oIB\u0011!(\u0012\u0004\u0006\u0003\tA\tAR\n\u0003\u000bBAQaN#\u0005\u0002!#\u0012\u0001\u0012\u0004\u0005\u0015\u0016\u00031J\u0001\tLk\u0012,X\t\u001f9peR\u0004\u0016M]1ngN1\u0011\n\u0005'X5z\u0003\"!\u0014+\u000f\u00059\u0013fBA(R\u001d\t1\u0003+\u0003\u0002\u0006\u0011%\u00111!G\u0005\u0003'b\tQ\"\u0012=q_J$8i\\7nC:$\u0017BA+W\u00051)\u0005\u0010]8siB\u000b'/Y7t\u0015\t\u0019\u0006\u0004\u0005\u0002$1&\u0011\u0011,\u000e\u0002\u000b\u0017V$W\u000fU1sC6\u001c\bCA.]\u001b\u0005I\u0012BA/\u001a\u0005U\u0011V-];je\u0016$G+\u001f9f\u001d\u0006lW\rU1sC6\u0004\"aW0\n\u0005\u0001L\"AE(qi&|g.\u00197J]\u0012,\u0007\u0010U1sC6DQaN%\u0005\u0002\t$\u0012a\u0019\t\u0003I&k\u0011!\u0012\u0015\u0005\u0013\u001a\u0004\u0018\u000f\u0005\u0002h]6\t\u0001N\u0003\u0002jU\u0006Q!nY8n[\u0006tG-\u001a:\u000b\u0005-d\u0017!\u00022fkN$(\"A7\u0002\u0007\r|W.\u0003\u0002pQ\nQ\u0001+\u0019:b[\u0016$XM]:\u0002%\r|W.\\1oI\u0012+7o\u0019:jaRLwN\\\u0011\u0002e\u0006IS\t\u001f9peR\u0004c-Z1ukJ,7\u000f\t4s_6\u0004\u0013\rI$f_6+7/\u0019\u0011eCR\f\u0007e\u001d;pe\u0016Da\u0001\u001e\u0001!\u0002\u0013q\u0014a\u00029be\u0006l7\u000f\t")
public class KuduExportCommand
implements ExportCommand<KuduDataStore>,
KuduDataStoreCommand.KuduDistributedCommand {
    private final KuduExportParams params;
    private final String name;
    private final Logger logger;
    private Object org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ Seq org$locationtech$geomesa$kudu$tools$KuduDataStoreCommand$KuduDistributedCommand$$super$libjarsFiles() {
        return ExportCommand.class.libjarsFiles((ExportCommand)this);
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$kudu$tools$KuduDataStoreCommand$KuduDistributedCommand$$super$libjarsPaths() {
        return DistributedCommand.class.libjarsPaths((DistributedCommand)this);
    }

    @Override
    public Seq<String> libjarsFiles() {
        return KuduDataStoreCommand$KuduDistributedCommand$class.libjarsFiles(this);
    }

    @Override
    public Iterator<Function0<Seq<File>>> libjarsPaths() {
        return KuduDataStoreCommand$KuduDistributedCommand$class.libjarsPaths(this);
    }

    @Override
    public scala.collection.immutable.Map<String, String> connection() {
        return KuduDataStoreCommand$class.connection(this);
    }

    public String name() {
        return this.name;
    }

    public void org$locationtech$geomesa$tools$export$ExportCommand$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    public void execute() {
        ExportCommand.class.execute((ExportCommand)this);
    }

    public Option export(DataStore ds, Query query, FeatureExporter exporter) {
        return ExportCommand.class.export((ExportCommand)this, (DataStore)ds, (Query)query, (FeatureExporter)exporter);
    }

    public void configure(Job job, DataStore ds, Query query) {
        ExportCommand.class.configure((ExportCommand)this, (Job)job, (DataStore)ds, (Query)query);
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, (String)message, code);
    }

    private Logger logger$lzycompute() {
        KuduExportCommand kuduExportCommand = this;
        synchronized (kuduExportCommand) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Object org$locationtech$geomesa$tools$InteractiveCommand$$_console() {
        return this.org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    }

    public void org$locationtech$geomesa$tools$InteractiveCommand$$_console_$eq(Object x$1) {
        this.org$locationtech$geomesa$tools$InteractiveCommand$$_console = x$1;
    }

    public Object console() {
        return InteractiveCommand.class.console((InteractiveCommand)this);
    }

    public void setConsole(Object c) {
        InteractiveCommand.class.setConsole((InteractiveCommand)this, (Object)c);
    }

    public <T> T withDataStore(Function1<KuduDataStore, T> method) throws ParameterException {
        return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return DataStoreCommand.class.loadDataStore((DataStoreCommand)this);
    }

    @Override
    public KuduExportParams params() {
        return this.params;
    }

    public KuduExportCommand() {
        DataStoreCommand.class.$init$((DataStoreCommand)this);
        DistributedCommand.class.$init$((DistributedCommand)this);
        InteractiveCommand.class.$init$((InteractiveCommand)this);
        LazyLogging.class.$init$((LazyLogging)this);
        MethodProfiling.class.$init$((MethodProfiling)this);
        ExportCommand.class.$init$((ExportCommand)this);
        KuduDataStoreCommand$class.$init$(this);
        KuduDataStoreCommand$KuduDistributedCommand$class.$init$(this);
        this.params = new KuduExportParams();
    }

    @Parameters(commandDescription="Export features from a GeoMesa data store")
    public static class KuduExportParams
    implements ExportCommand.ExportParams,
    KuduDataStoreCommand.KuduParams,
    RequiredTypeNameParam,
    OptionalIndexParam {
        @Parameter(names={"--index"}, description="Specify a particular GeoMesa index", required=false)
        private String index;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"-M", "--master"}, description="Kudu master server", required=true)
        private String master;
        @Parameter(names={"--boss-threads"}, description="Kudu client boss threads")
        private Integer bosses;
        @Parameter(names={"--worker-threads"}, description="Kudu client worker threads")
        private Integer workers;
        @Parameter(names={"--disable-statistics"}, description="Disable Kudu client statistics", arity=0)
        private Boolean statistics;
        @Parameter(names={"-p", "--password"}, description="Connection password")
        private String password;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"-o", "--output"}, description="Output to a file instead of std out")
        private String file;
        @Parameter(names={"--gzip"}, description="Level of gzip compression to apply to output, from 1-9")
        private Integer gzip;
        @Parameter(names={"--no-header"}, description="Export as a delimited text format (csv|tsv) without a type header")
        private boolean noHeader;
        @Parameter(names={"-m", "--max-features"}, description="Restrict the maximum number of features returned")
        private Integer maxFeatures;
        @Parameter(names={"--attribute"}, description="Attributes or derived expressions to export, or 'id' to include the feature ID", splitter=NoopParameterSplitter.class)
        private List<String> transforms;
        @Parameter(names={"-a", "--attributes"}, description="Comma-separated attributes to export, or 'id' to include the feature ID")
        private List<String> attributes;
        @Parameter(names={"--sort-by"}, description="Sort by the specified attributes (comma-delimited)")
        private List<String> sortFields;
        @Parameter(names={"--sort-descending"}, description="Sort in descending order, instead of ascending", arity=0)
        private boolean sortDescending;
        @Parameter(names={"--num-reducers"}, description="Number of reducers to use when sorting or merging (for distributed export)", validateWith=PositiveInteger.class)
        private Integer reducers;
        @Parameter(names={"--chunk-size"}, description="Split the output into multiple files, by specifying the rough number of bytes to store per file", converter=ParameterConverters.BytesConverter.class)
        private Long chunkSize;
        @Parameter(names={"-F", "--output-format"}, description="File format of output files (csv|tsv|gml|json|shp|avro|leaflet|orc|parquet|arrow)", converter=ParameterConverters.ExportFormatConverter.class)
        private ExportFormat explicitOutputFormat;
        private final ExportFormat outputFormat;
        @Parameter(names={"--force"}, description="Force execution without prompt")
        private boolean force;
        @Parameter(names={"--run-mode"}, description="Run locally or on a cluster", required=false)
        private String runMode;
        private final Option<Enumeration.Value> mode;
        @Parameter(names={"--hints"}, description="Query hints to set, in the form key1=value1;key2=value2", required=false, converter=ParameterConverters.HintConverter.class)
        private Map<String, String> hints;
        @Parameter(names={"-q", "--cql"}, description="CQL predicate", converter=ParameterConverters.FilterConverter.class)
        private Filter cqlFilter;
        private volatile byte bitmap$0;

        public String index() {
            return this.index;
        }

        public void index_$eq(String x$1) {
            this.index = x$1;
        }

        public <DS extends GeoMesaDataStore<DS>> Option<GeoMesaFeatureIndex<?, ?>> loadIndex(DS ds, String typeName, IndexMode.IndexMode mode) throws ParameterException {
            return OptionalIndexParam.class.loadIndex((OptionalIndexParam)this, ds, (String)typeName, (IndexMode.IndexMode)mode);
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        @Override
        public String master() {
            return this.master;
        }

        @Override
        @TraitSetter
        public void master_$eq(String x$1) {
            this.master = x$1;
        }

        @Override
        public Integer bosses() {
            return this.bosses;
        }

        @Override
        @TraitSetter
        public void bosses_$eq(Integer x$1) {
            this.bosses = x$1;
        }

        @Override
        public Integer workers() {
            return this.workers;
        }

        @Override
        @TraitSetter
        public void workers_$eq(Integer x$1) {
            this.workers = x$1;
        }

        @Override
        public Boolean statistics() {
            return this.statistics;
        }

        @Override
        @TraitSetter
        public void statistics_$eq(Boolean x$1) {
            this.statistics = x$1;
        }

        public String password() {
            return this.password;
        }

        public void password_$eq(String x$1) {
            this.password = x$1;
        }

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        public String file() {
            return this.file;
        }

        public void file_$eq(String x$1) {
            this.file = x$1;
        }

        public Integer gzip() {
            return this.gzip;
        }

        public void gzip_$eq(Integer x$1) {
            this.gzip = x$1;
        }

        public boolean noHeader() {
            return this.noHeader;
        }

        public void noHeader_$eq(boolean x$1) {
            this.noHeader = x$1;
        }

        public Integer maxFeatures() {
            return this.maxFeatures;
        }

        public void maxFeatures_$eq(Integer x$1) {
            this.maxFeatures = x$1;
        }

        public List<String> transforms() {
            return this.transforms;
        }

        public void transforms_$eq(List<String> x$1) {
            this.transforms = x$1;
        }

        public List<String> attributes() {
            return this.attributes;
        }

        public void attributes_$eq(List<String> x$1) {
            this.attributes = x$1;
        }

        public List<String> sortFields() {
            return this.sortFields;
        }

        public void sortFields_$eq(List<String> x$1) {
            this.sortFields = x$1;
        }

        public boolean sortDescending() {
            return this.sortDescending;
        }

        public void sortDescending_$eq(boolean x$1) {
            this.sortDescending = x$1;
        }

        public Integer reducers() {
            return this.reducers;
        }

        public void reducers_$eq(Integer x$1) {
            this.reducers = x$1;
        }

        public Long chunkSize() {
            return this.chunkSize;
        }

        public void chunkSize_$eq(Long x$1) {
            this.chunkSize = x$1;
        }

        public ExportFormat explicitOutputFormat() {
            return this.explicitOutputFormat;
        }

        public void explicitOutputFormat_$eq(ExportFormat x$1) {
            this.explicitOutputFormat = x$1;
        }

        private ExportFormat outputFormat$lzycompute() {
            KuduExportParams kuduExportParams = this;
            synchronized (kuduExportParams) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.outputFormat = ExportCommand.ExportParams.class.outputFormat((ExportCommand.ExportParams)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
                return this.outputFormat;
            }
        }

        public ExportFormat outputFormat() {
            return (byte)(this.bitmap$0 & 1) == 0 ? this.outputFormat$lzycompute() : this.outputFormat;
        }

        public boolean force() {
            return this.force;
        }

        public void force_$eq(boolean x$1) {
            this.force = x$1;
        }

        public String runMode() {
            return this.runMode;
        }

        public void runMode_$eq(String x$1) {
            this.runMode = x$1;
        }

        private Option mode$lzycompute() {
            KuduExportParams kuduExportParams = this;
            synchronized (kuduExportParams) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.mode = DistributedRunParam.class.mode((DistributedRunParam)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
                return this.mode;
            }
        }

        public Option<Enumeration.Value> mode() {
            return (byte)(this.bitmap$0 & 2) == 0 ? this.mode$lzycompute() : this.mode;
        }

        public Map<String, String> hints() {
            return this.hints;
        }

        public void hints_$eq(Map<String, String> x$1) {
            this.hints = x$1;
        }

        public Filter cqlFilter() {
            return this.cqlFilter;
        }

        public void cqlFilter_$eq(Filter x$1) {
            this.cqlFilter = x$1;
        }

        public KuduExportParams() {
            OptionalCqlFilterParam.class.$init$((OptionalCqlFilterParam)this);
            QueryHintsParams.class.$init$((QueryHintsParams)this);
            DistributedRunParam.class.$init$((DistributedRunParam)this);
            OptionalForceParam.class.$init$((OptionalForceParam)this);
            ExportCommand.ExportParams.class.$init$((ExportCommand.ExportParams)this);
            CatalogParam.class.$init$((CatalogParam)this);
            PasswordParams.class.$init$((PasswordParams)this);
            KuduDataStoreCommand$KuduParams$class.$init$(this);
            RequiredTypeNameParam.class.$init$((RequiredTypeNameParam)this);
            OptionalIndexParam.class.$init$((OptionalIndexParam)this);
        }
    }
}

