/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kudu.tools.data;

import com.beust.jcommander.IValueValidator;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import org.geotools.data.DataStore;
import org.locationtech.geomesa.kudu.data.KuduDataStore;
import org.locationtech.geomesa.kudu.package;
import org.locationtech.geomesa.kudu.tools.KuduDataStoreCommand;
import org.locationtech.geomesa.kudu.tools.KuduDataStoreCommand$KuduParams$class;
import org.locationtech.geomesa.kudu.tools.KuduDataStoreCommand$class;
import org.locationtech.geomesa.kudu.utils.ColumnConfiguration$;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.DataStoreCommand;
import org.locationtech.geomesa.tools.OptionalDtgParam;
import org.locationtech.geomesa.tools.OptionalTypeNameParam;
import org.locationtech.geomesa.tools.PasswordParams;
import org.locationtech.geomesa.tools.RequiredFeatureSpecParam;
import org.locationtech.geomesa.tools.data.CreateSchemaCommand;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u0001\u0003\u0001=\u0011qcS;ek\u000e\u0013X-\u0019;f'\u000eDW-\\1D_6l\u0017M\u001c3\u000b\u0005\r!\u0011\u0001\u00023bi\u0006T!!\u0002\u0004\u0002\u000bQ|w\u000e\\:\u000b\u0005\u001dA\u0011\u0001B6vIVT!!\u0003\u0006\u0002\u000f\u001d,w.\\3tC*\u00111\u0002D\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\f\"!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0019qC\u0007\u000f\u000e\u0003aQ!aA\r\u000b\u0005\u0015A\u0011BA\u000e\u0019\u0005M\u0019%/Z1uKN\u001b\u0007.Z7b\u0007>lW.\u00198e!\tir$D\u0001\u001f\u0015\t\u0019a!\u0003\u0002!=\ti1*\u001e3v\t\u0006$\u0018m\u0015;pe\u0016\u0004\"AI\u0012\u000e\u0003\u0011I!\u0001\n\u0003\u0003)-+H-\u001e#bi\u0006\u001cFo\u001c:f\u0007>lW.\u00198e\u0011\u00151\u0003\u0001\"\u0001(\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0006\u0005\u0002*\u00015\t!\u0001C\u0004,\u0001\t\u0007I\u0011\t\u0017\u0002\rA\f'/Y7t+\u0005i\u0003C\u0001\u0018F\u001d\tycH\u0004\u00021{9\u0011\u0011\u0007\u0010\b\u0003emr!a\r\u001e\u000f\u0005QJdBA\u001b9\u001b\u00051$BA\u001c\u000f\u0003\u0019a$o\\8u}%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005\r!q!B \u0003\u0011\u0003\u0001\u0015aF&vIV\u001c%/Z1uKN\u001b\u0007.Z7b\u0007>lW.\u00198e!\tI\u0013IB\u0003\u0002\u0005!\u0005!i\u0005\u0002B!!)a%\u0011C\u0001\tR\t\u0001I\u0002\u0003G\u0003\u00029%AF&vIV\u001c%/Z1uKN\u001b\u0007.Z7b!\u0006\u0014\u0018-\\:\u0014\t\u0015\u0003\u0002j\u0015\t\u0003\u0013Bs!A\u0013(\u000f\u0005-keB\u0001\u001aM\u0013\t)\u0001\"\u0003\u0002\u00043%\u0011q\nG\u0001\u0014\u0007J,\u0017\r^3TG\",W.Y\"p[6\fg\u000eZ\u0005\u0003#J\u0013!c\u0011:fCR,7k\u00195f[\u0006\u0004\u0016M]1ng*\u0011q\n\u0007\t\u0003)^s!\u0001M+\n\u0005Y#\u0011\u0001F&vIV$\u0015\r^1Ti>\u0014XmQ8n[\u0006tG-\u0003\u0002Y3\nQ1*\u001e3v!\u0006\u0014\u0018-\\:\u000b\u0005Y#\u0001\"\u0002\u0014F\t\u0003YF#\u0001/\u0011\u0005u+U\"A!\t\u000f}+\u0005\u0019!C\u0001A\u0006Y1m\\7qe\u0016\u001c8/[8o+\u0005\t\u0007C\u00012f\u001d\t\t2-\u0003\u0002e%\u00051\u0001K]3eK\u001aL!AZ4\u0003\rM#(/\u001b8h\u0015\t!'\u0003C\u0004j\u000b\u0002\u0007I\u0011\u00016\u0002\u001f\r|W\u000e\u001d:fgNLwN\\0%KF$\"a\u001b8\u0011\u0005Ea\u0017BA7\u0013\u0005\u0011)f.\u001b;\t\u000f=D\u0017\u0011!a\u0001C\u0006\u0019\u0001\u0010J\u0019\t\rE,\u0005\u0015)\u0003b\u00031\u0019w.\u001c9sKN\u001c\u0018n\u001c8!QA\u00018/ @\u0002\u0004\u0005\u0015\u0011\u0011BA\u0006\u0003\u001b\ty\u0001\u0005\u0002uw6\tQO\u0003\u0002wo\u0006Q!nY8n[\u0006tG-\u001a:\u000b\u0005aL\u0018!\u00022fkN$(\"\u0001>\u0002\u0007\r|W.\u0003\u0002}k\nI\u0001+\u0019:b[\u0016$XM]\u0001\u0006]\u0006lWm\u001d\u0017\u0002\u007f\u0006\u0012\u0011\u0011A\u0001\u000e[5\u001aw.\u001c9sKN\u001c\u0018n\u001c8\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u0011\u0003\u0003\u000f\ta\u000bR3gCVdG\u000fI2p[B\u0014Xm]:j_:\u0004cm\u001c:!I\u0006$\u0018\r\t4jY\u0016\u001ch\u0006I(oK\u0002zg\rI\u0014muR:C\u0006I\u0014t]\u0006\u0004\b/_\u0014-A\u001dRH.\u001b2(A=\u0014\be\n8p?\u000e|W\u000e\u001d:fgNLwN\\\u0014\u0002\u0011I,\u0017/^5sK\u0012L\u0012\u0001A\u0001\u0012m\u0006d\u0017\u000eZ1uKZ\u000bG.^3XSRD7EAA\t!\ri\u00161\u0003\u0004\u0007\u0003+\t\u0005!a\u0006\u00031\r{W\u000e\u001d:fgNLwN\u001c+za\u00164\u0016\r\\5eCR|'o\u0005\u0004\u0002\u0014\u0005e\u0011\u0011\u0006\t\u0005\u00037\t)#\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\r\u0012\u0001\u00026bm\u0006LA!a\n\u0002\u001e\t1qJ\u00196fGR\u0004B\u0001^A\u0016C&\u0019\u0011QF;\u0003\u001f%3\u0016\r\\;f-\u0006d\u0017\u000eZ1u_JDqAJA\n\t\u0003\t\t\u0004\u0006\u0002\u0002\u0012!A\u0011QGA\n\t\u0003\n9$\u0001\u0005wC2LG-\u0019;f)\u0015Y\u0017\u0011HA\u001f\u0011\u001d\tY$a\rA\u0002\u0005\fAA\\1nK\"9\u0011qHA\u001a\u0001\u0004\t\u0017!\u0002<bYV,\u0007fB#\u0002D\u0005%\u00131\n\t\u0004i\u0006\u0015\u0013bAA$k\nQ\u0001+\u0019:b[\u0016$XM]:\u0002%\r|W.\\1oI\u0012+7o\u0019:jaRLwN\\\u0011\u0003\u0003\u001b\nQd\u0011:fCR,\u0007%\u0019\u0011HK>lUm]1!M\u0016\fG/\u001e:fAQL\b/\u001a\u0005\b\u0003#\u0002\u0001\u0015!\u0003.\u0003\u001d\u0001\u0018M]1ng\u0002Bq!!\u0016\u0001\t#\n9&A\rtKR\u0014\u0015mY6f]\u0012\u001c\u0006/Z2jM&\u001cw\n\u001d;j_:\u001cHcA6\u0002Z!A\u00111LA*\u0001\u0004\ti&A\u0006gK\u0006$XO]3UsB,\u0007\u0003BA0\u0003[j!!!\u0019\u000b\t\u0005\r\u0014QM\u0001\u0007g&l\u0007\u000f\\3\u000b\t\u0005\u001d\u0014\u0011N\u0001\bM\u0016\fG/\u001e:f\u0015\r\tY\u0007D\u0001\b_B,gnZ5t\u0013\u0011\ty'!\u0019\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f)f\u0004X\r")
public class KuduCreateSchemaCommand
implements CreateSchemaCommand<KuduDataStore>,
KuduDataStoreCommand {
    private final KuduCreateSchemaParams params;
    private final String name;

    @Override
    public Map<String, String> connection() {
        return KuduDataStoreCommand$class.connection(this);
    }

    public String name() {
        return this.name;
    }

    public void org$locationtech$geomesa$tools$data$CreateSchemaCommand$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    public void execute() {
        CreateSchemaCommand.class.execute((CreateSchemaCommand)this);
    }

    public void createSchema(DataStore ds, SimpleFeatureType sft) {
        CreateSchemaCommand.class.createSchema((CreateSchemaCommand)this, (DataStore)ds, (SimpleFeatureType)sft);
    }

    public <T> T withDataStore(Function1<KuduDataStore, T> method) throws ParameterException {
        return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return DataStoreCommand.class.loadDataStore((DataStoreCommand)this);
    }

    @Override
    public KuduCreateSchemaParams params() {
        return this.params;
    }

    public void setBackendSpecificOptions(SimpleFeatureType featureType) {
        Option$.MODULE$.apply((Object)this.params().compression()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String value) {
                package.KuduSystemProperties$.MODULE$.Compression().set(value);
            }
        });
    }

    public KuduCreateSchemaCommand() {
        DataStoreCommand.class.$init$((DataStoreCommand)this);
        CreateSchemaCommand.class.$init$((CreateSchemaCommand)this);
        KuduDataStoreCommand$class.$init$(this);
        this.params = new KuduCreateSchemaParams();
    }

    @Parameters(commandDescription="Create a GeoMesa feature type")
    public static class KuduCreateSchemaParams
    implements CreateSchemaCommand.CreateSchemaParams,
    KuduDataStoreCommand.KuduParams {
        @Parameter(names={"--compression"}, description="Default compression for data files. One of 'lz4', 'snappy', 'zlib' or 'no_compression'", required=false, validateValueWith=CompressionTypeValidator.class)
        private String compression;
        @Parameter(names={"-M", "--master"}, description="Kudu master server", required=true)
        private String master;
        @Parameter(names={"--boss-threads"}, description="Kudu client boss threads")
        private Integer bosses;
        @Parameter(names={"--worker-threads"}, description="Kudu client worker threads")
        private Integer workers;
        @Parameter(names={"--disable-statistics"}, description="Disable Kudu client statistics", arity=0)
        private Boolean statistics;
        @Parameter(names={"-p", "--password"}, description="Connection password")
        private String password;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"--dtg"}, description="DateTime field name to use as the default dtg")
        private String dtgField;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate")
        private String featureName;
        @Parameter(names={"-s", "--spec"}, description="SimpleFeatureType specification as a GeoTools spec string, SFT config, or file with either", required=true)
        private String spec;

        @Override
        public String master() {
            return this.master;
        }

        @Override
        @TraitSetter
        public void master_$eq(String x$1) {
            this.master = x$1;
        }

        @Override
        public Integer bosses() {
            return this.bosses;
        }

        @Override
        @TraitSetter
        public void bosses_$eq(Integer x$1) {
            this.bosses = x$1;
        }

        @Override
        public Integer workers() {
            return this.workers;
        }

        @Override
        @TraitSetter
        public void workers_$eq(Integer x$1) {
            this.workers = x$1;
        }

        @Override
        public Boolean statistics() {
            return this.statistics;
        }

        @Override
        @TraitSetter
        public void statistics_$eq(Boolean x$1) {
            this.statistics = x$1;
        }

        public String password() {
            return this.password;
        }

        public void password_$eq(String x$1) {
            this.password = x$1;
        }

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        public String dtgField() {
            return this.dtgField;
        }

        public void dtgField_$eq(String x$1) {
            this.dtgField = x$1;
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        public String spec() {
            return this.spec;
        }

        public void spec_$eq(String x$1) {
            this.spec = x$1;
        }

        public String compression() {
            return this.compression;
        }

        public void compression_$eq(String x$1) {
            this.compression = x$1;
        }

        public KuduCreateSchemaParams() {
            RequiredFeatureSpecParam.class.$init$((RequiredFeatureSpecParam)this);
            OptionalTypeNameParam.class.$init$((OptionalTypeNameParam)this);
            OptionalDtgParam.class.$init$((OptionalDtgParam)this);
            CatalogParam.class.$init$((CatalogParam)this);
            PasswordParams.class.$init$((PasswordParams)this);
            KuduDataStoreCommand$KuduParams$class.$init$(this);
            this.compression = package.KuduSystemProperties$.MODULE$.Compression().default();
        }
    }

    public static class CompressionTypeValidator
    implements IValueValidator<String> {
        public void validate(String name, String value) {
            try {
                ColumnConfiguration$.MODULE$.compression(Option$.MODULE$.apply((Object)value));
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                throw new ParameterException("Invalid compression type.  Values types are 'lz4', 'snappy', 'zlib' or 'no_compression'");
            }
        }
    }
}

