/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kudu.tools.export;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.validators.PositiveInteger;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.mapreduce.Job;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.kudu.data.KuduDataStore;
import org.locationtech.geomesa.kudu.tools.KuduDataStoreCommand;
import org.locationtech.geomesa.kudu.tools.KuduDataStoreCommand$KuduDistributedCommand$class;
import org.locationtech.geomesa.kudu.tools.KuduDataStoreCommand$KuduParams$class;
import org.locationtech.geomesa.kudu.tools.KuduDataStoreCommand$class;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.DistributedRunParam;
import org.locationtech.geomesa.tools.OptionalCqlFilterParam;
import org.locationtech.geomesa.tools.OptionalForceParam;
import org.locationtech.geomesa.tools.OptionalIndexParam;
import org.locationtech.geomesa.tools.PasswordParams;
import org.locationtech.geomesa.tools.QueryHintsParams;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.formats.ExportFormat;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.utils.NoopParameterSplitter;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.opengis.filter.Filter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001\u001f\t\t2*\u001e3v\u000bb\u0004xN\u001d;D_6l\u0017M\u001c3\u000b\u0005\r!\u0011AB3ya>\u0014HO\u0003\u0002\u0006\r\u0005)Ao\\8mg*\u0011q\u0001C\u0001\u0005WV$WO\u0003\u0002\n\u0015\u00059q-Z8nKN\f'BA\u0006\r\u00031awnY1uS>tG/Z2i\u0015\u0005i\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u00111\u0011\u0002\"!\u0005\f\u000e\u0003IQ!a\u0005\u000b\u0002\t1\fgn\u001a\u0006\u0002+\u0005!!.\u0019<b\u0013\t9\"C\u0001\u0004PE*,7\r\u001e\t\u00043qqR\"\u0001\u000e\u000b\u0005\rY\"BA\u0003\t\u0013\ti\"DA\u0007FqB|'\u000f^\"p[6\fg\u000e\u001a\t\u0003?\tj\u0011\u0001\t\u0006\u0003C\u0019\tA\u0001Z1uC&\u00111\u0005\t\u0002\u000e\u0017V$W\u000fR1uCN#xN]3\u0011\u0005\u0015*dB\u0001\u00144\u001d\t9#G\u0004\u0002)c9\u0011\u0011\u0006\r\b\u0003U=r!a\u000b\u0018\u000e\u00031R!!\f\b\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003i\u0011\tAcS;ek\u0012\u000bG/Y*u_J,7i\\7nC:$\u0017B\u0001\u001c8\u0005YYU\u000fZ;ESN$(/\u001b2vi\u0016$7i\\7nC:$'B\u0001\u001b\u0005\u0011\u0015I\u0004\u0001\"\u0001;\u0003\u0019a\u0014N\\5u}Q\t1\b\u0005\u0002=\u00015\t!\u0001C\u0004?\u0001\t\u0007I\u0011I \u0002\rA\f'/Y7t+\u0005\u0001\u0005CA!R\u001d\t\u0011EI\u0004\u0002'\u0007&\u00111\u0001B\u0004\u0006\u000b\nA\tAR\u0001\u0012\u0017V$W/\u0012=q_J$8i\\7nC:$\u0007C\u0001\u001fH\r\u0015\t!\u0001#\u0001I'\t9\u0015\n\u0005\u0002K\u001b6\t1JC\u0001M\u0003\u0015\u00198-\u00197b\u0013\tq5J\u0001\u0004B]f\u0014VM\u001a\u0005\u0006s\u001d#\t\u0001\u0015\u000b\u0002\r\u001a!!k\u0012\u0001T\u0005AYU\u000fZ;FqB|'\u000f\u001e)be\u0006l7o\u0005\u0004R\u0013R{&M\u001a\t\u0003+rs!A\u0016.\u000f\u0005]KfB\u0001\u0015Y\u0013\t)\u0001\"\u0003\u0002\u00047%\u00111LG\u0001\u000e\u000bb\u0004xN\u001d;D_6l\u0017M\u001c3\n\u0005us&\u0001D#ya>\u0014H\u000fU1sC6\u001c(BA.\u001b!\t)\u0003-\u0003\u0002bo\tQ1*\u001e3v!\u0006\u0014\u0018-\\:\u0011\u0005\r$W\"A\u000e\n\u0005\u0015\\\"!\u0006*fcVL'/\u001a3UsB,g*Y7f!\u0006\u0014\u0018-\u001c\t\u0003G\u001eL!\u0001[\u000e\u0003%=\u0003H/[8oC2Le\u000eZ3y!\u0006\u0014\u0018-\u001c\u0005\u0006sE#\tA\u001b\u000b\u0002WB\u0011A.U\u0007\u0002\u000f\"\"\u0011K\u001c=z!\tyg/D\u0001q\u0015\t\t(/\u0001\u0006kG>lW.\u00198eKJT!a\u001d;\u0002\u000b\t,Wo\u001d;\u000b\u0003U\f1aY8n\u0013\t9\bO\u0001\u0006QCJ\fW.\u001a;feN\f!cY8n[\u0006tG\rR3tGJL\u0007\u000f^5p]\u0006\n!0A\u0015FqB|'\u000f\u001e\u0011gK\u0006$XO]3tA\u0019\u0014x.\u001c\u0011bA\u001d+w.T3tC\u0002\"\u0017\r^1!gR|'/\u001a\u0005\u0007y\u0002\u0001\u000b\u0011\u0002!\u0002\u000fA\f'/Y7tA\u0001")
public class KuduExportCommand
implements ExportCommand<KuduDataStore>,
KuduDataStoreCommand.KuduDistributedCommand {
    private final KuduExportParams params;
    private final String name;
    private final Logger logger;
    private Object org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ Seq org$locationtech$geomesa$kudu$tools$KuduDataStoreCommand$KuduDistributedCommand$$super$libjarsFiles() {
        return ExportCommand.class.libjarsFiles((ExportCommand)this);
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$kudu$tools$KuduDataStoreCommand$KuduDistributedCommand$$super$libjarsPaths() {
        return package.DistributedCommand.class.libjarsPaths((package.DistributedCommand)this);
    }

    @Override
    public Seq<String> libjarsFiles() {
        return KuduDataStoreCommand$KuduDistributedCommand$class.libjarsFiles(this);
    }

    @Override
    public Iterator<Function0<Seq<File>>> libjarsPaths() {
        return KuduDataStoreCommand$KuduDistributedCommand$class.libjarsPaths(this);
    }

    @Override
    public scala.collection.immutable.Map<String, String> connection() {
        return KuduDataStoreCommand$class.connection(this);
    }

    public String name() {
        return this.name;
    }

    public void org$locationtech$geomesa$tools$export$ExportCommand$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    public void execute() {
        ExportCommand.class.execute((ExportCommand)this);
    }

    public Option export(DataStore ds, Query query, FeatureExporter exporter, boolean writeEmptyFiles) {
        return ExportCommand.class.export((ExportCommand)this, (DataStore)ds, (Query)query, (FeatureExporter)exporter, (boolean)writeEmptyFiles);
    }

    public void configure(Job job, DataStore ds, Query query) {
        ExportCommand.class.configure((ExportCommand)this, (Job)job, (DataStore)ds, (Query)query);
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, (String)message, code);
    }

    private Logger logger$lzycompute() {
        KuduExportCommand kuduExportCommand = this;
        synchronized (kuduExportCommand) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Object org$locationtech$geomesa$tools$InteractiveCommand$$_console() {
        return this.org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    }

    public void org$locationtech$geomesa$tools$InteractiveCommand$$_console_$eq(Object x$1) {
        this.org$locationtech$geomesa$tools$InteractiveCommand$$_console = x$1;
    }

    public Object console() {
        return package.InteractiveCommand.class.console((package.InteractiveCommand)this);
    }

    public void setConsole(Object c) {
        package.InteractiveCommand.class.setConsole((package.InteractiveCommand)this, (Object)c);
    }

    public <T> T withDataStore(Function1<KuduDataStore, T> method) throws ParameterException {
        return (T)package.DataStoreCommand.class.withDataStore((package.DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return package.DataStoreCommand.class.loadDataStore((package.DataStoreCommand)this);
    }

    public Seq<package.Command> subCommands() {
        return package.Command.class.subCommands((package.Command)this);
    }

    public Option<ParameterException> validate() {
        return package.Command.class.validate((package.Command)this);
    }

    public void run() {
        package.Command.class.run((package.Command)this);
    }

    @Override
    public KuduExportParams params() {
        return this.params;
    }

    public KuduExportCommand() {
        package.Command.class.$init$((package.Command)this);
        package.DataStoreCommand.class.$init$((package.DataStoreCommand)this);
        package.DistributedCommand.class.$init$((package.DistributedCommand)this);
        package.InteractiveCommand.class.$init$((package.InteractiveCommand)this);
        LazyLogging.class.$init$((LazyLogging)this);
        MethodProfiling.class.$init$((MethodProfiling)this);
        ExportCommand.class.$init$((ExportCommand)this);
        KuduDataStoreCommand$class.$init$(this);
        KuduDataStoreCommand$KuduDistributedCommand$class.$init$(this);
        this.params = new KuduExportParams();
    }

    @Parameters(commandDescription="Export features from a GeoMesa data store")
    public static class KuduExportParams
    implements ExportCommand.ExportParams,
    KuduDataStoreCommand.KuduParams,
    RequiredTypeNameParam,
    OptionalIndexParam {
        @Parameter(names={"--index"}, description="Specify a particular GeoMesa index", required=false)
        private String index;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"-M", "--master"}, description="Kudu master server", required=true)
        private String master;
        @Parameter(names={"--boss-threads"}, description="Kudu client boss threads")
        private Integer bosses;
        @Parameter(names={"--worker-threads"}, description="Kudu client worker threads")
        private Integer workers;
        @Parameter(names={"--disable-statistics"}, description="Disable Kudu client statistics", arity=0)
        private Boolean statistics;
        @Parameter(names={"-p", "--password"}, description="Connection password")
        private String password;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"-o", "--output"}, description="Output to a file instead of std out")
        private String file;
        @Parameter(names={"--gzip"}, description="Level of gzip compression to apply to output, from 1-9")
        private Integer gzip;
        @Parameter(names={"--no-header"}, description="Export as a delimited text format (csv|tsv) without a type header")
        private boolean noHeader;
        @Parameter(names={"--suppress-empty"}, description="Suppress all output (headers, etc) if there are no features exported")
        private boolean suppressEmpty;
        @Parameter(names={"-m", "--max-features"}, description="Restrict the maximum number of features returned")
        private Integer maxFeatures;
        @Parameter(names={"--attribute"}, description="Attributes or derived expressions to export, or 'id' to include the feature ID", splitter=NoopParameterSplitter.class)
        private List<String> transforms;
        @Parameter(names={"-a", "--attributes"}, description="Comma-separated attributes to export, or 'id' to include the feature ID")
        private List<String> attributes;
        @Parameter(names={"--sort-by"}, description="Sort by the specified attributes (comma-delimited)")
        private List<String> sortFields;
        @Parameter(names={"--sort-descending"}, description="Sort in descending order, instead of ascending", arity=0)
        private boolean sortDescending;
        @Parameter(names={"--num-reducers"}, description="Number of reducers to use when sorting or merging (for distributed export)", validateWith={PositiveInteger.class})
        private Integer reducers;
        @Parameter(names={"--chunk-size"}, description="Split the output into multiple files, by specifying the rough number of bytes to store per file", converter=ParameterConverters.BytesConverter.class)
        private Long chunkSize;
        @Parameter(names={"-F", "--output-format"}, description="File format of output files (csv|tsv|gml|json|shp|avro|leaflet|orc|parquet|arrow)", converter=ParameterConverters.ExportFormatConverter.class)
        private ExportFormat explicitOutputFormat;
        private final ExportFormat outputFormat;
        @Parameter(names={"--force"}, description="Force execution without prompt")
        private boolean force;
        @Parameter(names={"--run-mode"}, description="Run locally or on a cluster", required=false)
        private String runMode;
        private final Option<Enumeration.Value> mode;
        @Parameter(names={"--hints"}, description="Query hints to set, in the form key1=value1;key2=value2", required=false, converter=ParameterConverters.HintConverter.class)
        private Map<String, String> hints;
        @Parameter(names={"-q", "--cql"}, description="CQL predicate", converter=ParameterConverters.FilterConverter.class)
        private Filter cqlFilter;
        private volatile byte bitmap$0;

        public String index() {
            return this.index;
        }

        public void index_$eq(String x$1) {
            this.index = x$1;
        }

        public <DS extends GeoMesaDataStore<DS>> Option<GeoMesaFeatureIndex<?, ?>> loadIndex(DS ds, String typeName, IndexMode.IndexMode mode) throws ParameterException {
            return OptionalIndexParam.class.loadIndex((OptionalIndexParam)this, ds, (String)typeName, (IndexMode.IndexMode)mode);
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        @Override
        public String master() {
            return this.master;
        }

        @Override
        @TraitSetter
        public void master_$eq(String x$1) {
            this.master = x$1;
        }

        @Override
        public Integer bosses() {
            return this.bosses;
        }

        @Override
        @TraitSetter
        public void bosses_$eq(Integer x$1) {
            this.bosses = x$1;
        }

        @Override
        public Integer workers() {
            return this.workers;
        }

        @Override
        @TraitSetter
        public void workers_$eq(Integer x$1) {
            this.workers = x$1;
        }

        @Override
        public Boolean statistics() {
            return this.statistics;
        }

        @Override
        @TraitSetter
        public void statistics_$eq(Boolean x$1) {
            this.statistics = x$1;
        }

        public String password() {
            return this.password;
        }

        public void password_$eq(String x$1) {
            this.password = x$1;
        }

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        public String file() {
            return this.file;
        }

        public void file_$eq(String x$1) {
            this.file = x$1;
        }

        public Integer gzip() {
            return this.gzip;
        }

        public void gzip_$eq(Integer x$1) {
            this.gzip = x$1;
        }

        public boolean noHeader() {
            return this.noHeader;
        }

        public void noHeader_$eq(boolean x$1) {
            this.noHeader = x$1;
        }

        public boolean suppressEmpty() {
            return this.suppressEmpty;
        }

        public void suppressEmpty_$eq(boolean x$1) {
            this.suppressEmpty = x$1;
        }

        public Integer maxFeatures() {
            return this.maxFeatures;
        }

        public void maxFeatures_$eq(Integer x$1) {
            this.maxFeatures = x$1;
        }

        public List<String> transforms() {
            return this.transforms;
        }

        public void transforms_$eq(List<String> x$1) {
            this.transforms = x$1;
        }

        public List<String> attributes() {
            return this.attributes;
        }

        public void attributes_$eq(List<String> x$1) {
            this.attributes = x$1;
        }

        public List<String> sortFields() {
            return this.sortFields;
        }

        public void sortFields_$eq(List<String> x$1) {
            this.sortFields = x$1;
        }

        public boolean sortDescending() {
            return this.sortDescending;
        }

        public void sortDescending_$eq(boolean x$1) {
            this.sortDescending = x$1;
        }

        public Integer reducers() {
            return this.reducers;
        }

        public void reducers_$eq(Integer x$1) {
            this.reducers = x$1;
        }

        public Long chunkSize() {
            return this.chunkSize;
        }

        public void chunkSize_$eq(Long x$1) {
            this.chunkSize = x$1;
        }

        public ExportFormat explicitOutputFormat() {
            return this.explicitOutputFormat;
        }

        public void explicitOutputFormat_$eq(ExportFormat x$1) {
            this.explicitOutputFormat = x$1;
        }

        private ExportFormat outputFormat$lzycompute() {
            KuduExportParams kuduExportParams = this;
            synchronized (kuduExportParams) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.outputFormat = ExportCommand.ExportParams.class.outputFormat((ExportCommand.ExportParams)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
                return this.outputFormat;
            }
        }

        public ExportFormat outputFormat() {
            return (byte)(this.bitmap$0 & 1) == 0 ? this.outputFormat$lzycompute() : this.outputFormat;
        }

        public boolean force() {
            return this.force;
        }

        public void force_$eq(boolean x$1) {
            this.force = x$1;
        }

        public String runMode() {
            return this.runMode;
        }

        public void runMode_$eq(String x$1) {
            this.runMode = x$1;
        }

        private Option mode$lzycompute() {
            KuduExportParams kuduExportParams = this;
            synchronized (kuduExportParams) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.mode = DistributedRunParam.class.mode((DistributedRunParam)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
                return this.mode;
            }
        }

        public Option<Enumeration.Value> mode() {
            return (byte)(this.bitmap$0 & 2) == 0 ? this.mode$lzycompute() : this.mode;
        }

        public Map<String, String> hints() {
            return this.hints;
        }

        public void hints_$eq(Map<String, String> x$1) {
            this.hints = x$1;
        }

        public Filter cqlFilter() {
            return this.cqlFilter;
        }

        public void cqlFilter_$eq(Filter x$1) {
            this.cqlFilter = x$1;
        }

        public KuduExportParams() {
            OptionalCqlFilterParam.class.$init$((OptionalCqlFilterParam)this);
            QueryHintsParams.class.$init$((QueryHintsParams)this);
            DistributedRunParam.class.$init$((DistributedRunParam)this);
            OptionalForceParam.class.$init$((OptionalForceParam)this);
            ExportCommand.ExportParams.class.$init$((ExportCommand.ExportParams)this);
            CatalogParam.class.$init$((CatalogParam)this);
            PasswordParams.class.$init$((PasswordParams)this);
            KuduDataStoreCommand$KuduParams$class.$init$(this);
            RequiredTypeNameParam.class.$init$((RequiredTypeNameParam)this);
            OptionalIndexParam.class.$init$((OptionalIndexParam)this);
        }
    }
}

