/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kudu.tools.export;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.validators.PositiveInteger;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.mapreduce.Job;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.kudu.data.KuduDataStore;
import org.locationtech.geomesa.kudu.tools.KuduDataStoreCommand;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.DistributedRunParam;
import org.locationtech.geomesa.tools.NumReducersParam;
import org.locationtech.geomesa.tools.OptionalCqlFilterParam;
import org.locationtech.geomesa.tools.OptionalForceParam;
import org.locationtech.geomesa.tools.OptionalIndexParam;
import org.locationtech.geomesa.tools.PasswordParams;
import org.locationtech.geomesa.tools.QueryHintsParams;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.formats.ExportFormat;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.utils.NoopParameterSplitter;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.opengis.filter.Filter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0003\u0006\u0001/!)\u0001\t\u0001C\u0001\u0003\"9A\t\u0001b\u0001\n\u0003*\u0005B\u0002?\u0001A\u0003%aiB\u0003K\u0015!\u00051JB\u0003\n\u0015!\u0005A\nC\u0003A\u000b\u0011\u00051K\u0002\u0003U\u000b\u0001)\u0006\"\u0002!\b\t\u0003Y'!E&vIV,\u0005\u0010]8si\u000e{W.\\1oI*\u00111\u0002D\u0001\u0007Kb\u0004xN\u001d;\u000b\u00055q\u0011!\u0002;p_2\u001c(BA\b\u0011\u0003\u0011YW\u000fZ;\u000b\u0005E\u0011\u0012aB4f_6,7/\u0019\u0006\u0003'Q\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011!F\u0001\u0004_J<7\u0001A\n\u0005\u0001a\u0001C\u0006\u0005\u0002\u001a=5\t!D\u0003\u0002\u001c9\u0005!A.\u00198h\u0015\u0005i\u0012\u0001\u00026bm\u0006L!a\b\u000e\u0003\r=\u0013'.Z2u!\r\tCEJ\u0007\u0002E)\u00111b\t\u0006\u0003\u001bAI!!\n\u0012\u0003\u001b\u0015C\bo\u001c:u\u0007>lW.\u00198e!\t9#&D\u0001)\u0015\tIc\"\u0001\u0003eCR\f\u0017BA\u0016)\u00055YU\u000fZ;ECR\f7\u000b^8sKB\u0011Q&\u0010\b\u0003]mr!a\f\u001e\u000f\u0005AJdBA\u00199\u001d\t\u0011tG\u0004\u00024m5\tAG\u0003\u00026-\u00051AH]8pizJ\u0011!F\u0005\u0003'QI!!\u0005\n\n\u0005=\u0001\u0012BA\u0007\u000f\u0013\taD\"\u0001\u000bLk\u0012,H)\u0019;b'R|'/Z\"p[6\fg\u000eZ\u0005\u0003}}\u0012acS;ek\u0012K7\u000f\u001e:jEV$X\rZ\"p[6\fg\u000e\u001a\u0006\u0003y1\ta\u0001P5oSRtD#\u0001\"\u0011\u0005\r\u0003Q\"\u0001\u0006\u0002\rA\f'/Y7t+\u00051\u0005CA$\b\u001d\tAEA\u0004\u0002/\u0013&\u00111\u0002D\u0001\u0012\u0017V$W/\u0012=q_J$8i\\7nC:$\u0007CA\"\u0006'\t)Q\n\u0005\u0002O#6\tqJC\u0001Q\u0003\u0015\u00198-\u00197b\u0013\t\u0011vJ\u0001\u0004B]f\u0014VM\u001a\u000b\u0002\u0017\n\u00012*\u001e3v\u000bb\u0004xN\u001d;QCJ\fWn]\n\u0007\u000f53\u0016\r\u001a5\u0011\u0005]sfB\u0001-]\u001d\tI6L\u0004\u000215&\u0011Q\u0002E\u0005\u0003\u0017\rJ!!\u0018\u0012\u0002\u001b\u0015C\bo\u001c:u\u0007>lW.\u00198e\u0013\ty\u0006M\u0001\u0007FqB|'\u000f\u001e)be\u0006l7O\u0003\u0002^EA\u0011QFY\u0005\u0003G~\u0012!bS;ekB\u000b'/Y7t!\t)g-D\u0001$\u0013\t97EA\u000bSKF,\u0018N]3e)f\u0004XMT1nKB\u000b'/Y7\u0011\u0005\u0015L\u0017B\u00016$\u0005Iy\u0005\u000f^5p]\u0006d\u0017J\u001c3fqB\u000b'/Y7\u0015\u00031\u0004\"!\\\u0004\u000e\u0003\u0015ACaB8zuB\u0011\u0001o^\u0007\u0002c*\u0011!o]\u0001\u000bU\u000e|W.\\1oI\u0016\u0014(B\u0001;v\u0003\u0015\u0011W-^:u\u0015\u00051\u0018aA2p[&\u0011\u00010\u001d\u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c\u0018AE2p[6\fg\u000e\u001a#fg\u000e\u0014\u0018\u000e\u001d;j_:\f\u0013a_\u0001*\u000bb\u0004xN\u001d;!M\u0016\fG/\u001e:fg\u00022'o\\7!C\u0002:Um\\'fg\u0006\u0004C-\u0019;bAM$xN]3\u0002\u000fA\f'/Y7tA\u0001")
public class KuduExportCommand
implements ExportCommand<KuduDataStore>,
KuduDataStoreCommand.KuduDistributedCommand {
    private final KuduExportParams params;
    private final String name;
    private Logger logger;
    private Object org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ Seq org$locationtech$geomesa$kudu$tools$KuduDataStoreCommand$KuduDistributedCommand$$super$libjarsFiles() {
        return ExportCommand.libjarsFiles$((ExportCommand)this);
    }

    @Override
    public /* synthetic */ Iterator org$locationtech$geomesa$kudu$tools$KuduDataStoreCommand$KuduDistributedCommand$$super$libjarsPaths() {
        return package.DistributedCommand.libjarsPaths$((package.DistributedCommand)this);
    }

    @Override
    public Seq<String> libjarsFiles() {
        return KuduDataStoreCommand.KuduDistributedCommand.libjarsFiles$(this);
    }

    @Override
    public Iterator<Function0<Seq<File>>> libjarsPaths() {
        return KuduDataStoreCommand.KuduDistributedCommand.libjarsPaths$(this);
    }

    @Override
    public scala.collection.immutable.Map<String, String> connection() {
        return KuduDataStoreCommand.connection$(this);
    }

    public void execute() {
        ExportCommand.execute$((ExportCommand)this);
    }

    public Option export(DataStore ds, Query query, FeatureExporter exporter, boolean writeEmptyFiles) {
        return ExportCommand.export$((ExportCommand)this, (DataStore)ds, (Query)query, (FeatureExporter)exporter, (boolean)writeEmptyFiles);
    }

    public void configure(Job job, DataStore ds, Query query) {
        ExportCommand.configure$((ExportCommand)this, (Job)job, (DataStore)ds, (Query)query);
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, (String)message, code);
    }

    public Object console() {
        return package.InteractiveCommand.console$((package.InteractiveCommand)this);
    }

    public void setConsole(Object c) {
        package.InteractiveCommand.setConsole$((package.InteractiveCommand)this, (Object)c);
    }

    public <T> T withDataStore(Function1<KuduDataStore, T> method) throws ParameterException {
        return (T)package.DataStoreCommand.withDataStore$((package.DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return package.DataStoreCommand.loadDataStore$((package.DataStoreCommand)this);
    }

    public Seq<package.Command> subCommands() {
        return package.Command.subCommands$((package.Command)this);
    }

    public Option<ParameterException> validate() {
        return package.Command.validate$((package.Command)this);
    }

    public void run() {
        package.Command.run$((package.Command)this);
    }

    public String name() {
        return this.name;
    }

    public void org$locationtech$geomesa$tools$export$ExportCommand$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    private Logger logger$lzycompute() {
        KuduExportCommand kuduExportCommand = this;
        synchronized (kuduExportCommand) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public Object org$locationtech$geomesa$tools$InteractiveCommand$$_console() {
        return this.org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    }

    public void org$locationtech$geomesa$tools$InteractiveCommand$$_console_$eq(Object x$1) {
        this.org$locationtech$geomesa$tools$InteractiveCommand$$_console = x$1;
    }

    @Override
    public KuduExportParams params() {
        return this.params;
    }

    public KuduExportCommand() {
        package.Command.$init$((package.Command)this);
        package.DataStoreCommand.$init$((package.DataStoreCommand)this);
        package.DistributedCommand.$init$((package.DistributedCommand)this);
        package.InteractiveCommand.$init$((package.InteractiveCommand)this);
        LazyLogging.$init$((LazyLogging)this);
        MethodProfiling.$init$((MethodProfiling)this);
        ExportCommand.$init$((ExportCommand)this);
        KuduDataStoreCommand.$init$(this);
        KuduDataStoreCommand.KuduDistributedCommand.$init$(this);
        this.params = new KuduExportParams();
    }

    @Parameters(commandDescription="Export features from a GeoMesa data store")
    public static class KuduExportParams
    implements ExportCommand.ExportParams,
    KuduDataStoreCommand.KuduParams,
    RequiredTypeNameParam,
    OptionalIndexParam {
        @Parameter(names={"--index"}, description="Specify a particular GeoMesa index", required=false)
        private String index;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"-M", "--master"}, description="Kudu master server", required=true)
        private String master;
        @Parameter(names={"--boss-threads"}, description="Kudu client boss threads")
        private Integer bosses;
        @Parameter(names={"--worker-threads"}, description="Kudu client worker threads")
        private Integer workers;
        @Parameter(names={"--disable-statistics"}, description="Disable Kudu client statistics", arity=0)
        private Boolean statistics;
        @Parameter(names={"-p", "--password"}, description="Connection password")
        private String password;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"-o", "--output"}, description="Output to a file instead of std out")
        private String file;
        @Parameter(names={"--gzip"}, description="Level of gzip compression to apply to output, from 1-9")
        private Integer gzip;
        @Parameter(names={"--no-header"}, description="Export as a delimited text format (csv|tsv) without a type header")
        private boolean noHeader;
        @Parameter(names={"--suppress-empty"}, description="Suppress all output (headers, etc) if there are no features exported")
        private boolean suppressEmpty;
        @Parameter(names={"-m", "--max-features"}, description="Restrict the maximum number of features returned")
        private Integer maxFeatures;
        @Parameter(names={"--attribute"}, description="Attributes or derived expressions to export, or 'id' to include the feature ID", splitter=NoopParameterSplitter.class)
        private List<String> transforms;
        @Parameter(names={"-a", "--attributes"}, description="Comma-separated attributes to export, or 'id' to include the feature ID")
        private List<String> attributes;
        @Parameter(names={"--sort-by"}, description="Sort by the specified attributes (comma-delimited)")
        private List<String> sortFields;
        @Parameter(names={"--sort-descending"}, description="Sort in descending order, instead of ascending", arity=0)
        private boolean sortDescending;
        @Parameter(names={"--chunk-size"}, description="Split the output into multiple files, by specifying the rough number of bytes to store per file", converter=ParameterConverters.BytesConverter.class)
        private Long chunkSize;
        @Parameter(names={"-F", "--output-format"}, description="File format of output files (csv|tsv|gml|json|shp|avro|avro-native|leaflet|orc|parquet|arrow)", converter=ParameterConverters.ExportFormatConverter.class)
        private ExportFormat explicitOutputFormat;
        private ExportFormat outputFormat;
        @Parameter(names={"--force"}, description="Force execution without prompt")
        private boolean force;
        @Parameter(names={"--num-reducers"}, description="Number of reducers to use when sorting or merging (for distributed jobs)", validateWith={PositiveInteger.class})
        private Integer reducers;
        @Parameter(names={"--run-mode"}, description="Run locally or on a cluster", required=false)
        private String runMode;
        private Option<Enumeration.Value> mode;
        @Parameter(names={"--hints"}, description="Query hints to set, in the form key1=value1;key2=value2", required=false, converter=ParameterConverters.HintConverter.class)
        private Map<String, String> hints;
        @Parameter(names={"-q", "--cql"}, description="CQL predicate", converter=ParameterConverters.FilterConverter.class)
        private Filter cqlFilter;
        private volatile byte bitmap$0;

        public <DS extends GeoMesaDataStore<DS>> Option<GeoMesaFeatureIndex<?, ?>> loadIndex(DS ds, String typeName, IndexMode.IndexMode mode) throws ParameterException {
            return OptionalIndexParam.loadIndex$((OptionalIndexParam)this, ds, (String)typeName, (IndexMode.IndexMode)mode);
        }

        public String index() {
            return this.index;
        }

        public void index_$eq(String x$1) {
            this.index = x$1;
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        @Override
        public String master() {
            return this.master;
        }

        @Override
        public void master_$eq(String x$1) {
            this.master = x$1;
        }

        @Override
        public Integer bosses() {
            return this.bosses;
        }

        @Override
        public void bosses_$eq(Integer x$1) {
            this.bosses = x$1;
        }

        @Override
        public Integer workers() {
            return this.workers;
        }

        @Override
        public void workers_$eq(Integer x$1) {
            this.workers = x$1;
        }

        @Override
        public Boolean statistics() {
            return this.statistics;
        }

        @Override
        public void statistics_$eq(Boolean x$1) {
            this.statistics = x$1;
        }

        public String password() {
            return this.password;
        }

        public void password_$eq(String x$1) {
            this.password = x$1;
        }

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        public String file() {
            return this.file;
        }

        public void file_$eq(String x$1) {
            this.file = x$1;
        }

        public Integer gzip() {
            return this.gzip;
        }

        public void gzip_$eq(Integer x$1) {
            this.gzip = x$1;
        }

        public boolean noHeader() {
            return this.noHeader;
        }

        public void noHeader_$eq(boolean x$1) {
            this.noHeader = x$1;
        }

        public boolean suppressEmpty() {
            return this.suppressEmpty;
        }

        public void suppressEmpty_$eq(boolean x$1) {
            this.suppressEmpty = x$1;
        }

        public Integer maxFeatures() {
            return this.maxFeatures;
        }

        public void maxFeatures_$eq(Integer x$1) {
            this.maxFeatures = x$1;
        }

        public List<String> transforms() {
            return this.transforms;
        }

        public void transforms_$eq(List<String> x$1) {
            this.transforms = x$1;
        }

        public List<String> attributes() {
            return this.attributes;
        }

        public void attributes_$eq(List<String> x$1) {
            this.attributes = x$1;
        }

        public List<String> sortFields() {
            return this.sortFields;
        }

        public void sortFields_$eq(List<String> x$1) {
            this.sortFields = x$1;
        }

        public boolean sortDescending() {
            return this.sortDescending;
        }

        public void sortDescending_$eq(boolean x$1) {
            this.sortDescending = x$1;
        }

        public Long chunkSize() {
            return this.chunkSize;
        }

        public void chunkSize_$eq(Long x$1) {
            this.chunkSize = x$1;
        }

        public ExportFormat explicitOutputFormat() {
            return this.explicitOutputFormat;
        }

        public void explicitOutputFormat_$eq(ExportFormat x$1) {
            this.explicitOutputFormat = x$1;
        }

        private ExportFormat outputFormat$lzycompute() {
            KuduExportParams kuduExportParams = this;
            synchronized (kuduExportParams) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.outputFormat = ExportCommand.ExportParams.outputFormat$((ExportCommand.ExportParams)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.outputFormat;
        }

        public ExportFormat outputFormat() {
            return (byte)(this.bitmap$0 & 1) == 0 ? this.outputFormat$lzycompute() : this.outputFormat;
        }

        public boolean force() {
            return this.force;
        }

        public void force_$eq(boolean x$1) {
            this.force = x$1;
        }

        public Integer reducers() {
            return this.reducers;
        }

        public void reducers_$eq(Integer x$1) {
            this.reducers = x$1;
        }

        public String runMode() {
            return this.runMode;
        }

        public void runMode_$eq(String x$1) {
            this.runMode = x$1;
        }

        private Option<Enumeration.Value> mode$lzycompute() {
            KuduExportParams kuduExportParams = this;
            synchronized (kuduExportParams) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.mode = DistributedRunParam.mode$((DistributedRunParam)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.mode;
        }

        public Option<Enumeration.Value> mode() {
            return (byte)(this.bitmap$0 & 2) == 0 ? this.mode$lzycompute() : this.mode;
        }

        public Map<String, String> hints() {
            return this.hints;
        }

        public void hints_$eq(Map<String, String> x$1) {
            this.hints = x$1;
        }

        public Filter cqlFilter() {
            return this.cqlFilter;
        }

        public void cqlFilter_$eq(Filter x$1) {
            this.cqlFilter = x$1;
        }

        public KuduExportParams() {
            OptionalCqlFilterParam.$init$((OptionalCqlFilterParam)this);
            QueryHintsParams.$init$((QueryHintsParams)this);
            DistributedRunParam.$init$((DistributedRunParam)this);
            NumReducersParam.$init$((NumReducersParam)this);
            OptionalForceParam.$init$((OptionalForceParam)this);
            ExportCommand.ExportParams.$init$((ExportCommand.ExportParams)this);
            CatalogParam.$init$((CatalogParam)this);
            PasswordParams.$init$((PasswordParams)this);
            KuduDataStoreCommand.KuduParams.$init$(this);
            RequiredTypeNameParam.$init$((RequiredTypeNameParam)this);
            OptionalIndexParam.$init$((OptionalIndexParam)this);
        }
    }
}

