/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.lambda.data;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.time.Clock;
import java.util.List;
import kafka.admin.AdminUtils$;
import kafka.utils.ZkUtils;
import org.apache.kafka.clients.producer.Producer;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureReader;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureWriter;
import org.geotools.feature.FeatureTypes;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureReader$;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureStore;
import org.locationtech.geomesa.index.planning.QueryRunner;
import org.locationtech.geomesa.index.stats.GeoMesaStats;
import org.locationtech.geomesa.index.stats.package;
import org.locationtech.geomesa.kafka.AdminUtilsVersions$;
import org.locationtech.geomesa.lambda.data.LambdaDataStore$;
import org.locationtech.geomesa.lambda.data.LambdaFeatureWriter;
import org.locationtech.geomesa.lambda.data.LambdaQueryRunner;
import org.locationtech.geomesa.lambda.data.LambdaStats;
import org.locationtech.geomesa.lambda.stream.OffsetManager;
import org.locationtech.geomesa.lambda.stream.TransientStore;
import org.locationtech.geomesa.lambda.stream.kafka.KafkaStore;
import org.locationtech.geomesa.lambda.stream.kafka.KafkaStore$;
import org.locationtech.geomesa.security.AuthorizationsProvider;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.geotools.FeatureUtils$;
import org.locationtech.geomesa.utils.io.IsCloseable;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r}h\u0001B\u0001\u0003\u00015\u0011q\u0002T1nE\u0012\fG)\u0019;b'R|'/\u001a\u0006\u0003\u0007\u0011\tA\u0001Z1uC*\u0011QAB\u0001\u0007Y\u0006l'\rZ1\u000b\u0005\u001dA\u0011aB4f_6,7/\u0019\u0006\u0003\u0013)\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011aC\u0001\u0004_J<7\u0001A\n\u0006\u000191R$\u000e\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001\\1oO*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u0011\u0005\u0019y%M[3diB\u0011qcG\u0007\u00021)\u00111!\u0007\u0006\u00035)\t\u0001bZ3pi>|Gn]\u0005\u00039a\u0011\u0011\u0002R1uCN#xN]3\u0011\u0005y\u0011dBA\u00100\u001d\t\u0001CF\u0004\u0002\"U9\u0011!%\u000b\b\u0003G!r!\u0001J\u0014\u000e\u0003\u0015R!A\n\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002,\r\u0005)\u0011N\u001c3fq&\u0011QFL\u0001\u0006gR\fGo\u001d\u0006\u0003W\u0019I!\u0001M\u0019\u0002\u000fA\f7m[1hK*\u0011QFL\u0005\u0003gQ\u0012q\u0002S1t\u000f\u0016|W*Z:b'R\fGo\u001d\u0006\u0003aE\u0002\"AN\u001f\u000e\u0003]R!\u0001O\u001d\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005iZ\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003q\n1aY8n\u0013\tqtGA\u0006MCjLHj\\4hS:<\u0007\u0002\u0003!\u0001\u0005\u000b\u0007I\u0011A!\u0002\u0017A,'o]5ti\u0016t7-Z\u000b\u0002-!A1\t\u0001B\u0001B\u0003%a#\u0001\u0007qKJ\u001c\u0018n\u001d;f]\u000e,\u0007\u0005\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0003!\u0001(o\u001c3vG\u0016\u0014\b\u0003B$P#Fk\u0011\u0001\u0013\u0006\u0003\u000b&S!AS&\u0002\u000f\rd\u0017.\u001a8ug*\u0011A*T\u0001\u0006W\u000647.\u0019\u0006\u0003\u001d*\ta!\u00199bG\",\u0017B\u0001)I\u0005!\u0001&o\u001c3vG\u0016\u0014\bc\u0001*V/6\t1KC\u0001U\u0003\u0015\u00198-\u00197b\u0013\t16KA\u0003BeJ\f\u0017\u0010\u0005\u0002S1&\u0011\u0011l\u0015\u0002\u0005\u0005f$X\r\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003]\u00039\u0019wN\\:v[\u0016\u00148i\u001c8gS\u001e\u0004B!\u00181dG:\u0011!KX\u0005\u0003?N\u000ba\u0001\u0015:fI\u00164\u0017BA1c\u0005\ri\u0015\r\u001d\u0006\u0003?N\u0003\"!\u00183\n\u0005\u0015\u0014'AB*ue&tw\r\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003i\u00035ygMZ:fi6\u000bg.Y4feB\u0011\u0011\u000e\\\u0007\u0002U*\u00111\u000eB\u0001\u0007gR\u0014X-Y7\n\u00055T'!D(gMN,G/T1oC\u001e,'\u000f\u0003\u0005p\u0001\t\u0005\t\u0015!\u0003q\u0003\u0019\u0019wN\u001c4jOB\u0019\u0011/!\u0002\u000f\u0005I4hBA:v\u001d\t\tC/\u0003\u0002\u0006\r%\u00111\u0001B\u0004\u0006o\nA\t\u0001_\u0001\u0010\u0019\u0006l'\rZ1ECR\f7\u000b^8sKB\u0011\u0011P_\u0007\u0002\u0005\u0019)\u0011A\u0001E\u0001wN\u0011!\u0010 \t\u0003%vL!A`*\u0003\r\u0005s\u0017PU3g\u0011\u001d\t\tA\u001fC\u0001\u0003\u0007\ta\u0001P5oSRtD#\u0001=\u0007\r\u0005\u001d!\u0010QA\u0005\u00051a\u0015-\u001c2eC\u000e{gNZ5h'\u001d\t)\u0001`A\u0006\u0003#\u00012AUA\u0007\u0013\r\tya\u0015\u0002\b!J|G-^2u!\r\u0011\u00161C\u0005\u0004\u0003+\u0019&\u0001D*fe&\fG.\u001b>bE2,\u0007bCA\r\u0003\u000b\u0011)\u001a!C\u0001\u00037\t!B_8pW\u0016,\u0007/\u001a:t+\u0005\u0019\u0007BCA\u0010\u0003\u000b\u0011\t\u0012)A\u0005G\u0006Y!p\\8lK\u0016\u0004XM]:!\u0011-\t\u0019#!\u0002\u0003\u0016\u0004%\t!a\u0007\u0002\u0017i\\g*Y7fgB\f7-\u001a\u0005\u000b\u0003O\t)A!E!\u0002\u0013\u0019\u0017\u0001\u0004>l\u001d\u0006lWm\u001d9bG\u0016\u0004\u0003bCA\u0016\u0003\u000b\u0011)\u001a!C\u0001\u0003[\t!\u0002]1si&$\u0018n\u001c8t+\t\ty\u0003E\u0002S\u0003cI1!a\rT\u0005\rIe\u000e\u001e\u0005\f\u0003o\t)A!E!\u0002\u0013\ty#A\u0006qCJ$\u0018\u000e^5p]N\u0004\u0003bCA\u001e\u0003\u000b\u0011)\u001a!C\u0001\u0003[\t\u0011bY8ogVlWM]:\t\u0017\u0005}\u0012Q\u0001B\tB\u0003%\u0011qF\u0001\u000bG>t7/^7feN\u0004\u0003bCA\"\u0003\u000b\u0011)\u001a!C\u0001\u0003\u000b\na!\u001a=qSJLXCAA$!\u0011\tI%a\u0015\u000e\u0005\u0005-#\u0002BA'\u0003\u001f\n\u0001\u0002Z;sCRLwN\u001c\u0006\u0004\u0003#\u001a\u0016AC2p]\u000e,(O]3oi&!\u0011QKA&\u0005!!UO]1uS>t\u0007bCA-\u0003\u000b\u0011\t\u0012)A\u0005\u0003\u000f\nq!\u001a=qSJL\b\u0005C\u0006\u0002^\u0005\u0015!Q3A\u0005\u0002\u0005}\u0013a\u00029feNL7\u000f^\u000b\u0003\u0003C\u00022AUA2\u0013\r\t)g\u0015\u0002\b\u0005>|G.Z1o\u0011-\tI'!\u0002\u0003\u0012\u0003\u0006I!!\u0019\u0002\u0011A,'o]5ti\u0002B\u0001\"!\u0001\u0002\u0006\u0011\u0005\u0011Q\u000e\u000b\u000f\u0003_\n\u0019(!\u001e\u0002x\u0005e\u00141PA?!\u0011\t\t(!\u0002\u000e\u0003iDq!!\u0007\u0002l\u0001\u00071\rC\u0004\u0002$\u0005-\u0004\u0019A2\t\u0011\u0005-\u00121\u000ea\u0001\u0003_A\u0001\"a\u000f\u0002l\u0001\u0007\u0011q\u0006\u0005\t\u0003\u0007\nY\u00071\u0001\u0002H!A\u0011QLA6\u0001\u0004\t\t\u0007\u0003\u0006\u0002\u0002\u0006\u0015\u0011\u0011!C\u0001\u0003\u0007\u000bAaY8qsRq\u0011qNAC\u0003\u000f\u000bI)a#\u0002\u000e\u0006=\u0005\"CA\r\u0003\u007f\u0002\n\u00111\u0001d\u0011%\t\u0019#a \u0011\u0002\u0003\u00071\r\u0003\u0006\u0002,\u0005}\u0004\u0013!a\u0001\u0003_A!\"a\u000f\u0002\u0000A\u0005\t\u0019AA\u0018\u0011)\t\u0019%a \u0011\u0002\u0003\u0007\u0011q\t\u0005\u000b\u0003;\ny\b%AA\u0002\u0005\u0005\u0004BCAJ\u0003\u000b\t\n\u0011\"\u0001\u0002\u0016\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAALU\r\u0019\u0017\u0011T\u0016\u0003\u00037\u0003B!!(\u0002(6\u0011\u0011q\u0014\u0006\u0005\u0003C\u000b\u0019+A\u0005v]\u000eDWmY6fI*\u0019\u0011QU*\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002*\u0006}%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q\u0011QVA\u0003#\u0003%\t!!&\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!Q\u0011\u0011WA\u0003#\u0003%\t!a-\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u0017\u0016\u0005\u0003_\tI\n\u0003\u0006\u0002:\u0006\u0015\u0011\u0013!C\u0001\u0003g\u000babY8qs\u0012\"WMZ1vYR$C\u0007\u0003\u0006\u0002>\u0006\u0015\u0011\u0013!C\u0001\u0003\u007f\u000babY8qs\u0012\"WMZ1vYR$S'\u0006\u0002\u0002B*\"\u0011qIAM\u0011)\t)-!\u0002\u0012\u0002\u0013\u0005\u0011qY\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137+\t\tIM\u000b\u0003\u0002b\u0005e\u0005BCAg\u0003\u000b\t\t\u0011\"\u0011\u0002P\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!5\u0011\u0007=\t\u0019.\u0003\u0002f!!Q\u0011q[A\u0003\u0003\u0003%\t!!\f\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0015\u0005m\u0017QAA\u0001\n\u0003\ti.\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005}\u0017Q\u001d\t\u0004%\u0006\u0005\u0018bAAr'\n\u0019\u0011I\\=\t\u0015\u0005\u001d\u0018\u0011\\A\u0001\u0002\u0004\ty#A\u0002yIEB!\"a;\u0002\u0006\u0005\u0005I\u0011IAw\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAx!\u0019\t\t0a>\u0002`6\u0011\u00111\u001f\u0006\u0004\u0003k\u001c\u0016AC2pY2,7\r^5p]&!\u0011\u0011`Az\u0005!IE/\u001a:bi>\u0014\bBCA\u007f\u0003\u000b\t\t\u0011\"\u0001\u0002\u0000\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002b\t\u0005\u0001BCAt\u0003w\f\t\u00111\u0001\u0002`\"Q!QAA\u0003\u0003\u0003%\tEa\u0002\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\f\t\u0015\t-\u0011QAA\u0001\n\u0003\u0012i!\u0001\u0005u_N#(/\u001b8h)\t\t\t\u000e\u0003\u0006\u0003\u0012\u0005\u0015\u0011\u0011!C!\u0005'\ta!Z9vC2\u001cH\u0003BA1\u0005+A!\"a:\u0003\u0010\u0005\u0005\t\u0019AAp\u000f%\u0011IB_A\u0001\u0012\u0003\u0011Y\"\u0001\u0007MC6\u0014G-Y\"p]\u001aLw\r\u0005\u0003\u0002r\tua!CA\u0004u\u0006\u0005\t\u0012\u0001B\u0010'\u0019\u0011iB!\t\u0002\u0012A\u0001\"1\u0005B\u0015G\u000e\fy#a\f\u0002H\u0005\u0005\u0014qN\u0007\u0003\u0005KQ1Aa\nT\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\u000b\u0003&\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001c\t\u0011\u0005\u0005!Q\u0004C\u0001\u0005_!\"Aa\u0007\t\u0015\t-!QDA\u0001\n\u000b\u0012i\u0001\u0003\u0006\u00036\tu\u0011\u0011!CA\u0005o\tQ!\u00199qYf$b\"a\u001c\u0003:\tm\"Q\bB \u0005\u0003\u0012\u0019\u0005C\u0004\u0002\u001a\tM\u0002\u0019A2\t\u000f\u0005\r\"1\u0007a\u0001G\"A\u00111\u0006B\u001a\u0001\u0004\ty\u0003\u0003\u0005\u0002<\tM\u0002\u0019AA\u0018\u0011!\t\u0019Ea\rA\u0002\u0005\u001d\u0003\u0002CA/\u0005g\u0001\r!!\u0019\t\u0015\t\u001d#QDA\u0001\n\u0003\u0013I%A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t-#q\u000b\t\u0006%\n5#\u0011K\u0005\u0004\u0005\u001f\u001a&AB(qi&|g\u000eE\u0007S\u0005'\u001a7-a\f\u00020\u0005\u001d\u0013\u0011M\u0005\u0004\u0005+\u001a&A\u0002+va2,g\u0007\u0003\u0006\u0003Z\t\u0015\u0013\u0011!a\u0001\u0003_\n1\u0001\u001f\u00131\u0011)\u0011iF!\b\u0002\u0002\u0013%!qL\u0001\fe\u0016\fGMU3t_24X\rF\u0001\u000f\u0011%\u0011\u0019G_I\u0001\n\u0003\u0011)'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HE\u000e\u000b\r\u0005O\u0012)Ha\u001e\u0003z\tm$Q\u0010\u0016\u0005\u0005S\nI\n\u0005\u0003\u0003l\tETB\u0001B7\u0015\r\u0011yGE\u0001\u0005i&lW-\u0003\u0003\u0003t\t5$!B\"m_\u000e\\\u0007B\u0002!\u0003b\u0001\u0007a\u0003\u0003\u0004F\u0005C\u0002\rA\u0012\u0005\u00077\n\u0005\u0004\u0019\u0001/\t\r\u001d\u0014\t\u00071\u0001i\u0011\u001dy'\u0011\ra\u0001\u0003_B!B!!\u0001\u0005\u0003\u0005\u000b1\u0002B5\u0003\u0015\u0019Gn\\2l\u0011\u001d\t\t\u0001\u0001C\u0001\u0005\u000b#BBa\"\u0003\u000e\n=%\u0011\u0013BJ\u0005+#BA!#\u0003\fB\u0011\u0011\u0010\u0001\u0005\u000b\u0005\u0003\u0013\u0019\t%AA\u0004\t%\u0004B\u0002!\u0003\u0004\u0002\u0007a\u0003\u0003\u0004F\u0005\u0007\u0003\rA\u0012\u0005\u00077\n\r\u0005\u0019\u0001/\t\r\u001d\u0014\u0019\t1\u0001i\u0011\u0019y'1\u0011a\u0001a\"I!\u0011\u0014\u0001C\u0002\u0013%!1T\u0001\rCV$\b\u000e\u0015:pm&$WM]\u000b\u0003\u0005;\u0003RA\u0015B'\u0005?\u0003BA!)\u0003(6\u0011!1\u0015\u0006\u0004\u0005K3\u0011\u0001C:fGV\u0014\u0018\u000e^=\n\t\t%&1\u0015\u0002\u0017\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8t!J|g/\u001b3fe\"A!Q\u0016\u0001!\u0002\u0013\u0011i*A\u0007bkRD\u0007K]8wS\u0012,'\u000f\t\u0005\u000b\u0005c\u0003!\u0019!C\u0001\t\tM\u0016A\u0003;sC:\u001c\u0018.\u001a8ugV\u0011!Q\u0017\t\b\u0005o\u0013Im\u0019Bg\u001b\t\u0011IL\u0003\u0003\u0003<\nu\u0016!B2bG\",'\u0002\u0002B`\u0005\u0003\f\u0001bY1gM\u0016Lg.\u001a\u0006\u0005\u0005\u0007\u0014)-\u0001\u0005cK:l\u0017M\\3t\u0015\r\u00119mO\u0001\u0007O&$\b.\u001e2\n\t\t-'\u0011\u0018\u0002\r\u0019>\fG-\u001b8h\u0007\u0006\u001c\u0007.\u001a\t\u0004S\n=\u0017b\u0001BiU\nqAK]1og&,g\u000e^*u_J,\u0007\u0002\u0003Bk\u0001\u0001\u0006IA!.\u0002\u0017Q\u0014\u0018M\\:jK:$8\u000f\t\u0005\t[\u0001\u0011\r\u0011\"\u0011\u0003ZV\u0011!1\u001c\t\u0005\u0005;\u0014y.D\u00012\u0013\r\u0011\t/\r\u0002\r\u000f\u0016|W*Z:b'R\fGo\u001d\u0005\t\u0005K\u0004\u0001\u0015!\u0003\u0003\\\u000611\u000f^1ug\u0002B\u0011B!;\u0001\u0005\u0004%IAa;\u0002\rI,hN\\3s+\t\u0011i\u000fE\u0002z\u0005_L1A!=\u0003\u0005Ea\u0015-\u001c2eCF+XM]=Sk:tWM\u001d\u0005\t\u0005k\u0004\u0001\u0015!\u0003\u0003n\u00069!/\u001e8oKJ\u0004\u0003bBA/\u0001\u0011\u0005!\u0011 \u000b\u0005\u0005w\u001c\t\u0001E\u0002S\u0005{L1Aa@T\u0005\u0011)f.\u001b;\t\u000f\r\r!q\u001fa\u0001G\u0006AA/\u001f9f\u001d\u0006lW\rC\u0004\u0004\b\u0001!\te!\u0003\u0002\u0019\u001d,G\u000fV=qK:\u000bW.Z:\u0015\u0005\r-\u0001c\u0001*VG\"91q\u0002\u0001\u0005B\rE\u0011\u0001C4fi:\u000bW.Z:\u0015\u0005\rM\u0001CBB\u000b\u00077\u0019y\"\u0004\u0002\u0004\u0018)\u00191\u0011\u0004\n\u0002\tU$\u0018\u000e\\\u0005\u0005\u0007;\u00199B\u0001\u0003MSN$\b\u0003BB\u0011\u0007_i!aa\t\u000b\t\r\u00152qE\u0001\u0005if\u0004XM\u0003\u0003\u0004*\r-\u0012a\u00024fCR,(/\u001a\u0006\u0004\u0007[Q\u0011aB8qK:<\u0017n]\u0005\u0005\u0007c\u0019\u0019C\u0001\u0003OC6,\u0007bBB\u001b\u0001\u0011\u00053qG\u0001\rGJ,\u0017\r^3TG\",W.\u0019\u000b\u0005\u0005w\u001cI\u0004\u0003\u0005\u0004<\rM\u0002\u0019AB\u001f\u0003\r\u0019h\r\u001e\t\u0005\u0007\u007f\u0019)%\u0004\u0002\u0004B)!11IB\u0014\u0003\u0019\u0019\u0018.\u001c9mK&!1qIB!\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/\u001a\u0005\b\u0007\u0017\u0002A\u0011IB'\u0003%9W\r^*dQ\u0016l\u0017\r\u0006\u0003\u0004>\r=\u0003\u0002CB\u0002\u0007\u0013\u0002\raa\b\t\u000f\r-\u0003\u0001\"\u0011\u0004TQ!1QHB+\u0011\u001d\u0019\u0019a!\u0015A\u0002\rDqa!\u0017\u0001\t\u0003\u001aY&\u0001\u0007va\u0012\fG/Z*dQ\u0016l\u0017\r\u0006\u0004\u0003|\u000eu3q\f\u0005\t\u0007\u0007\u00199\u00061\u0001\u0004 !A1\u0011MB,\u0001\u0004\u0019i$A\u0006gK\u0006$XO]3UsB,\u0007bBB-\u0001\u0011\u00053Q\r\u000b\u0007\u0005w\u001c9g!\u001b\t\u000f\r\r11\ra\u0001G\"A1\u0011MB2\u0001\u0004\u0019i\u0004C\u0004\u0004n\u0001!\tea\u001c\u0002\u0019I,Wn\u001c<f'\u000eDW-\\1\u0015\t\tm8\u0011\u000f\u0005\t\u0007\u0007\u0019Y\u00071\u0001\u0004 !91Q\u000e\u0001\u0005B\rUD\u0003\u0002B~\u0007oBqaa\u0001\u0004t\u0001\u00071\rC\u0004\u0004|\u0001!\te! \u0002!\u001d,GOR3biV\u0014XmU8ve\u000e,G\u0003BB@\u0007\u0013\u0003Ba!!\u0004\u00066\u001111\u0011\u0006\u0004\u0007\u0007B\u0012\u0002BBD\u0007\u0007\u00131cU5na2,g)Z1ukJ,7k\\;sG\u0016D\u0001ba\u0001\u0004z\u0001\u00071q\u0004\u0005\b\u0007w\u0002A\u0011IBG)\u0011\u0019yha$\t\u000f\r\r11\u0012a\u0001G\"911\u0013\u0001\u0005B\rU\u0015\u0001E4fi\u001a+\u0017\r^;sKJ+\u0017\rZ3s)\u0019\u00199j!(\u0004(B!1\u0011QBM\u0013\u0011\u0019Yja!\u0003'MKW\u000e\u001d7f\r\u0016\fG/\u001e:f%\u0016\fG-\u001a:\t\u0011\r}5\u0011\u0013a\u0001\u0007C\u000bQ!];fef\u00042aFBR\u0013\r\u0019)\u000b\u0007\u0002\u0006#V,'/\u001f\u0005\t\u0007S\u001b\t\n1\u0001\u0004,\u0006YAO]1og\u0006\u001cG/[8o!\r92QV\u0005\u0004\u0007_C\"a\u0003+sC:\u001c\u0018m\u0019;j_:Dqaa-\u0001\t\u0003\u001a),\u0001\fhKR4U-\u0019;ve\u0016<&/\u001b;fe\u0006\u0003\b/\u001a8e)\u0019\u00199l!0\u0004@B!1\u0011QB]\u0013\u0011\u0019Yla!\u0003'MKW\u000e\u001d7f\r\u0016\fG/\u001e:f/JLG/\u001a:\t\u000f\r\r1\u0011\u0017a\u0001G\"A1\u0011VBY\u0001\u0004\u0019Y\u000bC\u0004\u0004D\u0002!\te!2\u0002!\u001d,GOR3biV\u0014Xm\u0016:ji\u0016\u0014HCBB\\\u0007\u000f\u001cI\rC\u0004\u0004\u0004\r\u0005\u0007\u0019A2\t\u0011\r%6\u0011\u0019a\u0001\u0007WCqaa1\u0001\t\u0003\u001ai\r\u0006\u0005\u00048\u000e=7\u0011[Bp\u0011\u001d\u0019\u0019aa3A\u0002\rD\u0001ba5\u0004L\u0002\u00071Q[\u0001\u0007M&dG/\u001a:\u0011\t\r]71\\\u0007\u0003\u00073TAaa5\u0004,%!1Q\\Bm\u0005\u00191\u0015\u000e\u001c;fe\"A1\u0011VBf\u0001\u0004\u0019Y\u000bC\u0004\u0004d\u0002!\te!:\u0002\u000f\u0011L7\u000f]8tKR\u0011!1 \u0005\b\u0007S\u0004A\u0011IBv\u0003\u001d9W\r^%oM>$\"a!<\u0011\u0007]\u0019y/C\u0002\u0004rb\u00111bU3sm&\u001cW-\u00138g_\"91Q\u001f\u0001\u0005B\r]\u0018!E4fi2{7m[5oO6\u000bg.Y4feR\u00111\u0011 \t\u0004/\rm\u0018bAB\u007f1\tqAj\\2lS:<W*\u00198bO\u0016\u0014\b")
public class LambdaDataStore
implements DataStore,
package.HasGeoMesaStats,
LazyLogging {
    private final DataStore persistence;
    public final Producer<byte[], byte[]> org$locationtech$geomesa$lambda$data$LambdaDataStore$$producer;
    public final Map<String, String> org$locationtech$geomesa$lambda$data$LambdaDataStore$$consumerConfig;
    public final OffsetManager org$locationtech$geomesa$lambda$data$LambdaDataStore$$offsetManager;
    public final LambdaConfig org$locationtech$geomesa$lambda$data$LambdaDataStore$$config;
    public final Clock org$locationtech$geomesa$lambda$data$LambdaDataStore$$clock;
    private final Option<AuthorizationsProvider> org$locationtech$geomesa$lambda$data$LambdaDataStore$$authProvider;
    private final LoadingCache<String, TransientStore> transients;
    private final GeoMesaStats stats;
    private final LambdaQueryRunner runner;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static Clock $lessinit$greater$default$6(DataStore dataStore, Producer<byte[], byte[]> producer2, Map<String, String> map, OffsetManager offsetManager, LambdaConfig lambdaConfig) {
        return LambdaDataStore$.MODULE$.$lessinit$greater$default$6(dataStore, producer2, map, offsetManager, lambdaConfig);
    }

    private Logger logger$lzycompute() {
        LambdaDataStore lambdaDataStore = this;
        synchronized (lambdaDataStore) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public DataStore persistence() {
        return this.persistence;
    }

    public Option<AuthorizationsProvider> org$locationtech$geomesa$lambda$data$LambdaDataStore$$authProvider() {
        return this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$authProvider;
    }

    public LoadingCache<String, TransientStore> transients() {
        return this.transients;
    }

    public GeoMesaStats stats() {
        return this.stats;
    }

    private LambdaQueryRunner runner() {
        return this.runner;
    }

    public void persist(String typeName) {
        ((TransientStore)this.transients().get((Object)typeName)).persist();
    }

    public String[] getTypeNames() {
        return this.persistence().getTypeNames();
    }

    public List<Name> getNames() {
        return this.persistence().getNames();
    }

    public void createSchema(SimpleFeatureType sft) {
        this.persistence().createSchema((FeatureType)sft);
        String topic = KafkaStore$.MODULE$.topic(this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$config.zkNamespace(), sft);
        KafkaStore$.MODULE$.withZk(this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$config.zookeepers(), new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LambdaDataStore $outer;
            private final String topic$1;

            public final void apply(ZkUtils zk) {
                if (AdminUtils$.MODULE$.topicExists(zk, this.topic$1)) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.logger().underlying().isWarnEnabled()) {
                        this.$outer.logger().underlying().warn("Topic [{}] already exists - it may contain stale data", new Object[]{this.topic$1});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    int replication = BoxesRunTime.unboxToInt((Object)new GeoMesaSystemProperties.SystemProperty("geomesa.kafka.replication", GeoMesaSystemProperties.SystemProperty$.MODULE$.apply$default$2()).option().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(String x$1) {
                            return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return 1;
                        }
                    }));
                    AdminUtilsVersions$.MODULE$.createTopic(zk, this.topic$1, this.$outer.org$locationtech$geomesa$lambda$data$LambdaDataStore$$config.partitions(), replication);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        });
    }

    public SimpleFeatureType getSchema(Name typeName) {
        return this.getSchema(typeName.getLocalPart());
    }

    /*
     * WARNING - void declaration
     */
    public SimpleFeatureType getSchema(String typeName) {
        void var2_2;
        SimpleFeatureType sft = this.persistence().getSchema(typeName);
        Object object = sft == null ? BoxedUnit.UNIT : this.transients().get((Object)typeName);
        return var2_2;
    }

    public void updateSchema(Name typeName, SimpleFeatureType featureType) {
        this.updateSchema(typeName.getLocalPart(), featureType);
    }

    public void updateSchema(String typeName, SimpleFeatureType featureType) {
        Object object;
        TransientStore transientStore = (TransientStore)this.transients().get((Object)typeName);
        String string = typeName;
        String string2 = featureType.getTypeName();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            object = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Update schema: entering quiet period");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Thread.sleep(((Duration)new GeoMesaSystemProperties.SystemProperty("geomesa.lambda.update.quiet.period", "10 seconds").toDuration().get()).toMillis());
            object = package.WithClose$.MODULE$.apply(transientStore.read(transientStore.read$default$1(), transientStore.read$default$2(), transientStore.read$default$3(), transientStore.read$default$4()), (Function1)new Serializable(this, typeName){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LambdaDataStore $outer;
                private final String typeName$1;

                public final void apply(CloseableIterator<SimpleFeature> toPersist) {
                    if (toPersist.nonEmpty()) {
                        BoxedUnit boxedUnit;
                        if (this.$outer.logger().underlying().isDebugEnabled()) {
                            this.$outer.logger().underlying().debug("Update schema: persisting transient features");
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        package.WithClose$.MODULE$.apply((Object)this.$outer.persistence().getFeatureWriter(this.typeName$1, Transaction.AUTO_COMMIT), (Function1)new Serializable(this, toPersist){
                            public static final long serialVersionUID = 0L;
                            private final CloseableIterator toPersist$1;

                            public final void apply(FeatureWriter<SimpleFeatureType, SimpleFeature> writer) {
                                this.toPersist$1.foreach((Function1)new Serializable(this, writer){
                                    public static final long serialVersionUID = 0L;
                                    private final FeatureWriter writer$1;

                                    public final SimpleFeature apply(SimpleFeature x$2) {
                                        return FeatureUtils$.MODULE$.write(this.writer$1, x$2, true);
                                    }
                                    {
                                        this.writer$1 = writer$1;
                                    }
                                });
                            }
                            {
                                this.toPersist$1 = toPersist$1;
                            }
                        }, IsCloseable$.MODULE$.closeableIsCloseable());
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.typeName$1 = typeName$1;
                }
            }, IsCloseable$.MODULE$.closeableIsCloseable());
        }
        package.CloseWithLogging$.MODULE$.apply((Object)transientStore, IsCloseable$.MODULE$.closeableIsCloseable());
        this.transients().invalidate((Object)typeName);
        this.persistence().updateSchema(typeName, featureType);
    }

    public void removeSchema(Name typeName) {
        this.removeSchema(typeName.getLocalPart());
    }

    public void removeSchema(String typeName) {
        TransientStore transientStore = (TransientStore)this.transients().get((Object)typeName);
        transientStore.removeSchema();
        package.CloseWithLogging$.MODULE$.apply((Object)transientStore, IsCloseable$.MODULE$.closeableIsCloseable());
        this.transients().invalidate((Object)typeName);
        this.persistence().removeSchema(typeName);
    }

    public SimpleFeatureSource getFeatureSource(Name typeName) {
        return this.getFeatureSource(typeName.getLocalPart());
    }

    public SimpleFeatureSource getFeatureSource(String typeName) {
        return new GeoMesaFeatureStore((DataStore)this, this.getSchema(typeName), (QueryRunner)this.runner());
    }

    public SimpleFeatureReader getFeatureReader(Query query, Transaction transaction) {
        return GeoMesaFeatureReader$.MODULE$.apply(this.getSchema(query.getTypeName()), query, (QueryRunner)this.runner(), (Option)None$.MODULE$, (Option)None$.MODULE$);
    }

    public SimpleFeatureWriter getFeatureWriterAppend(String typeName, Transaction transaction) {
        return new LambdaFeatureWriter.AppendLambdaFeatureWriter((TransientStore)this.transients().get((Object)typeName));
    }

    public SimpleFeatureWriter getFeatureWriter(String typeName, Transaction transaction) {
        return this.getFeatureWriter(typeName, (Filter)Filter.INCLUDE, transaction);
    }

    public SimpleFeatureWriter getFeatureWriter(String typeName, Filter filter2, Transaction transaction) {
        Query query = new Query(typeName, filter2);
        SelfClosingIterator features2 = SelfClosingIterator$.MODULE$.apply((FeatureReader)this.getFeatureReader(query, transaction));
        return new LambdaFeatureWriter.ModifyLambdaFeatureWriter((TransientStore)this.transients().get((Object)typeName), (CloseableIterator<SimpleFeature>)features2);
    }

    public void dispose() {
        package.CloseWithLogging$.MODULE$.apply((Object)((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.transients().asMap()).asScala()).values(), (IsCloseable)IsCloseable$.MODULE$.iterableIsCloseable());
        this.transients().invalidateAll();
        package.CloseWithLogging$.MODULE$.apply((Object)this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$offsetManager, IsCloseable$.MODULE$.closeableIsCloseable());
        package.CloseWithLogging$.MODULE$.apply(this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$producer, IsCloseable$.MODULE$.closeableIsCloseable());
        this.persistence().dispose();
    }

    /*
     * WARNING - void declaration
     */
    public ServiceInfo getInfo() {
        void var1_1;
        DefaultServiceInfo info = new DefaultServiceInfo();
        info.setDescription(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Features from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass().getSimpleName()})));
        info.setSchema(FeatureTypes.DEFAULT_NAMESPACE);
        return var1_1;
    }

    public LockingManager getLockingManager() {
        return null;
    }

    public LambdaDataStore(DataStore persistence, Producer<byte[], byte[]> producer2, Map<String, String> consumerConfig, OffsetManager offsetManager, LambdaConfig config, Clock clock) {
        Object object;
        None$ none$;
        this.persistence = persistence;
        this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$producer = producer2;
        this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$consumerConfig = consumerConfig;
        this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$offsetManager = offsetManager;
        this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$config = config;
        this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$clock = clock;
        LazyLogging.class.$init$((LazyLogging)this);
        DataStore dataStore = persistence;
        if (dataStore instanceof AccumuloDataStore) {
            AccumuloDataStore accumuloDataStore = (AccumuloDataStore)dataStore;
            none$ = new Some((Object)accumuloDataStore.config().authProvider());
        } else {
            none$ = None$.MODULE$;
        }
        this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$authProvider = none$;
        this.transients = Caffeine.newBuilder().build((CacheLoader)new CacheLoader<String, TransientStore>(this){
            private final /* synthetic */ LambdaDataStore $outer;

            public TransientStore load(String key) {
                SimpleFeatureType sft = this.$outer.persistence().getSchema(key);
                return new KafkaStore(this.$outer.persistence(), sft, this.$outer.org$locationtech$geomesa$lambda$data$LambdaDataStore$$authProvider(), this.$outer.org$locationtech$geomesa$lambda$data$LambdaDataStore$$offsetManager, this.$outer.org$locationtech$geomesa$lambda$data$LambdaDataStore$$producer, this.$outer.org$locationtech$geomesa$lambda$data$LambdaDataStore$$consumerConfig, this.$outer.org$locationtech$geomesa$lambda$data$LambdaDataStore$$config, this.$outer.org$locationtech$geomesa$lambda$data$LambdaDataStore$$clock);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        DataStore dataStore2 = persistence;
        if (dataStore2 instanceof package.HasGeoMesaStats) {
            DataStore dataStore3 = dataStore2;
            object = new LambdaStats(((package.HasGeoMesaStats)dataStore3).stats(), this.transients());
        } else {
            object = package.NoopStats$.MODULE$;
        }
        this.stats = object;
        this.runner = new LambdaQueryRunner(this, persistence, this.transients());
    }

    public static class LambdaConfig
    implements Product,
    Serializable {
        private final String zookeepers;
        private final String zkNamespace;
        private final int partitions;
        private final int consumers;
        private final Duration expiry;
        private final boolean persist;

        public String zookeepers() {
            return this.zookeepers;
        }

        public String zkNamespace() {
            return this.zkNamespace;
        }

        public int partitions() {
            return this.partitions;
        }

        public int consumers() {
            return this.consumers;
        }

        public Duration expiry() {
            return this.expiry;
        }

        public boolean persist() {
            return this.persist;
        }

        public LambdaConfig copy(String zookeepers, String zkNamespace, int partitions, int consumers2, Duration expiry, boolean persist2) {
            return new LambdaConfig(zookeepers, zkNamespace, partitions, consumers2, expiry, persist2);
        }

        public String copy$default$1() {
            return this.zookeepers();
        }

        public String copy$default$2() {
            return this.zkNamespace();
        }

        public int copy$default$3() {
            return this.partitions();
        }

        public int copy$default$4() {
            return this.consumers();
        }

        public Duration copy$default$5() {
            return this.expiry();
        }

        public boolean copy$default$6() {
            return this.persist();
        }

        public String productPrefix() {
            return "LambdaConfig";
        }

        public int productArity() {
            return 6;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 5: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.persist());
                    break;
                }
                case 4: {
                    object = this.expiry();
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToInteger((int)this.consumers());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToInteger((int)this.partitions());
                    break;
                }
                case 1: {
                    object = this.zkNamespace();
                    break;
                }
                case 0: {
                    object = this.zookeepers();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof LambdaConfig;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.zookeepers()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.zkNamespace()));
            n = Statics.mix((int)n, (int)this.partitions());
            n = Statics.mix((int)n, (int)this.consumers());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.expiry()));
            n = Statics.mix((int)n, (int)(this.persist() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)6);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof LambdaConfig)) return false;
            boolean bl = true;
            if (!bl) return false;
            LambdaConfig lambdaConfig = (LambdaConfig)x$1;
            String string = this.zookeepers();
            String string2 = lambdaConfig.zookeepers();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.zkNamespace();
            String string4 = lambdaConfig.zkNamespace();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (this.partitions() != lambdaConfig.partitions()) return false;
            if (this.consumers() != lambdaConfig.consumers()) return false;
            Duration duration = this.expiry();
            Duration duration2 = lambdaConfig.expiry();
            if (duration == null) {
                if (duration2 != null) {
                    return false;
                }
            } else if (!duration.equals(duration2)) return false;
            if (this.persist() != lambdaConfig.persist()) return false;
            if (!lambdaConfig.canEqual(this)) return false;
            return true;
        }

        public LambdaConfig(String zookeepers, String zkNamespace, int partitions, int consumers2, Duration expiry, boolean persist2) {
            this.zookeepers = zookeepers;
            this.zkNamespace = zkNamespace;
            this.partitions = partitions;
            this.consumers = consumers2;
            this.expiry = expiry;
            this.persist = persist2;
            Product.class.$init$((Product)this);
        }
    }
}

