/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.lambda.data;

import com.github.benmanes.caffeine.cache.LoadingCache;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureReader;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.index.audit.QueryEvent;
import org.locationtech.geomesa.index.audit.QueryEvent$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.geoserver.ViewParams$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.stats.package;
import org.locationtech.geomesa.index.utils.ExplainLogger;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.index.view.MergedQueryRunner;
import org.locationtech.geomesa.lambda.data.LambdaDataStore;
import org.locationtech.geomesa.lambda.stream.TransientStore;
import org.locationtech.geomesa.utils.audit.AuditProvider;
import org.locationtech.geomesa.utils.audit.AuditWriter;
import org.locationtech.geomesa.utils.audit.AuditedEvent;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tea\u0001B\u0001\u0003\u00015\u0011\u0011\u0003T1nE\u0012\f\u0017+^3ssJ+hN\\3s\u0015\t\u0019A!\u0001\u0003eCR\f'BA\u0003\u0007\u0003\u0019a\u0017-\u001c2eC*\u0011q\u0001C\u0001\bO\u0016|W.Z:b\u0015\tI!\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010)5\t\u0001C\u0003\u0002\u0012%\u0005!a/[3x\u0015\t\u0019b!A\u0003j]\u0012,\u00070\u0003\u0002\u0016!\t\tR*\u001a:hK\u0012\fV/\u001a:z%Vtg.\u001a:\t\u0011]\u0001!\u0011!Q\u0001\na\t!\u0001Z:\u0011\u0005eQR\"\u0001\u0002\n\u0005m\u0011!a\u0004'b[\n$\u0017\rR1uCN#xN]3\t\u0011u\u0001!\u0011!Q\u0001\ny\t1\u0002]3sg&\u001cH/\u001a8dKB\u0011qdI\u0007\u0002A)\u00111!\t\u0006\u0003E)\t\u0001bZ3pi>|Gn]\u0005\u0003I\u0001\u0012\u0011\u0002R1uCN#xN]3\t\u0011\u0019\u0002!\u0011!Q\u0001\n\u001d\n!\u0002\u001e:b]NLWM\u001c;t!\u0011A3'N \u000e\u0003%R!AK\u0016\u0002\u000b\r\f7\r[3\u000b\u00051j\u0013\u0001C2bM\u001a,\u0017N\\3\u000b\u00059z\u0013\u0001\u00032f]6\fg.Z:\u000b\u0005A\n\u0014AB4ji\",(MC\u00013\u0003\r\u0019w.\\\u0005\u0003i%\u0012A\u0002T8bI&twmQ1dQ\u0016\u0004\"A\u000e\u001f\u000f\u0005]RT\"\u0001\u001d\u000b\u0003e\nQa]2bY\u0006L!a\u000f\u001d\u0002\rA\u0013X\rZ3g\u0013\tidH\u0001\u0004TiJLgn\u001a\u0006\u0003wa\u0002\"\u0001Q\"\u000e\u0003\u0005S!A\u0011\u0003\u0002\rM$(/Z1n\u0013\t!\u0015I\u0001\bUe\u0006t7/[3oiN#xN]3\t\u000b\u0019\u0003A\u0011A$\u0002\rqJg.\u001b;?)\u0011A\u0015JS&\u0011\u0005e\u0001\u0001\"B\fF\u0001\u0004A\u0002\"B\u000fF\u0001\u0004q\u0002\"\u0002\u0014F\u0001\u00049\u0003\"B'\u0001\t\u0003r\u0015\u0001\u0003:v]F+XM]=\u0015\t=\u000bgm\u001b\t\u0004!V;V\"A)\u000b\u0005I\u001b\u0016AC2pY2,7\r^5p]*\u0011AKB\u0001\u0006kRLGn]\u0005\u0003-F\u0013\u0011c\u00117pg\u0016\f'\r\\3Ji\u0016\u0014\u0018\r^8s!\tAv,D\u0001Z\u0015\tQ6,\u0001\u0004tS6\u0004H.\u001a\u0006\u00039v\u000bqAZ3biV\u0014XM\u0003\u0002_\u0015\u00059q\u000e]3oO&\u001c\u0018B\u00011Z\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK\")!\r\u0014a\u0001G\u0006\u00191O\u001a;\u0011\u0005a#\u0017BA3Z\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/\u001a\u0005\u0006O2\u0003\r\u0001[\u0001\u0006cV,'/\u001f\t\u0003?%L!A\u001b\u0011\u0003\u000bE+XM]=\t\u000f1d\u0005\u0013!a\u0001[\u00069Q\r\u001f9mC&t\u0007C\u00018q\u001b\u0005y'B\u0001+\u0013\u0013\t\txNA\u0005FqBd\u0017-\u001b8fe\u001e)1O\u0001E\u0001i\u0006\tB*Y7cI\u0006\fV/\u001a:z%Vtg.\u001a:\u0011\u0005e)h!B\u0001\u0003\u0011\u000318CA;x!\t9\u00040\u0003\u0002zq\t1\u0011I\\=SK\u001aDQAR;\u0005\u0002m$\u0012\u0001\u001e\u0004\u0005{V\u0004eP\u0001\nUe\u0006t7/[3oiF+XM]=bE2,7#\u0003?x\u007f\u00065\u0011QDA\u0012!\u0011\t\t!a\u0002\u000f\u0007=\t\u0019!C\u0002\u0002\u0006A\t\u0011#T3sO\u0016$\u0017+^3ssJ+hN\\3s\u0013\u0011\tI!a\u0003\u0003\u0013E+XM]=bE2,'bAA\u0003!A!\u0011qBA\r\u001b\t\t\tB\u0003\u0003\u0002\u0014\u0005U\u0011\u0001D:dC2\fGn\\4hS:<'bAA\fc\u0005AA/\u001f9fg\u00064W-\u0003\u0003\u0002\u001c\u0005E!!D*ue&\u001cG\u000fT8hO&tw\rE\u00028\u0003?I1!!\t9\u0005\u001d\u0001&o\u001c3vGR\u00042aNA\u0013\u0013\r\t9\u0003\u000f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\nMq\u0014)\u001a!C\u0001\u0003W)\u0012a\n\u0005\n\u0003_a(\u0011#Q\u0001\n\u001d\n1\u0002\u001e:b]NLWM\u001c;tA!1a\t C\u0001\u0003g!B!!\u000e\u0002:A\u0019\u0011q\u0007?\u000e\u0003UDaAJA\u0019\u0001\u00049\u0003bBA\u001fy\u0012\u0005\u0013qH\u0001\u0011O\u0016$h)Z1ukJ,'+Z1eKJ$b!!\u0011\u0002H\u0005-\u0003#B\u0010\u0002D\r<\u0016bAA#A\tia)Z1ukJ,'+Z1eKJDq!!\u0013\u0002<\u0001\u0007\u0001.A\u0001r\u0011!\ti%a\u000fA\u0002\u0005=\u0013!\u0001;\u0011\u0007}\t\t&C\u0002\u0002T\u0001\u00121\u0002\u0016:b]N\f7\r^5p]\"I\u0011q\u000b?\u0002\u0002\u0013\u0005\u0011\u0011L\u0001\u0005G>\u0004\u0018\u0010\u0006\u0003\u00026\u0005m\u0003\u0002\u0003\u0014\u0002VA\u0005\t\u0019A\u0014\t\u0013\u0005}C0%A\u0005\u0002\u0005\u0005\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003GR3aJA3W\t\t9\u0007\u0005\u0003\u0002j\u0005MTBAA6\u0015\u0011\ti'a\u001c\u0002\u0013Ut7\r[3dW\u0016$'bAA9q\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u00141\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA=y\u0006\u0005I\u0011IA>\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0010\t\u0005\u0003\u007f\nI)\u0004\u0002\u0002\u0002*!\u00111QAC\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u001d\u0015\u0001\u00026bm\u0006L1!PAA\u0011%\ti\t`A\u0001\n\u0003\ty)\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u0012B\u0019q'a%\n\u0007\u0005U\u0005HA\u0002J]RD\u0011\"!'}\u0003\u0003%\t!a'\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QTAR!\r9\u0014qT\u0005\u0004\u0003CC$aA!os\"Q\u0011QUAL\u0003\u0003\u0005\r!!%\u0002\u0007a$\u0013\u0007C\u0005\u0002*r\f\t\u0011\"\u0011\u0002,\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002.B1\u0011qVAZ\u0003;k!!!-\u000b\u0005IC\u0014\u0002BA[\u0003c\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003sc\u0018\u0011!C\u0001\u0003w\u000b\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003{\u000b\u0019\rE\u00028\u0003\u007fK1!!19\u0005\u001d\u0011un\u001c7fC:D!\"!*\u00028\u0006\u0005\t\u0019AAO\u0011%\t9\r`A\u0001\n\u0003\nI-\u0001\u0005iCND7i\u001c3f)\t\t\t\nC\u0005\u0002Nr\f\t\u0011\"\u0011\u0002P\u0006AAo\\*ue&tw\r\u0006\u0002\u0002~!I\u00111\u001b?\u0002\u0002\u0013\u0005\u0013Q[\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005u\u0016q\u001b\u0005\u000b\u0003K\u000b\t.!AA\u0002\u0005uu!CAnk\u0006\u0005\t\u0012AAo\u0003I!&/\u00198tS\u0016tG/U;fef\f'\r\\3\u0011\t\u0005]\u0012q\u001c\u0004\t{V\f\t\u0011#\u0001\u0002bN1\u0011q\\Ar\u0003G\u0001r!!:\u0002l\u001e\n)$\u0004\u0002\u0002h*\u0019\u0011\u0011\u001e\u001d\u0002\u000fI,h\u000e^5nK&!\u0011Q^At\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u0005\b\r\u0006}G\u0011AAy)\t\ti\u000e\u0003\u0006\u0002N\u0006}\u0017\u0011!C#\u0003\u001fD!\"a>\u0002`\u0006\u0005I\u0011QA}\u0003\u0015\t\u0007\u000f\u001d7z)\u0011\t)$a?\t\r\u0019\n)\u00101\u0001(\u0011)\ty0a8\u0002\u0002\u0013\u0005%\u0011A\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\u0019A!\u0003\u0011\t]\u0012)aJ\u0005\u0004\u0005\u000fA$AB(qi&|g\u000e\u0003\u0006\u0003\f\u0005u\u0018\u0011!a\u0001\u0003k\t1\u0001\u001f\u00131\u0011)\u0011y!a8\u0002\u0002\u0013%!\u0011C\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\u0014A!\u0011q\u0010B\u000b\u0013\u0011\u00119\"!!\u0003\r=\u0013'.Z2u\u0001")
public class LambdaQueryRunner
extends MergedQueryRunner {
    private final DataStore persistence;
    private final LoadingCache<String, TransientStore> transients;

    public CloseableIterator<SimpleFeature> runQuery(SimpleFeatureType sft, Query query, Explainer explain) {
        CloseableIterator<SimpleFeature> closeableIterator;
        Hints hints = this.configureQuery(sft, query).getHints();
        if (QueryHints$.MODULE$.RichHints(hints).isLambdaQueryPersistent() && QueryHints$.MODULE$.RichHints(hints).isLambdaQueryTransient()) {
            closeableIterator = super.runQuery(sft, query, explain);
        } else if (QueryHints$.MODULE$.RichHints(hints).isLambdaQueryPersistent()) {
            closeableIterator = SelfClosingIterator$.MODULE$.apply(this.persistence.getFeatureReader(query, Transaction.AUTO_COMMIT));
        } else {
            Option audit = Option$.MODULE$.apply((Object)this.persistence).collect((PartialFunction)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final <A1 extends DataStore, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof GeoMesaDataStore) {
                        GeoMesaDataStore geoMesaDataStore = (GeoMesaDataStore)A1;
                        object = geoMesaDataStore.config().audit();
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(DataStore x1) {
                    DataStore dataStore = x1;
                    boolean bl = dataStore instanceof GeoMesaDataStore;
                    return bl;
                }
            }).flatten(Predef$.MODULE$.$conforms());
            audit.foreach((Function1)new Serializable(this, sft, query){
                public static final long serialVersionUID = 0L;
                private final SimpleFeatureType sft$1;
                private final Query query$1;

                public final void apply(Tuple3<AuditWriter, AuditProvider, String> x0$1) {
                    Tuple3<AuditWriter, AuditProvider, String> tuple3 = x0$1;
                    if (tuple3 != null) {
                        AuditWriter writer = (AuditWriter)tuple3._1();
                        AuditProvider provider = (AuditProvider)tuple3._2();
                        String typ = (String)tuple3._3();
                        QueryEvent stat = new QueryEvent(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-lambda"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typ})), this.sft$1.getTypeName(), System.currentTimeMillis(), provider.getCurrentUserId(), package$.MODULE$.filterToString(this.query$1.getFilter()), ViewParams$.MODULE$.getReadableHints(this.query$1), 0L, 0L, 0L, QueryEvent$.MODULE$.apply$default$10());
                        writer.writeEvent((AuditedEvent)stat, ClassTag$.MODULE$.apply(QueryEvent.class));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple3);
                }
                {
                    this.sft$1 = sft$1;
                    this.query$1 = query$1;
                }
            });
            closeableIterator = ((TransientStore)this.transients.get((Object)sft.getTypeName())).read((Option<Filter>)Option$.MODULE$.apply((Object)query.getFilter()), (Option<String[]>)Option$.MODULE$.apply((Object)query.getPropertyNames()), (Option<Hints>)Option$.MODULE$.apply((Object)query.getHints()), explain);
        }
        return closeableIterator;
    }

    public LambdaQueryRunner(LambdaDataStore ds, DataStore persistence, LoadingCache<String, TransientStore> transients) {
        this.persistence = persistence;
        this.transients = transients;
        super((package.HasGeoMesaStats)ds, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TransientQueryable(transients)), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new MergedQueryRunner.DataStoreQueryable(persistence)), (Object)None$.MODULE$)})));
    }

    public static class TransientQueryable
    implements MergedQueryRunner.Queryable,
    StrictLogging,
    Product,
    Serializable {
        private final LoadingCache<String, TransientStore> transients;
        private final Logger logger;

        public Logger logger() {
            return this.logger;
        }

        public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
            this.logger = x$1;
        }

        public LoadingCache<String, TransientStore> transients() {
            return this.transients;
        }

        public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query q, Transaction t) {
            TransientStore store = (TransientStore)this.transients().get((Object)q.getTypeName());
            ExplainLogger explain = new ExplainLogger(this.logger());
            CloseableIterator<SimpleFeature> iter = store.read((Option<Filter>)Option$.MODULE$.apply((Object)q.getFilter()), (Option<String[]>)Option$.MODULE$.apply((Object)q.getPropertyNames()), (Option<Hints>)Option$.MODULE$.apply((Object)q.getHints()), (Explainer)explain);
            return new SimpleFeatureReader(this, q, iter){
                private final Query q$1;
                private final CloseableIterator iter$1;

                public SimpleFeatureType getFeatureType() {
                    return QueryHints$.MODULE$.RichHints(this.q$1.getHints()).getReturnSft();
                }

                public boolean hasNext() {
                    return this.iter$1.hasNext();
                }

                public SimpleFeature next() {
                    return (SimpleFeature)this.iter$1.next();
                }

                public void close() {
                    this.iter$1.close();
                }
                {
                    this.q$1 = q$1;
                    this.iter$1 = iter$1;
                }
            };
        }

        public TransientQueryable copy(LoadingCache<String, TransientStore> transients) {
            return new TransientQueryable(transients);
        }

        public LoadingCache<String, TransientStore> copy$default$1() {
            return this.transients();
        }

        public String productPrefix() {
            return "TransientQueryable";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 0: 
            }
            return this.transients();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TransientQueryable;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TransientQueryable)) return false;
            boolean bl = true;
            if (!bl) return false;
            TransientQueryable transientQueryable = (TransientQueryable)x$1;
            LoadingCache<String, TransientStore> loadingCache = this.transients();
            LoadingCache<String, TransientStore> loadingCache2 = transientQueryable.transients();
            if (loadingCache == null) {
                if (loadingCache2 != null) {
                    return false;
                }
            } else if (!loadingCache.equals(loadingCache2)) return false;
            if (!transientQueryable.canEqual(this)) return false;
            return true;
        }

        public TransientQueryable(LoadingCache<String, TransientStore> transients) {
            this.transients = transients;
            StrictLogging.class.$init$((StrictLogging)this);
            Product.class.$init$((Product)this);
        }
    }
}

