/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.lambda.stream.kafka;

import java.time.Duration;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer;
import org.locationtech.geomesa.kafka.consumer.ThreadedConsumer;
import org.locationtech.geomesa.kafka.consumer.ThreadedConsumer$;
import org.locationtech.geomesa.lambda.stream.kafka.KafkaFeatureCache;
import org.locationtech.geomesa.lambda.stream.kafka.KafkaStore$;
import org.locationtech.geomesa.lambda.stream.kafka.KafkaStore$MessageTypes$;
import org.opengis.feature.simple.SimpleFeature;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001i4A!\u0001\u0002\u0001\u001f\t\u00012*\u00194lC\u000e\u000b7\r[3M_\u0006$WM\u001d\u0006\u0003\u0007\u0011\tQa[1gW\u0006T!!\u0002\u0004\u0002\rM$(/Z1n\u0015\t9\u0001\"\u0001\u0004mC6\u0014G-\u0019\u0006\u0003\u0013)\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\f\u0019\u0005aAn\\2bi&|g\u000e^3dQ*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011#F\u0007\u0002%)\u00111\u0003F\u0001\tG>t7/^7fe*\u00111\u0001C\u0005\u0003-I\u0011\u0001\u0003\u00165sK\u0006$W\rZ\"p]N,X.\u001a:\t\u0011a\u0001!\u0011!Q\u0001\ne\t\u0011bY8ogVlWM]:\u0011\u0007i!sE\u0004\u0002\u001cC9\u0011AdH\u0007\u0002;)\u0011aDD\u0001\u0007yI|w\u000e\u001e \n\u0003\u0001\nQa]2bY\u0006L!AI\u0012\u0002\u000fA\f7m[1hK*\t\u0001%\u0003\u0002&M\t\u00191+Z9\u000b\u0005\t\u001a\u0003\u0003\u0002\u00150cEj\u0011!\u000b\u0006\u0003')R!a\u000b\u0017\u0002\u000f\rd\u0017.\u001a8ug*\u00111!\f\u0006\u0003]1\ta!\u00199bG\",\u0017B\u0001\u0019*\u0005!\u0019uN\\:v[\u0016\u0014\bc\u0001\u001a4k5\t1%\u0003\u00025G\t)\u0011I\u001d:bsB\u0011!GN\u0005\u0003o\r\u0012AAQ=uK\"A\u0011\b\u0001B\u0001B\u0003%!(A\u0003u_BL7\r\u0005\u0002<}9\u0011!\u0007P\u0005\u0003{\r\na\u0001\u0015:fI\u00164\u0017BA A\u0005\u0019\u0019FO]5oO*\u0011Qh\t\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\u0006IaM]3rk\u0016t7-\u001f\t\u0003e\u0011K!!R\u0012\u0003\t1{gn\u001a\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\u0006Q1/\u001a:jC2L'0\u001a:\u0011\u0005%sU\"\u0001&\u000b\u0005-c\u0015\u0001B6ss>T!!\u0014\u0005\u0002\u0011\u0019,\u0017\r^;sKNL!a\u0014&\u0003+-\u0013\u0018p\u001c$fCR,(/Z*fe&\fG.\u001b>fe\"A\u0011\u000b\u0001B\u0001B\u0003%!+A\u0003dC\u000eDW\r\u0005\u0002TE:\u0011A\u000b\u0019\b\u0003+~s!A\u00160\u000f\u0005]kfB\u0001-]\u001d\tI6L\u0004\u0002\u001d5&\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005\r!\u0011BA1\u0003\u0003EY\u0015MZ6b\r\u0016\fG/\u001e:f\u0007\u0006\u001c\u0007.Z\u0005\u0003G\u0012\u0014Ac\u0016:ji\u0006\u0014G.\u001a$fCR,(/Z\"bG\",'BA1\u0003\u0011\u00151\u0007\u0001\"\u0001h\u0003\u0019a\u0014N\\5u}Q1\u0001N[6m[:\u0004\"!\u001b\u0001\u000e\u0003\tAQ\u0001G3A\u0002eAQ!O3A\u0002iBQAQ3A\u0002\rCQaR3A\u0002!CQ!U3A\u0002ICQ\u0001\u001d\u0001\u0005RE\fqaY8ogVlW\r\u0006\u0002skB\u0011!g]\u0005\u0003i\u000e\u0012A!\u00168ji\")ao\u001ca\u0001o\u00061!/Z2pe\u0012\u0004B\u0001\u000b=2c%\u0011\u00110\u000b\u0002\u000f\u0007>t7/^7feJ+7m\u001c:e\u0001")
public class KafkaCacheLoader
extends ThreadedConsumer {
    private final KryoFeatureSerializer serializer;
    private final KafkaFeatureCache.WritableFeatureCache cache;

    public void consume(ConsumerRecord<byte[], byte[]> record) {
        Tuple2<Object, Object> tuple2 = KafkaStore$.MODULE$.deserializeKey((byte[])record.key());
        if (tuple2 != null) {
            Tuple2 tuple22;
            long time = tuple2._1$mcJ$sp();
            byte action = BoxesRunTime.unboxToByte((Object)tuple2._2());
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)time), (Object)BoxesRunTime.boxToByte((byte)action));
            long time2 = tuple23._1$mcJ$sp();
            byte action2 = BoxesRunTime.unboxToByte((Object)tuple23._2());
            SimpleFeature feature = this.serializer.deserialize((byte[])record.value());
            byte by = action2;
            if (KafkaStore$MessageTypes$.MODULE$.Write() == by) {
                this.cache.add(feature, record.partition(), record.offset(), time2);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (KafkaStore$MessageTypes$.MODULE$.Delete() == by) {
                this.cache.delete(feature, record.partition(), record.offset(), time2);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Unhandled message type: {}", new Object[]{BoxesRunTime.boxToByte((byte)action2)});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public KafkaCacheLoader(Seq<Consumer<byte[], byte[]>> consumers2, String topic, long frequency, KryoFeatureSerializer serializer, KafkaFeatureCache.WritableFeatureCache cache) {
        this.serializer = serializer;
        this.cache = cache;
        super(consumers2, Duration.ofMillis(frequency), ThreadedConsumer$.MODULE$.$lessinit$greater$default$3());
        this.startConsumers(this.startConsumers$default$1());
    }
}

