/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.lambda.stream.kafka;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.locationtech.geomesa.lambda.stream.OffsetManager;
import org.opengis.feature.simple.SimpleFeature;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0015b\u0001B\u0001\u0003\u0001=\u0011\u0011cS1gW\u00064U-\u0019;ve\u0016\u001c\u0015m\u00195f\u0015\t\u0019A!A\u0003lC\u001a\\\u0017M\u0003\u0002\u0006\r\u000511\u000f\u001e:fC6T!a\u0002\u0005\u0002\r1\fWN\u00193b\u0015\tI!\"A\u0004hK>lWm]1\u000b\u0005-a\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0017\u0001\u0001b#a\u0006\u0002\u001a\u0005m\u0011\u0011\u0006\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005])fB\u0001\r(\u001d\tIbE\u0004\u0002\u001bK9\u00111\u0004\n\b\u00039\rr!!\b\u0012\u000f\u0005y\tS\"A\u0010\u000b\u0005\u0001r\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!a\u0001\u0003\b\u000b!\u0012\u0001\u0012A\u0015\u0002#-\u000bgm[1GK\u0006$XO]3DC\u000eDW\r\u0005\u0002+W5\t!AB\u0003\u0002\u0005!\u0005Af\u0005\u0002,!!)af\u000bC\u0001_\u00051A(\u001b8jiz\"\u0012!\u000b\u0004\bc-\u0002\n1%\u00013\u0005Q\u0011V-\u00193bE2,g)Z1ukJ,7)Y2iKN\u0011\u0001\u0007\u0005\u0005\u0006iA2\t!N\u0001\u0004C2dG#\u0001\u001c\u0011\u0007]btH\u0004\u00029u9\u0011a$O\u0005\u0002'%\u00111HE\u0001\ba\u0006\u001c7.Y4f\u0013\tidH\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\tY$\u0003\u0005\u0002A\u000f6\t\u0011I\u0003\u0002C\u0007\u000611/[7qY\u0016T!\u0001R#\u0002\u000f\u0019,\u0017\r^;sK*\u0011a\tD\u0001\b_B,gnZ5t\u0013\tA\u0015IA\u0007TS6\u0004H.\u001a$fCR,(/\u001a\u0005\u0006\u0015B2\taS\u0001\u0004O\u0016$HCA M\u0011\u0015i\u0015\n1\u0001O\u0003\tIG\r\u0005\u0002P%:\u0011\u0011\u0003U\u0005\u0003#J\ta\u0001\u0015:fI\u00164\u0017BA*U\u0005\u0019\u0019FO]5oO*\u0011\u0011K\u0005\u0004\b-.\u0002\n1%\u0001X\u0005Q9&/\u001b;bE2,g)Z1ukJ,7)Y2iKN\u0011Q\u000b\u0005\u0005\u00063V3\tAW\u0001\u0012a\u0006\u0014H/\u001b;j_:\f5o]5h]\u0016$GcA._GB\u0011\u0011\u0003X\u0005\u0003;J\u0011A!\u00168ji\")q\f\u0017a\u0001A\u0006I\u0001/\u0019:uSRLwN\u001c\t\u0003#\u0005L!A\u0019\n\u0003\u0007%sG\u000fC\u0003e1\u0002\u0007Q-\u0001\u0004pM\u001a\u001cX\r\u001e\t\u0003#\u0019L!a\u001a\n\u0003\t1{gn\u001a\u0005\u0006SV3\tA[\u0001\u0004C\u0012$G#B.lY6t\u0007\"\u0002#i\u0001\u0004y\u0004\"B0i\u0001\u0004\u0001\u0007\"\u00023i\u0001\u0004)\u0007\"B8i\u0001\u0004)\u0017aB2sK\u0006$X\r\u001a\u0005\u0006cV3\tA]\u0001\u0007I\u0016dW\r^3\u0015\u000bm\u001bH/\u001e<\t\u000b\u0011\u0003\b\u0019A \t\u000b}\u0003\b\u0019\u00011\t\u000b\u0011\u0004\b\u0019A3\t\u000b=\u0004\b\u0019A3\u0007\u000fa\\\u0003\u0013aI\u0001s\n!R\t\u001f9je&twMR3biV\u0014XmQ1dQ\u0016\u001c\"a\u001e\t\t\u000bm<h\u0011\u0001?\u0002\u000f\u0015D\b/\u001b:fIR\u0019Q0!\u0001\u0011\u0007]r\b-\u0003\u0002\u0000}\t\u00191+Z9\t\r\u0005\r!\u00101\u0001f\u0003\u0019)\u0007\u0010]5ss\"11p\u001eD\u0001\u0003\u000f!b!!\u0003\u0002\u0014\u0005U\u0001CB\t\u0002\f\u0015\fy!C\u0002\u0002\u000eI\u0011a\u0001V;qY\u0016\u0014\u0004\u0003B\u001c\u007f\u0003#\u0001R!EA\u0006K~BaaXA\u0003\u0001\u0004\u0001\u0007bBA\u0002\u0003\u000b\u0001\r!\u001a\t\u0003/A\u0002\"aF<\u0011\t\u0005u\u00111\u0005\b\u00043\u0005}\u0011bAA\u0011\t\u0005iqJ\u001a4tKRl\u0015M\\1hKJLA!!\n\u0002(\tqqJ\u001a4tKRd\u0015n\u001d;f]\u0016\u0014(bAA\u0011\tA!\u00111FA\u001d\u001b\t\tiC\u0003\u0003\u00020\u0005E\u0012\u0001D:dC2\fGn\\4hS:<'\u0002BA\u001a\u0003k\t\u0001\u0002^=qKN\fg-\u001a\u0006\u0003\u0003o\t1aY8n\u0013\u0011\tY$!\f\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\n\u0003\u007f\u0001!\u0011!Q\u0001\n9\u000bQ\u0001^8qS\u000eDaA\f\u0001\u0005\u0002\u0005\rC\u0003BA#\u0003\u000f\u0002\"A\u000b\u0001\t\u000f\u0005}\u0012\u0011\ta\u0001\u001d\"I\u00111\n\u0001C\u0002\u0013%\u0011QJ\u0001\tM\u0016\fG/\u001e:fgV\u0011\u0011q\n\t\u0007\u0003#\nyFT \u000e\u0005\u0005M#\u0002BA+\u0003/\n!bY8oGV\u0014(/\u001a8u\u0015\u0011\tI&a\u0017\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003;\nAA[1wC&!\u0011\u0011MA*\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\u0005\t\u0003K\u0002\u0001\u0015!\u0003\u0002P\u0005Ia-Z1ukJ,7\u000f\t\u0005\n\u0003S\u0002!\u0019!C\u0005\u0003W\na!];fk\u0016\u001cXCAA7!\u0019\ty'!\u001f\u0002~5\u0011\u0011\u0011\u000f\u0006\u0005\u0003g\n)(A\u0004nkR\f'\r\\3\u000b\u0007\u0005]$#\u0001\u0006d_2dWm\u0019;j_:LA!a\u001f\u0002r\tY\u0011I\u001d:bs\n+hMZ3s!\u001d\t\u00121BA@\u0003\u0017\u0003B!!!\u0002\b6\u0011\u00111\u0011\u0006\u0005\u0003\u000b\u000b\u0019&A\u0003m_\u000e\\7/\u0003\u0003\u0002\n\u0006\r%!\u0004*fK:$(/\u00198u\u0019>\u001c7\u000e\u0005\u0004\u0002\u000e\u0006=\u00151S\u0007\u0003\u0003/JA!!%\u0002X\tQ\u0011I\u001d:bs\u0012+\u0017/^3\u0011\rE\t)*Z3@\u0013\r\t9J\u0005\u0002\u0007)V\u0004H.Z\u001a\t\u0011\u0005m\u0005\u0001)A\u0005\u0003[\nq!];fk\u0016\u001c\b\u0005C\u0005\u0002 \u0002\u0011\r\u0011\"\u0003\u0002\"\u00069qN\u001a4tKR\u001cXCAAR!\u0019\ty'!\u001f\u0002&B!\u0011qUAW\u001b\t\tIK\u0003\u0003\u0002,\u0006M\u0013AB1u_6L7-\u0003\u0003\u00020\u0006%&AC!u_6L7\rT8oO\"A\u00111\u0017\u0001!\u0002\u0013\t\u0019+\u0001\u0005pM\u001a\u001cX\r^:!\u0011%\t9\f\u0001b\u0001\n\u0013\tI,A\u0003eK\n,x-\u0006\u0002\u0002<B\u0019\u0011#!0\n\u0007\u0005}&CA\u0004C_>dW-\u00198\t\u0011\u0005\r\u0007\u0001)A\u0005\u0003w\u000ba\u0001Z3ck\u001e\u0004\u0003BB-\u0001\t\u0003\n9\rF\u0003\\\u0003\u0013\fY\r\u0003\u0004`\u0003\u000b\u0004\r\u0001\u0019\u0005\u0007I\u0006\u0015\u0007\u0019A3\t\r)\u0003A\u0011IAh)\ry\u0014\u0011\u001b\u0005\u0007\u001b\u00065\u0007\u0019\u0001(\t\u000bQ\u0002A\u0011I\u001b\t\r%\u0004A\u0011IAl)%Y\u0016\u0011\\An\u0003;\fy\u000e\u0003\u0004E\u0003+\u0004\ra\u0010\u0005\u0007?\u0006U\u0007\u0019\u00011\t\r\u0011\f)\u000e1\u0001f\u0011\u0019y\u0017Q\u001ba\u0001K\"1\u0011\u000f\u0001C!\u0003G$\u0012bWAs\u0003O\fI/a;\t\r\u0011\u000b\t\u000f1\u0001@\u0011\u0019y\u0016\u0011\u001da\u0001A\"1A-!9A\u0002\u0015Daa\\Aq\u0001\u0004)\u0007BB>\u0001\t\u0003\ny\u000fF\u0002~\u0003cDq!a\u0001\u0002n\u0002\u0007Q\r\u0003\u0004|\u0001\u0011\u0005\u0013Q\u001f\u000b\u0007\u0003\u0013\t90!?\t\r}\u000b\u0019\u00101\u0001a\u0011\u001d\t\u0019!a=A\u0002\u0015Dq!!@\u0001\t\u0003\ny0A\u0007pM\u001a\u001cX\r^\"iC:<W\r\u001a\u000b\u00067\n\u0005!1\u0001\u0005\u0007?\u0006m\b\u0019\u00011\t\r\u0011\fY\u00101\u0001f\u0011\u001d\u00119\u0001\u0001C\u0005\u0005\u0013\tq\"\u001a8tkJ,\u0007+\u0019:uSRLwN\u001c\u000b\u00067\n-!Q\u0002\u0005\u0007?\n\u0015\u0001\u0019\u00011\t\r\u0011\u0014)\u00011\u0001f\u0011\u001d\u0011\t\u0002\u0001C\u0005\u0005'\taA]3n_Z,G\u0003BA^\u0005+Aa\u0001\u0012B\b\u0001\u0004y\u0004b\u0002B\r\u0001\u0011%!1D\u0001\u0005I&4g\rF\u0003O\u0005;\u0011\t\u0003C\u0004\u0003 \t]\u0001\u0019\u00011\u0002\u0011=\u0014\u0018nZ5oC2DqAa\t\u0003\u0018\u0001\u0007\u0001-A\u0004va\u0012\fG/\u001a3")
public class KafkaFeatureCache
implements WritableFeatureCache,
ReadableFeatureCache,
ExpiringFeatureCache,
OffsetManager.OffsetListener,
LazyLogging {
    private final String topic;
    private final ConcurrentHashMap<String, SimpleFeature> features;
    private final ArrayBuffer<Tuple2<ReentrantLock, ArrayDeque<Tuple3<Object, Object, SimpleFeature>>>> queues;
    private final ArrayBuffer<AtomicLong> offsets;
    private final boolean debug;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        KafkaFeatureCache kafkaFeatureCache = this;
        synchronized (kafkaFeatureCache) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private ConcurrentHashMap<String, SimpleFeature> features() {
        return this.features;
    }

    private ArrayBuffer<Tuple2<ReentrantLock, ArrayDeque<Tuple3<Object, Object, SimpleFeature>>>> queues() {
        return this.queues;
    }

    private ArrayBuffer<AtomicLong> offsets() {
        return this.offsets;
    }

    private boolean debug() {
        return this.debug;
    }

    @Override
    public void partitionAssigned(int partition, long offset) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Partition assigned: [{}:{}:{}]", new Object[]{this.topic, BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToLong((long)offset)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.ensurePartition(partition, offset);
    }

    @Override
    public SimpleFeature get(String id) {
        return this.features().get(id);
    }

    @Override
    public Iterator<SimpleFeature> all() {
        return (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.features().values().iterator()).asScala();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void add(SimpleFeature feature, int partition, long offset, long created) {
        BoxedUnit boxedUnit;
        if (((AtomicLong)this.offsets().apply(partition)).get() < offset) {
            Tuple2 tuple2;
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding [", ":", "] ", " created at "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToLong((long)offset), feature}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZonedDateTime.ofInstant(Instant.ofEpochMilli(created), ZoneOffset.UTC)}))).toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            this.features().put(feature.getID(), feature);
            Tuple2 tuple22 = (Tuple2)this.queues().apply(partition);
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            ReentrantLock lock = (ReentrantLock)tuple22._1();
            ArrayDeque queue = (ArrayDeque)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)lock, (Object)queue);
            ReentrantLock lock2 = (ReentrantLock)tuple23._1();
            ArrayDeque queue2 = (ArrayDeque)tuple23._2();
            lock2.lock();
            try {
                queue2.addLast(new Tuple3((Object)BoxesRunTime.boxToLong((long)offset), (Object)BoxesRunTime.boxToLong((long)created), (Object)feature));
                lock2.unlock();
                return;
            }
            catch (Throwable throwable) {
                void var12_10;
                var12_10.unlock();
                throw throwable;
            }
        }
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignoring [", ":", "] ", " created at "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToLong((long)offset), feature}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZonedDateTime.ofInstant(Instant.ofEpochMilli(created), ZoneOffset.UTC)}))).toString());
            boxedUnit = BoxedUnit.UNIT;
            return;
        }
        boxedUnit = BoxedUnit.UNIT;
    }

    @Override
    public void delete(SimpleFeature feature, int partition, long offset, long created) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting [", ":", "] ", " created at "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToLong((long)offset), feature}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZonedDateTime.ofInstant(Instant.ofEpochMilli(created), ZoneOffset.UTC)}))).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.features().remove(feature.getID());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Seq<Object> expired(long expiry) {
        ArrayBuffer result = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        int i = 0;
        void var3_2;
        while (i < this.queues().length()) {
            BoxedUnit boxedUnit;
            Tuple3 peek;
            Tuple3 tuple3;
            Tuple2 tuple22;
            Tuple2 tuple2 = (Tuple2)this.queues().apply(i);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ReentrantLock lock = (ReentrantLock)tuple2._1();
            ArrayDeque queue = (ArrayDeque)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)lock, (Object)queue);
            ReentrantLock lock2 = (ReentrantLock)tuple23._1();
            ArrayDeque queue2 = (ArrayDeque)tuple23._2();
            lock2.lock();
            try {
                tuple3 = (Tuple3)queue2.peek();
                lock2.unlock();
            }
            catch (Throwable throwable) {
                void var10_9;
                var10_9.unlock();
                throw throwable;
            }
            Tuple3 tuple32 = peek = tuple3;
            if (tuple32 == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                if (tuple32 == null) {
                    throw new MatchError((Object)tuple32);
                }
                long created = BoxesRunTime.unboxToLong((Object)tuple32._2());
                boxedUnit = expiry > created ? result.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i)) : BoxedUnit.UNIT;
            }
            ++i;
        }
        return var3_2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Tuple2<Object, Seq<Tuple2<Object, SimpleFeature>>> expired(int partition, long expiry) {
        BoxedUnit boxedUnit;
        Tuple2 tuple22;
        ArrayBuffer expired = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        Tuple2 tuple2 = (Tuple2)this.queues().apply(partition);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ReentrantLock lock = (ReentrantLock)tuple2._1();
        ArrayDeque queue = (ArrayDeque)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)lock, (Object)queue);
        ReentrantLock lock2 = (ReentrantLock)tuple23._1();
        ArrayDeque queue2 = (ArrayDeque)tuple23._2();
        boolean loop = true;
        while (loop) {
            BoxedUnit boxedUnit2;
            lock2.lock();
            Tuple3 poll = (Tuple3)queue2.poll();
            if (poll == null) {
                lock2.unlock();
                loop = false;
                boxedUnit2 = BoxedUnit.UNIT;
                continue;
            }
            if (BoxesRunTime.unboxToLong((Object)poll._2()) > expiry) {
                try {
                    queue2.addFirst(poll);
                    lock2.unlock();
                    loop = false;
                    boxedUnit2 = BoxedUnit.UNIT;
                    continue;
                }
                catch (Throwable throwable) {
                    void var10_9;
                    var10_9.unlock();
                    throw throwable;
                }
            }
            lock2.unlock();
            boxedUnit2 = expired.$plus$eq((Object)new Tuple2(poll._1(), poll._3()));
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Checking [{}:{}] for expired entries: found {} expired and {} remaining", new Object[]{this.topic, BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToInteger((int)expired.size()), BoxesRunTime.boxToInteger((int)queue2.size())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        long maxExpiredOffset = expired.isEmpty() ? -1L : ((Tuple2)expired.apply(expired.length() - 1))._1$mcJ$sp();
        ArrayBuffer latest = (ArrayBuffer)expired.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaFeatureCache $outer;

            public final boolean apply(Tuple2<Object, SimpleFeature> x0$1) {
                Tuple2<Object, SimpleFeature> tuple2 = x0$1;
                if (tuple2 != null) {
                    SimpleFeature feature = (SimpleFeature)tuple2._2();
                    boolean bl = this.$outer.org$locationtech$geomesa$lambda$stream$kafka$KafkaFeatureCache$$remove(feature);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)maxExpiredOffset), (Object)latest);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void offsetChanged(int partition, long offset) {
        BoxedUnit boxedUnit;
        Tuple3 tuple33;
        Tuple2 tuple22;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Offsets changed for [{}:{}]: -> {}", new Object[]{this.topic, BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToLong((long)offset)});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.queues().length() <= partition) {
            this.ensurePartition(partition, offset);
            return;
        }
        Tuple2 tuple2 = (Tuple2)this.queues().apply(partition);
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        ReentrantLock lock = (ReentrantLock)tuple2._1();
        ArrayDeque queue = (ArrayDeque)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)lock, (Object)queue);
        ReentrantLock lock2 = (ReentrantLock)tuple23._1();
        ArrayDeque queue2 = (ArrayDeque)tuple23._2();
        Tuple3 tuple3 = this.debug() ? new Tuple3((Object)BoxesRunTime.boxToInteger((int)this.features().size()), (Object)BoxesRunTime.boxToInteger((int)queue2.size()), (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())) : new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToLong((long)0L));
        if (tuple3 == null) throw new MatchError((Object)tuple3);
        int featureSize = BoxesRunTime.unboxToInt((Object)tuple3._1());
        int queueSize = BoxesRunTime.unboxToInt((Object)tuple3._2());
        long start = BoxesRunTime.unboxToLong((Object)tuple3._3());
        Tuple3 tuple34 = tuple33 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)featureSize), (Object)BoxesRunTime.boxToInteger((int)queueSize), (Object)BoxesRunTime.boxToLong((long)start));
        int featureSize2 = BoxesRunTime.unboxToInt((Object)tuple34._1());
        int queueSize2 = BoxesRunTime.unboxToInt((Object)tuple34._2());
        long start2 = BoxesRunTime.unboxToLong((Object)tuple34._3());
        boolean loop = true;
        while (loop) {
            Object object;
            lock2.lock();
            Tuple3 poll = (Tuple3)queue2.poll();
            if (poll == null) {
                lock2.unlock();
                loop = false;
                object = BoxedUnit.UNIT;
                continue;
            }
            if (BoxesRunTime.unboxToLong((Object)poll._1()) > offset) {
                try {
                    queue2.addFirst(poll);
                    lock2.unlock();
                    loop = false;
                    object = BoxedUnit.UNIT;
                    continue;
                }
                catch (Throwable throwable) {
                    void var9_8;
                    var9_8.unlock();
                    throw throwable;
                }
            }
            lock2.unlock();
            object = BoxesRunTime.boxToBoolean((boolean)this.org$locationtech$geomesa$lambda$stream$kafka$KafkaFeatureCache$$remove((SimpleFeature)poll._3()));
        }
        long last = ((AtomicLong)this.offsets().apply(partition)).get();
        while (last < offset && !((AtomicLong)this.offsets().apply(partition)).compareAndSet(last, offset)) {
            last = ((AtomicLong)this.offsets().apply(partition)).get();
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Size of cached state for [", ":", "]: features (total): "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic, BoxesRunTime.boxToInteger((int)partition)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", offsets: ", " in "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.diff(featureSize2, this.features().size()), this.diff(queueSize2, queue2.size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - start2))}))).toString());
            boxedUnit = BoxedUnit.UNIT;
            return;
        }
        boxedUnit = BoxedUnit.UNIT;
    }

    private synchronized void ensurePartition(int partition, long offset) {
        while (this.queues().length() <= partition) {
            this.queues().$plus$eq((Object)new Tuple2((Object)new ReentrantLock(), new ArrayDeque()));
            this.offsets().$plus$eq((Object)new AtomicLong(-1L));
        }
        ((AtomicLong)this.offsets().apply(partition)).set(offset);
    }

    public boolean org$locationtech$geomesa$lambda$stream$kafka$KafkaFeatureCache$$remove(SimpleFeature feature) {
        return feature == this.features().get(feature.getID()) && this.features().remove(feature.getID(), feature);
    }

    private String diff(int original, int updated) {
        int arg$macro$1 = updated;
        int arg$macro$2 = updated - original;
        return new StringOps("%d (%+d)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1), BoxesRunTime.boxToInteger((int)arg$macro$2)}));
    }

    public KafkaFeatureCache(String topic) {
        this.topic = topic;
        LazyLogging.class.$init$((LazyLogging)this);
        this.features = new ConcurrentHashMap();
        this.queues = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        this.offsets = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        this.debug = this.logger().underlying().isDebugEnabled();
    }

    public static interface WritableFeatureCache {
        public void partitionAssigned(int var1, long var2);

        public void add(SimpleFeature var1, int var2, long var3, long var5);

        public void delete(SimpleFeature var1, int var2, long var3, long var5);
    }

    public static interface ReadableFeatureCache {
        public Iterator<SimpleFeature> all();

        public SimpleFeature get(String var1);
    }

    public static interface ExpiringFeatureCache {
        public Seq<Object> expired(long var1);

        public Tuple2<Object, Seq<Tuple2<Object, SimpleFeature>>> expired(int var1, long var2);
    }
}

