/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.lambda.stream.kafka;

import java.time.Clock;
import java.util.Properties;
import java.util.UUID;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.geotools.data.DataStore;
import org.locationtech.geomesa.kafka.KafkaConsumerVersions$;
import org.locationtech.geomesa.lambda.data.LambdaDataStore;
import org.locationtech.geomesa.lambda.stream.OffsetManager;
import org.locationtech.geomesa.lambda.stream.kafka.KafkaStore;
import org.locationtech.geomesa.security.AuthorizationsProvider;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class KafkaStore$ {
    public static final KafkaStore$ MODULE$;
    private final GeoMesaSystemProperties.SystemProperty LoadIntervalProperty;

    static {
        new KafkaStore$();
    }

    public GeoMesaSystemProperties.SystemProperty LoadIntervalProperty() {
        return this.LoadIntervalProperty;
    }

    public String topic(String ns, SimpleFeatureType sft) {
        return this.topic(ns, sft.getTypeName());
    }

    public String topic(String ns, String typeName) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ns, typeName})).replaceAll("[^a-zA-Z0-9_\\-]", "_");
    }

    /*
     * WARNING - void declaration
     */
    public <T> T withZk(String zookeepers, Function1<ZkUtils, T> fn) {
        Object object;
        boolean security = new GeoMesaSystemProperties.SystemProperty("geomesa.zookeeper.security.enabled", GeoMesaSystemProperties.SystemProperty$.MODULE$.apply$default$2()).option().exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).toBoolean();
            }
        });
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(zookeepers, 3000, 3000, security);
        try {
            object = fn.apply((Object)zkUtils);
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.close();
            throw throwable;
        }
        zkUtils.close();
        return (T)object;
    }

    public Producer<byte[], byte[]> producer(Map<String, String> connect) {
        Properties props = new Properties();
        props.put("acks", "1");
        props.put("retries", BoxesRunTime.boxToInteger((int)3));
        props.put("linger.ms", BoxesRunTime.boxToInteger((int)3));
        connect.foreach((Function1)new Serializable(props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Object object = this.props$1.put(k, v);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.props$1 = props$1;
            }
        });
        props.put("partitioner.class", KafkaStore.FeatureIdPartitioner.class.getName());
        props.put("key.serializer", ByteArraySerializer.class.getName());
        props.put("value.serializer", ByteArraySerializer.class.getName());
        return new KafkaProducer(props);
    }

    public Consumer<byte[], byte[]> consumer(Map<String, String> connect, String group) {
        Properties props = new Properties();
        props.put("group.id", group);
        connect.foreach((Function1)new Serializable(props){
            public static final long serialVersionUID = 0L;
            private final Properties props$2;

            public final Object apply(Tuple2<String, String> x0$2) {
                Tuple2<String, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Object object = this.props$2.put(k, v);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.props$2 = props$2;
            }
        });
        props.put("enable.auto.commit", "false");
        props.put("auto.offset.reset", "earliest");
        props.put("key.deserializer", ByteArrayDeserializer.class.getName());
        props.put("value.deserializer", ByteArrayDeserializer.class.getName());
        return new KafkaConsumer(props);
    }

    public Seq<Consumer<byte[], byte[]>> consumers(Map<String, String> connect, String topic, OffsetManager manager, int parallelism, Function2<Object, Object, BoxedUnit> callback) {
        Predef$.MODULE$.require(parallelism > 0, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Parallelism must be greater than 0";
            }
        });
        String group = UUID.randomUUID().toString();
        return (Seq)Seq$.MODULE$.fill(parallelism, (Function0)new Serializable(connect, topic, manager, callback, group){
            public static final long serialVersionUID = 0L;
            private final Map connect$1;
            private final String topic$1;
            private final OffsetManager manager$1;
            private final Function2 callback$1;
            private final String group$1;

            /*
             * WARNING - void declaration
             */
            public final Consumer<byte[], byte[]> apply() {
                void var1_1;
                Consumer<byte[], byte[]> consumer2 = KafkaStore$.MODULE$.consumer((Map<String, String>)this.connect$1, this.group$1);
                KafkaStore.OffsetRebalanceListener listener = new KafkaStore.OffsetRebalanceListener(consumer2, this.manager$1, (Function2<Object, Object, BoxedUnit>)this.callback$1);
                KafkaConsumerVersions$.MODULE$.subscribe(consumer2, this.topic$1, (ConsumerRebalanceListener)listener);
                return var1_1;
            }
            {
                this.connect$1 = connect$1;
                this.topic$1 = topic$1;
                this.manager$1 = manager$1;
                this.callback$1 = callback$1;
                this.group$1 = group$1;
            }
        });
    }

    public byte[] serializeKey(long time, byte action) {
        byte[] result = (byte[])Array$.MODULE$.ofDim(9, ClassTag$.MODULE$.Byte());
        result[0] = (byte)(time >> 56 & 0xFFL);
        result[1] = (byte)(time >> 48 & 0xFFL);
        result[2] = (byte)(time >> 40 & 0xFFL);
        result[3] = (byte)(time >> 32 & 0xFFL);
        result[4] = (byte)(time >> 24 & 0xFFL);
        result[5] = (byte)(time >> 16 & 0xFFL);
        result[6] = (byte)(time >> 8 & 0xFFL);
        result[7] = (byte)(time & 0xFFL);
        result[8] = action;
        return result;
    }

    public Tuple2<Object, Object> deserializeKey(byte[] key) {
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)ByteArrays$.MODULE$.readLong(key, ByteArrays$.MODULE$.readLong$default$2())), (Object)BoxesRunTime.boxToByte((byte)key[8]));
    }

    public Clock $lessinit$greater$default$8(DataStore ds, SimpleFeatureType sft, Option<AuthorizationsProvider> authProvider, OffsetManager offsetManager, Producer<byte[], byte[]> producer2, Map<String, String> consumerConfig, LambdaDataStore.LambdaConfig config) {
        return Clock.systemUTC();
    }

    private KafkaStore$() {
        MODULE$ = this;
        this.LoadIntervalProperty = new GeoMesaSystemProperties.SystemProperty("geomesa.lambda.load.interval", "100ms");
    }
}

