/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.lambda.stream.kafka;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.time.Clock;
import java.util.Collection;
import java.util.Map;
import kafka.admin.AdminUtils$;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.utils.ZkUtils;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.TopicPartition;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.features.SerializationOption;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer$;
import org.locationtech.geomesa.features.kryo.impl.KryoFeatureDeserialization$;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureWriter$;
import org.locationtech.geomesa.index.planning.QueryInterceptor;
import org.locationtech.geomesa.index.stats.GeoMesaStats;
import org.locationtech.geomesa.index.utils.ExplainLogging;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.kafka.AdminUtilsVersions$;
import org.locationtech.geomesa.kafka.KafkaConsumerVersions$;
import org.locationtech.geomesa.lambda.data.LambdaDataStore;
import org.locationtech.geomesa.lambda.stream.OffsetManager;
import org.locationtech.geomesa.lambda.stream.TransientStore;
import org.locationtech.geomesa.lambda.stream.TransientStore$class;
import org.locationtech.geomesa.lambda.stream.kafka.DataStorePersistence;
import org.locationtech.geomesa.lambda.stream.kafka.KafkaCacheLoader;
import org.locationtech.geomesa.lambda.stream.kafka.KafkaFeatureCache;
import org.locationtech.geomesa.lambda.stream.kafka.KafkaQueryRunner;
import org.locationtech.geomesa.lambda.stream.kafka.KafkaStore$;
import org.locationtech.geomesa.lambda.stream.kafka.KafkaStore$MessageTypes$;
import org.locationtech.geomesa.security.AuthorizationsProvider;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.io.IsCloseable;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;
import scala.util.hashing.MurmurHash3$;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0005c\u0001B\u0001\u0003\u0001=\u0011!bS1gW\u0006\u001cFo\u001c:f\u0015\t\u0019A!A\u0003lC\u001a\\\u0017M\u0003\u0002\u0006\r\u000511\u000f\u001e:fC6T!a\u0002\u0005\u0002\r1\fWN\u00193b\u0015\tI!\"A\u0004hK>lWm]1\u000b\u0005-a\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001bC\u0007\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]AR\"\u0001\u0003\n\u0005e!!A\u0004+sC:\u001c\u0018.\u001a8u'R|'/\u001a\t\u00037\tj\u0011\u0001\b\u0006\u0003;y\tAb]2bY\u0006dwnZ4j]\u001eT!a\b\u0011\u0002\u0011QL\b/Z:bM\u0016T\u0011!I\u0001\u0004G>l\u0017BA\u0012\u001d\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u0011\u0015\u0002!\u0011!Q\u0001\n\u0019\n!\u0001Z:\u0011\u0005\u001dbS\"\u0001\u0015\u000b\u0005%R\u0013\u0001\u00023bi\u0006T!a\u000b\u0007\u0002\u0011\u001d,w\u000e^8pYNL!!\f\u0015\u0003\u0013\u0011\u000bG/Y*u_J,\u0007\u0002C\u0018\u0001\u0005\u000b\u0007I\u0011\u0001\u0019\u0002\u0007M4G/F\u00012!\t\u0011\u0014(D\u00014\u0015\t!T'\u0001\u0004tS6\u0004H.\u001a\u0006\u0003m]\nqAZ3biV\u0014XM\u0003\u00029\u0019\u00059q\u000e]3oO&\u001c\u0018B\u0001\u001e4\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/\u001a\u0005\ty\u0001\u0011\t\u0011)A\u0005c\u0005!1O\u001a;!\u0011!q\u0004A!A!\u0002\u0013y\u0014\u0001D1vi\"\u0004&o\u001c<jI\u0016\u0014\bcA\tA\u0005&\u0011\u0011I\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015C\u0011\u0001C:fGV\u0014\u0018\u000e^=\n\u0005\u001d#%AF!vi\"|'/\u001b>bi&|gn\u001d)s_ZLG-\u001a:\t\u0011%\u0003!\u0011!Q\u0001\n)\u000bQb\u001c4gg\u0016$X*\u00198bO\u0016\u0014\bCA\fL\u0013\taEAA\u0007PM\u001a\u001cX\r^'b]\u0006<WM\u001d\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u001f\u0006A\u0001O]8ek\u000e,'\u000f\u0005\u0003Q/fKV\"A)\u000b\u00059\u0013&BA*U\u0003\u001d\u0019G.[3oiNT!aA+\u000b\u0005Yc\u0011AB1qC\u000eDW-\u0003\u0002Y#\nA\u0001K]8ek\u000e,'\u000fE\u0002\u00125rK!a\u0017\n\u0003\u000b\u0005\u0013(/Y=\u0011\u0005Ei\u0016B\u00010\u0013\u0005\u0011\u0011\u0015\u0010^3\t\u0011\u0001\u0004!\u0011!Q\u0001\n\u0005\fabY8ogVlWM]\"p]\u001aLw\r\u0005\u0003cK\"DgBA\td\u0013\t!'#\u0001\u0004Qe\u0016$WMZ\u0005\u0003M\u001e\u00141!T1q\u0015\t!'\u0003\u0005\u0002cS&\u0011!n\u001a\u0002\u0007'R\u0014\u0018N\\4\t\u00111\u0004!\u0011!Q\u0001\n5\faaY8oM&<\u0007C\u00018\u0000\u001d\tyGP\u0004\u0002qw:\u0011\u0011O\u001f\b\u0003eft!a\u001d=\u000f\u0005Q<X\"A;\u000b\u0005Yt\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003S\u0019I!! @\u0002\u001f1\u000bWN\u00193b\t\u0006$\u0018m\u0015;pe\u0016T!!\u000b\u0004\n\t\u0005\u0005\u00111\u0001\u0002\r\u0019\u0006l'\rZ1D_:4\u0017n\u001a\u0006\u0003{zD!\"a\u0002\u0001\u0005\u0003\u0005\u000b1BA\u0005\u0003\u0015\u0019Gn\\2l!\u0011\tY!!\u0006\u000e\u0005\u00055!\u0002BA\b\u0003#\tA\u0001^5nK*\u0011\u00111C\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0018\u00055!!B\"m_\u000e\\\u0007bBA\u000e\u0001\u0011\u0005\u0011QD\u0001\u0007y%t\u0017\u000e\u001e \u0015!\u0005}\u0011qEA\u0015\u0003W\ti#a\f\u00022\u0005MB\u0003BA\u0011\u0003K\u00012!a\t\u0001\u001b\u0005\u0011\u0001BCA\u0004\u00033\u0001\n\u0011q\u0001\u0002\n!1Q%!\u0007A\u0002\u0019BaaLA\r\u0001\u0004\t\u0004B\u0002 \u0002\u001a\u0001\u0007q\b\u0003\u0004J\u00033\u0001\rA\u0013\u0005\u0007\u001d\u0006e\u0001\u0019A(\t\r\u0001\fI\u00021\u0001b\u0011\u0019a\u0017\u0011\u0004a\u0001[\"I\u0011q\u0007\u0001C\u0002\u0013%\u0011\u0011H\u0001\u0006i>\u0004\u0018nY\u000b\u0002Q\"9\u0011Q\b\u0001!\u0002\u0013A\u0017A\u0002;pa&\u001c\u0007\u0005C\u0005\u0002B\u0001\u0011\r\u0011\"\u0003\u0002D\u0005)1-Y2iKV\u0011\u0011Q\t\t\u0005\u0003G\t9%C\u0002\u0002J\t\u0011\u0011cS1gW\u00064U-\u0019;ve\u0016\u001c\u0015m\u00195f\u0011!\ti\u0005\u0001Q\u0001\n\u0005\u0015\u0013AB2bG\",\u0007\u0005C\u0005\u0002R\u0001\u0011\r\u0011\"\u0003\u0002T\u0005Q1/\u001a:jC2L'0\u001a:\u0016\u0005\u0005U\u0003\u0003BA,\u0003Cj!!!\u0017\u000b\t\u0005m\u0013QL\u0001\u0005WJLxNC\u0002\u0002`!\t\u0001BZ3biV\u0014Xm]\u0005\u0005\u0003G\nIFA\u000bLef|g)Z1ukJ,7+\u001a:jC2L'0\u001a:\t\u0011\u0005\u001d\u0004\u0001)A\u0005\u0003+\n1b]3sS\u0006d\u0017N_3sA!I\u00111\u000e\u0001C\u0002\u0013%\u0011QN\u0001\rS:$XM]2faR|'o]\u000b\u0003\u0003_\u0002B!!\u001d\u0002\b:!\u00111OAA\u001d\u0011\t)(a\u001f\u000f\u0007E\f9(C\u0002\u0002z!\tQ!\u001b8eKbLA!! \u0002\u0000\u0005A\u0001\u000f\\1o]&twMC\u0002\u0002z!IA!a!\u0002\u0006\u0006\u0001\u0012+^3ss&sG/\u001a:dKB$xN\u001d\u0006\u0005\u0003{\ny(\u0003\u0003\u0002\n\u0006-%aF)vKJL\u0018J\u001c;fe\u000e,\u0007\u000f^8s\r\u0006\u001cGo\u001c:z\u0015\u0011\t\u0019)!\"\t\u0011\u0005=\u0005\u0001)A\u0005\u0003_\nQ\"\u001b8uKJ\u001cW\r\u001d;peN\u0004\u0003\"CAJ\u0001\t\u0007I\u0011BAK\u0003-\tX/\u001a:z%Vtg.\u001a:\u0016\u0005\u0005]\u0005\u0003BA\u0012\u00033K1!a'\u0003\u0005AY\u0015MZ6b#V,'/\u001f*v]:,'\u000f\u0003\u0005\u0002 \u0002\u0001\u000b\u0011BAL\u00031\tX/\u001a:z%Vtg.\u001a:!\u0011%\t\u0019\u000b\u0001b\u0001\n\u0013\t)+\u0001\u0004m_\u0006$WM]\u000b\u0003\u0003O\u0003B!a\t\u0002*&\u0019\u00111\u0016\u0002\u0003!-\u000bgm[1DC\u000eDW\rT8bI\u0016\u0014\b\u0002CAX\u0001\u0001\u0006I!a*\u0002\u000f1|\u0017\rZ3sA!I\u00111\u0017\u0001C\u0002\u0013%\u0011QW\u0001\fa\u0016\u00148/[:uK:\u001cW-\u0006\u0002\u00028B!\u0011\u0003QA]!\u0011\t\u0019#a/\n\u0007\u0005u&A\u0001\u000bECR\f7\u000b^8sKB+'o]5ti\u0016t7-\u001a\u0005\t\u0003\u0003\u0004\u0001\u0015!\u0003\u00028\u0006a\u0001/\u001a:tSN$XM\\2fA!9\u0011Q\u0019\u0001\u0005B\u0005\u001d\u0017\u0001D2sK\u0006$XmU2iK6\fGCAAe!\r\t\u00121Z\u0005\u0004\u0003\u001b\u0014\"\u0001B+oSRDq!!5\u0001\t\u0003\n9-\u0001\u0007sK6|g/Z*dQ\u0016l\u0017\rC\u0004\u0002V\u0002!\t%a6\u0002\tI,\u0017\r\u001a\u000b\u000b\u00033\fy/a@\u0003\b\tu\u0001CBAn\u0003K\fI/\u0004\u0002\u0002^*!\u0011q\\Aq\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0004\u0003GD\u0011!B;uS2\u001c\u0018\u0002BAt\u0003;\u0014\u0011c\u00117pg\u0016\f'\r\\3Ji\u0016\u0014\u0018\r^8s!\r\u0011\u00141^\u0005\u0004\u0003[\u001c$!D*j[BdWMR3biV\u0014X\r\u0003\u0006\u0002r\u0006M\u0007\u0013!a\u0001\u0003g\faAZ5mi\u0016\u0014\b\u0003B\tA\u0003k\u0004B!a>\u0002|6\u0011\u0011\u0011 \u0006\u0004\u0003c<\u0014\u0002BA\u007f\u0003s\u0014aAR5mi\u0016\u0014\bB\u0003B\u0001\u0003'\u0004\n\u00111\u0001\u0003\u0004\u0005QAO]1og\u001a|'/\\:\u0011\tE\u0001%Q\u0001\t\u0004#iC\u0007B\u0003B\u0005\u0003'\u0004\n\u00111\u0001\u0003\f\u0005)\u0001.\u001b8ugB!\u0011\u0003\u0011B\u0007!\u0011\u0011yA!\u0007\u000e\u0005\tE!\u0002\u0002B\n\u0005+\tqAZ1di>\u0014\u0018PC\u0002\u0003\u0018)\nA!\u001e;jY&!!1\u0004B\t\u0005\u0015A\u0015N\u001c;t\u0011)\u0011y\"a5\u0011\u0002\u0003\u0007!\u0011E\u0001\bKb\u0004H.Y5o!\u0011\u0011\u0019Ca\n\u000e\u0005\t\u0015\"\u0002BAr\u0003\u007fJAA!\u000b\u0003&\tIQ\t\u001f9mC&tWM\u001d\u0005\b\u0005[\u0001A\u0011\tB\u0018\u0003\u00159(/\u001b;f)\u0011\tIM!\r\t\u0011\tM\"1\u0006a\u0001\u0003S\f\u0001b\u001c:jO&t\u0017\r\u001c\u0005\b\u0005o\u0001A\u0011\tB\u001d\u0003\u0019!W\r\\3uKR!\u0011\u0011\u001aB\u001e\u0011!\u0011\u0019D!\u000eA\u0002\u0005%\bb\u0002B \u0001\u0011\u0005\u0013qY\u0001\ba\u0016\u00148/[:u\u0011\u001d\u0011\u0019\u0005\u0001C!\u0003\u000f\fQa\u00197pg\u0016D\u0011Ba\u0012\u0001#\u0003%\tE!\u0013\u0002\u001dI,\u0017\r\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\n\u0016\u0005\u0003g\u0014ie\u000b\u0002\u0003PA!!\u0011\u000bB.\u001b\t\u0011\u0019F\u0003\u0003\u0003V\t]\u0013!C;oG\",7m[3e\u0015\r\u0011IFE\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B/\u0005'\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u0011\t\u0007AI\u0001\n\u0003\u0012\u0019'\u0001\bsK\u0006$G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t\u0015$\u0006\u0002B\u0002\u0005\u001bB\u0011B!\u001b\u0001#\u0003%\tEa\u001b\u0002\u001dI,\u0017\r\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!Q\u000e\u0016\u0005\u0005\u0017\u0011i\u0005C\u0005\u0003r\u0001\t\n\u0011\"\u0011\u0003t\u0005q!/Z1eI\u0011,g-Y;mi\u0012\"TC\u0001B;U\u0011\u0011\tC!\u0014\b\u000f\te$\u0001#\u0001\u0003|\u0005Q1*\u00194lCN#xN]3\u0011\t\u0005\r\"Q\u0010\u0004\u0007\u0003\tA\tAa \u0014\u0007\tu\u0004\u0003\u0003\u0005\u0002\u001c\tuD\u0011\u0001BB)\t\u0011Y\b\u0003\u0006\u0003\b\nu$\u0019!C\u0001\u0005\u0013\u000bA\u0003T8bI&sG/\u001a:wC2\u0004&o\u001c9feRLXC\u0001BF!\u0011\u0011iIa(\u000f\t\t=%\u0011\u0014\b\u0005\u0005#\u0013)JD\u0002r\u0005'K1!a9\t\u0013\u0011\u00119*!9\u0002\t\r|gNZ\u0005\u0005\u00057\u0013i*A\fHK>lUm]1TsN$X-\u001c)s_B,'\u000f^5fg*!!qSAq\u0013\u0011\u0011\tKa)\u0003\u001dMK8\u000f^3n!J|\u0007/\u001a:us*!!1\u0014BO\u0011%\u00119K! !\u0002\u0013\u0011Y)A\u000bM_\u0006$\u0017J\u001c;feZ\fG\u000e\u0015:pa\u0016\u0014H/\u001f\u0011\b\u0011\t-&Q\u0010E\u0001\u0005[\u000bA\"T3tg\u0006<W\rV=qKN\u0004BAa,\u000326\u0011!Q\u0010\u0004\t\u0005g\u0013i\b#\u0001\u00036\naQ*Z:tC\u001e,G+\u001f9fgN\u0019!\u0011\u0017\t\t\u0011\u0005m!\u0011\u0017C\u0001\u0005s#\"A!,\t\u0015\tu&\u0011\u0017b\u0001\n\u0003\u0011y,A\u0003Xe&$X-F\u0001]\u0011!\u0011\u0019M!-!\u0002\u0013a\u0016AB,sSR,\u0007\u0005\u0003\u0006\u0003H\nE&\u0019!C\u0001\u0005\u007f\u000ba\u0001R3mKR,\u0007\u0002\u0003Bf\u0005c\u0003\u000b\u0011\u0002/\u0002\u000f\u0011+G.\u001a;fA!A\u0011q\u0007B?\t\u0003\u0011y\rF\u0003i\u0005#\u0014)\u000eC\u0004\u0003T\n5\u0007\u0019\u00015\u0002\u00059\u001c\bBB\u0018\u0003N\u0002\u0007\u0011\u0007\u0003\u0005\u00028\tuD\u0011\u0001Bm)\u0015A'1\u001cBo\u0011\u001d\u0011\u0019Na6A\u0002!DqAa8\u0003X\u0002\u0007\u0001.\u0001\u0005usB,g*Y7f\u0011!\u0011\u0019O! \u0005\u0002\t\u0015\u0018AB<ji\"T6.\u0006\u0003\u0003h\n=H\u0003\u0002Bu\u0007/!BAa;\u0004\u0002A!!Q\u001eBx\u0019\u0001!\u0001B!=\u0003b\n\u0007!1\u001f\u0002\u0002)F!!Q\u001fB~!\r\t\"q_\u0005\u0004\u0005s\u0014\"a\u0002(pi\"Lgn\u001a\t\u0004#\tu\u0018b\u0001B\u0000%\t\u0019\u0011I\\=\t\u0011\r\r!\u0011\u001da\u0001\u0007\u000b\t!A\u001a8\u0011\u000fE\u00199aa\u0003\u0003l&\u00191\u0011\u0002\n\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BB\u0007\u0007'i!aa\u0004\u000b\t\u0005\r8\u0011\u0003\u0006\u0002\u0007%!1QCB\b\u0005\u001dQ6.\u0016;jYNDqa!\u0007\u0003b\u0002\u0007\u0001.\u0001\u0006{_>\\W-\u001a9feNDqA\u0014B?\t\u0003\u0019i\u0002F\u0002P\u0007?Aqa!\t\u0004\u001c\u0001\u0007\u0011-A\u0004d_:tWm\u0019;\t\u0011\r\u0015\"Q\u0010C\u0001\u0007O\t\u0001bY8ogVlWM\u001d\u000b\u0007\u0007S\u0019\u0019d!\u000e\u0011\r\r-2qF-Z\u001b\t\u0019iCC\u0002\u0004&IKAa!\r\u0004.\tA1i\u001c8tk6,'\u000fC\u0004\u0004\"\r\r\u0002\u0019A1\t\u000f\r]21\u0005a\u0001Q\u0006)qM]8va\"I11\bB?\t\u0003\u00111QH\u0001\nG>t7/^7feN$Bba\u0010\u0004R\rM3QKB-\u0007G\u0002ba!\u0011\u0004L\r%b\u0002BB\"\u0007\u000fr1\u0001^B#\u0013\u0005\u0019\u0012bAB%%\u00059\u0001/Y2lC\u001e,\u0017\u0002BB'\u0007\u001f\u00121aU3r\u0015\r\u0019IE\u0005\u0005\b\u0007C\u0019I\u00041\u0001b\u0011\u001d\t9d!\u000fA\u0002!Dqaa\u0016\u0004:\u0001\u0007!*A\u0004nC:\fw-\u001a:\t\u0011\rm3\u0011\ba\u0001\u0007;\n1\u0002]1sC2dW\r\\5t[B\u0019\u0011ca\u0018\n\u0007\r\u0005$CA\u0002J]RD\u0001b!\u001a\u0004:\u0001\u00071qM\u0001\tG\u0006dGNY1dWBI\u0011c!\u001b\u0004^\r5\u0014\u0011Z\u0005\u0004\u0007W\u0012\"!\u0003$v]\u000e$\u0018n\u001c83!\r\t2qN\u0005\u0004\u0007c\u0012\"\u0001\u0002'p]\u001eD\u0011b!\u001e\u0003~\u0011\u0005!aa\u001e\u0002\u0019M,'/[1mSj,7*Z=\u0015\u000be\u001bIha\u001f\t\u0011\u0005=11\u000fa\u0001\u0007[Bqa! \u0004t\u0001\u0007A,\u0001\u0004bGRLwN\u001c\u0005\n\u0007\u0003\u0013i\b\"\u0001\u0003\u0007\u0007\u000ba\u0002Z3tKJL\u0017\r\\5{K.+\u0017\u0010\u0006\u0003\u0004\u0006\u000e-\u0005CB\t\u0004\b\u000e5D,C\u0002\u0004\nJ\u0011a\u0001V;qY\u0016\u0014\u0004bBBG\u0007\u007f\u0002\r!W\u0001\u0004W\u0016Lh\u0001CBI\u0005{\u0002!aa%\u0003/=3gm]3u%\u0016\u0014\u0017\r\\1oG\u0016d\u0015n\u001d;f]\u0016\u00148cBBH\u0007+\u001b\tK\u0007\t\u0005\u0007/\u001bi*\u0004\u0002\u0004\u001a*!11TA\t\u0003\u0011a\u0017M\\4\n\t\r}5\u0011\u0014\u0002\u0007\u001f\nTWm\u0019;\u0011\t\r-21U\u0005\u0005\u0007K\u001biCA\rD_:\u001cX/\\3s%\u0016\u0014\u0017\r\\1oG\u0016d\u0015n\u001d;f]\u0016\u0014\bbCB\u0013\u0007\u001f\u0013\t\u0011)A\u0005\u0007SA!ba\u0016\u0004\u0010\n\u0005\t\u0015!\u0003K\u0011-\u0019)ga$\u0003\u0002\u0003\u0006Iaa\u001a\t\u0011\u0005m1q\u0012C\u0001\u0007_#\u0002b!-\u00044\u000eU6q\u0017\t\u0005\u0005_\u001by\t\u0003\u0005\u0004&\r5\u0006\u0019AB\u0015\u0011\u001d\u00199f!,A\u0002)C\u0001b!\u001a\u0004.\u0002\u00071q\r\u0005\t\u0007w\u001by\t\"\u0011\u0004>\u0006\u0019rN\u001c)beRLG/[8ogJ+go\\6fIR!\u0011\u0011ZB`\u0011!\u0019\tm!/A\u0002\r\r\u0017a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0011\r\r\u00157\u0011ZBg\u001b\t\u00199M\u0003\u0003\u0003\u0018\u0005E\u0011\u0002BBf\u0007\u000f\u0014!bQ8mY\u0016\u001cG/[8o!\u0011\u0019ym!6\u000e\u0005\rE'bABj)\u000611m\\7n_:LAaa6\u0004R\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0002CBn\u0007\u001f#\te!8\u0002)=t\u0007+\u0019:uSRLwN\\:BgNLwM\\3e)\u0011\tIma8\t\u0011\r\u00057\u0011\u001ca\u0001\u0007\u00074qaa9\u0003~\u0001\u0019)O\u0001\u000bGK\u0006$XO]3JIB\u000b'\u000f^5uS>tWM]\n\u0007\u0007C\u001c)ja:\u0011\u0007A\u001bI/C\u0002\u0004lF\u00131\u0002U1si&$\u0018n\u001c8fe\"A\u00111DBq\t\u0003\u0019y\u000f\u0006\u0002\u0004rB!!qVBq\u0011!\u0019)p!9\u0005B\r]\u0018!\u00039beRLG/[8o)9\u0019if!?\u0004|\u000euH\u0011\u0001C\u0003\t\u0013Aq!a\u000e\u0004t\u0002\u0007\u0001\u000e\u0003\u0005\u0004\u000e\u000eM\b\u0019\u0001B~\u0011\u001d\u0019ypa=A\u0002e\u000b\u0001b[3z\u0005f$Xm\u001d\u0005\t\t\u0007\u0019\u0019\u00101\u0001\u0003|\u0006)a/\u00197vK\"9AqABz\u0001\u0004I\u0016A\u0003<bYV,')\u001f;fg\"AA1BBz\u0001\u0004!i!A\u0004dYV\u001cH/\u001a:\u0011\t\r=GqB\u0005\u0005\t#\u0019\tNA\u0004DYV\u001cH/\u001a:\t\u0011\u0011U1\u0011\u001dC!\t/\t\u0011bY8oM&<WO]3\u0015\t\u0005%G\u0011\u0004\u0005\t\t7!\u0019\u00021\u0001\u0005\u001e\u000591m\u001c8gS\u001e\u001c\b\u0007\u0002C\u0010\tK\u0001ra!2\u0005\"!$\u0019#C\u0002g\u0007\u000f\u0004BA!<\u0005&\u0011aAq\u0005C\r\u0003\u0003\u0005\tQ!\u0001\u0003t\n\u0019q\fJ\u0019\t\u0011\t\r3\u0011\u001dC!\u0003\u000fD!\u0002\"\f\u0003~E\u0005I\u0011\u0001C\u0018\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%qQ\u0001B\u0011\u0007C\u001a\tk!9\u0004\"\u000f\u0005<\u0011uBq\b\u0016\u0005\u0003\u0013\u0011i\u0005\u0003\u0004&\tW\u0001\rA\n\u0005\u0007_\u0011-\u0002\u0019A\u0019\t\ry\"Y\u00031\u0001@\u0011\u0019IE1\u0006a\u0001\u0015\"1a\nb\u000bA\u0002=Ca\u0001\u0019C\u0016\u0001\u0004\t\u0007B\u00027\u0005,\u0001\u0007Q\u000e")
public class KafkaStore
implements TransientStore,
LazyLogging {
    private final DataStore ds;
    private final SimpleFeatureType sft;
    private final OffsetManager offsetManager;
    private final Producer<byte[], byte[]> producer;
    public final LambdaDataStore.LambdaConfig org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$config;
    private final Clock clock;
    private final String org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$topic;
    private final KafkaFeatureCache org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$cache;
    private final KryoFeatureSerializer serializer;
    private final QueryInterceptor.QueryInterceptorFactory interceptors;
    private final KafkaQueryRunner queryRunner;
    private final KafkaCacheLoader loader;
    private final Option<DataStorePersistence> persistence;
    private final Logger logger;
    private final GeoMesaStats stats;
    private volatile boolean bitmap$0;

    public static Clock $lessinit$greater$default$8(DataStore dataStore, SimpleFeatureType simpleFeatureType, Option<AuthorizationsProvider> option, OffsetManager offsetManager, Producer<byte[], byte[]> producer2, scala.collection.immutable.Map<String, String> map, LambdaDataStore.LambdaConfig lambdaConfig) {
        return KafkaStore$.MODULE$.$lessinit$greater$default$8(dataStore, simpleFeatureType, option, offsetManager, producer2, map, lambdaConfig);
    }

    public static Consumer<byte[], byte[]> consumer(scala.collection.immutable.Map<String, String> map, String string) {
        return KafkaStore$.MODULE$.consumer(map, string);
    }

    public static <T> T withZk(String string, Function1<ZkUtils, T> function1) {
        return KafkaStore$.MODULE$.withZk(string, function1);
    }

    public static String topic(String string, String string2) {
        return KafkaStore$.MODULE$.topic(string, string2);
    }

    public static String topic(String string, SimpleFeatureType simpleFeatureType) {
        return KafkaStore$.MODULE$.topic(string, simpleFeatureType);
    }

    public static GeoMesaSystemProperties.SystemProperty LoadIntervalProperty() {
        return KafkaStore$.MODULE$.LoadIntervalProperty();
    }

    private Logger logger$lzycompute() {
        KafkaStore kafkaStore = this;
        synchronized (kafkaStore) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public GeoMesaStats stats() {
        return this.stats;
    }

    @Override
    public void org$locationtech$geomesa$lambda$stream$TransientStore$_setter_$stats_$eq(GeoMesaStats x$1) {
        this.stats = x$1;
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    public String org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$topic() {
        return this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$topic;
    }

    public KafkaFeatureCache org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$cache() {
        return this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$cache;
    }

    private KryoFeatureSerializer serializer() {
        return this.serializer;
    }

    private QueryInterceptor.QueryInterceptorFactory interceptors() {
        return this.interceptors;
    }

    private KafkaQueryRunner queryRunner() {
        return this.queryRunner;
    }

    private KafkaCacheLoader loader() {
        return this.loader;
    }

    private Option<DataStorePersistence> persistence() {
        return this.persistence;
    }

    @Override
    public void createSchema() {
        KafkaStore$.MODULE$.withZk(this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$config.zookeepers(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaStore $outer;

            public final void apply(ZkUtils zk) {
                if (AdminUtils$.MODULE$.topicExists(zk, this.$outer.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$topic())) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.logger().underlying().isWarnEnabled()) {
                        this.$outer.logger().underlying().warn("Topic [{}] already exists - it may contain stale data", new Object[]{this.$outer.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$topic()});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    int replication = BoxesRunTime.unboxToInt((Object)new GeoMesaSystemProperties.SystemProperty("geomesa.kafka.replication", GeoMesaSystemProperties.SystemProperty$.MODULE$.apply$default$2()).option().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(String x$1) {
                            return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return 1;
                        }
                    }));
                    AdminUtilsVersions$.MODULE$.createTopic(zk, this.$outer.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$topic(), this.$outer.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$config.partitions(), replication);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public void removeSchema() {
        this.offsetManager.deleteOffsets(this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$topic());
        KafkaStore$.MODULE$.withZk(this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$config.zookeepers(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaStore $outer;

            public final void apply(ZkUtils zk) {
                try {
                    if (AdminUtils$.MODULE$.topicExists(zk, this.$outer.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$topic())) {
                        AdminUtils$.MODULE$.deleteTopic(zk, this.$outer.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$topic());
                    }
                }
                catch (TopicAlreadyMarkedForDeletionException topicAlreadyMarkedForDeletionException) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.logger().underlying().isWarnEnabled()) {
                        this.$outer.logger().underlying().warn("Topic is already marked for deletion");
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public CloseableIterator<SimpleFeature> read(Option<Filter> filter2, Option<String[]> transforms, Option<Hints> hints, Explainer explain) {
        Query query = new Query();
        filter2.foreach((Function1)new Serializable(this, query){
            public static final long serialVersionUID = 0L;
            private final Query query$1;

            public final void apply(Filter x$1) {
                this.query$1.setFilter(x$1);
            }
            {
                this.query$1 = query$1;
            }
        });
        transforms.foreach((Function1)new Serializable(this, query){
            public static final long serialVersionUID = 0L;
            private final Query query$1;

            public final void apply(String[] x$1) {
                this.query$1.setPropertyNames(x$1);
            }
            {
                this.query$1 = query$1;
            }
        });
        hints.foreach((Function1)new Serializable(this, query){
            public static final long serialVersionUID = 0L;
            private final Query query$1;

            public final void apply(Hints x$1) {
                this.query$1.setHints(x$1);
            }
            {
                this.query$1 = query$1;
            }
        });
        return this.queryRunner().runQuery(this.sft(), query, explain);
    }

    @Override
    public Option<Filter> read$default$1() {
        return None$.MODULE$;
    }

    @Override
    public Option<String[]> read$default$2() {
        return None$.MODULE$;
    }

    @Override
    public Option<Hints> read$default$3() {
        return None$.MODULE$;
    }

    @Override
    public Explainer read$default$4() {
        return new ExplainLogging();
    }

    @Override
    public void write(SimpleFeature original) {
        BoxedUnit boxedUnit;
        SimpleFeature feature = GeoMesaFeatureWriter$.MODULE$.featureWithFid(this.sft(), original);
        byte[] key = KafkaStore$.MODULE$.serializeKey(this.clock.millis(), KafkaStore$MessageTypes$.MODULE$.Write());
        this.producer.send(new ProducerRecord(this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$topic(), (Object)key, (Object)this.serializer().serialize(feature)));
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Wrote feature to [{}]: {}", new Object[]{this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$topic(), feature});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public void delete(SimpleFeature original) {
        SimpleFeature feature = GeoMesaFeatureWriter$.MODULE$.featureWithFid(this.sft(), original);
        byte[] key = KafkaStore$.MODULE$.serializeKey(this.clock.millis(), KafkaStore$MessageTypes$.MODULE$.Delete());
        this.producer.send(new ProducerRecord(this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$topic(), (Object)key, (Object)this.serializer().serialize(feature)));
        if (this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$config.persist()) {
            Id filter2 = package$.MODULE$.ff().id(new FeatureId[]{package$.MODULE$.ff().featureId(feature.getID())});
            package.WithClose$.MODULE$.apply((Object)this.ds.getFeatureWriter(this.sft().getTypeName(), (Filter)filter2, Transaction.AUTO_COMMIT), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(FeatureWriter<SimpleFeatureType, SimpleFeature> writer) {
                    while (writer.hasNext()) {
                        writer.next();
                        writer.remove();
                    }
                }
            }, IsCloseable$.MODULE$.closeableIsCloseable());
        }
    }

    @Override
    public void persist() {
        Option<DataStorePersistence> option = this.persistence();
        if (option instanceof Some) {
            Some some = (Some)option;
            DataStorePersistence p = (DataStorePersistence)some.x();
            p.run();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalStateException("Persistence disabled for this store");
        }
        throw new MatchError(option);
    }

    @Override
    public void close() {
        package.CloseWithLogging$.MODULE$.apply((Object)this.loader(), IsCloseable$.MODULE$.closeableIsCloseable());
        package.CloseWithLogging$.MODULE$.apply((Object)this.interceptors(), IsCloseable$.MODULE$.closeableIsCloseable());
        package.CloseWithLogging$.MODULE$.apply(this.persistence(), (IsCloseable)IsCloseable$.MODULE$.optionIsCloseable());
        this.offsetManager.removeOffsetListener(this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$topic(), this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$cache());
    }

    public KafkaStore(DataStore ds, SimpleFeatureType sft, Option<AuthorizationsProvider> authProvider, OffsetManager offsetManager, Producer<byte[], byte[]> producer2, scala.collection.immutable.Map<String, String> consumerConfig, LambdaDataStore.LambdaConfig config, Clock clock) {
        this.ds = ds;
        this.sft = sft;
        this.offsetManager = offsetManager;
        this.producer = producer2;
        this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$config = config;
        this.clock = clock;
        TransientStore$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$topic = KafkaStore$.MODULE$.topic(config.zkNamespace(), sft);
        this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$cache = new KafkaFeatureCache(this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$topic());
        Set options = SerializationOption.SerializationOptions$.MODULE$.builder().withUserData().immutable().lazy().build();
        this.serializer = KryoFeatureSerializer$.MODULE$.apply(sft, options);
        this.interceptors = QueryInterceptor.QueryInterceptorFactory$.MODULE$.apply(ds);
        this.queryRunner = new KafkaQueryRunner(this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$cache(), this.stats(), authProvider, this.interceptors());
        Seq<Consumer<byte[], byte[]>> consumers2 = KafkaStore$.MODULE$.consumers(consumerConfig, this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$topic(), offsetManager, config.consumers(), (Function2<Object, Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaStore $outer;

            public final void apply(int partition, long offset) {
                this.apply$mcVIJ$sp(partition, offset);
            }

            public void apply$mcVIJ$sp(int partition, long offset) {
                this.$outer.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$cache().partitionAssigned(partition, offset);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        long frequency = ((Duration)KafkaStore$.MODULE$.LoadIntervalProperty().toDuration().get()).toMillis();
        this.loader = new KafkaCacheLoader(consumers2, this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$topic(), frequency, this.serializer(), this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$cache());
        Duration duration = config.expiry();
        Duration.Infinite infinite = Duration$.MODULE$.Inf();
        this.persistence = !(duration != null ? !duration.equals(infinite) : infinite != null) ? None$.MODULE$ : new Some((Object)new DataStorePersistence(ds, sft, offsetManager, this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$cache(), this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$topic(), config.expiry().toMillis(), config.persist(), clock));
        offsetManager.addOffsetListener(this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$topic(), this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$$cache());
    }

    public static class FeatureIdPartitioner
    implements Partitioner {
        public int partition(String topic, Object key, byte[] keyBytes, Object value, byte[] valueBytes, Cluster cluster) {
            int count = cluster.partitionsForTopic(topic).size();
            String id = KryoFeatureDeserialization$.MODULE$.getInput(valueBytes, 5, valueBytes.length - 5).readString();
            return Math.abs(MurmurHash3$.MODULE$.stringHash(id)) % count;
        }

        public void configure(Map<String, ?> configs) {
        }

        public void close() {
        }
    }

    public static class OffsetRebalanceListener
    implements ConsumerRebalanceListener,
    LazyLogging {
        public final Consumer<byte[], byte[]> org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$OffsetRebalanceListener$$consumer;
        public final OffsetManager org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$OffsetRebalanceListener$$manager;
        public final Function2<Object, Object, BoxedUnit> org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$OffsetRebalanceListener$$callback;
        private final Logger logger;
        private volatile boolean bitmap$0;

        private Logger logger$lzycompute() {
            OffsetRebalanceListener offsetRebalanceListener = this;
            synchronized (offsetRebalanceListener) {
                if (!this.bitmap$0) {
                    this.logger = LazyLogging.class.logger((LazyLogging)this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        public void onPartitionsRevoked(Collection<TopicPartition> topicPartitions) {
        }

        public void onPartitionsAssigned(Collection<TopicPartition> topicPartitions) {
            JavaConversions$.MODULE$.collectionAsScalaIterable(topicPartitions).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ OffsetRebalanceListener $outer;

                public final void apply(TopicPartition tp) {
                    long l;
                    long lastRead = this.$outer.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$OffsetRebalanceListener$$manager.getOffset(tp.topic(), tp.partition());
                    KafkaConsumerVersions$.MODULE$.pause(this.$outer.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$OffsetRebalanceListener$$consumer, tp);
                    if (lastRead < 0L) {
                        l = this.seekToBeginning$1(tp);
                    } else {
                        try {
                            this.$outer.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$OffsetRebalanceListener$$consumer.seek(tp, lastRead + 1L);
                            l = lastRead;
                        }
                        catch (Throwable throwable) {
                            long l2;
                            BoxedUnit boxedUnit;
                            Throwable throwable2 = throwable;
                            Option option = NonFatal$.MODULE$.unapply(throwable2);
                            if (option.isEmpty()) {
                                throw throwable;
                            }
                            Throwable e = (Throwable)option.get();
                            if (this.$outer.logger().underlying().isWarnEnabled()) {
                                this.$outer.logger().underlying().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error seeking to initial offset: [", ":", ":", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp.topic(), BoxesRunTime.boxToInteger((int)tp.partition()), BoxesRunTime.boxToLong((long)lastRead)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", seeking to beginning: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e}))).toString());
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            l = l2 = this.seekToBeginning$1(tp);
                        }
                    }
                    long offset = l;
                    this.$outer.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$OffsetRebalanceListener$$callback.apply$mcVIJ$sp(tp.partition(), offset);
                    KafkaConsumerVersions$.MODULE$.resume(this.$outer.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$OffsetRebalanceListener$$consumer, tp);
                }

                private final long seekToBeginning$1(TopicPartition tp$1) {
                    KafkaConsumerVersions$.MODULE$.seekToBeginning(this.$outer.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$OffsetRebalanceListener$$consumer, tp$1);
                    return this.$outer.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$OffsetRebalanceListener$$consumer.position(tp$1) - 1L;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public OffsetRebalanceListener(Consumer<byte[], byte[]> consumer2, OffsetManager manager, Function2<Object, Object, BoxedUnit> callback) {
            this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$OffsetRebalanceListener$$consumer = consumer2;
            this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$OffsetRebalanceListener$$manager = manager;
            this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$OffsetRebalanceListener$$callback = callback;
            LazyLogging.class.$init$((LazyLogging)this);
        }
    }
}

