/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.metrics.reporters;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.io.File;
import java.io.FileWriter;
import java.util.Locale;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.locationtech.geomesa.metrics.reporters.DelimitedFileReporter$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

@ScalaSignature(bytes="\u0006\u0001\r]q!B\u0001\u0003\u0011\u0003i\u0011!\u0006#fY&l\u0017\u000e^3e\r&dWMU3q_J$XM\u001d\u0006\u0003\u0007\u0011\t\u0011B]3q_J$XM]:\u000b\u0005\u00151\u0011aB7fiJL7m\u001d\u0006\u0003\u000f!\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\n\u0015\u0005aAn\\2bi&|g\u000e^3dQ*\t1\"A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u000f\u001f5\t!AB\u0003\u0011\u0005!\u0005\u0011CA\u000bEK2LW.\u001b;fI\u001aKG.\u001a*fa>\u0014H/\u001a:\u0014\u0005=\u0011\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\rC\u0003\u001a\u001f\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u0002\u001b!9Ad\u0004b\u0001\n\u0003i\u0012!C4bk\u001e,7i\u001c7t+\u0005q\u0002cA\n C%\u0011\u0001\u0005\u0006\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005'\t\"C%\u0003\u0002$)\t1A+\u001e9mKJ\u0002\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\t1\fgn\u001a\u0006\u0002S\u0005!!.\u0019<b\u0013\tYcE\u0001\u0004TiJLgn\u001a\u0005\u0007[=\u0001\u000b\u0011\u0002\u0010\u0002\u0015\u001d\fWoZ3D_2\u001c\b\u0005C\u00040\u001f\t\u0007I\u0011A\u000f\u0002\u0017\r|WO\u001c;fe\u000e{Gn\u001d\u0005\u0007c=\u0001\u000b\u0011\u0002\u0010\u0002\u0019\r|WO\u001c;fe\u000e{Gn\u001d\u0011\t\u000fMz!\u0019!C\u0001;\u0005i\u0001.[:u_\u001e\u0014\u0018-\\\"pYNDa!N\b!\u0002\u0013q\u0012A\u00045jgR|wM]1n\u0007>d7\u000f\t\u0005\bo=\u0011\r\u0011\"\u0001\u001e\u0003%iW\r^3s\u0007>d7\u000f\u0003\u0004:\u001f\u0001\u0006IAH\u0001\u000b[\u0016$XM]\"pYN\u0004\u0003bB\u001e\u0010\u0005\u0004%\t!H\u0001\ni&lWM]\"pYNDa!P\b!\u0002\u0013q\u0012A\u0003;j[\u0016\u00148i\u001c7tA!)qh\u0004C\u0001\u0001\u0006Yam\u001c:SK\u001eL7\u000f\u001e:z)\r\t5Q\u0003\t\u0003\u0005\u000ek\u0011a\u0004\u0004\u0005\t>\u0001QIA\u0004Ck&dG-\u001a:\u0014\u0005\r\u0013\u0002\u0002C$D\u0005\u0003\u0005\u000b\u0011\u0002%\u0002\u0011I,w-[:uef\u0004\"!S(\u000e\u0003)S!!B&\u000b\u00051k\u0015\u0001C2pI\u0006D\u0017\r\\3\u000b\u00039\u000b1aY8n\u0013\t\u0001&J\u0001\bNKR\u0014\u0018n\u0019*fO&\u001cHO]=\t\re\u0019E\u0011\u0001\u0003S)\t\t5\u000bC\u0003H#\u0002\u0007\u0001\nC\u0004V\u0007\u0002\u0007I\u0011\u0002,\u0002\r1|7-\u00197f+\u00059\u0006C\u0001-\\\u001b\u0005I&B\u0001.)\u0003\u0011)H/\u001b7\n\u0005qK&A\u0002'pG\u0006dW\rC\u0004_\u0007\u0002\u0007I\u0011B0\u0002\u00151|7-\u00197f?\u0012*\u0017\u000f\u0006\u0002aGB\u00111#Y\u0005\u0003ER\u0011A!\u00168ji\"9A-XA\u0001\u0002\u00049\u0016a\u0001=%c!1am\u0011Q!\n]\u000bq\u0001\\8dC2,\u0007\u0005C\u0004i\u0007\u0002\u0007I\u0011B5\u0002\u0011I\fG/Z+oSR,\u0012A\u001b\t\u0003W:l\u0011\u0001\u001c\u0006\u0003[f\u000b!bY8oGV\u0014(/\u001a8u\u0013\tyGN\u0001\u0005US6,WK\\5u\u0011\u001d\t8\t1A\u0005\nI\fAB]1uKVs\u0017\u000e^0%KF$\"\u0001Y:\t\u000f\u0011\u0004\u0018\u0011!a\u0001U\"1Qo\u0011Q!\n)\f\u0011B]1uKVs\u0017\u000e\u001e\u0011\t\u000f]\u001c\u0005\u0019!C\u0005S\u0006aA-\u001e:bi&|g.\u00168ji\"9\u0011p\u0011a\u0001\n\u0013Q\u0018\u0001\u00053ve\u0006$\u0018n\u001c8V]&$x\fJ3r)\t\u00017\u0010C\u0004eq\u0006\u0005\t\u0019\u00016\t\ru\u001c\u0005\u0015)\u0003k\u00035!WO]1uS>tWK\\5uA!Aqp\u0011a\u0001\n\u0013\t\t!A\u0003dY>\u001c7.\u0006\u0002\u0002\u0004A\u0019\u0011*!\u0002\n\u0007\u0005\u001d!JA\u0003DY>\u001c7\u000eC\u0005\u0002\f\r\u0003\r\u0011\"\u0003\u0002\u000e\u0005I1\r\\8dW~#S-\u001d\u000b\u0004A\u0006=\u0001\"\u00033\u0002\n\u0005\u0005\t\u0019AA\u0002\u0011!\t\u0019b\u0011Q!\n\u0005\r\u0011AB2m_\u000e\\\u0007\u0005C\u0005\u0002\u0018\r\u0003\r\u0011\"\u0003\u0002\u001a\u00051a-\u001b7uKJ,\"!a\u0007\u0011\u0007%\u000bi\"C\u0002\u0002 )\u0013A\"T3ue&\u001cg)\u001b7uKJD\u0011\"a\tD\u0001\u0004%I!!\n\u0002\u0015\u0019LG\u000e^3s?\u0012*\u0017\u000fF\u0002a\u0003OA\u0011\u0002ZA\u0011\u0003\u0003\u0005\r!a\u0007\t\u0011\u0005-2\t)Q\u0005\u00037\tqAZ5mi\u0016\u0014\b\u0005C\u0005\u00020\r\u0003\r\u0011\"\u0003\u00022\u0005I\u0011mZ4sK\u001e\fG/Z\u000b\u0003\u0003g\u00012aEA\u001b\u0013\r\t9\u0004\u0006\u0002\b\u0005>|G.Z1o\u0011%\tYd\u0011a\u0001\n\u0013\ti$A\u0007bO\u001e\u0014XmZ1uK~#S-\u001d\u000b\u0004A\u0006}\u0002\"\u00033\u0002:\u0005\u0005\t\u0019AA\u001a\u0011!\t\u0019e\u0011Q!\n\u0005M\u0012AC1hOJ,w-\u0019;fA!I\u0011qI\"A\u0002\u0013%\u0011\u0011J\u0001\u0007M>\u0014X.\u0019;\u0016\u0005\u0005-\u0003\u0003BA'\u00037j!!a\u0014\u000b\t\u0005E\u00131K\u0001\u0004GN4(\u0002BA+\u0003/\nqaY8n[>t7OC\u0002\u0002Z)\ta!\u00199bG\",\u0017\u0002BA/\u0003\u001f\u0012\u0011bQ*W\r>\u0014X.\u0019;\t\u0013\u0005\u00054\t1A\u0005\n\u0005\r\u0014A\u00034pe6\fGo\u0018\u0013fcR\u0019\u0001-!\u001a\t\u0013\u0011\fy&!AA\u0002\u0005-\u0003\u0002CA5\u0007\u0002\u0006K!a\u0013\u0002\u000f\u0019|'/\\1uA!9\u0011QN\"\u0005\u0002\u0005=\u0014!\u00034pe6\fGOR8s)\r\t\u0015\u0011\u000f\u0005\u0007+\u0006-\u0004\u0019A,\t\u000f\u0005U4\t\"\u0001\u0002x\u0005q1m\u001c8wKJ$(+\u0019;fgR{GcA!\u0002z!1\u0001.a\u001dA\u0002)Dq!! D\t\u0003\ty(\u0001\nd_:4XM\u001d;EkJ\fG/[8ogR{GcA!\u0002\u0002\"1q/a\u001fA\u0002)Dq!!\"D\t\u0003\t9)A\u0005xSRD7\t\\8dWR\u0019\u0011)!#\t\u000f}\f\u0019\t1\u0001\u0002\u0004!9\u0011qC\"\u0005\u0002\u00055EcA!\u0002\u0010\"A\u0011qCAF\u0001\u0004\tY\u0002C\u0004\u00020\r#\t!a%\u0015\u0007\u0005\u000b)\n\u0003\u0005\u00020\u0005E\u0005\u0019AA\u001a\u0011\u001d\tIj\u0011C\u0001\u00037\u000b!b^5uQ\u000e{W.\\1t)\u0005\t\u0005bBAP\u0007\u0012\u0005\u00111T\u0001\to&$\b\u000eV1cg\"9\u00111U\"\u0005\u0002\u0005\u0015\u0016!\u00022vS2$G\u0003BAT\u0007'\u00012ADAU\r\u0015\u0001\"\u0001AAV'\u0011\tI+!,\u0011\u0007%\u000by+C\u0002\u00022*\u0013\u0011cU2iK\u0012,H.\u001a3SKB|'\u000f^3s\u0011%9\u0015\u0011\u0016B\u0001B\u0003%\u0001\nC\u0006\u00028\u0006%&\u0011!Q\u0001\n\u0005e\u0016\u0001\u00029bi\"\u0004B!a/\u0002B:\u00191#!0\n\u0007\u0005}F#\u0001\u0004Qe\u0016$WMZ\u0005\u0004W\u0005\r'bAA`)!Y\u0011qFAU\u0005\u0003\u0005\u000b\u0011BA\u001a\u0011-\t9%!+\u0003\u0002\u0003\u0006I!a\u0013\t\u0015}\fIK!A!\u0002\u0013\t\u0019\u0001C\u0005V\u0003S\u0013\t\u0011)A\u0005/\"Y\u0011qCAU\u0005\u0003\u0005\u000b\u0011BA\u000e\u0011%A\u0017\u0011\u0016B\u0001B\u0003%!\u000eC\u0005x\u0003S\u0013\t\u0011)A\u0005U\"9\u0011$!+\u0005\n\u0005UG\u0003FAT\u0003/\fI.a7\u0002^\u0006}\u0017\u0011]Ar\u0003K\f9\u000f\u0003\u0004H\u0003'\u0004\r\u0001\u0013\u0005\t\u0003o\u000b\u0019\u000e1\u0001\u0002:\"A\u0011qFAj\u0001\u0004\t\u0019\u0004\u0003\u0005\u0002H\u0005M\u0007\u0019AA&\u0011\u001dy\u00181\u001ba\u0001\u0003\u0007Aa!VAj\u0001\u00049\u0006\u0002CA\f\u0003'\u0004\r!a\u0007\t\r!\f\u0019\u000e1\u0001k\u0011\u00199\u00181\u001ba\u0001U\"Q\u00111^AU\u0005\u0004%I!!<\u0002\u000f]\u0014\u0018\u000e^3sgV\u0011\u0011q\u001e\t\t\u0003c\fY0!/\u0002\u00006\u0011\u00111\u001f\u0006\u0005\u0003k\f90A\u0004nkR\f'\r\\3\u000b\u0007\u0005eH#\u0001\u0006d_2dWm\u0019;j_:LA!!@\u0002t\n\u0019Q*\u00199\u0011\t\u00055#\u0011A\u0005\u0005\u0005\u0007\tyE\u0001\u0006D'Z\u0003&/\u001b8uKJD\u0011Ba\u0002\u0002*\u0002\u0006I!a<\u0002\u0011]\u0014\u0018\u000e^3sg\u0002B!Ba\u0003\u0002*\n\u0007I\u0011\u0002B\u0007\u0003\u00191w\u000e\u001c3feV\u0011!q\u0002\t\u0005\u0005#\u00119\"\u0004\u0002\u0003\u0014)\u0019!Q\u0003\u0015\u0002\u0005%|\u0017\u0002\u0002B\r\u0005'\u0011AAR5mK\"I!QDAUA\u0003%!qB\u0001\bM>dG-\u001a:!\u0011)\u0011\t#!+C\u0002\u0013%!1E\u0001\fi&lW-\u00128d_\u0012,'/\u0006\u0002\u0003&A!!q\u0005B\u001a\u001b\t\u0011IC\u0003\u0003\u0002H\t-\"\u0002\u0002B\u0017\u0005_\tA\u0001^5nK*\u0019!\u0011\u0007\u0006\u0002\t)|G-Y\u0005\u0005\u0005k\u0011ICA\tECR,G+[7f\r>\u0014X.\u0019;uKJD\u0011B!\u000f\u0002*\u0002\u0006IA!\n\u0002\u0019QLW.Z#oG>$WM\u001d\u0011\t\u0011\tu\u0012\u0011\u0016C\u0001\u0005\u007f\tQA\u001a7vg\"$\u0012\u0001\u0019\u0005\t\u0005\u0007\nI\u000b\"\u0011\u0003@\u0005!1\u000f^8q\u0011!\u00119%!+\u0005B\t%\u0013A\u0002:fa>\u0014H\u000fF\u0006a\u0005\u0017\u0012\u0019Ha \u0003\f\n]\u0005\u0002\u0003B'\u0005\u000b\u0002\rAa\u0014\u0002\r\u001d\fWoZ3t!\u001dA&\u0011KA]\u0005+J1Aa\u0015Z\u0005%\u0019vN\u001d;fI6\u000b\u0007\u000f\r\u0003\u0003X\t\u0005\u0004#B%\u0003Z\tu\u0013b\u0001B.\u0015\n)q)Y;hKB!!q\fB1\u0019\u0001!ABa\u0019\u0003L\u0005\u0005\t\u0011!B\u0001\u0005K\u00121a\u0018\u00132#\u0011\u00119G!\u001c\u0011\u0007M\u0011I'C\u0002\u0003lQ\u0011qAT8uQ&tw\rE\u0002\u0014\u0005_J1A!\u001d\u0015\u0005\r\te.\u001f\u0005\t\u0005k\u0012)\u00051\u0001\u0003x\u0005A1m\\;oi\u0016\u00148\u000fE\u0004Y\u0005#\nIL!\u001f\u0011\u0007%\u0013Y(C\u0002\u0003~)\u0013qaQ8v]R,'\u000f\u0003\u0005\u0003\u0002\n\u0015\u0003\u0019\u0001BB\u0003)A\u0017n\u001d;pOJ\fWn\u001d\t\b1\nE\u0013\u0011\u0018BC!\rI%qQ\u0005\u0004\u0005\u0013S%!\u0003%jgR|wM]1n\u0011!\u0011iI!\u0012A\u0002\t=\u0015AB7fi\u0016\u00148\u000fE\u0004Y\u0005#\nIL!%\u0011\u0007%\u0013\u0019*C\u0002\u0003\u0016*\u0013Q!T3uKJD\u0001B!'\u0003F\u0001\u0007!1T\u0001\u0007i&lWM]:\u0011\u000fa\u0013\t&!/\u0003\u001eB\u0019\u0011Ja(\n\u0007\t\u0005&JA\u0003US6,'\u000f\u0003\u0005\u0003&\u0006%F\u0011\u0002BT\u0003)9(/\u001b;f\u000f\u0006,x-\u001a\u000b\bA\n%&Q\u0016BY\u0011!\u0011YKa)A\u0002\u0005e\u0016\u0001\u00028b[\u0016D\u0001Ba,\u0003$\u0002\u0007\u0011\u0011X\u0001\ni&lWm\u001d;b[BD\u0001Ba-\u0003$\u0002\u0007!QW\u0001\u0006O\u0006,x-\u001a\u0019\u0005\u0005o\u0013Y\fE\u0003J\u00053\u0012I\f\u0005\u0003\u0003`\tmF\u0001\u0004B_\u0005c\u000b\t\u0011!A\u0003\u0002\t\u0015$aA0%e!A!\u0011YAU\t\u0013\u0011\u0019-\u0001\u0007xe&$XmQ8v]R,'\u000fF\u0004a\u0005\u000b\u00149M!3\t\u0011\t-&q\u0018a\u0001\u0003sC\u0001Ba,\u0003@\u0002\u0007\u0011\u0011\u0018\u0005\t\u0005\u0017\u0014y\f1\u0001\u0003z\u000591m\\;oi\u0016\u0014\b\u0002\u0003Bh\u0003S#IA!5\u0002\u001d]\u0014\u0018\u000e^3ISN$xn\u001a:b[R9\u0001Ma5\u0003V\n]\u0007\u0002\u0003BV\u0005\u001b\u0004\r!!/\t\u0011\t=&Q\u001aa\u0001\u0003sC\u0001B!7\u0003N\u0002\u0007!QQ\u0001\nQ&\u001cHo\\4sC6D\u0001B!8\u0002*\u0012%!q\\\u0001\u000boJLG/Z'fi\u0016\u0014Hc\u00021\u0003b\n\r(Q\u001d\u0005\t\u0005W\u0013Y\u000e1\u0001\u0002:\"A!q\u0016Bn\u0001\u0004\tI\f\u0003\u0005\u0003h\nm\u0007\u0019\u0001BI\u0003\u0015iW\r^3s\u0011!\u0011Y/!+\u0005\n\t5\u0018AC<sSR,G+[7feR9\u0001Ma<\u0003r\nM\b\u0002\u0003BV\u0005S\u0004\r!!/\t\u0011\t=&\u0011\u001ea\u0001\u0003sC\u0001B!>\u0003j\u0002\u0007!QT\u0001\u0006i&lWM\u001d\u0005\t\u0005s\fI\u000b\"\u0003\u0003|\u0006)qO]5uKRY\u0001M!@\u0004\u0002\r%11BB\u0007\u0011!\u0011yPa>A\u0002\u0005e\u0016AB7fiJL7\r\u0003\u0005\u0004\u0004\t]\b\u0019AB\u0003\u0003\u0011\u0019w\u000e\\:\u0011\tMy2q\u0001\t\u0007'\t\nI,!/\t\u0011\t-&q\u001fa\u0001\u0003sC\u0001Ba,\u0003x\u0002\u0007\u0011\u0011\u0018\u0005\t\u0007\u001f\u00119\u00101\u0001\u0004\u0012\u00051a/\u00197vKN\u0004BaE\u0010\u0003n!A\u0011qWAQ\u0001\u0004\tI\fC\u0003H}\u0001\u0007\u0001\n")
public class DelimitedFileReporter
extends ScheduledReporter {
    public final String org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$path;
    public final boolean org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$aggregate;
    public final CSVFormat org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$format;
    private final Clock clock;
    private final Locale locale;
    private final Map<String, CSVPrinter> writers;
    private final File org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$folder;
    private final DateTimeFormatter timeEncoder;

    public static Builder forRegistry(MetricRegistry metricRegistry) {
        return DelimitedFileReporter$.MODULE$.forRegistry(metricRegistry);
    }

    public static Tuple2<String, String>[] timerCols() {
        return DelimitedFileReporter$.MODULE$.timerCols();
    }

    public static Tuple2<String, String>[] meterCols() {
        return DelimitedFileReporter$.MODULE$.meterCols();
    }

    public static Tuple2<String, String>[] histogramCols() {
        return DelimitedFileReporter$.MODULE$.histogramCols();
    }

    public static Tuple2<String, String>[] counterCols() {
        return DelimitedFileReporter$.MODULE$.counterCols();
    }

    public static Tuple2<String, String>[] gaugeCols() {
        return DelimitedFileReporter$.MODULE$.gaugeCols();
    }

    private Map<String, CSVPrinter> writers() {
        return this.writers;
    }

    public File org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$folder() {
        return this.org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$folder;
    }

    private DateTimeFormatter timeEncoder() {
        return this.timeEncoder;
    }

    public void flush() {
        Map<String, CSVPrinter> map = this.writers();
        synchronized (map) {
            this.writers().values().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(CSVPrinter x$1) {
                    x$1.flush();
                }
            });
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        Map<String, CSVPrinter> map = this.writers();
        synchronized (map) {
            this.writers().values().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(CSVPrinter w) {
                    w.flush();
                    w.close();
                }
            });
        }
        super.stop();
    }

    public void report(SortedMap<String, Gauge<?>> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        ObjectRef timestamp$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        JavaConversions$.MODULE$.mapAsScalaMap(gauges).foreach((Function1)new Serializable(this, timestamp$lzy, bitmap$0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelimitedFileReporter $outer;
            private final ObjectRef timestamp$lzy$1;
            private final VolatileByteRef bitmap$0$1;

            public final void apply(Tuple2<String, Gauge<?>> x0$1) {
                Tuple2<String, Gauge<?>> tuple2 = x0$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Gauge metric = (Gauge)tuple2._2();
                    this.$outer.org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$writeGauge(name, this.$outer.org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$timestamp$1(this.timestamp$lzy$1, this.bitmap$0$1), metric);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.timestamp$lzy$1 = timestamp$lzy$1;
                this.bitmap$0$1 = bitmap$0$1;
            }
        });
        JavaConversions$.MODULE$.mapAsScalaMap(counters).foreach((Function1)new Serializable(this, timestamp$lzy, bitmap$0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelimitedFileReporter $outer;
            private final ObjectRef timestamp$lzy$1;
            private final VolatileByteRef bitmap$0$1;

            public final void apply(Tuple2<String, Counter> x0$2) {
                Tuple2<String, Counter> tuple2 = x0$2;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Counter metric = (Counter)tuple2._2();
                    this.$outer.org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$writeCounter(name, this.$outer.org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$timestamp$1(this.timestamp$lzy$1, this.bitmap$0$1), metric);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.timestamp$lzy$1 = timestamp$lzy$1;
                this.bitmap$0$1 = bitmap$0$1;
            }
        });
        JavaConversions$.MODULE$.mapAsScalaMap(histograms).foreach((Function1)new Serializable(this, timestamp$lzy, bitmap$0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelimitedFileReporter $outer;
            private final ObjectRef timestamp$lzy$1;
            private final VolatileByteRef bitmap$0$1;

            public final void apply(Tuple2<String, Histogram> x0$3) {
                Tuple2<String, Histogram> tuple2 = x0$3;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Histogram metric = (Histogram)tuple2._2();
                    this.$outer.org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$writeHistogram(name, this.$outer.org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$timestamp$1(this.timestamp$lzy$1, this.bitmap$0$1), metric);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.timestamp$lzy$1 = timestamp$lzy$1;
                this.bitmap$0$1 = bitmap$0$1;
            }
        });
        JavaConversions$.MODULE$.mapAsScalaMap(meters).foreach((Function1)new Serializable(this, timestamp$lzy, bitmap$0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelimitedFileReporter $outer;
            private final ObjectRef timestamp$lzy$1;
            private final VolatileByteRef bitmap$0$1;

            public final void apply(Tuple2<String, Meter> x0$4) {
                Tuple2<String, Meter> tuple2 = x0$4;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Meter metric = (Meter)tuple2._2();
                    this.$outer.org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$writeMeter(name, this.$outer.org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$timestamp$1(this.timestamp$lzy$1, this.bitmap$0$1), metric);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.timestamp$lzy$1 = timestamp$lzy$1;
                this.bitmap$0$1 = bitmap$0$1;
            }
        });
        JavaConversions$.MODULE$.mapAsScalaMap(timers).foreach((Function1)new Serializable(this, timestamp$lzy, bitmap$0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelimitedFileReporter $outer;
            private final ObjectRef timestamp$lzy$1;
            private final VolatileByteRef bitmap$0$1;

            public final void apply(Tuple2<String, Timer> x0$5) {
                Tuple2<String, Timer> tuple2 = x0$5;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Timer metric = (Timer)tuple2._2();
                    this.$outer.org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$writeTimer(name, this.$outer.org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$timestamp$1(this.timestamp$lzy$1, this.bitmap$0$1), metric);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.timestamp$lzy$1 = timestamp$lzy$1;
                this.bitmap$0$1 = bitmap$0$1;
            }
        });
    }

    public void org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$writeGauge(String name, String timestamp, Gauge<?> gauge) {
        this.write("gauges", DelimitedFileReporter$.MODULE$.gaugeCols(), name, timestamp, (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{gauge.getValue()}), ClassTag$.MODULE$.Any()));
    }

    public void org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$writeCounter(String name, String timestamp, Counter counter) {
        this.write("counters", DelimitedFileReporter$.MODULE$.counterCols(), name, timestamp, (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)counter.getCount())}), ClassTag$.MODULE$.Any()));
    }

    public void org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$writeHistogram(String name, String timestamp, Histogram histogram) {
        Snapshot snapshot = histogram.getSnapshot();
        Object[] values = (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)histogram.getCount()), BoxesRunTime.boxToLong((long)snapshot.getMin()), BoxesRunTime.boxToLong((long)snapshot.getMax()), BoxesRunTime.boxToDouble((double)snapshot.getMean()), BoxesRunTime.boxToDouble((double)snapshot.getStdDev()), BoxesRunTime.boxToDouble((double)snapshot.getMedian()), BoxesRunTime.boxToDouble((double)snapshot.get75thPercentile()), BoxesRunTime.boxToDouble((double)snapshot.get95thPercentile()), BoxesRunTime.boxToDouble((double)snapshot.get98thPercentile()), BoxesRunTime.boxToDouble((double)snapshot.get99thPercentile()), BoxesRunTime.boxToDouble((double)snapshot.get999thPercentile())}), ClassTag$.MODULE$.Any());
        this.write("histograms", DelimitedFileReporter$.MODULE$.histogramCols(), name, timestamp, values);
    }

    public void org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$writeMeter(String name, String timestamp, Meter meter) {
        Object[] values = (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)meter.getCount()), BoxesRunTime.boxToDouble((double)this.convertRate(meter.getMeanRate())), BoxesRunTime.boxToDouble((double)this.convertRate(meter.getOneMinuteRate())), BoxesRunTime.boxToDouble((double)this.convertRate(meter.getFiveMinuteRate())), BoxesRunTime.boxToDouble((double)this.convertRate(meter.getFifteenMinuteRate())), this.getRateUnit()}), ClassTag$.MODULE$.Any());
        this.write("meters", DelimitedFileReporter$.MODULE$.meterCols(), name, timestamp, values);
    }

    public void org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$writeTimer(String name, String timestamp, Timer timer) {
        Snapshot snapshot = timer.getSnapshot();
        Object[] values = (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)timer.getCount()), BoxesRunTime.boxToDouble((double)this.convertDuration(snapshot.getMin())), BoxesRunTime.boxToDouble((double)this.convertDuration(snapshot.getMax())), BoxesRunTime.boxToDouble((double)this.convertDuration(snapshot.getMean())), BoxesRunTime.boxToDouble((double)this.convertDuration(snapshot.getStdDev())), BoxesRunTime.boxToDouble((double)this.convertDuration(snapshot.getMedian())), BoxesRunTime.boxToDouble((double)this.convertDuration(snapshot.get75thPercentile())), BoxesRunTime.boxToDouble((double)this.convertDuration(snapshot.get95thPercentile())), BoxesRunTime.boxToDouble((double)this.convertDuration(snapshot.get98thPercentile())), BoxesRunTime.boxToDouble((double)this.convertDuration(snapshot.get99thPercentile())), BoxesRunTime.boxToDouble((double)this.convertDuration(snapshot.get999thPercentile())), BoxesRunTime.boxToDouble((double)this.convertRate(timer.getMeanRate())), BoxesRunTime.boxToDouble((double)this.convertRate(timer.getOneMinuteRate())), BoxesRunTime.boxToDouble((double)this.convertRate(timer.getFiveMinuteRate())), BoxesRunTime.boxToDouble((double)this.convertRate(timer.getFifteenMinuteRate())), this.getRateUnit(), this.getDurationUnit()}), ClassTag$.MODULE$.Any());
        this.write("timers", DelimitedFileReporter$.MODULE$.timerCols(), name, timestamp, values);
    }

    private void write(String metric, Tuple2<String, String>[] cols, String name, String timestamp, Object[] values) {
        Map<String, CSVPrinter> map = this.writers();
        synchronized (map) {
            String key = this.org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$aggregate ? metric : name;
            CSVPrinter writer = (CSVPrinter)this.writers().getOrElseUpdate((Object)key, (Function0)new Serializable(this, cols, key){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DelimitedFileReporter $outer;
                private final Tuple2[] cols$1;
                private final String key$1;

                public final CSVPrinter apply() {
                    Object[] objectArray = new Object[2];
                    objectArray[0] = this.key$1;
                    CSVFormat cSVFormat = this.$outer.org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$format;
                    CSVFormat cSVFormat2 = CSVFormat.TDF;
                    objectArray[1] = !(cSVFormat != null ? !cSVFormat.equals(cSVFormat2) : cSVFormat2 != null) ? "t" : "c";
                    String fileName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", "sv"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray));
                    File file = new File(this.$outer.org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$folder(), fileName);
                    CSVPrinter writer = this.$outer.org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$format.print((Appendable)new FileWriter(file, true));
                    if (!file.exists() || file.length() == 0L) {
                        writer.print((Object)"time");
                        if (this.$outer.org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$aggregate) {
                            writer.print((Object)"name");
                        }
                        Predef$.MODULE$.refArrayOps((Object[])this.cols$1).foreach((Function1)new Serializable(this, writer){
                            public static final long serialVersionUID = 0L;
                            private final CSVPrinter writer$1;

                            public final void apply(Tuple2<String, String> x0$6) {
                                Tuple2<String, String> tuple2 = x0$6;
                                if (tuple2 != null) {
                                    String header = (String)tuple2._1();
                                    this.writer$1.print((Object)header);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.writer$1 = writer$1;
                            }
                        });
                        writer.println();
                    }
                    return writer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.cols$1 = cols$1;
                    this.key$1 = key$1;
                }
            });
            writer.print((Object)timestamp);
            if (this.org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$aggregate) {
                writer.print((Object)name);
            }
            for (int i = 0; i < cols.length; ++i) {
                writer.print((Object)new StringOps(Predef$.MODULE$.augmentString((String)cols[i]._2())).formatLocal(this.locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{values[i]})));
            }
            writer.println();
            return;
        }
    }

    private final String timestamp$lzycompute$1(ObjectRef timestamp$lzy$1, VolatileByteRef bitmap$0$1) {
        DelimitedFileReporter delimitedFileReporter = this;
        synchronized (delimitedFileReporter) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                timestamp$lzy$1.elem = this.timeEncoder().print(this.clock.getTime());
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (String)timestamp$lzy$1.elem;
        }
    }

    public final String org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$timestamp$1(ObjectRef timestamp$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.timestamp$lzycompute$1(timestamp$lzy$1, bitmap$0$1) : (String)timestamp$lzy$1.elem;
    }

    public DelimitedFileReporter(MetricRegistry registry, String path, boolean aggregate, CSVFormat format, Clock clock, Locale locale, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit) {
        this.org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$path = path;
        this.org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$aggregate = aggregate;
        this.org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$format = format;
        this.clock = clock;
        this.locale = locale;
        super(registry, "DelimitedFileReporter", filter, rateUnit, durationUnit);
        this.writers = Map$.MODULE$.empty();
        this.org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$folder = new File(path);
        if (this.org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$folder().exists()) {
            Predef$.MODULE$.require(this.org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$folder().isDirectory(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DelimitedFileReporter $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Path refers to a file - must be a folder: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$path}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        } else {
            Predef$.MODULE$.require(this.org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$folder().mkdirs(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DelimitedFileReporter $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't create folder at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$locationtech$geomesa$metrics$reporters$DelimitedFileReporter$$path}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        this.timeEncoder = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS").withZoneUTC();
    }

    public static class Builder {
        private final MetricRegistry registry;
        private Locale locale;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private Clock clock;
        private MetricFilter filter;
        private boolean aggregate;
        private CSVFormat format;

        private Locale locale() {
            return this.locale;
        }

        private void locale_$eq(Locale x$1) {
            this.locale = x$1;
        }

        private TimeUnit rateUnit() {
            return this.rateUnit;
        }

        private void rateUnit_$eq(TimeUnit x$1) {
            this.rateUnit = x$1;
        }

        private TimeUnit durationUnit() {
            return this.durationUnit;
        }

        private void durationUnit_$eq(TimeUnit x$1) {
            this.durationUnit = x$1;
        }

        private Clock clock() {
            return this.clock;
        }

        private void clock_$eq(Clock x$1) {
            this.clock = x$1;
        }

        private MetricFilter filter() {
            return this.filter;
        }

        private void filter_$eq(MetricFilter x$1) {
            this.filter = x$1;
        }

        private boolean aggregate() {
            return this.aggregate;
        }

        private void aggregate_$eq(boolean x$1) {
            this.aggregate = x$1;
        }

        private CSVFormat format() {
            return this.format;
        }

        private void format_$eq(CSVFormat x$1) {
            this.format = x$1;
        }

        public Builder formatFor(Locale locale) {
            this.locale_$eq(locale);
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit_$eq(rateUnit);
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit_$eq(durationUnit);
            return this;
        }

        public Builder withClock(Clock clock) {
            this.clock_$eq(clock);
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter_$eq(filter);
            return this;
        }

        public Builder aggregate(boolean aggregate) {
            this.aggregate_$eq(aggregate);
            return this;
        }

        public Builder withCommas() {
            this.format_$eq(CSVFormat.DEFAULT);
            return this;
        }

        public Builder withTabs() {
            this.format_$eq(CSVFormat.TDF);
            return this;
        }

        public DelimitedFileReporter build(String path) {
            return new DelimitedFileReporter(this.registry, path, this.aggregate(), this.format(), this.clock(), this.locale(), this.filter(), this.rateUnit(), this.durationUnit());
        }

        public Builder(MetricRegistry registry) {
            this.registry = registry;
            this.locale = Locale.getDefault();
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.clock = Clock.defaultClock();
            this.filter = MetricFilter.ALL;
            this.aggregate = true;
            this.format = CSVFormat.TDF;
        }
    }
}

