/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.metrics.reporters;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.google.common.base.Charsets;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.hadoop.io.Text;
import org.locationtech.geomesa.metrics.reporters.AccumuloReporter$;
import org.locationtech.geomesa.metrics.reporters.AccumuloReporter$Keys$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

@ScalaSignature(bytes="\u0006\u0001\u0011eq!B\u0001\u0003\u0011\u0003i\u0011\u0001E!dGVlW\u000f\\8SKB|'\u000f^3s\u0015\t\u0019A!A\u0005sKB|'\u000f^3sg*\u0011QAB\u0001\b[\u0016$(/[2t\u0015\t9\u0001\"A\u0004hK>lWm]1\u000b\u0005%Q\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0011\u00059yQ\"\u0001\u0002\u0007\u000bA\u0011\u0001\u0012A\t\u0003!\u0005\u001b7-^7vY>\u0014V\r]8si\u0016\u00148CA\b\u0013!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fM\")\u0011d\u0004C\u00015\u00051A(\u001b8jiz\"\u0012!D\u0004\u00069=A\t!H\u0001\u0005\u0017\u0016L8\u000f\u0005\u0002\u001f?5\tqBB\u0003!\u001f!\u0005\u0011E\u0001\u0003LKf\u001c8CA\u0010\u0013\u0011\u0015Ir\u0004\"\u0001$)\u0005i\u0002bB\u0013 \u0005\u0004%\tAJ\u0001\u0006G>,h\u000e^\u000b\u0002OA\u0011\u0001fL\u0007\u0002S)\u0011!fK\u0001\u0003S>T!\u0001L\u0017\u0002\r!\fGm\\8q\u0015\tq#\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003a%\u0012A\u0001V3yi\"1!g\bQ\u0001\n\u001d\naaY8v]R\u0004\u0003b\u0002\u001b \u0005\u0004%\tAJ\u0001\u0006m\u0006dW/\u001a\u0005\u0007m}\u0001\u000b\u0011B\u0014\u0002\rY\fG.^3!\u0011\u001dAtD1A\u0005\u0002\u0019\n1!\\1y\u0011\u0019Qt\u0004)A\u0005O\u0005!Q.\u0019=!\u0011\u001datD1A\u0005\u0002\u0019\nA!\\3b]\"1ah\bQ\u0001\n\u001d\nQ!\\3b]\u0002Bq\u0001Q\u0010C\u0002\u0013\u0005a%A\u0002nS:DaAQ\u0010!\u0002\u00139\u0013\u0001B7j]\u0002Bq\u0001R\u0010C\u0002\u0013\u0005a%\u0001\u0004ti\u0012$WM\u001e\u0005\u0007\r~\u0001\u000b\u0011B\u0014\u0002\u000fM$H\rZ3wA!9\u0001j\bb\u0001\n\u00031\u0013a\u000196a!1!j\bQ\u0001\n\u001d\nA\u0001]\u001b1A!9Aj\bb\u0001\n\u00031\u0013a\u000198k!1aj\bQ\u0001\n\u001d\nA\u0001]\u001c6A!9\u0001k\bb\u0001\n\u00031\u0013a\u00019:k!1!k\bQ\u0001\n\u001d\nA\u0001]\u001d6A!9Ak\bb\u0001\n\u00031\u0013a\u00019:q!1ak\bQ\u0001\n\u001d\nA\u0001]\u001d9A!9\u0001l\bb\u0001\n\u00031\u0013a\u00019:s!1!l\bQ\u0001\n\u001d\nA\u0001]\u001d:A!9Al\bb\u0001\n\u00031\u0013\u0001\u00029:seBaAX\u0010!\u0002\u00139\u0013!\u00029:se\u0002\u0003b\u00021 \u0005\u0004%\tAJ\u0001\n[\u0016\fgn\u0018:bi\u0016DaAY\u0010!\u0002\u00139\u0013AC7fC:|&/\u0019;fA!9Am\bb\u0001\n\u00031\u0013aB72?J\fG/\u001a\u0005\u0007M~\u0001\u000b\u0011B\u0014\u0002\u00115\ftL]1uK\u0002Bq\u0001[\u0010C\u0002\u0013\u0005a%A\u0004nk}\u0013\u0018\r^3\t\r)|\u0002\u0015!\u0003(\u0003!iWg\u0018:bi\u0016\u0004\u0003b\u00027 \u0005\u0004%\tAJ\u0001\t[F*tL]1uK\"1an\bQ\u0001\n\u001d\n\u0011\"\\\u00196?J\fG/\u001a\u0011\t\u000fA|\"\u0019!C\u0001M\u0005I!/\u0019;f?Vt\u0017\u000e\u001e\u0005\u0007e~\u0001\u000b\u0011B\u0014\u0002\u0015I\fG/Z0v]&$\b\u0005C\u0004u?\t\u0007I\u0011\u0001\u0014\u0002\u001b\u0011,(/\u0019;j_:|VO\\5u\u0011\u00191x\u0004)A\u0005O\u0005qA-\u001e:bi&|gnX;oSR\u0004\u0003b\u0002= \u0005\u0004%\tAJ\u0001\u0006K6\u0004H/\u001f\u0005\u0007u~\u0001\u000b\u0011B\u0014\u0002\r\u0015l\u0007\u000f^=!\u0011\u0015ax\u0002\"\u0001~\u0003-1wN\u001d*fO&\u001cHO]=\u0015\u0007y\u001cY\r\u0005\u0002\u001f\u007f\u001a1\u0011\u0011A\b\u0001\u0003\u0007\u0011qAQ;jY\u0012,'o\u0005\u0002\u0000%!Q\u0011qA@\u0003\u0002\u0003\u0006I!!\u0003\u0002\u0011I,w-[:uef\u0004B!a\u0003\u0002\u00185\u0011\u0011Q\u0002\u0006\u0004\u000b\u0005=!\u0002BA\t\u0003'\t\u0001bY8eC\"\fG.\u001a\u0006\u0003\u0003+\t1aY8n\u0013\u0011\tI\"!\u0004\u0003\u001d5+GO]5d%\u0016<\u0017n\u001d;ss\"9\u0011d C\u0001\t\u0005uAc\u0001@\u0002 !A\u0011qAA\u000e\u0001\u0004\tI\u0001C\u0005\u0002$}\u0004\r\u0011\"\u0003\u0002&\u00051An\\2bY\u0016,\"!a\n\u0011\t\u0005%\u00121G\u0007\u0003\u0003WQA!!\f\u00020\u0005!Q\u000f^5m\u0015\t\t\t$\u0001\u0003kCZ\f\u0017\u0002BA\u001b\u0003W\u0011a\u0001T8dC2,\u0007\"CA\u001d\u007f\u0002\u0007I\u0011BA\u001e\u0003)awnY1mK~#S-\u001d\u000b\u0005\u0003{\t\u0019\u0005E\u0002\u0014\u0003\u007fI1!!\u0011\u0015\u0005\u0011)f.\u001b;\t\u0015\u0005\u0015\u0013qGA\u0001\u0002\u0004\t9#A\u0002yIEB\u0001\"!\u0013\u0000A\u0003&\u0011qE\u0001\bY>\u001c\u0017\r\\3!\u0011%\tie a\u0001\n\u0013\ty%\u0001\u0005sCR,WK\\5u+\t\t\t\u0006\u0005\u0003\u0002T\u0005eSBAA+\u0015\u0011\t9&a\u000b\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002\\\u0005U#\u0001\u0003+j[\u0016,f.\u001b;\t\u0013\u0005}s\u00101A\u0005\n\u0005\u0005\u0014\u0001\u0004:bi\u0016,f.\u001b;`I\u0015\fH\u0003BA\u001f\u0003GB!\"!\u0012\u0002^\u0005\u0005\t\u0019AA)\u0011!\t9g Q!\n\u0005E\u0013!\u0003:bi\u0016,f.\u001b;!\u0011%\tYg a\u0001\n\u0013\ty%\u0001\u0007ekJ\fG/[8o+:LG\u000fC\u0005\u0002p}\u0004\r\u0011\"\u0003\u0002r\u0005\u0001B-\u001e:bi&|g.\u00168ji~#S-\u001d\u000b\u0005\u0003{\t\u0019\b\u0003\u0006\u0002F\u00055\u0014\u0011!a\u0001\u0003#B\u0001\"a\u001e\u0000A\u0003&\u0011\u0011K\u0001\u000eIV\u0014\u0018\r^5p]Vs\u0017\u000e\u001e\u0011\t\u0013\u0005mt\u00101A\u0005\n\u0005u\u0014!B2m_\u000e\\WCAA@!\u0011\tY!!!\n\t\u0005\r\u0015Q\u0002\u0002\u0006\u00072|7m\u001b\u0005\n\u0003\u000f{\b\u0019!C\u0005\u0003\u0013\u000b\u0011b\u00197pG.|F%Z9\u0015\t\u0005u\u00121\u0012\u0005\u000b\u0003\u000b\n))!AA\u0002\u0005}\u0004\u0002CAH\u007f\u0002\u0006K!a \u0002\r\rdwnY6!\u0011%\t\u0019j a\u0001\n\u0013\t)*\u0001\u0004gS2$XM]\u000b\u0003\u0003/\u0003B!a\u0003\u0002\u001a&!\u00111TA\u0007\u00051iU\r\u001e:jG\u001aKG\u000e^3s\u0011%\tyj a\u0001\n\u0013\t\t+\u0001\u0006gS2$XM]0%KF$B!!\u0010\u0002$\"Q\u0011QIAO\u0003\u0003\u0005\r!a&\t\u0011\u0005\u001dv\u0010)Q\u0005\u0003/\u000bqAZ5mi\u0016\u0014\b\u0005C\u0005\u0002,~\u0004\r\u0011\"\u0003\u0002.\u0006)A/\u00192mKV\u0011\u0011q\u0016\t\u0005\u0003c\u000b9LD\u0002\u0014\u0003gK1!!.\u0015\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011XA^\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0017\u000b\t\u0013\u0005}v\u00101A\u0005\n\u0005\u0005\u0017!\u0003;bE2,w\fJ3r)\u0011\ti$a1\t\u0015\u0005\u0015\u0013QXA\u0001\u0002\u0004\ty\u000b\u0003\u0005\u0002H~\u0004\u000b\u0015BAX\u0003\u0019!\u0018M\u00197fA!Y\u00111Z@A\u0002\u0003\u0007I\u0011BAW\u000311\u0018n]5cS2LG/[3t\u0011-\tym a\u0001\u0002\u0004%I!!5\u0002!YL7/\u001b2jY&$\u0018.Z:`I\u0015\fH\u0003BA\u001f\u0003'D!\"!\u0012\u0002N\u0006\u0005\t\u0019AAX\u0011!\t9n Q!\n\u0005=\u0016!\u0004<jg&\u0014\u0017\u000e\\5uS\u0016\u001c\b\u0005C\u0005\u0002\\~\u0004\r\u0011\"\u0003\u0002^\u0006!Qn\\2l+\t\ty\u000eE\u0002\u0014\u0003CL1!a9\u0015\u0005\u001d\u0011un\u001c7fC:D\u0011\"a:\u0000\u0001\u0004%I!!;\u0002\u00115|7m[0%KF$B!!\u0010\u0002l\"Q\u0011QIAs\u0003\u0003\u0005\r!a8\t\u0011\u0005=x\u0010)Q\u0005\u0003?\fQ!\\8dW\u0002Bq!a=\u0000\t\u0003\t)0A\u0005g_Jl\u0017\r\u001e$peR\u0019a0a>\t\u0011\u0005\r\u0012\u0011\u001fa\u0001\u0003OAq!a?\u0000\t\u0003\ti0\u0001\bd_:4XM\u001d;SCR,7\u000fV8\u0015\u0007y\fy\u0010\u0003\u0005\u0002N\u0005e\b\u0019AA)\u0011\u001d\u0011\u0019a C\u0001\u0005\u000b\t!cY8om\u0016\u0014H\u000fR;sCRLwN\\:U_R\u0019aPa\u0002\t\u0011\u0005-$\u0011\u0001a\u0001\u0003#BqAa\u0003\u0000\t\u0003\u0011i!A\u0005xSRD7\t\\8dWR\u0019aPa\u0004\t\u0011\u0005m$\u0011\u0002a\u0001\u0003\u007fBq!a%\u0000\t\u0003\u0011\u0019\u0002F\u0002\u007f\u0005+A\u0001\"a%\u0003\u0012\u0001\u0007\u0011q\u0013\u0005\b\u00053yH\u0011\u0001B\u000e\u000319(/\u001b;f)>$\u0016M\u00197f)\rq(Q\u0004\u0005\t\u0003W\u00139\u00021\u0001\u00020\"9!\u0011E@\u0005\u0002\t\r\u0012\u0001E<ji\"4\u0016n]5cS2LG/[3t)\rq(Q\u0005\u0005\t\u0003\u0017\u0014y\u00021\u0001\u00020\"9\u00111\\@\u0005\u0002\t%Bc\u0001@\u0003,!A\u00111\u001cB\u0014\u0001\u0004\ty\u000eC\u0004\u00030}$\tA!\r\u0002\u000b\t,\u0018\u000e\u001c3\u0015\u0015\tM21XB`\u0007\u0007\u001c9\rE\u0002\u000f\u0005k1Q\u0001\u0005\u0002\u0001\u0005o\u0019BA!\u000e\u0003:A!\u00111\u0002B\u001e\u0013\u0011\u0011i$!\u0004\u0003#M\u001b\u0007.\u001a3vY\u0016$'+\u001a9peR,'\u000fC\u0006\u0002\b\tU\"\u0011!Q\u0001\n\u0005%\u0001b\u0003B\"\u0005k\u0011\t\u0011)A\u0005\u0005\u000b\n\u0011bY8o]\u0016\u001cGo\u001c:\u0011\t\t\u001d#QK\u0007\u0003\u0005\u0013RAAa\u0013\u0003N\u000511\r\\5f]RTAAa\u0014\u0003R\u0005!1m\u001c:f\u0015\r\u0011\u0019&L\u0001\tC\u000e\u001cW/\\;m_&!!q\u000bB%\u0005%\u0019uN\u001c8fGR|'\u000fC\u0006\u0002,\nU\"\u0011!Q\u0001\n\u0005=\u0006bCAf\u0005k\u0011\t\u0011)A\u0005\u0005;\u0002Ra\u0005B0\u0003_K1A!\u0019\u0015\u0005\u0019y\u0005\u000f^5p]\"Y\u00111\u0010B\u001b\u0005\u0003\u0005\u000b\u0011BA@\u0011-\t\u0019C!\u000e\u0003\u0002\u0003\u0006I!a\n\t\u0017\u0005M%Q\u0007B\u0001B\u0003%\u0011q\u0013\u0005\f\u0003\u001b\u0012)D!A!\u0002\u0013\t\t\u0006C\u0006\u0002l\tU\"\u0011!Q\u0001\n\u0005E\u0003bB\r\u00036\u0011%!q\u000e\u000b\u0015\u0005g\u0011\tHa\u001d\u0003v\t]$\u0011\u0010B>\u0005{\u0012yH!!\t\u0011\u0005\u001d!Q\u000ea\u0001\u0003\u0013A\u0001Ba\u0011\u0003n\u0001\u0007!Q\t\u0005\t\u0003W\u0013i\u00071\u0001\u00020\"A\u00111\u001aB7\u0001\u0004\u0011i\u0006\u0003\u0005\u0002|\t5\u0004\u0019AA@\u0011!\t\u0019C!\u001cA\u0002\u0005\u001d\u0002\u0002CAJ\u0005[\u0002\r!a&\t\u0011\u00055#Q\u000ea\u0001\u0003#B\u0001\"a\u001b\u0003n\u0001\u0007\u0011\u0011\u000b\u0005\u000b\u0005\u000b\u0013)D1A\u0005\n\t\u001d\u0015AB<sSR,'/\u0006\u0002\u0003\nB!!q\tBF\u0013\u0011\u0011iI!\u0013\u0003\u0017\t\u000bGo\u00195Xe&$XM\u001d\u0005\n\u0005#\u0013)\u0004)A\u0005\u0005\u0013\u000bqa\u001e:ji\u0016\u0014\b\u0005\u0003\u0006\u0003\u0016\nU\"\u0019!C\u0005\u0005/\u000b1\u0002^5nK\u0016s7m\u001c3feV\u0011!\u0011\u0014\t\u0005\u00057\u0013)+\u0004\u0002\u0003\u001e*!!q\u0014BQ\u0003\u00191wN]7bi*!!1UA\u0018\u0003\u0011!\u0018.\\3\n\t\t\u001d&Q\u0014\u0002\u0012\t\u0006$X\rV5nK\u001a{'/\\1ui\u0016\u0014\b\"\u0003BV\u0005k\u0001\u000b\u0011\u0002BM\u00031!\u0018.\\3F]\u000e|G-\u001a:!\u0011)\u0011yK!\u000eC\u0002\u0013%!\u0011W\u0001\u000bm&\u001c\u0018NY5mSRLXC\u0001BZ!\u0015\u0019\"q\fB[!\u0011\u00119L!0\u000e\u0005\te&\u0002\u0002B^\u0005\u001b\n\u0001b]3dkJLG/_\u0005\u0005\u0005\u007f\u0013IL\u0001\tD_2,XN\u001c,jg&\u0014\u0017\u000e\\5us\"I!1\u0019B\u001bA\u0003%!1W\u0001\fm&\u001c\u0018NY5mSRL\b\u0005\u0003\u0005\u0003H\nUB\u0011\tBe\u0003\u0011\u0019Ho\u001c9\u0015\u0005\u0005u\u0002\u0002\u0003Bg\u0005k!\tEa4\u0002\rI,\u0007o\u001c:u)1\tiD!5\u0003z\u000e\u00151\u0011CB\u000f\u0011!\u0011\u0019Na3A\u0002\tU\u0017AB4bk\u001e,7\u000f\u0005\u0005\u0002*\t]\u0017q\u0016Bn\u0013\u0011\u0011I.a\u000b\u0003\u0013M{'\u000f^3e\u001b\u0006\u0004\b\u0007\u0002Bo\u0005O\u0004b!a\u0003\u0003`\n\r\u0018\u0002\u0002Bq\u0003\u001b\u0011QaR1vO\u0016\u0004BA!:\u0003h2\u0001A\u0001\u0004Bu\u0005#\f\t\u0011!A\u0003\u0002\t-(aA0%cE!!Q\u001eBz!\r\u0019\"q^\u0005\u0004\u0005c$\"a\u0002(pi\"Lgn\u001a\t\u0004'\tU\u0018b\u0001B|)\t\u0019\u0011I\\=\t\u0011\tm(1\u001aa\u0001\u0005{\f\u0001bY8v]R,'o\u001d\t\t\u0003S\u00119.a,\u0003\u0000B!\u00111BB\u0001\u0013\u0011\u0019\u0019!!\u0004\u0003\u000f\r{WO\u001c;fe\"A1q\u0001Bf\u0001\u0004\u0019I!\u0001\u0006iSN$xn\u001a:b[N\u0004\u0002\"!\u000b\u0003X\u0006=61\u0002\t\u0005\u0003\u0017\u0019i!\u0003\u0003\u0004\u0010\u00055!!\u0003%jgR|wM]1n\u0011!\u0019\u0019Ba3A\u0002\rU\u0011AB7fi\u0016\u00148\u000f\u0005\u0005\u0002*\t]\u0017qVB\f!\u0011\tYa!\u0007\n\t\rm\u0011Q\u0002\u0002\u0006\u001b\u0016$XM\u001d\u0005\t\u0007?\u0011Y\r1\u0001\u0004\"\u00051A/[7feN\u0004\u0002\"!\u000b\u0003X\u0006=61\u0005\t\u0005\u0003\u0017\u0019)#\u0003\u0003\u0004(\u00055!!\u0002+j[\u0016\u0014\b\u0002CB\u0016\u0005k!\tA!3\u0002\u000b\u0019dWo\u001d5\t\u0011\r=\"Q\u0007C\u0005\u0007c\tA\"\u00193e\u001bV$\u0018\r^5p]N$B!!\u0010\u00044!A1QGB\u0017\u0001\u0004\u00199$A\u0005nkR\fG/[8ogB11\u0011HB%\u0007\u001frAaa\u000f\u0004F9!1QHB\"\u001b\t\u0019yDC\u0002\u0004B1\ta\u0001\u0010:p_Rt\u0014\"A\u000b\n\u0007\r\u001dC#A\u0004qC\u000e\\\u0017mZ3\n\t\r-3Q\n\u0002\u0004'\u0016\f(bAB$)A!1\u0011KB,\u001b\t\u0019\u0019F\u0003\u0003\u0004V\t5\u0013\u0001\u00023bi\u0006LAa!\u0017\u0004T\tAQ*\u001e;bi&|g\u000e\u0003\u0005\u0004^\tUB\u0011BB0\u0003=9\u0017-^4f)>lU\u000f^1uS>tG\u0003CB(\u0007C\u001a)g!\u001b\t\u0011\r\r41\fa\u0001\u0003_\u000bAA\\1nK\"A1qMB.\u0001\u0004\ty+A\u0005uS6,7\u000f^1na\"A11NB.\u0001\u0004\u0019i'A\u0003hCV<W\r\r\u0003\u0004p\rM\u0004CBA\u0006\u0005?\u001c\t\b\u0005\u0003\u0003f\u000eMD\u0001DB;\u0007S\n\t\u0011!A\u0003\u0002\t-(aA0%e!A1\u0011\u0010B\u001b\t\u0013\u0019Y(A\td_VtG/\u001a:U_6+H/\u0019;j_:$\u0002ba\u0014\u0004~\r}4\u0011\u0011\u0005\t\u0007G\u001a9\b1\u0001\u00020\"A1qMB<\u0001\u0004\ty\u000b\u0003\u0005\u0004\u0004\u000e]\u0004\u0019\u0001B\u0000\u0003\u001d\u0019w.\u001e8uKJD\u0001ba\"\u00036\u0011%1\u0011R\u0001\u0014Q&\u001cHo\\4sC6$v.T;uCRLwN\u001c\u000b\u0007\u0007\u001f\u001aYi!$\t\u0011\r\r4Q\u0011a\u0001\u0003_C\u0001ba$\u0004\u0006\u0002\u000711B\u0001\nQ&\u001cHo\\4sC6D\u0001ba%\u00036\u0011%1QS\u0001\u0010[\u0016$XM\u001d+p\u001bV$\u0018\r^5p]R11qJBL\u00073C\u0001ba\u0019\u0004\u0012\u0002\u0007\u0011q\u0016\u0005\t\u00077\u001b\t\n1\u0001\u0004\u0018\u0005)Q.\u001a;fe\"A1q\u0014B\u001b\t\u0013\u0019\t+A\buS6,'\u000fV8NkR\fG/[8o)\u0019\u0019yea)\u0004&\"A11MBO\u0001\u0004\ty\u000b\u0003\u0005\u0004(\u000eu\u0005\u0019AB\u0012\u0003\u0015!\u0018.\\3s\u0011!\u0019YK!\u000e\u0005\n\r5\u0016a\u00019viRQ\u0011QHBX\u0007g\u001b9l!/\t\u0011\rE6\u0011\u0016a\u0001\u0007\u001f\n\u0011!\u001c\u0005\b\u0007k\u001bI\u000b1\u0001(\u0003\t\u0019g\r\u0003\u0005\u0003 \u000e%\u0006\u0019AAX\u0011\u001d!4\u0011\u0016a\u0001\u0005gD\u0001b!0\u0003.\u0001\u0007\u0011qV\u0001\u000bS:\u001cH/\u00198dK&#\u0007\u0002CBa\u0005[\u0001\r!a,\u0002\u0015i|wn[3fa\u0016\u00148\u000f\u0003\u0005\u0004F\n5\u0002\u0019AAX\u0003\u0011)8/\u001a:\t\u0011\r%'Q\u0006a\u0001\u0003_\u000b\u0001\u0002]1tg^|'\u000f\u001a\u0005\b\u0003\u000fY\b\u0019AA\u0005\u0011\u001d\u0019ym\u0004C\u0005\u0007#\f1\"\\;uCRLwN\u001c$peR11qJBj\u0007+D\u0001ba\u0019\u0004N\u0002\u0007\u0011q\u0016\u0005\u000b\u0007O\u001ai\r%AA\u0002\tu\u0003\"CBm\u001fE\u0005I\u0011BBn\u0003UiW\u000f^1uS>tgi\u001c:%I\u00164\u0017-\u001e7uII*\"a!8+\t\tu3q\\\u0016\u0003\u0007C\u0004Baa9\u0004n6\u00111Q\u001d\u0006\u0005\u0007O\u001cI/A\u0005v]\u000eDWmY6fI*\u001911\u001e\u000b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004p\u000e\u0015(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\":qba=\u0004z\u000eu\bcA\n\u0004v&\u00191q\u001f\u000b\u0003\u0015\u0011,\u0007O]3dCR,G-\t\u0002\u0004|\u0006\u0019s+\u001b7mA\t,\u0007E]3n_Z,G\rI<ji\"|W\u000f\u001e\u0011sKBd\u0017mY3nK:$\u0018'C\u0012\u00020\u000e}Hq\u0001C\u0001\u0013\u0011!\t\u0001b\u0001\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0015\r!)\u0001F\u0001\u000bI\u0016\u0004(/Z2bi\u0016$\u0017'C\u0012\u0005\n\u0011-AQ\u0002C\u0003\u001d\r\u0019B1B\u0005\u0004\t\u000b!\u0012'\u0002\u0012\u0014)\u0011=!!B:dC2\f\u0007f\u0002\u0001\u0004t\u000eeH1C\u0019\nG\u0005=6q C\u000b\t\u0003\t\u0014b\tC\u0005\t\u0017!9\u0002\"\u00022\u000b\t\u001aB\u0003b\u0004")
public class AccumuloReporter
extends ScheduledReporter {
    private final Clock clock;
    private final Locale locale;
    private final BatchWriter writer;
    private final DateTimeFormatter timeEncoder;
    private final Option<ColumnVisibility> visibility;

    public static Builder forRegistry(MetricRegistry metricRegistry) {
        return AccumuloReporter$.MODULE$.forRegistry(metricRegistry);
    }

    private BatchWriter writer() {
        return this.writer;
    }

    private DateTimeFormatter timeEncoder() {
        return this.timeEncoder;
    }

    private Option<ColumnVisibility> visibility() {
        return this.visibility;
    }

    public void stop() {
        this.writer().close();
        super.stop();
    }

    public void report(SortedMap<String, Gauge<?>> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        ObjectRef timestamp$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        this.addMutations((Seq<Mutation>)((Seq)JavaConversions$.MODULE$.mapAsScalaMap(gauges).toSeq().map((Function1)new Serializable(this, timestamp$lzy, bitmap$0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AccumuloReporter $outer;
            private final ObjectRef timestamp$lzy$1;
            private final VolatileByteRef bitmap$0$1;

            public final Mutation apply(Tuple2<String, Gauge<?>> x0$1) {
                Tuple2<String, Gauge<?>> tuple2 = x0$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Gauge metric = (Gauge)tuple2._2();
                    Mutation mutation = this.$outer.org$locationtech$geomesa$metrics$reporters$AccumuloReporter$$gaugeToMutation(name, this.$outer.org$locationtech$geomesa$metrics$reporters$AccumuloReporter$$timestamp$1(this.timestamp$lzy$1, this.bitmap$0$1), metric);
                    return mutation;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.timestamp$lzy$1 = timestamp$lzy$1;
                this.bitmap$0$1 = bitmap$0$1;
            }
        }, Seq$.MODULE$.canBuildFrom())));
        this.addMutations((Seq<Mutation>)((Seq)JavaConversions$.MODULE$.mapAsScalaMap(counters).toSeq().map((Function1)new Serializable(this, timestamp$lzy, bitmap$0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AccumuloReporter $outer;
            private final ObjectRef timestamp$lzy$1;
            private final VolatileByteRef bitmap$0$1;

            public final Mutation apply(Tuple2<String, Counter> x0$2) {
                Tuple2<String, Counter> tuple2 = x0$2;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Counter metric = (Counter)tuple2._2();
                    Mutation mutation = this.$outer.org$locationtech$geomesa$metrics$reporters$AccumuloReporter$$counterToMutation(name, this.$outer.org$locationtech$geomesa$metrics$reporters$AccumuloReporter$$timestamp$1(this.timestamp$lzy$1, this.bitmap$0$1), metric);
                    return mutation;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.timestamp$lzy$1 = timestamp$lzy$1;
                this.bitmap$0$1 = bitmap$0$1;
            }
        }, Seq$.MODULE$.canBuildFrom())));
        this.addMutations((Seq<Mutation>)((Seq)JavaConversions$.MODULE$.mapAsScalaMap(histograms).toSeq().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AccumuloReporter $outer;

            public final Mutation apply(Tuple2<String, Histogram> x0$3) {
                Tuple2<String, Histogram> tuple2 = x0$3;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Histogram metric = (Histogram)tuple2._2();
                    Mutation mutation = this.$outer.org$locationtech$geomesa$metrics$reporters$AccumuloReporter$$histogramToMutation(name, metric);
                    return mutation;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())));
        this.addMutations((Seq<Mutation>)((Seq)JavaConversions$.MODULE$.mapAsScalaMap(meters).toSeq().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AccumuloReporter $outer;

            public final Mutation apply(Tuple2<String, Meter> x0$4) {
                Tuple2<String, Meter> tuple2 = x0$4;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Meter metric = (Meter)tuple2._2();
                    Mutation mutation = this.$outer.org$locationtech$geomesa$metrics$reporters$AccumuloReporter$$meterToMutation(name, metric);
                    return mutation;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())));
        this.addMutations((Seq<Mutation>)((Seq)JavaConversions$.MODULE$.mapAsScalaMap(timers).toSeq().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AccumuloReporter $outer;

            public final Mutation apply(Tuple2<String, Timer> x0$5) {
                Tuple2<String, Timer> tuple2 = x0$5;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Timer metric = (Timer)tuple2._2();
                    Mutation mutation = this.$outer.org$locationtech$geomesa$metrics$reporters$AccumuloReporter$$timerToMutation(name, metric);
                    return mutation;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())));
    }

    public void flush() {
        this.writer().flush();
    }

    private void addMutations(Seq<Mutation> mutations) {
        if (mutations.nonEmpty()) {
            this.writer().addMutations((Iterable)JavaConversions$.MODULE$.seqAsJavaList(mutations));
        }
    }

    public Mutation org$locationtech$geomesa$metrics$reporters$AccumuloReporter$$gaugeToMutation(String name, String timestamp, Gauge<?> gauge) {
        Mutation m = AccumuloReporter$.MODULE$.org$locationtech$geomesa$metrics$reporters$AccumuloReporter$$mutationFor(name, (Option<String>)new Some((Object)timestamp));
        this.put(m, AccumuloReporter$Keys$.MODULE$.value(), "%s", gauge.getValue());
        return m;
    }

    public Mutation org$locationtech$geomesa$metrics$reporters$AccumuloReporter$$counterToMutation(String name, String timestamp, Counter counter) {
        Mutation m = AccumuloReporter$.MODULE$.org$locationtech$geomesa$metrics$reporters$AccumuloReporter$$mutationFor(name, (Option<String>)new Some((Object)timestamp));
        this.put(m, AccumuloReporter$Keys$.MODULE$.count(), "%d", BoxesRunTime.boxToLong((long)counter.getCount()));
        return m;
    }

    /*
     * WARNING - void declaration
     */
    public Mutation org$locationtech$geomesa$metrics$reporters$AccumuloReporter$$histogramToMutation(String name, Histogram histogram) {
        void var3_3;
        Mutation m = AccumuloReporter$.MODULE$.org$locationtech$geomesa$metrics$reporters$AccumuloReporter$$mutationFor(name, AccumuloReporter$.MODULE$.org$locationtech$geomesa$metrics$reporters$AccumuloReporter$$mutationFor$default$2());
        Snapshot snapshot = histogram.getSnapshot();
        this.put(m, AccumuloReporter$Keys$.MODULE$.count(), "%d", BoxesRunTime.boxToLong((long)histogram.getCount()));
        this.put(m, AccumuloReporter$Keys$.MODULE$.max(), "%d", BoxesRunTime.boxToLong((long)snapshot.getMax()));
        this.put(m, AccumuloReporter$Keys$.MODULE$.mean(), "%f", BoxesRunTime.boxToDouble((double)snapshot.getMean()));
        this.put(m, AccumuloReporter$Keys$.MODULE$.min(), "%d", BoxesRunTime.boxToLong((long)snapshot.getMin()));
        this.put(m, AccumuloReporter$Keys$.MODULE$.stddev(), "%f", BoxesRunTime.boxToDouble((double)snapshot.getStdDev()));
        this.put(m, AccumuloReporter$Keys$.MODULE$.p50(), "%f", BoxesRunTime.boxToDouble((double)snapshot.getMedian()));
        this.put(m, AccumuloReporter$Keys$.MODULE$.p75(), "%f", BoxesRunTime.boxToDouble((double)snapshot.get75thPercentile()));
        this.put(m, AccumuloReporter$Keys$.MODULE$.p95(), "%f", BoxesRunTime.boxToDouble((double)snapshot.get95thPercentile()));
        this.put(m, AccumuloReporter$Keys$.MODULE$.p98(), "%f", BoxesRunTime.boxToDouble((double)snapshot.get98thPercentile()));
        this.put(m, AccumuloReporter$Keys$.MODULE$.p99(), "%f", BoxesRunTime.boxToDouble((double)snapshot.get99thPercentile()));
        this.put(m, AccumuloReporter$Keys$.MODULE$.p999(), "%f", BoxesRunTime.boxToDouble((double)snapshot.get999thPercentile()));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Mutation org$locationtech$geomesa$metrics$reporters$AccumuloReporter$$meterToMutation(String name, Meter meter) {
        void var3_3;
        Mutation m = AccumuloReporter$.MODULE$.org$locationtech$geomesa$metrics$reporters$AccumuloReporter$$mutationFor(name, AccumuloReporter$.MODULE$.org$locationtech$geomesa$metrics$reporters$AccumuloReporter$$mutationFor$default$2());
        this.put(m, AccumuloReporter$Keys$.MODULE$.count(), "%d", BoxesRunTime.boxToLong((long)meter.getCount()));
        this.put(m, AccumuloReporter$Keys$.MODULE$.mean_rate(), "%f", BoxesRunTime.boxToDouble((double)this.convertRate(meter.getMeanRate())));
        this.put(m, AccumuloReporter$Keys$.MODULE$.m1_rate(), "%f", BoxesRunTime.boxToDouble((double)this.convertRate(meter.getOneMinuteRate())));
        this.put(m, AccumuloReporter$Keys$.MODULE$.m5_rate(), "%f", BoxesRunTime.boxToDouble((double)this.convertRate(meter.getFiveMinuteRate())));
        this.put(m, AccumuloReporter$Keys$.MODULE$.m15_rate(), "%f", BoxesRunTime.boxToDouble((double)this.convertRate(meter.getFifteenMinuteRate())));
        this.put(m, AccumuloReporter$Keys$.MODULE$.rate_unit(), "events/%s", this.getRateUnit());
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Mutation org$locationtech$geomesa$metrics$reporters$AccumuloReporter$$timerToMutation(String name, Timer timer) {
        void var3_3;
        Mutation m = AccumuloReporter$.MODULE$.org$locationtech$geomesa$metrics$reporters$AccumuloReporter$$mutationFor(name, AccumuloReporter$.MODULE$.org$locationtech$geomesa$metrics$reporters$AccumuloReporter$$mutationFor$default$2());
        Snapshot snapshot = timer.getSnapshot();
        this.put(m, AccumuloReporter$Keys$.MODULE$.count(), "%d", BoxesRunTime.boxToLong((long)timer.getCount()));
        this.put(m, AccumuloReporter$Keys$.MODULE$.max(), "%f", BoxesRunTime.boxToDouble((double)this.convertDuration(snapshot.getMax())));
        this.put(m, AccumuloReporter$Keys$.MODULE$.mean(), "%f", BoxesRunTime.boxToDouble((double)this.convertDuration(snapshot.getMean())));
        this.put(m, AccumuloReporter$Keys$.MODULE$.min(), "%f", BoxesRunTime.boxToDouble((double)this.convertDuration(snapshot.getMin())));
        this.put(m, AccumuloReporter$Keys$.MODULE$.stddev(), "%f", BoxesRunTime.boxToDouble((double)this.convertDuration(snapshot.getStdDev())));
        this.put(m, AccumuloReporter$Keys$.MODULE$.p50(), "%f", BoxesRunTime.boxToDouble((double)this.convertDuration(snapshot.getMedian())));
        this.put(m, AccumuloReporter$Keys$.MODULE$.p75(), "%f", BoxesRunTime.boxToDouble((double)this.convertDuration(snapshot.get75thPercentile())));
        this.put(m, AccumuloReporter$Keys$.MODULE$.p95(), "%f", BoxesRunTime.boxToDouble((double)this.convertDuration(snapshot.get95thPercentile())));
        this.put(m, AccumuloReporter$Keys$.MODULE$.p98(), "%f", BoxesRunTime.boxToDouble((double)this.convertDuration(snapshot.get98thPercentile())));
        this.put(m, AccumuloReporter$Keys$.MODULE$.p99(), "%f", BoxesRunTime.boxToDouble((double)this.convertDuration(snapshot.get99thPercentile())));
        this.put(m, AccumuloReporter$Keys$.MODULE$.p999(), "%f", BoxesRunTime.boxToDouble((double)this.convertDuration(snapshot.get999thPercentile())));
        this.put(m, AccumuloReporter$Keys$.MODULE$.mean_rate(), "%f", BoxesRunTime.boxToDouble((double)this.convertRate(timer.getMeanRate())));
        this.put(m, AccumuloReporter$Keys$.MODULE$.m1_rate(), "%f", BoxesRunTime.boxToDouble((double)this.convertRate(timer.getOneMinuteRate())));
        this.put(m, AccumuloReporter$Keys$.MODULE$.m5_rate(), "%f", BoxesRunTime.boxToDouble((double)this.convertRate(timer.getFiveMinuteRate())));
        this.put(m, AccumuloReporter$Keys$.MODULE$.m15_rate(), "%f", BoxesRunTime.boxToDouble((double)this.convertRate(timer.getFifteenMinuteRate())));
        this.put(m, AccumuloReporter$Keys$.MODULE$.duration_unit(), "%s", this.getDurationUnit());
        this.put(m, AccumuloReporter$Keys$.MODULE$.rate_unit(), "calls/%s", this.getRateUnit());
        return var3_3;
    }

    private void put(Mutation m, Text cf, String format, Object value) {
        Option<ColumnVisibility> option;
        block4: {
            block3: {
                Value v;
                block2: {
                    v = new Value(new StringOps(Predef$.MODULE$.augmentString(format)).formatLocal(this.locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})).getBytes(Charsets.UTF_8));
                    option = this.visibility();
                    if (!None$.MODULE$.equals(option)) break block2;
                    m.put(cf, AccumuloReporter$Keys$.MODULE$.empty(), v);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                ColumnVisibility vis = (ColumnVisibility)some.x();
                m.put(cf, AccumuloReporter$Keys$.MODULE$.empty(), vis, v);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(option);
    }

    private final String timestamp$lzycompute$1(ObjectRef timestamp$lzy$1, VolatileByteRef bitmap$0$1) {
        AccumuloReporter accumuloReporter = this;
        synchronized (accumuloReporter) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                timestamp$lzy$1.elem = ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.clock.getTime()), ZoneOffset.UTC).format(this.timeEncoder());
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (String)timestamp$lzy$1.elem;
        }
    }

    public final String org$locationtech$geomesa$metrics$reporters$AccumuloReporter$$timestamp$1(ObjectRef timestamp$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.timestamp$lzycompute$1(timestamp$lzy$1, bitmap$0$1) : (String)timestamp$lzy$1.elem;
    }

    public AccumuloReporter(MetricRegistry registry, Connector connector, String table, Option<String> visibilities, Clock clock, Locale locale, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit) {
        this.clock = clock;
        this.locale = locale;
        super(registry, "AccumuloReporter", filter, rateUnit, durationUnit);
        if (!connector.tableOperations().exists(table)) {
            try {
                connector.tableOperations().create(table, true, TimeType.LOGICAL);
            }
            catch (TableExistsException tableExistsException) {
                // empty catch block
            }
        }
        this.writer = connector.createBatchWriter(table, new BatchWriterConfig());
        this.timeEncoder = DateTimeFormatter.ofPattern("yyyyMMddHHmmss", Locale.US).withZone(ZoneOffset.UTC);
        this.visibility = visibilities.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ColumnVisibility apply(String x$1) {
                return new ColumnVisibility(x$1);
            }
        });
    }

    public static class Builder {
        private final MetricRegistry registry;
        private Locale locale;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private Clock clock;
        private MetricFilter filter;
        private String table;
        private String visibilities;
        private boolean mock;

        private Locale locale() {
            return this.locale;
        }

        private void locale_$eq(Locale x$1) {
            this.locale = x$1;
        }

        private TimeUnit rateUnit() {
            return this.rateUnit;
        }

        private void rateUnit_$eq(TimeUnit x$1) {
            this.rateUnit = x$1;
        }

        private TimeUnit durationUnit() {
            return this.durationUnit;
        }

        private void durationUnit_$eq(TimeUnit x$1) {
            this.durationUnit = x$1;
        }

        private Clock clock() {
            return this.clock;
        }

        private void clock_$eq(Clock x$1) {
            this.clock = x$1;
        }

        private MetricFilter filter() {
            return this.filter;
        }

        private void filter_$eq(MetricFilter x$1) {
            this.filter = x$1;
        }

        private String table() {
            return this.table;
        }

        private void table_$eq(String x$1) {
            this.table = x$1;
        }

        private String visibilities() {
            return this.visibilities;
        }

        private void visibilities_$eq(String x$1) {
            this.visibilities = x$1;
        }

        private boolean mock() {
            return this.mock;
        }

        private void mock_$eq(boolean x$1) {
            this.mock = x$1;
        }

        public Builder formatFor(Locale locale) {
            this.locale_$eq(locale);
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit_$eq(rateUnit);
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit_$eq(durationUnit);
            return this;
        }

        public Builder withClock(Clock clock) {
            this.clock_$eq(clock);
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter_$eq(filter);
            return this;
        }

        public Builder writeToTable(String table) {
            this.table_$eq(table);
            return this;
        }

        public Builder withVisibilities(String visibilities) {
            this.visibilities_$eq(visibilities);
            return this;
        }

        public Builder mock(boolean mock) {
            this.mock_$eq(mock);
            return this;
        }

        public AccumuloReporter build(String instanceId, String zookeepers, String user, String password) {
            MockInstance instance = this.mock() ? new MockInstance(instanceId) : new ZooKeeperInstance(instanceId, zookeepers);
            Connector connector = instance.getConnector(user, (AuthenticationToken)new PasswordToken((CharSequence)password));
            return new AccumuloReporter(this.registry, connector, this.table(), (Option<String>)Option$.MODULE$.apply((Object)this.visibilities()), this.clock(), this.locale(), this.filter(), this.rateUnit(), this.durationUnit());
        }

        public Builder(MetricRegistry registry) {
            this.registry = registry;
            this.locale = Locale.getDefault();
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.clock = Clock.defaultClock();
            this.filter = MetricFilter.ALL;
            this.table = "metrics";
            this.mock = false;
        }
    }
}

