/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.tube;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Date;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.referencing.GeodeticCalculator;
import org.locationtech.geomesa.features.ScalaSimpleFeatureFactory$;
import org.locationtech.geomesa.process.tube.TubeBuilder$;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.Conversions;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.geotools.converters.FastConverter$;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00055w!\u0002\u0012$\u0011\u0003qc!\u0002\u0019$\u0011\u0003\t\u0004\"\u0002\u001d\u0002\t\u0003I\u0004b\u0002\u001e\u0002\u0005\u0004%\ta\u000f\u0005\u0007\t\u0006\u0001\u000b\u0011\u0002\u001f\u0007\u000bA\u001a\u0013\u0011A#\t\u0011A+!Q1A\u0005\u0002EC\u0001\u0002X\u0003\u0003\u0002\u0003\u0006IA\u0015\u0005\t;\u0016\u0011)\u0019!C\u0001=\"A!-\u0002B\u0001B\u0003%q\f\u0003\u0005d\u000b\t\u0015\r\u0011\"\u0001e\u0011!AWA!A!\u0002\u0013)\u0007\"\u0002\u001d\u0006\t\u0003I\u0007b\u00028\u0006\u0005\u0004%\ta\u001c\u0005\u0007m\u0016\u0001\u000b\u0011\u00029\t\u000f],!\u0019!C\u0001q\"9\u0011qA\u0003!\u0002\u0013I\b\"CA\u0005\u000b\t\u0007I\u0011AA\u0006\u0011!\ti\"\u0002Q\u0001\n\u00055\u0001\u0002CA\u0010\u000b\t\u0007I\u0011A\u001e\t\u000f\u0005\u0005R\u0001)A\u0005y!I\u00111E\u0003C\u0002\u0013\u0005\u0011Q\u0005\u0005\t\u0003s)\u0001\u0015!\u0003\u0002(!I\u00111H\u0003C\u0002\u0013\u0005\u0011Q\b\u0005\t\u0003\u0017*\u0001\u0015!\u0003\u0002@!9\u0011QJ\u0003\u0005\u0002\u0005=\u0003bBA1\u000b\u0011\u0005\u00111\r\u0005\b\u0003g*A\u0011AA;\u0011\u001d\tI(\u0002C\u0001\u0003wBq!a!\u0006\t\u0003\t)\tC\u0004\u0002\u0014\u0016!\t!!&\t\u000f\u0005=V\u0001\"\u0001\u00022\"9\u0011qW\u0003\u0005\u0002\u0005e\u0006bBAe\u000b\u0019\u0005\u00111Z\u0001\f)V\u0014WMQ;jY\u0012,'O\u0003\u0002%K\u0005!A/\u001e2f\u0015\t1s%A\u0004qe>\u001cWm]:\u000b\u0005!J\u0013aB4f_6,7/\u0019\u0006\u0003U-\nA\u0002\\8dCRLwN\u001c;fG\"T\u0011\u0001L\u0001\u0004_J<7\u0001\u0001\t\u0003_\u0005i\u0011a\t\u0002\f)V\u0014WMQ;jY\u0012,'o\u0005\u0002\u0002eA\u00111GN\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0018\u0002\u001f\u0011+g-Y;mi\u0012#xMR5fY\u0012,\u0012\u0001\u0010\t\u0003{\tk\u0011A\u0010\u0006\u0003\u007f\u0001\u000bA\u0001\\1oO*\t\u0011)\u0001\u0003kCZ\f\u0017BA\"?\u0005\u0019\u0019FO]5oO\u0006\u0001B)\u001a4bk2$H\t^4GS\u0016dG\rI\n\u0004\u000bI2\u0005CA$O\u001b\u0005A%BA%K\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tYE*\u0001\u0005usB,7/\u00194f\u0015\u0005i\u0015aA2p[&\u0011q\n\u0013\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-\u0001\u0007uk\n,g)Z1ukJ,7/F\u0001S!\t\u0019&,D\u0001U\u0015\t)f+\u0001\u0004tS6\u0004H.\u001a\u0006\u0003/b\u000bA\u0001Z1uC*\u0011\u0011lK\u0001\tO\u0016|Go\\8mg&\u00111\f\u0016\u0002\u0018'&l\u0007\u000f\\3GK\u0006$XO]3D_2dWm\u0019;j_:\fQ\u0002^;cK\u001a+\u0017\r^;sKN\u0004\u0013A\u00042vM\u001a,'\u000fR5ti\u0006t7-Z\u000b\u0002?B\u00111\u0007Y\u0005\u0003CR\u0012a\u0001R8vE2,\u0017a\u00042vM\u001a,'\u000fR5ti\u0006t7-\u001a\u0011\u0002\u000f5\f\u0007PQ5ogV\tQ\r\u0005\u00024M&\u0011q\r\u000e\u0002\u0004\u0013:$\u0018\u0001C7bq\nKgn\u001d\u0011\u0015\t)\\G.\u001c\t\u0003_\u0015AQ\u0001\u0015\u0007A\u0002ICQ!\u0018\u0007A\u0002}CQa\u0019\u0007A\u0002\u0015\fAaY1mGV\t\u0001\u000f\u0005\u0002ri6\t!O\u0003\u0002t1\u0006Y!/\u001a4fe\u0016t7-\u001b8h\u0013\t)(O\u0001\nHK>$W\r^5d\u0007\u0006d7-\u001e7bi>\u0014\u0018!B2bY\u000e\u0004\u0013\u0001\u00033uO\u001aKW\r\u001c3\u0016\u0003e\u00042A_A\u0002\u001d\tYx\u0010\u0005\u0002}i5\tQP\u0003\u0002\u007f[\u00051AH]8pizJ1!!\u00015\u0003\u0019\u0001&/\u001a3fM&\u00191)!\u0002\u000b\u0007\u0005\u0005A'A\u0005ei\u001e4\u0015.\u001a7eA\u00051q-Z8GC\u000e,\"!!\u0004\u0011\t\u0005=\u0011\u0011D\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u0005!q-Z8n\u0015\r\t9\"K\u0001\u0004UR\u001c\u0018\u0002BA\u000e\u0003#\u0011qbR3p[\u0016$(/\u001f$bGR|'/_\u0001\bO\u0016|g)Y2!\u0003%9UiT'`!J{\u0005+\u0001\u0006H\u000b>ku\f\u0015*P!\u0002\n\u0001\u0002^;cKRK\b/Z\u000b\u0003\u0003O\u0001B!!\u000b\u000265\u0011\u00111\u0006\u0006\u0004+\u00065\"\u0002BA\u0018\u0003c\tqAZ3biV\u0014XMC\u0002\u00024-\nqa\u001c9f]\u001eL7/\u0003\u0003\u00028\u0005-\"!E*j[BdWMR3biV\u0014X\rV=qK\u0006IA/\u001e2f)f\u0004X\rI\u0001\bEVLG\u000eZ3s+\t\ty\u0004\u0005\u0003\u0002B\u0005\u001dSBAA\"\u0015\r)\u0016Q\t\u0006\u0004\u0003_A\u0016\u0002BA%\u0003\u0007\u0012AcU5na2,g)Z1ukJ,')^5mI\u0016\u0014\u0018\u0001\u00032vS2$WM\u001d\u0011\u0002\u000f\u001d,GoR3p[R!\u0011\u0011KA,!\u0011\ty!a\u0015\n\t\u0005U\u0013\u0011\u0003\u0002\t\u000f\u0016|W.\u001a;ss\"9\u0011\u0011L\rA\u0002\u0005m\u0013AA:g!\u0011\tI#!\u0018\n\t\u0005}\u00131\u0006\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\u0002\u0019\u001d,Go\u0015;beR$\u0016.\\3\u0015\t\u0005\u0015\u0014\u0011\u000f\t\u0005\u0003O\ni'\u0004\u0002\u0002j)\u0019\u00111\u000e!\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003_\nIG\u0001\u0003ECR,\u0007bBA-5\u0001\u0007\u00111L\u0001\u000bO\u0016$XI\u001c3US6,G\u0003BA3\u0003oBq!!\u0017\u001c\u0001\u0004\tY&\u0001\u0006ck\u001a4WM]$f_6$b!!\u0015\u0002~\u0005}\u0004bBA\n9\u0001\u0007\u0011\u0011\u000b\u0005\u0007\u0003\u0003c\u0002\u0019A0\u0002\r5,G/\u001a:t\u0003=iW\r^3sgR{G)Z4sK\u0016\u001cH#B0\u0002\b\u0006%\u0005BBAA;\u0001\u0007q\fC\u0004\u0002\fv\u0001\r!!$\u0002\u000bA|\u0017N\u001c;\u0011\t\u0005=\u0011qR\u0005\u0005\u0003#\u000b\tBA\u0003Q_&tG/\u0001\u0004ck\u001a4WM\u001d\u000b\u0007\u0003/\u000bI+!,\u0011\r\u0005e\u00151UA.\u001d\u0011\tY*a(\u000f\u0007q\fi*C\u00016\u0013\r\t\t\u000bN\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)+a*\u0003\u0011%#XM]1u_JT1!!)5\u0011\u001d\tYK\ba\u0001\u0003/\u000bab]5na2,g)Z1ukJ,7\u000f\u0003\u0004\u0002\u0002z\u0001\raX\u0001\niJ\fgn\u001d4pe6$b!a&\u00024\u0006U\u0006\"\u0002) \u0001\u0004\u0011\u0006\"B< \u0001\u0004I\u0018!F7bW\u0016LE\tT*bM\u0016d\u0015N\\3TiJLgn\u001a\u000b\u0007\u0003#\nY,!2\t\u000f\u0005u\u0006\u00051\u0001\u0002@\u00061\u0011N\u001c9viF\u0002B!a\u0004\u0002B&!\u00111YA\t\u0005)\u0019un\u001c:eS:\fG/\u001a\u0005\b\u0003\u000f\u0004\u0003\u0019AA`\u0003\u0019Ig\u000e];ue\u0005Q1M]3bi\u0016$VOY3\u0016\u0005\u0005]\u0005")
public abstract class TubeBuilder
implements LazyLogging {
    private final SimpleFeatureCollection tubeFeatures;
    private final double bufferDistance;
    private final int maxBins;
    private final GeodeticCalculator calc;
    private final String dtgField;
    private final GeometryFactory geoFac;
    private final String GEOM_PROP;
    private final SimpleFeatureType tubeType;
    private final SimpleFeatureBuilder builder;
    private Logger logger;
    private volatile boolean bitmap$0;

    public static String DefaultDtgField() {
        return TubeBuilder$.MODULE$.DefaultDtgField();
    }

    private Logger logger$lzycompute() {
        TubeBuilder tubeBuilder = this;
        synchronized (tubeBuilder) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public SimpleFeatureCollection tubeFeatures() {
        return this.tubeFeatures;
    }

    public double bufferDistance() {
        return this.bufferDistance;
    }

    public int maxBins() {
        return this.maxBins;
    }

    public GeodeticCalculator calc() {
        return this.calc;
    }

    public String dtgField() {
        return this.dtgField;
    }

    public GeometryFactory geoFac() {
        return this.geoFac;
    }

    public String GEOM_PROP() {
        return this.GEOM_PROP;
    }

    public SimpleFeatureType tubeType() {
        return this.tubeType;
    }

    public SimpleFeatureBuilder builder() {
        return this.builder;
    }

    public Geometry getGeom(SimpleFeature sf) {
        return (Geometry)sf.getAttribute(0);
    }

    public Date getStartTime(SimpleFeature sf) {
        return (Date)sf.getAttribute(1);
    }

    public Date getEndTime(SimpleFeature sf) {
        return (Date)sf.getAttribute(2);
    }

    public Geometry bufferGeom(Geometry geom, double meters) {
        return geom.buffer(this.metersToDegrees(meters, Conversions.RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(geom))));
    }

    public double metersToDegrees(double meters, Point point) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(12).append("Buffering: ").append(Double.toString(meters)).append(" ").append(WKTUtils$.MODULE$.write((Geometry)point)).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.calc().setStartingGeographicPoint(point.getX(), point.getY());
        this.calc().setDirection(0.0, meters);
        Point2D dest2D = this.calc().getDestinationGeographicPoint();
        Point destPoint = this.geoFac().createPoint(new Coordinate(dest2D.getX(), dest2D.getY()));
        return point.distance((Geometry)destPoint);
    }

    public Iterator<SimpleFeature> buffer(Iterator<SimpleFeature> simpleFeatures, double meters) {
        return simpleFeatures.map((Function1 & Serializable & scala.Serializable)sf -> {
            Geometry bufferedGeom = this.bufferGeom(this.getGeom((SimpleFeature)sf), meters);
            this.builder().reset();
            this.builder().init(sf);
            this.builder().set(this.GEOM_PROP(), (Object)bufferedGeom);
            return this.builder().buildFeature(sf.getID());
        });
    }

    public Iterator<SimpleFeature> transform(SimpleFeatureCollection tubeFeatures, String dtgField) {
        return SelfClosingIterator$.MODULE$.apply(tubeFeatures.features()).map((Function1 & Serializable & scala.Serializable)sf -> {
            Date date = (Date)FastConverter$.MODULE$.convert(sf.getAttribute(dtgField), Date.class);
            if (date == null) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(83).append("Unable to retrieve date field from input tubeFeatures...ensure there a field named ").append(dtgField).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new IllegalArgumentException(new StringBuilder(85).append("Unable to retrieve date field from input tubeFeatures...ensure there a field named \"").append(dtgField).append("\"").toString());
            }
            this.builder().reset();
            return this.builder().buildFeature(sf.getID(), new Object[]{sf.getDefaultGeometry(), date, null});
        });
    }

    public Geometry makeIDLSafeLineString(Coordinate input1, Coordinate input2) {
        LineString lineString;
        if (GeometryUtils$.MODULE$.crossesIDL(input1, input2)) {
            Tuple2 tuple2;
            double latIntercept = GeometryUtils$.MODULE$.calcIDLIntercept(input1, input2);
            Coordinate p1 = new Coordinate(-180.0, latIntercept);
            Coordinate p2 = new Coordinate(180.0, latIntercept);
            Tuple2 tuple22 = tuple2 = input1.x > 0.0 ? new Tuple2((Object)input1, (Object)input2) : new Tuple2((Object)input2, (Object)input1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Coordinate point1 = (Coordinate)tuple2._1();
            Coordinate point2 = (Coordinate)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)point1, (Object)point2);
            Tuple2 tuple24 = tuple23;
            Coordinate point12 = (Coordinate)tuple24._1();
            Coordinate point22 = (Coordinate)tuple24._2();
            LineString westLine = new LineString((CoordinateSequence)new CoordinateArraySequence((Coordinate[])((Object[])new Coordinate[]{p1, point22})), this.geoFac());
            LineString eastLine = new LineString((CoordinateSequence)new CoordinateArraySequence((Coordinate[])((Object[])new Coordinate[]{point12, p2})), this.geoFac());
            lineString = new MultiLineString((LineString[])((Object[])new LineString[]{westLine, eastLine}), this.geoFac());
        } else {
            lineString = new LineString((CoordinateSequence)new CoordinateArraySequence((Coordinate[])((Object[])new Coordinate[]{input1, input2})), this.geoFac());
        }
        return lineString;
    }

    public abstract Iterator<SimpleFeature> createTube();

    public TubeBuilder(SimpleFeatureCollection tubeFeatures, double bufferDistance, int maxBins) {
        this.tubeFeatures = tubeFeatures;
        this.bufferDistance = bufferDistance;
        this.maxBins = maxBins;
        LazyLogging.$init$((LazyLogging)this);
        this.calc = new GeodeticCalculator();
        this.dtgField = (String)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType((SimpleFeatureType)tubeFeatures.getSchema())).getOrElse((Function0 & Serializable & scala.Serializable)() -> TubeBuilder$.MODULE$.DefaultDtgField());
        this.geoFac = new GeometryFactory();
        this.GEOM_PROP = "geom";
        this.tubeType = SimpleFeatureTypes$.MODULE$.createType("tubeType", new StringBuilder(39).append(this.GEOM_PROP()).append(":Geometry:srid=4326,start:Date,end:Date").toString());
        this.builder = ScalaSimpleFeatureFactory$.MODULE$.featureBuilder(this.tubeType());
    }
}

