/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.analytic;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection$;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.analytic.SamplingVisitor;
import org.opengis.feature.FeatureVisitor;
import org.opengis.util.ProgressListener;
import scala.Option;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@DescribeProcess(title="Sampling Process", description="Uses statistical sampling to reduces the features returned by a query")
@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0002\u0005\u0001=AQA\n\u0001\u0005\u0002\u001dBQA\u000b\u0001\u0005\u0002-\u0012qbU1na2Lgn\u001a)s_\u000e,7o\u001d\u0006\u0003\u000b\u0019\t\u0001\"\u00198bYf$\u0018n\u0019\u0006\u0003\u000f!\tq\u0001\u001d:pG\u0016\u001c8O\u0003\u0002\n\u0015\u00059q-Z8nKN\f'BA\u0006\r\u00031awnY1uS>tG/Z2i\u0015\u0005i\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u00111q\u0001\"!\u0005\f\u000e\u0003IQ!a\u0005\u000b\u0002\t1\fgn\u001a\u0006\u0002+\u0005!!.\u0019<b\u0013\t9\"C\u0001\u0004PE*,7\r\u001e\t\u00033ii\u0011AB\u0005\u00037\u0019\u0011abR3p\u001b\u0016\u001c\u0018\r\u0015:pG\u0016\u001c8\u000f\u0005\u0002\u001eI5\taD\u0003\u0002 A\u0005a1oY1mC2|wmZ5oO*\u0011\u0011EI\u0001\tif\u0004Xm]1gK*\t1%A\u0002d_6L!!\n\u0010\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\u0002\"!\u000b\u0001\u000e\u0003\u0011\tq!\u001a=fGV$X\rF\u0003-m\u0011#v\r\u0005\u0002.i5\taF\u0003\u00020a\u000511/[7qY\u0016T!!\r\u001a\u0002\t\u0011\fG/\u0019\u0006\u0003g1\t\u0001bZ3pi>|Gn]\u0005\u0003k9\u0012qcU5na2,g)Z1ukJ,7i\u001c7mK\u000e$\u0018n\u001c8\t\u000bE\u0012\u0001\u0019\u0001\u0017)\rYBt\bQ!C!\tIT(D\u0001;\u0015\tYD(A\u0004gC\u000e$xN]=\u000b\u0005\u001d\u0011\u0014B\u0001 ;\u0005E!Um]2sS\n,\u0007+\u0019:b[\u0016$XM]\u0001\u0005]\u0006lW-I\u00012\u0003-!Wm]2sSB$\u0018n\u001c8\"\u0003\r\u000ba\"\u00138qkR\u0004c-Z1ukJ,7\u000fC\u0003F\u0005\u0001\u0007a)A\u0007tC6\u0004H.\u001a)fe\u000e,g\u000e\u001e\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0002\u0013\u0006)1oY1mC&\u00111\n\u0013\u0002\u0006\r2|\u0017\r\u001e\u0015\u000b\tbzT*\u0011(Q#J\u001b\u0016%A#\"\u0003=\u000ba\u0006U3sG\u0016tG\u000fI8gA\u0019,\u0017\r^;sKN\u0004Co\u001c\u0011sKR,(O\u001c\u0017!E\u0016$x/Z3oAA\u0002\u0013M\u001c3!c\u0005AQ.\u001b8WC2,X\rI\u0001\u0001\u0003!i\u0017\r\u001f,bYV,\u0007\u0005C q\u0002\u0001\u0001\u0001\u0001\u0001\u0001\t\u000bU\u0013\u0001\u0019\u0001,\u0002\u0011QD'/Z1e\u0005f\u0004\"a\u00160\u000f\u0005ac\u0006CA-I\u001b\u0005Q&BA.\u000f\u0003\u0019a$o\\8u}%\u0011Q\fS\u0001\u0007!J,G-\u001a4\n\u0005}\u0003'AB*ue&twM\u0003\u0002^\u0011\"BA\u000bO c\u0003\u000e,g-I\u0001VC\u0005!\u0017\u0001O!uiJL'-\u001e;fA\u0019LW\r\u001c3!i>\u0004C.\u001b8lA\u0005\u001c8o\\2jCR,G\r\t4fCR,(/Z:!M>\u0014\be]1na2LgnZ\u0001\u0004[&tW$\u0001\u0001\t\u000b!\u0014\u0001\u0019A5\u0002\u000f5|g.\u001b;peB\u0011!n\\\u0007\u0002W*\u0011A.\\\u0001\u0005kRLGN\u0003\u0002o\u0019\u00059q\u000e]3oO&\u001c\u0018B\u00019l\u0005A\u0001&o\\4sKN\u001cH*[:uK:,'\u000f\u000b\u0004\u0003e~*\u0018i\u001e\t\u0003sML!\u0001\u001e\u001e\u0003\u001d\u0011+7o\u0019:jE\u0016\u0014Vm];mi\u0006\na/\u0001\u0004sKN,H\u000e^\u0011\u0002q\u0006yq*\u001e;qkR\u0004c-Z1ukJ,7\u000f\u000b\u0003\u0003u\u0006\r\u0001cA$|{&\u0011A\u0010\u0013\u0002\u0007i\"\u0014xn^:\u0011\u0005y|X\"\u0001\u001f\n\u0007\u0005\u0005AH\u0001\tQe>\u001cWm]:Fq\u000e,\u0007\u000f^5p]\u000e\nQ\u0010\u000b\u0006\u0001\u0003\u000f\ti!a\u0004B\u0003'\u00012!OA\u0005\u0013\r\tYA\u000f\u0002\u0010\t\u0016\u001c8M]5cKB\u0013xnY3tg\u0006)A/\u001b;mK\u0006\u0012\u0011\u0011C\u0001\u0011'\u0006l\u0007\u000f\\5oO\u0002\u0002&o\\2fgN\f#!!\u0006\u0002\u000bV\u001bXm\u001d\u0011ti\u0006$\u0018n\u001d;jG\u0006d\u0007e]1na2Lgn\u001a\u0011u_\u0002\u0012X\rZ;dKN\u0004C\u000f[3!M\u0016\fG/\u001e:fg\u0002\u0012X\r^;s]\u0016$\u0007EY=!C\u0002\nX/\u001a:z\u0001")
public class SamplingProcess
implements GeoMesaProcess,
LazyLogging {
    private Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        SamplingProcess samplingProcess = this;
        synchronized (samplingProcess) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @DescribeResult(name="result", description="Output features")
    public SimpleFeatureCollection execute(@DescribeParameter(name="data", description="Input features") SimpleFeatureCollection data, @DescribeParameter(name="samplePercent", description="Percent of features to return, between 0 and 1", minValue=0.0, maxValue=1.0) float samplePercent, @DescribeParameter(name="threadBy", description="Attribute field to link associated features for sampling", min=0) String threadBy, ProgressListener monitor) throws ProcessException {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Attempting sampling on {}", new Object[]{data.getClass().getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        SamplingVisitor visitor = new SamplingVisitor(data, samplePercent, (Option<String>)Option$.MODULE$.apply((Object)threadBy));
        GeoMesaFeatureCollection$.MODULE$.visit((FeatureCollection)data, (FeatureVisitor)visitor, monitor);
        return visitor.getResult().results();
    }

    public SamplingProcess() {
        LazyLogging.$init$((LazyLogging)this);
    }
}

