/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.analytic;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.List;
import org.geotools.data.Query;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.features.TransformSimpleFeature;
import org.locationtech.geomesa.features.TransformSimpleFeature$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.iterators.StatsScan$;
import org.locationtech.geomesa.index.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.process.FeatureResult;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.Transform;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.Stat$;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.Expression;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001B\n\u0015\u0001}A\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\"A!\u000b\u0001B\u0001B\u0003%1\u000b\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003Y\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u001d\u0019\u0007A1A\u0005\n\u0011DaA\u001c\u0001!\u0002\u0013)\u0007\u0002C8\u0001\u0011\u000b\u0007I\u0011\u00029\t\u0013\u0005\r\u0001\u0001#b\u0001\n\u0013!\u0007BCA\u0003\u0001!\u0015\r\u0011\"\u0003\u0002\b!I\u00111\u0003\u0001\t\u0006\u0004%I\u0001\u001a\u0005\u000b\u0003+\u0001\u0001R1A\u0005\n\u0005]\u0001bCA\u0013\u0001\u0001\u0007\t\u0019!C\u0005\u0003OA1\"!\r\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00024!Y\u0011q\b\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0015\u0011\u001d\t\t\u0005\u0001C!\u0003\u0007Bq!a\u0014\u0001\t\u0003\n\t\u0006C\u0004\u0002T\u0001!\t%!\u0016\u0003\u0019M#\u0018\r^:WSNLGo\u001c:\u000b\u0005U1\u0012\u0001C1oC2LH/[2\u000b\u0005]A\u0012a\u00029s_\u000e,7o\u001d\u0006\u00033i\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\u001c9\u0005aAn\\2bi&|g\u000e^3dQ*\tQ$A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001A!z\u0003CA\u0011'\u001b\u0005\u0011#BA\u0012%\u0003\u0011a\u0017M\\4\u000b\u0003\u0015\nAA[1wC&\u0011qE\t\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005%jS\"\u0001\u0016\u000b\u0005]Y#B\u0001\u0017\u0019\u0003\u0015Ig\u000eZ3y\u0013\tq#FA\u000bHK>lUm]1Qe>\u001cWm]:WSNLGo\u001c:\u0011\u0005A:T\"A\u0019\u000b\u0005I\u001a\u0014\u0001D:dC2\fGn\\4hS:<'B\u0001\u001b6\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u001c\u0002\u0007\r|W.\u0003\u00029c\tYA*\u0019>z\u0019><w-\u001b8h\u0003!1W-\u0019;ve\u0016\u001c\bCA\u001eC\u001b\u0005a$BA\u001f?\u0003\u0019\u0019\u0018.\u001c9mK*\u0011q\bQ\u0001\u0005I\u0006$\u0018M\u0003\u0002B9\u0005Aq-Z8u_>d7/\u0003\u0002Dy\t92+[7qY\u00164U-\u0019;ve\u0016\u001cu\u000e\u001c7fGRLwN\\\u0001\u000bgR\fGo\u0015;sS:<\u0007C\u0001$P\u001d\t9U\n\u0005\u0002I\u00176\t\u0011J\u0003\u0002K=\u00051AH]8pizR\u0011\u0001T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001d.\u000ba\u0001\u0015:fI\u00164\u0017B\u0001)R\u0005\u0019\u0019FO]5oO*\u0011ajS\u0001\u0007K:\u001cw\u000eZ3\u0011\u0005Q+V\"A&\n\u0005Y[%a\u0002\"p_2,\u0017M\\\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\bc\u0001+Z\u000b&\u0011!l\u0013\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bu{\u0006-\u00192\u0011\u0005y\u0003Q\"\u0001\u000b\t\u000be*\u0001\u0019\u0001\u001e\t\u000b\u0011+\u0001\u0019A#\t\u000bI+\u0001\u0019A*\t\u000b]+\u0001\u0019\u0001-\u0002\u000f=\u0014\u0018nZ*giV\tQ\r\u0005\u0002gY6\tqM\u0003\u0002>Q*\u0011\u0011N[\u0001\bM\u0016\fG/\u001e:f\u0015\tYG$A\u0004pa\u0016tw-[:\n\u00055<'!E*j[BdWMR3biV\u0014X\rV=qK\u0006AqN]5h'\u001a$\b%\u0001\u000bue\u0006t7OZ8s[\u0012+g-\u001b8ji&|gn]\u000b\u0002cB\u0019!o\u001e>\u000f\u0005M,hB\u0001%u\u0013\u0005a\u0015B\u0001<L\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001_=\u0003\u0007M+\u0017O\u0003\u0002w\u0017B\u00111p`\u0007\u0002y*\u0011\u0011) \u0006\u0003}b\tQ!\u001e;jYNL1!!\u0001}\u0005%!&/\u00198tM>\u0014X.\u0001\u0007ue\u0006t7OZ8s[N3G/A\u0006ue\u0006t7OZ8s[N3WCAA\u0005!\u0011\tY!a\u0004\u000e\u0005\u00055!BA\u001d\u0019\u0013\u0011\t\t\"!\u0004\u0003-Q\u0013\u0018M\\:g_Jl7+[7qY\u00164U-\u0019;ve\u0016\fqa\u001d;biN3G/\u0001\u0003ti\u0006$XCAA\r!\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010{\u0006)1\u000f^1ug&!\u00111EA\u000f\u0005\u0011\u0019F/\u0019;\u0002\u0015I,7/\u001e7u\u0007\u0006d7-\u0006\u0002\u0002*A!\u00111FA\u0017\u001b\u00051\u0012bAA\u0018-\tia)Z1ukJ,'+Z:vYR\faB]3tk2$8)\u00197d?\u0012*\u0017\u000f\u0006\u0003\u00026\u0005m\u0002c\u0001+\u00028%\u0019\u0011\u0011H&\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003{q\u0011\u0011!a\u0001\u0003S\t1\u0001\u001f\u00132\u0003-\u0011Xm];mi\u000e\u000bGn\u0019\u0011\u0002\u000bYL7/\u001b;\u0015\t\u0005U\u0012Q\t\u0005\u0007SB\u0001\r!a\u0012\u0011\t\u0005%\u00131J\u0007\u0002Q&\u0019\u0011Q\n5\u0003\u000f\u0019+\u0017\r^;sK\u0006Iq-\u001a;SKN,H\u000e\u001e\u000b\u0003\u0003S\tq!\u001a=fGV$X\r\u0006\u0004\u00026\u0005]\u0013\u0011\r\u0005\b\u00033\u0012\u0002\u0019AA.\u0003\u0019\u0019x.\u001e:dKB\u00191(!\u0018\n\u0007\u0005}CHA\nTS6\u0004H.\u001a$fCR,(/Z*pkJ\u001cW\rC\u0004\u0002dI\u0001\r!!\u001a\u0002\u000bE,XM]=\u0011\t\u0005\u001d\u0014\u0011N\u0007\u0002}%\u0019\u00111\u000e \u0003\u000bE+XM]=")
public class StatsVisitor
implements GeoMesaProcessVisitor,
LazyLogging {
    private Seq<Transform> transformDefinitions;
    private SimpleFeatureType transformSft;
    private TransformSimpleFeature transformSf;
    private SimpleFeatureType statSft;
    private Stat stat;
    private final String statString;
    private final boolean encode;
    private final String[] properties;
    private final SimpleFeatureType origSft;
    private FeatureResult resultCalc;
    private Logger logger;
    private volatile byte bitmap$0;

    public List<Expression> getExpressions() {
        return GeoMesaProcessVisitor.getExpressions$((GeoMesaProcessVisitor)this);
    }

    private Logger logger$lzycompute() {
        StatsVisitor statsVisitor = this;
        synchronized (statsVisitor) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.logger$lzycompute() : this.logger;
    }

    private SimpleFeatureType origSft() {
        return this.origSft;
    }

    private Seq<Transform> transformDefinitions$lzycompute() {
        StatsVisitor statsVisitor = this;
        synchronized (statsVisitor) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.transformDefinitions = Transform.Transforms$.MODULE$.apply(this.origSft(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.properties));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.transformDefinitions;
    }

    private Seq<Transform> transformDefinitions() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.transformDefinitions$lzycompute() : this.transformDefinitions;
    }

    private SimpleFeatureType transformSft$lzycompute() {
        StatsVisitor statsVisitor = this;
        synchronized (statsVisitor) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.transformSft = Transform.Transforms$.MODULE$.schema(this.origSft(), this.transformDefinitions());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.transformSft;
    }

    private SimpleFeatureType transformSft() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.transformSft$lzycompute() : this.transformSft;
    }

    private TransformSimpleFeature transformSf$lzycompute() {
        StatsVisitor statsVisitor = this;
        synchronized (statsVisitor) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.transformSf = TransformSimpleFeature$.MODULE$.apply(this.transformSft(), this.transformDefinitions());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.transformSf;
    }

    private TransformSimpleFeature transformSf() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.transformSf$lzycompute() : this.transformSf;
    }

    private SimpleFeatureType statSft$lzycompute() {
        StatsVisitor statsVisitor = this;
        synchronized (statsVisitor) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.statSft = this.properties == null ? this.origSft() : this.transformSft();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.statSft;
    }

    private SimpleFeatureType statSft() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.statSft$lzycompute() : this.statSft;
    }

    private Stat stat$lzycompute() {
        StatsVisitor statsVisitor = this;
        synchronized (statsVisitor) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.stat = Stat$.MODULE$.apply(this.statSft(), this.statString);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.stat;
    }

    private Stat stat() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.stat$lzycompute() : this.stat;
    }

    private FeatureResult resultCalc() {
        return this.resultCalc;
    }

    private void resultCalc_$eq(FeatureResult x$1) {
        this.resultCalc = x$1;
    }

    public void visit(Feature feature) {
        SimpleFeature sf = (SimpleFeature)feature;
        if (this.properties != null) {
            this.transformSf().setFeature(sf);
            this.stat().observe((SimpleFeature)this.transformSf());
        } else {
            this.stat().observe(sf);
        }
    }

    public FeatureResult getResult() {
        FeatureResult featureResult;
        if (this.resultCalc() != null) {
            featureResult = this.resultCalc();
        } else {
            String stats = this.encode ? (String)StatsScan$.MODULE$.encodeStat(this.statSft()).apply((Object)this.stat()) : this.stat().toJson();
            ScalaSimpleFeature sf = new ScalaSimpleFeature(StatsScan$.MODULE$.StatsSft(), "", new Object[]{stats, GeometryUtils$.MODULE$.zeroPoint()}, ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4());
            ListFeatureCollection manualVisitResults = new ListFeatureCollection(StatsScan$.MODULE$.StatsSft());
            manualVisitResults.add((SimpleFeature)sf);
            featureResult = new FeatureResult((SimpleFeatureCollection)manualVisitResults);
        }
        return featureResult;
    }

    public void execute(SimpleFeatureSource source, Query query) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Running Geomesa stats iterator process on source type {}", new Object[]{source.getClass().getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (this.properties != null) {
            BoxedUnit boxedUnit2;
            List list = query.getProperties();
            List list2 = Query.ALL_PROPERTIES;
            if (list == null ? list2 != null : !((Object)list).equals(list2)) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringBuilder(67).append("Overriding inner query's properties (").append(query.getProperties()).append(") ").append("with properties/transforms ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.properties)).mkString(",")).append(".").toString());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            query.setPropertyNames(this.properties);
        }
        query.getHints().put((Object)QueryHints$.MODULE$.STATS_STRING(), (Object)this.statString);
        query.getHints().put((Object)QueryHints$.MODULE$.ENCODE_STATS(), (Object)new Boolean(this.encode));
        this.resultCalc_$eq(new FeatureResult(source.getFeatures(query)));
    }

    public StatsVisitor(SimpleFeatureCollection features, String statString, boolean encode, String[] properties) {
        this.statString = statString;
        this.encode = encode;
        this.properties = properties;
        GeoMesaProcessVisitor.$init$((GeoMesaProcessVisitor)this);
        LazyLogging.$init$((LazyLogging)this);
        this.origSft = (SimpleFeatureType)features.getSchema();
    }
}

