/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.analytic;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection$;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.analytic.AttributeVisitor;
import org.locationtech.geomesa.process.analytic.UniqueProcess$;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import org.opengis.util.ProgressListener;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DescribeProcess(title="Geomesa Unique", description="Finds unique attributes values, optimized for GeoMesa")
@ScalaSignature(bytes="\u0006\u0001\u0005%g\u0001\u0002\b\u0010\u0001iAQ!\r\u0001\u0005\u0002IBQ!\u000e\u0001\u0005\u0002Y:q!!\u0011\u0010\u0011\u0003\t\u0019E\u0002\u0004\u000f\u001f!\u0005\u0011Q\t\u0005\u0007c\u0011!\t!a\u0014\t\u0013\u0005ECA1A\u0005\u0002\u0005M\u0003\u0002CA-\t\u0001\u0006I!!\u0016\t\u0013\u0005mCA1A\u0005\u0002\u0005M\u0003\u0002CA/\t\u0001\u0006I!!\u0016\t\u0013\u0005}CA1A\u0005\u0002\u0005M\u0003\u0002CA1\t\u0001\u0006I!!\u0016\t\u000f\u0005\rD\u0001\"\u0001\u0002f!9\u0011\u0011\u0016\u0003\u0005\u0002\u0005-&!D+oSF,X\r\u0015:pG\u0016\u001c8O\u0003\u0002\u0011#\u0005A\u0011M\\1msRL7M\u0003\u0002\u0013'\u00059\u0001O]8dKN\u001c(B\u0001\u000b\u0016\u0003\u001d9Wm\\7fg\u0006T!AF\f\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003a\t1a\u001c:h\u0007\u0001\u0019B\u0001A\u000e$OA\u0011A$I\u0007\u0002;)\u0011adH\u0001\u0005Y\u0006twMC\u0001!\u0003\u0011Q\u0017M^1\n\u0005\tj\"AB(cU\u0016\u001cG\u000f\u0005\u0002%K5\t\u0011#\u0003\u0002'#\tqq)Z8NKN\f\u0007K]8dKN\u001c\bC\u0001\u00150\u001b\u0005I#B\u0001\u0016,\u00031\u00198-\u00197bY><w-\u001b8h\u0015\taS&\u0001\u0005usB,7/\u00194f\u0015\u0005q\u0013aA2p[&\u0011\u0001'\u000b\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002gA\u0011A\u0007A\u0007\u0002\u001f\u00059Q\r_3dkR,GCC\u001cB!\u000e\u001480a\u0001\u0002\u0010A\u0011\u0001hP\u0007\u0002s)\u0011!hO\u0001\u0007g&l\u0007\u000f\\3\u000b\u0005qj\u0014\u0001\u00023bi\u0006T!AP\f\u0002\u0011\u001d,w\u000e^8pYNL!\u0001Q\u001d\u0003/MKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0007>dG.Z2uS>t\u0007\"\u0002\"\u0003\u0001\u00049\u0014\u0001\u00034fCR,(/Z:)\r\u0005#5\nT'O!\t)\u0015*D\u0001G\u0015\t9\u0005*A\u0004gC\u000e$xN]=\u000b\u0005Ii\u0014B\u0001&G\u0005E!Um]2sS\n,\u0007+\u0019:b[\u0016$XM]\u0001\u0005]\u0006lW-I\u0001C\u0003-!Wm]2sSB$\u0018n\u001c8\"\u0003=\u000b\u0001$\u00138qkR\u0004c-Z1ukJ,\u0007eY8mY\u0016\u001cG/[8o\u0011\u0015\t&\u00011\u0001S\u0003%\tG\u000f\u001e:jEV$X\r\u0005\u0002T9:\u0011AK\u0017\t\u0003+bk\u0011A\u0016\u0006\u0003/f\ta\u0001\u0010:p_Rt$\"A-\u0002\u000bM\u001c\u0017\r\\1\n\u0005mC\u0016A\u0002)sK\u0012,g-\u0003\u0002^=\n11\u000b\u001e:j]\u001eT!a\u0017-)\rA#5\nY'bC\u0005\t\u0016%\u00012\u0002W\u0005#HO]5ckR,\u0007e\u001e5pg\u0016\u0004SO\\5rk\u0016\u0004c/\u00197vKN\u0004\u0013M]3!Kb$(/Y2uK\u0012DQ\u0001\u001a\u0002A\u0002\u0015\faAZ5mi\u0016\u0014\bC\u00014k\u001b\u00059'B\u00013i\u0015\tIw#A\u0004pa\u0016tw-[:\n\u0005-<'A\u0002$jYR,'\u000f\u000b\u0005d\t.kgn\\'qC\u0005!\u0017aA7j]v\t\u0001!I\u0001r\u00035\"\u0006.\u001a\u0011gS2$XM\u001d\u0011u_\u0002\n\u0007\u000f\u001d7zAQ|\u0007\u0005\u001e5fA\u0019,\u0017\r^;sK\u0002\u001aw\u000e\u001c7fGRLwN\u001c\u0005\u0006g\n\u0001\r\u0001^\u0001\nQ&\u001cHo\\4sC6\u0004\"\u0001H;\n\u0005Yl\"a\u0002\"p_2,\u0017M\u001c\u0015\te\u0012[\u0005P\\8Ns\u0006\n1/I\u0001{\u0003\u0019\u001a%/Z1uK\u0002\n\u0007\u0005[5ti><'/Y7!_\u001a\u0004\u0013\r\u001e;sS\n,H/\u001a\u0011wC2,Xm\u001d\u0005\u0006y\n\u0001\rAU\u0001\u0005g>\u0014H\u000f\u000b\u0005|\t.shn\\'\u0000C\u0005a\u0018EAA\u0001\u0003!\u001avN\u001d;!e\u0016\u001cX\u000f\u001c;tA5\u0002\u0013\r\u001c7po\u0016$\u0007\u0005^8!E\u0016\u0004\u0013iU\"!_J\u0004C)R*D\u0011\u0019\t)A\u0001a\u0001i\u0006Y1o\u001c:u\u0005f\u001cu.\u001e8uQ-\t\u0019\u0001R&\u0002\n9|W*a\u0003\"\u0005\u0005\u0015\u0011EAA\u0007\u0003Q\u001avN\u001d;!Ef\u0004\u0003.[:u_\u001e\u0014\u0018-\u001c\u0011d_VtGo\u001d\u0011j]N$X-\u00193!_\u001a\u0004\u0013\r\u001e;sS\n,H/\u001a\u0011wC2,Xm\u001d\u0005\b\u0003#\u0011\u0001\u0019AA\n\u0003A\u0001(o\\4sKN\u001cH*[:uK:,'\u000f\u0005\u0003\u0002\u0016\u0005mQBAA\f\u0015\r\tI\u0002[\u0001\u0005kRLG.\u0003\u0003\u0002\u001e\u0005]!\u0001\u0005)s_\u001e\u0014Xm]:MSN$XM\\3sQ%\u0011\u0011\u0011E&\u0002(5\u000bY\u0003E\u0002F\u0003GI1!!\nG\u00059!Um]2sS\n,'+Z:vYR\f#!!\u000b\u0002\rI,7/\u001e7uC\t\ti#A!GK\u0006$XO]3!G>dG.Z2uS>t\u0007e^5uQ\u0002\ng\u000eI1uiJL'-\u001e;fA\r|g\u000e^1j]&tw\r\t;iK\u0002*h.[9vK\u00022\u0018\r\\;fg\"R\u0001!!\r\u00028\u0005eR*!\u0010\u0011\u0007\u0015\u000b\u0019$C\u0002\u00026\u0019\u0013q\u0002R3tGJL'-\u001a)s_\u000e,7o]\u0001\u0006i&$H.Z\u0011\u0003\u0003w\tabR3p[\u0016\u001c\u0018\rI+oSF,X-\t\u0002\u0002@\u0005)d)\u001b8eg\u0002*h.[9vK\u0002\nG\u000f\u001e:jEV$Xm\u001d\u0011wC2,Xm\u001d\u0017!_B$\u0018.\\5{K\u0012\u0004cm\u001c:!\u000f\u0016|W*Z:b\u00035)f.[9vKB\u0013xnY3tgB\u0011A\u0007B\n\u0004\t\u0005\u001d\u0003\u0003BA%\u0003\u0017j\u0011\u0001W\u0005\u0004\u0003\u001bB&AB!osJ+g\r\u0006\u0002\u0002D\u000591K\u001a;OC6,WCAA+!\ra\u0012qK\u0005\u0003;v\t\u0001b\u00154u\u001d\u0006lW\rI\u0001\u000f\u0003R$(/\u001b2vi\u00164\u0016\r\\;f\u0003=\tE\u000f\u001e:jEV$XMV1mk\u0016\u0004\u0013AD!uiJL'-\u001e;f\u0007>,h\u000e^\u0001\u0010\u0003R$(/\u001b2vi\u0016\u001cu.\u001e8uA\u000512M]3bi\u0016\u0014V\r^;s]\u000e{G\u000e\\3di&|g\u000eF\u00068\u0003O\ni(!'\u0002 \u0006\u001d\u0006bBA5\u0019\u0001\u0007\u00111N\u0001\rk:L\u0017/^3WC2,Xm\u001d\t\b'\u00065\u0014\u0011OA<\u0013\r\tyG\u0018\u0002\u0004\u001b\u0006\u0004\b\u0003BA%\u0003gJ1!!\u001eY\u0005\r\te.\u001f\t\u0005\u0003\u0013\nI(C\u0002\u0002|a\u0013A\u0001T8oO\"9\u0011q\u0010\u0007A\u0002\u0005\u0005\u0015a\u00022j]\u0012Lgn\u001a\u0019\u0005\u0003\u0007\u000bi\tE\u0003T\u0003\u000b\u000bI)C\u0002\u0002\bz\u0013Qa\u00117bgN\u0004B!a#\u0002\u000e2\u0001A\u0001DAH\u0003{\n\t\u0011!A\u0003\u0002\u0005E%aA0%cE!\u00111SA9!\u0011\tI%!&\n\u0007\u0005]\u0005LA\u0004O_RD\u0017N\\4\t\rMd\u0001\u0019AAN!\u0011\tI%!(\n\u0005YD\u0006B\u0002?\r\u0001\u0004\t\t\u000bE\u0003\u0002J\u0005\r&+C\u0002\u0002&b\u0013aa\u00149uS>t\u0007bBA\u0003\u0019\u0001\u0007\u00111T\u0001\u0010GJ,\u0017\r^3V]&\fX/Z*giR1\u0011QVA^\u0003\u000f\u0004B!a,\u000286\u0011\u0011\u0011\u0017\u0006\u0004u\u0005M&bAA[Q\u00069a-Z1ukJ,\u0017\u0002BA]\u0003c\u0013\u0011cU5na2,g)Z1ukJ,G+\u001f9f\u0011\u001d\ty(\u0004a\u0001\u0003{\u0003D!a0\u0002DB)1+!\"\u0002BB!\u00111RAb\t1\t)-a/\u0002\u0002\u0003\u0005)\u0011AAI\u0005\ryFE\r\u0005\u0007g6\u0001\r!a'")
public class UniqueProcess
implements GeoMesaProcess,
LazyLogging {
    private Logger logger;
    private volatile boolean bitmap$0;

    public static SimpleFeatureType createUniqueSft(Class<?> clazz, boolean bl) {
        return UniqueProcess$.MODULE$.createUniqueSft(clazz, bl);
    }

    public static SimpleFeatureCollection createReturnCollection(Map<Object, Object> map, Class<?> clazz, boolean bl, Option<String> option, boolean bl2) {
        return UniqueProcess$.MODULE$.createReturnCollection(map, clazz, bl, option, bl2);
    }

    public static String AttributeCount() {
        return UniqueProcess$.MODULE$.AttributeCount();
    }

    public static String AttributeValue() {
        return UniqueProcess$.MODULE$.AttributeValue();
    }

    public static String SftName() {
        return UniqueProcess$.MODULE$.SftName();
    }

    private Logger logger$lzycompute() {
        UniqueProcess uniqueProcess = this;
        synchronized (uniqueProcess) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @DescribeResult(name="result", description="Feature collection with an attribute containing the unique values")
    public SimpleFeatureCollection execute(@DescribeParameter(name="features", description="Input feature collection") SimpleFeatureCollection features, @DescribeParameter(name="attribute", description="Attribute whose unique values are extracted") String attribute, @DescribeParameter(name="filter", min=0, description="The filter to apply to the feature collection") Filter filter, @DescribeParameter(name="histogram", min=0, description="Create a histogram of attribute values") Boolean histogram, @DescribeParameter(name="sort", min=0, description="Sort results - allowed to be ASC or DESC") String sort, @DescribeParameter(name="sortByCount", min=0, description="Sort by histogram counts instead of attribute values") Boolean sortByCount, ProgressListener progressListener) {
        AttributeDescriptor attributeDescriptor = (AttributeDescriptor)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((SimpleFeatureType)features.getSchema()).getAttributeDescriptors()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)UniqueProcess.$anonfun$execute$1(attribute, x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(44).append("Attribute ").append(attribute).append(" does not exist in feature schema.").toString());
        });
        boolean hist = Option$.MODULE$.apply((Object)histogram).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2));
        boolean sortBy = Option$.MODULE$.apply((Object)sortByCount).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3));
        AttributeVisitor visitor = new AttributeVisitor(features, attributeDescriptor, (Option<Filter>)Option$.MODULE$.apply((Object)filter).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)UniqueProcess.$anonfun$execute$5(x$4))), hist);
        GeoMesaFeatureCollection$.MODULE$.visit((FeatureCollection)features, (FeatureVisitor)visitor, progressListener);
        Map<Object, Object> uniqueValues = visitor.getResult().attributes();
        Class binding = attributeDescriptor.getType().getBinding();
        return UniqueProcess$.MODULE$.createReturnCollection(uniqueValues, binding, hist, (Option<String>)Option$.MODULE$.apply((Object)sort), sortBy);
    }

    public static final /* synthetic */ boolean $anonfun$execute$1(String attribute$1, AttributeDescriptor x$1) {
        String string = x$1.getLocalName();
        String string2 = attribute$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$execute$5(Filter x$4) {
        Filter filter = x$4;
        IncludeFilter includeFilter = Filter.INCLUDE;
        return filter == null ? includeFilter != null : !filter.equals(includeFilter);
    }

    public UniqueProcess() {
        LazyLogging.$init$((LazyLogging)this);
    }
}

