/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.transform;

import java.io.Serializable;
import java.time.Duration;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Date;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.date.DateUtils$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@DescribeProcess(title="Date Offset Process", description="Modifies the specified date field in a feature collection by an input time period.")
@ScalaSignature(bytes="\u0006\u0001=4Aa\u0001\u0003\u0001\u001f!)A\u0004\u0001C\u0001;!)\u0001\u0005\u0001C\u0001C\t\tB)\u0019;f\u001f\u001a47/\u001a;Qe>\u001cWm]:\u000b\u0005\u00151\u0011!\u0003;sC:\u001chm\u001c:n\u0015\t9\u0001\"A\u0004qe>\u001cWm]:\u000b\u0005%Q\u0011aB4f_6,7/\u0019\u0006\u0003\u00171\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001AA\u0002CA\t\u0017\u001b\u0005\u0011\"BA\n\u0015\u0003\u0011a\u0017M\\4\u000b\u0003U\tAA[1wC&\u0011qC\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005eQR\"\u0001\u0004\n\u0005m1!AD$f_6+7/\u0019)s_\u000e,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\u0001\"a\b\u0001\u000e\u0003\u0011\tq!\u001a=fGV$X\r\u0006\u0003#Ymr\u0005CA\u0012+\u001b\u0005!#BA\u0013'\u0003\u0019\u0019\u0018.\u001c9mK*\u0011q\u0005K\u0001\u0005I\u0006$\u0018M\u0003\u0002*\u0019\u0005Aq-Z8u_>d7/\u0003\u0002,I\t92+[7qY\u00164U-\u0019;ve\u0016\u001cu\u000e\u001c7fGRLwN\u001c\u0005\u0006[\t\u0001\rAI\u0001\f_\n\u001ch)Z1ukJ,7\u000f\u000b\u0004-_Y:\u0004(\u000f\t\u0003aQj\u0011!\r\u0006\u0003eM\nqAZ1di>\u0014\u0018P\u0003\u0002\bQ%\u0011Q'\r\u0002\u0012\t\u0016\u001c8M]5cKB\u000b'/Y7fi\u0016\u0014\u0018\u0001\u00028b[\u0016\f\u0013aJ\u0001\fI\u0016\u001c8M]5qi&|g.I\u0001;\u00039Ie\u000e];uA\u0019,\u0017\r^;sKNDQ\u0001\u0010\u0002A\u0002u\n\u0011\u0002Z1uK\u001aKW\r\u001c3\u0011\u0005y:eBA F!\t\u00015)D\u0001B\u0015\t\u0011e\"\u0001\u0004=e>|GO\u0010\u0006\u0002\t\u0006)1oY1mC&\u0011aiQ\u0001\u0007!J,G-\u001a4\n\u0005!K%AB*ue&twM\u0003\u0002G\u0007\"21h\f\u001cLq1\u000b\u0013\u0001P\u0011\u0002\u001b\u0006aB\u000b[3!I\u0006$X\rI1uiJL'-\u001e;fAQ|\u0007%\\8eS\u001aL\b\"B(\u0003\u0001\u0004i\u0014A\u0003;j[\u0016|eMZ:fi\"2aj\f\u001cRqI\u000b\u0013aT\u0011\u0002'\u00061B+[7fA=4gm]3uA!*gf\u001a\u0018!!F\"\u0015\u0006\u000b\u0004\u0003+ZB\u0006H\u0017\t\u0003aYK!aV\u0019\u0003\u001d\u0011+7o\u0019:jE\u0016\u0014Vm];mi\u0006\n\u0011,\u0001\u0004sKN,H\u000e^\u0011\u00027\u0006\tr*\u001e;qkR\u00043m\u001c7mK\u000e$\u0018n\u001c8)\u0007\tiV\rE\u0002_?\u0006l\u0011aQ\u0005\u0003A\u000e\u0013a\u0001\u001e5s_^\u001c\bC\u00012d\u001b\u0005\u0019\u0014B\u000134\u0005A\u0001&o\\2fgN,\u0005pY3qi&|gnI\u0001bQ\u0019\u0001qM[69[B\u0011\u0001\u0007[\u0005\u0003SF\u0012q\u0002R3tGJL'-\u001a)s_\u000e,7o]\u0001\u0006i&$H.Z\u0011\u0002Y\u0006\u0019B)\u0019;fA=3gm]3uAA\u0013xnY3tg\u0006\na.\u0001*N_\u0012Lg-[3tAQDW\rI:qK\u000eLg-[3eA\u0011\fG/\u001a\u0011gS\u0016dG\rI5oA\u0005\u0004c-Z1ukJ,\u0007eY8mY\u0016\u001cG/[8oA\tL\b%\u00198!S:\u0004X\u000f\u001e\u0011uS6,\u0007\u0005]3sS>$g\u0006")
public class DateOffsetProcess
implements GeoMesaProcess {
    @DescribeResult(name="result", description="Output collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="data", description="Input features") SimpleFeatureCollection obsFeatures, @DescribeParameter(name="dateField", description="The date attribute to modify") String dateField, @DescribeParameter(name="timeOffset", description="Time offset (e.g. P1D)") String timeOffset) throws ProcessException {
        Duration duration;
        try {
            duration = Duration.parse(timeOffset);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(new StringBuilder(15).append("Invalid offset ").append(timeOffset).toString(), e);
        }
        Duration period = duration;
        int dtgIndex = ((SimpleFeatureType)obsFeatures.getSchema()).indexOf(dateField);
        Predef$.MODULE$.require(dtgIndex != -1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Field '").append(dateField).append("' does not exist in input feature collection: ").append(obsFeatures.getSchema()).toString());
        CloseableIterator iter = SelfClosingIterator$.MODULE$.apply(obsFeatures.features()).map((Function1 & Serializable & scala.Serializable)sf -> {
            Date dtg = (Date)sf.getAttribute(dateField);
            ZonedDateTime offset = ZonedDateTime.ofInstant(DateUtils$.MODULE$.toInstant(dtg), ZoneOffset.UTC).plus(period);
            Date newDtg = Date.from(offset.toInstant());
            sf.setAttribute(dtgIndex, (Object)newDtg);
            return sf;
        });
        return new ListFeatureCollection((SimpleFeatureType)obsFeatures.getSchema(), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)iter.toList()));
    }
}

