/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.transform;

import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.transform.HashAttribute;
import scala.reflect.ScalaSignature;

@DescribeProcess(title="Hash Attribute Color Process", description="Adds an attribute to each SimpleFeature that hashes the configured attribute modulo the configured param and emits a color")
@ScalaSignature(bytes="\u0006\u0001\r4AAB\u0004\u0001%!)1\u0005\u0001C\u0001I!9a\u0005\u0001b\u0001\n\u00039\u0003BB\u001d\u0001A\u0003%\u0001\u0006C\u0003;\u0001\u0011\u00053\bC\u0003E\u0001\u0011\u0005SIA\rICND\u0017\t\u001e;sS\n,H/Z\"pY>\u0014\bK]8dKN\u001c(B\u0001\u0005\n\u0003%!(/\u00198tM>\u0014XN\u0003\u0002\u000b\u0017\u00059\u0001O]8dKN\u001c(B\u0001\u0007\u000e\u0003\u001d9Wm\\7fg\u0006T!AD\b\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003A\t1a\u001c:h\u0007\u0001\u0019B\u0001A\n\u001c?A\u0011A#G\u0007\u0002+)\u0011acF\u0001\u0005Y\u0006twMC\u0001\u0019\u0003\u0011Q\u0017M^1\n\u0005i)\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001d;5\t\u0011\"\u0003\u0002\u001f\u0013\tqq)Z8NKN\f\u0007K]8dKN\u001c\bC\u0001\u0011\"\u001b\u00059\u0011B\u0001\u0012\b\u00055A\u0015m\u001d5BiR\u0014\u0018NY;uK\u00061A(\u001b8jiz\"\u0012!\n\t\u0003A\u0001\taaY8m_J\u001cX#\u0001\u0015\u0011\u0007%bc&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\u0015\t%O]1z!\tycG\u0004\u00021iA\u0011\u0011GK\u0007\u0002e)\u00111'E\u0001\u0007yI|w\u000e\u001e \n\u0005UR\u0013A\u0002)sK\u0012,g-\u0003\u00028q\t11\u000b\u001e:j]\u001eT!!\u000e\u0016\u0002\u000f\r|Gn\u001c:tA\u0005iAO]1og\u001a|'/\u001c%bg\"$\"\u0001P \u0011\u0005%j\u0014B\u0001 +\u0005\u0019\te.\u001f*fM\")\u0001\t\u0002a\u0001\u0003\u0006!\u0001.Y:i!\tI#)\u0003\u0002DU\t\u0019\u0011J\u001c;\u0002\u0015\u0005,x-\\3oiN3G\u000f\u0006\u0002G\u0013B\u0011\u0011fR\u0005\u0003\u0011*\u0012A!\u00168ji\")!*\u0002a\u0001\u0017\u0006Q1O\u001a;Ck&dG-\u001a:\u0011\u00051\u001bV\"A'\u000b\u00059{\u0015AB:j[BdWM\u0003\u0002Q#\u00069a-Z1ukJ,'B\u0001*\u0010\u0003!9Wm\u001c;p_2\u001c\u0018B\u0001+N\u0005a\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/\u001a\"vS2$WM\u001d\u0015\u0007\u0001Ykf\fY1\u0011\u0005][V\"\u0001-\u000b\u0005eS\u0016a\u00024bGR|'/\u001f\u0006\u0003\u0015EK!\u0001\u0018-\u0003\u001f\u0011+7o\u0019:jE\u0016\u0004&o\\2fgN\fQ\u0001^5uY\u0016\f\u0013aX\u0001\u001d\u0011\u0006\u001c\b\u000eI!uiJL'-\u001e;fA\r{Gn\u001c:!!J|7-Z:t\u0003-!Wm]2sSB$\u0018n\u001c8\"\u0003\t\f!0\u00113eg\u0002\ng\u000eI1uiJL'-\u001e;fAQ|\u0007%Z1dQ\u0002\u001a\u0016.\u001c9mK\u001a+\u0017\r^;sK\u0002\"\b.\u0019;!Q\u0006\u001c\b.Z:!i\",\u0007eY8oM&<WO]3eA\u0005$HO]5ckR,\u0007%\\8ek2|\u0007\u0005\u001e5fA\r|gNZ5hkJ,G\r\t9be\u0006l\u0007%\u00198eA\u0015l\u0017\u000e^:!C\u0002\u001aw\u000e\\8s\u0001")
public class HashAttributeColorProcess
implements GeoMesaProcess,
HashAttribute {
    private final String[] colors;

    @Override
    @DescribeResult(name="result", description="Output collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="data", description="Input features") SimpleFeatureCollection obsFeatures, @DescribeParameter(name="attribute", description="The attribute to hash on") String attribute, @DescribeParameter(name="modulo", description="The divisor") Integer modulo) throws ProcessException {
        return HashAttribute.execute$(this, obsFeatures, attribute, modulo);
    }

    public String[] colors() {
        return this.colors;
    }

    @Override
    public Object transformHash(int hash) {
        return this.colors()[hash % this.colors().length];
    }

    @Override
    public void augmentSft(SimpleFeatureTypeBuilder sftBuilder) {
        sftBuilder.add("hash", String.class);
    }

    public HashAttributeColorProcess() {
        HashAttribute.$init$(this);
        this.colors = (String[])((Object[])new String[]{"#6495ED", "#B0C4DE", "#00FFFF", "#9ACD32", "#00FA9A", "#FFF8DC", "#F5DEB3"});
    }
}

